(function(FileViewer){"use strict";var define=FileViewer.define,require=FileViewer.require,self=self||{},THREE={REVISION:"76"};"function"==typeof define&&define.amd?define("three",THREE):"undefined"!=typeof exports&&"undefined"!=typeof module&&(module.exports=THREE),void 0===Number.EPSILON&&(Number.EPSILON=Math.pow(2,-52)),void 0===Math.sign&&(Math.sign=function(x){return 0>x?-1:x>0?1:+x}),void 0===Function.prototype.name&&void 0!==Object.defineProperty&&Object.defineProperty(Function.prototype,"name",{get:function(){return this.toString().match(/^\s*function\s*(\S*)\s*\(/)[1]}}),void 0===Object.assign&&Object.defineProperty(Object,"assign",{writable:!0,configurable:!0,value:function(target){if(void 0===target||null===target)throw new TypeError("Cannot convert first argument to object");for(var to=Object(target),i=1,n=arguments.length;i!==n;++i){var nextSource=arguments[i];if(void 0!==nextSource&&null!==nextSource){nextSource=Object(nextSource);for(var keysArray=Object.keys(nextSource),nextIndex=0,len=keysArray.length;nextIndex!==len;++nextIndex){var nextKey=keysArray[nextIndex],desc=Object.getOwnPropertyDescriptor(nextSource,nextKey);void 0!==desc&&desc.enumerable&&(to[nextKey]=nextSource[nextKey])}}}return to}}),THREE.MOUSE={LEFT:0,MIDDLE:1,RIGHT:2},THREE.CullFaceNone=0,THREE.CullFaceBack=1,THREE.CullFaceFront=2,THREE.CullFaceFrontBack=3,THREE.FrontFaceDirectionCW=0,THREE.FrontFaceDirectionCCW=1,THREE.BasicShadowMap=0,THREE.PCFShadowMap=1,THREE.PCFSoftShadowMap=2,THREE.FrontSide=0,THREE.BackSide=1,THREE.DoubleSide=2,THREE.FlatShading=1,THREE.SmoothShading=2,THREE.NoColors=0,THREE.FaceColors=1,THREE.VertexColors=2,THREE.NoBlending=0,THREE.NormalBlending=1,THREE.AdditiveBlending=2,THREE.SubtractiveBlending=3,THREE.MultiplyBlending=4,THREE.CustomBlending=5,THREE.AddEquation=100,THREE.SubtractEquation=101,THREE.ReverseSubtractEquation=102,THREE.MinEquation=103,THREE.MaxEquation=104,THREE.ZeroFactor=200,THREE.OneFactor=201,THREE.SrcColorFactor=202,THREE.OneMinusSrcColorFactor=203,THREE.SrcAlphaFactor=204,THREE.OneMinusSrcAlphaFactor=205,THREE.DstAlphaFactor=206,THREE.OneMinusDstAlphaFactor=207,THREE.DstColorFactor=208,THREE.OneMinusDstColorFactor=209,THREE.SrcAlphaSaturateFactor=210,THREE.NeverDepth=0,THREE.AlwaysDepth=1,THREE.LessDepth=2,THREE.LessEqualDepth=3,THREE.EqualDepth=4,THREE.GreaterEqualDepth=5,THREE.GreaterDepth=6,THREE.NotEqualDepth=7,THREE.MultiplyOperation=0,THREE.MixOperation=1,THREE.AddOperation=2,THREE.NoToneMapping=0,THREE.LinearToneMapping=1,THREE.ReinhardToneMapping=2,THREE.Uncharted2ToneMapping=3,THREE.CineonToneMapping=4,THREE.UVMapping=300,THREE.CubeReflectionMapping=301,THREE.CubeRefractionMapping=302,THREE.EquirectangularReflectionMapping=303,THREE.EquirectangularRefractionMapping=304,THREE.SphericalReflectionMapping=305,THREE.CubeUVReflectionMapping=306,THREE.CubeUVRefractionMapping=307,THREE.RepeatWrapping=1e3,THREE.ClampToEdgeWrapping=1001,THREE.MirroredRepeatWrapping=1002,THREE.NearestFilter=1003,THREE.NearestMipMapNearestFilter=1004,THREE.NearestMipMapLinearFilter=1005,THREE.LinearFilter=1006,THREE.LinearMipMapNearestFilter=1007,THREE.LinearMipMapLinearFilter=1008,THREE.UnsignedByteType=1009,THREE.ByteType=1010,THREE.ShortType=1011,THREE.UnsignedShortType=1012,THREE.IntType=1013,THREE.UnsignedIntType=1014,THREE.FloatType=1015,THREE.HalfFloatType=1025,THREE.UnsignedShort4444Type=1016,THREE.UnsignedShort5551Type=1017,THREE.UnsignedShort565Type=1018,THREE.AlphaFormat=1019,THREE.RGBFormat=1020,THREE.RGBAFormat=1021,THREE.LuminanceFormat=1022,THREE.LuminanceAlphaFormat=1023,THREE.RGBEFormat=THREE.RGBAFormat,THREE.DepthFormat=1026,THREE.RGB_S3TC_DXT1_Format=2001,THREE.RGBA_S3TC_DXT1_Format=2002,THREE.RGBA_S3TC_DXT3_Format=2003,THREE.RGBA_S3TC_DXT5_Format=2004,THREE.RGB_PVRTC_4BPPV1_Format=2100,THREE.RGB_PVRTC_2BPPV1_Format=2101,THREE.RGBA_PVRTC_4BPPV1_Format=2102,THREE.RGBA_PVRTC_2BPPV1_Format=2103,THREE.RGB_ETC1_Format=2151,THREE.LoopOnce=2200,THREE.LoopRepeat=2201,THREE.LoopPingPong=2202,THREE.InterpolateDiscrete=2300,THREE.InterpolateLinear=2301,THREE.InterpolateSmooth=2302,THREE.ZeroCurvatureEnding=2400,THREE.ZeroSlopeEnding=2401,THREE.WrapAroundEnding=2402,THREE.TrianglesDrawMode=0,THREE.TriangleStripDrawMode=1,THREE.TriangleFanDrawMode=2,THREE.LinearEncoding=3e3,THREE.sRGBEncoding=3001,THREE.GammaEncoding=3007,THREE.RGBEEncoding=3002,THREE.LogLuvEncoding=3003,THREE.RGBM7Encoding=3004,THREE.RGBM16Encoding=3005,THREE.RGBDEncoding=3006,THREE.BasicDepthPacking=3200,THREE.RGBADepthPacking=3201,THREE.Color=function(color){return 3===arguments.length?this.fromArray(arguments):this.set(color)},THREE.Color.prototype={constructor:THREE.Color,r:1,g:1,b:1,set:function(value){return value instanceof THREE.Color?this.copy(value):"number"==typeof value?this.setHex(value):"string"==typeof value&&this.setStyle(value),this},setScalar:function(scalar){this.r=scalar,this.g=scalar,this.b=scalar},setHex:function(hex){return hex=Math.floor(hex),this.r=(hex>>16&255)/255,this.g=(hex>>8&255)/255,this.b=(255&hex)/255,this},setRGB:function(r,g,b){return this.r=r,this.g=g,this.b=b,this},setHSL:function(){function hue2rgb(p,q,t){return 0>t&&(t+=1),t>1&&(t-=1),1/6>t?p+6*(q-p)*t:.5>t?q:2/3>t?p+6*(q-p)*(2/3-t):p}return function(h,s,l){if(h=THREE.Math.euclideanModulo(h,1),s=THREE.Math.clamp(s,0,1),l=THREE.Math.clamp(l,0,1),0===s)this.r=this.g=this.b=l;else{var p=.5>=l?l*(1+s):l+s-l*s,q=2*l-p;this.r=hue2rgb(q,p,h+1/3),this.g=hue2rgb(q,p,h),this.b=hue2rgb(q,p,h-1/3)}return this}}(),setStyle:function(style){function handleAlpha(string){void 0!==string&&parseFloat(string)<1&&console.warn("THREE.Color: Alpha component of "+style+" will be ignored.")}var m;if(m=/^((?:rgb|hsl)a?)\(\s*([^\)]*)\)/.exec(style)){var color,name=m[1],components=m[2];switch(name){case"rgb":case"rgba":if(color=/^(\d+)\s*,\s*(\d+)\s*,\s*(\d+)\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(components))return this.r=Math.min(255,parseInt(color[1],10))/255,this.g=Math.min(255,parseInt(color[2],10))/255,this.b=Math.min(255,parseInt(color[3],10))/255,handleAlpha(color[5]),this;if(color=/^(\d+)\%\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(components))return this.r=Math.min(100,parseInt(color[1],10))/100,this.g=Math.min(100,parseInt(color[2],10))/100,this.b=Math.min(100,parseInt(color[3],10))/100,handleAlpha(color[5]),this;break;case"hsl":case"hsla":if(color=/^([0-9]*\.?[0-9]+)\s*,\s*(\d+)\%\s*,\s*(\d+)\%\s*(,\s*([0-9]*\.?[0-9]+)\s*)?$/.exec(components)){var h=parseFloat(color[1])/360,s=parseInt(color[2],10)/100,l=parseInt(color[3],10)/100;return handleAlpha(color[5]),this.setHSL(h,s,l)}}}else if(m=/^\#([A-Fa-f0-9]+)$/.exec(style)){var hex=m[1],size=hex.length;if(3===size)return this.r=parseInt(hex.charAt(0)+hex.charAt(0),16)/255,this.g=parseInt(hex.charAt(1)+hex.charAt(1),16)/255,this.b=parseInt(hex.charAt(2)+hex.charAt(2),16)/255,this;if(6===size)return this.r=parseInt(hex.charAt(0)+hex.charAt(1),16)/255,this.g=parseInt(hex.charAt(2)+hex.charAt(3),16)/255,this.b=parseInt(hex.charAt(4)+hex.charAt(5),16)/255,this}if(style&&style.length>0){var hex=THREE.ColorKeywords[style];void 0!==hex?this.setHex(hex):console.warn("THREE.Color: Unknown color "+style)}return this},clone:function(){return new this.constructor(this.r,this.g,this.b)},copy:function(color){return this.r=color.r,this.g=color.g,this.b=color.b,this},copyGammaToLinear:function(color,gammaFactor){return void 0===gammaFactor&&(gammaFactor=2),this.r=Math.pow(color.r,gammaFactor),this.g=Math.pow(color.g,gammaFactor),this.b=Math.pow(color.b,gammaFactor),this},copyLinearToGamma:function(color,gammaFactor){void 0===gammaFactor&&(gammaFactor=2);var safeInverse=gammaFactor>0?1/gammaFactor:1;return this.r=Math.pow(color.r,safeInverse),this.g=Math.pow(color.g,safeInverse),this.b=Math.pow(color.b,safeInverse),this},convertGammaToLinear:function(){var r=this.r,g=this.g,b=this.b;return this.r=r*r,this.g=g*g,this.b=b*b,this},convertLinearToGamma:function(){return this.r=Math.sqrt(this.r),this.g=Math.sqrt(this.g),this.b=Math.sqrt(this.b),this},getHex:function(){return 255*this.r<<16^255*this.g<<8^255*this.b<<0},getHexString:function(){return("000000"+this.getHex().toString(16)).slice(-6)},getHSL:function(optionalTarget){var hue,saturation,hsl=optionalTarget||{h:0,s:0,l:0},r=this.r,g=this.g,b=this.b,max=Math.max(r,g,b),min=Math.min(r,g,b),lightness=(min+max)/2;if(min===max)hue=0,saturation=0;else{var delta=max-min;switch(saturation=.5>=lightness?delta/(max+min):delta/(2-max-min),max){case r:hue=(g-b)/delta+(b>g?6:0);break;case g:hue=(b-r)/delta+2;break;case b:hue=(r-g)/delta+4}hue/=6}return hsl.h=hue,hsl.s=saturation,hsl.l=lightness,hsl},getStyle:function(){return"rgb("+(255*this.r|0)+","+(255*this.g|0)+","+(255*this.b|0)+")"},offsetHSL:function(h,s,l){var hsl=this.getHSL();return hsl.h+=h,hsl.s+=s,hsl.l+=l,this.setHSL(hsl.h,hsl.s,hsl.l),this},add:function(color){return this.r+=color.r,this.g+=color.g,this.b+=color.b,this},addColors:function(color1,color2){return this.r=color1.r+color2.r,this.g=color1.g+color2.g,this.b=color1.b+color2.b,this},addScalar:function(s){return this.r+=s,this.g+=s,this.b+=s,this},multiply:function(color){return this.r*=color.r,this.g*=color.g,this.b*=color.b,this},multiplyScalar:function(s){return this.r*=s,this.g*=s,this.b*=s,this},lerp:function(color,alpha){return this.r+=(color.r-this.r)*alpha,this.g+=(color.g-this.g)*alpha,this.b+=(color.b-this.b)*alpha,this},equals:function(c){return c.r===this.r&&c.g===this.g&&c.b===this.b},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.r=array[offset],this.g=array[offset+1],this.b=array[offset+2],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.r,array[offset+1]=this.g,array[offset+2]=this.b,array}},THREE.ColorKeywords={aliceblue:15792383,antiquewhite:16444375,aqua:65535,aquamarine:8388564,azure:15794175,beige:16119260,bisque:16770244,black:0,blanchedalmond:16772045,blue:255,blueviolet:9055202,brown:10824234,burlywood:14596231,cadetblue:6266528,chartreuse:8388352,chocolate:13789470,coral:16744272,cornflowerblue:6591981,cornsilk:16775388,crimson:14423100,cyan:65535,darkblue:139,darkcyan:35723,darkgoldenrod:12092939,darkgray:11119017,darkgreen:25600,darkgrey:11119017,darkkhaki:12433259,darkmagenta:9109643,darkolivegreen:5597999,darkorange:16747520,darkorchid:10040012,darkred:9109504,darksalmon:15308410,darkseagreen:9419919,darkslateblue:4734347,darkslategray:3100495,darkslategrey:3100495,darkturquoise:52945,darkviolet:9699539,deeppink:16716947,deepskyblue:49151,dimgray:6908265,dimgrey:6908265,dodgerblue:2003199,firebrick:11674146,floralwhite:16775920,forestgreen:2263842,fuchsia:16711935,gainsboro:14474460,ghostwhite:16316671,gold:16766720,goldenrod:14329120,gray:8421504,green:32768,greenyellow:11403055,grey:8421504,honeydew:15794160,hotpink:16738740,indianred:13458524,indigo:4915330,ivory:16777200,khaki:15787660,lavender:15132410,lavenderblush:16773365,lawngreen:8190976,lemonchiffon:16775885,lightblue:11393254,lightcoral:15761536,lightcyan:14745599,lightgoldenrodyellow:16448210,lightgray:13882323,lightgreen:9498256,lightgrey:13882323,lightpink:16758465,lightsalmon:16752762,lightseagreen:2142890,lightskyblue:8900346,lightslategray:7833753,lightslategrey:7833753,lightsteelblue:11584734,lightyellow:16777184,lime:65280,limegreen:3329330,linen:16445670,magenta:16711935,maroon:8388608,mediumaquamarine:6737322,mediumblue:205,mediumorchid:12211667,mediumpurple:9662683,mediumseagreen:3978097,mediumslateblue:8087790,mediumspringgreen:64154,mediumturquoise:4772300,mediumvioletred:13047173,midnightblue:1644912,mintcream:16121850,mistyrose:16770273,moccasin:16770229,navajowhite:16768685,navy:128,oldlace:16643558,olive:8421376,olivedrab:7048739,orange:16753920,orangered:16729344,orchid:14315734,palegoldenrod:15657130,palegreen:10025880,paleturquoise:11529966,palevioletred:14381203,papayawhip:16773077,peachpuff:16767673,peru:13468991,pink:16761035,plum:14524637,powderblue:11591910,purple:8388736,red:16711680,rosybrown:12357519,royalblue:4286945,saddlebrown:9127187,salmon:16416882,sandybrown:16032864,seagreen:3050327,seashell:16774638,sienna:10506797,silver:12632256,skyblue:8900331,slateblue:6970061,slategray:7372944,slategrey:7372944,snow:16775930,springgreen:65407,steelblue:4620980,tan:13808780,teal:32896,thistle:14204888,tomato:16737095,turquoise:4251856,violet:15631086,wheat:16113331,white:16777215,whitesmoke:16119285,yellow:16776960,yellowgreen:10145074},THREE.Quaternion=function(x,y,z,w){this._x=x||0,this._y=y||0,this._z=z||0,this._w=void 0!==w?w:1},THREE.Quaternion.prototype={constructor:THREE.Quaternion,get x(){return this._x},set x(value){this._x=value,this.onChangeCallback()},get y(){return this._y},set y(value){this._y=value,this.onChangeCallback()},get z(){return this._z},set z(value){this._z=value,this.onChangeCallback()},get w(){return this._w},set w(value){this._w=value,this.onChangeCallback()},set:function(x,y,z,w){return this._x=x,this._y=y,this._z=z,this._w=w,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._w)},copy:function(quaternion){return this._x=quaternion.x,this._y=quaternion.y,this._z=quaternion.z,this._w=quaternion.w,this.onChangeCallback(),this},setFromEuler:function(euler,update){if(euler instanceof THREE.Euler==!1)throw new Error("THREE.Quaternion: .setFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var c1=Math.cos(euler._x/2),c2=Math.cos(euler._y/2),c3=Math.cos(euler._z/2),s1=Math.sin(euler._x/2),s2=Math.sin(euler._y/2),s3=Math.sin(euler._z/2),order=euler.order;return"XYZ"===order?(this._x=s1*c2*c3+c1*s2*s3,this._y=c1*s2*c3-s1*c2*s3,this._z=c1*c2*s3+s1*s2*c3,this._w=c1*c2*c3-s1*s2*s3):"YXZ"===order?(this._x=s1*c2*c3+c1*s2*s3,this._y=c1*s2*c3-s1*c2*s3,this._z=c1*c2*s3-s1*s2*c3,this._w=c1*c2*c3+s1*s2*s3):"ZXY"===order?(this._x=s1*c2*c3-c1*s2*s3,this._y=c1*s2*c3+s1*c2*s3,this._z=c1*c2*s3+s1*s2*c3,this._w=c1*c2*c3-s1*s2*s3):"ZYX"===order?(this._x=s1*c2*c3-c1*s2*s3,this._y=c1*s2*c3+s1*c2*s3,this._z=c1*c2*s3-s1*s2*c3,this._w=c1*c2*c3+s1*s2*s3):"YZX"===order?(this._x=s1*c2*c3+c1*s2*s3,this._y=c1*s2*c3+s1*c2*s3,this._z=c1*c2*s3-s1*s2*c3,this._w=c1*c2*c3-s1*s2*s3):"XZY"===order&&(this._x=s1*c2*c3-c1*s2*s3,this._y=c1*s2*c3-s1*c2*s3,this._z=c1*c2*s3+s1*s2*c3,this._w=c1*c2*c3+s1*s2*s3),update!==!1&&this.onChangeCallback(),this},setFromAxisAngle:function(axis,angle){var halfAngle=angle/2,s=Math.sin(halfAngle);return this._x=axis.x*s,this._y=axis.y*s,this._z=axis.z*s,this._w=Math.cos(halfAngle),this.onChangeCallback(),this},setFromRotationMatrix:function(m){var s,te=m.elements,m11=te[0],m12=te[4],m13=te[8],m21=te[1],m22=te[5],m23=te[9],m31=te[2],m32=te[6],m33=te[10],trace=m11+m22+m33;return trace>0?(s=.5/Math.sqrt(trace+1),this._w=.25/s,this._x=(m32-m23)*s,this._y=(m13-m31)*s,this._z=(m21-m12)*s):m11>m22&&m11>m33?(s=2*Math.sqrt(1+m11-m22-m33),this._w=(m32-m23)/s,this._x=.25*s,this._y=(m12+m21)/s,this._z=(m13+m31)/s):m22>m33?(s=2*Math.sqrt(1+m22-m11-m33),this._w=(m13-m31)/s,this._x=(m12+m21)/s,this._y=.25*s,this._z=(m23+m32)/s):(s=2*Math.sqrt(1+m33-m11-m22),this._w=(m21-m12)/s,this._x=(m13+m31)/s,this._y=(m23+m32)/s,this._z=.25*s),this.onChangeCallback(),this},setFromUnitVectors:function(){var v1,r,EPS=1e-6;return function(vFrom,vTo){return void 0===v1&&(v1=new THREE.Vector3),r=vFrom.dot(vTo)+1,EPS>r?(r=0,Math.abs(vFrom.x)>Math.abs(vFrom.z)?v1.set(-vFrom.y,vFrom.x,0):v1.set(0,-vFrom.z,vFrom.y)):v1.crossVectors(vFrom,vTo),this._x=v1.x,this._y=v1.y,this._z=v1.z,this._w=r,this.normalize(),this}}(),inverse:function(){return this.conjugate().normalize(),this},conjugate:function(){return this._x*=-1,this._y*=-1,this._z*=-1,this.onChangeCallback(),this},dot:function(v){return this._x*v._x+this._y*v._y+this._z*v._z+this._w*v._w},lengthSq:function(){return this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w},length:function(){return Math.sqrt(this._x*this._x+this._y*this._y+this._z*this._z+this._w*this._w)},normalize:function(){var l=this.length();return 0===l?(this._x=0,this._y=0,this._z=0,this._w=1):(l=1/l,this._x=this._x*l,this._y=this._y*l,this._z=this._z*l,this._w=this._w*l),this.onChangeCallback(),this},multiply:function(q,p){return void 0!==p?(console.warn("THREE.Quaternion: .multiply() now only accepts one argument. Use .multiplyQuaternions( a, b ) instead."),this.multiplyQuaternions(q,p)):this.multiplyQuaternions(this,q)},multiplyQuaternions:function(a,b){var qax=a._x,qay=a._y,qaz=a._z,qaw=a._w,qbx=b._x,qby=b._y,qbz=b._z,qbw=b._w;return this._x=qax*qbw+qaw*qbx+qay*qbz-qaz*qby,this._y=qay*qbw+qaw*qby+qaz*qbx-qax*qbz,this._z=qaz*qbw+qaw*qbz+qax*qby-qay*qbx,this._w=qaw*qbw-qax*qbx-qay*qby-qaz*qbz,this.onChangeCallback(),this},slerp:function(qb,t){if(0===t)return this;if(1===t)return this.copy(qb);var x=this._x,y=this._y,z=this._z,w=this._w,cosHalfTheta=w*qb._w+x*qb._x+y*qb._y+z*qb._z;if(0>cosHalfTheta?(this._w=-qb._w,this._x=-qb._x,this._y=-qb._y,this._z=-qb._z,cosHalfTheta=-cosHalfTheta):this.copy(qb),cosHalfTheta>=1)return this._w=w,this._x=x,this._y=y,this._z=z,this;var sinHalfTheta=Math.sqrt(1-cosHalfTheta*cosHalfTheta);if(Math.abs(sinHalfTheta)<.001)return this._w=.5*(w+this._w),this._x=.5*(x+this._x),this._y=.5*(y+this._y),this._z=.5*(z+this._z),this;var halfTheta=Math.atan2(sinHalfTheta,cosHalfTheta),ratioA=Math.sin((1-t)*halfTheta)/sinHalfTheta,ratioB=Math.sin(t*halfTheta)/sinHalfTheta;return this._w=w*ratioA+this._w*ratioB,this._x=x*ratioA+this._x*ratioB,this._y=y*ratioA+this._y*ratioB,this._z=z*ratioA+this._z*ratioB,this.onChangeCallback(),this},equals:function(quaternion){return quaternion._x===this._x&&quaternion._y===this._y&&quaternion._z===this._z&&quaternion._w===this._w},fromArray:function(array,offset){return void 0===offset&&(offset=0),this._x=array[offset],this._y=array[offset+1],this._z=array[offset+2],this._w=array[offset+3],this.onChangeCallback(),this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this._x,array[offset+1]=this._y,array[offset+2]=this._z,array[offset+3]=this._w,array},onChange:function(callback){return this.onChangeCallback=callback,this},onChangeCallback:function(){}},Object.assign(THREE.Quaternion,{slerp:function(qa,qb,qm,t){return qm.copy(qa).slerp(qb,t)},slerpFlat:function(dst,dstOffset,src0,srcOffset0,src1,srcOffset1,t){var x0=src0[srcOffset0+0],y0=src0[srcOffset0+1],z0=src0[srcOffset0+2],w0=src0[srcOffset0+3],x1=src1[srcOffset1+0],y1=src1[srcOffset1+1],z1=src1[srcOffset1+2],w1=src1[srcOffset1+3];if(w0!==w1||x0!==x1||y0!==y1||z0!==z1){var s=1-t,cos=x0*x1+y0*y1+z0*z1+w0*w1,dir=cos>=0?1:-1,sqrSin=1-cos*cos;if(sqrSin>Number.EPSILON){var sin=Math.sqrt(sqrSin),len=Math.atan2(sin,cos*dir);s=Math.sin(s*len)/sin,t=Math.sin(t*len)/sin}var tDir=t*dir;if(x0=x0*s+x1*tDir,y0=y0*s+y1*tDir,z0=z0*s+z1*tDir,w0=w0*s+w1*tDir,s===1-t){var f=1/Math.sqrt(x0*x0+y0*y0+z0*z0+w0*w0);x0*=f,y0*=f,z0*=f,w0*=f}}dst[dstOffset]=x0,dst[dstOffset+1]=y0,dst[dstOffset+2]=z0,dst[dstOffset+3]=w0}}),THREE.Vector2=function(x,y){this.x=x||0,this.y=y||0},THREE.Vector2.prototype={constructor:THREE.Vector2,get width(){return this.x},set width(value){this.x=value},get height(){return this.y},set height(value){this.y=value},set:function(x,y){return this.x=x,this.y=y,this},setScalar:function(scalar){return this.x=scalar,this.y=scalar,this},setX:function(x){return this.x=x,this},setY:function(y){return this.y=y,this},setComponent:function(index,value){switch(index){case 0:this.x=value;break;case 1:this.y=value;break;default:throw new Error("index is out of range: "+index)}},getComponent:function(index){switch(index){case 0:return this.x;case 1:return this.y;default:throw new Error("index is out of range: "+index)}},clone:function(){return new this.constructor(this.x,this.y)},copy:function(v){return this.x=v.x,this.y=v.y,this},add:function(v,w){return void 0!==w?(console.warn("THREE.Vector2: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(v,w)):(this.x+=v.x,this.y+=v.y,this)},addScalar:function(s){return this.x+=s,this.y+=s,this},addVectors:function(a,b){return this.x=a.x+b.x,this.y=a.y+b.y,this},addScaledVector:function(v,s){return this.x+=v.x*s,this.y+=v.y*s,this},sub:function(v,w){return void 0!==w?(console.warn("THREE.Vector2: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(v,w)):(this.x-=v.x,this.y-=v.y,this)},subScalar:function(s){return this.x-=s,this.y-=s,this},subVectors:function(a,b){return this.x=a.x-b.x,this.y=a.y-b.y,this},multiply:function(v){return this.x*=v.x,this.y*=v.y,this},multiplyScalar:function(scalar){return isFinite(scalar)?(this.x*=scalar,this.y*=scalar):(this.x=0,this.y=0),this},divide:function(v){return this.x/=v.x,this.y/=v.y,this},divideScalar:function(scalar){return this.multiplyScalar(1/scalar)},min:function(v){return this.x=Math.min(this.x,v.x),this.y=Math.min(this.y,v.y),this},max:function(v){return this.x=Math.max(this.x,v.x),this.y=Math.max(this.y,v.y),this},clamp:function(min,max){return this.x=Math.max(min.x,Math.min(max.x,this.x)),this.y=Math.max(min.y,Math.min(max.y,this.y)),this},clampScalar:function(){var min,max;return function(minVal,maxVal){return void 0===min&&(min=new THREE.Vector2,max=new THREE.Vector2),min.set(minVal,minVal),max.set(maxVal,maxVal),this.clamp(min,max)}}(),clampLength:function(min,max){var length=this.length();return this.multiplyScalar(Math.max(min,Math.min(max,length))/length),this},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this},negate:function(){return this.x=-this.x,this.y=-this.y,this},dot:function(v){return this.x*v.x+this.y*v.y},lengthSq:function(){return this.x*this.x+this.y*this.y},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)},normalize:function(){return this.divideScalar(this.length())},angle:function(){var angle=Math.atan2(this.y,this.x);return 0>angle&&(angle+=2*Math.PI),angle},distanceTo:function(v){return Math.sqrt(this.distanceToSquared(v))},distanceToSquared:function(v){var dx=this.x-v.x,dy=this.y-v.y;return dx*dx+dy*dy},setLength:function(length){return this.multiplyScalar(length/this.length())},lerp:function(v,alpha){return this.x+=(v.x-this.x)*alpha,this.y+=(v.y-this.y)*alpha,this},lerpVectors:function(v1,v2,alpha){return this.subVectors(v2,v1).multiplyScalar(alpha).add(v1),this},equals:function(v){return v.x===this.x&&v.y===this.y},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.x=array[offset],this.y=array[offset+1],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.x,array[offset+1]=this.y,array},fromAttribute:function(attribute,index,offset){return void 0===offset&&(offset=0),index=index*attribute.itemSize+offset,this.x=attribute.array[index],this.y=attribute.array[index+1],this},rotateAround:function(center,angle){var c=Math.cos(angle),s=Math.sin(angle),x=this.x-center.x,y=this.y-center.y;return this.x=x*c-y*s+center.x,this.y=x*s+y*c+center.y,this}},THREE.Vector3=function(x,y,z){this.x=x||0,this.y=y||0,this.z=z||0},THREE.Vector3.prototype={constructor:THREE.Vector3,set:function(x,y,z){return this.x=x,this.y=y,this.z=z,this},setScalar:function(scalar){return this.x=scalar,this.y=scalar,this.z=scalar,this},setX:function(x){return this.x=x,this},setY:function(y){return this.y=y,this},setZ:function(z){return this.z=z,this},setComponent:function(index,value){switch(index){case 0:this.x=value;break;case 1:this.y=value;break;case 2:this.z=value;break;default:throw new Error("index is out of range: "+index)}},getComponent:function(index){switch(index){case 0:return this.x;case 1:return this.y;case 2:return this.z;default:throw new Error("index is out of range: "+index)}},clone:function(){return new this.constructor(this.x,this.y,this.z)},copy:function(v){return this.x=v.x,this.y=v.y,this.z=v.z,this},add:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(v,w)):(this.x+=v.x,this.y+=v.y,this.z+=v.z,this)},addScalar:function(s){return this.x+=s,this.y+=s,this.z+=s,this},addVectors:function(a,b){return this.x=a.x+b.x,this.y=a.y+b.y,this.z=a.z+b.z,this},addScaledVector:function(v,s){return this.x+=v.x*s,this.y+=v.y*s,this.z+=v.z*s,this},sub:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(v,w)):(this.x-=v.x,this.y-=v.y,this.z-=v.z,this)},subScalar:function(s){return this.x-=s,this.y-=s,this.z-=s,this},subVectors:function(a,b){return this.x=a.x-b.x,this.y=a.y-b.y,this.z=a.z-b.z,this},multiply:function(v,w){return void 0!==w?(console.warn("THREE.Vector3: .multiply() now only accepts one argument. Use .multiplyVectors( a, b ) instead."),this.multiplyVectors(v,w)):(this.x*=v.x,this.y*=v.y,this.z*=v.z,this)},multiplyScalar:function(scalar){return isFinite(scalar)?(this.x*=scalar,this.y*=scalar,this.z*=scalar):(this.x=0,this.y=0,this.z=0),this},multiplyVectors:function(a,b){return this.x=a.x*b.x,this.y=a.y*b.y,this.z=a.z*b.z,this},applyEuler:function(){var quaternion;return function(euler){return euler instanceof THREE.Euler==!1&&console.error("THREE.Vector3: .applyEuler() now expects an Euler rotation rather than a Vector3 and order."),void 0===quaternion&&(quaternion=new THREE.Quaternion),this.applyQuaternion(quaternion.setFromEuler(euler)),this}}(),applyAxisAngle:function(){var quaternion;return function(axis,angle){return void 0===quaternion&&(quaternion=new THREE.Quaternion),this.applyQuaternion(quaternion.setFromAxisAngle(axis,angle)),this}}(),applyMatrix3:function(m){var x=this.x,y=this.y,z=this.z,e=m.elements;return this.x=e[0]*x+e[3]*y+e[6]*z,this.y=e[1]*x+e[4]*y+e[7]*z,this.z=e[2]*x+e[5]*y+e[8]*z,this},applyMatrix4:function(m){var x=this.x,y=this.y,z=this.z,e=m.elements;return this.x=e[0]*x+e[4]*y+e[8]*z+e[12],this.y=e[1]*x+e[5]*y+e[9]*z+e[13],this.z=e[2]*x+e[6]*y+e[10]*z+e[14],this},applyProjection:function(m){var x=this.x,y=this.y,z=this.z,e=m.elements,d=1/(e[3]*x+e[7]*y+e[11]*z+e[15]);return this.x=(e[0]*x+e[4]*y+e[8]*z+e[12])*d,this.y=(e[1]*x+e[5]*y+e[9]*z+e[13])*d,this.z=(e[2]*x+e[6]*y+e[10]*z+e[14])*d,this},applyQuaternion:function(q){var x=this.x,y=this.y,z=this.z,qx=q.x,qy=q.y,qz=q.z,qw=q.w,ix=qw*x+qy*z-qz*y,iy=qw*y+qz*x-qx*z,iz=qw*z+qx*y-qy*x,iw=-qx*x-qy*y-qz*z;return this.x=ix*qw+iw*-qx+iy*-qz-iz*-qy,this.y=iy*qw+iw*-qy+iz*-qx-ix*-qz,this.z=iz*qw+iw*-qz+ix*-qy-iy*-qx,this},project:function(){var matrix;return function(camera){return void 0===matrix&&(matrix=new THREE.Matrix4),matrix.multiplyMatrices(camera.projectionMatrix,matrix.getInverse(camera.matrixWorld)),this.applyProjection(matrix)}}(),unproject:function(){var matrix;return function(camera){return void 0===matrix&&(matrix=new THREE.Matrix4),matrix.multiplyMatrices(camera.matrixWorld,matrix.getInverse(camera.projectionMatrix)),this.applyProjection(matrix)}}(),transformDirection:function(m){var x=this.x,y=this.y,z=this.z,e=m.elements;return this.x=e[0]*x+e[4]*y+e[8]*z,this.y=e[1]*x+e[5]*y+e[9]*z,this.z=e[2]*x+e[6]*y+e[10]*z,this.normalize(),this},divide:function(v){return this.x/=v.x,this.y/=v.y,this.z/=v.z,this},divideScalar:function(scalar){return this.multiplyScalar(1/scalar)},min:function(v){return this.x=Math.min(this.x,v.x),this.y=Math.min(this.y,v.y),this.z=Math.min(this.z,v.z),this},max:function(v){return this.x=Math.max(this.x,v.x),this.y=Math.max(this.y,v.y),this.z=Math.max(this.z,v.z),this},clamp:function(min,max){return this.x=Math.max(min.x,Math.min(max.x,this.x)),this.y=Math.max(min.y,Math.min(max.y,this.y)),this.z=Math.max(min.z,Math.min(max.z,this.z)),this},clampScalar:function(){var min,max;return function(minVal,maxVal){return void 0===min&&(min=new THREE.Vector3,max=new THREE.Vector3),min.set(minVal,minVal,minVal),max.set(maxVal,maxVal,maxVal),this.clamp(min,max)}}(),clampLength:function(min,max){var length=this.length();return this.multiplyScalar(Math.max(min,Math.min(max,length))/length),this},floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this},dot:function(v){return this.x*v.x+this.y*v.y+this.z*v.z},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)},normalize:function(){return this.divideScalar(this.length())},setLength:function(length){return this.multiplyScalar(length/this.length())},lerp:function(v,alpha){return this.x+=(v.x-this.x)*alpha,this.y+=(v.y-this.y)*alpha,this.z+=(v.z-this.z)*alpha,this},lerpVectors:function(v1,v2,alpha){return this.subVectors(v2,v1).multiplyScalar(alpha).add(v1),this},cross:function(v,w){if(void 0!==w)return console.warn("THREE.Vector3: .cross() now only accepts one argument. Use .crossVectors( a, b ) instead."),this.crossVectors(v,w);var x=this.x,y=this.y,z=this.z;return this.x=y*v.z-z*v.y,this.y=z*v.x-x*v.z,this.z=x*v.y-y*v.x,this},crossVectors:function(a,b){var ax=a.x,ay=a.y,az=a.z,bx=b.x,by=b.y,bz=b.z;return this.x=ay*bz-az*by,this.y=az*bx-ax*bz,this.z=ax*by-ay*bx,this},projectOnVector:function(){var v1,dot;return function(vector){return void 0===v1&&(v1=new THREE.Vector3),v1.copy(vector).normalize(),dot=this.dot(v1),this.copy(v1).multiplyScalar(dot)}}(),projectOnPlane:function(){var v1;return function(planeNormal){return void 0===v1&&(v1=new THREE.Vector3),v1.copy(this).projectOnVector(planeNormal),this.sub(v1)}}(),reflect:function(){var v1;return function(normal){return void 0===v1&&(v1=new THREE.Vector3),this.sub(v1.copy(normal).multiplyScalar(2*this.dot(normal)))}}(),angleTo:function(v){var theta=this.dot(v)/Math.sqrt(this.lengthSq()*v.lengthSq());return Math.acos(THREE.Math.clamp(theta,-1,1))},distanceTo:function(v){return Math.sqrt(this.distanceToSquared(v))},distanceToSquared:function(v){var dx=this.x-v.x,dy=this.y-v.y,dz=this.z-v.z;return dx*dx+dy*dy+dz*dz},setFromSpherical:function(s){var sinPhiRadius=Math.sin(s.phi)*s.radius;return this.x=sinPhiRadius*Math.sin(s.theta),this.y=Math.cos(s.phi)*s.radius,this.z=sinPhiRadius*Math.cos(s.theta),this},setFromMatrixPosition:function(m){return this.setFromMatrixColumn(m,3)},setFromMatrixScale:function(m){var sx=this.setFromMatrixColumn(m,0).length(),sy=this.setFromMatrixColumn(m,1).length(),sz=this.setFromMatrixColumn(m,2).length();return this.x=sx,this.y=sy,this.z=sz,this},setFromMatrixColumn:function(m,index){return"number"==typeof m&&(console.warn("THREE.Vector3: setFromMatrixColumn now expects ( matrix, index )."),m=arguments[1],index=arguments[0]),this.fromArray(m.elements,4*index)},equals:function(v){return v.x===this.x&&v.y===this.y&&v.z===this.z},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.x=array[offset],this.y=array[offset+1],this.z=array[offset+2],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.x,array[offset+1]=this.y,array[offset+2]=this.z,array},fromAttribute:function(attribute,index,offset){return void 0===offset&&(offset=0),
index=index*attribute.itemSize+offset,this.x=attribute.array[index],this.y=attribute.array[index+1],this.z=attribute.array[index+2],this}},THREE.Vector4=function(x,y,z,w){this.x=x||0,this.y=y||0,this.z=z||0,this.w=void 0!==w?w:1},THREE.Vector4.prototype={constructor:THREE.Vector4,set:function(x,y,z,w){return this.x=x,this.y=y,this.z=z,this.w=w,this},setScalar:function(scalar){return this.x=scalar,this.y=scalar,this.z=scalar,this.w=scalar,this},setX:function(x){return this.x=x,this},setY:function(y){return this.y=y,this},setZ:function(z){return this.z=z,this},setW:function(w){return this.w=w,this},setComponent:function(index,value){switch(index){case 0:this.x=value;break;case 1:this.y=value;break;case 2:this.z=value;break;case 3:this.w=value;break;default:throw new Error("index is out of range: "+index)}},getComponent:function(index){switch(index){case 0:return this.x;case 1:return this.y;case 2:return this.z;case 3:return this.w;default:throw new Error("index is out of range: "+index)}},clone:function(){return new this.constructor(this.x,this.y,this.z,this.w)},copy:function(v){return this.x=v.x,this.y=v.y,this.z=v.z,this.w=void 0!==v.w?v.w:1,this},add:function(v,w){return void 0!==w?(console.warn("THREE.Vector4: .add() now only accepts one argument. Use .addVectors( a, b ) instead."),this.addVectors(v,w)):(this.x+=v.x,this.y+=v.y,this.z+=v.z,this.w+=v.w,this)},addScalar:function(s){return this.x+=s,this.y+=s,this.z+=s,this.w+=s,this},addVectors:function(a,b){return this.x=a.x+b.x,this.y=a.y+b.y,this.z=a.z+b.z,this.w=a.w+b.w,this},addScaledVector:function(v,s){return this.x+=v.x*s,this.y+=v.y*s,this.z+=v.z*s,this.w+=v.w*s,this},sub:function(v,w){return void 0!==w?(console.warn("THREE.Vector4: .sub() now only accepts one argument. Use .subVectors( a, b ) instead."),this.subVectors(v,w)):(this.x-=v.x,this.y-=v.y,this.z-=v.z,this.w-=v.w,this)},subScalar:function(s){return this.x-=s,this.y-=s,this.z-=s,this.w-=s,this},subVectors:function(a,b){return this.x=a.x-b.x,this.y=a.y-b.y,this.z=a.z-b.z,this.w=a.w-b.w,this},multiplyScalar:function(scalar){return isFinite(scalar)?(this.x*=scalar,this.y*=scalar,this.z*=scalar,this.w*=scalar):(this.x=0,this.y=0,this.z=0,this.w=0),this},applyMatrix4:function(m){var x=this.x,y=this.y,z=this.z,w=this.w,e=m.elements;return this.x=e[0]*x+e[4]*y+e[8]*z+e[12]*w,this.y=e[1]*x+e[5]*y+e[9]*z+e[13]*w,this.z=e[2]*x+e[6]*y+e[10]*z+e[14]*w,this.w=e[3]*x+e[7]*y+e[11]*z+e[15]*w,this},divideScalar:function(scalar){return this.multiplyScalar(1/scalar)},setAxisAngleFromQuaternion:function(q){this.w=2*Math.acos(q.w);var s=Math.sqrt(1-q.w*q.w);return 1e-4>s?(this.x=1,this.y=0,this.z=0):(this.x=q.x/s,this.y=q.y/s,this.z=q.z/s),this},setAxisAngleFromRotationMatrix:function(m){var angle,x,y,z,epsilon=.01,epsilon2=.1,te=m.elements,m11=te[0],m12=te[4],m13=te[8],m21=te[1],m22=te[5],m23=te[9],m31=te[2],m32=te[6],m33=te[10];if(Math.abs(m12-m21)<epsilon&&Math.abs(m13-m31)<epsilon&&Math.abs(m23-m32)<epsilon){if(Math.abs(m12+m21)<epsilon2&&Math.abs(m13+m31)<epsilon2&&Math.abs(m23+m32)<epsilon2&&Math.abs(m11+m22+m33-3)<epsilon2)return this.set(1,0,0,0),this;angle=Math.PI;var xx=(m11+1)/2,yy=(m22+1)/2,zz=(m33+1)/2,xy=(m12+m21)/4,xz=(m13+m31)/4,yz=(m23+m32)/4;return xx>yy&&xx>zz?epsilon>xx?(x=0,y=.707106781,z=.707106781):(x=Math.sqrt(xx),y=xy/x,z=xz/x):yy>zz?epsilon>yy?(x=.707106781,y=0,z=.707106781):(y=Math.sqrt(yy),x=xy/y,z=yz/y):epsilon>zz?(x=.707106781,y=.707106781,z=0):(z=Math.sqrt(zz),x=xz/z,y=yz/z),this.set(x,y,z,angle),this}var s=Math.sqrt((m32-m23)*(m32-m23)+(m13-m31)*(m13-m31)+(m21-m12)*(m21-m12));return Math.abs(s)<.001&&(s=1),this.x=(m32-m23)/s,this.y=(m13-m31)/s,this.z=(m21-m12)/s,this.w=Math.acos((m11+m22+m33-1)/2),this},min:function(v){return this.x=Math.min(this.x,v.x),this.y=Math.min(this.y,v.y),this.z=Math.min(this.z,v.z),this.w=Math.min(this.w,v.w),this},max:function(v){return this.x=Math.max(this.x,v.x),this.y=Math.max(this.y,v.y),this.z=Math.max(this.z,v.z),this.w=Math.max(this.w,v.w),this},clamp:function(min,max){return this.x=Math.max(min.x,Math.min(max.x,this.x)),this.y=Math.max(min.y,Math.min(max.y,this.y)),this.z=Math.max(min.z,Math.min(max.z,this.z)),this.w=Math.max(min.w,Math.min(max.w,this.w)),this},clampScalar:function(){var min,max;return function(minVal,maxVal){return void 0===min&&(min=new THREE.Vector4,max=new THREE.Vector4),min.set(minVal,minVal,minVal,minVal),max.set(maxVal,maxVal,maxVal,maxVal),this.clamp(min,max)}}(),floor:function(){return this.x=Math.floor(this.x),this.y=Math.floor(this.y),this.z=Math.floor(this.z),this.w=Math.floor(this.w),this},ceil:function(){return this.x=Math.ceil(this.x),this.y=Math.ceil(this.y),this.z=Math.ceil(this.z),this.w=Math.ceil(this.w),this},round:function(){return this.x=Math.round(this.x),this.y=Math.round(this.y),this.z=Math.round(this.z),this.w=Math.round(this.w),this},roundToZero:function(){return this.x=this.x<0?Math.ceil(this.x):Math.floor(this.x),this.y=this.y<0?Math.ceil(this.y):Math.floor(this.y),this.z=this.z<0?Math.ceil(this.z):Math.floor(this.z),this.w=this.w<0?Math.ceil(this.w):Math.floor(this.w),this},negate:function(){return this.x=-this.x,this.y=-this.y,this.z=-this.z,this.w=-this.w,this},dot:function(v){return this.x*v.x+this.y*v.y+this.z*v.z+this.w*v.w},lengthSq:function(){return this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w},length:function(){return Math.sqrt(this.x*this.x+this.y*this.y+this.z*this.z+this.w*this.w)},lengthManhattan:function(){return Math.abs(this.x)+Math.abs(this.y)+Math.abs(this.z)+Math.abs(this.w)},normalize:function(){return this.divideScalar(this.length())},setLength:function(length){return this.multiplyScalar(length/this.length())},lerp:function(v,alpha){return this.x+=(v.x-this.x)*alpha,this.y+=(v.y-this.y)*alpha,this.z+=(v.z-this.z)*alpha,this.w+=(v.w-this.w)*alpha,this},lerpVectors:function(v1,v2,alpha){return this.subVectors(v2,v1).multiplyScalar(alpha).add(v1),this},equals:function(v){return v.x===this.x&&v.y===this.y&&v.z===this.z&&v.w===this.w},fromArray:function(array,offset){return void 0===offset&&(offset=0),this.x=array[offset],this.y=array[offset+1],this.z=array[offset+2],this.w=array[offset+3],this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this.x,array[offset+1]=this.y,array[offset+2]=this.z,array[offset+3]=this.w,array},fromAttribute:function(attribute,index,offset){return void 0===offset&&(offset=0),index=index*attribute.itemSize+offset,this.x=attribute.array[index],this.y=attribute.array[index+1],this.z=attribute.array[index+2],this.w=attribute.array[index+3],this}},THREE.Euler=function(x,y,z,order){this._x=x||0,this._y=y||0,this._z=z||0,this._order=order||THREE.Euler.DefaultOrder},THREE.Euler.RotationOrders=["XYZ","YZX","ZXY","XZY","YXZ","ZYX"],THREE.Euler.DefaultOrder="XYZ",THREE.Euler.prototype={constructor:THREE.Euler,get x(){return this._x},set x(value){this._x=value,this.onChangeCallback()},get y(){return this._y},set y(value){this._y=value,this.onChangeCallback()},get z(){return this._z},set z(value){this._z=value,this.onChangeCallback()},get order(){return this._order},set order(value){this._order=value,this.onChangeCallback()},set:function(x,y,z,order){return this._x=x,this._y=y,this._z=z,this._order=order||this._order,this.onChangeCallback(),this},clone:function(){return new this.constructor(this._x,this._y,this._z,this._order)},copy:function(euler){return this._x=euler._x,this._y=euler._y,this._z=euler._z,this._order=euler._order,this.onChangeCallback(),this},setFromRotationMatrix:function(m,order,update){var clamp=THREE.Math.clamp,te=m.elements,m11=te[0],m12=te[4],m13=te[8],m21=te[1],m22=te[5],m23=te[9],m31=te[2],m32=te[6],m33=te[10];return order=order||this._order,"XYZ"===order?(this._y=Math.asin(clamp(m13,-1,1)),Math.abs(m13)<.99999?(this._x=Math.atan2(-m23,m33),this._z=Math.atan2(-m12,m11)):(this._x=Math.atan2(m32,m22),this._z=0)):"YXZ"===order?(this._x=Math.asin(-clamp(m23,-1,1)),Math.abs(m23)<.99999?(this._y=Math.atan2(m13,m33),this._z=Math.atan2(m21,m22)):(this._y=Math.atan2(-m31,m11),this._z=0)):"ZXY"===order?(this._x=Math.asin(clamp(m32,-1,1)),Math.abs(m32)<.99999?(this._y=Math.atan2(-m31,m33),this._z=Math.atan2(-m12,m22)):(this._y=0,this._z=Math.atan2(m21,m11))):"ZYX"===order?(this._y=Math.asin(-clamp(m31,-1,1)),Math.abs(m31)<.99999?(this._x=Math.atan2(m32,m33),this._z=Math.atan2(m21,m11)):(this._x=0,this._z=Math.atan2(-m12,m22))):"YZX"===order?(this._z=Math.asin(clamp(m21,-1,1)),Math.abs(m21)<.99999?(this._x=Math.atan2(-m23,m22),this._y=Math.atan2(-m31,m11)):(this._x=0,this._y=Math.atan2(m13,m33))):"XZY"===order?(this._z=Math.asin(-clamp(m12,-1,1)),Math.abs(m12)<.99999?(this._x=Math.atan2(m32,m22),this._y=Math.atan2(m13,m11)):(this._x=Math.atan2(-m23,m33),this._y=0)):console.warn("THREE.Euler: .setFromRotationMatrix() given unsupported order: "+order),this._order=order,update!==!1&&this.onChangeCallback(),this},setFromQuaternion:function(){var matrix;return function(q,order,update){return void 0===matrix&&(matrix=new THREE.Matrix4),matrix.makeRotationFromQuaternion(q),this.setFromRotationMatrix(matrix,order,update),this}}(),setFromVector3:function(v,order){return this.set(v.x,v.y,v.z,order||this._order)},reorder:function(){var q=new THREE.Quaternion;return function(newOrder){q.setFromEuler(this),this.setFromQuaternion(q,newOrder)}}(),equals:function(euler){return euler._x===this._x&&euler._y===this._y&&euler._z===this._z&&euler._order===this._order},fromArray:function(array){return this._x=array[0],this._y=array[1],this._z=array[2],void 0!==array[3]&&(this._order=array[3]),this.onChangeCallback(),this},toArray:function(array,offset){return void 0===array&&(array=[]),void 0===offset&&(offset=0),array[offset]=this._x,array[offset+1]=this._y,array[offset+2]=this._z,array[offset+3]=this._order,array},toVector3:function(optionalResult){return optionalResult?optionalResult.set(this._x,this._y,this._z):new THREE.Vector3(this._x,this._y,this._z)},onChange:function(callback){return this.onChangeCallback=callback,this},onChangeCallback:function(){}},THREE.Line3=function(start,end){this.start=void 0!==start?start:new THREE.Vector3,this.end=void 0!==end?end:new THREE.Vector3},THREE.Line3.prototype={constructor:THREE.Line3,set:function(start,end){return this.start.copy(start),this.end.copy(end),this},clone:function(){return(new this.constructor).copy(this)},copy:function(line){return this.start.copy(line.start),this.end.copy(line.end),this},center:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.addVectors(this.start,this.end).multiplyScalar(.5)},delta:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.subVectors(this.end,this.start)},distanceSq:function(){return this.start.distanceToSquared(this.end)},distance:function(){return this.start.distanceTo(this.end)},at:function(t,optionalTarget){var result=optionalTarget||new THREE.Vector3;return this.delta(result).multiplyScalar(t).add(this.start)},closestPointToPointParameter:function(){var startP=new THREE.Vector3,startEnd=new THREE.Vector3;return function(point,clampToLine){startP.subVectors(point,this.start),startEnd.subVectors(this.end,this.start);var startEnd2=startEnd.dot(startEnd),startEnd_startP=startEnd.dot(startP),t=startEnd_startP/startEnd2;return clampToLine&&(t=THREE.Math.clamp(t,0,1)),t}}(),closestPointToPoint:function(point,clampToLine,optionalTarget){var t=this.closestPointToPointParameter(point,clampToLine),result=optionalTarget||new THREE.Vector3;return this.delta(result).multiplyScalar(t).add(this.start)},applyMatrix4:function(matrix){return this.start.applyMatrix4(matrix),this.end.applyMatrix4(matrix),this},equals:function(line){return line.start.equals(this.start)&&line.end.equals(this.end)}},THREE.Box2=function(min,max){this.min=void 0!==min?min:new THREE.Vector2(+(1/0),+(1/0)),this.max=void 0!==max?max:new THREE.Vector2(-(1/0),-(1/0))},THREE.Box2.prototype={constructor:THREE.Box2,set:function(min,max){return this.min.copy(min),this.max.copy(max),this},setFromPoints:function(points){this.makeEmpty();for(var i=0,il=points.length;il>i;i++)this.expandByPoint(points[i]);return this},setFromCenterAndSize:function(){var v1=new THREE.Vector2;return function(center,size){var halfSize=v1.copy(size).multiplyScalar(.5);return this.min.copy(center).sub(halfSize),this.max.copy(center).add(halfSize),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(box){return this.min.copy(box.min),this.max.copy(box.max),this},makeEmpty:function(){return this.min.x=this.min.y=+(1/0),this.max.x=this.max.y=-(1/0),this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y},center:function(optionalTarget){var result=optionalTarget||new THREE.Vector2;return result.addVectors(this.min,this.max).multiplyScalar(.5)},size:function(optionalTarget){var result=optionalTarget||new THREE.Vector2;return result.subVectors(this.max,this.min)},expandByPoint:function(point){return this.min.min(point),this.max.max(point),this},expandByVector:function(vector){return this.min.sub(vector),this.max.add(vector),this},expandByScalar:function(scalar){return this.min.addScalar(-scalar),this.max.addScalar(scalar),this},containsPoint:function(point){return!(point.x<this.min.x||point.x>this.max.x||point.y<this.min.y||point.y>this.max.y)},containsBox:function(box){return this.min.x<=box.min.x&&box.max.x<=this.max.x&&this.min.y<=box.min.y&&box.max.y<=this.max.y},getParameter:function(point,optionalTarget){var result=optionalTarget||new THREE.Vector2;return result.set((point.x-this.min.x)/(this.max.x-this.min.x),(point.y-this.min.y)/(this.max.y-this.min.y))},intersectsBox:function(box){return!(box.max.x<this.min.x||box.min.x>this.max.x||box.max.y<this.min.y||box.min.y>this.max.y)},clampPoint:function(point,optionalTarget){var result=optionalTarget||new THREE.Vector2;return result.copy(point).clamp(this.min,this.max)},distanceToPoint:function(){var v1=new THREE.Vector2;return function(point){var clampedPoint=v1.copy(point).clamp(this.min,this.max);return clampedPoint.sub(point).length()}}(),intersect:function(box){return this.min.max(box.min),this.max.min(box.max),this},union:function(box){return this.min.min(box.min),this.max.max(box.max),this},translate:function(offset){return this.min.add(offset),this.max.add(offset),this},equals:function(box){return box.min.equals(this.min)&&box.max.equals(this.max)}},THREE.Box3=function(min,max){this.min=void 0!==min?min:new THREE.Vector3(+(1/0),+(1/0),+(1/0)),this.max=void 0!==max?max:new THREE.Vector3(-(1/0),-(1/0),-(1/0))},THREE.Box3.prototype={constructor:THREE.Box3,set:function(min,max){return this.min.copy(min),this.max.copy(max),this},setFromArray:function(array){for(var minX=+(1/0),minY=+(1/0),minZ=+(1/0),maxX=-(1/0),maxY=-(1/0),maxZ=-(1/0),i=0,l=array.length;l>i;i+=3){var x=array[i],y=array[i+1],z=array[i+2];minX>x&&(minX=x),minY>y&&(minY=y),minZ>z&&(minZ=z),x>maxX&&(maxX=x),y>maxY&&(maxY=y),z>maxZ&&(maxZ=z)}this.min.set(minX,minY,minZ),this.max.set(maxX,maxY,maxZ)},setFromPoints:function(points){this.makeEmpty();for(var i=0,il=points.length;il>i;i++)this.expandByPoint(points[i]);return this},setFromCenterAndSize:function(){var v1=new THREE.Vector3;return function(center,size){var halfSize=v1.copy(size).multiplyScalar(.5);return this.min.copy(center).sub(halfSize),this.max.copy(center).add(halfSize),this}}(),setFromObject:function(){var v1=new THREE.Vector3;return function(object){var scope=this;return object.updateMatrixWorld(!0),this.makeEmpty(),object.traverse(function(node){var geometry=node.geometry;if(void 0!==geometry)if(geometry instanceof THREE.Geometry)for(var vertices=geometry.vertices,i=0,il=vertices.length;il>i;i++)v1.copy(vertices[i]),v1.applyMatrix4(node.matrixWorld),scope.expandByPoint(v1);else if(geometry instanceof THREE.BufferGeometry&&void 0!==geometry.attributes.position)for(var positions=geometry.attributes.position.array,i=0,il=positions.length;il>i;i+=3)v1.fromArray(positions,i),v1.applyMatrix4(node.matrixWorld),scope.expandByPoint(v1)}),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(box){return this.min.copy(box.min),this.max.copy(box.max),this},makeEmpty:function(){return this.min.x=this.min.y=this.min.z=+(1/0),this.max.x=this.max.y=this.max.z=-(1/0),this},isEmpty:function(){return this.max.x<this.min.x||this.max.y<this.min.y||this.max.z<this.min.z},center:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.addVectors(this.min,this.max).multiplyScalar(.5)},size:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.subVectors(this.max,this.min)},expandByPoint:function(point){return this.min.min(point),this.max.max(point),this},expandByVector:function(vector){return this.min.sub(vector),this.max.add(vector),this},expandByScalar:function(scalar){return this.min.addScalar(-scalar),this.max.addScalar(scalar),this},containsPoint:function(point){return!(point.x<this.min.x||point.x>this.max.x||point.y<this.min.y||point.y>this.max.y||point.z<this.min.z||point.z>this.max.z)},containsBox:function(box){return this.min.x<=box.min.x&&box.max.x<=this.max.x&&this.min.y<=box.min.y&&box.max.y<=this.max.y&&this.min.z<=box.min.z&&box.max.z<=this.max.z},getParameter:function(point,optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.set((point.x-this.min.x)/(this.max.x-this.min.x),(point.y-this.min.y)/(this.max.y-this.min.y),(point.z-this.min.z)/(this.max.z-this.min.z))},intersectsBox:function(box){return!(box.max.x<this.min.x||box.min.x>this.max.x||box.max.y<this.min.y||box.min.y>this.max.y||box.max.z<this.min.z||box.min.z>this.max.z)},intersectsSphere:function(){var closestPoint;return function(sphere){return void 0===closestPoint&&(closestPoint=new THREE.Vector3),this.clampPoint(sphere.center,closestPoint),closestPoint.distanceToSquared(sphere.center)<=sphere.radius*sphere.radius}}(),intersectsPlane:function(plane){var min,max;return plane.normal.x>0?(min=plane.normal.x*this.min.x,max=plane.normal.x*this.max.x):(min=plane.normal.x*this.max.x,max=plane.normal.x*this.min.x),plane.normal.y>0?(min+=plane.normal.y*this.min.y,max+=plane.normal.y*this.max.y):(min+=plane.normal.y*this.max.y,max+=plane.normal.y*this.min.y),plane.normal.z>0?(min+=plane.normal.z*this.min.z,max+=plane.normal.z*this.max.z):(min+=plane.normal.z*this.max.z,max+=plane.normal.z*this.min.z),min<=plane.constant&&max>=plane.constant},clampPoint:function(point,optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.copy(point).clamp(this.min,this.max)},distanceToPoint:function(){var v1=new THREE.Vector3;return function(point){var clampedPoint=v1.copy(point).clamp(this.min,this.max);return clampedPoint.sub(point).length()}}(),getBoundingSphere:function(){var v1=new THREE.Vector3;return function(optionalTarget){var result=optionalTarget||new THREE.Sphere;return result.center=this.center(),result.radius=.5*this.size(v1).length(),result}}(),intersect:function(box){return this.min.max(box.min),this.max.min(box.max),this.isEmpty()&&this.makeEmpty(),this},union:function(box){return this.min.min(box.min),this.max.max(box.max),this},applyMatrix4:function(){var points=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3,new THREE.Vector3];return function(matrix){return this.isEmpty()?this:(points[0].set(this.min.x,this.min.y,this.min.z).applyMatrix4(matrix),points[1].set(this.min.x,this.min.y,this.max.z).applyMatrix4(matrix),points[2].set(this.min.x,this.max.y,this.min.z).applyMatrix4(matrix),points[3].set(this.min.x,this.max.y,this.max.z).applyMatrix4(matrix),points[4].set(this.max.x,this.min.y,this.min.z).applyMatrix4(matrix),points[5].set(this.max.x,this.min.y,this.max.z).applyMatrix4(matrix),points[6].set(this.max.x,this.max.y,this.min.z).applyMatrix4(matrix),points[7].set(this.max.x,this.max.y,this.max.z).applyMatrix4(matrix),this.setFromPoints(points),this)}}(),translate:function(offset){return this.min.add(offset),this.max.add(offset),this},equals:function(box){return box.min.equals(this.min)&&box.max.equals(this.max)}},THREE.Matrix3=function(){this.elements=new Float32Array([1,0,0,0,1,0,0,0,1]),arguments.length>0&&console.error("THREE.Matrix3: the constructor no longer reads arguments. use .set() instead.")},THREE.Matrix3.prototype={constructor:THREE.Matrix3,set:function(n11,n12,n13,n21,n22,n23,n31,n32,n33){var te=this.elements;return te[0]=n11,te[1]=n21,te[2]=n31,te[3]=n12,te[4]=n22,te[5]=n32,te[6]=n13,te[7]=n23,te[8]=n33,this},identity:function(){return this.set(1,0,0,0,1,0,0,0,1),this},clone:function(){return(new this.constructor).fromArray(this.elements)},copy:function(m){var me=m.elements;return this.set(me[0],me[3],me[6],me[1],me[4],me[7],me[2],me[5],me[8]),this},setFromMatrix4:function(m){var me=m.elements;return this.set(me[0],me[4],me[8],me[1],me[5],me[9],me[2],me[6],me[10]),this},applyToVector3Array:function(){var v1;return function(array,offset,length){void 0===v1&&(v1=new THREE.Vector3),void 0===offset&&(offset=0),void 0===length&&(length=array.length);for(var i=0,j=offset;length>i;i+=3,j+=3)v1.fromArray(array,j),v1.applyMatrix3(this),v1.toArray(array,j);return array}}(),applyToBuffer:function(){var v1;return function(buffer,offset,length){void 0===v1&&(v1=new THREE.Vector3),void 0===offset&&(offset=0),void 0===length&&(length=buffer.length/buffer.itemSize);for(var i=0,j=offset;length>i;i++,j++)v1.x=buffer.getX(j),v1.y=buffer.getY(j),v1.z=buffer.getZ(j),v1.applyMatrix3(this),buffer.setXYZ(v1.x,v1.y,v1.z);return buffer}}(),multiplyScalar:function(s){var te=this.elements;return te[0]*=s,te[3]*=s,te[6]*=s,te[1]*=s,te[4]*=s,te[7]*=s,te[2]*=s,te[5]*=s,te[8]*=s,this},determinant:function(){var te=this.elements,a=te[0],b=te[1],c=te[2],d=te[3],e=te[4],f=te[5],g=te[6],h=te[7],i=te[8];return a*e*i-a*f*h-b*d*i+b*f*g+c*d*h-c*e*g},getInverse:function(matrix,throwOnDegenerate){matrix instanceof THREE.Matrix4&&console.error("THREE.Matrix3.getInverse no longer takes a Matrix4 argument.");var me=matrix.elements,te=this.elements,n11=me[0],n21=me[1],n31=me[2],n12=me[3],n22=me[4],n32=me[5],n13=me[6],n23=me[7],n33=me[8],t11=n33*n22-n32*n23,t12=n32*n13-n33*n12,t13=n23*n12-n22*n13,det=n11*t11+n21*t12+n31*t13;if(0===det){var msg="THREE.Matrix3.getInverse(): can't invert matrix, determinant is 0";if(throwOnDegenerate)throw new Error(msg);return console.warn(msg),this.identity()}return te[0]=t11,te[1]=n31*n23-n33*n21,te[2]=n32*n21-n31*n22,te[3]=t12,te[4]=n33*n11-n31*n13,te[5]=n31*n12-n32*n11,te[6]=t13,te[7]=n21*n13-n23*n11,te[8]=n22*n11-n21*n12,this.multiplyScalar(1/det)},transpose:function(){var tmp,m=this.elements;return tmp=m[1],m[1]=m[3],m[3]=tmp,tmp=m[2],m[2]=m[6],m[6]=tmp,tmp=m[5],m[5]=m[7],m[7]=tmp,this},flattenToArrayOffset:function(array,offset){return console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead."),this.toArray(array,offset)},getNormalMatrix:function(matrix4){return this.setFromMatrix4(matrix4).getInverse(this).transpose()},transposeIntoArray:function(r){var m=this.elements;return r[0]=m[0],r[1]=m[3],r[2]=m[6],r[3]=m[1],r[4]=m[4],r[5]=m[7],r[6]=m[2],r[7]=m[5],r[8]=m[8],this},fromArray:function(array){return this.elements.set(array),this},toArray:function(array,offset){void 0===array&&(array=[]),void 0===offset&&(offset=0);var te=this.elements;return array[offset]=te[0],array[offset+1]=te[1],array[offset+2]=te[2],array[offset+3]=te[3],array[offset+4]=te[4],array[offset+5]=te[5],array[offset+6]=te[6],array[offset+7]=te[7],array[offset+8]=te[8],array}},THREE.Matrix4=function(){this.elements=new Float32Array([1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1]),arguments.length>0&&console.error("THREE.Matrix4: the constructor no longer reads arguments. use .set() instead.")},THREE.Matrix4.prototype={constructor:THREE.Matrix4,set:function(n11,n12,n13,n14,n21,n22,n23,n24,n31,n32,n33,n34,n41,n42,n43,n44){var te=this.elements;return te[0]=n11,te[4]=n12,te[8]=n13,te[12]=n14,te[1]=n21,te[5]=n22,te[9]=n23,te[13]=n24,te[2]=n31,te[6]=n32,te[10]=n33,te[14]=n34,te[3]=n41,te[7]=n42,te[11]=n43,te[15]=n44,this},identity:function(){return this.set(1,0,0,0,0,1,0,0,0,0,1,0,0,0,0,1),this},clone:function(){return(new THREE.Matrix4).fromArray(this.elements)},copy:function(m){return this.elements.set(m.elements),this},copyPosition:function(m){var te=this.elements,me=m.elements;return te[12]=me[12],te[13]=me[13],te[14]=me[14],this},extractBasis:function(xAxis,yAxis,zAxis){return xAxis.setFromMatrixColumn(this,0),yAxis.setFromMatrixColumn(this,1),zAxis.setFromMatrixColumn(this,2),this},makeBasis:function(xAxis,yAxis,zAxis){return this.set(xAxis.x,yAxis.x,zAxis.x,0,xAxis.y,yAxis.y,zAxis.y,0,xAxis.z,yAxis.z,zAxis.z,0,0,0,0,1),this},extractRotation:function(){var v1;return function(m){void 0===v1&&(v1=new THREE.Vector3);var te=this.elements,me=m.elements,scaleX=1/v1.setFromMatrixColumn(m,0).length(),scaleY=1/v1.setFromMatrixColumn(m,1).length(),scaleZ=1/v1.setFromMatrixColumn(m,2).length();return te[0]=me[0]*scaleX,te[1]=me[1]*scaleX,te[2]=me[2]*scaleX,te[4]=me[4]*scaleY,te[5]=me[5]*scaleY,te[6]=me[6]*scaleY,te[8]=me[8]*scaleZ,te[9]=me[9]*scaleZ,te[10]=me[10]*scaleZ,this}}(),makeRotationFromEuler:function(euler){euler instanceof THREE.Euler==!1&&console.error("THREE.Matrix: .makeRotationFromEuler() now expects a Euler rotation rather than a Vector3 and order.");var te=this.elements,x=euler.x,y=euler.y,z=euler.z,a=Math.cos(x),b=Math.sin(x),c=Math.cos(y),d=Math.sin(y),e=Math.cos(z),f=Math.sin(z);if("XYZ"===euler.order){var ae=a*e,af=a*f,be=b*e,bf=b*f;te[0]=c*e,te[4]=-c*f,te[8]=d,te[1]=af+be*d,te[5]=ae-bf*d,te[9]=-b*c,te[2]=bf-ae*d,te[6]=be+af*d,te[10]=a*c}else if("YXZ"===euler.order){var ce=c*e,cf=c*f,de=d*e,df=d*f;te[0]=ce+df*b,te[4]=de*b-cf,te[8]=a*d,te[1]=a*f,te[5]=a*e,te[9]=-b,te[2]=cf*b-de,te[6]=df+ce*b,te[10]=a*c}else if("ZXY"===euler.order){var ce=c*e,cf=c*f,de=d*e,df=d*f;te[0]=ce-df*b,te[4]=-a*f,te[8]=de+cf*b,te[1]=cf+de*b,te[5]=a*e,te[9]=df-ce*b,te[2]=-a*d,te[6]=b,te[10]=a*c}else if("ZYX"===euler.order){var ae=a*e,af=a*f,be=b*e,bf=b*f;te[0]=c*e,te[4]=be*d-af,te[8]=ae*d+bf,te[1]=c*f,te[5]=bf*d+ae,te[9]=af*d-be,te[2]=-d,te[6]=b*c,te[10]=a*c}else if("YZX"===euler.order){var ac=a*c,ad=a*d,bc=b*c,bd=b*d;te[0]=c*e,te[4]=bd-ac*f,te[8]=bc*f+ad,te[1]=f,te[5]=a*e,te[9]=-b*e,te[2]=-d*e,te[6]=ad*f+bc,te[10]=ac-bd*f}else if("XZY"===euler.order){var ac=a*c,ad=a*d,bc=b*c,bd=b*d;te[0]=c*e,te[4]=-f,te[8]=d*e,te[1]=ac*f+bd,te[5]=a*e,te[9]=ad*f-bc,te[2]=bc*f-ad,te[6]=b*e,te[10]=bd*f+ac}return te[3]=0,te[7]=0,te[11]=0,te[12]=0,te[13]=0,te[14]=0,te[15]=1,this},makeRotationFromQuaternion:function(q){var te=this.elements,x=q.x,y=q.y,z=q.z,w=q.w,x2=x+x,y2=y+y,z2=z+z,xx=x*x2,xy=x*y2,xz=x*z2,yy=y*y2,yz=y*z2,zz=z*z2,wx=w*x2,wy=w*y2,wz=w*z2;return te[0]=1-(yy+zz),te[4]=xy-wz,te[8]=xz+wy,te[1]=xy+wz,te[5]=1-(xx+zz),te[9]=yz-wx,te[2]=xz-wy,te[6]=yz+wx,te[10]=1-(xx+yy),te[3]=0,te[7]=0,te[11]=0,te[12]=0,te[13]=0,te[14]=0,te[15]=1,this},lookAt:function(){var x,y,z;return function(eye,target,up){void 0===x&&(x=new THREE.Vector3),void 0===y&&(y=new THREE.Vector3),void 0===z&&(z=new THREE.Vector3);var te=this.elements;return z.subVectors(eye,target).normalize(),0===z.lengthSq()&&(z.z=1),x.crossVectors(up,z).normalize(),0===x.lengthSq()&&(z.x+=1e-4,x.crossVectors(up,z).normalize()),y.crossVectors(z,x),te[0]=x.x,te[4]=y.x,te[8]=z.x,te[1]=x.y,te[5]=y.y,te[9]=z.y,te[2]=x.z,te[6]=y.z,te[10]=z.z,this}}(),multiply:function(m,n){return void 0!==n?(console.warn("THREE.Matrix4: .multiply() now only accepts one argument. Use .multiplyMatrices( a, b ) instead."),this.multiplyMatrices(m,n)):this.multiplyMatrices(this,m)},premultiply:function(m){return this.multiplyMatrices(m,this)},multiplyMatrices:function(a,b){var ae=a.elements,be=b.elements,te=this.elements,a11=ae[0],a12=ae[4],a13=ae[8],a14=ae[12],a21=ae[1],a22=ae[5],a23=ae[9],a24=ae[13],a31=ae[2],a32=ae[6],a33=ae[10],a34=ae[14],a41=ae[3],a42=ae[7],a43=ae[11],a44=ae[15],b11=be[0],b12=be[4],b13=be[8],b14=be[12],b21=be[1],b22=be[5],b23=be[9],b24=be[13],b31=be[2],b32=be[6],b33=be[10],b34=be[14],b41=be[3],b42=be[7],b43=be[11],b44=be[15];return te[0]=a11*b11+a12*b21+a13*b31+a14*b41,te[4]=a11*b12+a12*b22+a13*b32+a14*b42,te[8]=a11*b13+a12*b23+a13*b33+a14*b43,te[12]=a11*b14+a12*b24+a13*b34+a14*b44,te[1]=a21*b11+a22*b21+a23*b31+a24*b41,te[5]=a21*b12+a22*b22+a23*b32+a24*b42,te[9]=a21*b13+a22*b23+a23*b33+a24*b43,te[13]=a21*b14+a22*b24+a23*b34+a24*b44,te[2]=a31*b11+a32*b21+a33*b31+a34*b41,te[6]=a31*b12+a32*b22+a33*b32+a34*b42,te[10]=a31*b13+a32*b23+a33*b33+a34*b43,te[14]=a31*b14+a32*b24+a33*b34+a34*b44,te[3]=a41*b11+a42*b21+a43*b31+a44*b41,te[7]=a41*b12+a42*b22+a43*b32+a44*b42,te[11]=a41*b13+a42*b23+a43*b33+a44*b43,te[15]=a41*b14+a42*b24+a43*b34+a44*b44,this},multiplyToArray:function(a,b,r){var te=this.elements;return this.multiplyMatrices(a,b),r[0]=te[0],r[1]=te[1],r[2]=te[2],r[3]=te[3],r[4]=te[4],r[5]=te[5],r[6]=te[6],r[7]=te[7],r[8]=te[8],r[9]=te[9],r[10]=te[10],r[11]=te[11],r[12]=te[12],r[13]=te[13],r[14]=te[14],r[15]=te[15],this},multiplyScalar:function(s){var te=this.elements;return te[0]*=s,te[4]*=s,te[8]*=s,te[12]*=s,te[1]*=s,te[5]*=s,te[9]*=s,te[13]*=s,te[2]*=s,te[6]*=s,te[10]*=s,te[14]*=s,te[3]*=s,te[7]*=s,te[11]*=s,te[15]*=s,this},applyToVector3Array:function(){var v1;return function(array,offset,length){void 0===v1&&(v1=new THREE.Vector3),void 0===offset&&(offset=0),void 0===length&&(length=array.length);for(var i=0,j=offset;length>i;i+=3,j+=3)v1.fromArray(array,j),v1.applyMatrix4(this),v1.toArray(array,j);return array}}(),applyToBuffer:function(){var v1;return function(buffer,offset,length){void 0===v1&&(v1=new THREE.Vector3),void 0===offset&&(offset=0),void 0===length&&(length=buffer.length/buffer.itemSize);for(var i=0,j=offset;length>i;i++,j++)v1.x=buffer.getX(j),v1.y=buffer.getY(j),v1.z=buffer.getZ(j),v1.applyMatrix4(this),buffer.setXYZ(v1.x,v1.y,v1.z);return buffer}}(),determinant:function(){var te=this.elements,n11=te[0],n12=te[4],n13=te[8],n14=te[12],n21=te[1],n22=te[5],n23=te[9],n24=te[13],n31=te[2],n32=te[6],n33=te[10],n34=te[14],n41=te[3],n42=te[7],n43=te[11],n44=te[15];return n41*(+n14*n23*n32-n13*n24*n32-n14*n22*n33+n12*n24*n33+n13*n22*n34-n12*n23*n34)+n42*(+n11*n23*n34-n11*n24*n33+n14*n21*n33-n13*n21*n34+n13*n24*n31-n14*n23*n31)+n43*(+n11*n24*n32-n11*n22*n34-n14*n21*n32+n12*n21*n34+n14*n22*n31-n12*n24*n31)+n44*(-n13*n22*n31-n11*n23*n32+n11*n22*n33+n13*n21*n32-n12*n21*n33+n12*n23*n31)},transpose:function(){var tmp,te=this.elements;return tmp=te[1],te[1]=te[4],te[4]=tmp,tmp=te[2],te[2]=te[8],te[8]=tmp,tmp=te[6],te[6]=te[9],te[9]=tmp,tmp=te[3],te[3]=te[12],te[12]=tmp,tmp=te[7],te[7]=te[13],te[13]=tmp,tmp=te[11],te[11]=te[14],te[14]=tmp,this},flattenToArrayOffset:function(array,offset){return console.warn("THREE.Matrix3: .flattenToArrayOffset is deprecated - just use .toArray instead."),this.toArray(array,offset)},getPosition:function(){var v1;return function(){return void 0===v1&&(v1=new THREE.Vector3),console.warn("THREE.Matrix4: .getPosition() has been removed. Use Vector3.setFromMatrixPosition( matrix ) instead."),v1.setFromMatrixColumn(this,3)}}(),setPosition:function(v){var te=this.elements;return te[12]=v.x,te[13]=v.y,te[14]=v.z,this},getInverse:function(m,throwOnDegenerate){var te=this.elements,me=m.elements,n11=me[0],n21=me[1],n31=me[2],n41=me[3],n12=me[4],n22=me[5],n32=me[6],n42=me[7],n13=me[8],n23=me[9],n33=me[10],n43=me[11],n14=me[12],n24=me[13],n34=me[14],n44=me[15],t11=n23*n34*n42-n24*n33*n42+n24*n32*n43-n22*n34*n43-n23*n32*n44+n22*n33*n44,t12=n14*n33*n42-n13*n34*n42-n14*n32*n43+n12*n34*n43+n13*n32*n44-n12*n33*n44,t13=n13*n24*n42-n14*n23*n42+n14*n22*n43-n12*n24*n43-n13*n22*n44+n12*n23*n44,t14=n14*n23*n32-n13*n24*n32-n14*n22*n33+n12*n24*n33+n13*n22*n34-n12*n23*n34,det=n11*t11+n21*t12+n31*t13+n41*t14;if(0===det){var msg="THREE.Matrix4.getInverse(): can't invert matrix, determinant is 0";if(throwOnDegenerate)throw new Error(msg);return console.warn(msg),this.identity()}return te[0]=t11,te[1]=n24*n33*n41-n23*n34*n41-n24*n31*n43+n21*n34*n43+n23*n31*n44-n21*n33*n44,
te[2]=n22*n34*n41-n24*n32*n41+n24*n31*n42-n21*n34*n42-n22*n31*n44+n21*n32*n44,te[3]=n23*n32*n41-n22*n33*n41-n23*n31*n42+n21*n33*n42+n22*n31*n43-n21*n32*n43,te[4]=t12,te[5]=n13*n34*n41-n14*n33*n41+n14*n31*n43-n11*n34*n43-n13*n31*n44+n11*n33*n44,te[6]=n14*n32*n41-n12*n34*n41-n14*n31*n42+n11*n34*n42+n12*n31*n44-n11*n32*n44,te[7]=n12*n33*n41-n13*n32*n41+n13*n31*n42-n11*n33*n42-n12*n31*n43+n11*n32*n43,te[8]=t13,te[9]=n14*n23*n41-n13*n24*n41-n14*n21*n43+n11*n24*n43+n13*n21*n44-n11*n23*n44,te[10]=n12*n24*n41-n14*n22*n41+n14*n21*n42-n11*n24*n42-n12*n21*n44+n11*n22*n44,te[11]=n13*n22*n41-n12*n23*n41-n13*n21*n42+n11*n23*n42+n12*n21*n43-n11*n22*n43,te[12]=t14,te[13]=n13*n24*n31-n14*n23*n31+n14*n21*n33-n11*n24*n33-n13*n21*n34+n11*n23*n34,te[14]=n14*n22*n31-n12*n24*n31-n14*n21*n32+n11*n24*n32+n12*n21*n34-n11*n22*n34,te[15]=n12*n23*n31-n13*n22*n31+n13*n21*n32-n11*n23*n32-n12*n21*n33+n11*n22*n33,this.multiplyScalar(1/det)},scale:function(v){var te=this.elements,x=v.x,y=v.y,z=v.z;return te[0]*=x,te[4]*=y,te[8]*=z,te[1]*=x,te[5]*=y,te[9]*=z,te[2]*=x,te[6]*=y,te[10]*=z,te[3]*=x,te[7]*=y,te[11]*=z,this},getMaxScaleOnAxis:function(){var te=this.elements,scaleXSq=te[0]*te[0]+te[1]*te[1]+te[2]*te[2],scaleYSq=te[4]*te[4]+te[5]*te[5]+te[6]*te[6],scaleZSq=te[8]*te[8]+te[9]*te[9]+te[10]*te[10];return Math.sqrt(Math.max(scaleXSq,scaleYSq,scaleZSq))},makeTranslation:function(x,y,z){return this.set(1,0,0,x,0,1,0,y,0,0,1,z,0,0,0,1),this},makeRotationX:function(theta){var c=Math.cos(theta),s=Math.sin(theta);return this.set(1,0,0,0,0,c,-s,0,0,s,c,0,0,0,0,1),this},makeRotationY:function(theta){var c=Math.cos(theta),s=Math.sin(theta);return this.set(c,0,s,0,0,1,0,0,-s,0,c,0,0,0,0,1),this},makeRotationZ:function(theta){var c=Math.cos(theta),s=Math.sin(theta);return this.set(c,-s,0,0,s,c,0,0,0,0,1,0,0,0,0,1),this},makeRotationAxis:function(axis,angle){var c=Math.cos(angle),s=Math.sin(angle),t=1-c,x=axis.x,y=axis.y,z=axis.z,tx=t*x,ty=t*y;return this.set(tx*x+c,tx*y-s*z,tx*z+s*y,0,tx*y+s*z,ty*y+c,ty*z-s*x,0,tx*z-s*y,ty*z+s*x,t*z*z+c,0,0,0,0,1),this},makeScale:function(x,y,z){return this.set(x,0,0,0,0,y,0,0,0,0,z,0,0,0,0,1),this},compose:function(position,quaternion,scale){return this.makeRotationFromQuaternion(quaternion),this.scale(scale),this.setPosition(position),this},decompose:function(){var vector,matrix;return function(position,quaternion,scale){void 0===vector&&(vector=new THREE.Vector3),void 0===matrix&&(matrix=new THREE.Matrix4);var te=this.elements,sx=vector.set(te[0],te[1],te[2]).length(),sy=vector.set(te[4],te[5],te[6]).length(),sz=vector.set(te[8],te[9],te[10]).length(),det=this.determinant();0>det&&(sx=-sx),position.x=te[12],position.y=te[13],position.z=te[14],matrix.elements.set(this.elements);var invSX=1/sx,invSY=1/sy,invSZ=1/sz;return matrix.elements[0]*=invSX,matrix.elements[1]*=invSX,matrix.elements[2]*=invSX,matrix.elements[4]*=invSY,matrix.elements[5]*=invSY,matrix.elements[6]*=invSY,matrix.elements[8]*=invSZ,matrix.elements[9]*=invSZ,matrix.elements[10]*=invSZ,quaternion.setFromRotationMatrix(matrix),scale.x=sx,scale.y=sy,scale.z=sz,this}}(),makeFrustum:function(left,right,bottom,top,near,far){var te=this.elements,x=2*near/(right-left),y=2*near/(top-bottom),a=(right+left)/(right-left),b=(top+bottom)/(top-bottom),c=-(far+near)/(far-near),d=-2*far*near/(far-near);return te[0]=x,te[4]=0,te[8]=a,te[12]=0,te[1]=0,te[5]=y,te[9]=b,te[13]=0,te[2]=0,te[6]=0,te[10]=c,te[14]=d,te[3]=0,te[7]=0,te[11]=-1,te[15]=0,this},makePerspective:function(fov,aspect,near,far){var ymax=near*Math.tan(THREE.Math.DEG2RAD*fov*.5),ymin=-ymax,xmin=ymin*aspect,xmax=ymax*aspect;return this.makeFrustum(xmin,xmax,ymin,ymax,near,far)},makeOrthographic:function(left,right,top,bottom,near,far){var te=this.elements,w=1/(right-left),h=1/(top-bottom),p=1/(far-near),x=(right+left)*w,y=(top+bottom)*h,z=(far+near)*p;return te[0]=2*w,te[4]=0,te[8]=0,te[12]=-x,te[1]=0,te[5]=2*h,te[9]=0,te[13]=-y,te[2]=0,te[6]=0,te[10]=-2*p,te[14]=-z,te[3]=0,te[7]=0,te[11]=0,te[15]=1,this},equals:function(matrix){for(var te=this.elements,me=matrix.elements,i=0;16>i;i++)if(te[i]!==me[i])return!1;return!0},fromArray:function(array){return this.elements.set(array),this},toArray:function(array,offset){void 0===array&&(array=[]),void 0===offset&&(offset=0);var te=this.elements;return array[offset]=te[0],array[offset+1]=te[1],array[offset+2]=te[2],array[offset+3]=te[3],array[offset+4]=te[4],array[offset+5]=te[5],array[offset+6]=te[6],array[offset+7]=te[7],array[offset+8]=te[8],array[offset+9]=te[9],array[offset+10]=te[10],array[offset+11]=te[11],array[offset+12]=te[12],array[offset+13]=te[13],array[offset+14]=te[14],array[offset+15]=te[15],array}},THREE.Ray=function(origin,direction){this.origin=void 0!==origin?origin:new THREE.Vector3,this.direction=void 0!==direction?direction:new THREE.Vector3},THREE.Ray.prototype={constructor:THREE.Ray,set:function(origin,direction){return this.origin.copy(origin),this.direction.copy(direction),this},clone:function(){return(new this.constructor).copy(this)},copy:function(ray){return this.origin.copy(ray.origin),this.direction.copy(ray.direction),this},at:function(t,optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.copy(this.direction).multiplyScalar(t).add(this.origin)},lookAt:function(v){this.direction.copy(v).sub(this.origin).normalize()},recast:function(){var v1=new THREE.Vector3;return function(t){return this.origin.copy(this.at(t,v1)),this}}(),closestPointToPoint:function(point,optionalTarget){var result=optionalTarget||new THREE.Vector3;result.subVectors(point,this.origin);var directionDistance=result.dot(this.direction);return 0>directionDistance?result.copy(this.origin):result.copy(this.direction).multiplyScalar(directionDistance).add(this.origin)},distanceToPoint:function(point){return Math.sqrt(this.distanceSqToPoint(point))},distanceSqToPoint:function(){var v1=new THREE.Vector3;return function(point){var directionDistance=v1.subVectors(point,this.origin).dot(this.direction);return 0>directionDistance?this.origin.distanceToSquared(point):(v1.copy(this.direction).multiplyScalar(directionDistance).add(this.origin),v1.distanceToSquared(point))}}(),distanceSqToSegment:function(){var segCenter=new THREE.Vector3,segDir=new THREE.Vector3,diff=new THREE.Vector3;return function(v0,v1,optionalPointOnRay,optionalPointOnSegment){segCenter.copy(v0).add(v1).multiplyScalar(.5),segDir.copy(v1).sub(v0).normalize(),diff.copy(this.origin).sub(segCenter);var s0,s1,sqrDist,extDet,segExtent=.5*v0.distanceTo(v1),a01=-this.direction.dot(segDir),b0=diff.dot(this.direction),b1=-diff.dot(segDir),c=diff.lengthSq(),det=Math.abs(1-a01*a01);if(det>0)if(s0=a01*b1-b0,s1=a01*b0-b1,extDet=segExtent*det,s0>=0)if(s1>=-extDet)if(extDet>=s1){var invDet=1/det;s0*=invDet,s1*=invDet,sqrDist=s0*(s0+a01*s1+2*b0)+s1*(a01*s0+s1+2*b1)+c}else s1=segExtent,s0=Math.max(0,-(a01*s1+b0)),sqrDist=-s0*s0+s1*(s1+2*b1)+c;else s1=-segExtent,s0=Math.max(0,-(a01*s1+b0)),sqrDist=-s0*s0+s1*(s1+2*b1)+c;else-extDet>=s1?(s0=Math.max(0,-(-a01*segExtent+b0)),s1=s0>0?-segExtent:Math.min(Math.max(-segExtent,-b1),segExtent),sqrDist=-s0*s0+s1*(s1+2*b1)+c):extDet>=s1?(s0=0,s1=Math.min(Math.max(-segExtent,-b1),segExtent),sqrDist=s1*(s1+2*b1)+c):(s0=Math.max(0,-(a01*segExtent+b0)),s1=s0>0?segExtent:Math.min(Math.max(-segExtent,-b1),segExtent),sqrDist=-s0*s0+s1*(s1+2*b1)+c);else s1=a01>0?-segExtent:segExtent,s0=Math.max(0,-(a01*s1+b0)),sqrDist=-s0*s0+s1*(s1+2*b1)+c;return optionalPointOnRay&&optionalPointOnRay.copy(this.direction).multiplyScalar(s0).add(this.origin),optionalPointOnSegment&&optionalPointOnSegment.copy(segDir).multiplyScalar(s1).add(segCenter),sqrDist}}(),intersectSphere:function(){var v1=new THREE.Vector3;return function(sphere,optionalTarget){v1.subVectors(sphere.center,this.origin);var tca=v1.dot(this.direction),d2=v1.dot(v1)-tca*tca,radius2=sphere.radius*sphere.radius;if(d2>radius2)return null;var thc=Math.sqrt(radius2-d2),t0=tca-thc,t1=tca+thc;return 0>t0&&0>t1?null:0>t0?this.at(t1,optionalTarget):this.at(t0,optionalTarget)}}(),intersectsSphere:function(sphere){return this.distanceToPoint(sphere.center)<=sphere.radius},distanceToPlane:function(plane){var denominator=plane.normal.dot(this.direction);if(0===denominator)return 0===plane.distanceToPoint(this.origin)?0:null;var t=-(this.origin.dot(plane.normal)+plane.constant)/denominator;return t>=0?t:null},intersectPlane:function(plane,optionalTarget){var t=this.distanceToPlane(plane);return null===t?null:this.at(t,optionalTarget)},intersectsPlane:function(plane){var distToPoint=plane.distanceToPoint(this.origin);if(0===distToPoint)return!0;var denominator=plane.normal.dot(this.direction);return 0>denominator*distToPoint},intersectBox:function(box,optionalTarget){var tmin,tmax,tymin,tymax,tzmin,tzmax,invdirx=1/this.direction.x,invdiry=1/this.direction.y,invdirz=1/this.direction.z,origin=this.origin;return invdirx>=0?(tmin=(box.min.x-origin.x)*invdirx,tmax=(box.max.x-origin.x)*invdirx):(tmin=(box.max.x-origin.x)*invdirx,tmax=(box.min.x-origin.x)*invdirx),invdiry>=0?(tymin=(box.min.y-origin.y)*invdiry,tymax=(box.max.y-origin.y)*invdiry):(tymin=(box.max.y-origin.y)*invdiry,tymax=(box.min.y-origin.y)*invdiry),tmin>tymax||tymin>tmax?null:((tymin>tmin||tmin!==tmin)&&(tmin=tymin),(tmax>tymax||tmax!==tmax)&&(tmax=tymax),invdirz>=0?(tzmin=(box.min.z-origin.z)*invdirz,tzmax=(box.max.z-origin.z)*invdirz):(tzmin=(box.max.z-origin.z)*invdirz,tzmax=(box.min.z-origin.z)*invdirz),tmin>tzmax||tzmin>tmax?null:((tzmin>tmin||tmin!==tmin)&&(tmin=tzmin),(tmax>tzmax||tmax!==tmax)&&(tmax=tzmax),0>tmax?null:this.at(tmin>=0?tmin:tmax,optionalTarget)))},intersectsBox:function(){var v=new THREE.Vector3;return function(box){return null!==this.intersectBox(box,v)}}(),intersectTriangle:function(){var diff=new THREE.Vector3,edge1=new THREE.Vector3,edge2=new THREE.Vector3,normal=new THREE.Vector3;return function(a,b,c,backfaceCulling,optionalTarget){edge1.subVectors(b,a),edge2.subVectors(c,a),normal.crossVectors(edge1,edge2);var sign,DdN=this.direction.dot(normal);if(DdN>0){if(backfaceCulling)return null;sign=1}else{if(!(0>DdN))return null;sign=-1,DdN=-DdN}diff.subVectors(this.origin,a);var DdQxE2=sign*this.direction.dot(edge2.crossVectors(diff,edge2));if(0>DdQxE2)return null;var DdE1xQ=sign*this.direction.dot(edge1.cross(diff));if(0>DdE1xQ)return null;if(DdQxE2+DdE1xQ>DdN)return null;var QdN=-sign*diff.dot(normal);return 0>QdN?null:this.at(QdN/DdN,optionalTarget)}}(),applyMatrix4:function(matrix4){return this.direction.add(this.origin).applyMatrix4(matrix4),this.origin.applyMatrix4(matrix4),this.direction.sub(this.origin),this.direction.normalize(),this},equals:function(ray){return ray.origin.equals(this.origin)&&ray.direction.equals(this.direction)}},THREE.Sphere=function(center,radius){this.center=void 0!==center?center:new THREE.Vector3,this.radius=void 0!==radius?radius:0},THREE.Sphere.prototype={constructor:THREE.Sphere,set:function(center,radius){return this.center.copy(center),this.radius=radius,this},setFromPoints:function(){var box=new THREE.Box3;return function(points,optionalCenter){var center=this.center;void 0!==optionalCenter?center.copy(optionalCenter):box.setFromPoints(points).center(center);for(var maxRadiusSq=0,i=0,il=points.length;il>i;i++)maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(points[i]));return this.radius=Math.sqrt(maxRadiusSq),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(sphere){return this.center.copy(sphere.center),this.radius=sphere.radius,this},empty:function(){return this.radius<=0},containsPoint:function(point){return point.distanceToSquared(this.center)<=this.radius*this.radius},distanceToPoint:function(point){return point.distanceTo(this.center)-this.radius},intersectsSphere:function(sphere){var radiusSum=this.radius+sphere.radius;return sphere.center.distanceToSquared(this.center)<=radiusSum*radiusSum},intersectsBox:function(box){return box.intersectsSphere(this)},intersectsPlane:function(plane){return Math.abs(this.center.dot(plane.normal)-plane.constant)<=this.radius},clampPoint:function(point,optionalTarget){var deltaLengthSq=this.center.distanceToSquared(point),result=optionalTarget||new THREE.Vector3;return result.copy(point),deltaLengthSq>this.radius*this.radius&&(result.sub(this.center).normalize(),result.multiplyScalar(this.radius).add(this.center)),result},getBoundingBox:function(optionalTarget){var box=optionalTarget||new THREE.Box3;return box.set(this.center,this.center),box.expandByScalar(this.radius),box},applyMatrix4:function(matrix){return this.center.applyMatrix4(matrix),this.radius=this.radius*matrix.getMaxScaleOnAxis(),this},translate:function(offset){return this.center.add(offset),this},equals:function(sphere){return sphere.center.equals(this.center)&&sphere.radius===this.radius}},THREE.Frustum=function(p0,p1,p2,p3,p4,p5){this.planes=[void 0!==p0?p0:new THREE.Plane,void 0!==p1?p1:new THREE.Plane,void 0!==p2?p2:new THREE.Plane,void 0!==p3?p3:new THREE.Plane,void 0!==p4?p4:new THREE.Plane,void 0!==p5?p5:new THREE.Plane]},THREE.Frustum.prototype={constructor:THREE.Frustum,set:function(p0,p1,p2,p3,p4,p5){var planes=this.planes;return planes[0].copy(p0),planes[1].copy(p1),planes[2].copy(p2),planes[3].copy(p3),planes[4].copy(p4),planes[5].copy(p5),this},clone:function(){return(new this.constructor).copy(this)},copy:function(frustum){for(var planes=this.planes,i=0;6>i;i++)planes[i].copy(frustum.planes[i]);return this},setFromMatrix:function(m){var planes=this.planes,me=m.elements,me0=me[0],me1=me[1],me2=me[2],me3=me[3],me4=me[4],me5=me[5],me6=me[6],me7=me[7],me8=me[8],me9=me[9],me10=me[10],me11=me[11],me12=me[12],me13=me[13],me14=me[14],me15=me[15];return planes[0].setComponents(me3-me0,me7-me4,me11-me8,me15-me12).normalize(),planes[1].setComponents(me3+me0,me7+me4,me11+me8,me15+me12).normalize(),planes[2].setComponents(me3+me1,me7+me5,me11+me9,me15+me13).normalize(),planes[3].setComponents(me3-me1,me7-me5,me11-me9,me15-me13).normalize(),planes[4].setComponents(me3-me2,me7-me6,me11-me10,me15-me14).normalize(),planes[5].setComponents(me3+me2,me7+me6,me11+me10,me15+me14).normalize(),this},intersectsObject:function(){var sphere=new THREE.Sphere;return function(object){var geometry=object.geometry;return null===geometry.boundingSphere&&geometry.computeBoundingSphere(),sphere.copy(geometry.boundingSphere),sphere.applyMatrix4(object.matrixWorld),this.intersectsSphere(sphere)}}(),intersectsSphere:function(sphere){for(var planes=this.planes,center=sphere.center,negRadius=-sphere.radius,i=0;6>i;i++){var distance=planes[i].distanceToPoint(center);if(negRadius>distance)return!1}return!0},intersectsBox:function(){var p1=new THREE.Vector3,p2=new THREE.Vector3;return function(box){for(var planes=this.planes,i=0;6>i;i++){var plane=planes[i];p1.x=plane.normal.x>0?box.min.x:box.max.x,p2.x=plane.normal.x>0?box.max.x:box.min.x,p1.y=plane.normal.y>0?box.min.y:box.max.y,p2.y=plane.normal.y>0?box.max.y:box.min.y,p1.z=plane.normal.z>0?box.min.z:box.max.z,p2.z=plane.normal.z>0?box.max.z:box.min.z;var d1=plane.distanceToPoint(p1),d2=plane.distanceToPoint(p2);if(0>d1&&0>d2)return!1}return!0}}(),containsPoint:function(point){for(var planes=this.planes,i=0;6>i;i++)if(planes[i].distanceToPoint(point)<0)return!1;return!0}},THREE.Plane=function(normal,constant){this.normal=void 0!==normal?normal:new THREE.Vector3(1,0,0),this.constant=void 0!==constant?constant:0},THREE.Plane.prototype={constructor:THREE.Plane,set:function(normal,constant){return this.normal.copy(normal),this.constant=constant,this},setComponents:function(x,y,z,w){return this.normal.set(x,y,z),this.constant=w,this},setFromNormalAndCoplanarPoint:function(normal,point){return this.normal.copy(normal),this.constant=-point.dot(this.normal),this},setFromCoplanarPoints:function(){var v1=new THREE.Vector3,v2=new THREE.Vector3;return function(a,b,c){var normal=v1.subVectors(c,b).cross(v2.subVectors(a,b)).normalize();return this.setFromNormalAndCoplanarPoint(normal,a),this}}(),clone:function(){return(new this.constructor).copy(this)},copy:function(plane){return this.normal.copy(plane.normal),this.constant=plane.constant,this},normalize:function(){var inverseNormalLength=1/this.normal.length();return this.normal.multiplyScalar(inverseNormalLength),this.constant*=inverseNormalLength,this},negate:function(){return this.constant*=-1,this.normal.negate(),this},distanceToPoint:function(point){return this.normal.dot(point)+this.constant},distanceToSphere:function(sphere){return this.distanceToPoint(sphere.center)-sphere.radius},projectPoint:function(point,optionalTarget){return this.orthoPoint(point,optionalTarget).sub(point).negate()},orthoPoint:function(point,optionalTarget){var perpendicularMagnitude=this.distanceToPoint(point),result=optionalTarget||new THREE.Vector3;return result.copy(this.normal).multiplyScalar(perpendicularMagnitude)},intersectLine:function(){var v1=new THREE.Vector3;return function(line,optionalTarget){var result=optionalTarget||new THREE.Vector3,direction=line.delta(v1),denominator=this.normal.dot(direction);if(0!==denominator){var t=-(line.start.dot(this.normal)+this.constant)/denominator;if(!(0>t||t>1))return result.copy(direction).multiplyScalar(t).add(line.start)}else if(0===this.distanceToPoint(line.start))return result.copy(line.start)}}(),intersectsLine:function(line){var startSign=this.distanceToPoint(line.start),endSign=this.distanceToPoint(line.end);return 0>startSign&&endSign>0||0>endSign&&startSign>0},intersectsBox:function(box){return box.intersectsPlane(this)},intersectsSphere:function(sphere){return sphere.intersectsPlane(this)},coplanarPoint:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.copy(this.normal).multiplyScalar(-this.constant)},applyMatrix4:function(){var v1=new THREE.Vector3,m1=new THREE.Matrix3;return function(matrix,optionalNormalMatrix){var referencePoint=this.coplanarPoint(v1).applyMatrix4(matrix),normalMatrix=optionalNormalMatrix||m1.getNormalMatrix(matrix),normal=this.normal.applyMatrix3(normalMatrix).normalize();return this.constant=-referencePoint.dot(normal),this}}(),translate:function(offset){return this.constant=this.constant-offset.dot(this.normal),this},equals:function(plane){return plane.normal.equals(this.normal)&&plane.constant===this.constant}},THREE.Spherical=function(radius,phi,theta){return this.radius=void 0!==radius?radius:1,this.phi=void 0!==phi?phi:0,this.theta=void 0!==theta?theta:0,this},THREE.Spherical.prototype={constructor:THREE.Spherical,set:function(radius,phi,theta){this.radius=radius,this.phi=phi,this.theta=theta},clone:function(){return(new this.constructor).copy(this)},copy:function(other){return this.radius.copy(other.radius),this.phi.copy(other.phi),this.theta.copy(other.theta),this},makeSafe:function(){var EPS=1e-6;this.phi=Math.max(EPS,Math.min(Math.PI-EPS,this.phi))},setFromVector3:function(vec3){return this.radius=vec3.length(),0===this.radius?(this.theta=0,this.phi=0):(this.theta=Math.atan2(vec3.x,vec3.z),this.phi=Math.acos(THREE.Math.clamp(vec3.y/this.radius,-1,1))),this}},THREE.Math={DEG2RAD:Math.PI/180,RAD2DEG:180/Math.PI,generateUUID:function(){var r,chars="0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".split(""),uuid=new Array(36),rnd=0;return function(){for(var i=0;36>i;i++)8===i||13===i||18===i||23===i?uuid[i]="-":14===i?uuid[i]="4":(2>=rnd&&(rnd=33554432+16777216*Math.random()|0),r=15&rnd,rnd>>=4,uuid[i]=chars[19===i?3&r|8:r]);return uuid.join("")}}(),clamp:function(value,min,max){return Math.max(min,Math.min(max,value))},euclideanModulo:function(n,m){return(n%m+m)%m},mapLinear:function(x,a1,a2,b1,b2){return b1+(x-a1)*(b2-b1)/(a2-a1)},smoothstep:function(x,min,max){return min>=x?0:x>=max?1:(x=(x-min)/(max-min),x*x*(3-2*x))},smootherstep:function(x,min,max){return min>=x?0:x>=max?1:(x=(x-min)/(max-min),x*x*x*(x*(6*x-15)+10))},random16:function(){return console.warn("THREE.Math.random16() has been deprecated. Use Math.random() instead."),Math.random()},randInt:function(low,high){return low+Math.floor(Math.random()*(high-low+1))},randFloat:function(low,high){return low+Math.random()*(high-low)},randFloatSpread:function(range){return range*(.5-Math.random())},degToRad:function(degrees){return degrees*THREE.Math.DEG2RAD},radToDeg:function(radians){return radians*THREE.Math.RAD2DEG},isPowerOfTwo:function(value){return 0===(value&value-1)&&0!==value},nearestPowerOfTwo:function(value){return Math.pow(2,Math.round(Math.log(value)/Math.LN2))},nextPowerOfTwo:function(value){return value--,value|=value>>1,value|=value>>2,value|=value>>4,value|=value>>8,value|=value>>16,value++,value}},THREE.Spline=function(points){function interpolate(p0,p1,p2,p3,t,t2,t3){var v0=.5*(p2-p0),v1=.5*(p3-p1);return(2*(p1-p2)+v0+v1)*t3+(-3*(p1-p2)-2*v0-v1)*t2+v0*t+p1}this.points=points;var point,intPoint,weight,w2,w3,pa,pb,pc,pd,c=[],v3={x:0,y:0,z:0};this.initFromArray=function(a){this.points=[];for(var i=0;i<a.length;i++)this.points[i]={x:a[i][0],y:a[i][1],z:a[i][2]}},this.getPoint=function(k){return point=(this.points.length-1)*k,intPoint=Math.floor(point),weight=point-intPoint,c[0]=0===intPoint?intPoint:intPoint-1,c[1]=intPoint,c[2]=intPoint>this.points.length-2?this.points.length-1:intPoint+1,c[3]=intPoint>this.points.length-3?this.points.length-1:intPoint+2,pa=this.points[c[0]],pb=this.points[c[1]],pc=this.points[c[2]],pd=this.points[c[3]],w2=weight*weight,w3=weight*w2,v3.x=interpolate(pa.x,pb.x,pc.x,pd.x,weight,w2,w3),v3.y=interpolate(pa.y,pb.y,pc.y,pd.y,weight,w2,w3),v3.z=interpolate(pa.z,pb.z,pc.z,pd.z,weight,w2,w3),v3},this.getControlPointsArray=function(){var i,p,l=this.points.length,coords=[];for(i=0;l>i;i++)p=this.points[i],coords[i]=[p.x,p.y,p.z];return coords},this.getLength=function(nSubDivisions){var i,index,nSamples,position,point=0,intPoint=0,oldIntPoint=0,oldPosition=new THREE.Vector3,tmpVec=new THREE.Vector3,chunkLengths=[],totalLength=0;for(chunkLengths[0]=0,nSubDivisions||(nSubDivisions=100),nSamples=this.points.length*nSubDivisions,oldPosition.copy(this.points[0]),i=1;nSamples>i;i++)index=i/nSamples,position=this.getPoint(index),tmpVec.copy(position),totalLength+=tmpVec.distanceTo(oldPosition),oldPosition.copy(position),point=(this.points.length-1)*index,intPoint=Math.floor(point),intPoint!==oldIntPoint&&(chunkLengths[intPoint]=totalLength,oldIntPoint=intPoint);return chunkLengths[chunkLengths.length]=totalLength,{chunks:chunkLengths,total:totalLength}},this.reparametrizeByArcLength=function(samplingCoef){var i,j,index,indexCurrent,indexNext,realDistance,sampling,position,newpoints=[],tmpVec=new THREE.Vector3,sl=this.getLength();for(newpoints.push(tmpVec.copy(this.points[0]).clone()),i=1;i<this.points.length;i++){for(realDistance=sl.chunks[i]-sl.chunks[i-1],sampling=Math.ceil(samplingCoef*realDistance/sl.total),indexCurrent=(i-1)/(this.points.length-1),indexNext=i/(this.points.length-1),j=1;sampling-1>j;j++)index=indexCurrent+j*(1/sampling)*(indexNext-indexCurrent),position=this.getPoint(index),newpoints.push(tmpVec.copy(position).clone());newpoints.push(tmpVec.copy(this.points[i]).clone())}this.points=newpoints}},THREE.Triangle=function(a,b,c){this.a=void 0!==a?a:new THREE.Vector3,this.b=void 0!==b?b:new THREE.Vector3,this.c=void 0!==c?c:new THREE.Vector3},THREE.Triangle.normal=function(){var v0=new THREE.Vector3;return function(a,b,c,optionalTarget){var result=optionalTarget||new THREE.Vector3;result.subVectors(c,b),v0.subVectors(a,b),result.cross(v0);var resultLengthSq=result.lengthSq();return resultLengthSq>0?result.multiplyScalar(1/Math.sqrt(resultLengthSq)):result.set(0,0,0)}}(),THREE.Triangle.barycoordFromPoint=function(){var v0=new THREE.Vector3,v1=new THREE.Vector3,v2=new THREE.Vector3;return function(point,a,b,c,optionalTarget){v0.subVectors(c,a),v1.subVectors(b,a),v2.subVectors(point,a);var dot00=v0.dot(v0),dot01=v0.dot(v1),dot02=v0.dot(v2),dot11=v1.dot(v1),dot12=v1.dot(v2),denom=dot00*dot11-dot01*dot01,result=optionalTarget||new THREE.Vector3;if(0===denom)return result.set(-2,-1,-1);var invDenom=1/denom,u=(dot11*dot02-dot01*dot12)*invDenom,v=(dot00*dot12-dot01*dot02)*invDenom;return result.set(1-u-v,v,u)}}(),THREE.Triangle.containsPoint=function(){var v1=new THREE.Vector3;return function(point,a,b,c){var result=THREE.Triangle.barycoordFromPoint(point,a,b,c,v1);return result.x>=0&&result.y>=0&&result.x+result.y<=1}}(),THREE.Triangle.prototype={constructor:THREE.Triangle,set:function(a,b,c){return this.a.copy(a),this.b.copy(b),this.c.copy(c),this},setFromPointsAndIndices:function(points,i0,i1,i2){return this.a.copy(points[i0]),this.b.copy(points[i1]),this.c.copy(points[i2]),this},clone:function(){return(new this.constructor).copy(this)},copy:function(triangle){return this.a.copy(triangle.a),this.b.copy(triangle.b),this.c.copy(triangle.c),this},area:function(){var v0=new THREE.Vector3,v1=new THREE.Vector3;return function(){return v0.subVectors(this.c,this.b),v1.subVectors(this.a,this.b),.5*v0.cross(v1).length()}}(),midpoint:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return result.addVectors(this.a,this.b).add(this.c).multiplyScalar(1/3)},normal:function(optionalTarget){return THREE.Triangle.normal(this.a,this.b,this.c,optionalTarget)},plane:function(optionalTarget){var result=optionalTarget||new THREE.Plane;return result.setFromCoplanarPoints(this.a,this.b,this.c)},barycoordFromPoint:function(point,optionalTarget){return THREE.Triangle.barycoordFromPoint(point,this.a,this.b,this.c,optionalTarget)},containsPoint:function(point){return THREE.Triangle.containsPoint(point,this.a,this.b,this.c)},closestPointToPoint:function(){var plane,edgeList,projectedPoint,closestPoint;return function(point,optionalTarget){void 0===plane&&(plane=new THREE.Plane,edgeList=[new THREE.Line3,new THREE.Line3,new THREE.Line3],projectedPoint=new THREE.Vector3,closestPoint=new THREE.Vector3);var result=optionalTarget||new THREE.Vector3,minDistance=1/0;if(plane.setFromCoplanarPoints(this.a,this.b,this.c),plane.projectPoint(point,projectedPoint),this.containsPoint(projectedPoint)===!0)result.copy(projectedPoint);else{edgeList[0].set(this.a,this.b),edgeList[1].set(this.b,this.c),edgeList[2].set(this.c,this.a);for(var i=0;i<edgeList.length;i++){edgeList[i].closestPointToPoint(projectedPoint,!0,closestPoint);var distance=projectedPoint.distanceToSquared(closestPoint);minDistance>distance&&(minDistance=distance,result.copy(closestPoint))}}return result}}(),equals:function(triangle){return triangle.a.equals(this.a)&&triangle.b.equals(this.b)&&triangle.c.equals(this.c)}},THREE.Interpolant=function(parameterPositions,sampleValues,sampleSize,resultBuffer){this.parameterPositions=parameterPositions,this._cachedIndex=0,this.resultBuffer=void 0!==resultBuffer?resultBuffer:new sampleValues.constructor(sampleSize),this.sampleValues=sampleValues,this.valueSize=sampleSize},THREE.Interpolant.prototype={constructor:THREE.Interpolant,evaluate:function(t){var pp=this.parameterPositions,i1=this._cachedIndex,t1=pp[i1],t0=pp[i1-1];validate_interval:{seek:{var right;linear_scan:{forward_scan:if(!(t1>t)){for(var giveUpAt=i1+2;;){if(void 0===t1){if(t0>t)break forward_scan;return i1=pp.length,this._cachedIndex=i1,this.afterEnd_(i1-1,t,t0)}if(i1===giveUpAt)break;if(t0=t1,t1=pp[++i1],t1>t)break seek}right=pp.length;break linear_scan}{if(t>=t0)break validate_interval;var t1global=pp[1];t1global>t&&(i1=2,t0=t1global);for(var giveUpAt=i1-2;;){if(void 0===t0)return this._cachedIndex=0,this.beforeStart_(0,t,t1);if(i1===giveUpAt)break;if(t1=t0,t0=pp[--i1-1],t>=t0)break seek}right=i1,i1=0}}for(;right>i1;){var mid=i1+right>>>1;t<pp[mid]?right=mid:i1=mid+1}if(t1=pp[i1],t0=pp[i1-1],void 0===t0)return this._cachedIndex=0,this.beforeStart_(0,t,t1);if(void 0===t1)return i1=pp.length,this._cachedIndex=i1,this.afterEnd_(i1-1,t0,t)}this._cachedIndex=i1,this.intervalChanged_(i1,t0,t1)}return this.interpolate_(i1,t0,t,t1)},settings:null,DefaultSettings_:{},getSettings_:function(){return this.settings||this.DefaultSettings_},copySampleValue_:function(index){for(var result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,offset=index*stride,i=0;i!==stride;++i)result[i]=values[offset+i];return result},interpolate_:function(i1,t0,t,t1){throw new Error("call to abstract method")},intervalChanged_:function(i1,t0,t1){}},Object.assign(THREE.Interpolant.prototype,{beforeStart_:THREE.Interpolant.prototype.copySampleValue_,afterEnd_:THREE.Interpolant.prototype.copySampleValue_}),THREE.CubicInterpolant=function(parameterPositions,sampleValues,sampleSize,resultBuffer){THREE.Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer),this._weightPrev=-0,this._offsetPrev=-0,this._weightNext=-0,this._offsetNext=-0},THREE.CubicInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.CubicInterpolant,DefaultSettings_:{endingStart:THREE.ZeroCurvatureEnding,endingEnd:THREE.ZeroCurvatureEnding},intervalChanged_:function(i1,t0,t1){var pp=this.parameterPositions,iPrev=i1-2,iNext=i1+1,tPrev=pp[iPrev],tNext=pp[iNext];if(void 0===tPrev)switch(this.getSettings_().endingStart){case THREE.ZeroSlopeEnding:iPrev=i1,tPrev=2*t0-t1;break;case THREE.WrapAroundEnding:iPrev=pp.length-2,tPrev=t0+pp[iPrev]-pp[iPrev+1];break;default:iPrev=i1,tPrev=t1}if(void 0===tNext)switch(this.getSettings_().endingEnd){case THREE.ZeroSlopeEnding:iNext=i1,tNext=2*t1-t0;break;case THREE.WrapAroundEnding:iNext=1,tNext=t1+pp[1]-pp[0];break;default:iNext=i1-1,tNext=t0}var halfDt=.5*(t1-t0),stride=this.valueSize;this._weightPrev=halfDt/(t0-tPrev),this._weightNext=halfDt/(tNext-t1),this._offsetPrev=iPrev*stride,this._offsetNext=iNext*stride},interpolate_:function(i1,t0,t,t1){for(var result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,o1=i1*stride,o0=o1-stride,oP=this._offsetPrev,oN=this._offsetNext,wP=this._weightPrev,wN=this._weightNext,p=(t-t0)/(t1-t0),pp=p*p,ppp=pp*p,sP=-wP*ppp+2*wP*pp-wP*p,s0=(1+wP)*ppp+(-1.5-2*wP)*pp+(-.5+wP)*p+1,s1=(-1-wN)*ppp+(1.5+wN)*pp+.5*p,sN=wN*ppp-wN*pp,i=0;i!==stride;++i)result[i]=sP*values[oP+i]+s0*values[o0+i]+s1*values[o1+i]+sN*values[oN+i];return result}}),THREE.DiscreteInterpolant=function(parameterPositions,sampleValues,sampleSize,resultBuffer){THREE.Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer)},THREE.DiscreteInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.DiscreteInterpolant,interpolate_:function(i1,t0,t,t1){return this.copySampleValue_(i1-1)}}),THREE.LinearInterpolant=function(parameterPositions,sampleValues,sampleSize,resultBuffer){THREE.Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer)},THREE.LinearInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.LinearInterpolant,interpolate_:function(i1,t0,t,t1){for(var result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,offset1=i1*stride,offset0=offset1-stride,weight1=(t-t0)/(t1-t0),weight0=1-weight1,i=0;i!==stride;++i)result[i]=values[offset0+i]*weight0+values[offset1+i]*weight1;return result}}),THREE.QuaternionLinearInterpolant=function(parameterPositions,sampleValues,sampleSize,resultBuffer){THREE.Interpolant.call(this,parameterPositions,sampleValues,sampleSize,resultBuffer)},THREE.QuaternionLinearInterpolant.prototype=Object.assign(Object.create(THREE.Interpolant.prototype),{constructor:THREE.QuaternionLinearInterpolant,interpolate_:function(i1,t0,t,t1){for(var result=this.resultBuffer,values=this.sampleValues,stride=this.valueSize,offset=i1*stride,alpha=(t-t0)/(t1-t0),end=offset+stride;offset!==end;offset+=4)THREE.Quaternion.slerpFlat(result,0,values,offset-stride,values,offset,alpha);return result}}),THREE.Clock=function(autoStart){this.autoStart=void 0!==autoStart?autoStart:!0,this.startTime=0,this.oldTime=0,this.elapsedTime=0,this.running=!1},THREE.Clock.prototype={constructor:THREE.Clock,start:function(){this.startTime=(performance||Date).now(),this.oldTime=this.startTime,this.running=!0},stop:function(){this.getElapsedTime(),
this.running=!1},getElapsedTime:function(){return this.getDelta(),this.elapsedTime},getDelta:function(){var diff=0;if(this.autoStart&&!this.running&&this.start(),this.running){var newTime=(performance||Date).now();diff=(newTime-this.oldTime)/1e3,this.oldTime=newTime,this.elapsedTime+=diff}return diff}},THREE.EventDispatcher=function(){},THREE.EventDispatcher.prototype={constructor:THREE.EventDispatcher,apply:function(object){object.addEventListener=THREE.EventDispatcher.prototype.addEventListener,object.hasEventListener=THREE.EventDispatcher.prototype.hasEventListener,object.removeEventListener=THREE.EventDispatcher.prototype.removeEventListener,object.dispatchEvent=THREE.EventDispatcher.prototype.dispatchEvent},addEventListener:function(type,listener){void 0===this._listeners&&(this._listeners={});var listeners=this._listeners;void 0===listeners[type]&&(listeners[type]=[]),-1===listeners[type].indexOf(listener)&&listeners[type].push(listener)},hasEventListener:function(type,listener){if(void 0===this._listeners)return!1;var listeners=this._listeners;return void 0!==listeners[type]&&-1!==listeners[type].indexOf(listener)},removeEventListener:function(type,listener){if(void 0!==this._listeners){var listeners=this._listeners,listenerArray=listeners[type];if(void 0!==listenerArray){var index=listenerArray.indexOf(listener);-1!==index&&listenerArray.splice(index,1)}}},dispatchEvent:function(event){if(void 0!==this._listeners){var listeners=this._listeners,listenerArray=listeners[event.type];if(void 0!==listenerArray){event.target=this;for(var array=[],length=listenerArray.length,i=0;length>i;i++)array[i]=listenerArray[i];for(var i=0;length>i;i++)array[i].call(this,event)}}}},THREE.Layers=function(){this.mask=1},THREE.Layers.prototype={constructor:THREE.Layers,set:function(channel){this.mask=1<<channel},enable:function(channel){this.mask|=1<<channel},toggle:function(channel){this.mask^=1<<channel},disable:function(channel){this.mask&=~(1<<channel)},test:function(layers){return 0!==(this.mask&layers.mask)}},function(THREE){function ascSort(a,b){return a.distance-b.distance}function intersectObject(object,raycaster,intersects,recursive){if(object.visible!==!1&&(object.raycast(raycaster,intersects),recursive===!0))for(var children=object.children,i=0,l=children.length;l>i;i++)intersectObject(children[i],raycaster,intersects,!0)}THREE.Raycaster=function(origin,direction,near,far){this.ray=new THREE.Ray(origin,direction),this.near=near||0,this.far=far||1/0,this.params={Mesh:{},Line:{},LOD:{},Points:{threshold:1},Sprite:{}},Object.defineProperties(this.params,{PointCloud:{get:function(){return console.warn("THREE.Raycaster: params.PointCloud has been renamed to params.Points."),this.Points}}})},THREE.Raycaster.prototype={constructor:THREE.Raycaster,linePrecision:1,set:function(origin,direction){this.ray.set(origin,direction)},setFromCamera:function(coords,camera){camera instanceof THREE.PerspectiveCamera?(this.ray.origin.setFromMatrixPosition(camera.matrixWorld),this.ray.direction.set(coords.x,coords.y,.5).unproject(camera).sub(this.ray.origin).normalize()):camera instanceof THREE.OrthographicCamera?(this.ray.origin.set(coords.x,coords.y,-1).unproject(camera),this.ray.direction.set(0,0,-1).transformDirection(camera.matrixWorld)):console.error("THREE.Raycaster: Unsupported camera type.")},intersectObject:function(object,recursive){var intersects=[];return intersectObject(object,this,intersects,recursive),intersects.sort(ascSort),intersects},intersectObjects:function(objects,recursive){var intersects=[];if(Array.isArray(objects)===!1)return console.warn("THREE.Raycaster.intersectObjects: objects is not an Array."),intersects;for(var i=0,l=objects.length;l>i;i++)intersectObject(objects[i],this,intersects,recursive);return intersects.sort(ascSort),intersects}}}(THREE),THREE.Object3D=function(){function onRotationChange(){quaternion.setFromEuler(rotation,!1)}function onQuaternionChange(){rotation.setFromQuaternion(quaternion,void 0,!1)}Object.defineProperty(this,"id",{value:THREE.Object3DIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="Object3D",this.parent=null,this.children=[],this.up=THREE.Object3D.DefaultUp.clone();var position=new THREE.Vector3,rotation=new THREE.Euler,quaternion=new THREE.Quaternion,scale=new THREE.Vector3(1,1,1);rotation.onChange(onRotationChange),quaternion.onChange(onQuaternionChange),Object.defineProperties(this,{position:{enumerable:!0,value:position},rotation:{enumerable:!0,value:rotation},quaternion:{enumerable:!0,value:quaternion},scale:{enumerable:!0,value:scale},modelViewMatrix:{value:new THREE.Matrix4},normalMatrix:{value:new THREE.Matrix3}}),this.rotationAutoUpdate=!0,this.matrix=new THREE.Matrix4,this.matrixWorld=new THREE.Matrix4,this.matrixAutoUpdate=THREE.Object3D.DefaultMatrixAutoUpdate,this.matrixWorldNeedsUpdate=!1,this.layers=new THREE.Layers,this.visible=!0,this.castShadow=!1,this.receiveShadow=!1,this.frustumCulled=!0,this.renderOrder=0,this.userData={}},THREE.Object3D.DefaultUp=new THREE.Vector3(0,1,0),THREE.Object3D.DefaultMatrixAutoUpdate=!0,THREE.Object3D.prototype={constructor:THREE.Object3D,applyMatrix:function(matrix){this.matrix.multiplyMatrices(matrix,this.matrix),this.matrix.decompose(this.position,this.quaternion,this.scale)},setRotationFromAxisAngle:function(axis,angle){this.quaternion.setFromAxisAngle(axis,angle)},setRotationFromEuler:function(euler){this.quaternion.setFromEuler(euler,!0)},setRotationFromMatrix:function(m){this.quaternion.setFromRotationMatrix(m)},setRotationFromQuaternion:function(q){this.quaternion.copy(q)},rotateOnAxis:function(){var q1=new THREE.Quaternion;return function(axis,angle){return q1.setFromAxisAngle(axis,angle),this.quaternion.multiply(q1),this}}(),rotateX:function(){var v1=new THREE.Vector3(1,0,0);return function(angle){return this.rotateOnAxis(v1,angle)}}(),rotateY:function(){var v1=new THREE.Vector3(0,1,0);return function(angle){return this.rotateOnAxis(v1,angle)}}(),rotateZ:function(){var v1=new THREE.Vector3(0,0,1);return function(angle){return this.rotateOnAxis(v1,angle)}}(),translateOnAxis:function(){var v1=new THREE.Vector3;return function(axis,distance){return v1.copy(axis).applyQuaternion(this.quaternion),this.position.add(v1.multiplyScalar(distance)),this}}(),translateX:function(){var v1=new THREE.Vector3(1,0,0);return function(distance){return this.translateOnAxis(v1,distance)}}(),translateY:function(){var v1=new THREE.Vector3(0,1,0);return function(distance){return this.translateOnAxis(v1,distance)}}(),translateZ:function(){var v1=new THREE.Vector3(0,0,1);return function(distance){return this.translateOnAxis(v1,distance)}}(),localToWorld:function(vector){return vector.applyMatrix4(this.matrixWorld)},worldToLocal:function(){var m1=new THREE.Matrix4;return function(vector){return vector.applyMatrix4(m1.getInverse(this.matrixWorld))}}(),lookAt:function(){var m1=new THREE.Matrix4;return function(vector){m1.lookAt(vector,this.position,this.up),this.quaternion.setFromRotationMatrix(m1)}}(),add:function(object){if(arguments.length>1){for(var i=0;i<arguments.length;i++)this.add(arguments[i]);return this}return object===this?(console.error("THREE.Object3D.add: object can't be added as a child of itself.",object),this):(object instanceof THREE.Object3D?(null!==object.parent&&object.parent.remove(object),object.parent=this,object.dispatchEvent({type:"added"}),this.children.push(object)):console.error("THREE.Object3D.add: object not an instance of THREE.Object3D.",object),this)},remove:function(object){if(arguments.length>1)for(var i=0;i<arguments.length;i++)this.remove(arguments[i]);var index=this.children.indexOf(object);-1!==index&&(object.parent=null,object.dispatchEvent({type:"removed"}),this.children.splice(index,1))},getObjectById:function(id){return this.getObjectByProperty("id",id)},getObjectByName:function(name){return this.getObjectByProperty("name",name)},getObjectByProperty:function(name,value){if(this[name]===value)return this;for(var i=0,l=this.children.length;l>i;i++){var child=this.children[i],object=child.getObjectByProperty(name,value);if(void 0!==object)return object}},getWorldPosition:function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return this.updateMatrixWorld(!0),result.setFromMatrixPosition(this.matrixWorld)},getWorldQuaternion:function(){var position=new THREE.Vector3,scale=new THREE.Vector3;return function(optionalTarget){var result=optionalTarget||new THREE.Quaternion;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(position,result,scale),result}}(),getWorldRotation:function(){var quaternion=new THREE.Quaternion;return function(optionalTarget){var result=optionalTarget||new THREE.Euler;return this.getWorldQuaternion(quaternion),result.setFromQuaternion(quaternion,this.rotation.order,!1)}}(),getWorldScale:function(){var position=new THREE.Vector3,quaternion=new THREE.Quaternion;return function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return this.updateMatrixWorld(!0),this.matrixWorld.decompose(position,quaternion,result),result}}(),getWorldDirection:function(){var quaternion=new THREE.Quaternion;return function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return this.getWorldQuaternion(quaternion),result.set(0,0,1).applyQuaternion(quaternion)}}(),raycast:function(){},traverse:function(callback){callback(this);for(var children=this.children,i=0,l=children.length;l>i;i++)children[i].traverse(callback)},traverseVisible:function(callback){if(this.visible!==!1){callback(this);for(var children=this.children,i=0,l=children.length;l>i;i++)children[i].traverseVisible(callback)}},traverseAncestors:function(callback){var parent=this.parent;null!==parent&&(callback(parent),parent.traverseAncestors(callback))},updateMatrix:function(){this.matrix.compose(this.position,this.quaternion,this.scale),this.matrixWorldNeedsUpdate=!0},updateMatrixWorld:function(force){this.matrixAutoUpdate===!0&&this.updateMatrix(),this.matrixWorldNeedsUpdate!==!0&&force!==!0||(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.matrixWorldNeedsUpdate=!1,force=!0);for(var i=0,l=this.children.length;l>i;i++)this.children[i].updateMatrixWorld(force)},toJSON:function(meta){function extractFromCache(cache){var values=[];for(var key in cache){var data=cache[key];delete data.metadata,values.push(data)}return values}var isRootObject=void 0===meta||""===meta,output={};isRootObject&&(meta={geometries:{},materials:{},textures:{},images:{}},output.metadata={version:4.4,type:"Object",generator:"Object3D.toJSON"});var object={};if(object.uuid=this.uuid,object.type=this.type,""!==this.name&&(object.name=this.name),"{}"!==JSON.stringify(this.userData)&&(object.userData=this.userData),this.castShadow===!0&&(object.castShadow=!0),this.receiveShadow===!0&&(object.receiveShadow=!0),this.visible===!1&&(object.visible=!1),object.matrix=this.matrix.toArray(),void 0!==this.geometry&&(void 0===meta.geometries[this.geometry.uuid]&&(meta.geometries[this.geometry.uuid]=this.geometry.toJSON(meta)),object.geometry=this.geometry.uuid),void 0!==this.material&&(void 0===meta.materials[this.material.uuid]&&(meta.materials[this.material.uuid]=this.material.toJSON(meta)),object.material=this.material.uuid),this.children.length>0){object.children=[];for(var i=0;i<this.children.length;i++)object.children.push(this.children[i].toJSON(meta).object)}if(isRootObject){var geometries=extractFromCache(meta.geometries),materials=extractFromCache(meta.materials),textures=extractFromCache(meta.textures),images=extractFromCache(meta.images);geometries.length>0&&(output.geometries=geometries),materials.length>0&&(output.materials=materials),textures.length>0&&(output.textures=textures),images.length>0&&(output.images=images)}return output.object=object,output},clone:function(recursive){return(new this.constructor).copy(this,recursive)},copy:function(source,recursive){if(void 0===recursive&&(recursive=!0),this.name=source.name,this.up.copy(source.up),this.position.copy(source.position),this.quaternion.copy(source.quaternion),this.scale.copy(source.scale),this.rotationAutoUpdate=source.rotationAutoUpdate,this.matrix.copy(source.matrix),this.matrixWorld.copy(source.matrixWorld),this.matrixAutoUpdate=source.matrixAutoUpdate,this.matrixWorldNeedsUpdate=source.matrixWorldNeedsUpdate,this.visible=source.visible,this.castShadow=source.castShadow,this.receiveShadow=source.receiveShadow,this.frustumCulled=source.frustumCulled,this.renderOrder=source.renderOrder,this.userData=JSON.parse(JSON.stringify(source.userData)),recursive===!0)for(var i=0;i<source.children.length;i++){var child=source.children[i];this.add(child.clone())}return this}},THREE.EventDispatcher.prototype.apply(THREE.Object3D.prototype),THREE.Object3DIdCount=0,THREE.Face3=function(a,b,c,normal,color,materialIndex){this.a=a,this.b=b,this.c=c,this.normal=normal instanceof THREE.Vector3?normal:new THREE.Vector3,this.vertexNormals=Array.isArray(normal)?normal:[],this.color=color instanceof THREE.Color?color:new THREE.Color,this.vertexColors=Array.isArray(color)?color:[],this.materialIndex=void 0!==materialIndex?materialIndex:0},THREE.Face3.prototype={constructor:THREE.Face3,clone:function(){return(new this.constructor).copy(this)},copy:function(source){this.a=source.a,this.b=source.b,this.c=source.c,this.normal.copy(source.normal),this.color.copy(source.color),this.materialIndex=source.materialIndex;for(var i=0,il=source.vertexNormals.length;il>i;i++)this.vertexNormals[i]=source.vertexNormals[i].clone();for(var i=0,il=source.vertexColors.length;il>i;i++)this.vertexColors[i]=source.vertexColors[i].clone();return this}},THREE.BufferAttribute=function(array,itemSize,normalized){this.uuid=THREE.Math.generateUUID(),this.array=array,this.itemSize=itemSize,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.version=0,this.normalized=normalized===!0},THREE.BufferAttribute.prototype={constructor:THREE.BufferAttribute,get count(){return this.array.length/this.itemSize},set needsUpdate(value){value===!0&&this.version++},setDynamic:function(value){return this.dynamic=value,this},copy:function(source){return this.array=new source.array.constructor(source.array),this.itemSize=source.itemSize,this.dynamic=source.dynamic,this},copyAt:function(index1,attribute,index2){index1*=this.itemSize,index2*=attribute.itemSize;for(var i=0,l=this.itemSize;l>i;i++)this.array[index1+i]=attribute.array[index2+i];return this},copyArray:function(array){return this.array.set(array),this},copyColorsArray:function(colors){for(var array=this.array,offset=0,i=0,l=colors.length;l>i;i++){var color=colors[i];void 0===color&&(console.warn("THREE.BufferAttribute.copyColorsArray(): color is undefined",i),color=new THREE.Color),array[offset++]=color.r,array[offset++]=color.g,array[offset++]=color.b}return this},copyIndicesArray:function(indices){for(var array=this.array,offset=0,i=0,l=indices.length;l>i;i++){var index=indices[i];array[offset++]=index.a,array[offset++]=index.b,array[offset++]=index.c}return this},copyVector2sArray:function(vectors){for(var array=this.array,offset=0,i=0,l=vectors.length;l>i;i++){var vector=vectors[i];void 0===vector&&(console.warn("THREE.BufferAttribute.copyVector2sArray(): vector is undefined",i),vector=new THREE.Vector2),array[offset++]=vector.x,array[offset++]=vector.y}return this},copyVector3sArray:function(vectors){for(var array=this.array,offset=0,i=0,l=vectors.length;l>i;i++){var vector=vectors[i];void 0===vector&&(console.warn("THREE.BufferAttribute.copyVector3sArray(): vector is undefined",i),vector=new THREE.Vector3),array[offset++]=vector.x,array[offset++]=vector.y,array[offset++]=vector.z}return this},copyVector4sArray:function(vectors){for(var array=this.array,offset=0,i=0,l=vectors.length;l>i;i++){var vector=vectors[i];void 0===vector&&(console.warn("THREE.BufferAttribute.copyVector4sArray(): vector is undefined",i),vector=new THREE.Vector4),array[offset++]=vector.x,array[offset++]=vector.y,array[offset++]=vector.z,array[offset++]=vector.w}return this},set:function(value,offset){return void 0===offset&&(offset=0),this.array.set(value,offset),this},getX:function(index){return this.array[index*this.itemSize]},setX:function(index,x){return this.array[index*this.itemSize]=x,this},getY:function(index){return this.array[index*this.itemSize+1]},setY:function(index,y){return this.array[index*this.itemSize+1]=y,this},getZ:function(index){return this.array[index*this.itemSize+2]},setZ:function(index,z){return this.array[index*this.itemSize+2]=z,this},getW:function(index){return this.array[index*this.itemSize+3]},setW:function(index,w){return this.array[index*this.itemSize+3]=w,this},setXY:function(index,x,y){return index*=this.itemSize,this.array[index+0]=x,this.array[index+1]=y,this},setXYZ:function(index,x,y,z){return index*=this.itemSize,this.array[index+0]=x,this.array[index+1]=y,this.array[index+2]=z,this},setXYZW:function(index,x,y,z,w){return index*=this.itemSize,this.array[index+0]=x,this.array[index+1]=y,this.array[index+2]=z,this.array[index+3]=w,this},clone:function(){return(new this.constructor).copy(this)}},THREE.Int8Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Int8Array(array),itemSize)},THREE.Uint8Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Uint8Array(array),itemSize)},THREE.Uint8ClampedAttribute=function(array,itemSize){return new THREE.BufferAttribute(new Uint8ClampedArray(array),itemSize)},THREE.Int16Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Int16Array(array),itemSize)},THREE.Uint16Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Uint16Array(array),itemSize)},THREE.Int32Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Int32Array(array),itemSize)},THREE.Uint32Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Uint32Array(array),itemSize)},THREE.Float32Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Float32Array(array),itemSize)},THREE.Float64Attribute=function(array,itemSize){return new THREE.BufferAttribute(new Float64Array(array),itemSize)},THREE.DynamicBufferAttribute=function(array,itemSize){return console.warn("THREE.DynamicBufferAttribute has been removed. Use new THREE.BufferAttribute().setDynamic( true ) instead."),new THREE.BufferAttribute(array,itemSize).setDynamic(!0)},THREE.InstancedBufferAttribute=function(array,itemSize,meshPerAttribute){THREE.BufferAttribute.call(this,array,itemSize),this.meshPerAttribute=meshPerAttribute||1},THREE.InstancedBufferAttribute.prototype=Object.create(THREE.BufferAttribute.prototype),THREE.InstancedBufferAttribute.prototype.constructor=THREE.InstancedBufferAttribute,THREE.InstancedBufferAttribute.prototype.copy=function(source){return THREE.BufferAttribute.prototype.copy.call(this,source),this.meshPerAttribute=source.meshPerAttribute,this},THREE.InterleavedBuffer=function(array,stride){this.uuid=THREE.Math.generateUUID(),this.array=array,this.stride=stride,this.dynamic=!1,this.updateRange={offset:0,count:-1},this.version=0},THREE.InterleavedBuffer.prototype={constructor:THREE.InterleavedBuffer,get length(){return this.array.length},get count(){return this.array.length/this.stride},set needsUpdate(value){value===!0&&this.version++},setDynamic:function(value){return this.dynamic=value,this},copy:function(source){return this.array=new source.array.constructor(source.array),this.stride=source.stride,this.dynamic=source.dynamic,this},copyAt:function(index1,attribute,index2){index1*=this.stride,index2*=attribute.stride;for(var i=0,l=this.stride;l>i;i++)this.array[index1+i]=attribute.array[index2+i];return this},set:function(value,offset){return void 0===offset&&(offset=0),this.array.set(value,offset),this},clone:function(){return(new this.constructor).copy(this)}},THREE.InstancedInterleavedBuffer=function(array,stride,meshPerAttribute){THREE.InterleavedBuffer.call(this,array,stride),this.meshPerAttribute=meshPerAttribute||1},THREE.InstancedInterleavedBuffer.prototype=Object.create(THREE.InterleavedBuffer.prototype),THREE.InstancedInterleavedBuffer.prototype.constructor=THREE.InstancedInterleavedBuffer,THREE.InstancedInterleavedBuffer.prototype.copy=function(source){return THREE.InterleavedBuffer.prototype.copy.call(this,source),this.meshPerAttribute=source.meshPerAttribute,this},THREE.InterleavedBufferAttribute=function(interleavedBuffer,itemSize,offset){this.uuid=THREE.Math.generateUUID(),this.data=interleavedBuffer,this.itemSize=itemSize,this.offset=offset},THREE.InterleavedBufferAttribute.prototype={constructor:THREE.InterleavedBufferAttribute,get length(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Please use .count."),this.array.length},get count(){return this.data.count},setX:function(index,x){return this.data.array[index*this.data.stride+this.offset]=x,this},setY:function(index,y){return this.data.array[index*this.data.stride+this.offset+1]=y,this},setZ:function(index,z){return this.data.array[index*this.data.stride+this.offset+2]=z,this},setW:function(index,w){return this.data.array[index*this.data.stride+this.offset+3]=w,this},getX:function(index){return this.data.array[index*this.data.stride+this.offset]},getY:function(index){return this.data.array[index*this.data.stride+this.offset+1]},getZ:function(index){return this.data.array[index*this.data.stride+this.offset+2]},getW:function(index){return this.data.array[index*this.data.stride+this.offset+3]},setXY:function(index,x,y){return index=index*this.data.stride+this.offset,this.data.array[index+0]=x,this.data.array[index+1]=y,this},setXYZ:function(index,x,y,z){return index=index*this.data.stride+this.offset,this.data.array[index+0]=x,this.data.array[index+1]=y,this.data.array[index+2]=z,this},setXYZW:function(index,x,y,z,w){return index=index*this.data.stride+this.offset,this.data.array[index+0]=x,this.data.array[index+1]=y,this.data.array[index+2]=z,this.data.array[index+3]=w,this}},THREE.Geometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="Geometry",this.vertices=[],this.colors=[],this.faces=[],this.faceVertexUvs=[[]],this.morphTargets=[],this.morphNormals=[],this.skinWeights=[],this.skinIndices=[],this.lineDistances=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.elementsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.lineDistancesNeedUpdate=!1,this.groupsNeedUpdate=!1},THREE.Geometry.prototype={constructor:THREE.Geometry,applyMatrix:function(matrix){for(var normalMatrix=(new THREE.Matrix3).getNormalMatrix(matrix),i=0,il=this.vertices.length;il>i;i++){var vertex=this.vertices[i];vertex.applyMatrix4(matrix)}for(var i=0,il=this.faces.length;il>i;i++){var face=this.faces[i];face.normal.applyMatrix3(normalMatrix).normalize();for(var j=0,jl=face.vertexNormals.length;jl>j;j++)face.vertexNormals[j].applyMatrix3(normalMatrix).normalize()}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this.verticesNeedUpdate=!0,this.normalsNeedUpdate=!0,this},rotateX:function(){var m1;return function(angle){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeRotationX(angle),this.applyMatrix(m1),this}}(),rotateY:function(){var m1;return function(angle){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeRotationY(angle),this.applyMatrix(m1),this}}(),rotateZ:function(){var m1;return function(angle){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeRotationZ(angle),this.applyMatrix(m1),this}}(),translate:function(){var m1;return function(x,y,z){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeTranslation(x,y,z),this.applyMatrix(m1),this}}(),scale:function(){var m1;return function(x,y,z){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeScale(x,y,z),this.applyMatrix(m1),this}}(),lookAt:function(){var obj;return function(vector){void 0===obj&&(obj=new THREE.Object3D),obj.lookAt(vector),obj.updateMatrix(),this.applyMatrix(obj.matrix)}}(),fromBufferGeometry:function(geometry){function addFace(a,b,c,materialIndex){var vertexNormals=void 0!==normals?[tempNormals[a].clone(),tempNormals[b].clone(),tempNormals[c].clone()]:[],vertexColors=void 0!==colors?[scope.colors[a].clone(),scope.colors[b].clone(),scope.colors[c].clone()]:[],face=new THREE.Face3(a,b,c,vertexNormals,vertexColors,materialIndex);scope.faces.push(face),void 0!==uvs&&scope.faceVertexUvs[0].push([tempUVs[a].clone(),tempUVs[b].clone(),tempUVs[c].clone()]),void 0!==uvs2&&scope.faceVertexUvs[1].push([tempUVs2[a].clone(),tempUVs2[b].clone(),tempUVs2[c].clone()])}var scope=this,indices=null!==geometry.index?geometry.index.array:void 0,attributes=geometry.attributes,positions=attributes.position.array,normals=void 0!==attributes.normal?attributes.normal.array:void 0,colors=void 0!==attributes.color?attributes.color.array:void 0,uvs=void 0!==attributes.uv?attributes.uv.array:void 0,uvs2=void 0!==attributes.uv2?attributes.uv2.array:void 0;void 0!==uvs2&&(this.faceVertexUvs[1]=[]);for(var tempNormals=[],tempUVs=[],tempUVs2=[],i=0,j=0;i<positions.length;i+=3,j+=2)scope.vertices.push(new THREE.Vector3(positions[i],positions[i+1],positions[i+2])),void 0!==normals&&tempNormals.push(new THREE.Vector3(normals[i],normals[i+1],normals[i+2])),void 0!==colors&&scope.colors.push(new THREE.Color(colors[i],colors[i+1],colors[i+2])),void 0!==uvs&&tempUVs.push(new THREE.Vector2(uvs[j],uvs[j+1])),void 0!==uvs2&&tempUVs2.push(new THREE.Vector2(uvs2[j],uvs2[j+1]));if(void 0!==indices){var groups=geometry.groups;if(groups.length>0)for(var i=0;i<groups.length;i++)for(var group=groups[i],start=group.start,count=group.count,j=start,jl=start+count;jl>j;j+=3)addFace(indices[j],indices[j+1],indices[j+2],group.materialIndex);else for(var i=0;i<indices.length;i+=3)addFace(indices[i],indices[i+1],indices[i+2])}else for(var i=0;i<positions.length/3;i+=3)addFace(i,i+1,i+2);return this.computeFaceNormals(),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),this},center:function(){this.computeBoundingBox();var offset=this.boundingBox.center().negate();return this.translate(offset.x,offset.y,offset.z),offset},normalize:function(){this.computeBoundingSphere();var center=this.boundingSphere.center,radius=this.boundingSphere.radius,s=0===radius?1:1/radius,matrix=new THREE.Matrix4;return matrix.set(s,0,0,-s*center.x,0,s,0,-s*center.y,0,0,s,-s*center.z,0,0,0,1),this.applyMatrix(matrix),this},computeFaceNormals:function(){for(var cb=new THREE.Vector3,ab=new THREE.Vector3,f=0,fl=this.faces.length;fl>f;f++){var face=this.faces[f],vA=this.vertices[face.a],vB=this.vertices[face.b],vC=this.vertices[face.c];cb.subVectors(vC,vB),ab.subVectors(vA,vB),cb.cross(ab),cb.normalize(),face.normal.copy(cb)}},computeVertexNormals:function(areaWeighted){void 0===areaWeighted&&(areaWeighted=!0);var v,vl,f,fl,face,vertices;for(vertices=new Array(this.vertices.length),v=0,vl=this.vertices.length;vl>v;v++)vertices[v]=new THREE.Vector3;if(areaWeighted){var vA,vB,vC,cb=new THREE.Vector3,ab=new THREE.Vector3;for(f=0,fl=this.faces.length;fl>f;f++)face=this.faces[f],vA=this.vertices[face.a],vB=this.vertices[face.b],vC=this.vertices[face.c],cb.subVectors(vC,vB),ab.subVectors(vA,vB),cb.cross(ab),vertices[face.a].add(cb),vertices[face.b].add(cb),vertices[face.c].add(cb)}else for(f=0,fl=this.faces.length;fl>f;f++)face=this.faces[f],vertices[face.a].add(face.normal),vertices[face.b].add(face.normal),vertices[face.c].add(face.normal);for(v=0,vl=this.vertices.length;vl>v;v++)vertices[v].normalize();for(f=0,fl=this.faces.length;fl>f;f++){face=this.faces[f];var vertexNormals=face.vertexNormals;3===vertexNormals.length?(vertexNormals[0].copy(vertices[face.a]),vertexNormals[1].copy(vertices[face.b]),vertexNormals[2].copy(vertices[face.c])):(vertexNormals[0]=vertices[face.a].clone(),vertexNormals[1]=vertices[face.b].clone(),vertexNormals[2]=vertices[face.c].clone())}this.faces.length>0&&(this.normalsNeedUpdate=!0)},computeMorphNormals:function(){var i,il,f,fl,face;for(f=0,fl=this.faces.length;fl>f;f++)for(face=this.faces[f],face.__originalFaceNormal?face.__originalFaceNormal.copy(face.normal):face.__originalFaceNormal=face.normal.clone(),face.__originalVertexNormals||(face.__originalVertexNormals=[]),i=0,il=face.vertexNormals.length;il>i;i++)face.__originalVertexNormals[i]?face.__originalVertexNormals[i].copy(face.vertexNormals[i]):face.__originalVertexNormals[i]=face.vertexNormals[i].clone();var tmpGeo=new THREE.Geometry;for(tmpGeo.faces=this.faces,i=0,il=this.morphTargets.length;il>i;i++){if(!this.morphNormals[i]){this.morphNormals[i]={},this.morphNormals[i].faceNormals=[],this.morphNormals[i].vertexNormals=[];var faceNormal,vertexNormals,dstNormalsFace=this.morphNormals[i].faceNormals,dstNormalsVertex=this.morphNormals[i].vertexNormals;for(f=0,fl=this.faces.length;fl>f;f++)faceNormal=new THREE.Vector3,vertexNormals={a:new THREE.Vector3,b:new THREE.Vector3,c:new THREE.Vector3},dstNormalsFace.push(faceNormal),dstNormalsVertex.push(vertexNormals)}var morphNormals=this.morphNormals[i];tmpGeo.vertices=this.morphTargets[i].vertices,tmpGeo.computeFaceNormals(),tmpGeo.computeVertexNormals();var faceNormal,vertexNormals;for(f=0,fl=this.faces.length;fl>f;f++)face=this.faces[f],faceNormal=morphNormals.faceNormals[f],vertexNormals=morphNormals.vertexNormals[f],faceNormal.copy(face.normal),vertexNormals.a.copy(face.vertexNormals[0]),vertexNormals.b.copy(face.vertexNormals[1]),vertexNormals.c.copy(face.vertexNormals[2])}for(f=0,fl=this.faces.length;fl>f;f++)face=this.faces[f],face.normal=face.__originalFaceNormal,face.vertexNormals=face.__originalVertexNormals},computeTangents:function(){console.warn("THREE.Geometry: .computeTangents() has been removed.")},computeLineDistances:function(){for(var d=0,vertices=this.vertices,i=0,il=vertices.length;il>i;i++)i>0&&(d+=vertices[i].distanceTo(vertices[i-1])),this.lineDistances[i]=d},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new THREE.Box3),this.boundingBox.setFromPoints(this.vertices)},computeBoundingSphere:function(){null===this.boundingSphere&&(this.boundingSphere=new THREE.Sphere),this.boundingSphere.setFromPoints(this.vertices)},merge:function(geometry,matrix,materialIndexOffset){if(geometry instanceof THREE.Geometry==!1)return void console.error("THREE.Geometry.merge(): geometry not an instance of THREE.Geometry.",geometry);var normalMatrix,vertexOffset=this.vertices.length,vertices1=this.vertices,vertices2=geometry.vertices,faces1=this.faces,faces2=geometry.faces,uvs1=this.faceVertexUvs[0],uvs2=geometry.faceVertexUvs[0];void 0===materialIndexOffset&&(materialIndexOffset=0),void 0!==matrix&&(normalMatrix=(new THREE.Matrix3).getNormalMatrix(matrix));for(var i=0,il=vertices2.length;il>i;i++){var vertex=vertices2[i],vertexCopy=vertex.clone();void 0!==matrix&&vertexCopy.applyMatrix4(matrix),vertices1.push(vertexCopy)}for(i=0,il=faces2.length;il>i;i++){var faceCopy,normal,color,face=faces2[i],faceVertexNormals=face.vertexNormals,faceVertexColors=face.vertexColors;faceCopy=new THREE.Face3(face.a+vertexOffset,face.b+vertexOffset,face.c+vertexOffset),faceCopy.normal.copy(face.normal),void 0!==normalMatrix&&faceCopy.normal.applyMatrix3(normalMatrix).normalize();for(var j=0,jl=faceVertexNormals.length;jl>j;j++)normal=faceVertexNormals[j].clone(),void 0!==normalMatrix&&normal.applyMatrix3(normalMatrix).normalize(),faceCopy.vertexNormals.push(normal);faceCopy.color.copy(face.color);for(var j=0,jl=faceVertexColors.length;jl>j;j++)color=faceVertexColors[j],faceCopy.vertexColors.push(color.clone());faceCopy.materialIndex=face.materialIndex+materialIndexOffset,faces1.push(faceCopy)}for(i=0,il=uvs2.length;il>i;i++){var uv=uvs2[i],uvCopy=[];if(void 0!==uv){for(var j=0,jl=uv.length;jl>j;j++)uvCopy.push(uv[j].clone());
uvs1.push(uvCopy)}}},mergeMesh:function(mesh){return mesh instanceof THREE.Mesh==!1?void console.error("THREE.Geometry.mergeMesh(): mesh not an instance of THREE.Mesh.",mesh):(mesh.matrixAutoUpdate&&mesh.updateMatrix(),void this.merge(mesh.geometry,mesh.matrix))},mergeVertices:function(){var v,key,i,il,face,indices,j,jl,verticesMap={},unique=[],changes=[],precisionPoints=4,precision=Math.pow(10,precisionPoints);for(i=0,il=this.vertices.length;il>i;i++)v=this.vertices[i],key=Math.round(v.x*precision)+"_"+Math.round(v.y*precision)+"_"+Math.round(v.z*precision),void 0===verticesMap[key]?(verticesMap[key]=i,unique.push(this.vertices[i]),changes[i]=unique.length-1):changes[i]=changes[verticesMap[key]];var faceIndicesToRemove=[];for(i=0,il=this.faces.length;il>i;i++){face=this.faces[i],face.a=changes[face.a],face.b=changes[face.b],face.c=changes[face.c],indices=[face.a,face.b,face.c];for(var dupIndex=-1,n=0;3>n;n++)if(indices[n]===indices[(n+1)%3]){dupIndex=n,faceIndicesToRemove.push(i);break}}for(i=faceIndicesToRemove.length-1;i>=0;i--){var idx=faceIndicesToRemove[i];for(this.faces.splice(idx,1),j=0,jl=this.faceVertexUvs.length;jl>j;j++)this.faceVertexUvs[j].splice(idx,1)}var diff=this.vertices.length-unique.length;return this.vertices=unique,diff},sortFacesByMaterialIndex:function(){function materialIndexSort(a,b){return a.materialIndex-b.materialIndex}for(var faces=this.faces,length=faces.length,i=0;length>i;i++)faces[i]._id=i;faces.sort(materialIndexSort);var newUvs1,newUvs2,uvs1=this.faceVertexUvs[0],uvs2=this.faceVertexUvs[1];uvs1&&uvs1.length===length&&(newUvs1=[]),uvs2&&uvs2.length===length&&(newUvs2=[]);for(var i=0;length>i;i++){var id=faces[i]._id;newUvs1&&newUvs1.push(uvs1[id]),newUvs2&&newUvs2.push(uvs2[id])}newUvs1&&(this.faceVertexUvs[0]=newUvs1),newUvs2&&(this.faceVertexUvs[1]=newUvs2)},toJSON:function(){function setBit(value,position,enabled){return enabled?value|1<<position:value&~(1<<position)}function getNormalIndex(normal){var hash=normal.x.toString()+normal.y.toString()+normal.z.toString();return void 0!==normalsHash[hash]?normalsHash[hash]:(normalsHash[hash]=normals.length/3,normals.push(normal.x,normal.y,normal.z),normalsHash[hash])}function getColorIndex(color){var hash=color.r.toString()+color.g.toString()+color.b.toString();return void 0!==colorsHash[hash]?colorsHash[hash]:(colorsHash[hash]=colors.length,colors.push(color.getHex()),colorsHash[hash])}function getUvIndex(uv){var hash=uv.x.toString()+uv.y.toString();return void 0!==uvsHash[hash]?uvsHash[hash]:(uvsHash[hash]=uvs.length/2,uvs.push(uv.x,uv.y),uvsHash[hash])}var data={metadata:{version:4.4,type:"Geometry",generator:"Geometry.toJSON"}};if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),void 0!==this.parameters){var parameters=this.parameters;for(var key in parameters)void 0!==parameters[key]&&(data[key]=parameters[key]);return data}for(var vertices=[],i=0;i<this.vertices.length;i++){var vertex=this.vertices[i];vertices.push(vertex.x,vertex.y,vertex.z)}for(var faces=[],normals=[],normalsHash={},colors=[],colorsHash={},uvs=[],uvsHash={},i=0;i<this.faces.length;i++){var face=this.faces[i],hasMaterial=!0,hasFaceUv=!1,hasFaceVertexUv=void 0!==this.faceVertexUvs[0][i],hasFaceNormal=face.normal.length()>0,hasFaceVertexNormal=face.vertexNormals.length>0,hasFaceColor=1!==face.color.r||1!==face.color.g||1!==face.color.b,hasFaceVertexColor=face.vertexColors.length>0,faceType=0;if(faceType=setBit(faceType,0,0),faceType=setBit(faceType,1,hasMaterial),faceType=setBit(faceType,2,hasFaceUv),faceType=setBit(faceType,3,hasFaceVertexUv),faceType=setBit(faceType,4,hasFaceNormal),faceType=setBit(faceType,5,hasFaceVertexNormal),faceType=setBit(faceType,6,hasFaceColor),faceType=setBit(faceType,7,hasFaceVertexColor),faces.push(faceType),faces.push(face.a,face.b,face.c),faces.push(face.materialIndex),hasFaceVertexUv){var faceVertexUvs=this.faceVertexUvs[0][i];faces.push(getUvIndex(faceVertexUvs[0]),getUvIndex(faceVertexUvs[1]),getUvIndex(faceVertexUvs[2]))}if(hasFaceNormal&&faces.push(getNormalIndex(face.normal)),hasFaceVertexNormal){var vertexNormals=face.vertexNormals;faces.push(getNormalIndex(vertexNormals[0]),getNormalIndex(vertexNormals[1]),getNormalIndex(vertexNormals[2]))}if(hasFaceColor&&faces.push(getColorIndex(face.color)),hasFaceVertexColor){var vertexColors=face.vertexColors;faces.push(getColorIndex(vertexColors[0]),getColorIndex(vertexColors[1]),getColorIndex(vertexColors[2]))}}return data.data={},data.data.vertices=vertices,data.data.normals=normals,colors.length>0&&(data.data.colors=colors),uvs.length>0&&(data.data.uvs=[uvs]),data.data.faces=faces,data},clone:function(){return(new THREE.Geometry).copy(this)},copy:function(source){this.vertices=[],this.faces=[],this.faceVertexUvs=[[]];for(var vertices=source.vertices,i=0,il=vertices.length;il>i;i++)this.vertices.push(vertices[i].clone());for(var faces=source.faces,i=0,il=faces.length;il>i;i++)this.faces.push(faces[i].clone());for(var i=0,il=source.faceVertexUvs.length;il>i;i++){var faceVertexUvs=source.faceVertexUvs[i];void 0===this.faceVertexUvs[i]&&(this.faceVertexUvs[i]=[]);for(var j=0,jl=faceVertexUvs.length;jl>j;j++){for(var uvs=faceVertexUvs[j],uvsCopy=[],k=0,kl=uvs.length;kl>k;k++){var uv=uvs[k];uvsCopy.push(uv.clone())}this.faceVertexUvs[i].push(uvsCopy)}}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}},THREE.EventDispatcher.prototype.apply(THREE.Geometry.prototype),THREE.GeometryIdCount=0,THREE.DirectGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="DirectGeometry",this.indices=[],this.vertices=[],this.normals=[],this.colors=[],this.uvs=[],this.uvs2=[],this.groups=[],this.morphTargets={},this.skinWeights=[],this.skinIndices=[],this.boundingBox=null,this.boundingSphere=null,this.verticesNeedUpdate=!1,this.normalsNeedUpdate=!1,this.colorsNeedUpdate=!1,this.uvsNeedUpdate=!1,this.groupsNeedUpdate=!1},THREE.DirectGeometry.prototype={constructor:THREE.DirectGeometry,computeBoundingBox:THREE.Geometry.prototype.computeBoundingBox,computeBoundingSphere:THREE.Geometry.prototype.computeBoundingSphere,computeFaceNormals:function(){console.warn("THREE.DirectGeometry: computeFaceNormals() is not a method of this type of geometry.")},computeVertexNormals:function(){console.warn("THREE.DirectGeometry: computeVertexNormals() is not a method of this type of geometry.")},computeGroups:function(geometry){for(var group,materialIndex,groups=[],faces=geometry.faces,i=0;i<faces.length;i++){var face=faces[i];face.materialIndex!==materialIndex&&(materialIndex=face.materialIndex,void 0!==group&&(group.count=3*i-group.start,groups.push(group)),group={start:3*i,materialIndex:materialIndex})}void 0!==group&&(group.count=3*i-group.start,groups.push(group)),this.groups=groups},fromGeometry:function(geometry){var morphTargetsPosition,faces=geometry.faces,vertices=geometry.vertices,faceVertexUvs=geometry.faceVertexUvs,hasFaceVertexUv=faceVertexUvs[0]&&faceVertexUvs[0].length>0,hasFaceVertexUv2=faceVertexUvs[1]&&faceVertexUvs[1].length>0,morphTargets=geometry.morphTargets,morphTargetsLength=morphTargets.length;if(morphTargetsLength>0){morphTargetsPosition=[];for(var i=0;morphTargetsLength>i;i++)morphTargetsPosition[i]=[];this.morphTargets.position=morphTargetsPosition}var morphTargetsNormal,morphNormals=geometry.morphNormals,morphNormalsLength=morphNormals.length;if(morphNormalsLength>0){morphTargetsNormal=[];for(var i=0;morphNormalsLength>i;i++)morphTargetsNormal[i]=[];this.morphTargets.normal=morphTargetsNormal}for(var skinIndices=geometry.skinIndices,skinWeights=geometry.skinWeights,hasSkinIndices=skinIndices.length===vertices.length,hasSkinWeights=skinWeights.length===vertices.length,i=0;i<faces.length;i++){var face=faces[i];this.vertices.push(vertices[face.a],vertices[face.b],vertices[face.c]);var vertexNormals=face.vertexNormals;if(3===vertexNormals.length)this.normals.push(vertexNormals[0],vertexNormals[1],vertexNormals[2]);else{var normal=face.normal;this.normals.push(normal,normal,normal)}var vertexColors=face.vertexColors;if(3===vertexColors.length)this.colors.push(vertexColors[0],vertexColors[1],vertexColors[2]);else{var color=face.color;this.colors.push(color,color,color)}if(hasFaceVertexUv===!0){var vertexUvs=faceVertexUvs[0][i];void 0!==vertexUvs?this.uvs.push(vertexUvs[0],vertexUvs[1],vertexUvs[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv ",i),this.uvs.push(new THREE.Vector2,new THREE.Vector2,new THREE.Vector2))}if(hasFaceVertexUv2===!0){var vertexUvs=faceVertexUvs[1][i];void 0!==vertexUvs?this.uvs2.push(vertexUvs[0],vertexUvs[1],vertexUvs[2]):(console.warn("THREE.DirectGeometry.fromGeometry(): Undefined vertexUv2 ",i),this.uvs2.push(new THREE.Vector2,new THREE.Vector2,new THREE.Vector2))}for(var j=0;morphTargetsLength>j;j++){var morphTarget=morphTargets[j].vertices;morphTargetsPosition[j].push(morphTarget[face.a],morphTarget[face.b],morphTarget[face.c])}for(var j=0;morphNormalsLength>j;j++){var morphNormal=morphNormals[j].vertexNormals[i];morphTargetsNormal[j].push(morphNormal.a,morphNormal.b,morphNormal.c)}hasSkinIndices&&this.skinIndices.push(skinIndices[face.a],skinIndices[face.b],skinIndices[face.c]),hasSkinWeights&&this.skinWeights.push(skinWeights[face.a],skinWeights[face.b],skinWeights[face.c])}return this.computeGroups(geometry),this.verticesNeedUpdate=geometry.verticesNeedUpdate,this.normalsNeedUpdate=geometry.normalsNeedUpdate,this.colorsNeedUpdate=geometry.colorsNeedUpdate,this.uvsNeedUpdate=geometry.uvsNeedUpdate,this.groupsNeedUpdate=geometry.groupsNeedUpdate,this},dispose:function(){this.dispatchEvent({type:"dispose"})}},THREE.EventDispatcher.prototype.apply(THREE.DirectGeometry.prototype),THREE.BufferGeometry=function(){Object.defineProperty(this,"id",{value:THREE.GeometryIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="BufferGeometry",this.index=null,this.attributes={},this.morphAttributes={},this.groups=[],this.boundingBox=null,this.boundingSphere=null,this.drawRange={start:0,count:1/0}},THREE.BufferGeometry.prototype={constructor:THREE.BufferGeometry,getIndex:function(){return this.index},setIndex:function(index){this.index=index},addAttribute:function(name,attribute){return attribute instanceof THREE.BufferAttribute==!1&&attribute instanceof THREE.InterleavedBufferAttribute==!1?(console.warn("THREE.BufferGeometry: .addAttribute() now expects ( name, attribute )."),void this.addAttribute(name,new THREE.BufferAttribute(arguments[1],arguments[2]))):"index"===name?(console.warn("THREE.BufferGeometry.addAttribute: Use .setIndex() for index attribute."),void this.setIndex(attribute)):(this.attributes[name]=attribute,this)},getAttribute:function(name){return this.attributes[name]},removeAttribute:function(name){return delete this.attributes[name],this},addGroup:function(start,count,materialIndex){this.groups.push({start:start,count:count,materialIndex:void 0!==materialIndex?materialIndex:0})},clearGroups:function(){this.groups=[]},setDrawRange:function(start,count){this.drawRange.start=start,this.drawRange.count=count},applyMatrix:function(matrix){var position=this.attributes.position;void 0!==position&&(matrix.applyToVector3Array(position.array),position.needsUpdate=!0);var normal=this.attributes.normal;if(void 0!==normal){var normalMatrix=(new THREE.Matrix3).getNormalMatrix(matrix);normalMatrix.applyToVector3Array(normal.array),normal.needsUpdate=!0}return null!==this.boundingBox&&this.computeBoundingBox(),null!==this.boundingSphere&&this.computeBoundingSphere(),this},rotateX:function(){var m1;return function(angle){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeRotationX(angle),this.applyMatrix(m1),this}}(),rotateY:function(){var m1;return function(angle){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeRotationY(angle),this.applyMatrix(m1),this}}(),rotateZ:function(){var m1;return function(angle){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeRotationZ(angle),this.applyMatrix(m1),this}}(),translate:function(){var m1;return function(x,y,z){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeTranslation(x,y,z),this.applyMatrix(m1),this}}(),scale:function(){var m1;return function(x,y,z){return void 0===m1&&(m1=new THREE.Matrix4),m1.makeScale(x,y,z),this.applyMatrix(m1),this}}(),lookAt:function(){var obj;return function(vector){void 0===obj&&(obj=new THREE.Object3D),obj.lookAt(vector),obj.updateMatrix(),this.applyMatrix(obj.matrix)}}(),center:function(){this.computeBoundingBox();var offset=this.boundingBox.center().negate();return this.translate(offset.x,offset.y,offset.z),offset},setFromObject:function(object){var geometry=object.geometry;if(object instanceof THREE.Points||object instanceof THREE.Line){var positions=new THREE.Float32Attribute(3*geometry.vertices.length,3),colors=new THREE.Float32Attribute(3*geometry.colors.length,3);if(this.addAttribute("position",positions.copyVector3sArray(geometry.vertices)),this.addAttribute("color",colors.copyColorsArray(geometry.colors)),geometry.lineDistances&&geometry.lineDistances.length===geometry.vertices.length){var lineDistances=new THREE.Float32Attribute(geometry.lineDistances.length,1);this.addAttribute("lineDistance",lineDistances.copyArray(geometry.lineDistances))}null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone())}else object instanceof THREE.Mesh&&geometry instanceof THREE.Geometry&&this.fromGeometry(geometry);return this},updateFromObject:function(object){var geometry=object.geometry;if(object instanceof THREE.Mesh){var direct=geometry.__directGeometry;if(void 0===direct)return this.fromGeometry(geometry);direct.verticesNeedUpdate=geometry.verticesNeedUpdate,direct.normalsNeedUpdate=geometry.normalsNeedUpdate,direct.colorsNeedUpdate=geometry.colorsNeedUpdate,direct.uvsNeedUpdate=geometry.uvsNeedUpdate,direct.groupsNeedUpdate=geometry.groupsNeedUpdate,geometry.verticesNeedUpdate=!1,geometry.normalsNeedUpdate=!1,geometry.colorsNeedUpdate=!1,geometry.uvsNeedUpdate=!1,geometry.groupsNeedUpdate=!1,geometry=direct}if(geometry.verticesNeedUpdate===!0){var attribute=this.attributes.position;void 0!==attribute&&(attribute.copyVector3sArray(geometry.vertices),attribute.needsUpdate=!0),geometry.verticesNeedUpdate=!1}if(geometry.normalsNeedUpdate===!0){var attribute=this.attributes.normal;void 0!==attribute&&(attribute.copyVector3sArray(geometry.normals),attribute.needsUpdate=!0),geometry.normalsNeedUpdate=!1}if(geometry.colorsNeedUpdate===!0){var attribute=this.attributes.color;void 0!==attribute&&(attribute.copyColorsArray(geometry.colors),attribute.needsUpdate=!0),geometry.colorsNeedUpdate=!1}if(geometry.uvsNeedUpdate){var attribute=this.attributes.uv;void 0!==attribute&&(attribute.copyVector2sArray(geometry.uvs),attribute.needsUpdate=!0),geometry.uvsNeedUpdate=!1}if(geometry.lineDistancesNeedUpdate){var attribute=this.attributes.lineDistance;void 0!==attribute&&(attribute.copyArray(geometry.lineDistances),attribute.needsUpdate=!0),geometry.lineDistancesNeedUpdate=!1}return geometry.groupsNeedUpdate&&(geometry.computeGroups(object.geometry),this.groups=geometry.groups,geometry.groupsNeedUpdate=!1),this},fromGeometry:function(geometry){return geometry.__directGeometry=(new THREE.DirectGeometry).fromGeometry(geometry),this.fromDirectGeometry(geometry.__directGeometry)},fromDirectGeometry:function(geometry){var positions=new Float32Array(3*geometry.vertices.length);if(this.addAttribute("position",new THREE.BufferAttribute(positions,3).copyVector3sArray(geometry.vertices)),geometry.normals.length>0){var normals=new Float32Array(3*geometry.normals.length);this.addAttribute("normal",new THREE.BufferAttribute(normals,3).copyVector3sArray(geometry.normals))}if(geometry.colors.length>0){var colors=new Float32Array(3*geometry.colors.length);this.addAttribute("color",new THREE.BufferAttribute(colors,3).copyColorsArray(geometry.colors))}if(geometry.uvs.length>0){var uvs=new Float32Array(2*geometry.uvs.length);this.addAttribute("uv",new THREE.BufferAttribute(uvs,2).copyVector2sArray(geometry.uvs))}if(geometry.uvs2.length>0){var uvs2=new Float32Array(2*geometry.uvs2.length);this.addAttribute("uv2",new THREE.BufferAttribute(uvs2,2).copyVector2sArray(geometry.uvs2))}if(geometry.indices.length>0){var TypeArray=geometry.vertices.length>65535?Uint32Array:Uint16Array,indices=new TypeArray(3*geometry.indices.length);this.setIndex(new THREE.BufferAttribute(indices,1).copyIndicesArray(geometry.indices))}this.groups=geometry.groups;for(var name in geometry.morphTargets){for(var array=[],morphTargets=geometry.morphTargets[name],i=0,l=morphTargets.length;l>i;i++){var morphTarget=morphTargets[i],attribute=new THREE.Float32Attribute(3*morphTarget.length,3);array.push(attribute.copyVector3sArray(morphTarget))}this.morphAttributes[name]=array}if(geometry.skinIndices.length>0){var skinIndices=new THREE.Float32Attribute(4*geometry.skinIndices.length,4);this.addAttribute("skinIndex",skinIndices.copyVector4sArray(geometry.skinIndices))}if(geometry.skinWeights.length>0){var skinWeights=new THREE.Float32Attribute(4*geometry.skinWeights.length,4);this.addAttribute("skinWeight",skinWeights.copyVector4sArray(geometry.skinWeights))}return null!==geometry.boundingSphere&&(this.boundingSphere=geometry.boundingSphere.clone()),null!==geometry.boundingBox&&(this.boundingBox=geometry.boundingBox.clone()),this},computeBoundingBox:function(){null===this.boundingBox&&(this.boundingBox=new THREE.Box3);var positions=this.attributes.position.array;void 0!==positions?this.boundingBox.setFromArray(positions):this.boundingBox.makeEmpty(),(isNaN(this.boundingBox.min.x)||isNaN(this.boundingBox.min.y)||isNaN(this.boundingBox.min.z))&&console.error('THREE.BufferGeometry.computeBoundingBox: Computed min/max have NaN values. The "position" attribute is likely to have NaN values.',this)},computeBoundingSphere:function(){var box=new THREE.Box3,vector=new THREE.Vector3;return function(){null===this.boundingSphere&&(this.boundingSphere=new THREE.Sphere);var positions=this.attributes.position.array;if(positions){var center=this.boundingSphere.center;box.setFromArray(positions),box.center(center);for(var maxRadiusSq=0,i=0,il=positions.length;il>i;i+=3)vector.fromArray(positions,i),maxRadiusSq=Math.max(maxRadiusSq,center.distanceToSquared(vector));this.boundingSphere.radius=Math.sqrt(maxRadiusSq),isNaN(this.boundingSphere.radius)&&console.error('THREE.BufferGeometry.computeBoundingSphere(): Computed radius is NaN. The "position" attribute is likely to have NaN values.',this)}}}(),computeFaceNormals:function(){},computeVertexNormals:function(){var index=this.index,attributes=this.attributes,groups=this.groups;if(attributes.position){var positions=attributes.position.array;if(void 0===attributes.normal)this.addAttribute("normal",new THREE.BufferAttribute(new Float32Array(positions.length),3));else for(var array=attributes.normal.array,i=0,il=array.length;il>i;i++)array[i]=0;var vA,vB,vC,normals=attributes.normal.array,pA=new THREE.Vector3,pB=new THREE.Vector3,pC=new THREE.Vector3,cb=new THREE.Vector3,ab=new THREE.Vector3;if(index){var indices=index.array;0===groups.length&&this.addGroup(0,indices.length);for(var j=0,jl=groups.length;jl>j;++j)for(var group=groups[j],start=group.start,count=group.count,i=start,il=start+count;il>i;i+=3)vA=3*indices[i+0],vB=3*indices[i+1],vC=3*indices[i+2],pA.fromArray(positions,vA),pB.fromArray(positions,vB),pC.fromArray(positions,vC),cb.subVectors(pC,pB),ab.subVectors(pA,pB),cb.cross(ab),normals[vA]+=cb.x,normals[vA+1]+=cb.y,normals[vA+2]+=cb.z,normals[vB]+=cb.x,normals[vB+1]+=cb.y,normals[vB+2]+=cb.z,normals[vC]+=cb.x,normals[vC+1]+=cb.y,normals[vC+2]+=cb.z}else for(var i=0,il=positions.length;il>i;i+=9)pA.fromArray(positions,i),pB.fromArray(positions,i+3),pC.fromArray(positions,i+6),cb.subVectors(pC,pB),ab.subVectors(pA,pB),cb.cross(ab),normals[i]=cb.x,normals[i+1]=cb.y,normals[i+2]=cb.z,normals[i+3]=cb.x,normals[i+4]=cb.y,normals[i+5]=cb.z,normals[i+6]=cb.x,normals[i+7]=cb.y,normals[i+8]=cb.z;this.normalizeNormals(),attributes.normal.needsUpdate=!0}},merge:function(geometry,offset){if(geometry instanceof THREE.BufferGeometry==!1)return void console.error("THREE.BufferGeometry.merge(): geometry not an instance of THREE.BufferGeometry.",geometry);void 0===offset&&(offset=0);var attributes=this.attributes;for(var key in attributes)if(void 0!==geometry.attributes[key])for(var attribute1=attributes[key],attributeArray1=attribute1.array,attribute2=geometry.attributes[key],attributeArray2=attribute2.array,attributeSize=attribute2.itemSize,i=0,j=attributeSize*offset;i<attributeArray2.length;i++,j++)attributeArray1[j]=attributeArray2[i];return this},normalizeNormals:function(){for(var x,y,z,n,normals=this.attributes.normal.array,i=0,il=normals.length;il>i;i+=3)x=normals[i],y=normals[i+1],z=normals[i+2],n=1/Math.sqrt(x*x+y*y+z*z),normals[i]*=n,normals[i+1]*=n,normals[i+2]*=n},toNonIndexed:function(){if(null===this.index)return console.warn("THREE.BufferGeometry.toNonIndexed(): Geometry is already non-indexed."),this;var geometry2=new THREE.BufferGeometry,indices=this.index.array,attributes=this.attributes;for(var name in attributes){for(var attribute=attributes[name],array=attribute.array,itemSize=attribute.itemSize,array2=new array.constructor(indices.length*itemSize),index=0,index2=0,i=0,l=indices.length;l>i;i++){index=indices[i]*itemSize;for(var j=0;itemSize>j;j++)array2[index2++]=array[index++]}geometry2.addAttribute(name,new THREE.BufferAttribute(array2,itemSize))}return geometry2},toJSON:function(){var data={metadata:{version:4.4,type:"BufferGeometry",generator:"BufferGeometry.toJSON"}};if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),void 0!==this.parameters){var parameters=this.parameters;for(var key in parameters)void 0!==parameters[key]&&(data[key]=parameters[key]);return data}data.data={attributes:{}};var index=this.index;if(null!==index){var array=Array.prototype.slice.call(index.array);data.data.index={type:index.array.constructor.name,array:array}}var attributes=this.attributes;for(var key in attributes){var attribute=attributes[key],array=Array.prototype.slice.call(attribute.array);data.data.attributes[key]={itemSize:attribute.itemSize,type:attribute.array.constructor.name,array:array,normalized:attribute.normalized}}var groups=this.groups;groups.length>0&&(data.data.groups=JSON.parse(JSON.stringify(groups)));var boundingSphere=this.boundingSphere;return null!==boundingSphere&&(data.data.boundingSphere={center:boundingSphere.center.toArray(),radius:boundingSphere.radius}),data},clone:function(){return(new THREE.BufferGeometry).copy(this)},copy:function(source){var index=source.index;null!==index&&this.setIndex(index.clone());var attributes=source.attributes;for(var name in attributes){var attribute=attributes[name];this.addAttribute(name,attribute.clone())}for(var groups=source.groups,i=0,l=groups.length;l>i;i++){var group=groups[i];this.addGroup(group.start,group.count,group.materialIndex)}return this},dispose:function(){this.dispatchEvent({type:"dispose"})}},THREE.EventDispatcher.prototype.apply(THREE.BufferGeometry.prototype),THREE.BufferGeometry.MaxIndex=65535,THREE.InstancedBufferGeometry=function(){THREE.BufferGeometry.call(this),this.type="InstancedBufferGeometry",this.maxInstancedCount=void 0},THREE.InstancedBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.InstancedBufferGeometry.prototype.constructor=THREE.InstancedBufferGeometry,THREE.InstancedBufferGeometry.prototype.addGroup=function(start,count,instances){this.groups.push({start:start,count:count,instances:instances})},THREE.InstancedBufferGeometry.prototype.copy=function(source){var index=source.index;null!==index&&this.setIndex(index.clone());var attributes=source.attributes;for(var name in attributes){var attribute=attributes[name];this.addAttribute(name,attribute.clone())}for(var groups=source.groups,i=0,l=groups.length;l>i;i++){var group=groups[i];this.addGroup(group.start,group.count,group.instances)}return this},THREE.EventDispatcher.prototype.apply(THREE.InstancedBufferGeometry.prototype),THREE.Uniform=function(value){"string"==typeof value&&(console.warn("THREE.Uniform: Type parameter is no longer needed."),value=arguments[1]),this.value=value,this.dynamic=!1},THREE.Uniform.prototype={constructor:THREE.Uniform,onUpdate:function(callback){return this.dynamic=!0,this.onUpdateCallback=callback,this}},THREE.AnimationClip=function(name,duration,tracks){this.name=name||THREE.Math.generateUUID(),this.tracks=tracks,this.duration=void 0!==duration?duration:-1,this.duration<0&&this.resetDuration(),this.trim(),this.optimize()},THREE.AnimationClip.prototype={constructor:THREE.AnimationClip,resetDuration:function(){for(var tracks=this.tracks,duration=0,i=0,n=tracks.length;i!==n;++i){var track=this.tracks[i];duration=Math.max(duration,track.times[track.times.length-1])}this.duration=duration},trim:function(){for(var i=0;i<this.tracks.length;i++)this.tracks[i].trim(0,this.duration);return this},optimize:function(){for(var i=0;i<this.tracks.length;i++)this.tracks[i].optimize();return this}},Object.assign(THREE.AnimationClip,{parse:function(json){for(var tracks=[],jsonTracks=json.tracks,frameTime=1/(json.fps||1),i=0,n=jsonTracks.length;i!==n;++i)tracks.push(THREE.KeyframeTrack.parse(jsonTracks[i]).scale(frameTime));return new THREE.AnimationClip(json.name,json.duration,tracks)},toJSON:function(clip){for(var tracks=[],clipTracks=clip.tracks,json={name:clip.name,duration:clip.duration,tracks:tracks},i=0,n=clipTracks.length;i!==n;++i)tracks.push(THREE.KeyframeTrack.toJSON(clipTracks[i]));return json},CreateFromMorphTargetSequence:function(name,morphTargetSequence,fps,noLoop){for(var numMorphTargets=morphTargetSequence.length,tracks=[],i=0;numMorphTargets>i;i++){var times=[],values=[];times.push((i+numMorphTargets-1)%numMorphTargets,i,(i+1)%numMorphTargets),values.push(0,1,0);var order=THREE.AnimationUtils.getKeyframeOrder(times);times=THREE.AnimationUtils.sortedArray(times,1,order),values=THREE.AnimationUtils.sortedArray(values,1,order),noLoop||0!==times[0]||(times.push(numMorphTargets),values.push(values[0])),tracks.push(new THREE.NumberKeyframeTrack(".morphTargetInfluences["+morphTargetSequence[i].name+"]",times,values).scale(1/fps))}return new THREE.AnimationClip(name,-1,tracks)},findByName:function(clipArray,name){for(var i=0;i<clipArray.length;i++)if(clipArray[i].name===name)return clipArray[i];return null},CreateClipsFromMorphTargetSequences:function(morphTargets,fps,noLoop){for(var animationToMorphTargets={},pattern=/^([\w-]*?)([\d]+)$/,i=0,il=morphTargets.length;il>i;i++){var morphTarget=morphTargets[i],parts=morphTarget.name.match(pattern);if(parts&&parts.length>1){var name=parts[1],animationMorphTargets=animationToMorphTargets[name];animationMorphTargets||(animationToMorphTargets[name]=animationMorphTargets=[]),animationMorphTargets.push(morphTarget)}}var clips=[];for(var name in animationToMorphTargets)clips.push(THREE.AnimationClip.CreateFromMorphTargetSequence(name,animationToMorphTargets[name],fps,noLoop));return clips},parseAnimation:function(animation,bones,nodeName){if(!animation)return console.error("  no animation in JSONLoader data"),null;for(var addNonemptyTrack=function(trackType,trackName,animationKeys,propertyName,destTracks){if(0!==animationKeys.length){var times=[],values=[];THREE.AnimationUtils.flattenJSON(animationKeys,times,values,propertyName),0!==times.length&&destTracks.push(new trackType(trackName,times,values))}},tracks=[],clipName=animation.name||"default",duration=animation.length||-1,fps=animation.fps||30,hierarchyTracks=animation.hierarchy||[],h=0;h<hierarchyTracks.length;h++){var animationKeys=hierarchyTracks[h].keys;if(animationKeys&&0!=animationKeys.length)if(animationKeys[0].morphTargets){for(var morphTargetNames={},k=0;k<animationKeys.length;k++)if(animationKeys[k].morphTargets)for(var m=0;m<animationKeys[k].morphTargets.length;m++)morphTargetNames[animationKeys[k].morphTargets[m]]=-1;for(var morphTargetName in morphTargetNames){for(var times=[],values=[],m=0;m!==animationKeys[k].morphTargets.length;++m){var animationKey=animationKeys[k];times.push(animationKey.time),values.push(animationKey.morphTarget===morphTargetName?1:0)}tracks.push(new THREE.NumberKeyframeTrack(".morphTargetInfluence["+morphTargetName+"]",times,values))}duration=morphTargetNames.length*(fps||1)}else{var boneName=".bones["+bones[h].name+"]";addNonemptyTrack(THREE.VectorKeyframeTrack,boneName+".position",animationKeys,"pos",tracks),addNonemptyTrack(THREE.QuaternionKeyframeTrack,boneName+".quaternion",animationKeys,"rot",tracks),addNonemptyTrack(THREE.VectorKeyframeTrack,boneName+".scale",animationKeys,"scl",tracks)}}if(0===tracks.length)return null;var clip=new THREE.AnimationClip(clipName,duration,tracks);return clip}}),THREE.AnimationMixer=function(root){this._root=root,this._initMemoryManager(),this._accuIndex=0,this.time=0,this.timeScale=1},THREE.AnimationMixer.prototype={constructor:THREE.AnimationMixer,clipAction:function(clip,optionalRoot){var prototypeAction,root=optionalRoot||this._root,rootUuid=root.uuid,clipName="string"==typeof clip?clip:clip.name,clipObject=clip!==clipName?clip:null,actionsForClip=this._actionsByClip[clipName];if(void 0!==actionsForClip){var existingAction=actionsForClip.actionByRoot[rootUuid];if(void 0!==existingAction)return existingAction;if(prototypeAction=actionsForClip.knownActions[0],clipObject=prototypeAction._clip,clip!==clipName&&clip!==clipObject)throw new Error("Different clips with the same name detected!")}if(null===clipObject)return null;var newAction=new THREE.AnimationMixer._Action(this,clipObject,optionalRoot);return this._bindAction(newAction,prototypeAction),this._addInactiveAction(newAction,clipName,rootUuid),newAction},existingAction:function(clip,optionalRoot){var root=optionalRoot||this._root,rootUuid=root.uuid,clipName="string"==typeof clip?clip:clip.name,actionsForClip=this._actionsByClip[clipName];return void 0!==actionsForClip?actionsForClip.actionByRoot[rootUuid]||null:null},stopAllAction:function(){var actions=this._actions,nActions=this._nActiveActions,bindings=this._bindings,nBindings=this._nActiveBindings;this._nActiveActions=0,this._nActiveBindings=0;for(var i=0;i!==nActions;++i)actions[i].reset();for(var i=0;i!==nBindings;++i)bindings[i].useCount=0;return this},update:function(deltaTime){deltaTime*=this.timeScale;for(var actions=this._actions,nActions=this._nActiveActions,time=this.time+=deltaTime,timeDirection=Math.sign(deltaTime),accuIndex=this._accuIndex^=1,i=0;i!==nActions;++i){var action=actions[i];action.enabled&&action._update(time,deltaTime,timeDirection,accuIndex)}for(var bindings=this._bindings,nBindings=this._nActiveBindings,i=0;i!==nBindings;++i)bindings[i].apply(accuIndex);return this},getRoot:function(){return this._root},uncacheClip:function(clip){var actions=this._actions,clipName=clip.name,actionsByClip=this._actionsByClip,actionsForClip=actionsByClip[clipName];if(void 0!==actionsForClip){for(var actionsToRemove=actionsForClip.knownActions,i=0,n=actionsToRemove.length;i!==n;++i){var action=actionsToRemove[i];this._deactivateAction(action);var cacheIndex=action._cacheIndex,lastInactiveAction=actions[actions.length-1];action._cacheIndex=null,action._byClipCacheIndex=null,lastInactiveAction._cacheIndex=cacheIndex,actions[cacheIndex]=lastInactiveAction,actions.pop(),this._removeInactiveBindingsForAction(action)}delete actionsByClip[clipName]}},uncacheRoot:function(root){var rootUuid=root.uuid,actionsByClip=this._actionsByClip;for(var clipName in actionsByClip){var actionByRoot=actionsByClip[clipName].actionByRoot,action=actionByRoot[rootUuid];void 0!==action&&(this._deactivateAction(action),this._removeInactiveAction(action))}var bindingsByRoot=this._bindingsByRootAndName,bindingByName=bindingsByRoot[rootUuid];if(void 0!==bindingByName)for(var trackName in bindingByName){
var binding=bindingByName[trackName];binding.restoreOriginalState(),this._removeInactiveBinding(binding)}},uncacheAction:function(clip,optionalRoot){var action=this.existingAction(clip,optionalRoot);null!==action&&(this._deactivateAction(action),this._removeInactiveAction(action))}},THREE.EventDispatcher.prototype.apply(THREE.AnimationMixer.prototype),THREE.AnimationMixer._Action=function(mixer,clip,localRoot){this._mixer=mixer,this._clip=clip,this._localRoot=localRoot||null;for(var tracks=clip.tracks,nTracks=tracks.length,interpolants=new Array(nTracks),interpolantSettings={endingStart:THREE.ZeroCurvatureEnding,endingEnd:THREE.ZeroCurvatureEnding},i=0;i!==nTracks;++i){var interpolant=tracks[i].createInterpolant(null);interpolants[i]=interpolant,interpolant.settings=interpolantSettings}this._interpolantSettings=interpolantSettings,this._interpolants=interpolants,this._propertyBindings=new Array(nTracks),this._cacheIndex=null,this._byClipCacheIndex=null,this._timeScaleInterpolant=null,this._weightInterpolant=null,this.loop=THREE.LoopRepeat,this._loopCount=-1,this._startTime=null,this.time=0,this.timeScale=1,this._effectiveTimeScale=1,this.weight=1,this._effectiveWeight=1,this.repetitions=1/0,this.paused=!1,this.enabled=!0,this.clampWhenFinished=!1,this.zeroSlopeAtStart=!0,this.zeroSlopeAtEnd=!0},THREE.AnimationMixer._Action.prototype={constructor:THREE.AnimationMixer._Action,play:function(){return this._mixer._activateAction(this),this},stop:function(){return this._mixer._deactivateAction(this),this.reset()},reset:function(){return this.paused=!1,this.enabled=!0,this.time=0,this._loopCount=-1,this._startTime=null,this.stopFading().stopWarping()},isRunning:function(){this._startTime;return this.enabled&&!this.paused&&0!==this.timeScale&&null===this._startTime&&this._mixer._isActiveAction(this)},isScheduled:function(){return this._mixer._isActiveAction(this)},startAt:function(time){return this._startTime=time,this},setLoop:function(mode,repetitions){return this.loop=mode,this.repetitions=repetitions,this},setEffectiveWeight:function(weight){return this.weight=weight,this._effectiveWeight=this.enabled?weight:0,this.stopFading()},getEffectiveWeight:function(){return this._effectiveWeight},fadeIn:function(duration){return this._scheduleFading(duration,0,1)},fadeOut:function(duration){return this._scheduleFading(duration,1,0)},crossFadeFrom:function(fadeOutAction,duration,warp){this._mixer;if(fadeOutAction.fadeOut(duration),this.fadeIn(duration),warp){var fadeInDuration=this._clip.duration,fadeOutDuration=fadeOutAction._clip.duration,startEndRatio=fadeOutDuration/fadeInDuration,endStartRatio=fadeInDuration/fadeOutDuration;fadeOutAction.warp(1,startEndRatio,duration),this.warp(endStartRatio,1,duration)}return this},crossFadeTo:function(fadeInAction,duration,warp){return fadeInAction.crossFadeFrom(this,duration,warp)},stopFading:function(){var weightInterpolant=this._weightInterpolant;return null!==weightInterpolant&&(this._weightInterpolant=null,this._mixer._takeBackControlInterpolant(weightInterpolant)),this},setEffectiveTimeScale:function(timeScale){return this.timeScale=timeScale,this._effectiveTimeScale=this.paused?0:timeScale,this.stopWarping()},getEffectiveTimeScale:function(){return this._effectiveTimeScale},setDuration:function(duration){return this.timeScale=this._clip.duration/duration,this.stopWarping()},syncWith:function(action){return this.time=action.time,this.timeScale=action.timeScale,this.stopWarping()},halt:function(duration){return this.warp(this._currentTimeScale,0,duration)},warp:function(startTimeScale,endTimeScale,duration){var mixer=this._mixer,now=mixer.time,interpolant=this._timeScaleInterpolant,timeScale=this.timeScale;null===interpolant&&(interpolant=mixer._lendControlInterpolant(),this._timeScaleInterpolant=interpolant);var times=interpolant.parameterPositions,values=interpolant.sampleValues;return times[0]=now,times[1]=now+duration,values[0]=startTimeScale/timeScale,values[1]=endTimeScale/timeScale,this},stopWarping:function(){var timeScaleInterpolant=this._timeScaleInterpolant;return null!==timeScaleInterpolant&&(this._timeScaleInterpolant=null,this._mixer._takeBackControlInterpolant(timeScaleInterpolant)),this},getMixer:function(){return this._mixer},getClip:function(){return this._clip},getRoot:function(){return this._localRoot||this._mixer._root},_update:function(time,deltaTime,timeDirection,accuIndex){var startTime=this._startTime;if(null!==startTime){var timeRunning=(time-startTime)*timeDirection;if(0>timeRunning||0===timeDirection)return;this._startTime=null,deltaTime=timeDirection*timeRunning}deltaTime*=this._updateTimeScale(time);var clipTime=this._updateTime(deltaTime),weight=this._updateWeight(time);if(weight>0)for(var interpolants=this._interpolants,propertyMixers=this._propertyBindings,j=0,m=interpolants.length;j!==m;++j)interpolants[j].evaluate(clipTime),propertyMixers[j].accumulate(accuIndex,weight)},_updateWeight:function(time){var weight=0;if(this.enabled){weight=this.weight;var interpolant=this._weightInterpolant;if(null!==interpolant){var interpolantValue=interpolant.evaluate(time)[0];weight*=interpolantValue,time>interpolant.parameterPositions[1]&&(this.stopFading(),0===interpolantValue&&(this.enabled=!1))}}return this._effectiveWeight=weight,weight},_updateTimeScale:function(time){var timeScale=0;if(!this.paused){timeScale=this.timeScale;var interpolant=this._timeScaleInterpolant;if(null!==interpolant){var interpolantValue=interpolant.evaluate(time)[0];timeScale*=interpolantValue,time>interpolant.parameterPositions[1]&&(this.stopWarping(),0===timeScale?this.pause=!0:this.timeScale=timeScale)}}return this._effectiveTimeScale=timeScale,timeScale},_updateTime:function(deltaTime){var time=this.time+deltaTime;if(0===deltaTime)return time;var duration=this._clip.duration,loop=this.loop,loopCount=this._loopCount,pingPong=!1;switch(loop){case THREE.LoopOnce:if(-1===loopCount&&(this.loopCount=0,this._setEndings(!0,!0,!1)),time>=duration)time=duration;else{if(!(0>time))break;time=0}this.clampWhenFinished?this.pause=!0:this.enabled=!1,this._mixer.dispatchEvent({type:"finished",action:this,direction:0>deltaTime?-1:1});break;case THREE.LoopPingPong:pingPong=!0;case THREE.LoopRepeat:if(-1===loopCount&&(deltaTime>0?(loopCount=0,this._setEndings(!0,0===this.repetitions,pingPong)):this._setEndings(0===this.repetitions,!0,pingPong)),time>=duration||0>time){var loopDelta=Math.floor(time/duration);time-=duration*loopDelta,loopCount+=Math.abs(loopDelta);var pending=this.repetitions-loopCount;if(0>pending){this.clampWhenFinished?this.paused=!0:this.enabled=!1,time=deltaTime>0?duration:0,this._mixer.dispatchEvent({type:"finished",action:this,direction:deltaTime>0?1:-1});break}if(0===pending){var atStart=0>deltaTime;this._setEndings(atStart,!atStart,pingPong)}else this._setEndings(!1,!1,pingPong);this._loopCount=loopCount,this._mixer.dispatchEvent({type:"loop",action:this,loopDelta:loopDelta})}if(loop===THREE.LoopPingPong&&1===(1&loopCount))return this.time=time,duration-time}return this.time=time,time},_setEndings:function(atStart,atEnd,pingPong){var settings=this._interpolantSettings;pingPong?(settings.endingStart=THREE.ZeroSlopeEnding,settings.endingEnd=THREE.ZeroSlopeEnding):(atStart?settings.endingStart=this.zeroSlopeAtStart?THREE.ZeroSlopeEnding:THREE.ZeroCurvatureEnding:settings.endingStart=THREE.WrapAroundEnding,atEnd?settings.endingEnd=this.zeroSlopeAtEnd?THREE.ZeroSlopeEnding:THREE.ZeroCurvatureEnding:settings.endingEnd=THREE.WrapAroundEnding)},_scheduleFading:function(duration,weightNow,weightThen){var mixer=this._mixer,now=mixer.time,interpolant=this._weightInterpolant;null===interpolant&&(interpolant=mixer._lendControlInterpolant(),this._weightInterpolant=interpolant);var times=interpolant.parameterPositions,values=interpolant.sampleValues;return times[0]=now,values[0]=weightNow,times[1]=now+duration,values[1]=weightThen,this}},Object.assign(THREE.AnimationMixer.prototype,{_bindAction:function(action,prototypeAction){var root=action._localRoot||this._root,tracks=action._clip.tracks,nTracks=tracks.length,bindings=action._propertyBindings,interpolants=action._interpolants,rootUuid=root.uuid,bindingsByRoot=this._bindingsByRootAndName,bindingsByName=bindingsByRoot[rootUuid];void 0===bindingsByName&&(bindingsByName={},bindingsByRoot[rootUuid]=bindingsByName);for(var i=0;i!==nTracks;++i){var track=tracks[i],trackName=track.name,binding=bindingsByName[trackName];if(void 0!==binding)bindings[i]=binding;else{if(binding=bindings[i],void 0!==binding){null===binding._cacheIndex&&(++binding.referenceCount,this._addInactiveBinding(binding,rootUuid,trackName));continue}var path=prototypeAction&&prototypeAction._propertyBindings[i].binding.parsedPath;binding=new THREE.PropertyMixer(THREE.PropertyBinding.create(root,trackName,path),track.ValueTypeName,track.getValueSize()),++binding.referenceCount,this._addInactiveBinding(binding,rootUuid,trackName),bindings[i]=binding}interpolants[i].resultBuffer=binding.buffer}},_activateAction:function(action){if(!this._isActiveAction(action)){if(null===action._cacheIndex){var rootUuid=(action._localRoot||this._root).uuid,clipName=action._clip.name,actionsForClip=this._actionsByClip[clipName];this._bindAction(action,actionsForClip&&actionsForClip.knownActions[0]),this._addInactiveAction(action,clipName,rootUuid)}for(var bindings=action._propertyBindings,i=0,n=bindings.length;i!==n;++i){var binding=bindings[i];0===binding.useCount++&&(this._lendBinding(binding),binding.saveOriginalState())}this._lendAction(action)}},_deactivateAction:function(action){if(this._isActiveAction(action)){for(var bindings=action._propertyBindings,i=0,n=bindings.length;i!==n;++i){var binding=bindings[i];0===--binding.useCount&&(binding.restoreOriginalState(),this._takeBackBinding(binding))}this._takeBackAction(action)}},_initMemoryManager:function(){this._actions=[],this._nActiveActions=0,this._actionsByClip={},this._bindings=[],this._nActiveBindings=0,this._bindingsByRootAndName={},this._controlInterpolants=[],this._nActiveControlInterpolants=0;var scope=this;this.stats={actions:{get total(){return scope._actions.length},get inUse(){return scope._nActiveActions}},bindings:{get total(){return scope._bindings.length},get inUse(){return scope._nActiveBindings}},controlInterpolants:{get total(){return scope._controlInterpolants.length},get inUse(){return scope._nActiveControlInterpolants}}}},_isActiveAction:function(action){var index=action._cacheIndex;return null!==index&&index<this._nActiveActions},_addInactiveAction:function(action,clipName,rootUuid){var actions=this._actions,actionsByClip=this._actionsByClip,actionsForClip=actionsByClip[clipName];if(void 0===actionsForClip)actionsForClip={knownActions:[action],actionByRoot:{}},action._byClipCacheIndex=0,actionsByClip[clipName]=actionsForClip;else{var knownActions=actionsForClip.knownActions;action._byClipCacheIndex=knownActions.length,knownActions.push(action)}action._cacheIndex=actions.length,actions.push(action),actionsForClip.actionByRoot[rootUuid]=action},_removeInactiveAction:function(action){var actions=this._actions,lastInactiveAction=actions[actions.length-1],cacheIndex=action._cacheIndex;lastInactiveAction._cacheIndex=cacheIndex,actions[cacheIndex]=lastInactiveAction,actions.pop(),action._cacheIndex=null;var clipName=action._clip.name,actionsByClip=this._actionsByClip,actionsForClip=actionsByClip[clipName],knownActionsForClip=actionsForClip.knownActions,lastKnownAction=knownActionsForClip[knownActionsForClip.length-1],byClipCacheIndex=action._byClipCacheIndex;lastKnownAction._byClipCacheIndex=byClipCacheIndex,knownActionsForClip[byClipCacheIndex]=lastKnownAction,knownActionsForClip.pop(),action._byClipCacheIndex=null;var actionByRoot=actionsForClip.actionByRoot,rootUuid=(actions._localRoot||this._root).uuid;delete actionByRoot[rootUuid],0===knownActionsForClip.length&&delete actionsByClip[clipName],this._removeInactiveBindingsForAction(action)},_removeInactiveBindingsForAction:function(action){for(var bindings=action._propertyBindings,i=0,n=bindings.length;i!==n;++i){var binding=bindings[i];0===--binding.referenceCount&&this._removeInactiveBinding(binding)}},_lendAction:function(action){var actions=this._actions,prevIndex=action._cacheIndex,lastActiveIndex=this._nActiveActions++,firstInactiveAction=actions[lastActiveIndex];action._cacheIndex=lastActiveIndex,actions[lastActiveIndex]=action,firstInactiveAction._cacheIndex=prevIndex,actions[prevIndex]=firstInactiveAction},_takeBackAction:function(action){var actions=this._actions,prevIndex=action._cacheIndex,firstInactiveIndex=--this._nActiveActions,lastActiveAction=actions[firstInactiveIndex];action._cacheIndex=firstInactiveIndex,actions[firstInactiveIndex]=action,lastActiveAction._cacheIndex=prevIndex,actions[prevIndex]=lastActiveAction},_addInactiveBinding:function(binding,rootUuid,trackName){var bindingsByRoot=this._bindingsByRootAndName,bindingByName=bindingsByRoot[rootUuid],bindings=this._bindings;void 0===bindingByName&&(bindingByName={},bindingsByRoot[rootUuid]=bindingByName),bindingByName[trackName]=binding,binding._cacheIndex=bindings.length,bindings.push(binding)},_removeInactiveBinding:function(binding){var bindings=this._bindings,propBinding=binding.binding,rootUuid=propBinding.rootNode.uuid,trackName=propBinding.path,bindingsByRoot=this._bindingsByRootAndName,bindingByName=bindingsByRoot[rootUuid],lastInactiveBinding=bindings[bindings.length-1],cacheIndex=binding._cacheIndex;lastInactiveBinding._cacheIndex=cacheIndex,bindings[cacheIndex]=lastInactiveBinding,bindings.pop(),delete bindingByName[trackName];remove_empty_map:{for(var _ in bindingByName)break remove_empty_map;delete bindingsByRoot[rootUuid]}},_lendBinding:function(binding){var bindings=this._bindings,prevIndex=binding._cacheIndex,lastActiveIndex=this._nActiveBindings++,firstInactiveBinding=bindings[lastActiveIndex];binding._cacheIndex=lastActiveIndex,bindings[lastActiveIndex]=binding,firstInactiveBinding._cacheIndex=prevIndex,bindings[prevIndex]=firstInactiveBinding},_takeBackBinding:function(binding){var bindings=this._bindings,prevIndex=binding._cacheIndex,firstInactiveIndex=--this._nActiveBindings,lastActiveBinding=bindings[firstInactiveIndex];binding._cacheIndex=firstInactiveIndex,bindings[firstInactiveIndex]=binding,lastActiveBinding._cacheIndex=prevIndex,bindings[prevIndex]=lastActiveBinding},_lendControlInterpolant:function(){var interpolants=this._controlInterpolants,lastActiveIndex=this._nActiveControlInterpolants++,interpolant=interpolants[lastActiveIndex];return void 0===interpolant&&(interpolant=new THREE.LinearInterpolant(new Float32Array(2),new Float32Array(2),1,this._controlInterpolantsResultBuffer),interpolant.__cacheIndex=lastActiveIndex,interpolants[lastActiveIndex]=interpolant),interpolant},_takeBackControlInterpolant:function(interpolant){var interpolants=this._controlInterpolants,prevIndex=interpolant.__cacheIndex,firstInactiveIndex=--this._nActiveControlInterpolants,lastActiveInterpolant=interpolants[firstInactiveIndex];interpolant.__cacheIndex=firstInactiveIndex,interpolants[firstInactiveIndex]=interpolant,lastActiveInterpolant.__cacheIndex=prevIndex,interpolants[prevIndex]=lastActiveInterpolant},_controlInterpolantsResultBuffer:new Float32Array(1)}),THREE.AnimationObjectGroup=function(var_args){this.uuid=THREE.Math.generateUUID(),this._objects=Array.prototype.slice.call(arguments),this.nCachedObjects_=0;var indices={};this._indicesByUUID=indices;for(var i=0,n=arguments.length;i!==n;++i)indices[arguments[i].uuid]=i;this._paths=[],this._parsedPaths=[],this._bindings=[],this._bindingsIndicesByPath={};var scope=this;this.stats={objects:{get total(){return scope._objects.length},get inUse(){return this.total-scope.nCachedObjects_}},get bindingsPerObject(){return scope._bindings.length}}},THREE.AnimationObjectGroup.prototype={constructor:THREE.AnimationObjectGroup,add:function(var_args){for(var objects=this._objects,nObjects=objects.length,nCachedObjects=this.nCachedObjects_,indicesByUUID=this._indicesByUUID,paths=this._paths,parsedPaths=this._parsedPaths,bindings=this._bindings,nBindings=bindings.length,i=0,n=arguments.length;i!==n;++i){var object=arguments[i],uuid=object.uuid,index=indicesByUUID[uuid];if(void 0===index){index=nObjects++,indicesByUUID[uuid]=index,objects.push(object);for(var j=0,m=nBindings;j!==m;++j)bindings[j].push(new THREE.PropertyBinding(object,paths[j],parsedPaths[j]))}else if(nCachedObjects>index){var knownObject=objects[index],firstActiveIndex=--nCachedObjects,lastCachedObject=objects[firstActiveIndex];indicesByUUID[lastCachedObject.uuid]=index,objects[index]=lastCachedObject,indicesByUUID[uuid]=firstActiveIndex,objects[firstActiveIndex]=object;for(var j=0,m=nBindings;j!==m;++j){var bindingsForPath=bindings[j],lastCached=bindingsForPath[firstActiveIndex],binding=bindingsForPath[index];bindingsForPath[index]=lastCached,void 0===binding&&(binding=new THREE.PropertyBinding(object,paths[j],parsedPaths[j])),bindingsForPath[firstActiveIndex]=binding}}else objects[index]!==knownObject&&console.error("Different objects with the same UUID detected. Clean the caches or recreate your infrastructure when reloading scenes...")}this.nCachedObjects_=nCachedObjects},remove:function(var_args){for(var objects=this._objects,nCachedObjects=(objects.length,this.nCachedObjects_),indicesByUUID=this._indicesByUUID,bindings=this._bindings,nBindings=bindings.length,i=0,n=arguments.length;i!==n;++i){var object=arguments[i],uuid=object.uuid,index=indicesByUUID[uuid];if(void 0!==index&&index>=nCachedObjects){var lastCachedIndex=nCachedObjects++,firstActiveObject=objects[lastCachedIndex];indicesByUUID[firstActiveObject.uuid]=index,objects[index]=firstActiveObject,indicesByUUID[uuid]=lastCachedIndex,objects[lastCachedIndex]=object;for(var j=0,m=nBindings;j!==m;++j){var bindingsForPath=bindings[j],firstActive=bindingsForPath[lastCachedIndex],binding=bindingsForPath[index];bindingsForPath[index]=firstActive,bindingsForPath[lastCachedIndex]=binding}}}this.nCachedObjects_=nCachedObjects},uncache:function(var_args){for(var objects=this._objects,nObjects=objects.length,nCachedObjects=this.nCachedObjects_,indicesByUUID=this._indicesByUUID,bindings=this._bindings,nBindings=bindings.length,i=0,n=arguments.length;i!==n;++i){var object=arguments[i],uuid=object.uuid,index=indicesByUUID[uuid];if(void 0!==index)if(delete indicesByUUID[uuid],nCachedObjects>index){var firstActiveIndex=--nCachedObjects,lastCachedObject=objects[firstActiveIndex],lastIndex=--nObjects,lastObject=objects[lastIndex];indicesByUUID[lastCachedObject.uuid]=index,objects[index]=lastCachedObject,indicesByUUID[lastObject.uuid]=firstActiveIndex,objects[firstActiveIndex]=lastObject,objects.pop();for(var j=0,m=nBindings;j!==m;++j){var bindingsForPath=bindings[j],lastCached=bindingsForPath[firstActiveIndex],last=bindingsForPath[lastIndex];bindingsForPath[index]=lastCached,bindingsForPath[firstActiveIndex]=last,bindingsForPath.pop()}}else{var lastIndex=--nObjects,lastObject=objects[lastIndex];indicesByUUID[lastObject.uuid]=index,objects[index]=lastObject,objects.pop();for(var j=0,m=nBindings;j!==m;++j){var bindingsForPath=bindings[j];bindingsForPath[index]=bindingsForPath[lastIndex],bindingsForPath.pop()}}}this.nCachedObjects_=nCachedObjects},subscribe_:function(path,parsedPath){var indicesByPath=this._bindingsIndicesByPath,index=indicesByPath[path],bindings=this._bindings;if(void 0!==index)return bindings[index];var paths=this._paths,parsedPaths=this._parsedPaths,objects=this._objects,nObjects=objects.length,nCachedObjects=this.nCachedObjects_,bindingsForPath=new Array(nObjects);index=bindings.length,indicesByPath[path]=index,paths.push(path),parsedPaths.push(parsedPath),bindings.push(bindingsForPath);for(var i=nCachedObjects,n=objects.length;i!==n;++i){var object=objects[i];bindingsForPath[i]=new THREE.PropertyBinding(object,path,parsedPath)}return bindingsForPath},unsubscribe_:function(path){var indicesByPath=this._bindingsIndicesByPath,index=indicesByPath[path];if(void 0!==index){var paths=this._paths,parsedPaths=this._parsedPaths,bindings=this._bindings,lastBindingsIndex=bindings.length-1,lastBindings=bindings[lastBindingsIndex],lastBindingsPath=path[lastBindingsIndex];indicesByPath[lastBindingsPath]=index,bindings[index]=lastBindings,bindings.pop(),parsedPaths[index]=parsedPaths[lastBindingsIndex],parsedPaths.pop(),paths[index]=paths[lastBindingsIndex],paths.pop()}}},THREE.AnimationUtils={arraySlice:function(array,from,to){return THREE.AnimationUtils.isTypedArray(array)?new array.constructor(array.subarray(from,to)):array.slice(from,to)},convertArray:function(array,type,forceClone){return!array||!forceClone&&array.constructor===type?array:"number"==typeof type.BYTES_PER_ELEMENT?new type(array):Array.prototype.slice.call(array)},isTypedArray:function(object){return ArrayBuffer.isView(object)&&!(object instanceof DataView)},getKeyframeOrder:function(times){function compareTime(i,j){return times[i]-times[j]}for(var n=times.length,result=new Array(n),i=0;i!==n;++i)result[i]=i;return result.sort(compareTime),result},sortedArray:function(values,stride,order){for(var nValues=values.length,result=new values.constructor(nValues),i=0,dstOffset=0;dstOffset!==nValues;++i)for(var srcOffset=order[i]*stride,j=0;j!==stride;++j)result[dstOffset++]=values[srcOffset+j];return result},flattenJSON:function(jsonKeys,times,values,valuePropertyName){for(var i=1,key=jsonKeys[0];void 0!==key&&void 0===key[valuePropertyName];)key=jsonKeys[i++];if(void 0!==key){var value=key[valuePropertyName];if(void 0!==value)if(Array.isArray(value)){do value=key[valuePropertyName],void 0!==value&&(times.push(key.time),values.push.apply(values,value)),key=jsonKeys[i++];while(void 0!==key)}else if(void 0!==value.toArray){do value=key[valuePropertyName],void 0!==value&&(times.push(key.time),value.toArray(values,values.length)),key=jsonKeys[i++];while(void 0!==key)}else do value=key[valuePropertyName],void 0!==value&&(times.push(key.time),values.push(value)),key=jsonKeys[i++];while(void 0!==key)}}},THREE.KeyframeTrack=function(name,times,values,interpolation){if(void 0===name)throw new Error("track name is undefined");if(void 0===times||0===times.length)throw new Error("no keyframes in track named "+name);this.name=name,this.times=THREE.AnimationUtils.convertArray(times,this.TimeBufferType),this.values=THREE.AnimationUtils.convertArray(values,this.ValueBufferType),this.setInterpolation(interpolation||this.DefaultInterpolation),this.validate(),this.optimize()},THREE.KeyframeTrack.prototype={constructor:THREE.KeyframeTrack,TimeBufferType:Float32Array,ValueBufferType:Float32Array,DefaultInterpolation:THREE.InterpolateLinear,InterpolantFactoryMethodDiscrete:function(result){return new THREE.DiscreteInterpolant(this.times,this.values,this.getValueSize(),result)},InterpolantFactoryMethodLinear:function(result){return new THREE.LinearInterpolant(this.times,this.values,this.getValueSize(),result)},InterpolantFactoryMethodSmooth:function(result){return new THREE.CubicInterpolant(this.times,this.values,this.getValueSize(),result)},setInterpolation:function(interpolation){var factoryMethod=void 0;switch(interpolation){case THREE.InterpolateDiscrete:factoryMethod=this.InterpolantFactoryMethodDiscrete;break;case THREE.InterpolateLinear:factoryMethod=this.InterpolantFactoryMethodLinear;break;case THREE.InterpolateSmooth:factoryMethod=this.InterpolantFactoryMethodSmooth}if(void 0===factoryMethod){var message="unsupported interpolation for "+this.ValueTypeName+" keyframe track named "+this.name;if(void 0===this.createInterpolant){if(interpolation===this.DefaultInterpolation)throw new Error(message);this.setInterpolation(this.DefaultInterpolation)}return void console.warn(message)}this.createInterpolant=factoryMethod},getInterpolation:function(){switch(this.createInterpolant){case this.InterpolantFactoryMethodDiscrete:return THREE.InterpolateDiscrete;case this.InterpolantFactoryMethodLinear:return THREE.InterpolateLinear;case this.InterpolantFactoryMethodSmooth:return THREE.InterpolateSmooth}},getValueSize:function(){return this.values.length/this.times.length},shift:function(timeOffset){if(0!==timeOffset)for(var times=this.times,i=0,n=times.length;i!==n;++i)times[i]+=timeOffset;return this},scale:function(timeScale){if(1!==timeScale)for(var times=this.times,i=0,n=times.length;i!==n;++i)times[i]*=timeScale;return this},trim:function(startTime,endTime){for(var times=this.times,nKeys=times.length,from=0,to=nKeys-1;from!==nKeys&&times[from]<startTime;)++from;for(;-1!==to&&times[to]>endTime;)--to;if(++to,0!==from||to!==nKeys){from>=to&&(to=Math.max(to,1),from=to-1);var stride=this.getValueSize();this.times=THREE.AnimationUtils.arraySlice(times,from,to),this.values=THREE.AnimationUtils.arraySlice(this.values,from*stride,to*stride)}return this},validate:function(){var valid=!0,valueSize=this.getValueSize();valueSize-Math.floor(valueSize)!==0&&(console.error("invalid value size in track",this),valid=!1);var times=this.times,values=this.values,nKeys=times.length;0===nKeys&&(console.error("track is empty",this),valid=!1);for(var prevTime=null,i=0;i!==nKeys;i++){var currTime=times[i];if("number"==typeof currTime&&isNaN(currTime)){console.error("time is not a valid number",this,i,currTime),valid=!1;break}if(null!==prevTime&&prevTime>currTime){console.error("out of order keys",this,i,currTime,prevTime),valid=!1;break}prevTime=currTime}if(void 0!==values&&THREE.AnimationUtils.isTypedArray(values))for(var i=0,n=values.length;i!==n;++i){var value=values[i];if(isNaN(value)){console.error("value is not a valid number",this,i,value),valid=!1;break}}return valid},optimize:function(){for(var times=this.times,values=this.values,stride=this.getValueSize(),writeIndex=1,i=1,n=times.length-1;n>=i;++i){var keep=!1,time=times[i],timeNext=times[i+1];if(time!==timeNext&&(1!==i||time!==time[0]))for(var offset=i*stride,offsetP=offset-stride,offsetN=offset+stride,j=0;j!==stride;++j){var value=values[offset+j];if(value!==values[offsetP+j]||value!==values[offsetN+j]){keep=!0;break}}if(keep){if(i!==writeIndex){times[writeIndex]=times[i];for(var readOffset=i*stride,writeOffset=writeIndex*stride,j=0;j!==stride;++j)values[writeOffset+j]=values[readOffset+j]}++writeIndex}}return writeIndex!==times.length&&(this.times=THREE.AnimationUtils.arraySlice(times,0,writeIndex),this.values=THREE.AnimationUtils.arraySlice(values,0,writeIndex*stride)),this}},Object.assign(THREE.KeyframeTrack,{parse:function(json){if(void 0===json.type)throw new Error("track type undefined, can not parse");var trackType=THREE.KeyframeTrack._getTrackTypeForValueTypeName(json.type);if(void 0===json.times){console.warn("legacy JSON format detected, converting");var times=[],values=[];THREE.AnimationUtils.flattenJSON(json.keys,times,values,"value"),json.times=times,json.values=values}return void 0!==trackType.parse?trackType.parse(json):new trackType(json.name,json.times,json.values,json.interpolation)},toJSON:function(track){var json,trackType=track.constructor;if(void 0!==trackType.toJSON)json=trackType.toJSON(track);else{json={name:track.name,times:THREE.AnimationUtils.convertArray(track.times,Array),values:THREE.AnimationUtils.convertArray(track.values,Array)};var interpolation=track.getInterpolation();interpolation!==track.DefaultInterpolation&&(json.interpolation=interpolation)}return json.type=track.ValueTypeName,json},_getTrackTypeForValueTypeName:function(typeName){switch(typeName.toLowerCase()){case"scalar":case"double":case"float":case"number":case"integer":return THREE.NumberKeyframeTrack;case"vector":case"vector2":case"vector3":case"vector4":return THREE.VectorKeyframeTrack;case"color":return THREE.ColorKeyframeTrack;case"quaternion":return THREE.QuaternionKeyframeTrack;case"bool":case"boolean":return THREE.BooleanKeyframeTrack;case"string":return THREE.StringKeyframeTrack}throw new Error("Unsupported typeName: "+typeName)}}),THREE.PropertyBinding=function(rootNode,path,parsedPath){this.path=path,this.parsedPath=parsedPath||THREE.PropertyBinding.parseTrackName(path),this.node=THREE.PropertyBinding.findNode(rootNode,this.parsedPath.nodeName)||rootNode,this.rootNode=rootNode},THREE.PropertyBinding.prototype={constructor:THREE.PropertyBinding,getValue:function(targetArray,offset){this.bind(),this.getValue(targetArray,offset)},setValue:function(sourceArray,offset){this.bind(),this.setValue(sourceArray,offset)},bind:function(){var targetObject=this.node,parsedPath=this.parsedPath,objectName=parsedPath.objectName,propertyName=parsedPath.propertyName,propertyIndex=parsedPath.propertyIndex;if(targetObject||(targetObject=THREE.PropertyBinding.findNode(this.rootNode,parsedPath.nodeName)||this.rootNode,this.node=targetObject),this.getValue=this._getValue_unavailable,this.setValue=this._setValue_unavailable,!targetObject)return void console.error("  trying to update node for track: "+this.path+" but it wasn't found.");if(objectName){var objectIndex=parsedPath.objectIndex;switch(objectName){case"materials":if(!targetObject.material)return void console.error("  can not bind to material as node does not have a material",this);if(!targetObject.material.materials)return void console.error("  can not bind to material.materials as node.material does not have a materials array",this);targetObject=targetObject.material.materials;break;case"bones":if(!targetObject.skeleton)return void console.error("  can not bind to bones as node does not have a skeleton",this);targetObject=targetObject.skeleton.bones;for(var i=0;i<targetObject.length;i++)if(targetObject[i].name===objectIndex){objectIndex=i;break}break;default:if(void 0===targetObject[objectName])return void console.error("  can not bind to objectName of node, undefined",this);targetObject=targetObject[objectName]}if(void 0!==objectIndex){if(void 0===targetObject[objectIndex])return void console.error("  trying to bind to objectIndex of objectName, but is undefined:",this,targetObject);targetObject=targetObject[objectIndex]}}var nodeProperty=targetObject[propertyName];if(!nodeProperty){var nodeName=parsedPath.nodeName;return void console.error("  trying to update property for track: "+nodeName+"."+propertyName+" but it wasn't found.",targetObject)}var versioning=this.Versioning.None;void 0!==targetObject.needsUpdate?(versioning=this.Versioning.NeedsUpdate,this.targetObject=targetObject):void 0!==targetObject.matrixWorldNeedsUpdate&&(versioning=this.Versioning.MatrixWorldNeedsUpdate,this.targetObject=targetObject);var bindingType=this.BindingType.Direct;if(void 0!==propertyIndex){if("morphTargetInfluences"===propertyName){if(!targetObject.geometry)return void console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry",this);if(!targetObject.geometry.morphTargets)return void console.error("  can not bind to morphTargetInfluences becasuse node does not have a geometry.morphTargets",this);for(var i=0;i<this.node.geometry.morphTargets.length;i++)if(targetObject.geometry.morphTargets[i].name===propertyIndex){propertyIndex=i;break}}bindingType=this.BindingType.ArrayElement,this.resolvedProperty=nodeProperty,this.propertyIndex=propertyIndex}else void 0!==nodeProperty.fromArray&&void 0!==nodeProperty.toArray?(bindingType=this.BindingType.HasFromToArray,this.resolvedProperty=nodeProperty):void 0!==nodeProperty.length?(bindingType=this.BindingType.EntireArray,this.resolvedProperty=nodeProperty):this.propertyName=propertyName;this.getValue=this.GetterByBindingType[bindingType],this.setValue=this.SetterByBindingTypeAndVersioning[bindingType][versioning]},unbind:function(){this.node=null,this.getValue=this._getValue_unbound,this.setValue=this._setValue_unbound}},Object.assign(THREE.PropertyBinding.prototype,{_getValue_unavailable:function(){},_setValue_unavailable:function(){},_getValue_unbound:THREE.PropertyBinding.prototype.getValue,_setValue_unbound:THREE.PropertyBinding.prototype.setValue,BindingType:{Direct:0,EntireArray:1,ArrayElement:2,HasFromToArray:3},Versioning:{
None:0,NeedsUpdate:1,MatrixWorldNeedsUpdate:2},GetterByBindingType:[function(buffer,offset){buffer[offset]=this.node[this.propertyName]},function(buffer,offset){for(var source=this.resolvedProperty,i=0,n=source.length;i!==n;++i)buffer[offset++]=source[i]},function(buffer,offset){buffer[offset]=this.resolvedProperty[this.propertyIndex]},function(buffer,offset){this.resolvedProperty.toArray(buffer,offset)}],SetterByBindingTypeAndVersioning:[[function(buffer,offset){this.node[this.propertyName]=buffer[offset]},function(buffer,offset){this.node[this.propertyName]=buffer[offset],this.targetObject.needsUpdate=!0},function(buffer,offset){this.node[this.propertyName]=buffer[offset],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(buffer,offset){for(var dest=this.resolvedProperty,i=0,n=dest.length;i!==n;++i)dest[i]=buffer[offset++]},function(buffer,offset){for(var dest=this.resolvedProperty,i=0,n=dest.length;i!==n;++i)dest[i]=buffer[offset++];this.targetObject.needsUpdate=!0},function(buffer,offset){for(var dest=this.resolvedProperty,i=0,n=dest.length;i!==n;++i)dest[i]=buffer[offset++];this.targetObject.matrixWorldNeedsUpdate=!0}],[function(buffer,offset){this.resolvedProperty[this.propertyIndex]=buffer[offset]},function(buffer,offset){this.resolvedProperty[this.propertyIndex]=buffer[offset],this.targetObject.needsUpdate=!0},function(buffer,offset){this.resolvedProperty[this.propertyIndex]=buffer[offset],this.targetObject.matrixWorldNeedsUpdate=!0}],[function(buffer,offset){this.resolvedProperty.fromArray(buffer,offset)},function(buffer,offset){this.resolvedProperty.fromArray(buffer,offset),this.targetObject.needsUpdate=!0},function(buffer,offset){this.resolvedProperty.fromArray(buffer,offset),this.targetObject.matrixWorldNeedsUpdate=!0}]]}),THREE.PropertyBinding.Composite=function(targetGroup,path,optionalParsedPath){var parsedPath=optionalParsedPath||THREE.PropertyBinding.parseTrackName(path);this._targetGroup=targetGroup,this._bindings=targetGroup.subscribe_(path,parsedPath)},THREE.PropertyBinding.Composite.prototype={constructor:THREE.PropertyBinding.Composite,getValue:function(array,offset){this.bind();var firstValidIndex=this._targetGroup.nCachedObjects_,binding=this._bindings[firstValidIndex];void 0!==binding&&binding.getValue(array,offset)},setValue:function(array,offset){for(var bindings=this._bindings,i=this._targetGroup.nCachedObjects_,n=bindings.length;i!==n;++i)bindings[i].setValue(array,offset)},bind:function(){for(var bindings=this._bindings,i=this._targetGroup.nCachedObjects_,n=bindings.length;i!==n;++i)bindings[i].bind()},unbind:function(){for(var bindings=this._bindings,i=this._targetGroup.nCachedObjects_,n=bindings.length;i!==n;++i)bindings[i].unbind()}},THREE.PropertyBinding.create=function(root,path,parsedPath){return root instanceof THREE.AnimationObjectGroup?new THREE.PropertyBinding.Composite(root,path,parsedPath):new THREE.PropertyBinding(root,path,parsedPath)},THREE.PropertyBinding.parseTrackName=function(trackName){var re=/^(([\w]+\/)*)([\w-\d]+)?(\.([\w]+)(\[([\w\d\[\]\_.:\- ]+)\])?)?(\.([\w.]+)(\[([\w\d\[\]\_. ]+)\])?)$/,matches=re.exec(trackName);if(!matches)throw new Error("cannot parse trackName at all: "+trackName);matches.index===re.lastIndex&&re.lastIndex++;var results={nodeName:matches[3],objectName:matches[5],objectIndex:matches[7],propertyName:matches[9],propertyIndex:matches[11]};if(null===results.propertyName||0===results.propertyName.length)throw new Error("can not parse propertyName from trackName: "+trackName);return results},THREE.PropertyBinding.findNode=function(root,nodeName){if(!nodeName||""===nodeName||"root"===nodeName||"."===nodeName||-1===nodeName||nodeName===root.name||nodeName===root.uuid)return root;if(root.skeleton){var searchSkeleton=function(skeleton){for(var i=0;i<skeleton.bones.length;i++){var bone=skeleton.bones[i];if(bone.name===nodeName)return bone}return null},bone=searchSkeleton(root.skeleton);if(bone)return bone}if(root.children){var searchNodeSubtree=function(children){for(var i=0;i<children.length;i++){var childNode=children[i];if(childNode.name===nodeName||childNode.uuid===nodeName)return childNode;var result=searchNodeSubtree(childNode.children);if(result)return result}return null},subTreeNode=searchNodeSubtree(root.children);if(subTreeNode)return subTreeNode}return null},THREE.PropertyMixer=function(binding,typeName,valueSize){this.binding=binding,this.valueSize=valueSize;var mixFunction,bufferType=Float64Array;switch(typeName){case"quaternion":mixFunction=this._slerp;break;case"string":case"bool":bufferType=Array,mixFunction=this._select;break;default:mixFunction=this._lerp}this.buffer=new bufferType(4*valueSize),this._mixBufferRegion=mixFunction,this.cumulativeWeight=0,this.useCount=0,this.referenceCount=0},THREE.PropertyMixer.prototype={constructor:THREE.PropertyMixer,accumulate:function(accuIndex,weight){var buffer=this.buffer,stride=this.valueSize,offset=accuIndex*stride+stride,currentWeight=this.cumulativeWeight;if(0===currentWeight){for(var i=0;i!==stride;++i)buffer[offset+i]=buffer[i];currentWeight=weight}else{currentWeight+=weight;var mix=weight/currentWeight;this._mixBufferRegion(buffer,offset,0,mix,stride)}this.cumulativeWeight=currentWeight},apply:function(accuIndex){var stride=this.valueSize,buffer=this.buffer,offset=accuIndex*stride+stride,weight=this.cumulativeWeight,binding=this.binding;if(this.cumulativeWeight=0,1>weight){var originalValueOffset=3*stride;this._mixBufferRegion(buffer,offset,originalValueOffset,1-weight,stride)}for(var i=stride,e=stride+stride;i!==e;++i)if(buffer[i]!==buffer[i+stride]){binding.setValue(buffer,offset);break}},saveOriginalState:function(){var binding=this.binding,buffer=this.buffer,stride=this.valueSize,originalValueOffset=3*stride;binding.getValue(buffer,originalValueOffset);for(var i=stride,e=originalValueOffset;i!==e;++i)buffer[i]=buffer[originalValueOffset+i%stride];this.cumulativeWeight=0},restoreOriginalState:function(){var originalValueOffset=3*this.valueSize;this.binding.setValue(this.buffer,originalValueOffset)},_select:function(buffer,dstOffset,srcOffset,t,stride){if(t>=.5)for(var i=0;i!==stride;++i)buffer[dstOffset+i]=buffer[srcOffset+i]},_slerp:function(buffer,dstOffset,srcOffset,t,stride){THREE.Quaternion.slerpFlat(buffer,dstOffset,buffer,dstOffset,buffer,srcOffset,t)},_lerp:function(buffer,dstOffset,srcOffset,t,stride){for(var s=1-t,i=0;i!==stride;++i){var j=dstOffset+i;buffer[j]=buffer[j]*s+buffer[srcOffset+i]*t}}},THREE.BooleanKeyframeTrack=function(name,times,values){THREE.KeyframeTrack.call(this,name,times,values)},THREE.BooleanKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.BooleanKeyframeTrack,ValueTypeName:"bool",ValueBufferType:Array,DefaultInterpolation:THREE.InterpolateDiscrete,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),THREE.ColorKeyframeTrack=function(name,times,values,interpolation){THREE.KeyframeTrack.call(this,name,times,values,interpolation)},THREE.ColorKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.ColorKeyframeTrack,ValueTypeName:"color"}),THREE.NumberKeyframeTrack=function(name,times,values,interpolation){THREE.KeyframeTrack.call(this,name,times,values,interpolation)},THREE.NumberKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.NumberKeyframeTrack,ValueTypeName:"number"}),THREE.QuaternionKeyframeTrack=function(name,times,values,interpolation){THREE.KeyframeTrack.call(this,name,times,values,interpolation)},THREE.QuaternionKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.QuaternionKeyframeTrack,ValueTypeName:"quaternion",DefaultInterpolation:THREE.InterpolateLinear,InterpolantFactoryMethodLinear:function(result){return new THREE.QuaternionLinearInterpolant(this.times,this.values,this.getValueSize(),result)},InterpolantFactoryMethodSmooth:void 0}),THREE.StringKeyframeTrack=function(name,times,values,interpolation){THREE.KeyframeTrack.call(this,name,times,values,interpolation)},THREE.StringKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.StringKeyframeTrack,ValueTypeName:"string",ValueBufferType:Array,DefaultInterpolation:THREE.InterpolateDiscrete,InterpolantFactoryMethodLinear:void 0,InterpolantFactoryMethodSmooth:void 0}),THREE.VectorKeyframeTrack=function(name,times,values,interpolation){THREE.KeyframeTrack.call(this,name,times,values,interpolation)},THREE.VectorKeyframeTrack.prototype=Object.assign(Object.create(THREE.KeyframeTrack.prototype),{constructor:THREE.VectorKeyframeTrack,ValueTypeName:"vector"}),THREE.Audio=function(listener){THREE.Object3D.call(this),this.type="Audio",this.context=listener.context,this.source=this.context.createBufferSource(),this.source.onended=this.onEnded.bind(this),this.gain=this.context.createGain(),this.gain.connect(listener.getInput()),this.autoplay=!1,this.startTime=0,this.playbackRate=1,this.isPlaying=!1,this.hasPlaybackControl=!0,this.sourceType="empty",this.filter=null},THREE.Audio.prototype=Object.create(THREE.Object3D.prototype),THREE.Audio.prototype.constructor=THREE.Audio,THREE.Audio.prototype.getOutput=function(){return this.gain},THREE.Audio.prototype.setNodeSource=function(audioNode){return this.hasPlaybackControl=!1,this.sourceType="audioNode",this.source=audioNode,this.connect(),this},THREE.Audio.prototype.setBuffer=function(audioBuffer){var scope=this;return scope.source.buffer=audioBuffer,scope.sourceType="buffer",scope.autoplay&&scope.play(),this},THREE.Audio.prototype.play=function(){if(this.isPlaying===!0)return void console.warn("THREE.Audio: Audio is already playing.");if(this.hasPlaybackControl===!1)return void console.warn("THREE.Audio: this Audio has no playback control.");var source=this.context.createBufferSource();source.buffer=this.source.buffer,source.loop=this.source.loop,source.onended=this.source.onended,source.start(0,this.startTime),source.playbackRate.value=this.playbackRate,this.isPlaying=!0,this.source=source,this.connect()},THREE.Audio.prototype.pause=function(){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):(this.source.stop(),void(this.startTime=this.context.currentTime))},THREE.Audio.prototype.stop=function(){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):(this.source.stop(),void(this.startTime=0))},THREE.Audio.prototype.connect=function(){null!==this.filter?(this.source.connect(this.filter),this.filter.connect(this.getOutput())):this.source.connect(this.getOutput())},THREE.Audio.prototype.disconnect=function(){null!==this.filter?(this.source.disconnect(this.filter),this.filter.disconnect(this.getOutput())):this.source.disconnect(this.getOutput())},THREE.Audio.prototype.getFilter=function(){return this.filter},THREE.Audio.prototype.setFilter=function(value){void 0===value&&(value=null),this.isPlaying===!0?(this.disconnect(),this.filter=value,this.connect()):this.filter=value},THREE.Audio.prototype.setPlaybackRate=function(value){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):(this.playbackRate=value,void(this.isPlaying===!0&&(this.source.playbackRate.value=this.playbackRate)))},THREE.Audio.prototype.getPlaybackRate=function(){return this.playbackRate},THREE.Audio.prototype.onEnded=function(){this.isPlaying=!1},THREE.Audio.prototype.setLoop=function(value){return this.hasPlaybackControl===!1?void console.warn("THREE.Audio: this Audio has no playback control."):void(this.source.loop=value)},THREE.Audio.prototype.getLoop=function(){return this.hasPlaybackControl===!1?(console.warn("THREE.Audio: this Audio has no playback control."),!1):this.source.loop},THREE.Audio.prototype.setVolume=function(value){this.gain.gain.value=value},THREE.Audio.prototype.getVolume=function(){return this.gain.gain.value},THREE.AudioAnalyser=function(audio,fftSize){this.analyser=audio.context.createAnalyser(),this.analyser.fftSize=void 0!==fftSize?fftSize:2048,this.data=new Uint8Array(this.analyser.frequencyBinCount),audio.getOutput().connect(this.analyser)},THREE.AudioAnalyser.prototype={constructor:THREE.AudioAnalyser,getData:function(){return this.analyser.getByteFrequencyData(this.data),this.data}},Object.defineProperty(THREE,"AudioContext",{get:function(){var context;return function(){return void 0===context&&(context=new(window.AudioContext||window.webkitAudioContext)),context}}()}),THREE.PositionalAudio=function(listener){THREE.Audio.call(this,listener),this.panner=this.context.createPanner(),this.panner.connect(this.gain)},THREE.PositionalAudio.prototype=Object.create(THREE.Audio.prototype),THREE.PositionalAudio.prototype.constructor=THREE.PositionalAudio,THREE.PositionalAudio.prototype.getOutput=function(){return this.panner},THREE.PositionalAudio.prototype.setRefDistance=function(value){this.panner.refDistance=value},THREE.PositionalAudio.prototype.getRefDistance=function(){return this.panner.refDistance},THREE.PositionalAudio.prototype.setRolloffFactor=function(value){this.panner.rolloffFactor=value},THREE.PositionalAudio.prototype.getRolloffFactor=function(){return this.panner.rolloffFactor},THREE.PositionalAudio.prototype.setDistanceModel=function(value){this.panner.distanceModel=value},THREE.PositionalAudio.prototype.getDistanceModel=function(){return this.panner.distanceModel},THREE.PositionalAudio.prototype.setMaxDistance=function(value){this.panner.maxDistance=value},THREE.PositionalAudio.prototype.getMaxDistance=function(){return this.panner.maxDistance},THREE.PositionalAudio.prototype.updateMatrixWorld=function(){var position=new THREE.Vector3;return function(force){THREE.Object3D.prototype.updateMatrixWorld.call(this,force),position.setFromMatrixPosition(this.matrixWorld),this.panner.setPosition(position.x,position.y,position.z)}}(),THREE.AudioListener=function(){THREE.Object3D.call(this),this.type="AudioListener",this.context=THREE.AudioContext,this.gain=this.context.createGain(),this.gain.connect(this.context.destination),this.filter=null},THREE.AudioListener.prototype=Object.create(THREE.Object3D.prototype),THREE.AudioListener.prototype.constructor=THREE.AudioListener,THREE.AudioListener.prototype.getInput=function(){return this.gain},THREE.AudioListener.prototype.removeFilter=function(){null!==this.filter&&(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination),this.gain.connect(this.context.destination),this.filter=null)},THREE.AudioListener.prototype.setFilter=function(value){null!==this.filter?(this.gain.disconnect(this.filter),this.filter.disconnect(this.context.destination)):this.gain.disconnect(this.context.destination),this.filter=value,this.gain.connect(this.filter),this.filter.connect(this.context.destination)},THREE.AudioListener.prototype.getFilter=function(){return this.filter},THREE.AudioListener.prototype.setMasterVolume=function(value){this.gain.gain.value=value},THREE.AudioListener.prototype.getMasterVolume=function(){return this.gain.gain.value},THREE.AudioListener.prototype.updateMatrixWorld=function(){var position=new THREE.Vector3,quaternion=new THREE.Quaternion,scale=new THREE.Vector3,orientation=new THREE.Vector3;return function(force){THREE.Object3D.prototype.updateMatrixWorld.call(this,force);var listener=this.context.listener,up=this.up;this.matrixWorld.decompose(position,quaternion,scale),orientation.set(0,0,-1).applyQuaternion(quaternion),listener.setPosition(position.x,position.y,position.z),listener.setOrientation(orientation.x,orientation.y,orientation.z,up.x,up.y,up.z)}}(),THREE.Camera=function(){THREE.Object3D.call(this),this.type="Camera",this.matrixWorldInverse=new THREE.Matrix4,this.projectionMatrix=new THREE.Matrix4},THREE.Camera.prototype=Object.create(THREE.Object3D.prototype),THREE.Camera.prototype.constructor=THREE.Camera,THREE.Camera.prototype.getWorldDirection=function(){var quaternion=new THREE.Quaternion;return function(optionalTarget){var result=optionalTarget||new THREE.Vector3;return this.getWorldQuaternion(quaternion),result.set(0,0,-1).applyQuaternion(quaternion)}}(),THREE.Camera.prototype.lookAt=function(){var m1=new THREE.Matrix4;return function(vector){m1.lookAt(this.position,vector,this.up),this.quaternion.setFromRotationMatrix(m1)}}(),THREE.Camera.prototype.clone=function(){return(new this.constructor).copy(this)},THREE.Camera.prototype.copy=function(source){return THREE.Object3D.prototype.copy.call(this,source),this.matrixWorldInverse.copy(source.matrixWorldInverse),this.projectionMatrix.copy(source.projectionMatrix),this},THREE.CubeCamera=function(near,far,cubeResolution){THREE.Object3D.call(this),this.type="CubeCamera";var fov=90,aspect=1,cameraPX=new THREE.PerspectiveCamera(fov,aspect,near,far);cameraPX.up.set(0,-1,0),cameraPX.lookAt(new THREE.Vector3(1,0,0)),this.add(cameraPX);var cameraNX=new THREE.PerspectiveCamera(fov,aspect,near,far);cameraNX.up.set(0,-1,0),cameraNX.lookAt(new THREE.Vector3(-1,0,0)),this.add(cameraNX);var cameraPY=new THREE.PerspectiveCamera(fov,aspect,near,far);cameraPY.up.set(0,0,1),cameraPY.lookAt(new THREE.Vector3(0,1,0)),this.add(cameraPY);var cameraNY=new THREE.PerspectiveCamera(fov,aspect,near,far);cameraNY.up.set(0,0,-1),cameraNY.lookAt(new THREE.Vector3(0,-1,0)),this.add(cameraNY);var cameraPZ=new THREE.PerspectiveCamera(fov,aspect,near,far);cameraPZ.up.set(0,-1,0),cameraPZ.lookAt(new THREE.Vector3(0,0,1)),this.add(cameraPZ);var cameraNZ=new THREE.PerspectiveCamera(fov,aspect,near,far);cameraNZ.up.set(0,-1,0),cameraNZ.lookAt(new THREE.Vector3(0,0,-1)),this.add(cameraNZ);var options={format:THREE.RGBFormat,magFilter:THREE.LinearFilter,minFilter:THREE.LinearFilter};this.renderTarget=new THREE.WebGLRenderTargetCube(cubeResolution,cubeResolution,options),this.updateCubeMap=function(renderer,scene){null===this.parent&&this.updateMatrixWorld();var renderTarget=this.renderTarget,generateMipmaps=renderTarget.texture.generateMipmaps;renderTarget.texture.generateMipmaps=!1,renderTarget.activeCubeFace=0,renderer.render(scene,cameraPX,renderTarget),renderTarget.activeCubeFace=1,renderer.render(scene,cameraNX,renderTarget),renderTarget.activeCubeFace=2,renderer.render(scene,cameraPY,renderTarget),renderTarget.activeCubeFace=3,renderer.render(scene,cameraNY,renderTarget),renderTarget.activeCubeFace=4,renderer.render(scene,cameraPZ,renderTarget),renderTarget.texture.generateMipmaps=generateMipmaps,renderTarget.activeCubeFace=5,renderer.render(scene,cameraNZ,renderTarget),renderer.setRenderTarget(null)}},THREE.CubeCamera.prototype=Object.create(THREE.Object3D.prototype),THREE.CubeCamera.prototype.constructor=THREE.CubeCamera,THREE.OrthographicCamera=function(left,right,top,bottom,near,far){THREE.Camera.call(this),this.type="OrthographicCamera",this.zoom=1,this.left=left,this.right=right,this.top=top,this.bottom=bottom,this.near=void 0!==near?near:.1,this.far=void 0!==far?far:2e3,this.updateProjectionMatrix()},THREE.OrthographicCamera.prototype=Object.create(THREE.Camera.prototype),THREE.OrthographicCamera.prototype.constructor=THREE.OrthographicCamera,THREE.OrthographicCamera.prototype.updateProjectionMatrix=function(){var dx=(this.right-this.left)/(2*this.zoom),dy=(this.top-this.bottom)/(2*this.zoom),cx=(this.right+this.left)/2,cy=(this.top+this.bottom)/2;this.projectionMatrix.makeOrthographic(cx-dx,cx+dx,cy+dy,cy-dy,this.near,this.far)},THREE.OrthographicCamera.prototype.copy=function(source){return THREE.Camera.prototype.copy.call(this,source),this.left=source.left,this.right=source.right,this.top=source.top,this.bottom=source.bottom,this.near=source.near,this.far=source.far,this.zoom=source.zoom,this},THREE.OrthographicCamera.prototype.toJSON=function(meta){var data=THREE.Object3D.prototype.toJSON.call(this,meta);return data.object.zoom=this.zoom,data.object.left=this.left,data.object.right=this.right,data.object.top=this.top,data.object.bottom=this.bottom,data.object.near=this.near,data.object.far=this.far,data},THREE.PerspectiveCamera=function(fov,aspect,near,far){THREE.Camera.call(this),this.type="PerspectiveCamera",this.fov=void 0!==fov?fov:50,this.zoom=1,this.near=void 0!==near?near:.1,this.far=void 0!==far?far:2e3,this.focus=10,this.aspect=void 0!==aspect?aspect:1,this.view=null,this.filmGauge=35,this.filmOffset=0,this.updateProjectionMatrix()},THREE.PerspectiveCamera.prototype=Object.create(THREE.Camera.prototype),THREE.PerspectiveCamera.prototype.constructor=THREE.PerspectiveCamera,THREE.PerspectiveCamera.prototype.setLens=function(focalLength,filmGauge){console.warn("THREE.PerspectiveCamera.setLens is deprecated. Use .setFocalLength and .filmGauge for a photographic setup."),void 0!==filmGauge&&(this.filmGauge=filmGauge),this.setFocalLength(focalLength)},THREE.PerspectiveCamera.prototype.setFocalLength=function(focalLength){var vExtentSlope=.5*this.getFilmHeight()/focalLength;this.fov=2*THREE.Math.RAD2DEG*Math.atan(vExtentSlope),this.updateProjectionMatrix()},THREE.PerspectiveCamera.prototype.getFocalLength=function(){var vExtentSlope=Math.tan(.5*THREE.Math.DEG2RAD*this.fov);return.5*this.getFilmHeight()/vExtentSlope},THREE.PerspectiveCamera.prototype.getEffectiveFOV=function(){return 2*THREE.Math.RAD2DEG*Math.atan(Math.tan(.5*THREE.Math.DEG2RAD*this.fov)/this.zoom)},THREE.PerspectiveCamera.prototype.getFilmWidth=function(){return this.filmGauge*Math.min(this.aspect,1)},THREE.PerspectiveCamera.prototype.getFilmHeight=function(){return this.filmGauge/Math.max(this.aspect,1)},THREE.PerspectiveCamera.prototype.setViewOffset=function(fullWidth,fullHeight,x,y,width,height){this.aspect=fullWidth/fullHeight,this.view={fullWidth:fullWidth,fullHeight:fullHeight,offsetX:x,offsetY:y,width:width,height:height},this.updateProjectionMatrix()},THREE.PerspectiveCamera.prototype.updateProjectionMatrix=function(){var near=this.near,top=near*Math.tan(.5*THREE.Math.DEG2RAD*this.fov)/this.zoom,height=2*top,width=this.aspect*height,left=-.5*width,view=this.view;if(null!==view){var fullWidth=view.fullWidth,fullHeight=view.fullHeight;left+=view.offsetX*width/fullWidth,top-=view.offsetY*height/fullHeight,width*=view.width/fullWidth,height*=view.height/fullHeight}var skew=this.filmOffset;0!==skew&&(left+=near*skew/this.getFilmWidth()),this.projectionMatrix.makeFrustum(left,left+width,top-height,top,near,this.far)},THREE.PerspectiveCamera.prototype.copy=function(source){return THREE.Camera.prototype.copy.call(this,source),this.fov=source.fov,this.zoom=source.zoom,this.near=source.near,this.far=source.far,this.focus=source.focus,this.aspect=source.aspect,this.view=null===source.view?null:Object.assign({},source.view),this.filmGauge=source.filmGauge,this.filmOffset=source.filmOffset,this},THREE.PerspectiveCamera.prototype.toJSON=function(meta){var data=THREE.Object3D.prototype.toJSON.call(this,meta);return data.object.fov=this.fov,data.object.zoom=this.zoom,data.object.near=this.near,data.object.far=this.far,data.object.focus=this.focus,data.object.aspect=this.aspect,null!==this.view&&(data.object.view=Object.assign({},this.view)),data.object.filmGauge=this.filmGauge,data.object.filmOffset=this.filmOffset,data},THREE.StereoCamera=function(){this.type="StereoCamera",this.aspect=1,this.cameraL=new THREE.PerspectiveCamera,this.cameraL.layers.enable(1),this.cameraL.matrixAutoUpdate=!1,this.cameraR=new THREE.PerspectiveCamera,this.cameraR.layers.enable(2),this.cameraR.matrixAutoUpdate=!1},THREE.StereoCamera.prototype={constructor:THREE.StereoCamera,update:function(){var focus,fov,aspect,near,far,eyeRight=new THREE.Matrix4,eyeLeft=new THREE.Matrix4;return function(camera){var needsUpdate=focus!==camera.focus||fov!==camera.fov||aspect!==camera.aspect*this.aspect||near!==camera.near||far!==camera.far;if(needsUpdate){focus=camera.focus,fov=camera.fov,aspect=camera.aspect*this.aspect,near=camera.near,far=camera.far;var xmin,xmax,projectionMatrix=camera.projectionMatrix.clone(),eyeSep=.032,eyeSepOnProjection=eyeSep*near/focus,ymax=near*Math.tan(THREE.Math.DEG2RAD*fov*.5);eyeLeft.elements[12]=-eyeSep,eyeRight.elements[12]=eyeSep,xmin=-ymax*aspect+eyeSepOnProjection,xmax=ymax*aspect+eyeSepOnProjection,projectionMatrix.elements[0]=2*near/(xmax-xmin),projectionMatrix.elements[8]=(xmax+xmin)/(xmax-xmin),this.cameraL.projectionMatrix.copy(projectionMatrix),xmin=-ymax*aspect-eyeSepOnProjection,xmax=ymax*aspect-eyeSepOnProjection,projectionMatrix.elements[0]=2*near/(xmax-xmin),projectionMatrix.elements[8]=(xmax+xmin)/(xmax-xmin),this.cameraR.projectionMatrix.copy(projectionMatrix)}this.cameraL.matrixWorld.copy(camera.matrixWorld).multiply(eyeLeft),this.cameraR.matrixWorld.copy(camera.matrixWorld).multiply(eyeRight)}}()},THREE.Light=function(color,intensity){THREE.Object3D.call(this),this.type="Light",this.color=new THREE.Color(color),this.intensity=void 0!==intensity?intensity:1,this.receiveShadow=void 0},THREE.Light.prototype=Object.create(THREE.Object3D.prototype),THREE.Light.prototype.constructor=THREE.Light,THREE.Light.prototype.copy=function(source){return THREE.Object3D.prototype.copy.call(this,source),this.color.copy(source.color),this.intensity=source.intensity,this},THREE.Light.prototype.toJSON=function(meta){var data=THREE.Object3D.prototype.toJSON.call(this,meta);return data.object.color=this.color.getHex(),data.object.intensity=this.intensity,void 0!==this.groundColor&&(data.object.groundColor=this.groundColor.getHex()),void 0!==this.distance&&(data.object.distance=this.distance),void 0!==this.angle&&(data.object.angle=this.angle),void 0!==this.decay&&(data.object.decay=this.decay),void 0!==this.penumbra&&(data.object.penumbra=this.penumbra),data},THREE.LightShadow=function(camera){this.camera=camera,this.bias=0,this.radius=1,this.mapSize=new THREE.Vector2(512,512),this.map=null,this.matrix=new THREE.Matrix4},THREE.LightShadow.prototype={constructor:THREE.LightShadow,copy:function(source){return this.camera=source.camera.clone(),this.bias=source.bias,this.radius=source.radius,this.mapSize.copy(source.mapSize),this},clone:function(){return(new this.constructor).copy(this)}},THREE.AmbientLight=function(color,intensity){THREE.Light.call(this,color,intensity),this.type="AmbientLight",this.castShadow=void 0},THREE.AmbientLight.prototype=Object.create(THREE.Light.prototype),THREE.AmbientLight.prototype.constructor=THREE.AmbientLight,THREE.DirectionalLight=function(color,intensity){THREE.Light.call(this,color,intensity),this.type="DirectionalLight",this.position.set(0,1,0),this.updateMatrix(),this.target=new THREE.Object3D,this.shadow=new THREE.DirectionalLightShadow},THREE.DirectionalLight.prototype=Object.create(THREE.Light.prototype),THREE.DirectionalLight.prototype.constructor=THREE.DirectionalLight,THREE.DirectionalLight.prototype.copy=function(source){return THREE.Light.prototype.copy.call(this,source),this.target=source.target.clone(),this.shadow=source.shadow.clone(),this},THREE.DirectionalLightShadow=function(light){THREE.LightShadow.call(this,new THREE.OrthographicCamera(-5,5,5,-5,.5,500))},THREE.DirectionalLightShadow.prototype=Object.create(THREE.LightShadow.prototype),THREE.DirectionalLightShadow.prototype.constructor=THREE.DirectionalLightShadow,THREE.HemisphereLight=function(skyColor,groundColor,intensity){THREE.Light.call(this,skyColor,intensity),this.type="HemisphereLight",this.castShadow=void 0,this.position.set(0,1,0),this.updateMatrix(),this.groundColor=new THREE.Color(groundColor)},THREE.HemisphereLight.prototype=Object.create(THREE.Light.prototype),THREE.HemisphereLight.prototype.constructor=THREE.HemisphereLight,THREE.HemisphereLight.prototype.copy=function(source){return THREE.Light.prototype.copy.call(this,source),this.groundColor.copy(source.groundColor),this},THREE.PointLight=function(color,intensity,distance,decay){THREE.Light.call(this,color,intensity),this.type="PointLight",this.distance=void 0!==distance?distance:0,this.decay=void 0!==decay?decay:1,this.shadow=new THREE.LightShadow(new THREE.PerspectiveCamera(90,1,.5,500))},THREE.PointLight.prototype=Object.create(THREE.Light.prototype),THREE.PointLight.prototype.constructor=THREE.PointLight,Object.defineProperty(THREE.PointLight.prototype,"power",{get:function(){return 4*this.intensity*Math.PI},set:function(power){this.intensity=power/(4*Math.PI)}}),THREE.PointLight.prototype.copy=function(source){return THREE.Light.prototype.copy.call(this,source),this.distance=source.distance,this.decay=source.decay,this.shadow=source.shadow.clone(),this},THREE.SpotLight=function(color,intensity,distance,angle,penumbra,decay){THREE.Light.call(this,color,intensity),this.type="SpotLight",this.position.set(0,1,0),this.updateMatrix(),this.target=new THREE.Object3D,this.distance=void 0!==distance?distance:0,this.angle=void 0!==angle?angle:Math.PI/3,this.penumbra=void 0!==penumbra?penumbra:0,this.decay=void 0!==decay?decay:1,this.shadow=new THREE.SpotLightShadow},THREE.SpotLight.prototype=Object.create(THREE.Light.prototype),THREE.SpotLight.prototype.constructor=THREE.SpotLight,Object.defineProperty(THREE.SpotLight.prototype,"power",{get:function(){return this.intensity*Math.PI},set:function(power){this.intensity=power/Math.PI}}),THREE.SpotLight.prototype.copy=function(source){return THREE.Light.prototype.copy.call(this,source),this.distance=source.distance,this.angle=source.angle,this.penumbra=source.penumbra,this.decay=source.decay,this.target=source.target.clone(),this.shadow=source.shadow.clone(),this},THREE.SpotLightShadow=function(){THREE.LightShadow.call(this,new THREE.PerspectiveCamera(50,1,.5,500))},THREE.SpotLightShadow.prototype=Object.create(THREE.LightShadow.prototype),THREE.SpotLightShadow.prototype.constructor=THREE.SpotLightShadow,THREE.SpotLightShadow.prototype.update=function(light){var fov=2*THREE.Math.RAD2DEG*light.angle,aspect=this.mapSize.width/this.mapSize.height,far=light.distance||500,camera=this.camera;fov===camera.fov&&aspect===camera.aspect&&far===camera.far||(camera.fov=fov,camera.aspect=aspect,camera.far=far,camera.updateProjectionMatrix())},THREE.AudioLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.AudioLoader.prototype={constructor:THREE.AudioLoader,load:function(url,onLoad,onProgress,onError){var loader=new THREE.XHRLoader(this.manager);loader.setResponseType("arraybuffer"),loader.load(url,function(buffer){var context=THREE.AudioContext;context.decodeAudioData(buffer,function(audioBuffer){onLoad(audioBuffer)})},onProgress,onError)}},THREE.Cache={enabled:!1,files:{},add:function(key,file){this.enabled!==!1&&(this.files[key]=file)},get:function(key){return this.enabled!==!1?this.files[key]:void 0},remove:function(key){delete this.files[key]},clear:function(){this.files={}}},THREE.Loader=function(){this.onLoadStart=function(){},this.onLoadProgress=function(){},this.onLoadComplete=function(){}},THREE.Loader.prototype={constructor:THREE.Loader,crossOrigin:void 0,extractUrlBase:function(url){var parts=url.split("/");return 1===parts.length?"./":(parts.pop(),parts.join("/")+"/")},initMaterials:function(materials,texturePath,crossOrigin){for(var array=[],i=0;i<materials.length;++i)array[i]=this.createMaterial(materials[i],texturePath,crossOrigin);return array},createMaterial:function(){var color,textureLoader,materialLoader;return function(m,texturePath,crossOrigin){function loadTexture(path,repeat,offset,wrap,anisotropy){var texture,fullPath=texturePath+path,loader=THREE.Loader.Handlers.get(fullPath);null!==loader?texture=loader.load(fullPath):(textureLoader.setCrossOrigin(crossOrigin),texture=textureLoader.load(fullPath)),void 0!==repeat&&(texture.repeat.fromArray(repeat),1!==repeat[0]&&(texture.wrapS=THREE.RepeatWrapping),1!==repeat[1]&&(texture.wrapT=THREE.RepeatWrapping)),void 0!==offset&&texture.offset.fromArray(offset),void 0!==wrap&&("repeat"===wrap[0]&&(texture.wrapS=THREE.RepeatWrapping),"mirror"===wrap[0]&&(texture.wrapS=THREE.MirroredRepeatWrapping),"repeat"===wrap[1]&&(texture.wrapT=THREE.RepeatWrapping),
"mirror"===wrap[1]&&(texture.wrapT=THREE.MirroredRepeatWrapping)),void 0!==anisotropy&&(texture.anisotropy=anisotropy);var uuid=THREE.Math.generateUUID();return textures[uuid]=texture,uuid}void 0===color&&(color=new THREE.Color),void 0===textureLoader&&(textureLoader=new THREE.TextureLoader),void 0===materialLoader&&(materialLoader=new THREE.MaterialLoader);var textures={},json={uuid:THREE.Math.generateUUID(),type:"MeshLambertMaterial"};for(var name in m){var value=m[name];switch(name){case"DbgColor":case"DbgIndex":case"opticalDensity":case"illumination":break;case"DbgName":json.name=value;break;case"blending":json.blending=THREE[value];break;case"colorAmbient":case"mapAmbient":console.warn("THREE.Loader.createMaterial:",name,"is no longer supported.");break;case"colorDiffuse":json.color=color.fromArray(value).getHex();break;case"colorSpecular":json.specular=color.fromArray(value).getHex();break;case"colorEmissive":json.emissive=color.fromArray(value).getHex();break;case"specularCoef":json.shininess=value;break;case"shading":"basic"===value.toLowerCase()&&(json.type="MeshBasicMaterial"),"phong"===value.toLowerCase()&&(json.type="MeshPhongMaterial");break;case"mapDiffuse":json.map=loadTexture(value,m.mapDiffuseRepeat,m.mapDiffuseOffset,m.mapDiffuseWrap,m.mapDiffuseAnisotropy);break;case"mapDiffuseRepeat":case"mapDiffuseOffset":case"mapDiffuseWrap":case"mapDiffuseAnisotropy":break;case"mapLight":json.lightMap=loadTexture(value,m.mapLightRepeat,m.mapLightOffset,m.mapLightWrap,m.mapLightAnisotropy);break;case"mapLightRepeat":case"mapLightOffset":case"mapLightWrap":case"mapLightAnisotropy":break;case"mapAO":json.aoMap=loadTexture(value,m.mapAORepeat,m.mapAOOffset,m.mapAOWrap,m.mapAOAnisotropy);break;case"mapAORepeat":case"mapAOOffset":case"mapAOWrap":case"mapAOAnisotropy":break;case"mapBump":json.bumpMap=loadTexture(value,m.mapBumpRepeat,m.mapBumpOffset,m.mapBumpWrap,m.mapBumpAnisotropy);break;case"mapBumpScale":json.bumpScale=value;break;case"mapBumpRepeat":case"mapBumpOffset":case"mapBumpWrap":case"mapBumpAnisotropy":break;case"mapNormal":json.normalMap=loadTexture(value,m.mapNormalRepeat,m.mapNormalOffset,m.mapNormalWrap,m.mapNormalAnisotropy);break;case"mapNormalFactor":json.normalScale=[value,value];break;case"mapNormalRepeat":case"mapNormalOffset":case"mapNormalWrap":case"mapNormalAnisotropy":break;case"mapSpecular":json.specularMap=loadTexture(value,m.mapSpecularRepeat,m.mapSpecularOffset,m.mapSpecularWrap,m.mapSpecularAnisotropy);break;case"mapSpecularRepeat":case"mapSpecularOffset":case"mapSpecularWrap":case"mapSpecularAnisotropy":break;case"mapAlpha":json.alphaMap=loadTexture(value,m.mapAlphaRepeat,m.mapAlphaOffset,m.mapAlphaWrap,m.mapAlphaAnisotropy);break;case"mapAlphaRepeat":case"mapAlphaOffset":case"mapAlphaWrap":case"mapAlphaAnisotropy":break;case"flipSided":json.side=THREE.BackSide;break;case"doubleSided":json.side=THREE.DoubleSide;break;case"transparency":console.warn("THREE.Loader.createMaterial: transparency has been renamed to opacity"),json.opacity=value;break;case"depthTest":case"depthWrite":case"colorWrite":case"opacity":case"reflectivity":case"transparent":case"visible":case"wireframe":json[name]=value;break;case"vertexColors":value===!0&&(json.vertexColors=THREE.VertexColors),"face"===value&&(json.vertexColors=THREE.FaceColors);break;default:console.error("THREE.Loader.createMaterial: Unsupported",name,value)}}return"MeshBasicMaterial"===json.type&&delete json.emissive,"MeshPhongMaterial"!==json.type&&delete json.specular,json.opacity<1&&(json.transparent=!0),materialLoader.setTextures(textures),materialLoader.parse(json)}}()},THREE.Loader.Handlers={handlers:[],add:function(regex,loader){this.handlers.push(regex,loader)},get:function(file){for(var handlers=this.handlers,i=0,l=handlers.length;l>i;i+=2){var regex=handlers[i],loader=handlers[i+1];if(regex.test(file))return loader}return null}},THREE.XHRLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.XHRLoader.prototype={constructor:THREE.XHRLoader,load:function(url,onLoad,onProgress,onError){void 0!==this.path&&(url=this.path+url);var scope=this,cached=THREE.Cache.get(url);if(void 0!==cached)return onLoad&&setTimeout(function(){onLoad(cached)},0),cached;var request=new XMLHttpRequest;return request.overrideMimeType("text/plain"),request.open("GET",url,!0),request.addEventListener("load",function(event){var response=event.target.response;THREE.Cache.add(url,response),200===this.status?(onLoad&&onLoad(response),scope.manager.itemEnd(url)):0===this.status?(console.warn("THREE.XHRLoader: HTTP Status 0 received."),onLoad&&onLoad(response),scope.manager.itemEnd(url)):(onError&&onError(event),scope.manager.itemError(url))},!1),void 0!==onProgress&&request.addEventListener("progress",function(event){onProgress(event)},!1),request.addEventListener("error",function(event){onError&&onError(event),scope.manager.itemError(url)},!1),void 0!==this.responseType&&(request.responseType=this.responseType),void 0!==this.withCredentials&&(request.withCredentials=this.withCredentials),request.send(null),scope.manager.itemStart(url),request},setPath:function(value){this.path=value},setResponseType:function(value){this.responseType=value},setWithCredentials:function(value){this.withCredentials=value}},THREE.FontLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.FontLoader.prototype={constructor:THREE.FontLoader,load:function(url,onLoad,onProgress,onError){var loader=new THREE.XHRLoader(this.manager);loader.load(url,function(text){onLoad(new THREE.Font(JSON.parse(text.substring(65,text.length-2))))},onProgress,onError)}},THREE.ImageLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.ImageLoader.prototype={constructor:THREE.ImageLoader,load:function(url,onLoad,onProgress,onError){void 0!==this.path&&(url=this.path+url);var scope=this,cached=THREE.Cache.get(url);if(void 0!==cached)return scope.manager.itemStart(url),onLoad?setTimeout(function(){onLoad(cached),scope.manager.itemEnd(url)},0):scope.manager.itemEnd(url),cached;var image=document.createElement("img");return image.addEventListener("load",function(event){THREE.Cache.add(url,this),onLoad&&onLoad(this),scope.manager.itemEnd(url)},!1),void 0!==onProgress&&image.addEventListener("progress",function(event){onProgress(event)},!1),image.addEventListener("error",function(event){onError&&onError(event),scope.manager.itemError(url)},!1),void 0!==this.crossOrigin&&(image.crossOrigin=this.crossOrigin),scope.manager.itemStart(url),image.src=url,image},setCrossOrigin:function(value){this.crossOrigin=value},setPath:function(value){this.path=value}},THREE.JSONLoader=function(manager){"boolean"==typeof manager&&(console.warn("THREE.JSONLoader: showStatus parameter has been removed from constructor."),manager=void 0),this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager,this.withCredentials=!1},THREE.JSONLoader.prototype={constructor:THREE.JSONLoader,get statusDomElement(){return void 0===this._statusDomElement&&(this._statusDomElement=document.createElement("div")),console.warn("THREE.JSONLoader: .statusDomElement has been removed."),this._statusDomElement},load:function(url,onLoad,onProgress,onError){var scope=this,texturePath=this.texturePath&&"string"==typeof this.texturePath?this.texturePath:THREE.Loader.prototype.extractUrlBase(url),loader=new THREE.XHRLoader(this.manager);loader.setWithCredentials(this.withCredentials),loader.load(url,function(text){var json=JSON.parse(text),metadata=json.metadata;if(void 0!==metadata){var type=metadata.type;if(void 0!==type){if("object"===type.toLowerCase())return void console.error("THREE.JSONLoader: "+url+" should be loaded with THREE.ObjectLoader instead.");if("scene"===type.toLowerCase())return void console.error("THREE.JSONLoader: "+url+" should be loaded with THREE.SceneLoader instead.")}}var object=scope.parse(json,texturePath);onLoad(object.geometry,object.materials)},onProgress,onError)},setTexturePath:function(value){this.texturePath=value},parse:function(json,texturePath){function parseModel(scale){function isBitSet(value,position){return value&1<<position}var i,j,fi,offset,zLength,colorIndex,normalIndex,uvIndex,materialIndex,type,isQuad,hasMaterial,hasFaceVertexUv,hasFaceNormal,hasFaceVertexNormal,hasFaceColor,hasFaceVertexColor,vertex,face,faceA,faceB,hex,normal,uvLayer,uv,u,v,faces=json.faces,vertices=json.vertices,normals=json.normals,colors=json.colors,nUvLayers=0;if(void 0!==json.uvs){for(i=0;i<json.uvs.length;i++)json.uvs[i].length&&nUvLayers++;for(i=0;nUvLayers>i;i++)geometry.faceVertexUvs[i]=[]}for(offset=0,zLength=vertices.length;zLength>offset;)vertex=new THREE.Vector3,vertex.x=vertices[offset++]*scale,vertex.y=vertices[offset++]*scale,vertex.z=vertices[offset++]*scale,geometry.vertices.push(vertex);for(offset=0,zLength=faces.length;zLength>offset;)if(type=faces[offset++],isQuad=isBitSet(type,0),hasMaterial=isBitSet(type,1),hasFaceVertexUv=isBitSet(type,3),hasFaceNormal=isBitSet(type,4),hasFaceVertexNormal=isBitSet(type,5),hasFaceColor=isBitSet(type,6),hasFaceVertexColor=isBitSet(type,7),isQuad){if(faceA=new THREE.Face3,faceA.a=faces[offset],faceA.b=faces[offset+1],faceA.c=faces[offset+3],faceB=new THREE.Face3,faceB.a=faces[offset+1],faceB.b=faces[offset+2],faceB.c=faces[offset+3],offset+=4,hasMaterial&&(materialIndex=faces[offset++],faceA.materialIndex=materialIndex,faceB.materialIndex=materialIndex),fi=geometry.faces.length,hasFaceVertexUv)for(i=0;nUvLayers>i;i++)for(uvLayer=json.uvs[i],geometry.faceVertexUvs[i][fi]=[],geometry.faceVertexUvs[i][fi+1]=[],j=0;4>j;j++)uvIndex=faces[offset++],u=uvLayer[2*uvIndex],v=uvLayer[2*uvIndex+1],uv=new THREE.Vector2(u,v),2!==j&&geometry.faceVertexUvs[i][fi].push(uv),0!==j&&geometry.faceVertexUvs[i][fi+1].push(uv);if(hasFaceNormal&&(normalIndex=3*faces[offset++],faceA.normal.set(normals[normalIndex++],normals[normalIndex++],normals[normalIndex]),faceB.normal.copy(faceA.normal)),hasFaceVertexNormal)for(i=0;4>i;i++)normalIndex=3*faces[offset++],normal=new THREE.Vector3(normals[normalIndex++],normals[normalIndex++],normals[normalIndex]),2!==i&&faceA.vertexNormals.push(normal),0!==i&&faceB.vertexNormals.push(normal);if(hasFaceColor&&(colorIndex=faces[offset++],hex=colors[colorIndex],faceA.color.setHex(hex),faceB.color.setHex(hex)),hasFaceVertexColor)for(i=0;4>i;i++)colorIndex=faces[offset++],hex=colors[colorIndex],2!==i&&faceA.vertexColors.push(new THREE.Color(hex)),0!==i&&faceB.vertexColors.push(new THREE.Color(hex));geometry.faces.push(faceA),geometry.faces.push(faceB)}else{if(face=new THREE.Face3,face.a=faces[offset++],face.b=faces[offset++],face.c=faces[offset++],hasMaterial&&(materialIndex=faces[offset++],face.materialIndex=materialIndex),fi=geometry.faces.length,hasFaceVertexUv)for(i=0;nUvLayers>i;i++)for(uvLayer=json.uvs[i],geometry.faceVertexUvs[i][fi]=[],j=0;3>j;j++)uvIndex=faces[offset++],u=uvLayer[2*uvIndex],v=uvLayer[2*uvIndex+1],uv=new THREE.Vector2(u,v),geometry.faceVertexUvs[i][fi].push(uv);if(hasFaceNormal&&(normalIndex=3*faces[offset++],face.normal.set(normals[normalIndex++],normals[normalIndex++],normals[normalIndex])),hasFaceVertexNormal)for(i=0;3>i;i++)normalIndex=3*faces[offset++],normal=new THREE.Vector3(normals[normalIndex++],normals[normalIndex++],normals[normalIndex]),face.vertexNormals.push(normal);if(hasFaceColor&&(colorIndex=faces[offset++],face.color.setHex(colors[colorIndex])),hasFaceVertexColor)for(i=0;3>i;i++)colorIndex=faces[offset++],face.vertexColors.push(new THREE.Color(colors[colorIndex]));geometry.faces.push(face)}}function parseSkin(){var influencesPerVertex=void 0!==json.influencesPerVertex?json.influencesPerVertex:2;if(json.skinWeights)for(var i=0,l=json.skinWeights.length;l>i;i+=influencesPerVertex){var x=json.skinWeights[i],y=influencesPerVertex>1?json.skinWeights[i+1]:0,z=influencesPerVertex>2?json.skinWeights[i+2]:0,w=influencesPerVertex>3?json.skinWeights[i+3]:0;geometry.skinWeights.push(new THREE.Vector4(x,y,z,w))}if(json.skinIndices)for(var i=0,l=json.skinIndices.length;l>i;i+=influencesPerVertex){var a=json.skinIndices[i],b=influencesPerVertex>1?json.skinIndices[i+1]:0,c=influencesPerVertex>2?json.skinIndices[i+2]:0,d=influencesPerVertex>3?json.skinIndices[i+3]:0;geometry.skinIndices.push(new THREE.Vector4(a,b,c,d))}geometry.bones=json.bones,geometry.bones&&geometry.bones.length>0&&(geometry.skinWeights.length!==geometry.skinIndices.length||geometry.skinIndices.length!==geometry.vertices.length)&&console.warn("When skinning, number of vertices ("+geometry.vertices.length+"), skinIndices ("+geometry.skinIndices.length+"), and skinWeights ("+geometry.skinWeights.length+") should match.")}function parseMorphing(scale){if(void 0!==json.morphTargets)for(var i=0,l=json.morphTargets.length;l>i;i++){geometry.morphTargets[i]={},geometry.morphTargets[i].name=json.morphTargets[i].name,geometry.morphTargets[i].vertices=[];for(var dstVertices=geometry.morphTargets[i].vertices,srcVertices=json.morphTargets[i].vertices,v=0,vl=srcVertices.length;vl>v;v+=3){var vertex=new THREE.Vector3;vertex.x=srcVertices[v]*scale,vertex.y=srcVertices[v+1]*scale,vertex.z=srcVertices[v+2]*scale,dstVertices.push(vertex)}}if(void 0!==json.morphColors&&json.morphColors.length>0){console.warn('THREE.JSONLoader: "morphColors" no longer supported. Using them as face colors.');for(var faces=geometry.faces,morphColors=json.morphColors[0].colors,i=0,l=faces.length;l>i;i++)faces[i].color.fromArray(morphColors,3*i)}}function parseAnimations(){var outputAnimations=[],animations=[];void 0!==json.animation&&animations.push(json.animation),void 0!==json.animations&&(json.animations.length?animations=animations.concat(json.animations):animations.push(json.animations));for(var i=0;i<animations.length;i++){var clip=THREE.AnimationClip.parseAnimation(animations[i],geometry.bones);clip&&outputAnimations.push(clip)}if(geometry.morphTargets){var morphAnimationClips=THREE.AnimationClip.CreateClipsFromMorphTargetSequences(geometry.morphTargets,10);outputAnimations=outputAnimations.concat(morphAnimationClips)}outputAnimations.length>0&&(geometry.animations=outputAnimations)}var geometry=new THREE.Geometry,scale=void 0!==json.scale?1/json.scale:1;if(parseModel(scale),parseSkin(),parseMorphing(scale),parseAnimations(),geometry.computeFaceNormals(),geometry.computeBoundingSphere(),void 0===json.materials||0===json.materials.length)return{geometry:geometry};var materials=THREE.Loader.prototype.initMaterials(json.materials,texturePath,this.crossOrigin);return{geometry:geometry,materials:materials}}},THREE.LoadingManager=function(onLoad,onProgress,onError){var scope=this,isLoading=!1,itemsLoaded=0,itemsTotal=0;this.onStart=void 0,this.onLoad=onLoad,this.onProgress=onProgress,this.onError=onError,this.itemStart=function(url){itemsTotal++,isLoading===!1&&void 0!==scope.onStart&&scope.onStart(url,itemsLoaded,itemsTotal),isLoading=!0},this.itemEnd=function(url){itemsLoaded++,void 0!==scope.onProgress&&scope.onProgress(url,itemsLoaded,itemsTotal),itemsLoaded===itemsTotal&&(isLoading=!1,void 0!==scope.onLoad&&scope.onLoad())},this.itemError=function(url){void 0!==scope.onError&&scope.onError(url)}},THREE.DefaultLoadingManager=new THREE.LoadingManager,THREE.BufferGeometryLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.BufferGeometryLoader.prototype={constructor:THREE.BufferGeometryLoader,load:function(url,onLoad,onProgress,onError){var scope=this,loader=new THREE.XHRLoader(scope.manager);loader.load(url,function(text){onLoad(scope.parse(JSON.parse(text)))},onProgress,onError)},parse:function(json){var geometry=new THREE.BufferGeometry,index=json.data.index,TYPED_ARRAYS={Int8Array:Int8Array,Uint8Array:Uint8Array,Uint8ClampedArray:Uint8ClampedArray,Int16Array:Int16Array,Uint16Array:Uint16Array,Int32Array:Int32Array,Uint32Array:Uint32Array,Float32Array:Float32Array,Float64Array:Float64Array};if(void 0!==index){var typedArray=new TYPED_ARRAYS[index.type](index.array);geometry.setIndex(new THREE.BufferAttribute(typedArray,1))}var attributes=json.data.attributes;for(var key in attributes){var attribute=attributes[key],typedArray=new TYPED_ARRAYS[attribute.type](attribute.array);geometry.addAttribute(key,new THREE.BufferAttribute(typedArray,attribute.itemSize,attribute.normalized))}var groups=json.data.groups||json.data.drawcalls||json.data.offsets;if(void 0!==groups)for(var i=0,n=groups.length;i!==n;++i){var group=groups[i];geometry.addGroup(group.start,group.count,group.materialIndex)}var boundingSphere=json.data.boundingSphere;if(void 0!==boundingSphere){var center=new THREE.Vector3;void 0!==boundingSphere.center&&center.fromArray(boundingSphere.center),geometry.boundingSphere=new THREE.Sphere(center,boundingSphere.radius)}return geometry}},THREE.MaterialLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager,this.textures={}},THREE.MaterialLoader.prototype={constructor:THREE.MaterialLoader,load:function(url,onLoad,onProgress,onError){var scope=this,loader=new THREE.XHRLoader(scope.manager);loader.load(url,function(text){onLoad(scope.parse(JSON.parse(text)))},onProgress,onError)},setTextures:function(value){this.textures=value},getTexture:function(name){var textures=this.textures;return void 0===textures[name]&&console.warn("THREE.MaterialLoader: Undefined texture",name),textures[name]},parse:function(json){var material=new THREE[json.type];if(void 0!==json.uuid&&(material.uuid=json.uuid),void 0!==json.name&&(material.name=json.name),void 0!==json.color&&material.color.setHex(json.color),void 0!==json.roughness&&(material.roughness=json.roughness),void 0!==json.metalness&&(material.metalness=json.metalness),void 0!==json.emissive&&material.emissive.setHex(json.emissive),void 0!==json.specular&&material.specular.setHex(json.specular),void 0!==json.shininess&&(material.shininess=json.shininess),void 0!==json.uniforms&&(material.uniforms=json.uniforms),void 0!==json.vertexShader&&(material.vertexShader=json.vertexShader),void 0!==json.fragmentShader&&(material.fragmentShader=json.fragmentShader),void 0!==json.vertexColors&&(material.vertexColors=json.vertexColors),void 0!==json.shading&&(material.shading=json.shading),void 0!==json.blending&&(material.blending=json.blending),void 0!==json.side&&(material.side=json.side),void 0!==json.opacity&&(material.opacity=json.opacity),void 0!==json.transparent&&(material.transparent=json.transparent),void 0!==json.alphaTest&&(material.alphaTest=json.alphaTest),void 0!==json.depthTest&&(material.depthTest=json.depthTest),void 0!==json.depthWrite&&(material.depthWrite=json.depthWrite),void 0!==json.colorWrite&&(material.colorWrite=json.colorWrite),void 0!==json.wireframe&&(material.wireframe=json.wireframe),void 0!==json.wireframeLinewidth&&(material.wireframeLinewidth=json.wireframeLinewidth),void 0!==json.size&&(material.size=json.size),void 0!==json.sizeAttenuation&&(material.sizeAttenuation=json.sizeAttenuation),void 0!==json.map&&(material.map=this.getTexture(json.map)),void 0!==json.alphaMap&&(material.alphaMap=this.getTexture(json.alphaMap),material.transparent=!0),void 0!==json.bumpMap&&(material.bumpMap=this.getTexture(json.bumpMap)),void 0!==json.bumpScale&&(material.bumpScale=json.bumpScale),void 0!==json.normalMap&&(material.normalMap=this.getTexture(json.normalMap)),void 0!==json.normalScale){var normalScale=json.normalScale;Array.isArray(normalScale)===!1&&(normalScale=[normalScale,normalScale]),material.normalScale=(new THREE.Vector2).fromArray(normalScale)}if(void 0!==json.displacementMap&&(material.displacementMap=this.getTexture(json.displacementMap)),void 0!==json.displacementScale&&(material.displacementScale=json.displacementScale),void 0!==json.displacementBias&&(material.displacementBias=json.displacementBias),void 0!==json.roughnessMap&&(material.roughnessMap=this.getTexture(json.roughnessMap)),void 0!==json.metalnessMap&&(material.metalnessMap=this.getTexture(json.metalnessMap)),void 0!==json.emissiveMap&&(material.emissiveMap=this.getTexture(json.emissiveMap)),void 0!==json.emissiveIntensity&&(material.emissiveIntensity=json.emissiveIntensity),void 0!==json.specularMap&&(material.specularMap=this.getTexture(json.specularMap)),void 0!==json.envMap&&(material.envMap=this.getTexture(json.envMap),material.combine=THREE.MultiplyOperation),json.reflectivity&&(material.reflectivity=json.reflectivity),void 0!==json.lightMap&&(material.lightMap=this.getTexture(json.lightMap)),void 0!==json.lightMapIntensity&&(material.lightMapIntensity=json.lightMapIntensity),void 0!==json.aoMap&&(material.aoMap=this.getTexture(json.aoMap)),void 0!==json.aoMapIntensity&&(material.aoMapIntensity=json.aoMapIntensity),void 0!==json.materials)for(var i=0,l=json.materials.length;l>i;i++)material.materials.push(this.parse(json.materials[i]));return material}},THREE.ObjectLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager,this.texturePath=""},THREE.ObjectLoader.prototype={constructor:THREE.ObjectLoader,load:function(url,onLoad,onProgress,onError){""===this.texturePath&&(this.texturePath=url.substring(0,url.lastIndexOf("/")+1));var scope=this,loader=new THREE.XHRLoader(scope.manager);loader.load(url,function(text){scope.parse(JSON.parse(text),onLoad)},onProgress,onError)},setTexturePath:function(value){this.texturePath=value},setCrossOrigin:function(value){this.crossOrigin=value},parse:function(json,onLoad){var geometries=this.parseGeometries(json.geometries),images=this.parseImages(json.images,function(){void 0!==onLoad&&onLoad(object)}),textures=this.parseTextures(json.textures,images),materials=this.parseMaterials(json.materials,textures),object=this.parseObject(json.object,geometries,materials);return json.animations&&(object.animations=this.parseAnimations(json.animations)),void 0!==json.images&&0!==json.images.length||void 0!==onLoad&&onLoad(object),object},parseGeometries:function(json){var geometries={};if(void 0!==json)for(var geometryLoader=new THREE.JSONLoader,bufferGeometryLoader=new THREE.BufferGeometryLoader,i=0,l=json.length;l>i;i++){var geometry,data=json[i];switch(data.type){case"PlaneGeometry":case"PlaneBufferGeometry":geometry=new THREE[data.type](data.width,data.height,data.widthSegments,data.heightSegments);break;case"BoxGeometry":case"BoxBufferGeometry":case"CubeGeometry":geometry=new THREE[data.type](data.width,data.height,data.depth,data.widthSegments,data.heightSegments,data.depthSegments);break;case"CircleGeometry":case"CircleBufferGeometry":geometry=new THREE[data.type](data.radius,data.segments,data.thetaStart,data.thetaLength);break;case"CylinderGeometry":case"CylinderBufferGeometry":geometry=new THREE[data.type](data.radiusTop,data.radiusBottom,data.height,data.radialSegments,data.heightSegments,data.openEnded,data.thetaStart,data.thetaLength);break;case"SphereGeometry":case"SphereBufferGeometry":geometry=new THREE[data.type](data.radius,data.widthSegments,data.heightSegments,data.phiStart,data.phiLength,data.thetaStart,data.thetaLength);break;case"DodecahedronGeometry":geometry=new THREE.DodecahedronGeometry(data.radius,data.detail);break;case"IcosahedronGeometry":geometry=new THREE.IcosahedronGeometry(data.radius,data.detail);break;case"OctahedronGeometry":geometry=new THREE.OctahedronGeometry(data.radius,data.detail);break;case"TetrahedronGeometry":geometry=new THREE.TetrahedronGeometry(data.radius,data.detail);break;case"RingGeometry":case"RingBufferGeometry":geometry=new THREE[data.type](data.innerRadius,data.outerRadius,data.thetaSegments,data.phiSegments,data.thetaStart,data.thetaLength);break;case"TorusGeometry":case"TorusBufferGeometry":geometry=new THREE[data.type](data.radius,data.tube,data.radialSegments,data.tubularSegments,data.arc);break;case"TorusKnotGeometry":case"TorusKnotBufferGeometry":geometry=new THREE[data.type](data.radius,data.tube,data.tubularSegments,data.radialSegments,data.p,data.q);break;case"LatheGeometry":case"LatheBufferGeometry":geometry=new THREE[data.type](data.points,data.segments,data.phiStart,data.phiLength);break;case"BufferGeometry":geometry=bufferGeometryLoader.parse(data);break;case"Geometry":geometry=geometryLoader.parse(data.data,this.texturePath).geometry;break;default:console.warn('THREE.ObjectLoader: Unsupported geometry type "'+data.type+'"');continue}geometry.uuid=data.uuid,void 0!==data.name&&(geometry.name=data.name),geometries[data.uuid]=geometry}return geometries},parseMaterials:function(json,textures){var materials={};if(void 0!==json){var loader=new THREE.MaterialLoader;loader.setTextures(textures);for(var i=0,l=json.length;l>i;i++){var material=loader.parse(json[i]);materials[material.uuid]=material}}return materials},parseAnimations:function(json){for(var animations=[],i=0;i<json.length;i++){var clip=THREE.AnimationClip.parse(json[i]);animations.push(clip)}return animations},parseImages:function(json,onLoad){function loadImage(url){return scope.manager.itemStart(url),loader.load(url,function(){scope.manager.itemEnd(url)})}var scope=this,images={};if(void 0!==json&&json.length>0){var manager=new THREE.LoadingManager(onLoad),loader=new THREE.ImageLoader(manager);loader.setCrossOrigin(this.crossOrigin);for(var i=0,l=json.length;l>i;i++){var image=json[i],path=/^(\/\/)|([a-z]+:(\/\/)?)/i.test(image.url)?image.url:scope.texturePath+image.url;images[image.uuid]=loadImage(path)}}return images},parseTextures:function(json,images){function parseConstant(value){return"number"==typeof value?value:(console.warn("THREE.ObjectLoader.parseTexture: Constant should be in numeric form.",value),THREE[value])}var textures={};if(void 0!==json)for(var i=0,l=json.length;l>i;i++){var data=json[i];void 0===data.image&&console.warn('THREE.ObjectLoader: No "image" specified for',data.uuid),void 0===images[data.image]&&console.warn("THREE.ObjectLoader: Undefined image",data.image);var texture=new THREE.Texture(images[data.image]);texture.needsUpdate=!0,texture.uuid=data.uuid,void 0!==data.name&&(texture.name=data.name),void 0!==data.mapping&&(texture.mapping=parseConstant(data.mapping)),void 0!==data.offset&&(texture.offset=new THREE.Vector2(data.offset[0],data.offset[1])),void 0!==data.repeat&&(texture.repeat=new THREE.Vector2(data.repeat[0],data.repeat[1])),void 0!==data.minFilter&&(texture.minFilter=parseConstant(data.minFilter)),void 0!==data.magFilter&&(texture.magFilter=parseConstant(data.magFilter)),void 0!==data.anisotropy&&(texture.anisotropy=data.anisotropy),Array.isArray(data.wrap)&&(texture.wrapS=parseConstant(data.wrap[0]),texture.wrapT=parseConstant(data.wrap[1])),textures[data.uuid]=texture}return textures},parseObject:function(){var matrix=new THREE.Matrix4;return function(data,geometries,materials){function getGeometry(name){return void 0===geometries[name]&&console.warn("THREE.ObjectLoader: Undefined geometry",name),geometries[name]}function getMaterial(name){return void 0!==name?(void 0===materials[name]&&console.warn("THREE.ObjectLoader: Undefined material",name),materials[name]):void 0}var object;switch(data.type){case"Scene":object=new THREE.Scene;break;case"PerspectiveCamera":object=new THREE.PerspectiveCamera(data.fov,data.aspect,data.near,data.far),void 0!==data.focus&&(object.focus=data.focus),void 0!==data.zoom&&(object.zoom=data.zoom),void 0!==data.filmGauge&&(object.filmGauge=data.filmGauge),void 0!==data.filmOffset&&(object.filmOffset=data.filmOffset),void 0!==data.view&&(object.view=Object.assign({},data.view));break;case"OrthographicCamera":object=new THREE.OrthographicCamera(data.left,data.right,data.top,data.bottom,data.near,data.far);break;case"AmbientLight":object=new THREE.AmbientLight(data.color,data.intensity);break;case"DirectionalLight":object=new THREE.DirectionalLight(data.color,data.intensity);break;case"PointLight":object=new THREE.PointLight(data.color,data.intensity,data.distance,data.decay);break;case"SpotLight":object=new THREE.SpotLight(data.color,data.intensity,data.distance,data.angle,data.penumbra,data.decay);break;case"HemisphereLight":object=new THREE.HemisphereLight(data.color,data.groundColor,data.intensity);break;case"Mesh":var geometry=getGeometry(data.geometry),material=getMaterial(data.material);object=geometry.bones&&geometry.bones.length>0?new THREE.SkinnedMesh(geometry,material):new THREE.Mesh(geometry,material);break;case"LOD":object=new THREE.LOD;break;case"Line":object=new THREE.Line(getGeometry(data.geometry),getMaterial(data.material),data.mode);break;case"PointCloud":case"Points":object=new THREE.Points(getGeometry(data.geometry),getMaterial(data.material));break;case"Sprite":object=new THREE.Sprite(getMaterial(data.material));break;case"Group":object=new THREE.Group;break;default:object=new THREE.Object3D}if(object.uuid=data.uuid,void 0!==data.name&&(object.name=data.name),void 0!==data.matrix?(matrix.fromArray(data.matrix),matrix.decompose(object.position,object.quaternion,object.scale)):(void 0!==data.position&&object.position.fromArray(data.position),void 0!==data.rotation&&object.rotation.fromArray(data.rotation),void 0!==data.scale&&object.scale.fromArray(data.scale)),void 0!==data.castShadow&&(object.castShadow=data.castShadow),void 0!==data.receiveShadow&&(object.receiveShadow=data.receiveShadow),void 0!==data.visible&&(object.visible=data.visible),void 0!==data.userData&&(object.userData=data.userData),void 0!==data.children)for(var child in data.children)object.add(this.parseObject(data.children[child],geometries,materials));if("LOD"===data.type)for(var levels=data.levels,l=0;l<levels.length;l++){var level=levels[l],child=object.getObjectByProperty("uuid",level.object);void 0!==child&&object.addLevel(child,level.distance)}return object}}()},THREE.TextureLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.TextureLoader.prototype={constructor:THREE.TextureLoader,load:function(url,onLoad,onProgress,onError){var texture=new THREE.Texture,loader=new THREE.ImageLoader(this.manager);return loader.setCrossOrigin(this.crossOrigin),loader.setPath(this.path),loader.load(url,function(image){texture.image=image,texture.needsUpdate=!0,void 0!==onLoad&&onLoad(texture)},onProgress,onError),texture},setCrossOrigin:function(value){this.crossOrigin=value},setPath:function(value){this.path=value}},THREE.CubeTextureLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager},THREE.CubeTextureLoader.prototype={constructor:THREE.CubeTextureLoader,load:function(urls,onLoad,onProgress,onError){function loadTexture(i){loader.load(urls[i],function(image){texture.images[i]=image,loaded++,6===loaded&&(texture.needsUpdate=!0,onLoad&&onLoad(texture))},void 0,onError)}var texture=new THREE.CubeTexture,loader=new THREE.ImageLoader(this.manager);loader.setCrossOrigin(this.crossOrigin),loader.setPath(this.path);for(var loaded=0,i=0;i<urls.length;++i)loadTexture(i);return texture},setCrossOrigin:function(value){this.crossOrigin=value},setPath:function(value){this.path=value}},THREE.DataTextureLoader=THREE.BinaryTextureLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager,this._parser=null},THREE.BinaryTextureLoader.prototype={constructor:THREE.BinaryTextureLoader,load:function(url,onLoad,onProgress,onError){var scope=this,texture=new THREE.DataTexture,loader=new THREE.XHRLoader(this.manager);return loader.setResponseType("arraybuffer"),loader.load(url,function(buffer){var texData=scope._parser(buffer);texData&&(void 0!==texData.image?texture.image=texData.image:void 0!==texData.data&&(texture.image.width=texData.width,texture.image.height=texData.height,texture.image.data=texData.data),texture.wrapS=void 0!==texData.wrapS?texData.wrapS:THREE.ClampToEdgeWrapping,texture.wrapT=void 0!==texData.wrapT?texData.wrapT:THREE.ClampToEdgeWrapping,texture.magFilter=void 0!==texData.magFilter?texData.magFilter:THREE.LinearFilter,texture.minFilter=void 0!==texData.minFilter?texData.minFilter:THREE.LinearMipMapLinearFilter,texture.anisotropy=void 0!==texData.anisotropy?texData.anisotropy:1,
void 0!==texData.format&&(texture.format=texData.format),void 0!==texData.type&&(texture.type=texData.type),void 0!==texData.mipmaps&&(texture.mipmaps=texData.mipmaps),1===texData.mipmapCount&&(texture.minFilter=THREE.LinearFilter),texture.needsUpdate=!0,onLoad&&onLoad(texture,texData))},onProgress,onError),texture}},THREE.CompressedTextureLoader=function(manager){this.manager=void 0!==manager?manager:THREE.DefaultLoadingManager,this._parser=null},THREE.CompressedTextureLoader.prototype={constructor:THREE.CompressedTextureLoader,load:function(url,onLoad,onProgress,onError){function loadTexture(i){loader.load(url[i],function(buffer){var texDatas=scope._parser(buffer,!0);images[i]={width:texDatas.width,height:texDatas.height,format:texDatas.format,mipmaps:texDatas.mipmaps},loaded+=1,6===loaded&&(1===texDatas.mipmapCount&&(texture.minFilter=THREE.LinearFilter),texture.format=texDatas.format,texture.needsUpdate=!0,onLoad&&onLoad(texture))},onProgress,onError)}var scope=this,images=[],texture=new THREE.CompressedTexture;texture.image=images;var loader=new THREE.XHRLoader(this.manager);if(loader.setPath(this.path),loader.setResponseType("arraybuffer"),Array.isArray(url))for(var loaded=0,i=0,il=url.length;il>i;++i)loadTexture(i);else loader.load(url,function(buffer){var texDatas=scope._parser(buffer,!0);if(texDatas.isCubemap)for(var faces=texDatas.mipmaps.length/texDatas.mipmapCount,f=0;faces>f;f++){images[f]={mipmaps:[]};for(var i=0;i<texDatas.mipmapCount;i++)images[f].mipmaps.push(texDatas.mipmaps[f*texDatas.mipmapCount+i]),images[f].format=texDatas.format,images[f].width=texDatas.width,images[f].height=texDatas.height}else texture.image.width=texDatas.width,texture.image.height=texDatas.height,texture.mipmaps=texDatas.mipmaps;1===texDatas.mipmapCount&&(texture.minFilter=THREE.LinearFilter),texture.format=texDatas.format,texture.needsUpdate=!0,onLoad&&onLoad(texture)},onProgress,onError);return texture},setPath:function(value){this.path=value}},THREE.Material=function(){Object.defineProperty(this,"id",{value:THREE.MaterialIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.type="Material",this.side=THREE.FrontSide,this.opacity=1,this.transparent=!1,this.blending=THREE.NormalBlending,this.blendSrc=THREE.SrcAlphaFactor,this.blendDst=THREE.OneMinusSrcAlphaFactor,this.blendEquation=THREE.AddEquation,this.blendSrcAlpha=null,this.blendDstAlpha=null,this.blendEquationAlpha=null,this.depthFunc=THREE.LessEqualDepth,this.depthTest=!0,this.depthWrite=!0,this.clippingPlanes=null,this.clipShadows=!1,this.colorWrite=!0,this.precision=null,this.polygonOffset=!1,this.polygonOffsetFactor=0,this.polygonOffsetUnits=0,this.alphaTest=0,this.premultipliedAlpha=!1,this.overdraw=0,this.visible=!0,this._needsUpdate=!0},THREE.Material.prototype={constructor:THREE.Material,get needsUpdate(){return this._needsUpdate},set needsUpdate(value){value===!0&&this.update(),this._needsUpdate=value},setValues:function(values){if(void 0!==values)for(var key in values){var newValue=values[key];if(void 0!==newValue){var currentValue=this[key];void 0!==currentValue?currentValue instanceof THREE.Color?currentValue.set(newValue):currentValue instanceof THREE.Vector3&&newValue instanceof THREE.Vector3?currentValue.copy(newValue):"overdraw"===key?this[key]=Number(newValue):this[key]=newValue:console.warn("THREE."+this.type+": '"+key+"' is not a property of this material.")}else console.warn("THREE.Material: '"+key+"' parameter is undefined.")}},toJSON:function(meta){function extractFromCache(cache){var values=[];for(var key in cache){var data=cache[key];delete data.metadata,values.push(data)}return values}var isRoot=void 0===meta;isRoot&&(meta={textures:{},images:{}});var data={metadata:{version:4.4,type:"Material",generator:"Material.toJSON"}};if(data.uuid=this.uuid,data.type=this.type,""!==this.name&&(data.name=this.name),this.color instanceof THREE.Color&&(data.color=this.color.getHex()),.5!==this.roughness&&(data.roughness=this.roughness),.5!==this.metalness&&(data.metalness=this.metalness),this.emissive instanceof THREE.Color&&(data.emissive=this.emissive.getHex()),this.specular instanceof THREE.Color&&(data.specular=this.specular.getHex()),void 0!==this.shininess&&(data.shininess=this.shininess),this.map instanceof THREE.Texture&&(data.map=this.map.toJSON(meta).uuid),this.alphaMap instanceof THREE.Texture&&(data.alphaMap=this.alphaMap.toJSON(meta).uuid),this.lightMap instanceof THREE.Texture&&(data.lightMap=this.lightMap.toJSON(meta).uuid),this.bumpMap instanceof THREE.Texture&&(data.bumpMap=this.bumpMap.toJSON(meta).uuid,data.bumpScale=this.bumpScale),this.normalMap instanceof THREE.Texture&&(data.normalMap=this.normalMap.toJSON(meta).uuid,data.normalScale=this.normalScale.toArray()),this.displacementMap instanceof THREE.Texture&&(data.displacementMap=this.displacementMap.toJSON(meta).uuid,data.displacementScale=this.displacementScale,data.displacementBias=this.displacementBias),this.roughnessMap instanceof THREE.Texture&&(data.roughnessMap=this.roughnessMap.toJSON(meta).uuid),this.metalnessMap instanceof THREE.Texture&&(data.metalnessMap=this.metalnessMap.toJSON(meta).uuid),this.emissiveMap instanceof THREE.Texture&&(data.emissiveMap=this.emissiveMap.toJSON(meta).uuid),this.specularMap instanceof THREE.Texture&&(data.specularMap=this.specularMap.toJSON(meta).uuid),this.envMap instanceof THREE.Texture&&(data.envMap=this.envMap.toJSON(meta).uuid,data.reflectivity=this.reflectivity),void 0!==this.size&&(data.size=this.size),void 0!==this.sizeAttenuation&&(data.sizeAttenuation=this.sizeAttenuation),void 0!==this.vertexColors&&this.vertexColors!==THREE.NoColors&&(data.vertexColors=this.vertexColors),void 0!==this.shading&&this.shading!==THREE.SmoothShading&&(data.shading=this.shading),void 0!==this.blending&&this.blending!==THREE.NormalBlending&&(data.blending=this.blending),void 0!==this.side&&this.side!==THREE.FrontSide&&(data.side=this.side),this.opacity<1&&(data.opacity=this.opacity),this.transparent===!0&&(data.transparent=this.transparent),this.alphaTest>0&&(data.alphaTest=this.alphaTest),this.premultipliedAlpha===!0&&(data.premultipliedAlpha=this.premultipliedAlpha),this.wireframe===!0&&(data.wireframe=this.wireframe),this.wireframeLinewidth>1&&(data.wireframeLinewidth=this.wireframeLinewidth),isRoot){var textures=extractFromCache(meta.textures),images=extractFromCache(meta.images);textures.length>0&&(data.textures=textures),images.length>0&&(data.images=images)}return data},clone:function(){return(new this.constructor).copy(this)},copy:function(source){this.name=source.name,this.side=source.side,this.opacity=source.opacity,this.transparent=source.transparent,this.blending=source.blending,this.blendSrc=source.blendSrc,this.blendDst=source.blendDst,this.blendEquation=source.blendEquation,this.blendSrcAlpha=source.blendSrcAlpha,this.blendDstAlpha=source.blendDstAlpha,this.blendEquationAlpha=source.blendEquationAlpha,this.depthFunc=source.depthFunc,this.depthTest=source.depthTest,this.depthWrite=source.depthWrite,this.colorWrite=source.colorWrite,this.precision=source.precision,this.polygonOffset=source.polygonOffset,this.polygonOffsetFactor=source.polygonOffsetFactor,this.polygonOffsetUnits=source.polygonOffsetUnits,this.alphaTest=source.alphaTest,this.premultipliedAlpha=source.premultipliedAlpha,this.overdraw=source.overdraw,this.visible=source.visible,this.clipShadows=source.clipShadows;var srcPlanes=source.clippingPlanes,dstPlanes=null;if(null!==srcPlanes){var n=srcPlanes.length;dstPlanes=new Array(n);for(var i=0;i!==n;++i)dstPlanes[i]=srcPlanes[i].clone()}return this.clippingPlanes=dstPlanes,this},update:function(){this.dispatchEvent({type:"update"})},dispose:function(){this.dispatchEvent({type:"dispose"})}},THREE.EventDispatcher.prototype.apply(THREE.Material.prototype),THREE.MaterialIdCount=0,THREE.LineBasicMaterial=function(parameters){THREE.Material.call(this),this.type="LineBasicMaterial",this.color=new THREE.Color(16777215),this.linewidth=1,this.linecap="round",this.linejoin="round",this.blending=THREE.NormalBlending,this.vertexColors=THREE.NoColors,this.fog=!0,this.setValues(parameters)},THREE.LineBasicMaterial.prototype=Object.create(THREE.Material.prototype),THREE.LineBasicMaterial.prototype.constructor=THREE.LineBasicMaterial,THREE.LineBasicMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.linewidth=source.linewidth,this.linecap=source.linecap,this.linejoin=source.linejoin,this.vertexColors=source.vertexColors,this.fog=source.fog,this},THREE.LineDashedMaterial=function(parameters){THREE.Material.call(this),this.type="LineDashedMaterial",this.color=new THREE.Color(16777215),this.linewidth=1,this.scale=1,this.dashSize=3,this.gapSize=1,this.blending=THREE.NormalBlending,this.vertexColors=THREE.NoColors,this.fog=!0,this.setValues(parameters)},THREE.LineDashedMaterial.prototype=Object.create(THREE.Material.prototype),THREE.LineDashedMaterial.prototype.constructor=THREE.LineDashedMaterial,THREE.LineDashedMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.linewidth=source.linewidth,this.scale=source.scale,this.dashSize=source.dashSize,this.gapSize=source.gapSize,this.vertexColors=source.vertexColors,this.fog=source.fog,this},THREE.MeshBasicMaterial=function(parameters){THREE.Material.call(this),this.type="MeshBasicMaterial",this.color=new THREE.Color(16777215),this.map=null,this.aoMap=null,this.aoMapIntensity=1,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=THREE.MultiplyOperation,this.reflectivity=1,this.refractionRatio=.98,this.fog=!0,this.shading=THREE.SmoothShading,this.blending=THREE.NormalBlending,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.vertexColors=THREE.NoColors,this.skinning=!1,this.morphTargets=!1,this.setValues(parameters)},THREE.MeshBasicMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshBasicMaterial.prototype.constructor=THREE.MeshBasicMaterial,THREE.MeshBasicMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.specularMap=source.specularMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.combine=source.combine,this.reflectivity=source.reflectivity,this.refractionRatio=source.refractionRatio,this.fog=source.fog,this.shading=source.shading,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.vertexColors=source.vertexColors,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this},THREE.MeshDepthMaterial=function(parameters){THREE.Material.call(this),this.type="MeshDepthMaterial",this.depthPacking=THREE.BasicDepthPacking,this.skinning=!1,this.morphTargets=!1,this.map=null,this.alphaMap=null,this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.wireframe=!1,this.wireframeLinewidth=1,this.setValues(parameters)},THREE.MeshDepthMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshDepthMaterial.prototype.constructor=THREE.MeshDepthMaterial,THREE.MeshDepthMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.depthPacking=source.depthPacking,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.map=source.map,this.alphaMap=source.alphaMap,this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this},THREE.MeshLambertMaterial=function(parameters){THREE.Material.call(this),this.type="MeshLambertMaterial",this.color=new THREE.Color(16777215),this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new THREE.Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=THREE.MultiplyOperation,this.reflectivity=1,this.refractionRatio=.98,this.fog=!0,this.blending=THREE.NormalBlending,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.vertexColors=THREE.NoColors,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)},THREE.MeshLambertMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshLambertMaterial.prototype.constructor=THREE.MeshLambertMaterial,THREE.MeshLambertMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.specularMap=source.specularMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.combine=source.combine,this.reflectivity=source.reflectivity,this.refractionRatio=source.refractionRatio,this.fog=source.fog,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.vertexColors=source.vertexColors,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},THREE.MeshNormalMaterial=function(parameters){THREE.Material.call(this,parameters),this.type="MeshNormalMaterial",this.wireframe=!1,this.wireframeLinewidth=1,this.morphTargets=!1,this.setValues(parameters)},THREE.MeshNormalMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshNormalMaterial.prototype.constructor=THREE.MeshNormalMaterial,THREE.MeshNormalMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this},THREE.MeshPhongMaterial=function(parameters){THREE.Material.call(this),this.type="MeshPhongMaterial",this.color=new THREE.Color(16777215),this.specular=new THREE.Color(1118481),this.shininess=30,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new THREE.Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new THREE.Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.specularMap=null,this.alphaMap=null,this.envMap=null,this.combine=THREE.MultiplyOperation,this.reflectivity=1,this.refractionRatio=.98,this.fog=!0,this.shading=THREE.SmoothShading,this.blending=THREE.NormalBlending,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.vertexColors=THREE.NoColors,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)},THREE.MeshPhongMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshPhongMaterial.prototype.constructor=THREE.MeshPhongMaterial,THREE.MeshPhongMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.specular.copy(source.specular),this.shininess=source.shininess,this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.specularMap=source.specularMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.combine=source.combine,this.reflectivity=source.reflectivity,this.refractionRatio=source.refractionRatio,this.fog=source.fog,this.shading=source.shading,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.vertexColors=source.vertexColors,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},THREE.MeshStandardMaterial=function(parameters){THREE.Material.call(this),this.defines={STANDARD:""},this.type="MeshStandardMaterial",this.color=new THREE.Color(16777215),this.roughness=.5,this.metalness=.5,this.map=null,this.lightMap=null,this.lightMapIntensity=1,this.aoMap=null,this.aoMapIntensity=1,this.emissive=new THREE.Color(0),this.emissiveIntensity=1,this.emissiveMap=null,this.bumpMap=null,this.bumpScale=1,this.normalMap=null,this.normalScale=new THREE.Vector2(1,1),this.displacementMap=null,this.displacementScale=1,this.displacementBias=0,this.roughnessMap=null,this.metalnessMap=null,this.alphaMap=null,this.envMap=null,this.envMapIntensity=1,this.refractionRatio=.98,this.fog=!0,this.shading=THREE.SmoothShading,this.blending=THREE.NormalBlending,this.wireframe=!1,this.wireframeLinewidth=1,this.wireframeLinecap="round",this.wireframeLinejoin="round",this.vertexColors=THREE.NoColors,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.setValues(parameters)},THREE.MeshStandardMaterial.prototype=Object.create(THREE.Material.prototype),THREE.MeshStandardMaterial.prototype.constructor=THREE.MeshStandardMaterial,THREE.MeshStandardMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.defines={STANDARD:""},this.color.copy(source.color),this.roughness=source.roughness,this.metalness=source.metalness,this.map=source.map,this.lightMap=source.lightMap,this.lightMapIntensity=source.lightMapIntensity,this.aoMap=source.aoMap,this.aoMapIntensity=source.aoMapIntensity,this.emissive.copy(source.emissive),this.emissiveMap=source.emissiveMap,this.emissiveIntensity=source.emissiveIntensity,this.bumpMap=source.bumpMap,this.bumpScale=source.bumpScale,this.normalMap=source.normalMap,this.normalScale.copy(source.normalScale),this.displacementMap=source.displacementMap,this.displacementScale=source.displacementScale,this.displacementBias=source.displacementBias,this.roughnessMap=source.roughnessMap,this.metalnessMap=source.metalnessMap,this.alphaMap=source.alphaMap,this.envMap=source.envMap,this.envMapIntensity=source.envMapIntensity,this.refractionRatio=source.refractionRatio,this.fog=source.fog,this.shading=source.shading,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.wireframeLinecap=source.wireframeLinecap,this.wireframeLinejoin=source.wireframeLinejoin,this.vertexColors=source.vertexColors,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this},THREE.MeshPhysicalMaterial=function(parameters){THREE.MeshStandardMaterial.call(this),this.defines={PHYSICAL:""},this.type="MeshPhysicalMaterial",this.reflectivity=.5,this.setValues(parameters)},THREE.MeshPhysicalMaterial.prototype=Object.create(THREE.MeshStandardMaterial.prototype),THREE.MeshPhysicalMaterial.prototype.constructor=THREE.MeshPhysicalMaterial,THREE.MeshPhysicalMaterial.prototype.copy=function(source){return THREE.MeshStandardMaterial.prototype.copy.call(this,source),this.defines={PHYSICAL:""},this.reflectivity=source.reflectivity,this},THREE.MultiMaterial=function(materials){this.uuid=THREE.Math.generateUUID(),this.type="MultiMaterial",this.materials=materials instanceof Array?materials:[],this.visible=!0},THREE.MultiMaterial.prototype={constructor:THREE.MultiMaterial,toJSON:function(meta){for(var output={metadata:{version:4.2,type:"material",generator:"MaterialExporter"},uuid:this.uuid,type:this.type,materials:[]},materials=this.materials,i=0,l=materials.length;l>i;i++){var material=materials[i].toJSON(meta);delete material.metadata,output.materials.push(material)}return output.visible=this.visible,output},clone:function(){for(var material=new this.constructor,i=0;i<this.materials.length;i++)material.materials.push(this.materials[i].clone());return material.visible=this.visible,material}},THREE.PointsMaterial=function(parameters){THREE.Material.call(this),this.type="PointsMaterial",this.color=new THREE.Color(16777215),this.map=null,this.size=1,this.sizeAttenuation=!0,this.blending=THREE.NormalBlending,this.vertexColors=THREE.NoColors,this.fog=!0,this.setValues(parameters)},THREE.PointsMaterial.prototype=Object.create(THREE.Material.prototype),THREE.PointsMaterial.prototype.constructor=THREE.PointsMaterial,THREE.PointsMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.size=source.size,this.sizeAttenuation=source.sizeAttenuation,this.vertexColors=source.vertexColors,this.fog=source.fog,this},THREE.ShaderMaterial=function(parameters){THREE.Material.call(this),this.type="ShaderMaterial",this.defines={},this.uniforms={},this.vertexShader="void main() {\n	gl_Position = projectionMatrix * modelViewMatrix * vec4( position, 1.0 );\n}",this.fragmentShader="void main() {\n	gl_FragColor = vec4( 1.0, 0.0, 0.0, 1.0 );\n}",this.shading=THREE.SmoothShading,this.linewidth=1,this.wireframe=!1,this.wireframeLinewidth=1,this.fog=!1,this.lights=!1,this.clipping=!1,this.vertexColors=THREE.NoColors,this.skinning=!1,this.morphTargets=!1,this.morphNormals=!1,this.extensions={derivatives:!1,fragDepth:!1,drawBuffers:!1,shaderTextureLOD:!1},this.defaultAttributeValues={color:[1,1,1],uv:[0,0],uv2:[0,0]},this.index0AttributeName=void 0,void 0!==parameters&&(void 0!==parameters.attributes&&console.error("THREE.ShaderMaterial: attributes should now be defined in THREE.BufferGeometry instead."),this.setValues(parameters))},THREE.ShaderMaterial.prototype=Object.create(THREE.Material.prototype),THREE.ShaderMaterial.prototype.constructor=THREE.ShaderMaterial,THREE.ShaderMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.fragmentShader=source.fragmentShader,this.vertexShader=source.vertexShader,this.uniforms=THREE.UniformsUtils.clone(source.uniforms),this.defines=source.defines,this.shading=source.shading,this.wireframe=source.wireframe,this.wireframeLinewidth=source.wireframeLinewidth,this.fog=source.fog,this.lights=source.lights,this.clipping=source.clipping,this.vertexColors=source.vertexColors,this.skinning=source.skinning,this.morphTargets=source.morphTargets,this.morphNormals=source.morphNormals,this.extensions=source.extensions,this},THREE.ShaderMaterial.prototype.toJSON=function(meta){var data=THREE.Material.prototype.toJSON.call(this,meta);return data.uniforms=this.uniforms,data.vertexShader=this.vertexShader,data.fragmentShader=this.fragmentShader,data},THREE.RawShaderMaterial=function(parameters){THREE.ShaderMaterial.call(this,parameters),this.type="RawShaderMaterial"},THREE.RawShaderMaterial.prototype=Object.create(THREE.ShaderMaterial.prototype),THREE.RawShaderMaterial.prototype.constructor=THREE.RawShaderMaterial,THREE.SpriteMaterial=function(parameters){THREE.Material.call(this),this.type="SpriteMaterial",this.color=new THREE.Color(16777215),this.map=null,this.rotation=0,this.fog=!1,this.setValues(parameters)},THREE.SpriteMaterial.prototype=Object.create(THREE.Material.prototype),THREE.SpriteMaterial.prototype.constructor=THREE.SpriteMaterial,THREE.SpriteMaterial.prototype.copy=function(source){return THREE.Material.prototype.copy.call(this,source),this.color.copy(source.color),this.map=source.map,this.rotation=source.rotation,this.fog=source.fog,this},THREE.Texture=function(image,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding){Object.defineProperty(this,"id",{value:THREE.TextureIdCount++}),this.uuid=THREE.Math.generateUUID(),this.name="",this.sourceFile="",this.image=void 0!==image?image:THREE.Texture.DEFAULT_IMAGE,this.mipmaps=[],this.mapping=void 0!==mapping?mapping:THREE.Texture.DEFAULT_MAPPING,this.wrapS=void 0!==wrapS?wrapS:THREE.ClampToEdgeWrapping,this.wrapT=void 0!==wrapT?wrapT:THREE.ClampToEdgeWrapping,this.magFilter=void 0!==magFilter?magFilter:THREE.LinearFilter,this.minFilter=void 0!==minFilter?minFilter:THREE.LinearMipMapLinearFilter,this.anisotropy=void 0!==anisotropy?anisotropy:1,this.format=void 0!==format?format:THREE.RGBAFormat,this.type=void 0!==type?type:THREE.UnsignedByteType,this.offset=new THREE.Vector2(0,0),this.repeat=new THREE.Vector2(1,1),this.generateMipmaps=!0,this.premultiplyAlpha=!1,this.flipY=!0,this.unpackAlignment=4,this.encoding=void 0!==encoding?encoding:THREE.LinearEncoding,this.version=0,this.onUpdate=null},THREE.Texture.DEFAULT_IMAGE=void 0,THREE.Texture.DEFAULT_MAPPING=THREE.UVMapping,THREE.Texture.prototype={constructor:THREE.Texture,set needsUpdate(value){value===!0&&this.version++},clone:function(){return(new this.constructor).copy(this)},copy:function(source){return this.image=source.image,this.mipmaps=source.mipmaps.slice(0),this.mapping=source.mapping,this.wrapS=source.wrapS,this.wrapT=source.wrapT,this.magFilter=source.magFilter,this.minFilter=source.minFilter,this.anisotropy=source.anisotropy,this.format=source.format,this.type=source.type,this.offset.copy(source.offset),this.repeat.copy(source.repeat),this.generateMipmaps=source.generateMipmaps,this.premultiplyAlpha=source.premultiplyAlpha,this.flipY=source.flipY,this.unpackAlignment=source.unpackAlignment,this.encoding=source.encoding,this},toJSON:function(meta){function getDataURL(image){var canvas;return void 0!==image.toDataURL?canvas=image:(canvas=document.createElement("canvas"),canvas.width=image.width,canvas.height=image.height,canvas.getContext("2d").drawImage(image,0,0,image.width,image.height)),canvas.width>2048||canvas.height>2048?canvas.toDataURL("image/jpeg",.6):canvas.toDataURL("image/png")}if(void 0!==meta.textures[this.uuid])return meta.textures[this.uuid];var output={metadata:{version:4.4,type:"Texture",generator:"Texture.toJSON"},uuid:this.uuid,name:this.name,mapping:this.mapping,repeat:[this.repeat.x,this.repeat.y],offset:[this.offset.x,this.offset.y],wrap:[this.wrapS,this.wrapT],minFilter:this.minFilter,magFilter:this.magFilter,anisotropy:this.anisotropy};if(void 0!==this.image){var image=this.image;void 0===image.uuid&&(image.uuid=THREE.Math.generateUUID()),void 0===meta.images[image.uuid]&&(meta.images[image.uuid]={uuid:image.uuid,url:getDataURL(image)}),output.image=image.uuid}return meta.textures[this.uuid]=output,output},dispose:function(){this.dispatchEvent({type:"dispose"})},transformUv:function(uv){if(this.mapping===THREE.UVMapping){if(uv.multiply(this.repeat),uv.add(this.offset),uv.x<0||uv.x>1)switch(this.wrapS){case THREE.RepeatWrapping:uv.x=uv.x-Math.floor(uv.x);break;case THREE.ClampToEdgeWrapping:uv.x=uv.x<0?0:1;break;case THREE.MirroredRepeatWrapping:1===Math.abs(Math.floor(uv.x)%2)?uv.x=Math.ceil(uv.x)-uv.x:uv.x=uv.x-Math.floor(uv.x)}if(uv.y<0||uv.y>1)switch(this.wrapT){case THREE.RepeatWrapping:uv.y=uv.y-Math.floor(uv.y);break;case THREE.ClampToEdgeWrapping:uv.y=uv.y<0?0:1;break;case THREE.MirroredRepeatWrapping:1===Math.abs(Math.floor(uv.y)%2)?uv.y=Math.ceil(uv.y)-uv.y:uv.y=uv.y-Math.floor(uv.y)}this.flipY&&(uv.y=1-uv.y)}}},THREE.EventDispatcher.prototype.apply(THREE.Texture.prototype),THREE.TextureIdCount=0,THREE.DepthTexture=function(width,height,type,mapping,wrapS,wrapT,magFilter,minFilter,anisotropy){THREE.Texture.call(this,null,mapping,wrapS,wrapT,magFilter,minFilter,THREE.DepthFormat,type,anisotropy),this.image={width:width,height:height},this.type=void 0!==type?type:THREE.UnsignedShortType,this.magFilter=void 0!==magFilter?magFilter:THREE.NearestFilter,this.minFilter=void 0!==minFilter?minFilter:THREE.NearestFilter,this.flipY=!1,this.generateMipmaps=!1},THREE.DepthTexture.prototype=Object.create(THREE.Texture.prototype),THREE.DepthTexture.prototype.constructor=THREE.DepthTexture,THREE.CanvasTexture=function(canvas,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy){THREE.Texture.call(this,canvas,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy),this.needsUpdate=!0},THREE.CanvasTexture.prototype=Object.create(THREE.Texture.prototype),THREE.CanvasTexture.prototype.constructor=THREE.CanvasTexture,THREE.CubeTexture=function(images,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding){images=void 0!==images?images:[],mapping=void 0!==mapping?mapping:THREE.CubeReflectionMapping,THREE.Texture.call(this,images,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding),this.flipY=!1},THREE.CubeTexture.prototype=Object.create(THREE.Texture.prototype),THREE.CubeTexture.prototype.constructor=THREE.CubeTexture,Object.defineProperty(THREE.CubeTexture.prototype,"images",{get:function(){return this.image},set:function(value){this.image=value}}),THREE.CompressedTexture=function(mipmaps,width,height,format,type,mapping,wrapS,wrapT,magFilter,minFilter,anisotropy,encoding){THREE.Texture.call(this,null,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding),this.image={width:width,height:height},this.mipmaps=mipmaps,this.flipY=!1,this.generateMipmaps=!1},THREE.CompressedTexture.prototype=Object.create(THREE.Texture.prototype),THREE.CompressedTexture.prototype.constructor=THREE.CompressedTexture,THREE.DataTexture=function(data,width,height,format,type,mapping,wrapS,wrapT,magFilter,minFilter,anisotropy,encoding){THREE.Texture.call(this,null,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy,encoding),this.image={data:data,width:width,height:height},this.magFilter=void 0!==magFilter?magFilter:THREE.NearestFilter,this.minFilter=void 0!==minFilter?minFilter:THREE.NearestFilter,this.flipY=!1,this.generateMipmaps=!1},THREE.DataTexture.prototype=Object.create(THREE.Texture.prototype),THREE.DataTexture.prototype.constructor=THREE.DataTexture,THREE.VideoTexture=function(video,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy){function update(){requestAnimationFrame(update),video.readyState>=video.HAVE_CURRENT_DATA&&(scope.needsUpdate=!0)}THREE.Texture.call(this,video,mapping,wrapS,wrapT,magFilter,minFilter,format,type,anisotropy),this.generateMipmaps=!1;var scope=this;update()},THREE.VideoTexture.prototype=Object.create(THREE.Texture.prototype),THREE.VideoTexture.prototype.constructor=THREE.VideoTexture,THREE.Group=function(){THREE.Object3D.call(this),this.type="Group"},THREE.Group.prototype=Object.create(THREE.Object3D.prototype),THREE.Group.prototype.constructor=THREE.Group,THREE.Points=function(geometry,material){THREE.Object3D.call(this),this.type="Points",this.geometry=void 0!==geometry?geometry:new THREE.Geometry,this.material=void 0!==material?material:new THREE.PointsMaterial({color:16777215*Math.random()})},THREE.Points.prototype=Object.create(THREE.Object3D.prototype),THREE.Points.prototype.constructor=THREE.Points,THREE.Points.prototype.raycast=function(){var inverseMatrix=new THREE.Matrix4,ray=new THREE.Ray,sphere=new THREE.Sphere;return function(raycaster,intersects){function testPoint(point,index){var rayPointDistanceSq=ray.distanceSqToPoint(point);if(localThresholdSq>rayPointDistanceSq){var intersectPoint=ray.closestPointToPoint(point);intersectPoint.applyMatrix4(matrixWorld);var distance=raycaster.ray.origin.distanceTo(intersectPoint);if(distance<raycaster.near||distance>raycaster.far)return;intersects.push({distance:distance,distanceToRay:Math.sqrt(rayPointDistanceSq),point:intersectPoint.clone(),index:index,face:null,object:object})}}var object=this,geometry=this.geometry,matrixWorld=this.matrixWorld,threshold=raycaster.params.Points.threshold;
if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),sphere.copy(geometry.boundingSphere),sphere.applyMatrix4(matrixWorld),raycaster.ray.intersectsSphere(sphere)!==!1){inverseMatrix.getInverse(matrixWorld),ray.copy(raycaster.ray).applyMatrix4(inverseMatrix);var localThreshold=threshold/((this.scale.x+this.scale.y+this.scale.z)/3),localThresholdSq=localThreshold*localThreshold,position=new THREE.Vector3;if(geometry instanceof THREE.BufferGeometry){var index=geometry.index,attributes=geometry.attributes,positions=attributes.position.array;if(null!==index)for(var indices=index.array,i=0,il=indices.length;il>i;i++){var a=indices[i];position.fromArray(positions,3*a),testPoint(position,a)}else for(var i=0,l=positions.length/3;l>i;i++)position.fromArray(positions,3*i),testPoint(position,i)}else for(var vertices=geometry.vertices,i=0,l=vertices.length;l>i;i++)testPoint(vertices[i],i)}}}(),THREE.Points.prototype.clone=function(){return new this.constructor(this.geometry,this.material).copy(this)},THREE.Line=function(geometry,material,mode){return 1===mode?(console.warn("THREE.Line: parameter THREE.LinePieces no longer supported. Created THREE.LineSegments instead."),new THREE.LineSegments(geometry,material)):(THREE.Object3D.call(this),this.type="Line",this.geometry=void 0!==geometry?geometry:new THREE.Geometry,void(this.material=void 0!==material?material:new THREE.LineBasicMaterial({color:16777215*Math.random()})))},THREE.Line.prototype=Object.create(THREE.Object3D.prototype),THREE.Line.prototype.constructor=THREE.Line,THREE.Line.prototype.raycast=function(){var inverseMatrix=new THREE.Matrix4,ray=new THREE.Ray,sphere=new THREE.Sphere;return function(raycaster,intersects){var precision=raycaster.linePrecision,precisionSq=precision*precision,geometry=this.geometry,matrixWorld=this.matrixWorld;if(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),sphere.copy(geometry.boundingSphere),sphere.applyMatrix4(matrixWorld),raycaster.ray.intersectsSphere(sphere)!==!1){inverseMatrix.getInverse(matrixWorld),ray.copy(raycaster.ray).applyMatrix4(inverseMatrix);var vStart=new THREE.Vector3,vEnd=new THREE.Vector3,interSegment=new THREE.Vector3,interRay=new THREE.Vector3,step=this instanceof THREE.LineSegments?2:1;if(geometry instanceof THREE.BufferGeometry){var index=geometry.index,attributes=geometry.attributes,positions=attributes.position.array;if(null!==index)for(var indices=index.array,i=0,l=indices.length-1;l>i;i+=step){var a=indices[i],b=indices[i+1];vStart.fromArray(positions,3*a),vEnd.fromArray(positions,3*b);var distSq=ray.distanceSqToSegment(vStart,vEnd,interRay,interSegment);if(!(distSq>precisionSq)){interRay.applyMatrix4(this.matrixWorld);var distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance:distance,point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}else for(var i=0,l=positions.length/3-1;l>i;i+=step){vStart.fromArray(positions,3*i),vEnd.fromArray(positions,3*i+3);var distSq=ray.distanceSqToSegment(vStart,vEnd,interRay,interSegment);if(!(distSq>precisionSq)){interRay.applyMatrix4(this.matrixWorld);var distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance:distance,point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}}else if(geometry instanceof THREE.Geometry)for(var vertices=geometry.vertices,nbVertices=vertices.length,i=0;nbVertices-1>i;i+=step){var distSq=ray.distanceSqToSegment(vertices[i],vertices[i+1],interRay,interSegment);if(!(distSq>precisionSq)){interRay.applyMatrix4(this.matrixWorld);var distance=raycaster.ray.origin.distanceTo(interRay);distance<raycaster.near||distance>raycaster.far||intersects.push({distance:distance,point:interSegment.clone().applyMatrix4(this.matrixWorld),index:i,face:null,faceIndex:null,object:this})}}}}}(),THREE.Line.prototype.clone=function(){return new this.constructor(this.geometry,this.material).copy(this)},THREE.LineStrip=0,THREE.LinePieces=1,THREE.LineSegments=function(geometry,material){THREE.Line.call(this,geometry,material),this.type="LineSegments"},THREE.LineSegments.prototype=Object.create(THREE.Line.prototype),THREE.LineSegments.prototype.constructor=THREE.LineSegments,THREE.Mesh=function(geometry,material){THREE.Object3D.call(this),this.type="Mesh",this.geometry=void 0!==geometry?geometry:new THREE.Geometry,this.material=void 0!==material?material:new THREE.MeshBasicMaterial({color:16777215*Math.random()}),this.drawMode=THREE.TrianglesDrawMode,this.updateMorphTargets()},THREE.Mesh.prototype=Object.create(THREE.Object3D.prototype),THREE.Mesh.prototype.constructor=THREE.Mesh,THREE.Mesh.prototype.setDrawMode=function(value){this.drawMode=value},THREE.Mesh.prototype.updateMorphTargets=function(){if(void 0!==this.geometry.morphTargets&&this.geometry.morphTargets.length>0){this.morphTargetBase=-1,this.morphTargetInfluences=[],this.morphTargetDictionary={};for(var m=0,ml=this.geometry.morphTargets.length;ml>m;m++)this.morphTargetInfluences.push(0),this.morphTargetDictionary[this.geometry.morphTargets[m].name]=m}},THREE.Mesh.prototype.getMorphTargetIndexByName=function(name){return void 0!==this.morphTargetDictionary[name]?this.morphTargetDictionary[name]:(console.warn("THREE.Mesh.getMorphTargetIndexByName: morph target "+name+" does not exist. Returning 0."),0)},THREE.Mesh.prototype.raycast=function(){function uvIntersection(point,p1,p2,p3,uv1,uv2,uv3){return THREE.Triangle.barycoordFromPoint(point,p1,p2,p3,barycoord),uv1.multiplyScalar(barycoord.x),uv2.multiplyScalar(barycoord.y),uv3.multiplyScalar(barycoord.z),uv1.add(uv2).add(uv3),uv1.clone()}function checkIntersection(object,raycaster,ray,pA,pB,pC,point){var intersect,material=object.material;if(intersect=material.side===THREE.BackSide?ray.intersectTriangle(pC,pB,pA,!0,point):ray.intersectTriangle(pA,pB,pC,material.side!==THREE.DoubleSide,point),null===intersect)return null;intersectionPointWorld.copy(point),intersectionPointWorld.applyMatrix4(object.matrixWorld);var distance=raycaster.ray.origin.distanceTo(intersectionPointWorld);return distance<raycaster.near||distance>raycaster.far?null:{distance:distance,point:intersectionPointWorld.clone(),object:object}}function checkBufferGeometryIntersection(object,raycaster,ray,positions,uvs,a,b,c){vA.fromArray(positions,3*a),vB.fromArray(positions,3*b),vC.fromArray(positions,3*c);var intersection=checkIntersection(object,raycaster,ray,vA,vB,vC,intersectionPoint);return intersection&&(uvs&&(uvA.fromArray(uvs,2*a),uvB.fromArray(uvs,2*b),uvC.fromArray(uvs,2*c),intersection.uv=uvIntersection(intersectionPoint,vA,vB,vC,uvA,uvB,uvC)),intersection.face=new THREE.Face3(a,b,c,THREE.Triangle.normal(vA,vB,vC)),intersection.faceIndex=a),intersection}var inverseMatrix=new THREE.Matrix4,ray=new THREE.Ray,sphere=new THREE.Sphere,vA=new THREE.Vector3,vB=new THREE.Vector3,vC=new THREE.Vector3,tempA=new THREE.Vector3,tempB=new THREE.Vector3,tempC=new THREE.Vector3,uvA=new THREE.Vector2,uvB=new THREE.Vector2,uvC=new THREE.Vector2,barycoord=new THREE.Vector3,intersectionPoint=new THREE.Vector3,intersectionPointWorld=new THREE.Vector3;return function(raycaster,intersects){var geometry=this.geometry,material=this.material,matrixWorld=this.matrixWorld;if(void 0!==material&&(null===geometry.boundingSphere&&geometry.computeBoundingSphere(),sphere.copy(geometry.boundingSphere),sphere.applyMatrix4(matrixWorld),raycaster.ray.intersectsSphere(sphere)!==!1&&(inverseMatrix.getInverse(matrixWorld),ray.copy(raycaster.ray).applyMatrix4(inverseMatrix),null===geometry.boundingBox||ray.intersectsBox(geometry.boundingBox)!==!1))){var uvs,intersection;if(geometry instanceof THREE.BufferGeometry){var a,b,c,index=geometry.index,attributes=geometry.attributes,positions=attributes.position.array;if(void 0!==attributes.uv&&(uvs=attributes.uv.array),null!==index)for(var indices=index.array,i=0,l=indices.length;l>i;i+=3)a=indices[i],b=indices[i+1],c=indices[i+2],intersection=checkBufferGeometryIntersection(this,raycaster,ray,positions,uvs,a,b,c),intersection&&(intersection.faceIndex=Math.floor(i/3),intersects.push(intersection));else for(var i=0,l=positions.length;l>i;i+=9)a=i/3,b=a+1,c=a+2,intersection=checkBufferGeometryIntersection(this,raycaster,ray,positions,uvs,a,b,c),intersection&&(intersection.index=a,intersects.push(intersection))}else if(geometry instanceof THREE.Geometry){var fvA,fvB,fvC,isFaceMaterial=material instanceof THREE.MultiMaterial,materials=isFaceMaterial===!0?material.materials:null,vertices=geometry.vertices,faces=geometry.faces,faceVertexUvs=geometry.faceVertexUvs[0];faceVertexUvs.length>0&&(uvs=faceVertexUvs);for(var f=0,fl=faces.length;fl>f;f++){var face=faces[f],faceMaterial=isFaceMaterial===!0?materials[face.materialIndex]:material;if(void 0!==faceMaterial){if(fvA=vertices[face.a],fvB=vertices[face.b],fvC=vertices[face.c],faceMaterial.morphTargets===!0){var morphTargets=geometry.morphTargets,morphInfluences=this.morphTargetInfluences;vA.set(0,0,0),vB.set(0,0,0),vC.set(0,0,0);for(var t=0,tl=morphTargets.length;tl>t;t++){var influence=morphInfluences[t];if(0!==influence){var targets=morphTargets[t].vertices;vA.addScaledVector(tempA.subVectors(targets[face.a],fvA),influence),vB.addScaledVector(tempB.subVectors(targets[face.b],fvB),influence),vC.addScaledVector(tempC.subVectors(targets[face.c],fvC),influence)}}vA.add(fvA),vB.add(fvB),vC.add(fvC),fvA=vA,fvB=vB,fvC=vC}if(intersection=checkIntersection(this,raycaster,ray,fvA,fvB,fvC,intersectionPoint)){if(uvs){var uvs_f=uvs[f];uvA.copy(uvs_f[0]),uvB.copy(uvs_f[1]),uvC.copy(uvs_f[2]),intersection.uv=uvIntersection(intersectionPoint,fvA,fvB,fvC,uvA,uvB,uvC)}intersection.face=face,intersection.faceIndex=f,intersects.push(intersection)}}}}}}}(),THREE.Mesh.prototype.clone=function(){return new this.constructor(this.geometry,this.material).copy(this)},THREE.Bone=function(skin){THREE.Object3D.call(this),this.type="Bone",this.skin=skin},THREE.Bone.prototype=Object.create(THREE.Object3D.prototype),THREE.Bone.prototype.constructor=THREE.Bone,THREE.Bone.prototype.copy=function(source){return THREE.Object3D.prototype.copy.call(this,source),this.skin=source.skin,this},THREE.Skeleton=function(bones,boneInverses,useVertexTexture){if(this.useVertexTexture=void 0!==useVertexTexture?useVertexTexture:!0,this.identityMatrix=new THREE.Matrix4,bones=bones||[],this.bones=bones.slice(0),this.useVertexTexture){var size=Math.sqrt(4*this.bones.length);size=THREE.Math.nextPowerOfTwo(Math.ceil(size)),size=Math.max(size,4),this.boneTextureWidth=size,this.boneTextureHeight=size,this.boneMatrices=new Float32Array(this.boneTextureWidth*this.boneTextureHeight*4),this.boneTexture=new THREE.DataTexture(this.boneMatrices,this.boneTextureWidth,this.boneTextureHeight,THREE.RGBAFormat,THREE.FloatType)}else this.boneMatrices=new Float32Array(16*this.bones.length);if(void 0===boneInverses)this.calculateInverses();else if(this.bones.length===boneInverses.length)this.boneInverses=boneInverses.slice(0);else{console.warn("THREE.Skeleton bonInverses is the wrong length."),this.boneInverses=[];for(var b=0,bl=this.bones.length;bl>b;b++)this.boneInverses.push(new THREE.Matrix4)}},THREE.Skeleton.prototype.calculateInverses=function(){this.boneInverses=[];for(var b=0,bl=this.bones.length;bl>b;b++){var inverse=new THREE.Matrix4;this.bones[b]&&inverse.getInverse(this.bones[b].matrixWorld),this.boneInverses.push(inverse)}},THREE.Skeleton.prototype.pose=function(){for(var bone,b=0,bl=this.bones.length;bl>b;b++)bone=this.bones[b],bone&&bone.matrixWorld.getInverse(this.boneInverses[b]);for(var b=0,bl=this.bones.length;bl>b;b++)bone=this.bones[b],bone&&(bone.parent?(bone.matrix.getInverse(bone.parent.matrixWorld),bone.matrix.multiply(bone.matrixWorld)):bone.matrix.copy(bone.matrixWorld),bone.matrix.decompose(bone.position,bone.quaternion,bone.scale))},THREE.Skeleton.prototype.update=function(){var offsetMatrix=new THREE.Matrix4;return function(){for(var b=0,bl=this.bones.length;bl>b;b++){var matrix=this.bones[b]?this.bones[b].matrixWorld:this.identityMatrix;offsetMatrix.multiplyMatrices(matrix,this.boneInverses[b]),offsetMatrix.toArray(this.boneMatrices,16*b)}this.useVertexTexture&&(this.boneTexture.needsUpdate=!0)}}(),THREE.Skeleton.prototype.clone=function(){return new THREE.Skeleton(this.bones,this.boneInverses,this.useVertexTexture)},THREE.SkinnedMesh=function(geometry,material,useVertexTexture){THREE.Mesh.call(this,geometry,material),this.type="SkinnedMesh",this.bindMode="attached",this.bindMatrix=new THREE.Matrix4,this.bindMatrixInverse=new THREE.Matrix4;var bones=[];if(this.geometry&&void 0!==this.geometry.bones){for(var bone,gbone,b=0,bl=this.geometry.bones.length;bl>b;++b)gbone=this.geometry.bones[b],bone=new THREE.Bone(this),bones.push(bone),bone.name=gbone.name,bone.position.fromArray(gbone.pos),bone.quaternion.fromArray(gbone.rotq),void 0!==gbone.scl&&bone.scale.fromArray(gbone.scl);for(var b=0,bl=this.geometry.bones.length;bl>b;++b)gbone=this.geometry.bones[b],-1!==gbone.parent&&null!==gbone.parent&&void 0!==bones[gbone.parent]?bones[gbone.parent].add(bones[b]):this.add(bones[b])}this.normalizeSkinWeights(),this.updateMatrixWorld(!0),this.bind(new THREE.Skeleton(bones,void 0,useVertexTexture),this.matrixWorld)},THREE.SkinnedMesh.prototype=Object.create(THREE.Mesh.prototype),THREE.SkinnedMesh.prototype.constructor=THREE.SkinnedMesh,THREE.SkinnedMesh.prototype.bind=function(skeleton,bindMatrix){this.skeleton=skeleton,void 0===bindMatrix&&(this.updateMatrixWorld(!0),this.skeleton.calculateInverses(),bindMatrix=this.matrixWorld),this.bindMatrix.copy(bindMatrix),this.bindMatrixInverse.getInverse(bindMatrix)},THREE.SkinnedMesh.prototype.pose=function(){this.skeleton.pose()},THREE.SkinnedMesh.prototype.normalizeSkinWeights=function(){if(this.geometry instanceof THREE.Geometry)for(var i=0;i<this.geometry.skinWeights.length;i++){var sw=this.geometry.skinWeights[i],scale=1/sw.lengthManhattan();scale!==1/0?sw.multiplyScalar(scale):sw.set(1,0,0,0)}else if(this.geometry instanceof THREE.BufferGeometry)for(var vec=new THREE.Vector4,skinWeight=this.geometry.attributes.skinWeight,i=0;i<skinWeight.count;i++){vec.x=skinWeight.getX(i),vec.y=skinWeight.getY(i),vec.z=skinWeight.getZ(i),vec.w=skinWeight.getW(i);var scale=1/vec.lengthManhattan();scale!==1/0?vec.multiplyScalar(scale):vec.set(1,0,0,0),skinWeight.setXYZW(i,vec.x,vec.y,vec.z,vec.w)}},THREE.SkinnedMesh.prototype.updateMatrixWorld=function(force){THREE.Mesh.prototype.updateMatrixWorld.call(this,!0),"attached"===this.bindMode?this.bindMatrixInverse.getInverse(this.matrixWorld):"detached"===this.bindMode?this.bindMatrixInverse.getInverse(this.bindMatrix):console.warn("THREE.SkinnedMesh unrecognized bindMode: "+this.bindMode)},THREE.SkinnedMesh.prototype.clone=function(){return new this.constructor(this.geometry,this.material,this.useVertexTexture).copy(this)},THREE.LOD=function(){THREE.Object3D.call(this),this.type="LOD",Object.defineProperties(this,{levels:{enumerable:!0,value:[]}})},THREE.LOD.prototype=Object.create(THREE.Object3D.prototype),THREE.LOD.prototype.constructor=THREE.LOD,THREE.LOD.prototype.addLevel=function(object,distance){void 0===distance&&(distance=0),distance=Math.abs(distance);for(var levels=this.levels,l=0;l<levels.length&&!(distance<levels[l].distance);l++);levels.splice(l,0,{distance:distance,object:object}),this.add(object)},THREE.LOD.prototype.getObjectForDistance=function(distance){for(var levels=this.levels,i=1,l=levels.length;l>i&&!(distance<levels[i].distance);i++);return levels[i-1].object},THREE.LOD.prototype.raycast=function(){var matrixPosition=new THREE.Vector3;return function(raycaster,intersects){matrixPosition.setFromMatrixPosition(this.matrixWorld);var distance=raycaster.ray.origin.distanceTo(matrixPosition);this.getObjectForDistance(distance).raycast(raycaster,intersects)}}(),THREE.LOD.prototype.update=function(){var v1=new THREE.Vector3,v2=new THREE.Vector3;return function(camera){var levels=this.levels;if(levels.length>1){v1.setFromMatrixPosition(camera.matrixWorld),v2.setFromMatrixPosition(this.matrixWorld);var distance=v1.distanceTo(v2);levels[0].object.visible=!0;for(var i=1,l=levels.length;l>i&&distance>=levels[i].distance;i++)levels[i-1].object.visible=!1,levels[i].object.visible=!0;for(;l>i;i++)levels[i].object.visible=!1}}}(),THREE.LOD.prototype.copy=function(source){THREE.Object3D.prototype.copy.call(this,source,!1);for(var levels=source.levels,i=0,l=levels.length;l>i;i++){var level=levels[i];this.addLevel(level.object.clone(),level.distance)}return this},THREE.LOD.prototype.toJSON=function(meta){var data=THREE.Object3D.prototype.toJSON.call(this,meta);data.object.levels=[];for(var levels=this.levels,i=0,l=levels.length;l>i;i++){var level=levels[i];data.object.levels.push({object:level.object.uuid,distance:level.distance})}return data},THREE.Sprite=function(){var indices=new Uint16Array([0,1,2,0,2,3]),vertices=new Float32Array([-.5,-.5,0,.5,-.5,0,.5,.5,0,-.5,.5,0]),uvs=new Float32Array([0,0,1,0,1,1,0,1]),geometry=new THREE.BufferGeometry;return geometry.setIndex(new THREE.BufferAttribute(indices,1)),geometry.addAttribute("position",new THREE.BufferAttribute(vertices,3)),geometry.addAttribute("uv",new THREE.BufferAttribute(uvs,2)),function(material){THREE.Object3D.call(this),this.type="Sprite",this.geometry=geometry,this.material=void 0!==material?material:new THREE.SpriteMaterial}}(),THREE.Sprite.prototype=Object.create(THREE.Object3D.prototype),THREE.Sprite.prototype.constructor=THREE.Sprite,THREE.Sprite.prototype.raycast=function(){var matrixPosition=new THREE.Vector3;return function(raycaster,intersects){matrixPosition.setFromMatrixPosition(this.matrixWorld);var distanceSq=raycaster.ray.distanceSqToPoint(matrixPosition),guessSizeSq=this.scale.x*this.scale.y/4;distanceSq>guessSizeSq||intersects.push({distance:Math.sqrt(distanceSq),point:this.position,face:null,object:this})}}(),THREE.Sprite.prototype.clone=function(){return new this.constructor(this.material).copy(this)},THREE.Particle=THREE.Sprite,THREE.LensFlare=function(texture,size,distance,blending,color){THREE.Object3D.call(this),this.lensFlares=[],this.positionScreen=new THREE.Vector3,this.customUpdateCallback=void 0,void 0!==texture&&this.add(texture,size,distance,blending,color)},THREE.LensFlare.prototype=Object.create(THREE.Object3D.prototype),THREE.LensFlare.prototype.constructor=THREE.LensFlare,THREE.LensFlare.prototype.add=function(texture,size,distance,blending,color,opacity){void 0===size&&(size=-1),void 0===distance&&(distance=0),void 0===opacity&&(opacity=1),void 0===color&&(color=new THREE.Color(16777215)),void 0===blending&&(blending=THREE.NormalBlending),distance=Math.min(distance,Math.max(0,distance)),this.lensFlares.push({texture:texture,size:size,distance:distance,x:0,y:0,z:0,scale:1,rotation:0,opacity:opacity,color:color,blending:blending})},THREE.LensFlare.prototype.updateLensFlares=function(){var f,flare,fl=this.lensFlares.length,vecX=2*-this.positionScreen.x,vecY=2*-this.positionScreen.y;for(f=0;fl>f;f++)flare=this.lensFlares[f],flare.x=this.positionScreen.x+vecX*flare.distance,flare.y=this.positionScreen.y+vecY*flare.distance,flare.wantedRotation=flare.x*Math.PI*.25,flare.rotation+=.25*(flare.wantedRotation-flare.rotation)},THREE.LensFlare.prototype.copy=function(source){THREE.Object3D.prototype.copy.call(this,source),this.positionScreen.copy(source.positionScreen),this.customUpdateCallback=source.customUpdateCallback;for(var i=0,l=source.lensFlares.length;l>i;i++)this.lensFlares.push(source.lensFlares[i]);return this},THREE.Scene=function(){THREE.Object3D.call(this),this.type="Scene",this.fog=null,this.overrideMaterial=null,this.autoUpdate=!0},THREE.Scene.prototype=Object.create(THREE.Object3D.prototype),THREE.Scene.prototype.constructor=THREE.Scene,THREE.Scene.prototype.copy=function(source,recursive){return THREE.Object3D.prototype.copy.call(this,source,recursive),null!==source.fog&&(this.fog=source.fog.clone()),null!==source.overrideMaterial&&(this.overrideMaterial=source.overrideMaterial.clone()),this.autoUpdate=source.autoUpdate,this.matrixAutoUpdate=source.matrixAutoUpdate,this},THREE.Fog=function(color,near,far){this.name="",this.color=new THREE.Color(color),this.near=void 0!==near?near:1,this.far=void 0!==far?far:1e3},THREE.Fog.prototype.clone=function(){return new THREE.Fog(this.color.getHex(),this.near,this.far)},THREE.FogExp2=function(color,density){this.name="",this.color=new THREE.Color(color),this.density=void 0!==density?density:25e-5},THREE.FogExp2.prototype.clone=function(){return new THREE.FogExp2(this.color.getHex(),this.density)},THREE.ShaderChunk={},THREE.ShaderChunk.alphamap_fragment="#ifdef USE_ALPHAMAP\n	diffuseColor.a *= texture2D( alphaMap, vUv ).g;\n#endif\n",THREE.ShaderChunk.alphamap_pars_fragment="#ifdef USE_ALPHAMAP\n	uniform sampler2D alphaMap;\n#endif\n",THREE.ShaderChunk.alphatest_fragment="#ifdef ALPHATEST\n	if ( diffuseColor.a < ALPHATEST ) discard;\n#endif\n",THREE.ShaderChunk.aomap_fragment="#ifdef USE_AOMAP\n	float ambientOcclusion = ( texture2D( aoMap, vUv2 ).r - 1.0 ) * aoMapIntensity + 1.0;\n	reflectedLight.indirectDiffuse *= ambientOcclusion;\n	#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n		float dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n		reflectedLight.indirectSpecular *= computeSpecularOcclusion( dotNV, ambientOcclusion, material.specularRoughness );\n	#endif\n#endif\n",THREE.ShaderChunk.aomap_pars_fragment="#ifdef USE_AOMAP\n	uniform sampler2D aoMap;\n	uniform float aoMapIntensity;\n#endif",THREE.ShaderChunk.begin_vertex="\nvec3 transformed = vec3( position );\n",THREE.ShaderChunk.beginnormal_vertex="\nvec3 objectNormal = vec3( normal );\n",THREE.ShaderChunk.bsdfs="bool testLightInRange( const in float lightDistance, const in float cutoffDistance ) {\n	return any( bvec2( cutoffDistance == 0.0, lightDistance < cutoffDistance ) );\n}\nfloat punctualLightIntensityToIrradianceFactor( const in float lightDistance, const in float cutoffDistance, const in float decayExponent ) {\n		if( decayExponent > 0.0 ) {\n#if defined ( PHYSICALLY_CORRECT_LIGHTS )\n			float distanceFalloff = 1.0 / max( pow( lightDistance, decayExponent ), 0.01 );\n			float maxDistanceCutoffFactor = pow2( saturate( 1.0 - pow4( lightDistance / cutoffDistance ) ) );\n			return distanceFalloff * maxDistanceCutoffFactor;\n#else\n			return pow( saturate( -lightDistance / cutoffDistance + 1.0 ), decayExponent );\n#endif\n		}\n		return 1.0;\n}\nvec3 BRDF_Diffuse_Lambert( const in vec3 diffuseColor ) {\n	return RECIPROCAL_PI * diffuseColor;\n}\nvec3 F_Schlick( const in vec3 specularColor, const in float dotLH ) {\n	float fresnel = exp2( ( -5.55473 * dotLH - 6.98316 ) * dotLH );\n	return ( 1.0 - specularColor ) * fresnel + specularColor;\n}\nfloat G_GGX_Smith( const in float alpha, const in float dotNL, const in float dotNV ) {\n	float a2 = pow2( alpha );\n	float gl = dotNL + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n	float gv = dotNV + sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n	return 1.0 / ( gl * gv );\n}\nfloat G_GGX_SmithCorrelated( const in float alpha, const in float dotNL, const in float dotNV ) {\n	float a2 = pow2( alpha );\n	float gv = dotNL * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNV ) );\n	float gl = dotNV * sqrt( a2 + ( 1.0 - a2 ) * pow2( dotNL ) );\n	return 0.5 / max( gv + gl, EPSILON );\n}\nfloat D_GGX( const in float alpha, const in float dotNH ) {\n	float a2 = pow2( alpha );\n	float denom = pow2( dotNH ) * ( a2 - 1.0 ) + 1.0;\n	return RECIPROCAL_PI * a2 / pow2( denom );\n}\nvec3 BRDF_Specular_GGX( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n	float alpha = pow2( roughness );\n	vec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n	float dotNL = saturate( dot( geometry.normal, incidentLight.direction ) );\n	float dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n	float dotNH = saturate( dot( geometry.normal, halfDir ) );\n	float dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n	vec3 F = F_Schlick( specularColor, dotLH );\n	float G = G_GGX_SmithCorrelated( alpha, dotNL, dotNV );\n	float D = D_GGX( alpha, dotNH );\n	return F * ( G * D );\n}\nvec3 BRDF_Specular_GGX_Environment( const in GeometricContext geometry, const in vec3 specularColor, const in float roughness ) {\n	float dotNV = saturate( dot( geometry.normal, geometry.viewDir ) );\n	const vec4 c0 = vec4( - 1, - 0.0275, - 0.572, 0.022 );\n	const vec4 c1 = vec4( 1, 0.0425, 1.04, - 0.04 );\n	vec4 r = roughness * c0 + c1;\n	float a004 = min( r.x * r.x, exp2( - 9.28 * dotNV ) ) * r.x + r.y;\n	vec2 AB = vec2( -1.04, 1.04 ) * a004 + r.zw;\n	return specularColor * AB.x + AB.y;\n}\nfloat G_BlinnPhong_Implicit( ) {\n	return 0.25;\n}\nfloat D_BlinnPhong( const in float shininess, const in float dotNH ) {\n	return RECIPROCAL_PI * ( shininess * 0.5 + 1.0 ) * pow( dotNH, shininess );\n}\nvec3 BRDF_Specular_BlinnPhong( const in IncidentLight incidentLight, const in GeometricContext geometry, const in vec3 specularColor, const in float shininess ) {\n	vec3 halfDir = normalize( incidentLight.direction + geometry.viewDir );\n	float dotNH = saturate( dot( geometry.normal, halfDir ) );\n	float dotLH = saturate( dot( incidentLight.direction, halfDir ) );\n	vec3 F = F_Schlick( specularColor, dotLH );\n	float G = G_BlinnPhong_Implicit( );\n	float D = D_BlinnPhong( shininess, dotNH );\n	return F * ( G * D );\n}\nfloat GGXRoughnessToBlinnExponent( const in float ggxRoughness ) {\n	return ( 2.0 / pow2( ggxRoughness + 0.0001 ) - 2.0 );\n}\nfloat BlinnExponentToGGXRoughness( const in float blinnExponent ) {\n	return sqrt( 2.0 / ( blinnExponent + 2.0 ) );\n}\n",THREE.ShaderChunk.bumpmap_pars_fragment="#ifdef USE_BUMPMAP\n	uniform sampler2D bumpMap;\n	uniform float bumpScale;\n	vec2 dHdxy_fwd() {\n		vec2 dSTdx = dFdx( vUv );\n		vec2 dSTdy = dFdy( vUv );\n		float Hll = bumpScale * texture2D( bumpMap, vUv ).x;\n		float dBx = bumpScale * texture2D( bumpMap, vUv + dSTdx ).x - Hll;\n		float dBy = bumpScale * texture2D( bumpMap, vUv + dSTdy ).x - Hll;\n		return vec2( dBx, dBy );\n	}\n	vec3 perturbNormalArb( vec3 surf_pos, vec3 surf_norm, vec2 dHdxy ) {\n		vec3 vSigmaX = dFdx( surf_pos );\n		vec3 vSigmaY = dFdy( surf_pos );\n		vec3 vN = surf_norm;\n		vec3 R1 = cross( vSigmaY, vN );\n		vec3 R2 = cross( vN, vSigmaX );\n		float fDet = dot( vSigmaX, R1 );\n		vec3 vGrad = sign( fDet ) * ( dHdxy.x * R1 + dHdxy.y * R2 );\n		return normalize( abs( fDet ) * surf_norm - vGrad );\n	}\n#endif\n",THREE.ShaderChunk.clipping_planes_fragment="#if NUM_CLIPPING_PLANES > 0\n	for ( int i = 0; i < NUM_CLIPPING_PLANES; ++ i ) {\n		vec4 plane = clippingPlanes[ i ];\n		if ( dot( vViewPosition, plane.xyz ) > plane.w ) discard;\n	}\n#endif\n",THREE.ShaderChunk.clipping_planes_pars_fragment="#if NUM_CLIPPING_PLANES > 0\n	#if ! defined( PHYSICAL ) && ! defined( PHONG )\n		varying vec3 vViewPosition;\n	#endif\n	uniform vec4 clippingPlanes[ NUM_CLIPPING_PLANES ];\n#endif\n",THREE.ShaderChunk.clipping_planes_pars_vertex="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n	varying vec3 vViewPosition;\n#endif\n",THREE.ShaderChunk.clipping_planes_vertex="#if NUM_CLIPPING_PLANES > 0 && ! defined( PHYSICAL ) && ! defined( PHONG )\n	vViewPosition = - mvPosition.xyz;\n#endif\n",THREE.ShaderChunk.color_fragment="#ifdef USE_COLOR\n	diffuseColor.rgb *= vColor;\n#endif",THREE.ShaderChunk.color_pars_fragment="#ifdef USE_COLOR\n	varying vec3 vColor;\n#endif\n",THREE.ShaderChunk.color_pars_vertex="#ifdef USE_COLOR\n	varying vec3 vColor;\n#endif",THREE.ShaderChunk.color_vertex="#ifdef USE_COLOR\n	vColor.xyz = color.xyz;\n#endif",THREE.ShaderChunk.common="#define PI 3.14159265359\n#define PI2 6.28318530718\n#define RECIPROCAL_PI 0.31830988618\n#define RECIPROCAL_PI2 0.15915494\n#define LOG2 1.442695\n#define EPSILON 1e-6\n#define saturate(a) clamp( a, 0.0, 1.0 )\n#define whiteCompliment(a) ( 1.0 - saturate( a ) )\nfloat pow2( const in float x ) { return x*x; }\nfloat pow3( const in float x ) { return x*x*x; }\nfloat pow4( const in float x ) { float x2 = x*x; return x2*x2; }\nfloat average( const in vec3 color ) { return dot( color, vec3( 0.3333 ) ); }\nhighp float rand( const in vec2 uv ) {\n	const highp float a = 12.9898, b = 78.233, c = 43758.5453;\n	highp float dt = dot( uv.xy, vec2( a,b ) ), sn = mod( dt, PI );\n	return fract(sin(sn) * c);\n}\nstruct IncidentLight {\n	vec3 color;\n	vec3 direction;\n	bool visible;\n};\nstruct ReflectedLight {\n	vec3 directDiffuse;\n	vec3 directSpecular;\n	vec3 indirectDiffuse;\n	vec3 indirectSpecular;\n};\nstruct GeometricContext {\n	vec3 position;\n	vec3 normal;\n	vec3 viewDir;\n};\nvec3 transformDirection( in vec3 dir, in mat4 matrix ) {\n	return normalize( ( matrix * vec4( dir, 0.0 ) ).xyz );\n}\nvec3 inverseTransformDirection( in vec3 dir, in mat4 matrix ) {\n	return normalize( ( vec4( dir, 0.0 ) * matrix ).xyz );\n}\nvec3 projectOnPlane(in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n	float distance = dot( planeNormal, point - pointOnPlane );\n	return - distance * planeNormal + point;\n}\nfloat sideOfPlane( in vec3 point, in vec3 pointOnPlane, in vec3 planeNormal ) {\n	return sign( dot( point - pointOnPlane, planeNormal ) );\n}\nvec3 linePlaneIntersect( in vec3 pointOnLine, in vec3 lineDirection, in vec3 pointOnPlane, in vec3 planeNormal ) {\n	return lineDirection * ( dot( planeNormal, pointOnPlane - pointOnLine ) / dot( planeNormal, lineDirection ) ) + pointOnLine;\n}\n",THREE.ShaderChunk.cube_uv_reflection_fragment="#ifdef ENVMAP_TYPE_CUBE_UV\nconst float cubeUV_textureSize = 1024.0;\nint getFaceFromDirection(vec3 direction) {\n	vec3 absDirection = abs(direction);\n	int face = -1;\n	if( absDirection.x > absDirection.z ) {\n		if(absDirection.x > absDirection.y )\n			face = direction.x > 0.0 ? 0 : 3;\n		else\n			face = direction.y > 0.0 ? 1 : 4;\n	}\n	else {\n		if(absDirection.z > absDirection.y )\n			face = direction.z > 0.0 ? 2 : 5;\n		else\n			face = direction.y > 0.0 ? 1 : 4;\n	}\n	return face;\n}\nfloat cubeUV_maxLods1 = log2(cubeUV_textureSize*0.25) - 1.0;\nfloat cubeUV_rangeClamp = exp2((6.0 - 1.0) * 2.0);\nvec2 MipLevelInfo( vec3 vec, float roughnessLevel, float roughness ) {\n	float scale = exp2(cubeUV_maxLods1 - roughnessLevel);\n	float dxRoughness = dFdx(roughness);\n	float dyRoughness = dFdy(roughness);\n	vec3 dx = dFdx( vec * scale * dxRoughness );\n	vec3 dy = dFdy( vec * scale * dyRoughness );\n	float d = max( dot( dx, dx ), dot( dy, dy ) );\n	d = clamp(d, 1.0, cubeUV_rangeClamp);\n	float mipLevel = 0.5 * log2(d);\n	return vec2(floor(mipLevel), fract(mipLevel));\n}\nfloat cubeUV_maxLods2 = log2(cubeUV_textureSize*0.25) - 2.0;\nconst float cubeUV_rcpTextureSize = 1.0 / cubeUV_textureSize;\nvec2 getCubeUV(vec3 direction, float roughnessLevel, float mipLevel) {\n	mipLevel = roughnessLevel > cubeUV_maxLods2 - 3.0 ? 0.0 : mipLevel;\n	float a = 16.0 * cubeUV_rcpTextureSize;\n	vec2 exp2_packed = exp2( vec2( roughnessLevel, mipLevel ) );\n	vec2 rcp_exp2_packed = vec2( 1.0 ) / exp2_packed;\n	float powScale = exp2_packed.x * exp2_packed.y;\n	float scale = rcp_exp2_packed.x * rcp_exp2_packed.y * 0.25;\n	float mipOffset = 0.75*(1.0 - rcp_exp2_packed.y) * rcp_exp2_packed.x;\n	bool bRes = mipLevel == 0.0;\n	scale =  bRes && (scale < a) ? a : scale;\n	vec3 r;\n	vec2 offset;\n	int face = getFaceFromDirection(direction);\n	float rcpPowScale = 1.0 / powScale;\n	if( face == 0) {\n		r = vec3(direction.x, -direction.z, direction.y);\n		offset = vec2(0.0+mipOffset,0.75 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n	}\n	else if( face == 1) {\n		r = vec3(direction.y, direction.x, direction.z);\n		offset = vec2(scale+mipOffset, 0.75 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n	}\n	else if( face == 2) {\n		r = vec3(direction.z, direction.x, direction.y);\n		offset = vec2(2.0*scale+mipOffset, 0.75 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  a : offset.y;\n	}\n	else if( face == 3) {\n		r = vec3(direction.x, direction.z, direction.y);\n		offset = vec2(0.0+mipOffset,0.5 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n	}\n	else if( face == 4) {\n		r = vec3(direction.y, direction.x, -direction.z);\n		offset = vec2(scale+mipOffset, 0.5 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n	}\n	else {\n		r = vec3(direction.z, -direction.x, direction.y);\n		offset = vec2(2.0*scale+mipOffset, 0.5 * rcpPowScale);\n		offset.y = bRes && (offset.y < 2.0*a) ?  0.0 : offset.y;\n	}\n	r = normalize(r);\n	float texelOffset = 0.5 * cubeUV_rcpTextureSize;\n	vec2 s = ( r.yz / abs( r.x ) + vec2( 1.0 ) ) * 0.5;\n	vec2 base = offset + vec2( texelOffset );\n	return base + s * ( scale - 2.0 * texelOffset );\n}\nfloat cubeUV_maxLods3 = log2(cubeUV_textureSize*0.25) - 3.0;\nvec4 textureCubeUV(vec3 reflectedDirection, float roughness ) {\n	float roughnessVal = roughness* cubeUV_maxLods3;\n	float r1 = floor(roughnessVal);\n	float r2 = r1 + 1.0;\n	float t = fract(roughnessVal);\n	vec2 mipInfo = MipLevelInfo(reflectedDirection, r1, roughness);\n	float s = mipInfo.y;\n	float level0 = mipInfo.x;\n	float level1 = level0 + 1.0;\n	level1 = level1 > 5.0 ? 5.0 : level1;\n	level0 += min( floor( s + 0.5 ), 5.0 );\n	vec2 uv_10 = getCubeUV(reflectedDirection, r1, level0);\n	vec4 color10 = envMapTexelToLinear(texture2D(envMap, uv_10));\n	vec2 uv_20 = getCubeUV(reflectedDirection, r2, level0);\n	vec4 color20 = envMapTexelToLinear(texture2D(envMap, uv_20));\n	vec4 result = mix(color10, color20, t);\n	return vec4(result.rgb, 1.0);\n}\n#endif\n",
THREE.ShaderChunk.defaultnormal_vertex="#ifdef FLIP_SIDED\n	objectNormal = -objectNormal;\n#endif\nvec3 transformedNormal = normalMatrix * objectNormal;\n",THREE.ShaderChunk.displacementmap_vertex="#ifdef USE_DISPLACEMENTMAP\n	transformed += normal * ( texture2D( displacementMap, uv ).x * displacementScale + displacementBias );\n#endif\n",THREE.ShaderChunk.displacementmap_pars_vertex="#ifdef USE_DISPLACEMENTMAP\n	uniform sampler2D displacementMap;\n	uniform float displacementScale;\n	uniform float displacementBias;\n#endif\n",THREE.ShaderChunk.emissivemap_fragment="#ifdef USE_EMISSIVEMAP\n	vec4 emissiveColor = texture2D( emissiveMap, vUv );\n	emissiveColor.rgb = emissiveMapTexelToLinear( emissiveColor ).rgb;\n	totalEmissiveRadiance *= emissiveColor.rgb;\n#endif\n",THREE.ShaderChunk.emissivemap_pars_fragment="#ifdef USE_EMISSIVEMAP\n	uniform sampler2D emissiveMap;\n#endif\n",THREE.ShaderChunk.encodings_pars_fragment="\nvec4 LinearToLinear( in vec4 value ) {\n  return value;\n}\nvec4 GammaToLinear( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( gammaFactor ) ), value.w );\n}\nvec4 LinearToGamma( in vec4 value, in float gammaFactor ) {\n  return vec4( pow( value.xyz, vec3( 1.0 / gammaFactor ) ), value.w );\n}\nvec4 sRGBToLinear( in vec4 value ) {\n  return vec4( mix( pow( value.rgb * 0.9478672986 + vec3( 0.0521327014 ), vec3( 2.4 ) ), value.rgb * 0.0773993808, vec3( lessThanEqual( value.rgb, vec3( 0.04045 ) ) ) ), value.w );\n}\nvec4 LinearTosRGB( in vec4 value ) {\n  return vec4( mix( pow( value.rgb, vec3( 0.41666 ) ) * 1.055 - vec3( 0.055 ), value.rgb * 12.92, vec3( lessThanEqual( value.rgb, vec3( 0.0031308 ) ) ) ), value.w );\n}\nvec4 RGBEToLinear( in vec4 value ) {\n  return vec4( value.rgb * exp2( value.a * 255.0 - 128.0 ), 1.0 );\n}\nvec4 LinearToRGBE( in vec4 value ) {\n  float maxComponent = max( max( value.r, value.g ), value.b );\n  float fExp = clamp( ceil( log2( maxComponent ) ), -128.0, 127.0 );\n  return vec4( value.rgb / exp2( fExp ), ( fExp + 128.0 ) / 255.0 );\n}\nvec4 RGBMToLinear( in vec4 value, in float maxRange ) {\n  return vec4( value.xyz * value.w * maxRange, 1.0 );\n}\nvec4 LinearToRGBM( in vec4 value, in float maxRange ) {\n  float maxRGB = max( value.x, max( value.g, value.b ) );\n  float M      = clamp( maxRGB / maxRange, 0.0, 1.0 );\n  M            = ceil( M * 255.0 ) / 255.0;\n  return vec4( value.rgb / ( M * maxRange ), M );\n}\nvec4 RGBDToLinear( in vec4 value, in float maxRange ) {\n    return vec4( value.rgb * ( ( maxRange / 255.0 ) / value.a ), 1.0 );\n}\nvec4 LinearToRGBD( in vec4 value, in float maxRange ) {\n    float maxRGB = max( value.x, max( value.g, value.b ) );\n    float D      = max( maxRange / maxRGB, 1.0 );\n    D            = min( floor( D ) / 255.0, 1.0 );\n    return vec4( value.rgb * ( D * ( 255.0 / maxRange ) ), D );\n}\nconst mat3 cLogLuvM = mat3( 0.2209, 0.3390, 0.4184, 0.1138, 0.6780, 0.7319, 0.0102, 0.1130, 0.2969 );\nvec4 LinearToLogLuv( in vec4 value )  {\n  vec3 Xp_Y_XYZp = value.rgb * cLogLuvM;\n  Xp_Y_XYZp = max(Xp_Y_XYZp, vec3(1e-6, 1e-6, 1e-6));\n  vec4 vResult;\n  vResult.xy = Xp_Y_XYZp.xy / Xp_Y_XYZp.z;\n  float Le = 2.0 * log2(Xp_Y_XYZp.y) + 127.0;\n  vResult.w = fract(Le);\n  vResult.z = (Le - (floor(vResult.w*255.0))/255.0)/255.0;\n  return vResult;\n}\nconst mat3 cLogLuvInverseM = mat3( 6.0014, -2.7008, -1.7996, -1.3320, 3.1029, -5.7721, 0.3008, -1.0882, 5.6268 );\nvec4 LogLuvToLinear( in vec4 value ) {\n  float Le = value.z * 255.0 + value.w;\n  vec3 Xp_Y_XYZp;\n  Xp_Y_XYZp.y = exp2((Le - 127.0) / 2.0);\n  Xp_Y_XYZp.z = Xp_Y_XYZp.y / value.y;\n  Xp_Y_XYZp.x = value.x * Xp_Y_XYZp.z;\n  vec3 vRGB = Xp_Y_XYZp.rgb * cLogLuvInverseM;\n  return vec4( max(vRGB, 0.0), 1.0 );\n}\n",THREE.ShaderChunk.encodings_fragment="  gl_FragColor = linearToOutputTexel( gl_FragColor );\n",THREE.ShaderChunk.envmap_fragment="#ifdef USE_ENVMAP\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n		vec3 cameraToVertex = normalize( vWorldPosition - cameraPosition );\n		vec3 worldNormal = inverseTransformDirection( normal, viewMatrix );\n		#ifdef ENVMAP_MODE_REFLECTION\n			vec3 reflectVec = reflect( cameraToVertex, worldNormal );\n		#else\n			vec3 reflectVec = refract( cameraToVertex, worldNormal, refractionRatio );\n		#endif\n	#else\n		vec3 reflectVec = vReflect;\n	#endif\n	#ifdef DOUBLE_SIDED\n		float flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n	#else\n		float flipNormal = 1.0;\n	#endif\n	#ifdef ENVMAP_TYPE_CUBE\n		vec4 envColor = textureCube( envMap, flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz ) );\n	#elif defined( ENVMAP_TYPE_EQUIREC )\n		vec2 sampleUV;\n		sampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n		sampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n		vec4 envColor = texture2D( envMap, sampleUV );\n	#elif defined( ENVMAP_TYPE_SPHERE )\n		vec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n		vec4 envColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5 );\n	#endif\n	envColor = envMapTexelToLinear( envColor );\n	#ifdef ENVMAP_BLENDING_MULTIPLY\n		outgoingLight = mix( outgoingLight, outgoingLight * envColor.xyz, specularStrength * reflectivity );\n	#elif defined( ENVMAP_BLENDING_MIX )\n		outgoingLight = mix( outgoingLight, envColor.xyz, specularStrength * reflectivity );\n	#elif defined( ENVMAP_BLENDING_ADD )\n		outgoingLight += envColor.xyz * specularStrength * reflectivity;\n	#endif\n#endif\n",THREE.ShaderChunk.envmap_pars_fragment="#if defined( USE_ENVMAP ) || defined( PHYSICAL )\n	uniform float reflectivity;\n	uniform float envMapIntenstiy;\n#endif\n#ifdef USE_ENVMAP\n	#if ! defined( PHYSICAL ) && ( defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) )\n		varying vec3 vWorldPosition;\n	#endif\n	#ifdef ENVMAP_TYPE_CUBE\n		uniform samplerCube envMap;\n	#else\n		uniform sampler2D envMap;\n	#endif\n	uniform float flipEnvMap;\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG ) || defined( PHYSICAL )\n		uniform float refractionRatio;\n	#else\n		varying vec3 vReflect;\n	#endif\n#endif\n",THREE.ShaderChunk.envmap_pars_vertex="#ifdef USE_ENVMAP\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n		varying vec3 vWorldPosition;\n	#else\n		varying vec3 vReflect;\n		uniform float refractionRatio;\n	#endif\n#endif\n",THREE.ShaderChunk.envmap_vertex="#ifdef USE_ENVMAP\n	#if defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( PHONG )\n		vWorldPosition = worldPosition.xyz;\n	#else\n		vec3 cameraToVertex = normalize( worldPosition.xyz - cameraPosition );\n		vec3 worldNormal = inverseTransformDirection( transformedNormal, viewMatrix );\n		#ifdef ENVMAP_MODE_REFLECTION\n			vReflect = reflect( cameraToVertex, worldNormal );\n		#else\n			vReflect = refract( cameraToVertex, worldNormal, refractionRatio );\n		#endif\n	#endif\n#endif\n",THREE.ShaderChunk.fog_fragment="#ifdef USE_FOG\n	#ifdef USE_LOGDEPTHBUF_EXT\n		float depth = gl_FragDepthEXT / gl_FragCoord.w;\n	#else\n		float depth = gl_FragCoord.z / gl_FragCoord.w;\n	#endif\n	#ifdef FOG_EXP2\n		float fogFactor = whiteCompliment( exp2( - fogDensity * fogDensity * depth * depth * LOG2 ) );\n	#else\n		float fogFactor = smoothstep( fogNear, fogFar, depth );\n	#endif\n	gl_FragColor.rgb = mix( gl_FragColor.rgb, fogColor, fogFactor );\n#endif\n",THREE.ShaderChunk.fog_pars_fragment="#ifdef USE_FOG\n	uniform vec3 fogColor;\n	#ifdef FOG_EXP2\n		uniform float fogDensity;\n	#else\n		uniform float fogNear;\n		uniform float fogFar;\n	#endif\n#endif",THREE.ShaderChunk.lightmap_fragment="#ifdef USE_LIGHTMAP\n	reflectedLight.indirectDiffuse += PI * texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n#endif\n",THREE.ShaderChunk.lightmap_pars_fragment="#ifdef USE_LIGHTMAP\n	uniform sampler2D lightMap;\n	uniform float lightMapIntensity;\n#endif",THREE.ShaderChunk.lights_lambert_vertex="vec3 diffuse = vec3( 1.0 );\nGeometricContext geometry;\ngeometry.position = mvPosition.xyz;\ngeometry.normal = normalize( transformedNormal );\ngeometry.viewDir = normalize( -mvPosition.xyz );\nGeometricContext backGeometry;\nbackGeometry.position = geometry.position;\nbackGeometry.normal = -geometry.normal;\nbackGeometry.viewDir = geometry.viewDir;\nvLightFront = vec3( 0.0 );\n#ifdef DOUBLE_SIDED\n	vLightBack = vec3( 0.0 );\n#endif\nIncidentLight directLight;\nfloat dotNL;\nvec3 directLightColor_Diffuse;\n#if NUM_POINT_LIGHTS > 0\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		getPointDirectLightIrradiance( pointLights[ i ], geometry, directLight );\n		dotNL = dot( geometry.normal, directLight.direction );\n		directLightColor_Diffuse = PI * directLight.color;\n		vLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n		#ifdef DOUBLE_SIDED\n			vLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n		#endif\n	}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		getSpotDirectLightIrradiance( spotLights[ i ], geometry, directLight );\n		dotNL = dot( geometry.normal, directLight.direction );\n		directLightColor_Diffuse = PI * directLight.color;\n		vLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n		#ifdef DOUBLE_SIDED\n			vLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n		#endif\n	}\n#endif\n#if NUM_DIR_LIGHTS > 0\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		getDirectionalDirectLightIrradiance( directionalLights[ i ], geometry, directLight );\n		dotNL = dot( geometry.normal, directLight.direction );\n		directLightColor_Diffuse = PI * directLight.color;\n		vLightFront += saturate( dotNL ) * directLightColor_Diffuse;\n		#ifdef DOUBLE_SIDED\n			vLightBack += saturate( -dotNL ) * directLightColor_Diffuse;\n		#endif\n	}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n	for ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n		vLightFront += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n		#ifdef DOUBLE_SIDED\n			vLightBack += getHemisphereLightIrradiance( hemisphereLights[ i ], backGeometry );\n		#endif\n	}\n#endif\n",THREE.ShaderChunk.lights_pars="uniform vec3 ambientLightColor;\nvec3 getAmbientLightIrradiance( const in vec3 ambientLightColor ) {\n	vec3 irradiance = ambientLightColor;\n	#ifndef PHYSICALLY_CORRECT_LIGHTS\n		irradiance *= PI;\n	#endif\n	return irradiance;\n}\n#if NUM_DIR_LIGHTS > 0\n	struct DirectionalLight {\n		vec3 direction;\n		vec3 color;\n		int shadow;\n		float shadowBias;\n		float shadowRadius;\n		vec2 shadowMapSize;\n	};\n	uniform DirectionalLight directionalLights[ NUM_DIR_LIGHTS ];\n	void getDirectionalDirectLightIrradiance( const in DirectionalLight directionalLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n		directLight.color = directionalLight.color;\n		directLight.direction = directionalLight.direction;\n		directLight.visible = true;\n	}\n#endif\n#if NUM_POINT_LIGHTS > 0\n	struct PointLight {\n		vec3 position;\n		vec3 color;\n		float distance;\n		float decay;\n		int shadow;\n		float shadowBias;\n		float shadowRadius;\n		vec2 shadowMapSize;\n	};\n	uniform PointLight pointLights[ NUM_POINT_LIGHTS ];\n	void getPointDirectLightIrradiance( const in PointLight pointLight, const in GeometricContext geometry, out IncidentLight directLight ) {\n		vec3 lVector = pointLight.position - geometry.position;\n		directLight.direction = normalize( lVector );\n		float lightDistance = length( lVector );\n		if ( testLightInRange( lightDistance, pointLight.distance ) ) {\n			directLight.color = pointLight.color;\n			directLight.color *= punctualLightIntensityToIrradianceFactor( lightDistance, pointLight.distance, pointLight.decay );\n			directLight.visible = true;\n		} else {\n			directLight.color = vec3( 0.0 );\n			directLight.visible = false;\n		}\n	}\n#endif\n#if NUM_SPOT_LIGHTS > 0\n	struct SpotLight {\n		vec3 position;\n		vec3 direction;\n		vec3 color;\n		float distance;\n		float decay;\n		float coneCos;\n		float penumbraCos;\n		int shadow;\n		float shadowBias;\n		float shadowRadius;\n		vec2 shadowMapSize;\n	};\n	uniform SpotLight spotLights[ NUM_SPOT_LIGHTS ];\n	void getSpotDirectLightIrradiance( const in SpotLight spotLight, const in GeometricContext geometry, out IncidentLight directLight  ) {\n		vec3 lVector = spotLight.position - geometry.position;\n		directLight.direction = normalize( lVector );\n		float lightDistance = length( lVector );\n		float angleCos = dot( directLight.direction, spotLight.direction );\n		if ( all( bvec2( angleCos > spotLight.coneCos, testLightInRange( lightDistance, spotLight.distance ) ) ) ) {\n			float spotEffect = smoothstep( spotLight.coneCos, spotLight.penumbraCos, angleCos );\n			directLight.color = spotLight.color;\n			directLight.color *= spotEffect * punctualLightIntensityToIrradianceFactor( lightDistance, spotLight.distance, spotLight.decay );\n			directLight.visible = true;\n		} else {\n			directLight.color = vec3( 0.0 );\n			directLight.visible = false;\n		}\n	}\n#endif\n#if NUM_HEMI_LIGHTS > 0\n	struct HemisphereLight {\n		vec3 direction;\n		vec3 skyColor;\n		vec3 groundColor;\n	};\n	uniform HemisphereLight hemisphereLights[ NUM_HEMI_LIGHTS ];\n	vec3 getHemisphereLightIrradiance( const in HemisphereLight hemiLight, const in GeometricContext geometry ) {\n		float dotNL = dot( geometry.normal, hemiLight.direction );\n		float hemiDiffuseWeight = 0.5 * dotNL + 0.5;\n		vec3 irradiance = mix( hemiLight.groundColor, hemiLight.skyColor, hemiDiffuseWeight );\n		#ifndef PHYSICALLY_CORRECT_LIGHTS\n			irradiance *= PI;\n		#endif\n		return irradiance;\n	}\n#endif\n#if defined( USE_ENVMAP ) && defined( PHYSICAL )\n	vec3 getLightProbeIndirectIrradiance( const in GeometricContext geometry, const in int maxMIPLevel ) {\n		#ifdef DOUBLE_SIDED\n			float flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n		#else\n			float flipNormal = 1.0;\n		#endif\n		vec3 worldNormal = inverseTransformDirection( geometry.normal, viewMatrix );\n		#ifdef ENVMAP_TYPE_CUBE\n			vec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = textureCubeLodEXT( envMap, queryVec, float( maxMIPLevel ) );\n			#else\n				vec4 envMapColor = textureCube( envMap, queryVec, float( maxMIPLevel ) );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#elif defined( ENVMAP_TYPE_CUBE_UV )\n			vec3 queryVec = flipNormal * vec3( flipEnvMap * worldNormal.x, worldNormal.yz );\n			vec4 envMapColor = textureCubeUV( queryVec, 1.0 );\n		#else\n			vec4 envMapColor = vec4( 0.0 );\n		#endif\n		return PI * envMapColor.rgb * envMapIntensity;\n	}\n	float getSpecularMIPLevel( const in float blinnShininessExponent, const in int maxMIPLevel ) {\n		float maxMIPLevelScalar = float( maxMIPLevel );\n		float desiredMIPLevel = maxMIPLevelScalar - 0.79248 - 0.5 * log2( pow2( blinnShininessExponent ) + 1.0 );\n		return clamp( desiredMIPLevel, 0.0, maxMIPLevelScalar );\n	}\n	vec3 getLightProbeIndirectRadiance( const in GeometricContext geometry, const in float blinnShininessExponent, const in int maxMIPLevel ) {\n		#ifdef ENVMAP_MODE_REFLECTION\n			vec3 reflectVec = reflect( -geometry.viewDir, geometry.normal );\n		#else\n			vec3 reflectVec = refract( -geometry.viewDir, geometry.normal, refractionRatio );\n		#endif\n		#ifdef DOUBLE_SIDED\n			float flipNormal = ( float( gl_FrontFacing ) * 2.0 - 1.0 );\n		#else\n			float flipNormal = 1.0;\n		#endif\n		reflectVec = inverseTransformDirection( reflectVec, viewMatrix );\n		float specularMIPLevel = getSpecularMIPLevel( blinnShininessExponent, maxMIPLevel );\n		#ifdef ENVMAP_TYPE_CUBE\n			vec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = textureCubeLodEXT( envMap, queryReflectVec, specularMIPLevel );\n			#else\n				vec4 envMapColor = textureCube( envMap, queryReflectVec, specularMIPLevel );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#elif defined( ENVMAP_TYPE_CUBE_UV )\n			vec3 queryReflectVec = flipNormal * vec3( flipEnvMap * reflectVec.x, reflectVec.yz );\n			vec4 envMapColor = textureCubeUV(queryReflectVec, BlinnExponentToGGXRoughness(blinnShininessExponent));\n		#elif defined( ENVMAP_TYPE_EQUIREC )\n			vec2 sampleUV;\n			sampleUV.y = saturate( flipNormal * reflectVec.y * 0.5 + 0.5 );\n			sampleUV.x = atan( flipNormal * reflectVec.z, flipNormal * reflectVec.x ) * RECIPROCAL_PI2 + 0.5;\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = texture2DLodEXT( envMap, sampleUV, specularMIPLevel );\n			#else\n				vec4 envMapColor = texture2D( envMap, sampleUV, specularMIPLevel );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#elif defined( ENVMAP_TYPE_SPHERE )\n			vec3 reflectView = flipNormal * normalize((viewMatrix * vec4( reflectVec, 0.0 )).xyz + vec3(0.0,0.0,1.0));\n			#ifdef TEXTURE_LOD_EXT\n				vec4 envMapColor = texture2DLodEXT( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n			#else\n				vec4 envMapColor = texture2D( envMap, reflectView.xy * 0.5 + 0.5, specularMIPLevel );\n			#endif\n			envMapColor.rgb = envMapTexelToLinear( envMapColor ).rgb;\n		#endif\n		return envMapColor.rgb * envMapIntensity;\n	}\n#endif\n",THREE.ShaderChunk.lights_phong_fragment="BlinnPhongMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb;\nmaterial.specularColor = specular;\nmaterial.specularShininess = shininess;\nmaterial.specularStrength = specularStrength;\n",THREE.ShaderChunk.lights_phong_pars_fragment="varying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\nstruct BlinnPhongMaterial {\n	vec3	diffuseColor;\n	vec3	specularColor;\n	float	specularShininess;\n	float	specularStrength;\n};\nvoid RE_Direct_BlinnPhong( const in IncidentLight directLight, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n	float dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n	vec3 irradiance = dotNL * directLight.color;\n	#ifndef PHYSICALLY_CORRECT_LIGHTS\n		irradiance *= PI;\n	#endif\n	reflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n	reflectedLight.directSpecular += irradiance * BRDF_Specular_BlinnPhong( directLight, geometry, material.specularColor, material.specularShininess ) * material.specularStrength;\n}\nvoid RE_IndirectDiffuse_BlinnPhong( const in vec3 irradiance, const in GeometricContext geometry, const in BlinnPhongMaterial material, inout ReflectedLight reflectedLight ) {\n	reflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\n#define RE_Direct				RE_Direct_BlinnPhong\n#define RE_IndirectDiffuse		RE_IndirectDiffuse_BlinnPhong\n#define Material_LightProbeLOD( material )	(0)\n",THREE.ShaderChunk.lights_physical_fragment="PhysicalMaterial material;\nmaterial.diffuseColor = diffuseColor.rgb * ( 1.0 - metalnessFactor );\nmaterial.specularRoughness = clamp( roughnessFactor, 0.04, 1.0 );\n#ifdef STANDARD\n	material.specularColor = mix( vec3( 0.04 ), diffuseColor.rgb, metalnessFactor );\n#else\n	material.specularColor = mix( vec3( 0.16 * pow2( reflectivity ) ), diffuseColor.rgb, metalnessFactor );\n#endif\n",THREE.ShaderChunk.lights_physical_pars_fragment="struct PhysicalMaterial {\n	vec3	diffuseColor;\n	float	specularRoughness;\n	vec3	specularColor;\n	#ifndef STANDARD\n	#endif\n};\nvoid RE_Direct_Physical( const in IncidentLight directLight, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n	float dotNL = saturate( dot( geometry.normal, directLight.direction ) );\n	vec3 irradiance = dotNL * directLight.color;\n	#ifndef PHYSICALLY_CORRECT_LIGHTS\n		irradiance *= PI;\n	#endif\n	reflectedLight.directDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n	reflectedLight.directSpecular += irradiance * BRDF_Specular_GGX( directLight, geometry, material.specularColor, material.specularRoughness );\n}\nvoid RE_IndirectDiffuse_Physical( const in vec3 irradiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n	reflectedLight.indirectDiffuse += irradiance * BRDF_Diffuse_Lambert( material.diffuseColor );\n}\nvoid RE_IndirectSpecular_Physical( const in vec3 radiance, const in GeometricContext geometry, const in PhysicalMaterial material, inout ReflectedLight reflectedLight ) {\n	reflectedLight.indirectSpecular += radiance * BRDF_Specular_GGX_Environment( geometry, material.specularColor, material.specularRoughness );\n}\n#define RE_Direct				RE_Direct_Physical\n#define RE_IndirectDiffuse		RE_IndirectDiffuse_Physical\n#define RE_IndirectSpecular		RE_IndirectSpecular_Physical\n#define Material_BlinnShininessExponent( material )   GGXRoughnessToBlinnExponent( material.specularRoughness )\nfloat computeSpecularOcclusion( const in float dotNV, const in float ambientOcclusion, const in float roughness ) {\n	return saturate( pow( dotNV + ambientOcclusion, exp2( - 16.0 * roughness - 1.0 ) ) - 1.0 + ambientOcclusion );\n}\n",THREE.ShaderChunk.lights_template="\nGeometricContext geometry;\ngeometry.position = - vViewPosition;\ngeometry.normal = normal;\ngeometry.viewDir = normalize( vViewPosition );\nIncidentLight directLight;\n#if ( NUM_POINT_LIGHTS > 0 ) && defined( RE_Direct )\n	PointLight pointLight;\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		pointLight = pointLights[ i ];\n		getPointDirectLightIrradiance( pointLight, geometry, directLight );\n		#ifdef USE_SHADOWMAP\n		directLight.color *= all( bvec2( pointLight.shadow, directLight.visible ) ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n		#endif\n		RE_Direct( directLight, geometry, material, reflectedLight );\n	}\n#endif\n#if ( NUM_SPOT_LIGHTS > 0 ) && defined( RE_Direct )\n	SpotLight spotLight;\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		spotLight = spotLights[ i ];\n		getSpotDirectLightIrradiance( spotLight, geometry, directLight );\n		#ifdef USE_SHADOWMAP\n		directLight.color *= all( bvec2( spotLight.shadow, directLight.visible ) ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n		#endif\n		RE_Direct( directLight, geometry, material, reflectedLight );\n	}\n#endif\n#if ( NUM_DIR_LIGHTS > 0 ) && defined( RE_Direct )\n	DirectionalLight directionalLight;\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		directionalLight = directionalLights[ i ];\n		getDirectionalDirectLightIrradiance( directionalLight, geometry, directLight );\n		#ifdef USE_SHADOWMAP\n		directLight.color *= all( bvec2( directionalLight.shadow, directLight.visible ) ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n		#endif\n		RE_Direct( directLight, geometry, material, reflectedLight );\n	}\n#endif\n#if defined( RE_IndirectDiffuse )\n	vec3 irradiance = getAmbientLightIrradiance( ambientLightColor );\n	#ifdef USE_LIGHTMAP\n		vec3 lightMapIrradiance = texture2D( lightMap, vUv2 ).xyz * lightMapIntensity;\n		#ifndef PHYSICALLY_CORRECT_LIGHTS\n			lightMapIrradiance *= PI;\n		#endif\n		irradiance += lightMapIrradiance;\n	#endif\n	#if ( NUM_HEMI_LIGHTS > 0 )\n		for ( int i = 0; i < NUM_HEMI_LIGHTS; i ++ ) {\n			irradiance += getHemisphereLightIrradiance( hemisphereLights[ i ], geometry );\n		}\n	#endif\n	#if defined( USE_ENVMAP ) && defined( PHYSICAL ) && defined( ENVMAP_TYPE_CUBE_UV )\n	 	irradiance += getLightProbeIndirectIrradiance( geometry, 8 );\n	#endif\n	RE_IndirectDiffuse( irradiance, geometry, material, reflectedLight );\n#endif\n#if defined( USE_ENVMAP ) && defined( RE_IndirectSpecular )\n	vec3 radiance = getLightProbeIndirectRadiance( geometry, Material_BlinnShininessExponent( material ), 8 );\n	RE_IndirectSpecular( radiance, geometry, material, reflectedLight );\n#endif\n",THREE.ShaderChunk.logdepthbuf_fragment="#if defined(USE_LOGDEPTHBUF) && defined(USE_LOGDEPTHBUF_EXT)\n	gl_FragDepthEXT = log2(vFragDepth) * logDepthBufFC * 0.5;\n#endif",THREE.ShaderChunk.logdepthbuf_pars_fragment="#ifdef USE_LOGDEPTHBUF\n	uniform float logDepthBufFC;\n	#ifdef USE_LOGDEPTHBUF_EXT\n		varying float vFragDepth;\n	#endif\n#endif\n",THREE.ShaderChunk.logdepthbuf_pars_vertex="#ifdef USE_LOGDEPTHBUF\n	#ifdef USE_LOGDEPTHBUF_EXT\n		varying float vFragDepth;\n	#endif\n	uniform float logDepthBufFC;\n#endif",THREE.ShaderChunk.logdepthbuf_vertex="#ifdef USE_LOGDEPTHBUF\n	gl_Position.z = log2(max( EPSILON, gl_Position.w + 1.0 )) * logDepthBufFC;\n	#ifdef USE_LOGDEPTHBUF_EXT\n		vFragDepth = 1.0 + gl_Position.w;\n	#else\n		gl_Position.z = (gl_Position.z - 1.0) * gl_Position.w;\n	#endif\n#endif\n",THREE.ShaderChunk.map_fragment="#ifdef USE_MAP\n	vec4 texelColor = texture2D( map, vUv );\n	texelColor = mapTexelToLinear( texelColor );\n	diffuseColor *= texelColor;\n#endif\n",THREE.ShaderChunk.map_pars_fragment="#ifdef USE_MAP\n	uniform sampler2D map;\n#endif\n",THREE.ShaderChunk.map_particle_fragment="#ifdef USE_MAP\n	vec4 mapTexel = texture2D( map, vec2( gl_PointCoord.x, 1.0 - gl_PointCoord.y ) * offsetRepeat.zw + offsetRepeat.xy );\n	diffuseColor *= mapTexelToLinear( mapTexel );\n#endif\n",THREE.ShaderChunk.map_particle_pars_fragment="#ifdef USE_MAP\n	uniform vec4 offsetRepeat;\n	uniform sampler2D map;\n#endif\n",THREE.ShaderChunk.metalnessmap_fragment="float metalnessFactor = metalness;\n#ifdef USE_METALNESSMAP\n	vec4 texelMetalness = texture2D( metalnessMap, vUv );\n	metalnessFactor *= texelMetalness.r;\n#endif\n",THREE.ShaderChunk.metalnessmap_pars_fragment="#ifdef USE_METALNESSMAP\n	uniform sampler2D metalnessMap;\n#endif",THREE.ShaderChunk.morphnormal_vertex="#ifdef USE_MORPHNORMALS\n	objectNormal += ( morphNormal0 - normal ) * morphTargetInfluences[ 0 ];\n	objectNormal += ( morphNormal1 - normal ) * morphTargetInfluences[ 1 ];\n	objectNormal += ( morphNormal2 - normal ) * morphTargetInfluences[ 2 ];\n	objectNormal += ( morphNormal3 - normal ) * morphTargetInfluences[ 3 ];\n#endif\n",THREE.ShaderChunk.morphtarget_pars_vertex="#ifdef USE_MORPHTARGETS\n	#ifndef USE_MORPHNORMALS\n	uniform float morphTargetInfluences[ 8 ];\n	#else\n	uniform float morphTargetInfluences[ 4 ];\n	#endif\n#endif",THREE.ShaderChunk.morphtarget_vertex="#ifdef USE_MORPHTARGETS\n	transformed += ( morphTarget0 - position ) * morphTargetInfluences[ 0 ];\n	transformed += ( morphTarget1 - position ) * morphTargetInfluences[ 1 ];\n	transformed += ( morphTarget2 - position ) * morphTargetInfluences[ 2 ];\n	transformed += ( morphTarget3 - position ) * morphTargetInfluences[ 3 ];\n	#ifndef USE_MORPHNORMALS\n	transformed += ( morphTarget4 - position ) * morphTargetInfluences[ 4 ];\n	transformed += ( morphTarget5 - position ) * morphTargetInfluences[ 5 ];\n	transformed += ( morphTarget6 - position ) * morphTargetInfluences[ 6 ];\n	transformed += ( morphTarget7 - position ) * morphTargetInfluences[ 7 ];\n	#endif\n#endif\n",THREE.ShaderChunk.normal_fragment="#ifdef FLAT_SHADED\n	vec3 fdx = vec3( dFdx( vViewPosition.x ), dFdx( vViewPosition.y ), dFdx( vViewPosition.z ) );\n	vec3 fdy = vec3( dFdy( vViewPosition.x ), dFdy( vViewPosition.y ), dFdy( vViewPosition.z ) );\n	vec3 normal = normalize( cross( fdx, fdy ) );\n#else\n	vec3 normal = normalize( vNormal );\n	#ifdef DOUBLE_SIDED\n		normal = normal * ( -1.0 + 2.0 * float( gl_FrontFacing ) );\n	#endif\n#endif\n#ifdef USE_NORMALMAP\n	normal = perturbNormal2Arb( -vViewPosition, normal );\n#elif defined( USE_BUMPMAP )\n	normal = perturbNormalArb( -vViewPosition, normal, dHdxy_fwd() );\n#endif\n",THREE.ShaderChunk.normalmap_pars_fragment="#ifdef USE_NORMALMAP\n	uniform sampler2D normalMap;\n	uniform vec2 normalScale;\n	vec3 perturbNormal2Arb( vec3 eye_pos, vec3 surf_norm ) {\n		vec3 q0 = dFdx( eye_pos.xyz );\n		vec3 q1 = dFdy( eye_pos.xyz );\n		vec2 st0 = dFdx( vUv.st );\n		vec2 st1 = dFdy( vUv.st );\n		vec3 S = normalize( q0 * st1.t - q1 * st0.t );\n		vec3 T = normalize( -q0 * st1.s + q1 * st0.s );\n		vec3 N = normalize( surf_norm );\n		vec3 mapN = texture2D( normalMap, vUv ).xyz * 2.0 - 1.0;\n		mapN.xy = normalScale * mapN.xy;\n		mat3 tsn = mat3( S, T, N );\n		return normalize( tsn * mapN );\n	}\n#endif\n",THREE.ShaderChunk.packing="vec3 packNormalToRGB( const in vec3 normal ) {\n  return normalize( normal ) * 0.5 + 0.5;\n}\nvec3 unpackRGBToNormal( const in vec3 rgb ) {\n  return 1.0 - 2.0 * rgb.xyz;\n}\nvec4 packDepthToRGBA( const in float value ) {\n	const vec4 bit_shift = vec4( 256.0 * 256.0 * 256.0, 256.0 * 256.0, 256.0, 1.0 );\n	const vec4 bit_mask = vec4( 0.0, 1.0 / 256.0, 1.0 / 256.0, 1.0 / 256.0 );\n	vec4 res = mod( value * bit_shift * vec4( 255 ), vec4( 256 ) ) / vec4( 255 );\n	res -= res.xxyz * bit_mask;\n	return res;\n}\nfloat unpackRGBAToDepth( const in vec4 rgba ) {\n	const vec4 bitSh = vec4( 1.0 / ( 256.0 * 256.0 * 256.0 ), 1.0 / ( 256.0 * 256.0 ), 1.0 / 256.0, 1.0 );\n	return dot( rgba, bitSh );\n}\nfloat viewZToOrthoDepth( const in float viewZ, const in float near, const in float far ) {\n  return ( viewZ + near ) / ( near - far );\n}\nfloat OrthoDepthToViewZ( const in float linearClipZ, const in float near, const in float far ) {\n  return linearClipZ * ( near - far ) - near;\n}\nfloat viewZToPerspectiveDepth( const in float viewZ, const in float near, const in float far ) {\n  return (( near + viewZ ) * far ) / (( far - near ) * viewZ );\n}\nfloat perspectiveDepthToViewZ( const in float invClipZ, const in float near, const in float far ) {\n  return ( near * far ) / ( ( far - near ) * invClipZ - far );\n}\n",THREE.ShaderChunk.premultiplied_alpha_fragment="#ifdef PREMULTIPLIED_ALPHA\n	gl_FragColor.rgb *= gl_FragColor.a;\n#endif\n",THREE.ShaderChunk.project_vertex="#ifdef USE_SKINNING\n	vec4 mvPosition = modelViewMatrix * skinned;\n#else\n	vec4 mvPosition = modelViewMatrix * vec4( transformed, 1.0 );\n#endif\ngl_Position = projectionMatrix * mvPosition;\n",THREE.ShaderChunk.roughnessmap_fragment="float roughnessFactor = roughness;\n#ifdef USE_ROUGHNESSMAP\n	vec4 texelRoughness = texture2D( roughnessMap, vUv );\n	roughnessFactor *= texelRoughness.r;\n#endif\n",THREE.ShaderChunk.roughnessmap_pars_fragment="#ifdef USE_ROUGHNESSMAP\n	uniform sampler2D roughnessMap;\n#endif",THREE.ShaderChunk.shadowmap_pars_fragment="#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n		uniform sampler2D directionalShadowMap[ NUM_DIR_LIGHTS ];\n		varying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n		uniform sampler2D spotShadowMap[ NUM_SPOT_LIGHTS ];\n		varying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n		uniform sampler2D pointShadowMap[ NUM_POINT_LIGHTS ];\n		varying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n	#endif\n	float texture2DCompare( sampler2D depths, vec2 uv, float compare ) {\n		return step( compare, unpackRGBAToDepth( texture2D( depths, uv ) ) );\n	}\n	float texture2DShadowLerp( sampler2D depths, vec2 size, vec2 uv, float compare ) {\n		const vec2 offset = vec2( 0.0, 1.0 );\n		vec2 texelSize = vec2( 1.0 ) / size;\n		vec2 centroidUV = floor( uv * size + 0.5 ) / size;\n		float lb = texture2DCompare( depths, centroidUV + texelSize * offset.xx, compare );\n		float lt = texture2DCompare( depths, centroidUV + texelSize * offset.xy, compare );\n		float rb = texture2DCompare( depths, centroidUV + texelSize * offset.yx, compare );\n		float rt = texture2DCompare( depths, centroidUV + texelSize * offset.yy, compare );\n		vec2 f = fract( uv * size + 0.5 );\n		float a = mix( lb, lt, f.y );\n		float b = mix( rb, rt, f.y );\n		float c = mix( a, b, f.x );\n		return c;\n	}\n	float getShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n		shadowCoord.xyz /= shadowCoord.w;\n		shadowCoord.z += shadowBias;\n		bvec4 inFrustumVec = bvec4 ( shadowCoord.x >= 0.0, shadowCoord.x <= 1.0, shadowCoord.y >= 0.0, shadowCoord.y <= 1.0 );\n		bool inFrustum = all( inFrustumVec );\n		bvec2 frustumTestVec = bvec2( inFrustum, shadowCoord.z <= 1.0 );\n		bool frustumTest = all( frustumTestVec );\n		if ( frustumTest ) {\n		#if defined( SHADOWMAP_TYPE_PCF )\n			vec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n			float dx0 = - texelSize.x * shadowRadius;\n			float dy0 = - texelSize.y * shadowRadius;\n			float dx1 = + texelSize.x * shadowRadius;\n			float dy1 = + texelSize.y * shadowRadius;\n			return (\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n				texture2DCompare( shadowMap, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n			) * ( 1.0 / 9.0 );\n		#elif defined( SHADOWMAP_TYPE_PCF_SOFT )\n			vec2 texelSize = vec2( 1.0 ) / shadowMapSize;\n			float dx0 = - texelSize.x * shadowRadius;\n			float dy0 = - texelSize.y * shadowRadius;\n			float dx1 = + texelSize.x * shadowRadius;\n			float dy1 = + texelSize.y * shadowRadius;\n			return (\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, 0.0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy, shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, 0.0 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx0, dy1 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( 0.0, dy1 ), shadowCoord.z ) +\n				texture2DShadowLerp( shadowMap, shadowMapSize, shadowCoord.xy + vec2( dx1, dy1 ), shadowCoord.z )\n			) * ( 1.0 / 9.0 );\n		#else\n			return texture2DCompare( shadowMap, shadowCoord.xy, shadowCoord.z );\n		#endif\n		}\n		return 1.0;\n	}\n	vec2 cubeToUV( vec3 v, float texelSizeY ) {\n		vec3 absV = abs( v );\n		float scaleToCube = 1.0 / max( absV.x, max( absV.y, absV.z ) );\n		absV *= scaleToCube;\n		v *= scaleToCube * ( 1.0 - 2.0 * texelSizeY );\n		vec2 planar = v.xy;\n		float almostATexel = 1.5 * texelSizeY;\n		float almostOne = 1.0 - almostATexel;\n		if ( absV.z >= almostOne ) {\n			if ( v.z > 0.0 )\n				planar.x = 4.0 - v.x;\n		} else if ( absV.x >= almostOne ) {\n			float signX = sign( v.x );\n			planar.x = v.z * signX + 2.0 * signX;\n		} else if ( absV.y >= almostOne ) {\n			float signY = sign( v.y );\n			planar.x = v.x + 2.0 * signY + 2.0;\n			planar.y = v.z * signY - 2.0;\n		}\n		return vec2( 0.125, 0.25 ) * planar + vec2( 0.375, 0.75 );\n	}\n	float getPointShadow( sampler2D shadowMap, vec2 shadowMapSize, float shadowBias, float shadowRadius, vec4 shadowCoord ) {\n		vec2 texelSize = vec2( 1.0 ) / ( shadowMapSize * vec2( 4.0, 2.0 ) );\n		vec3 lightToPosition = shadowCoord.xyz;\n		vec3 bd3D = normalize( lightToPosition );\n		float dp = ( length( lightToPosition ) - shadowBias ) / 1000.0;\n		#if defined( SHADOWMAP_TYPE_PCF ) || defined( SHADOWMAP_TYPE_PCF_SOFT )\n			vec2 offset = vec2( - 1, 1 ) * shadowRadius * texelSize.y;\n			return (\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xyx, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yyx, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxy, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.xxx, texelSize.y ), dp ) +\n				texture2DCompare( shadowMap, cubeToUV( bd3D + offset.yxx, texelSize.y ), dp )\n			) * ( 1.0 / 9.0 );\n		#else\n			return texture2DCompare( shadowMap, cubeToUV( bd3D, texelSize.y ), dp );\n		#endif\n	}\n#endif\n",
THREE.ShaderChunk.shadowmap_pars_vertex="#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n		uniform mat4 directionalShadowMatrix[ NUM_DIR_LIGHTS ];\n		varying vec4 vDirectionalShadowCoord[ NUM_DIR_LIGHTS ];\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n		uniform mat4 spotShadowMatrix[ NUM_SPOT_LIGHTS ];\n		varying vec4 vSpotShadowCoord[ NUM_SPOT_LIGHTS ];\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n		uniform mat4 pointShadowMatrix[ NUM_POINT_LIGHTS ];\n		varying vec4 vPointShadowCoord[ NUM_POINT_LIGHTS ];\n	#endif\n#endif\n",THREE.ShaderChunk.shadowmap_vertex="#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		vDirectionalShadowCoord[ i ] = directionalShadowMatrix[ i ] * worldPosition;\n	}\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		vSpotShadowCoord[ i ] = spotShadowMatrix[ i ] * worldPosition;\n	}\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		vPointShadowCoord[ i ] = pointShadowMatrix[ i ] * worldPosition;\n	}\n	#endif\n#endif\n",THREE.ShaderChunk.shadowmask_pars_fragment="float getShadowMask() {\n	float shadow = 1.0;\n	#ifdef USE_SHADOWMAP\n	#if NUM_DIR_LIGHTS > 0\n	DirectionalLight directionalLight;\n	for ( int i = 0; i < NUM_DIR_LIGHTS; i ++ ) {\n		directionalLight = directionalLights[ i ];\n		shadow *= bool( directionalLight.shadow ) ? getShadow( directionalShadowMap[ i ], directionalLight.shadowMapSize, directionalLight.shadowBias, directionalLight.shadowRadius, vDirectionalShadowCoord[ i ] ) : 1.0;\n	}\n	#endif\n	#if NUM_SPOT_LIGHTS > 0\n	SpotLight spotLight;\n	for ( int i = 0; i < NUM_SPOT_LIGHTS; i ++ ) {\n		spotLight = spotLights[ i ];\n		shadow *= bool( spotLight.shadow ) ? getShadow( spotShadowMap[ i ], spotLight.shadowMapSize, spotLight.shadowBias, spotLight.shadowRadius, vSpotShadowCoord[ i ] ) : 1.0;\n	}\n	#endif\n	#if NUM_POINT_LIGHTS > 0\n	PointLight pointLight;\n	for ( int i = 0; i < NUM_POINT_LIGHTS; i ++ ) {\n		pointLight = pointLights[ i ];\n		shadow *= bool( pointLight.shadow ) ? getPointShadow( pointShadowMap[ i ], pointLight.shadowMapSize, pointLight.shadowBias, pointLight.shadowRadius, vPointShadowCoord[ i ] ) : 1.0;\n	}\n	#endif\n	#endif\n	return shadow;\n}\n",THREE.ShaderChunk.skinbase_vertex="#ifdef USE_SKINNING\n	mat4 boneMatX = getBoneMatrix( skinIndex.x );\n	mat4 boneMatY = getBoneMatrix( skinIndex.y );\n	mat4 boneMatZ = getBoneMatrix( skinIndex.z );\n	mat4 boneMatW = getBoneMatrix( skinIndex.w );\n#endif",THREE.ShaderChunk.skinning_pars_vertex="#ifdef USE_SKINNING\n	uniform mat4 bindMatrix;\n	uniform mat4 bindMatrixInverse;\n	#ifdef BONE_TEXTURE\n		uniform sampler2D boneTexture;\n		uniform int boneTextureWidth;\n		uniform int boneTextureHeight;\n		mat4 getBoneMatrix( const in float i ) {\n			float j = i * 4.0;\n			float x = mod( j, float( boneTextureWidth ) );\n			float y = floor( j / float( boneTextureWidth ) );\n			float dx = 1.0 / float( boneTextureWidth );\n			float dy = 1.0 / float( boneTextureHeight );\n			y = dy * ( y + 0.5 );\n			vec4 v1 = texture2D( boneTexture, vec2( dx * ( x + 0.5 ), y ) );\n			vec4 v2 = texture2D( boneTexture, vec2( dx * ( x + 1.5 ), y ) );\n			vec4 v3 = texture2D( boneTexture, vec2( dx * ( x + 2.5 ), y ) );\n			vec4 v4 = texture2D( boneTexture, vec2( dx * ( x + 3.5 ), y ) );\n			mat4 bone = mat4( v1, v2, v3, v4 );\n			return bone;\n		}\n	#else\n		uniform mat4 boneMatrices[ MAX_BONES ];\n		mat4 getBoneMatrix( const in float i ) {\n			mat4 bone = boneMatrices[ int(i) ];\n			return bone;\n		}\n	#endif\n#endif\n",THREE.ShaderChunk.skinning_vertex="#ifdef USE_SKINNING\n	vec4 skinVertex = bindMatrix * vec4( transformed, 1.0 );\n	vec4 skinned = vec4( 0.0 );\n	skinned += boneMatX * skinVertex * skinWeight.x;\n	skinned += boneMatY * skinVertex * skinWeight.y;\n	skinned += boneMatZ * skinVertex * skinWeight.z;\n	skinned += boneMatW * skinVertex * skinWeight.w;\n	skinned  = bindMatrixInverse * skinned;\n#endif\n",THREE.ShaderChunk.skinnormal_vertex="#ifdef USE_SKINNING\n	mat4 skinMatrix = mat4( 0.0 );\n	skinMatrix += skinWeight.x * boneMatX;\n	skinMatrix += skinWeight.y * boneMatY;\n	skinMatrix += skinWeight.z * boneMatZ;\n	skinMatrix += skinWeight.w * boneMatW;\n	skinMatrix  = bindMatrixInverse * skinMatrix * bindMatrix;\n	objectNormal = vec4( skinMatrix * vec4( objectNormal, 0.0 ) ).xyz;\n#endif\n",THREE.ShaderChunk.specularmap_fragment="float specularStrength;\n#ifdef USE_SPECULARMAP\n	vec4 texelSpecular = texture2D( specularMap, vUv );\n	specularStrength = texelSpecular.r;\n#else\n	specularStrength = 1.0;\n#endif",THREE.ShaderChunk.specularmap_pars_fragment="#ifdef USE_SPECULARMAP\n	uniform sampler2D specularMap;\n#endif",THREE.ShaderChunk.tonemapping_fragment="#if defined( TONE_MAPPING )\n  gl_FragColor.rgb = toneMapping( gl_FragColor.rgb );\n#endif\n",THREE.ShaderChunk.tonemapping_pars_fragment="#define saturate(a) clamp( a, 0.0, 1.0 )\nuniform float toneMappingExposure;\nuniform float toneMappingWhitePoint;\nvec3 LinearToneMapping( vec3 color ) {\n  return toneMappingExposure * color;\n}\nvec3 ReinhardToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( color / ( vec3( 1.0 ) + color ) );\n}\n#define Uncharted2Helper( x ) max( ( ( x * ( 0.15 * x + 0.10 * 0.50 ) + 0.20 * 0.02 ) / ( x * ( 0.15 * x + 0.50 ) + 0.20 * 0.30 ) ) - 0.02 / 0.30, vec3( 0.0 ) )\nvec3 Uncharted2ToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  return saturate( Uncharted2Helper( color ) / Uncharted2Helper( vec3( toneMappingWhitePoint ) ) );\n}\nvec3 OptimizedCineonToneMapping( vec3 color ) {\n  color *= toneMappingExposure;\n  color = max( vec3( 0.0 ), color - 0.004 );\n  return pow( ( color * ( 6.2 * color + 0.5 ) ) / ( color * ( 6.2 * color + 1.7 ) + 0.06 ), vec3( 2.2 ) );\n}\n",THREE.ShaderChunk.uv2_pars_fragment="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n	varying vec2 vUv2;\n#endif",THREE.ShaderChunk.uv2_pars_vertex="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n	attribute vec2 uv2;\n	varying vec2 vUv2;\n#endif",THREE.ShaderChunk.uv2_vertex="#if defined( USE_LIGHTMAP ) || defined( USE_AOMAP )\n	vUv2 = uv2;\n#endif",THREE.ShaderChunk.uv_pars_fragment="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n	varying vec2 vUv;\n#endif",THREE.ShaderChunk.uv_pars_vertex="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n	varying vec2 vUv;\n	uniform vec4 offsetRepeat;\n#endif\n",THREE.ShaderChunk.uv_vertex="#if defined( USE_MAP ) || defined( USE_BUMPMAP ) || defined( USE_NORMALMAP ) || defined( USE_SPECULARMAP ) || defined( USE_ALPHAMAP ) || defined( USE_EMISSIVEMAP ) || defined( USE_ROUGHNESSMAP ) || defined( USE_METALNESSMAP )\n	vUv = uv * offsetRepeat.zw + offsetRepeat.xy;\n#endif",THREE.ShaderChunk.worldpos_vertex="#if defined( USE_ENVMAP ) || defined( PHONG ) || defined( PHYSICAL ) || defined( LAMBERT ) || defined ( USE_SHADOWMAP )\n	#ifdef USE_SKINNING\n		vec4 worldPosition = modelMatrix * skinned;\n	#else\n		vec4 worldPosition = modelMatrix * vec4( transformed, 1.0 );\n	#endif\n#endif\n",THREE.UniformsUtils={merge:function(uniforms){for(var merged={},u=0;u<uniforms.length;u++){var tmp=this.clone(uniforms[u]);for(var p in tmp)merged[p]=tmp[p]}return merged},clone:function(uniforms_src){var uniforms_dst={};for(var u in uniforms_src){uniforms_dst[u]={};for(var p in uniforms_src[u]){var parameter_src=uniforms_src[u][p];parameter_src instanceof THREE.Color||parameter_src instanceof THREE.Vector2||parameter_src instanceof THREE.Vector3||parameter_src instanceof THREE.Vector4||parameter_src instanceof THREE.Matrix3||parameter_src instanceof THREE.Matrix4||parameter_src instanceof THREE.Texture?uniforms_dst[u][p]=parameter_src.clone():Array.isArray(parameter_src)?uniforms_dst[u][p]=parameter_src.slice():uniforms_dst[u][p]=parameter_src}}return uniforms_dst}},THREE.UniformsLib={common:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"1f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)},specularMap:{type:"t",value:null},alphaMap:{type:"t",value:null},envMap:{type:"t",value:null},flipEnvMap:{type:"1f",value:-1},reflectivity:{type:"1f",value:1},refractionRatio:{type:"1f",value:.98}},aomap:{aoMap:{type:"t",value:null},aoMapIntensity:{type:"1f",value:1}},lightmap:{lightMap:{type:"t",value:null},lightMapIntensity:{type:"1f",value:1}},emissivemap:{emissiveMap:{type:"t",value:null}},bumpmap:{bumpMap:{type:"t",value:null},bumpScale:{type:"1f",value:1}},normalmap:{normalMap:{type:"t",value:null},normalScale:{type:"v2",value:new THREE.Vector2(1,1)}},displacementmap:{displacementMap:{type:"t",value:null},displacementScale:{type:"1f",value:1},displacementBias:{type:"1f",value:0}},roughnessmap:{roughnessMap:{type:"t",value:null}},metalnessmap:{metalnessMap:{type:"t",value:null}},fog:{fogDensity:{type:"1f",value:25e-5},fogNear:{type:"1f",value:1},fogFar:{type:"1f",value:2e3},fogColor:{type:"c",value:new THREE.Color(16777215)}},lights:{ambientLightColor:{type:"3fv",value:[]},directionalLights:{type:"sa",value:[],properties:{direction:{type:"v3"},color:{type:"c"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},directionalShadowMap:{type:"tv",value:[]},directionalShadowMatrix:{type:"m4v",value:[]},spotLights:{type:"sa",value:[],properties:{color:{type:"c"},position:{type:"v3"},direction:{type:"v3"},distance:{type:"1f"},coneCos:{type:"1f"},penumbraCos:{type:"1f"},decay:{type:"1f"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},spotShadowMap:{type:"tv",value:[]},spotShadowMatrix:{type:"m4v",value:[]},pointLights:{type:"sa",value:[],properties:{color:{type:"c"},position:{type:"v3"},decay:{type:"1f"},distance:{type:"1f"},shadow:{type:"1i"},shadowBias:{type:"1f"},shadowRadius:{type:"1f"},shadowMapSize:{type:"v2"}}},pointShadowMap:{type:"tv",value:[]},pointShadowMatrix:{type:"m4v",value:[]},hemisphereLights:{type:"sa",value:[],properties:{direction:{type:"v3"},skyColor:{type:"c"},groundColor:{type:"c"}}}},points:{diffuse:{type:"c",value:new THREE.Color(15658734)},opacity:{type:"1f",value:1},size:{type:"1f",value:1},scale:{type:"1f",value:1},map:{type:"t",value:null},offsetRepeat:{type:"v4",value:new THREE.Vector4(0,0,1,1)}}},THREE.ShaderChunk.cube_frag="uniform samplerCube tCube;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	gl_FragColor = textureCube( tCube, vec3( tFlip * vWorldPosition.x, vWorldPosition.yz ) );\n	#include <logdepthbuf_fragment>\n}\n",THREE.ShaderChunk.cube_vert="varying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	vWorldPosition = transformDirection( position, modelMatrix );\n	#include <begin_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.depth_frag="#if DEPTH_PACKING == 3200\n	uniform float opacity;\n#endif\n#include <common>\n#include <packing>\n#include <uv_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( 1.0 );\n	#if DEPTH_PACKING == 3200\n		diffuseColor.a = opacity;\n	#endif\n	#include <map_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <logdepthbuf_fragment>\n	#if DEPTH_PACKING == 3200\n		gl_FragColor = vec4( vec3( gl_FragCoord.z ), opacity );\n	#elif DEPTH_PACKING == 3201\n		gl_FragColor = packDepthToRGBA( gl_FragCoord.z );\n	#endif\n}\n",THREE.ShaderChunk.depth_vert="#include <common>\n#include <uv_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <skinbase_vertex>\n	#include <begin_vertex>\n	#include <displacementmap_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.distanceRGBA_frag="uniform vec3 lightPos;\nvarying vec4 vWorldPosition;\n#include <common>\n#include <packing>\n#include <clipping_planes_pars_fragment>\nvoid main () {\n	#include <clipping_planes_fragment>\n	gl_FragColor = packDepthToRGBA( length( vWorldPosition.xyz - lightPos.xyz ) / 1000.0 );\n}\n",THREE.ShaderChunk.distanceRGBA_vert="varying vec4 vWorldPosition;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <skinbase_vertex>\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <worldpos_vertex>\n	#include <clipping_planes_vertex>\n	vWorldPosition = worldPosition;\n}\n",THREE.ShaderChunk.equirect_frag="uniform sampler2D tEquirect;\nuniform float tFlip;\nvarying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec3 direction = normalize( vWorldPosition );\n	vec2 sampleUV;\n	sampleUV.y = saturate( tFlip * direction.y * -0.5 + 0.5 );\n	sampleUV.x = atan( direction.z, direction.x ) * RECIPROCAL_PI2 + 0.5;\n	gl_FragColor = texture2D( tEquirect, sampleUV );\n	#include <logdepthbuf_fragment>\n}\n",THREE.ShaderChunk.equirect_vert="varying vec3 vWorldPosition;\n#include <common>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	vWorldPosition = transformDirection( position, modelMatrix );\n	#include <begin_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.linedashed_frag="uniform vec3 diffuse;\nuniform float opacity;\nuniform float dashSize;\nuniform float totalSize;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_fragment>\n#include <fog_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	if ( mod( vLineDistance, totalSize ) > dashSize ) {\n		discard;\n	}\n	vec3 outgoingLight = vec3( 0.0 );\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	#include <logdepthbuf_fragment>\n	#include <color_fragment>\n	outgoingLight = diffuseColor.rgb;\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.linedashed_vert="uniform float scale;\nattribute float lineDistance;\nvarying float vLineDistance;\n#include <common>\n#include <color_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <color_vertex>\n	vLineDistance = scale * lineDistance;\n	vec4 mvPosition = modelViewMatrix * vec4( position, 1.0 );\n	gl_Position = projectionMatrix * mvPosition;\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.meshbasic_frag="uniform vec3 diffuse;\nuniform float opacity;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	ReflectedLight reflectedLight;\n	reflectedLight.directDiffuse = vec3( 0.0 );\n	reflectedLight.directSpecular = vec3( 0.0 );\n	reflectedLight.indirectDiffuse = diffuseColor.rgb;\n	reflectedLight.indirectSpecular = vec3( 0.0 );\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.indirectDiffuse;\n	#include <envmap_fragment>\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshbasic_vert="#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <skinbase_vertex>\n	#ifdef USE_ENVMAP\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n	#endif\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <worldpos_vertex>\n	#include <clipping_planes_vertex>\n	#include <envmap_vertex>\n}\n",THREE.ShaderChunk.meshlambert_frag="uniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float opacity;\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n	varying vec3 vLightBack;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <shadowmask_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n	vec3 totalEmissiveRadiance = emissive;\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	#include <emissivemap_fragment>\n	reflectedLight.indirectDiffuse = getAmbientLightIrradiance( ambientLightColor );\n	#include <lightmap_fragment>\n	reflectedLight.indirectDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb );\n	#ifdef DOUBLE_SIDED\n		reflectedLight.directDiffuse = ( gl_FrontFacing ) ? vLightFront : vLightBack;\n	#else\n		reflectedLight.directDiffuse = vLightFront;\n	#endif\n	reflectedLight.directDiffuse *= BRDF_Diffuse_Lambert( diffuseColor.rgb ) * getShadowMask();\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + totalEmissiveRadiance;\n	#include <envmap_fragment>\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshlambert_vert="#define LAMBERT\nvarying vec3 vLightFront;\n#ifdef DOUBLE_SIDED\n	varying vec3 vLightBack;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <envmap_pars_vertex>\n#include <bsdfs>\n#include <lights_pars>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinbase_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	#include <worldpos_vertex>\n	#include <envmap_vertex>\n	#include <lights_lambert_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.meshphong_frag="#define PHONG\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform vec3 specular;\nuniform float shininess;\nuniform float opacity;\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <lights_pars>\n#include <lights_phong_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n	vec3 totalEmissiveRadiance = emissive;\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	#include <normal_fragment>\n	#include <emissivemap_fragment>\n	#include <lights_phong_fragment>\n	#include <lights_template>\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n	#include <envmap_fragment>\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshphong_vert="#define PHONG\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <envmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinbase_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n	vNormal = normalize( transformedNormal );\n#endif\n	#include <begin_vertex>\n	#include <displacementmap_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	vViewPosition = - mvPosition.xyz;\n	#include <worldpos_vertex>\n	#include <envmap_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.meshphysical_frag="#define PHYSICAL\nuniform vec3 diffuse;\nuniform vec3 emissive;\nuniform float roughness;\nuniform float metalness;\nuniform float opacity;\nuniform float envMapIntensity;\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <packing>\n#include <color_pars_fragment>\n#include <uv_pars_fragment>\n#include <uv2_pars_fragment>\n#include <map_pars_fragment>\n#include <alphamap_pars_fragment>\n#include <aomap_pars_fragment>\n#include <lightmap_pars_fragment>\n#include <emissivemap_pars_fragment>\n#include <envmap_pars_fragment>\n#include <fog_pars_fragment>\n#include <bsdfs>\n#include <cube_uv_reflection_fragment>\n#include <lights_pars>\n#include <lights_physical_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <bumpmap_pars_fragment>\n#include <normalmap_pars_fragment>\n#include <roughnessmap_pars_fragment>\n#include <metalnessmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	ReflectedLight reflectedLight = ReflectedLight( vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ), vec3( 0.0 ) );\n	vec3 totalEmissiveRadiance = emissive;\n	#include <logdepthbuf_fragment>\n	#include <map_fragment>\n	#include <color_fragment>\n	#include <alphamap_fragment>\n	#include <alphatest_fragment>\n	#include <specularmap_fragment>\n	#include <roughnessmap_fragment>\n	#include <metalnessmap_fragment>\n	#include <normal_fragment>\n	#include <emissivemap_fragment>\n	#include <lights_physical_fragment>\n	#include <lights_template>\n	#include <aomap_fragment>\n	vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveRadiance;\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.meshphysical_vert="#define PHYSICAL\nvarying vec3 vViewPosition;\n#ifndef FLAT_SHADED\n	varying vec3 vNormal;\n#endif\n#include <common>\n#include <uv_pars_vertex>\n#include <uv2_pars_vertex>\n#include <displacementmap_pars_vertex>\n#include <color_pars_vertex>\n#include <morphtarget_pars_vertex>\n#include <skinning_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <specularmap_pars_fragment>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <uv_vertex>\n	#include <uv2_vertex>\n	#include <color_vertex>\n	#include <beginnormal_vertex>\n	#include <morphnormal_vertex>\n	#include <skinbase_vertex>\n	#include <skinnormal_vertex>\n	#include <defaultnormal_vertex>\n#ifndef FLAT_SHADED\n	vNormal = normalize( transformedNormal );\n#endif\n	#include <begin_vertex>\n	#include <displacementmap_vertex>\n	#include <morphtarget_vertex>\n	#include <skinning_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	vViewPosition = - mvPosition.xyz;\n	#include <worldpos_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderChunk.normal_frag="uniform float opacity;\nvarying vec3 vNormal;\n#include <common>\n#include <packing>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	gl_FragColor = vec4( packNormalToRGB( vNormal ), opacity );\n	#include <logdepthbuf_fragment>\n}\n",THREE.ShaderChunk.normal_vert="varying vec3 vNormal;\n#include <common>\n#include <morphtarget_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	vNormal = normalize( normalMatrix * normal );\n	#include <begin_vertex>\n	#include <morphtarget_vertex>\n	#include <project_vertex>\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n}\n",THREE.ShaderChunk.points_frag="uniform vec3 diffuse;\nuniform float opacity;\n#include <common>\n#include <color_pars_fragment>\n#include <map_particle_pars_fragment>\n#include <fog_pars_fragment>\n#include <shadowmap_pars_fragment>\n#include <logdepthbuf_pars_fragment>\n#include <clipping_planes_pars_fragment>\nvoid main() {\n	#include <clipping_planes_fragment>\n	vec3 outgoingLight = vec3( 0.0 );\n	vec4 diffuseColor = vec4( diffuse, opacity );\n	#include <logdepthbuf_fragment>\n	#include <map_particle_fragment>\n	#include <color_fragment>\n	#include <alphatest_fragment>\n	outgoingLight = diffuseColor.rgb;\n	gl_FragColor = vec4( outgoingLight, diffuseColor.a );\n	#include <premultiplied_alpha_fragment>\n	#include <tonemapping_fragment>\n	#include <encodings_fragment>\n	#include <fog_fragment>\n}\n",THREE.ShaderChunk.points_vert="uniform float size;\nuniform float scale;\n#include <common>\n#include <color_pars_vertex>\n#include <shadowmap_pars_vertex>\n#include <logdepthbuf_pars_vertex>\n#include <clipping_planes_pars_vertex>\nvoid main() {\n	#include <color_vertex>\n	#include <begin_vertex>\n	#include <project_vertex>\n	#ifdef USE_SIZEATTENUATION\n		gl_PointSize = size * ( scale / - mvPosition.z );\n	#else\n		gl_PointSize = size;\n	#endif\n	#include <logdepthbuf_vertex>\n	#include <clipping_planes_vertex>\n	#include <worldpos_vertex>\n	#include <shadowmap_vertex>\n}\n",THREE.ShaderLib={basic:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.fog]),vertexShader:THREE.ShaderChunk.meshbasic_vert,fragmentShader:THREE.ShaderChunk.meshbasic_frag},lambert:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)}}]),vertexShader:THREE.ShaderChunk.meshlambert_vert,fragmentShader:THREE.ShaderChunk.meshlambert_frag},phong:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.bumpmap,THREE.UniformsLib.normalmap,THREE.UniformsLib.displacementmap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)},specular:{type:"c",value:new THREE.Color(1118481)},shininess:{type:"1f",value:30}}]),vertexShader:THREE.ShaderChunk.meshphong_vert,fragmentShader:THREE.ShaderChunk.meshphong_frag},standard:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.aomap,THREE.UniformsLib.lightmap,THREE.UniformsLib.emissivemap,THREE.UniformsLib.bumpmap,THREE.UniformsLib.normalmap,THREE.UniformsLib.displacementmap,THREE.UniformsLib.roughnessmap,THREE.UniformsLib.metalnessmap,THREE.UniformsLib.fog,THREE.UniformsLib.lights,{emissive:{type:"c",value:new THREE.Color(0)},roughness:{type:"1f",value:.5},metalness:{type:"1f",value:0},envMapIntensity:{type:"1f",value:1}}]),vertexShader:THREE.ShaderChunk.meshphysical_vert,fragmentShader:THREE.ShaderChunk.meshphysical_frag},points:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.points,THREE.UniformsLib.fog]),vertexShader:THREE.ShaderChunk.points_vert,fragmentShader:THREE.ShaderChunk.points_frag},dashed:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.fog,{scale:{type:"1f",value:1},dashSize:{type:"1f",value:1},totalSize:{type:"1f",value:2}}]),vertexShader:THREE.ShaderChunk.linedashed_vert,fragmentShader:THREE.ShaderChunk.linedashed_frag},depth:{uniforms:THREE.UniformsUtils.merge([THREE.UniformsLib.common,THREE.UniformsLib.displacementmap]),vertexShader:THREE.ShaderChunk.depth_vert,fragmentShader:THREE.ShaderChunk.depth_frag},normal:{uniforms:{opacity:{type:"1f",value:1}},vertexShader:THREE.ShaderChunk.normal_vert,fragmentShader:THREE.ShaderChunk.normal_frag},cube:{uniforms:{tCube:{type:"t",value:null},tFlip:{type:"1f",value:-1}},vertexShader:THREE.ShaderChunk.cube_vert,fragmentShader:THREE.ShaderChunk.cube_frag},equirect:{uniforms:{tEquirect:{type:"t",value:null},tFlip:{type:"1f",
value:-1}},vertexShader:THREE.ShaderChunk.equirect_vert,fragmentShader:THREE.ShaderChunk.equirect_frag},distanceRGBA:{uniforms:{lightPos:{type:"v3",value:new THREE.Vector3}},vertexShader:THREE.ShaderChunk.distanceRGBA_vert,fragmentShader:THREE.ShaderChunk.distanceRGBA_frag}},THREE.ShaderLib.physical={uniforms:THREE.UniformsUtils.merge([THREE.ShaderLib.standard.uniforms,{}]),vertexShader:THREE.ShaderChunk.meshphysical_vert,fragmentShader:THREE.ShaderChunk.meshphysical_frag},THREE.WebGLRenderer=function(parameters){function getTargetPixelRatio(){return null===_currentRenderTarget?_pixelRatio:1}function glClearColor(r,g,b,a){_premultipliedAlpha===!0&&(r*=a,g*=a,b*=a),state.clearColor(r,g,b,a)}function setDefaultGLState(){state.init(),state.scissor(_currentScissor.copy(_scissor).multiplyScalar(_pixelRatio)),state.viewport(_currentViewport.copy(_viewport).multiplyScalar(_pixelRatio)),glClearColor(_clearColor.r,_clearColor.g,_clearColor.b,_clearAlpha)}function resetGLState(){_currentProgram=null,_currentCamera=null,_currentGeometryProgram="",_currentMaterialId=-1,state.reset()}function onContextLost(event){event.preventDefault(),resetGLState(),setDefaultGLState(),properties.clear()}function onTextureDispose(event){var texture=event.target;texture.removeEventListener("dispose",onTextureDispose),deallocateTexture(texture),_infoMemory.textures--}function onRenderTargetDispose(event){var renderTarget=event.target;renderTarget.removeEventListener("dispose",onRenderTargetDispose),deallocateRenderTarget(renderTarget),_infoMemory.textures--}function onMaterialDispose(event){var material=event.target;material.removeEventListener("dispose",onMaterialDispose),deallocateMaterial(material)}function deallocateTexture(texture){var textureProperties=properties.get(texture);if(texture.image&&textureProperties.__image__webglTextureCube)_gl.deleteTexture(textureProperties.__image__webglTextureCube);else{if(void 0===textureProperties.__webglInit)return;_gl.deleteTexture(textureProperties.__webglTexture)}properties["delete"](texture)}function deallocateRenderTarget(renderTarget){var renderTargetProperties=properties.get(renderTarget),textureProperties=properties.get(renderTarget.texture);if(renderTarget){if(void 0!==textureProperties.__webglTexture&&_gl.deleteTexture(textureProperties.__webglTexture),renderTarget.depthTexture&&renderTarget.depthTexture.dispose(),renderTarget instanceof THREE.WebGLRenderTargetCube)for(var i=0;6>i;i++)_gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer[i]),renderTargetProperties.__webglDepthbuffer&&_gl.deleteRenderbuffer(renderTargetProperties.__webglDepthbuffer[i]);else _gl.deleteFramebuffer(renderTargetProperties.__webglFramebuffer),renderTargetProperties.__webglDepthbuffer&&_gl.deleteRenderbuffer(renderTargetProperties.__webglDepthbuffer);properties["delete"](renderTarget.texture),properties["delete"](renderTarget)}}function deallocateMaterial(material){releaseMaterialProgramReference(material),properties["delete"](material)}function releaseMaterialProgramReference(material){var programInfo=properties.get(material).program;material.program=void 0,void 0!==programInfo&&programCache.releaseProgram(programInfo)}function setupVertexAttributes(material,program,geometry,startIndex){var extension;if(geometry instanceof THREE.InstancedBufferGeometry&&(extension=extensions.get("ANGLE_instanced_arrays"),null===extension))return void console.error("THREE.WebGLRenderer.setupVertexAttributes: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");void 0===startIndex&&(startIndex=0),state.initAttributes();var geometryAttributes=geometry.attributes,programAttributes=program.getAttributes(),materialDefaultAttributeValues=material.defaultAttributeValues;for(var name in programAttributes){var programAttribute=programAttributes[name];if(programAttribute>=0){var geometryAttribute=geometryAttributes[name];if(void 0!==geometryAttribute){var type=_gl.FLOAT,array=geometryAttribute.array,normalized=geometryAttribute.normalized;array instanceof Float32Array?type=_gl.FLOAT:array instanceof Float64Array?console.warn("Unsupported data buffer format: Float64Array"):array instanceof Uint16Array?type=_gl.UNSIGNED_SHORT:array instanceof Int16Array?type=_gl.SHORT:array instanceof Uint32Array?type=_gl.UNSIGNED_INT:array instanceof Int32Array?type=_gl.INT:array instanceof Int8Array?type=_gl.BYTE:array instanceof Uint8Array&&(type=_gl.UNSIGNED_BYTE);var size=geometryAttribute.itemSize,buffer=objects.getAttributeBuffer(geometryAttribute);if(geometryAttribute instanceof THREE.InterleavedBufferAttribute){var data=geometryAttribute.data,stride=data.stride,offset=geometryAttribute.offset;data instanceof THREE.InstancedInterleavedBuffer?(state.enableAttributeAndDivisor(programAttribute,data.meshPerAttribute,extension),void 0===geometry.maxInstancedCount&&(geometry.maxInstancedCount=data.meshPerAttribute*data.count)):state.enableAttribute(programAttribute),_gl.bindBuffer(_gl.ARRAY_BUFFER,buffer),_gl.vertexAttribPointer(programAttribute,size,type,normalized,stride*data.array.BYTES_PER_ELEMENT,(startIndex*stride+offset)*data.array.BYTES_PER_ELEMENT)}else geometryAttribute instanceof THREE.InstancedBufferAttribute?(state.enableAttributeAndDivisor(programAttribute,geometryAttribute.meshPerAttribute,extension),void 0===geometry.maxInstancedCount&&(geometry.maxInstancedCount=geometryAttribute.meshPerAttribute*geometryAttribute.count)):state.enableAttribute(programAttribute),_gl.bindBuffer(_gl.ARRAY_BUFFER,buffer),_gl.vertexAttribPointer(programAttribute,size,type,normalized,0,startIndex*size*geometryAttribute.array.BYTES_PER_ELEMENT)}else if(void 0!==materialDefaultAttributeValues){var value=materialDefaultAttributeValues[name];if(void 0!==value)switch(value.length){case 2:_gl.vertexAttrib2fv(programAttribute,value);break;case 3:_gl.vertexAttrib3fv(programAttribute,value);break;case 4:_gl.vertexAttrib4fv(programAttribute,value);break;default:_gl.vertexAttrib1fv(programAttribute,value)}}}}state.disableUnusedAttributes()}function absNumericalSort(a,b){return Math.abs(b[0])-Math.abs(a[0])}function painterSortStable(a,b){return a.object.renderOrder!==b.object.renderOrder?a.object.renderOrder-b.object.renderOrder:a.material.id!==b.material.id?a.material.id-b.material.id:a.z!==b.z?a.z-b.z:a.id-b.id}function reversePainterSortStable(a,b){return a.object.renderOrder!==b.object.renderOrder?a.object.renderOrder-b.object.renderOrder:a.z!==b.z?b.z-a.z:a.id-b.id}function pushRenderItem(object,geometry,material,z,group){var array,index;material.transparent?(array=transparentObjects,index=++transparentObjectsLastIndex):(array=opaqueObjects,index=++opaqueObjectsLastIndex);var renderItem=array[index];void 0!==renderItem?(renderItem.id=object.id,renderItem.object=object,renderItem.geometry=geometry,renderItem.material=material,renderItem.z=_vector3.z,renderItem.group=group):(renderItem={id:object.id,object:object,geometry:geometry,material:material,z:_vector3.z,group:group},array.push(renderItem))}function isObjectViewable(object){var geometry=object.geometry;null===geometry.boundingSphere&&geometry.computeBoundingSphere();var sphere=_sphere.copy(geometry.boundingSphere).applyMatrix4(object.matrixWorld);if(!_frustum.intersectsSphere(sphere))return!1;if(0===_numClippingPlanes)return!0;var planes=_this.clippingPlanes,center=sphere.center,negRad=-sphere.radius,i=0;do if(planes[i].distanceToPoint(center)<negRad)return!1;while(++i!==_numClippingPlanes);return!0}function projectObject(object,camera){if(object.visible!==!1){if(object.layers.test(camera.layers))if(object instanceof THREE.Light)lights.push(object);else if(object instanceof THREE.Sprite)object.frustumCulled!==!1&&isObjectViewable(object)!==!0||sprites.push(object);else if(object instanceof THREE.LensFlare)lensFlares.push(object);else if(object instanceof THREE.ImmediateRenderObject)_this.sortObjects===!0&&(_vector3.setFromMatrixPosition(object.matrixWorld),_vector3.applyProjection(_projScreenMatrix)),pushRenderItem(object,null,object.material,_vector3.z,null);else if((object instanceof THREE.Mesh||object instanceof THREE.Line||object instanceof THREE.Points)&&(object instanceof THREE.SkinnedMesh&&object.skeleton.update(),object.frustumCulled===!1||isObjectViewable(object)===!0)){var material=object.material;if(material.visible===!0){_this.sortObjects===!0&&(_vector3.setFromMatrixPosition(object.matrixWorld),_vector3.applyProjection(_projScreenMatrix));var geometry=objects.update(object);if(material instanceof THREE.MultiMaterial)for(var groups=geometry.groups,materials=material.materials,i=0,l=groups.length;l>i;i++){var group=groups[i],groupMaterial=materials[group.materialIndex];groupMaterial.visible===!0&&pushRenderItem(object,geometry,groupMaterial,_vector3.z,group)}else pushRenderItem(object,geometry,material,_vector3.z,null)}}for(var children=object.children,i=0,l=children.length;l>i;i++)projectObject(children[i],camera)}}function renderObjects(renderList,camera,fog,overrideMaterial){for(var i=0,l=renderList.length;l>i;i++){var renderItem=renderList[i],object=renderItem.object,geometry=renderItem.geometry,material=void 0===overrideMaterial?renderItem.material:overrideMaterial,group=renderItem.group;if(object.modelViewMatrix.multiplyMatrices(camera.matrixWorldInverse,object.matrixWorld),object.normalMatrix.getNormalMatrix(object.modelViewMatrix),object instanceof THREE.ImmediateRenderObject){setMaterial(material);var program=setProgram(camera,fog,material,object);_currentGeometryProgram="",object.render(function(object){_this.renderBufferImmediate(object,program,material)})}else _this.renderBufferDirect(camera,fog,geometry,material,object,group)}}function initMaterial(material,fog,object){var materialProperties=properties.get(material),parameters=programCache.getParameters(material,_lights,fog,_numClippingPlanes,object),code=programCache.getProgramCode(material,parameters),program=materialProperties.program,programChange=!0;if(void 0===program)material.addEventListener("dispose",onMaterialDispose);else if(program.code!==code)releaseMaterialProgramReference(material);else{if(void 0!==parameters.shaderID)return;programChange=!1}if(programChange){if(parameters.shaderID){var shader=THREE.ShaderLib[parameters.shaderID];materialProperties.__webglShader={name:material.type,uniforms:THREE.UniformsUtils.clone(shader.uniforms),vertexShader:shader.vertexShader,fragmentShader:shader.fragmentShader}}else materialProperties.__webglShader={name:material.type,uniforms:material.uniforms,vertexShader:material.vertexShader,fragmentShader:material.fragmentShader};material.__webglShader=materialProperties.__webglShader,program=programCache.acquireProgram(material,parameters,code),materialProperties.program=program,material.program=program}var attributes=program.getAttributes();if(material.morphTargets){material.numSupportedMorphTargets=0;for(var i=0;i<_this.maxMorphTargets;i++)attributes["morphTarget"+i]>=0&&material.numSupportedMorphTargets++}if(material.morphNormals){material.numSupportedMorphNormals=0;for(var i=0;i<_this.maxMorphNormals;i++)attributes["morphNormal"+i]>=0&&material.numSupportedMorphNormals++}var uniforms=materialProperties.__webglShader.uniforms;(material instanceof THREE.ShaderMaterial||material instanceof THREE.RawShaderMaterial)&&material.clipping!==!0||(materialProperties.numClippingPlanes=_numClippingPlanes,uniforms.clippingPlanes=_clippingPlanesUniform),(material instanceof THREE.MeshPhongMaterial||material instanceof THREE.MeshLambertMaterial||material instanceof THREE.MeshStandardMaterial||material.lights)&&(materialProperties.lightsHash=_lights.hash,uniforms.ambientLightColor.value=_lights.ambient,uniforms.directionalLights.value=_lights.directional,uniforms.spotLights.value=_lights.spot,uniforms.pointLights.value=_lights.point,uniforms.hemisphereLights.value=_lights.hemi,uniforms.directionalShadowMap.value=_lights.directionalShadowMap,uniforms.directionalShadowMatrix.value=_lights.directionalShadowMatrix,uniforms.spotShadowMap.value=_lights.spotShadowMap,uniforms.spotShadowMatrix.value=_lights.spotShadowMatrix,uniforms.pointShadowMap.value=_lights.pointShadowMap,uniforms.pointShadowMatrix.value=_lights.pointShadowMatrix);var progUniforms=materialProperties.program.getUniforms(),uniformsList=THREE.WebGLUniforms.seqWithValue(progUniforms.seq,uniforms);materialProperties.uniformsList=uniformsList,materialProperties.dynamicUniforms=THREE.WebGLUniforms.splitDynamic(uniformsList,uniforms)}function setMaterial(material){setMaterialFaces(material),material.transparent===!0?state.setBlending(material.blending,material.blendEquation,material.blendSrc,material.blendDst,material.blendEquationAlpha,material.blendSrcAlpha,material.blendDstAlpha,material.premultipliedAlpha):state.setBlending(THREE.NoBlending),state.setDepthFunc(material.depthFunc),state.setDepthTest(material.depthTest),state.setDepthWrite(material.depthWrite),state.setColorWrite(material.colorWrite),state.setPolygonOffset(material.polygonOffset,material.polygonOffsetFactor,material.polygonOffsetUnits)}function setMaterialFaces(material){material.side!==THREE.DoubleSide?state.enable(_gl.CULL_FACE):state.disable(_gl.CULL_FACE),state.setFlipSided(material.side===THREE.BackSide)}function setProgram(camera,fog,material,object){_usedTextureUnits=0;var materialProperties=properties.get(material);if(_clippingEnabled){if(_localClippingEnabled||camera!==_currentCamera){var useCache=camera===_currentCamera&&material.id===_currentMaterialId;setClippingState(material.clippingPlanes,material.clipShadows,camera,materialProperties,useCache)}void 0!==materialProperties.numClippingPlanes&&materialProperties.numClippingPlanes!==_numClippingPlanes&&(material.needsUpdate=!0)}void 0===materialProperties.program&&(material.needsUpdate=!0),void 0!==materialProperties.lightsHash&&materialProperties.lightsHash!==_lights.hash&&(material.needsUpdate=!0),material.needsUpdate&&(initMaterial(material,fog,object),material.needsUpdate=!1);var refreshProgram=!1,refreshMaterial=!1,refreshLights=!1,program=materialProperties.program,p_uniforms=program.getUniforms(),m_uniforms=materialProperties.__webglShader.uniforms;if(program.id!==_currentProgram&&(_gl.useProgram(program.program),_currentProgram=program.id,refreshProgram=!0,refreshMaterial=!0,refreshLights=!0),material.id!==_currentMaterialId&&(_currentMaterialId=material.id,refreshMaterial=!0),refreshProgram||camera!==_currentCamera){if(p_uniforms.set(_gl,camera,"projectionMatrix"),capabilities.logarithmicDepthBuffer&&p_uniforms.setValue(_gl,"logDepthBufFC",2/(Math.log(camera.far+1)/Math.LN2)),camera!==_currentCamera&&(_currentCamera=camera,refreshMaterial=!0,refreshLights=!0),material instanceof THREE.ShaderMaterial||material instanceof THREE.MeshPhongMaterial||material instanceof THREE.MeshStandardMaterial||material.envMap){var uCamPos=p_uniforms.map.cameraPosition;void 0!==uCamPos&&uCamPos.setValue(_gl,_vector3.setFromMatrixPosition(camera.matrixWorld))}(material instanceof THREE.MeshPhongMaterial||material instanceof THREE.MeshLambertMaterial||material instanceof THREE.MeshBasicMaterial||material instanceof THREE.MeshStandardMaterial||material instanceof THREE.ShaderMaterial||material.skinning)&&p_uniforms.setValue(_gl,"viewMatrix",camera.matrixWorldInverse),p_uniforms.set(_gl,_this,"toneMappingExposure"),p_uniforms.set(_gl,_this,"toneMappingWhitePoint")}if(material.skinning){p_uniforms.setOptional(_gl,object,"bindMatrix"),p_uniforms.setOptional(_gl,object,"bindMatrixInverse");var skeleton=object.skeleton;skeleton&&(capabilities.floatVertexTextures&&skeleton.useVertexTexture?(p_uniforms.set(_gl,skeleton,"boneTexture"),p_uniforms.set(_gl,skeleton,"boneTextureWidth"),p_uniforms.set(_gl,skeleton,"boneTextureHeight")):p_uniforms.setOptional(_gl,skeleton,"boneMatrices"))}refreshMaterial&&((material instanceof THREE.MeshPhongMaterial||material instanceof THREE.MeshLambertMaterial||material instanceof THREE.MeshStandardMaterial||material.lights)&&markUniformsLightsNeedsUpdate(m_uniforms,refreshLights),fog&&material.fog&&refreshUniformsFog(m_uniforms,fog),(material instanceof THREE.MeshBasicMaterial||material instanceof THREE.MeshLambertMaterial||material instanceof THREE.MeshPhongMaterial||material instanceof THREE.MeshStandardMaterial||material instanceof THREE.MeshDepthMaterial)&&refreshUniformsCommon(m_uniforms,material),material instanceof THREE.LineBasicMaterial?refreshUniformsLine(m_uniforms,material):material instanceof THREE.LineDashedMaterial?(refreshUniformsLine(m_uniforms,material),refreshUniformsDash(m_uniforms,material)):material instanceof THREE.PointsMaterial?refreshUniformsPoints(m_uniforms,material):material instanceof THREE.MeshLambertMaterial?refreshUniformsLambert(m_uniforms,material):material instanceof THREE.MeshPhongMaterial?refreshUniformsPhong(m_uniforms,material):material instanceof THREE.MeshPhysicalMaterial?refreshUniformsPhysical(m_uniforms,material):material instanceof THREE.MeshStandardMaterial?refreshUniformsStandard(m_uniforms,material):material instanceof THREE.MeshDepthMaterial?material.displacementMap&&(m_uniforms.displacementMap.value=material.displacementMap,m_uniforms.displacementScale.value=material.displacementScale,m_uniforms.displacementBias.value=material.displacementBias):material instanceof THREE.MeshNormalMaterial&&(m_uniforms.opacity.value=material.opacity),THREE.WebGLUniforms.upload(_gl,materialProperties.uniformsList,m_uniforms,_this)),p_uniforms.set(_gl,object,"modelViewMatrix"),p_uniforms.set(_gl,object,"normalMatrix"),p_uniforms.setValue(_gl,"modelMatrix",object.matrixWorld);var dynUniforms=materialProperties.dynamicUniforms;return null!==dynUniforms&&(THREE.WebGLUniforms.evalDynamic(dynUniforms,m_uniforms,object,camera),THREE.WebGLUniforms.upload(_gl,dynUniforms,m_uniforms,_this)),program}function refreshUniformsCommon(uniforms,material){uniforms.opacity.value=material.opacity,uniforms.diffuse.value=material.color,material.emissive&&uniforms.emissive.value.copy(material.emissive).multiplyScalar(material.emissiveIntensity),uniforms.map.value=material.map,uniforms.specularMap.value=material.specularMap,uniforms.alphaMap.value=material.alphaMap,material.aoMap&&(uniforms.aoMap.value=material.aoMap,uniforms.aoMapIntensity.value=material.aoMapIntensity);var uvScaleMap;if(material.map?uvScaleMap=material.map:material.specularMap?uvScaleMap=material.specularMap:material.displacementMap?uvScaleMap=material.displacementMap:material.normalMap?uvScaleMap=material.normalMap:material.bumpMap?uvScaleMap=material.bumpMap:material.roughnessMap?uvScaleMap=material.roughnessMap:material.metalnessMap?uvScaleMap=material.metalnessMap:material.alphaMap?uvScaleMap=material.alphaMap:material.emissiveMap&&(uvScaleMap=material.emissiveMap),void 0!==uvScaleMap){uvScaleMap instanceof THREE.WebGLRenderTarget&&(uvScaleMap=uvScaleMap.texture);var offset=uvScaleMap.offset,repeat=uvScaleMap.repeat;uniforms.offsetRepeat.value.set(offset.x,offset.y,repeat.x,repeat.y)}uniforms.envMap.value=material.envMap,uniforms.flipEnvMap.value=material.envMap instanceof THREE.WebGLRenderTargetCube?1:-1,uniforms.reflectivity.value=material.reflectivity,uniforms.refractionRatio.value=material.refractionRatio}function refreshUniformsLine(uniforms,material){uniforms.diffuse.value=material.color,uniforms.opacity.value=material.opacity}function refreshUniformsDash(uniforms,material){uniforms.dashSize.value=material.dashSize,uniforms.totalSize.value=material.dashSize+material.gapSize,uniforms.scale.value=material.scale}function refreshUniformsPoints(uniforms,material){if(uniforms.diffuse.value=material.color,uniforms.opacity.value=material.opacity,uniforms.size.value=material.size*_pixelRatio,uniforms.scale.value=.5*_canvas.clientHeight,uniforms.map.value=material.map,null!==material.map){var offset=material.map.offset,repeat=material.map.repeat;uniforms.offsetRepeat.value.set(offset.x,offset.y,repeat.x,repeat.y)}}function refreshUniformsFog(uniforms,fog){uniforms.fogColor.value=fog.color,fog instanceof THREE.Fog?(uniforms.fogNear.value=fog.near,uniforms.fogFar.value=fog.far):fog instanceof THREE.FogExp2&&(uniforms.fogDensity.value=fog.density)}function refreshUniformsLambert(uniforms,material){material.lightMap&&(uniforms.lightMap.value=material.lightMap,uniforms.lightMapIntensity.value=material.lightMapIntensity),material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap)}function refreshUniformsPhong(uniforms,material){uniforms.specular.value=material.specular,uniforms.shininess.value=Math.max(material.shininess,1e-4),material.lightMap&&(uniforms.lightMap.value=material.lightMap,uniforms.lightMapIntensity.value=material.lightMapIntensity),material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap),material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale),material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale)),material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias)}function refreshUniformsStandard(uniforms,material){uniforms.roughness.value=material.roughness,uniforms.metalness.value=material.metalness,material.roughnessMap&&(uniforms.roughnessMap.value=material.roughnessMap),material.metalnessMap&&(uniforms.metalnessMap.value=material.metalnessMap),material.lightMap&&(uniforms.lightMap.value=material.lightMap,uniforms.lightMapIntensity.value=material.lightMapIntensity),material.emissiveMap&&(uniforms.emissiveMap.value=material.emissiveMap),material.bumpMap&&(uniforms.bumpMap.value=material.bumpMap,uniforms.bumpScale.value=material.bumpScale),material.normalMap&&(uniforms.normalMap.value=material.normalMap,uniforms.normalScale.value.copy(material.normalScale)),material.displacementMap&&(uniforms.displacementMap.value=material.displacementMap,uniforms.displacementScale.value=material.displacementScale,uniforms.displacementBias.value=material.displacementBias),material.envMap&&(uniforms.envMapIntensity.value=material.envMapIntensity)}function refreshUniformsPhysical(uniforms,material){refreshUniformsStandard(uniforms,material)}function markUniformsLightsNeedsUpdate(uniforms,value){uniforms.ambientLightColor.needsUpdate=value,uniforms.directionalLights.needsUpdate=value,uniforms.pointLights.needsUpdate=value,uniforms.spotLights.needsUpdate=value,uniforms.hemisphereLights.needsUpdate=value}function setupShadows(lights){for(var lightShadowsLength=0,i=0,l=lights.length;l>i;i++){var light=lights[i];light.castShadow&&(_lights.shadows[lightShadowsLength++]=light)}_lights.shadows.length=lightShadowsLength}function setupLights(lights,camera){var l,ll,light,color,intensity,distance,r=0,g=0,b=0,viewMatrix=camera.matrixWorldInverse,directionalLength=0,pointLength=0,spotLength=0,hemiLength=0;for(l=0,ll=lights.length;ll>l;l++)if(light=lights[l],color=light.color,intensity=light.intensity,distance=light.distance,light instanceof THREE.AmbientLight)r+=color.r*intensity,g+=color.g*intensity,b+=color.b*intensity;else if(light instanceof THREE.DirectionalLight){var uniforms=lightCache.get(light);uniforms.color.copy(light.color).multiplyScalar(light.intensity),uniforms.direction.setFromMatrixPosition(light.matrixWorld),_vector3.setFromMatrixPosition(light.target.matrixWorld),uniforms.direction.sub(_vector3),uniforms.direction.transformDirection(viewMatrix),uniforms.shadow=light.castShadow,light.castShadow&&(uniforms.shadowBias=light.shadow.bias,uniforms.shadowRadius=light.shadow.radius,uniforms.shadowMapSize=light.shadow.mapSize),_lights.directionalShadowMap[directionalLength]=light.shadow.map,_lights.directionalShadowMatrix[directionalLength]=light.shadow.matrix,_lights.directional[directionalLength++]=uniforms}else if(light instanceof THREE.SpotLight){var uniforms=lightCache.get(light);uniforms.position.setFromMatrixPosition(light.matrixWorld),uniforms.position.applyMatrix4(viewMatrix),uniforms.color.copy(color).multiplyScalar(intensity),uniforms.distance=distance,uniforms.direction.setFromMatrixPosition(light.matrixWorld),_vector3.setFromMatrixPosition(light.target.matrixWorld),uniforms.direction.sub(_vector3),uniforms.direction.transformDirection(viewMatrix),uniforms.coneCos=Math.cos(light.angle),uniforms.penumbraCos=Math.cos(light.angle*(1-light.penumbra)),uniforms.decay=0===light.distance?0:light.decay,uniforms.shadow=light.castShadow,light.castShadow&&(uniforms.shadowBias=light.shadow.bias,uniforms.shadowRadius=light.shadow.radius,uniforms.shadowMapSize=light.shadow.mapSize),_lights.spotShadowMap[spotLength]=light.shadow.map,_lights.spotShadowMatrix[spotLength]=light.shadow.matrix,_lights.spot[spotLength++]=uniforms}else if(light instanceof THREE.PointLight){var uniforms=lightCache.get(light);uniforms.position.setFromMatrixPosition(light.matrixWorld),uniforms.position.applyMatrix4(viewMatrix),uniforms.color.copy(light.color).multiplyScalar(light.intensity),uniforms.distance=light.distance,uniforms.decay=0===light.distance?0:light.decay,uniforms.shadow=light.castShadow,light.castShadow&&(uniforms.shadowBias=light.shadow.bias,uniforms.shadowRadius=light.shadow.radius,uniforms.shadowMapSize=light.shadow.mapSize),_lights.pointShadowMap[pointLength]=light.shadow.map,void 0===_lights.pointShadowMatrix[pointLength]&&(_lights.pointShadowMatrix[pointLength]=new THREE.Matrix4),_vector3.setFromMatrixPosition(light.matrixWorld).negate(),_lights.pointShadowMatrix[pointLength].identity().setPosition(_vector3),_lights.point[pointLength++]=uniforms}else if(light instanceof THREE.HemisphereLight){var uniforms=lightCache.get(light);uniforms.direction.setFromMatrixPosition(light.matrixWorld),uniforms.direction.transformDirection(viewMatrix),uniforms.direction.normalize(),uniforms.skyColor.copy(light.color).multiplyScalar(intensity),uniforms.groundColor.copy(light.groundColor).multiplyScalar(intensity),_lights.hemi[hemiLength++]=uniforms}_lights.ambient[0]=r,_lights.ambient[1]=g,_lights.ambient[2]=b,_lights.directional.length=directionalLength,_lights.spot.length=spotLength,_lights.point.length=pointLength,_lights.hemi.length=hemiLength,_lights.hash=directionalLength+","+pointLength+","+spotLength+","+hemiLength+","+_lights.shadows.length}function setupGlobalClippingPlanes(planes,camera){_clippingEnabled=0!==_this.clippingPlanes.length||_this.localClippingEnabled||0!==_numGlobalClippingPlanes||_localClippingEnabled,_localClippingEnabled=_this.localClippingEnabled,_globalClippingState=setupClippingPlanes(planes,camera,0),_numGlobalClippingPlanes=null!==planes?planes.length:0}function setupClippingPlanes(planes,camera,dstOffset,skipTransform){var nPlanes=null!==planes?planes.length:0,dstArray=null;if(0!==nPlanes){if(dstArray=_clippingPlanesUniform.value,skipTransform!==!0||null===dstArray){var flatSize=dstOffset+4*nPlanes,viewMatrix=camera.matrixWorldInverse,viewNormalMatrix=_matrix3.getNormalMatrix(viewMatrix);(null===dstArray||dstArray.length<flatSize)&&(dstArray=new Float32Array(flatSize));for(var i=0,i4=dstOffset;i!==nPlanes;++i,i4+=4){var plane=_plane.copy(planes[i]).applyMatrix4(viewMatrix,viewNormalMatrix);plane.normal.toArray(dstArray,i4),dstArray[i4+3]=plane.constant}}_clippingPlanesUniform.value=dstArray,_clippingPlanesUniform.needsUpdate=!0}return _numClippingPlanes=nPlanes,dstArray}function resetGlobalClippingState(){_clippingPlanesUniform.value!==_globalClippingState&&(_clippingPlanesUniform.value=_globalClippingState,_clippingPlanesUniform.needsUpdate=_numGlobalClippingPlanes>0),_numClippingPlanes=_numGlobalClippingPlanes}function setClippingState(planes,clipShadows,camera,cache,fromCache){if(!_localClippingEnabled||null===planes||0===planes.length||_clipRenderingShadows&&!clipShadows)_clipRenderingShadows?setupClippingPlanes(null):resetGlobalClippingState();else{var nGlobal=_clipRenderingShadows?0:_numGlobalClippingPlanes,lGlobal=4*nGlobal,dstArray=cache.clippingState||null;_clippingPlanesUniform.value=dstArray,dstArray=setupClippingPlanes(planes,camera,lGlobal,fromCache);for(var i=0;i!==lGlobal;++i)dstArray[i]=_globalClippingState[i];cache.clippingState=dstArray,_numClippingPlanes+=nGlobal}}function allocTextureUnit(){var textureUnit=_usedTextureUnits;return textureUnit>=capabilities.maxTextures&&console.warn("WebGLRenderer: trying to use "+textureUnit+" texture units while this GPU supports only "+capabilities.maxTextures),_usedTextureUnits+=1,textureUnit}function setTextureParameters(textureType,texture,isPowerOfTwoImage){var extension;if(isPowerOfTwoImage?(_gl.texParameteri(textureType,_gl.TEXTURE_WRAP_S,paramThreeToGL(texture.wrapS)),_gl.texParameteri(textureType,_gl.TEXTURE_WRAP_T,paramThreeToGL(texture.wrapT)),_gl.texParameteri(textureType,_gl.TEXTURE_MAG_FILTER,paramThreeToGL(texture.magFilter)),_gl.texParameteri(textureType,_gl.TEXTURE_MIN_FILTER,paramThreeToGL(texture.minFilter))):(_gl.texParameteri(textureType,_gl.TEXTURE_WRAP_S,_gl.CLAMP_TO_EDGE),_gl.texParameteri(textureType,_gl.TEXTURE_WRAP_T,_gl.CLAMP_TO_EDGE),texture.wrapS===THREE.ClampToEdgeWrapping&&texture.wrapT===THREE.ClampToEdgeWrapping||console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.wrapS and Texture.wrapT should be set to THREE.ClampToEdgeWrapping.",texture),_gl.texParameteri(textureType,_gl.TEXTURE_MAG_FILTER,filterFallback(texture.magFilter)),_gl.texParameteri(textureType,_gl.TEXTURE_MIN_FILTER,filterFallback(texture.minFilter)),texture.minFilter!==THREE.NearestFilter&&texture.minFilter!==THREE.LinearFilter&&console.warn("THREE.WebGLRenderer: Texture is not power of two. Texture.minFilter should be set to THREE.NearestFilter or THREE.LinearFilter.",texture)),extension=extensions.get("EXT_texture_filter_anisotropic")){if(texture.type===THREE.FloatType&&null===extensions.get("OES_texture_float_linear"))return;if(texture.type===THREE.HalfFloatType&&null===extensions.get("OES_texture_half_float_linear"))return;(texture.anisotropy>1||properties.get(texture).__currentAnisotropy)&&(_gl.texParameterf(textureType,extension.TEXTURE_MAX_ANISOTROPY_EXT,Math.min(texture.anisotropy,_this.getMaxAnisotropy())),properties.get(texture).__currentAnisotropy=texture.anisotropy)}}function uploadTexture(textureProperties,texture,slot){void 0===textureProperties.__webglInit&&(textureProperties.__webglInit=!0,texture.addEventListener("dispose",onTextureDispose),textureProperties.__webglTexture=_gl.createTexture(),_infoMemory.textures++),state.activeTexture(_gl.TEXTURE0+slot),state.bindTexture(_gl.TEXTURE_2D,textureProperties.__webglTexture),_gl.pixelStorei(_gl.UNPACK_FLIP_Y_WEBGL,texture.flipY),_gl.pixelStorei(_gl.UNPACK_PREMULTIPLY_ALPHA_WEBGL,texture.premultiplyAlpha),_gl.pixelStorei(_gl.UNPACK_ALIGNMENT,texture.unpackAlignment);var image=clampToMaxSize(texture.image,capabilities.maxTextureSize);textureNeedsPowerOfTwo(texture)&&isPowerOfTwo(image)===!1&&(image=makePowerOfTwo(image));var isPowerOfTwoImage=isPowerOfTwo(image),glFormat=paramThreeToGL(texture.format),glType=paramThreeToGL(texture.type);setTextureParameters(_gl.TEXTURE_2D,texture,isPowerOfTwoImage);var mipmap,mipmaps=texture.mipmaps;if(texture instanceof THREE.DepthTexture){var internalFormat=_gl.DEPTH_COMPONENT;if(texture.type===THREE.FloatType){if(!_isWebGL2)throw new Error("Float Depth Texture only supported in WebGL2.0");internalFormat=_gl.DEPTH_COMPONENT32F}else _isWebGL2&&(internalFormat=_gl.DEPTH_COMPONENT16);state.texImage2D(_gl.TEXTURE_2D,0,internalFormat,image.width,image.height,0,glFormat,glType,null)}else if(texture instanceof THREE.DataTexture)if(mipmaps.length>0&&isPowerOfTwoImage){for(var i=0,il=mipmaps.length;il>i;i++)mipmap=mipmaps[i],state.texImage2D(_gl.TEXTURE_2D,i,glFormat,mipmap.width,mipmap.height,0,glFormat,glType,mipmap.data);texture.generateMipmaps=!1}else state.texImage2D(_gl.TEXTURE_2D,0,glFormat,image.width,image.height,0,glFormat,glType,image.data);else if(texture instanceof THREE.CompressedTexture)for(var i=0,il=mipmaps.length;il>i;i++)mipmap=mipmaps[i],
texture.format!==THREE.RGBAFormat&&texture.format!==THREE.RGBFormat?state.getCompressedTextureFormats().indexOf(glFormat)>-1?state.compressedTexImage2D(_gl.TEXTURE_2D,i,glFormat,mipmap.width,mipmap.height,0,mipmap.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .uploadTexture()"):state.texImage2D(_gl.TEXTURE_2D,i,glFormat,mipmap.width,mipmap.height,0,glFormat,glType,mipmap.data);else if(mipmaps.length>0&&isPowerOfTwoImage){for(var i=0,il=mipmaps.length;il>i;i++)mipmap=mipmaps[i],state.texImage2D(_gl.TEXTURE_2D,i,glFormat,glFormat,glType,mipmap);texture.generateMipmaps=!1}else state.texImage2D(_gl.TEXTURE_2D,0,glFormat,glFormat,glType,image);texture.generateMipmaps&&isPowerOfTwoImage&&_gl.generateMipmap(_gl.TEXTURE_2D),textureProperties.__version=texture.version,texture.onUpdate&&texture.onUpdate(texture)}function setTexture2D(texture,slot){texture instanceof THREE.WebGLRenderTarget&&(texture=texture.texture);var textureProperties=properties.get(texture);if(texture.version>0&&textureProperties.__version!==texture.version){var image=texture.image;return void 0===image?void console.warn("THREE.WebGLRenderer: Texture marked for update but image is undefined",texture):image.complete===!1?void console.warn("THREE.WebGLRenderer: Texture marked for update but image is incomplete",texture):void uploadTexture(textureProperties,texture,slot)}state.activeTexture(_gl.TEXTURE0+slot),state.bindTexture(_gl.TEXTURE_2D,textureProperties.__webglTexture)}function clampToMaxSize(image,maxSize){if(image.width>maxSize||image.height>maxSize){var scale=maxSize/Math.max(image.width,image.height),canvas=document.createElement("canvas");canvas.width=Math.floor(image.width*scale),canvas.height=Math.floor(image.height*scale);var context=canvas.getContext("2d");return context.drawImage(image,0,0,image.width,image.height,0,0,canvas.width,canvas.height),console.warn("THREE.WebGLRenderer: image is too big ("+image.width+"x"+image.height+"). Resized to "+canvas.width+"x"+canvas.height,image),canvas}return image}function isPowerOfTwo(image){return THREE.Math.isPowerOfTwo(image.width)&&THREE.Math.isPowerOfTwo(image.height)}function textureNeedsPowerOfTwo(texture){return texture.wrapS!==THREE.ClampToEdgeWrapping||texture.wrapT!==THREE.ClampToEdgeWrapping?!0:texture.minFilter!==THREE.NearestFilter&&texture.minFilter!==THREE.LinearFilter}function makePowerOfTwo(image){if(image instanceof HTMLImageElement||image instanceof HTMLCanvasElement){var canvas=document.createElement("canvas");canvas.width=THREE.Math.nearestPowerOfTwo(image.width),canvas.height=THREE.Math.nearestPowerOfTwo(image.height);var context=canvas.getContext("2d");return context.drawImage(image,0,0,canvas.width,canvas.height),console.warn("THREE.WebGLRenderer: image is not power of two ("+image.width+"x"+image.height+"). Resized to "+canvas.width+"x"+canvas.height,image),canvas}return image}function setCubeTexture(texture,slot){var textureProperties=properties.get(texture);if(6===texture.image.length)if(texture.version>0&&textureProperties.__version!==texture.version){textureProperties.__image__webglTextureCube||(texture.addEventListener("dispose",onTextureDispose),textureProperties.__image__webglTextureCube=_gl.createTexture(),_infoMemory.textures++),state.activeTexture(_gl.TEXTURE0+slot),state.bindTexture(_gl.TEXTURE_CUBE_MAP,textureProperties.__image__webglTextureCube),_gl.pixelStorei(_gl.UNPACK_FLIP_Y_WEBGL,texture.flipY);for(var isCompressed=texture instanceof THREE.CompressedTexture,isDataTexture=texture.image[0]instanceof THREE.DataTexture,cubeImage=[],i=0;6>i;i++)!_this.autoScaleCubemaps||isCompressed||isDataTexture?cubeImage[i]=isDataTexture?texture.image[i].image:texture.image[i]:cubeImage[i]=clampToMaxSize(texture.image[i],capabilities.maxCubemapSize);var image=cubeImage[0],isPowerOfTwoImage=isPowerOfTwo(image),glFormat=paramThreeToGL(texture.format),glType=paramThreeToGL(texture.type);setTextureParameters(_gl.TEXTURE_CUBE_MAP,texture,isPowerOfTwoImage);for(var i=0;6>i;i++)if(isCompressed)for(var mipmap,mipmaps=cubeImage[i].mipmaps,j=0,jl=mipmaps.length;jl>j;j++)mipmap=mipmaps[j],texture.format!==THREE.RGBAFormat&&texture.format!==THREE.RGBFormat?state.getCompressedTextureFormats().indexOf(glFormat)>-1?state.compressedTexImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X+i,j,glFormat,mipmap.width,mipmap.height,0,mipmap.data):console.warn("THREE.WebGLRenderer: Attempt to load unsupported compressed texture format in .setCubeTexture()"):state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X+i,j,glFormat,mipmap.width,mipmap.height,0,glFormat,glType,mipmap.data);else isDataTexture?state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,glFormat,cubeImage[i].width,cubeImage[i].height,0,glFormat,glType,cubeImage[i].data):state.texImage2D(_gl.TEXTURE_CUBE_MAP_POSITIVE_X+i,0,glFormat,glFormat,glType,cubeImage[i]);texture.generateMipmaps&&isPowerOfTwoImage&&_gl.generateMipmap(_gl.TEXTURE_CUBE_MAP),textureProperties.__version=texture.version,texture.onUpdate&&texture.onUpdate(texture)}else state.activeTexture(_gl.TEXTURE0+slot),state.bindTexture(_gl.TEXTURE_CUBE_MAP,textureProperties.__image__webglTextureCube)}function setCubeTextureDynamic(texture,slot){state.activeTexture(_gl.TEXTURE0+slot),state.bindTexture(_gl.TEXTURE_CUBE_MAP,properties.get(texture).__webglTexture)}function setupFrameBufferTexture(framebuffer,renderTarget,attachment,textureTarget){var glFormat=paramThreeToGL(renderTarget.texture.format),glType=paramThreeToGL(renderTarget.texture.type);state.texImage2D(textureTarget,0,glFormat,renderTarget.width,renderTarget.height,0,glFormat,glType,null),_gl.bindFramebuffer(_gl.FRAMEBUFFER,framebuffer),_gl.framebufferTexture2D(_gl.FRAMEBUFFER,attachment,textureTarget,properties.get(renderTarget.texture).__webglTexture,0),_gl.bindFramebuffer(_gl.FRAMEBUFFER,null)}function setupRenderBufferStorage(renderbuffer,renderTarget){_gl.bindRenderbuffer(_gl.RENDERBUFFER,renderbuffer),renderTarget.depthBuffer&&!renderTarget.stencilBuffer?(_gl.renderbufferStorage(_gl.RENDERBUFFER,_gl.DEPTH_COMPONENT16,renderTarget.width,renderTarget.height),_gl.framebufferRenderbuffer(_gl.FRAMEBUFFER,_gl.DEPTH_ATTACHMENT,_gl.RENDERBUFFER,renderbuffer)):renderTarget.depthBuffer&&renderTarget.stencilBuffer?(_gl.renderbufferStorage(_gl.RENDERBUFFER,_gl.DEPTH_STENCIL,renderTarget.width,renderTarget.height),_gl.framebufferRenderbuffer(_gl.FRAMEBUFFER,_gl.DEPTH_STENCIL_ATTACHMENT,_gl.RENDERBUFFER,renderbuffer)):_gl.renderbufferStorage(_gl.RENDERBUFFER,_gl.RGBA4,renderTarget.width,renderTarget.height),_gl.bindRenderbuffer(_gl.RENDERBUFFER,null)}function setupDepthTexture(framebuffer,renderTarget){var isCube=renderTarget instanceof THREE.WebGLRenderTargetCube;if(isCube)throw new Error("Depth Texture with cube render targets is not supported!");if(_gl.bindFramebuffer(_gl.FRAMEBUFFER,framebuffer),!(renderTarget.depthTexture instanceof THREE.DepthTexture))throw new Error("renderTarget.depthTexture must be an instance of THREE.DepthTexture");properties.get(renderTarget.depthTexture).__webglTexture&&renderTarget.depthTexture.image.width===renderTarget.width&&renderTarget.depthTexture.image.height===renderTarget.height||(renderTarget.depthTexture.image.width=renderTarget.width,renderTarget.depthTexture.image.height=renderTarget.height,renderTarget.depthTexture.needsUpdate=!0),_this.setTexture(renderTarget.depthTexture,0);var webglDepthTexture=properties.get(renderTarget.depthTexture).__webglTexture;_gl.framebufferTexture2D(_gl.FRAMEBUFFER,_gl.DEPTH_ATTACHMENT,_gl.TEXTURE_2D,webglDepthTexture,0)}function setupDepthRenderbuffer(renderTarget){var renderTargetProperties=properties.get(renderTarget),isCube=renderTarget instanceof THREE.WebGLRenderTargetCube;if(renderTarget.depthTexture){if(isCube)throw new Error("target.depthTexture not supported in Cube render targets");setupDepthTexture(renderTargetProperties.__webglFramebuffer,renderTarget)}else if(isCube){renderTargetProperties.__webglDepthbuffer=[];for(var i=0;6>i;i++)_gl.bindFramebuffer(_gl.FRAMEBUFFER,renderTargetProperties.__webglFramebuffer[i]),renderTargetProperties.__webglDepthbuffer[i]=_gl.createRenderbuffer(),setupRenderBufferStorage(renderTargetProperties.__webglDepthbuffer[i],renderTarget)}else _gl.bindFramebuffer(_gl.FRAMEBUFFER,renderTargetProperties.__webglFramebuffer),renderTargetProperties.__webglDepthbuffer=_gl.createRenderbuffer(),setupRenderBufferStorage(renderTargetProperties.__webglDepthbuffer,renderTarget);_gl.bindFramebuffer(_gl.FRAMEBUFFER,null)}function setupRenderTarget(renderTarget){var renderTargetProperties=properties.get(renderTarget),textureProperties=properties.get(renderTarget.texture);renderTarget.addEventListener("dispose",onRenderTargetDispose),textureProperties.__webglTexture=_gl.createTexture(),_infoMemory.textures++;var isCube=renderTarget instanceof THREE.WebGLRenderTargetCube,isTargetPowerOfTwo=THREE.Math.isPowerOfTwo(renderTarget.width)&&THREE.Math.isPowerOfTwo(renderTarget.height);if(isCube){renderTargetProperties.__webglFramebuffer=[];for(var i=0;6>i;i++)renderTargetProperties.__webglFramebuffer[i]=_gl.createFramebuffer()}else renderTargetProperties.__webglFramebuffer=_gl.createFramebuffer();if(isCube){state.bindTexture(_gl.TEXTURE_CUBE_MAP,textureProperties.__webglTexture),setTextureParameters(_gl.TEXTURE_CUBE_MAP,renderTarget.texture,isTargetPowerOfTwo);for(var i=0;6>i;i++)setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer[i],renderTarget,_gl.COLOR_ATTACHMENT0,_gl.TEXTURE_CUBE_MAP_POSITIVE_X+i);renderTarget.texture.generateMipmaps&&isTargetPowerOfTwo&&_gl.generateMipmap(_gl.TEXTURE_CUBE_MAP),state.bindTexture(_gl.TEXTURE_CUBE_MAP,null)}else state.bindTexture(_gl.TEXTURE_2D,textureProperties.__webglTexture),setTextureParameters(_gl.TEXTURE_2D,renderTarget.texture,isTargetPowerOfTwo),setupFrameBufferTexture(renderTargetProperties.__webglFramebuffer,renderTarget,_gl.COLOR_ATTACHMENT0,_gl.TEXTURE_2D),renderTarget.texture.generateMipmaps&&isTargetPowerOfTwo&&_gl.generateMipmap(_gl.TEXTURE_2D),state.bindTexture(_gl.TEXTURE_2D,null);renderTarget.depthBuffer&&setupDepthRenderbuffer(renderTarget)}function updateRenderTargetMipmap(renderTarget){var target=renderTarget instanceof THREE.WebGLRenderTargetCube?_gl.TEXTURE_CUBE_MAP:_gl.TEXTURE_2D,texture=properties.get(renderTarget.texture).__webglTexture;state.bindTexture(target,texture),_gl.generateMipmap(target),state.bindTexture(target,null)}function filterFallback(f){return f===THREE.NearestFilter||f===THREE.NearestMipMapNearestFilter||f===THREE.NearestMipMapLinearFilter?_gl.NEAREST:_gl.LINEAR}function paramThreeToGL(p){var extension;if(p===THREE.RepeatWrapping)return _gl.REPEAT;if(p===THREE.ClampToEdgeWrapping)return _gl.CLAMP_TO_EDGE;if(p===THREE.MirroredRepeatWrapping)return _gl.MIRRORED_REPEAT;if(p===THREE.NearestFilter)return _gl.NEAREST;if(p===THREE.NearestMipMapNearestFilter)return _gl.NEAREST_MIPMAP_NEAREST;if(p===THREE.NearestMipMapLinearFilter)return _gl.NEAREST_MIPMAP_LINEAR;if(p===THREE.LinearFilter)return _gl.LINEAR;if(p===THREE.LinearMipMapNearestFilter)return _gl.LINEAR_MIPMAP_NEAREST;if(p===THREE.LinearMipMapLinearFilter)return _gl.LINEAR_MIPMAP_LINEAR;if(p===THREE.UnsignedByteType)return _gl.UNSIGNED_BYTE;if(p===THREE.UnsignedShort4444Type)return _gl.UNSIGNED_SHORT_4_4_4_4;if(p===THREE.UnsignedShort5551Type)return _gl.UNSIGNED_SHORT_5_5_5_1;if(p===THREE.UnsignedShort565Type)return _gl.UNSIGNED_SHORT_5_6_5;if(p===THREE.ByteType)return _gl.BYTE;if(p===THREE.ShortType)return _gl.SHORT;if(p===THREE.UnsignedShortType)return _gl.UNSIGNED_SHORT;if(p===THREE.IntType)return _gl.INT;if(p===THREE.UnsignedIntType)return _gl.UNSIGNED_INT;if(p===THREE.FloatType)return _gl.FLOAT;if(extension=extensions.get("OES_texture_half_float"),null!==extension&&p===THREE.HalfFloatType)return extension.HALF_FLOAT_OES;if(p===THREE.AlphaFormat)return _gl.ALPHA;if(p===THREE.RGBFormat)return _gl.RGB;if(p===THREE.RGBAFormat)return _gl.RGBA;if(p===THREE.LuminanceFormat)return _gl.LUMINANCE;if(p===THREE.LuminanceAlphaFormat)return _gl.LUMINANCE_ALPHA;if(p===THREE.DepthFormat)return _gl.DEPTH_COMPONENT;if(p===THREE.AddEquation)return _gl.FUNC_ADD;if(p===THREE.SubtractEquation)return _gl.FUNC_SUBTRACT;if(p===THREE.ReverseSubtractEquation)return _gl.FUNC_REVERSE_SUBTRACT;if(p===THREE.ZeroFactor)return _gl.ZERO;if(p===THREE.OneFactor)return _gl.ONE;if(p===THREE.SrcColorFactor)return _gl.SRC_COLOR;if(p===THREE.OneMinusSrcColorFactor)return _gl.ONE_MINUS_SRC_COLOR;if(p===THREE.SrcAlphaFactor)return _gl.SRC_ALPHA;if(p===THREE.OneMinusSrcAlphaFactor)return _gl.ONE_MINUS_SRC_ALPHA;if(p===THREE.DstAlphaFactor)return _gl.DST_ALPHA;if(p===THREE.OneMinusDstAlphaFactor)return _gl.ONE_MINUS_DST_ALPHA;if(p===THREE.DstColorFactor)return _gl.DST_COLOR;if(p===THREE.OneMinusDstColorFactor)return _gl.ONE_MINUS_DST_COLOR;if(p===THREE.SrcAlphaSaturateFactor)return _gl.SRC_ALPHA_SATURATE;if(extension=extensions.get("WEBGL_compressed_texture_s3tc"),null!==extension){if(p===THREE.RGB_S3TC_DXT1_Format)return extension.COMPRESSED_RGB_S3TC_DXT1_EXT;if(p===THREE.RGBA_S3TC_DXT1_Format)return extension.COMPRESSED_RGBA_S3TC_DXT1_EXT;if(p===THREE.RGBA_S3TC_DXT3_Format)return extension.COMPRESSED_RGBA_S3TC_DXT3_EXT;if(p===THREE.RGBA_S3TC_DXT5_Format)return extension.COMPRESSED_RGBA_S3TC_DXT5_EXT}if(extension=extensions.get("WEBGL_compressed_texture_pvrtc"),null!==extension){if(p===THREE.RGB_PVRTC_4BPPV1_Format)return extension.COMPRESSED_RGB_PVRTC_4BPPV1_IMG;if(p===THREE.RGB_PVRTC_2BPPV1_Format)return extension.COMPRESSED_RGB_PVRTC_2BPPV1_IMG;if(p===THREE.RGBA_PVRTC_4BPPV1_Format)return extension.COMPRESSED_RGBA_PVRTC_4BPPV1_IMG;if(p===THREE.RGBA_PVRTC_2BPPV1_Format)return extension.COMPRESSED_RGBA_PVRTC_2BPPV1_IMG}if(extension=extensions.get("WEBGL_compressed_texture_etc1"),null!==extension&&p===THREE.RGB_ETC1_Format)return extension.COMPRESSED_RGB_ETC1_WEBGL;if(extension=extensions.get("EXT_blend_minmax"),null!==extension){if(p===THREE.MinEquation)return extension.MIN_EXT;if(p===THREE.MaxEquation)return extension.MAX_EXT}return 0}console.log("THREE.WebGLRenderer",THREE.REVISION),parameters=parameters||{};var _canvas=void 0!==parameters.canvas?parameters.canvas:document.createElement("canvas"),_context=void 0!==parameters.context?parameters.context:null,_alpha=void 0!==parameters.alpha?parameters.alpha:!1,_depth=void 0!==parameters.depth?parameters.depth:!0,_stencil=void 0!==parameters.stencil?parameters.stencil:!0,_antialias=void 0!==parameters.antialias?parameters.antialias:!1,_premultipliedAlpha=void 0!==parameters.premultipliedAlpha?parameters.premultipliedAlpha:!0,_preserveDrawingBuffer=void 0!==parameters.preserveDrawingBuffer?parameters.preserveDrawingBuffer:!1,lights=[],opaqueObjects=[],opaqueObjectsLastIndex=-1,transparentObjects=[],transparentObjectsLastIndex=-1,morphInfluences=new Float32Array(8),sprites=[],lensFlares=[];this.domElement=_canvas,this.context=null,this.autoClear=!0,this.autoClearColor=!0,this.autoClearDepth=!0,this.autoClearStencil=!0,this.sortObjects=!0,this.clippingPlanes=[],this.localClippingEnabled=!1,this.gammaFactor=2,this.gammaInput=!1,this.gammaOutput=!1,this.physicallyCorrectLights=!1,this.toneMapping=THREE.LinearToneMapping,this.toneMappingExposure=1,this.toneMappingWhitePoint=1,this.maxMorphTargets=8,this.maxMorphNormals=4,this.autoScaleCubemaps=!0;var _this=this,_currentProgram=null,_currentRenderTarget=null,_currentFramebuffer=null,_currentMaterialId=-1,_currentGeometryProgram="",_currentCamera=null,_currentScissor=new THREE.Vector4,_currentScissorTest=null,_currentViewport=new THREE.Vector4,_usedTextureUnits=0,_clearColor=new THREE.Color(0),_clearAlpha=0,_width=_canvas.width,_height=_canvas.height,_pixelRatio=1,_scissor=new THREE.Vector4(0,0,_width,_height),_scissorTest=!1,_viewport=new THREE.Vector4(0,0,_width,_height),_frustum=new THREE.Frustum,_clippingEnabled=!1,_localClippingEnabled=!1,_clipRenderingShadows=!1,_numClippingPlanes=0,_clippingPlanesUniform={type:"4fv",value:null,needsUpdate:!1},_globalClippingState=null,_numGlobalClippingPlanes=0,_matrix3=new THREE.Matrix3,_sphere=new THREE.Sphere,_plane=new THREE.Plane,_projScreenMatrix=new THREE.Matrix4,_vector3=new THREE.Vector3,_lights={hash:"",ambient:[0,0,0],directional:[],directionalShadowMap:[],directionalShadowMatrix:[],spot:[],spotShadowMap:[],spotShadowMatrix:[],point:[],pointShadowMap:[],pointShadowMatrix:[],hemi:[],shadows:[]},_infoMemory={geometries:0,textures:0},_infoRender={calls:0,vertices:0,faces:0,points:0};this.info={render:_infoRender,memory:_infoMemory,programs:null};var _gl;try{var attributes={alpha:_alpha,depth:_depth,stencil:_stencil,antialias:_antialias,premultipliedAlpha:_premultipliedAlpha,preserveDrawingBuffer:_preserveDrawingBuffer};if(_gl=_context||_canvas.getContext("webgl",attributes)||_canvas.getContext("experimental-webgl",attributes),null===_gl)throw null!==_canvas.getContext("webgl")?"Error creating WebGL context with your selected attributes.":"Error creating WebGL context.";void 0===_gl.getShaderPrecisionFormat&&(_gl.getShaderPrecisionFormat=function(){return{rangeMin:1,rangeMax:1,precision:1}}),_canvas.addEventListener("webglcontextlost",onContextLost,!1)}catch(error){console.error("THREE.WebGLRenderer: "+error)}var _isWebGL2="undefined"!=typeof WebGL2RenderingContext&&_gl instanceof WebGL2RenderingContext,extensions=new THREE.WebGLExtensions(_gl);extensions.get("WEBGL_depth_texture"),extensions.get("OES_texture_float"),extensions.get("OES_texture_float_linear"),extensions.get("OES_texture_half_float"),extensions.get("OES_texture_half_float_linear"),extensions.get("OES_standard_derivatives"),extensions.get("ANGLE_instanced_arrays"),extensions.get("OES_element_index_uint")&&(THREE.BufferGeometry.MaxIndex=4294967296);var capabilities=new THREE.WebGLCapabilities(_gl,extensions,parameters),state=new THREE.WebGLState(_gl,extensions,paramThreeToGL),properties=new THREE.WebGLProperties,objects=new THREE.WebGLObjects(_gl,properties,this.info),programCache=new THREE.WebGLPrograms(this,capabilities),lightCache=new THREE.WebGLLights;this.info.programs=programCache.programs;var bufferRenderer=new THREE.WebGLBufferRenderer(_gl,extensions,_infoRender),indexedBufferRenderer=new THREE.WebGLIndexedBufferRenderer(_gl,extensions,_infoRender);setDefaultGLState(),this.context=_gl,this.capabilities=capabilities,this.extensions=extensions,this.properties=properties,this.state=state;var shadowMap=new THREE.WebGLShadowMap(this,_lights,objects);this.shadowMap=shadowMap;var spritePlugin=new THREE.SpritePlugin(this,sprites),lensFlarePlugin=new THREE.LensFlarePlugin(this,lensFlares);this.getContext=function(){return _gl},this.getContextAttributes=function(){return _gl.getContextAttributes()},this.forceContextLoss=function(){extensions.get("WEBGL_lose_context").loseContext()},this.getMaxAnisotropy=function(){var value;return function(){if(void 0!==value)return value;var extension=extensions.get("EXT_texture_filter_anisotropic");return value=null!==extension?_gl.getParameter(extension.MAX_TEXTURE_MAX_ANISOTROPY_EXT):0}}(),this.getPrecision=function(){return capabilities.precision},this.getPixelRatio=function(){return _pixelRatio},this.setPixelRatio=function(value){void 0!==value&&(_pixelRatio=value,this.setSize(_viewport.z,_viewport.w,!1))},this.getSize=function(){return{width:_width,height:_height}},this.setSize=function(width,height,updateStyle){_width=width,_height=height,_canvas.width=width*_pixelRatio,_canvas.height=height*_pixelRatio,updateStyle!==!1&&(_canvas.style.width=width+"px",_canvas.style.height=height+"px"),this.setViewport(0,0,width,height)},this.setViewport=function(x,y,width,height){state.viewport(_viewport.set(x,y,width,height))},this.setScissor=function(x,y,width,height){state.scissor(_scissor.set(x,y,width,height))},this.setScissorTest=function(boolean){state.setScissorTest(_scissorTest=boolean)},this.getClearColor=function(){return _clearColor},this.setClearColor=function(color,alpha){_clearColor.set(color),_clearAlpha=void 0!==alpha?alpha:1,glClearColor(_clearColor.r,_clearColor.g,_clearColor.b,_clearAlpha)},this.getClearAlpha=function(){return _clearAlpha},this.setClearAlpha=function(alpha){_clearAlpha=alpha,glClearColor(_clearColor.r,_clearColor.g,_clearColor.b,_clearAlpha)},this.clear=function(color,depth,stencil){var bits=0;(void 0===color||color)&&(bits|=_gl.COLOR_BUFFER_BIT),(void 0===depth||depth)&&(bits|=_gl.DEPTH_BUFFER_BIT),(void 0===stencil||stencil)&&(bits|=_gl.STENCIL_BUFFER_BIT),_gl.clear(bits)},this.clearColor=function(){this.clear(!0,!1,!1)},this.clearDepth=function(){this.clear(!1,!0,!1)},this.clearStencil=function(){this.clear(!1,!1,!0)},this.clearTarget=function(renderTarget,color,depth,stencil){this.setRenderTarget(renderTarget),this.clear(color,depth,stencil)},this.resetGLState=resetGLState,this.dispose=function(){_canvas.removeEventListener("webglcontextlost",onContextLost,!1)},this.renderBufferImmediate=function(object,program,material){state.initAttributes();var buffers=properties.get(object);object.hasPositions&&!buffers.position&&(buffers.position=_gl.createBuffer()),object.hasNormals&&!buffers.normal&&(buffers.normal=_gl.createBuffer()),object.hasUvs&&!buffers.uv&&(buffers.uv=_gl.createBuffer()),object.hasColors&&!buffers.color&&(buffers.color=_gl.createBuffer());var attributes=program.getAttributes();if(object.hasPositions&&(_gl.bindBuffer(_gl.ARRAY_BUFFER,buffers.position),_gl.bufferData(_gl.ARRAY_BUFFER,object.positionArray,_gl.DYNAMIC_DRAW),state.enableAttribute(attributes.position),_gl.vertexAttribPointer(attributes.position,3,_gl.FLOAT,!1,0,0)),object.hasNormals){if(_gl.bindBuffer(_gl.ARRAY_BUFFER,buffers.normal),"MeshPhongMaterial"!==material.type&&"MeshStandardMaterial"!==material.type&&"MeshPhysicalMaterial"!==material.type&&material.shading===THREE.FlatShading)for(var i=0,l=3*object.count;l>i;i+=9){var array=object.normalArray,nx=(array[i+0]+array[i+3]+array[i+6])/3,ny=(array[i+1]+array[i+4]+array[i+7])/3,nz=(array[i+2]+array[i+5]+array[i+8])/3;array[i+0]=nx,array[i+1]=ny,array[i+2]=nz,array[i+3]=nx,array[i+4]=ny,array[i+5]=nz,array[i+6]=nx,array[i+7]=ny,array[i+8]=nz}_gl.bufferData(_gl.ARRAY_BUFFER,object.normalArray,_gl.DYNAMIC_DRAW),state.enableAttribute(attributes.normal),_gl.vertexAttribPointer(attributes.normal,3,_gl.FLOAT,!1,0,0)}object.hasUvs&&material.map&&(_gl.bindBuffer(_gl.ARRAY_BUFFER,buffers.uv),_gl.bufferData(_gl.ARRAY_BUFFER,object.uvArray,_gl.DYNAMIC_DRAW),state.enableAttribute(attributes.uv),_gl.vertexAttribPointer(attributes.uv,2,_gl.FLOAT,!1,0,0)),object.hasColors&&material.vertexColors!==THREE.NoColors&&(_gl.bindBuffer(_gl.ARRAY_BUFFER,buffers.color),_gl.bufferData(_gl.ARRAY_BUFFER,object.colorArray,_gl.DYNAMIC_DRAW),state.enableAttribute(attributes.color),_gl.vertexAttribPointer(attributes.color,3,_gl.FLOAT,!1,0,0)),state.disableUnusedAttributes(),_gl.drawArrays(_gl.TRIANGLES,0,object.count),object.count=0},this.renderBufferDirect=function(camera,fog,geometry,material,object,group){setMaterial(material);var program=setProgram(camera,fog,material,object),updateBuffers=!1,geometryProgram=geometry.id+"_"+program.id+"_"+material.wireframe;geometryProgram!==_currentGeometryProgram&&(_currentGeometryProgram=geometryProgram,updateBuffers=!0);var morphTargetInfluences=object.morphTargetInfluences;if(void 0!==morphTargetInfluences){for(var activeInfluences=[],i=0,l=morphTargetInfluences.length;l>i;i++){var influence=morphTargetInfluences[i];activeInfluences.push([influence,i])}activeInfluences.sort(absNumericalSort),activeInfluences.length>8&&(activeInfluences.length=8);for(var morphAttributes=geometry.morphAttributes,i=0,l=activeInfluences.length;l>i;i++){var influence=activeInfluences[i];if(morphInfluences[i]=influence[0],0!==influence[0]){var index=influence[1];material.morphTargets===!0&&morphAttributes.position&&geometry.addAttribute("morphTarget"+i,morphAttributes.position[index]),material.morphNormals===!0&&morphAttributes.normal&&geometry.addAttribute("morphNormal"+i,morphAttributes.normal[index])}else material.morphTargets===!0&&geometry.removeAttribute("morphTarget"+i),material.morphNormals===!0&&geometry.removeAttribute("morphNormal"+i)}program.getUniforms().setValue(_gl,"morphTargetInfluences",morphInfluences),updateBuffers=!0}var index=geometry.index,position=geometry.attributes.position;material.wireframe===!0&&(index=objects.getWireframeAttribute(geometry));var renderer;null!==index?(renderer=indexedBufferRenderer,renderer.setIndex(index)):renderer=bufferRenderer,updateBuffers&&(setupVertexAttributes(material,program,geometry),null!==index&&_gl.bindBuffer(_gl.ELEMENT_ARRAY_BUFFER,objects.getAttributeBuffer(index)));var dataStart=0,dataCount=1/0;null!==index?dataCount=index.count:void 0!==position&&(dataCount=position.count);var rangeStart=geometry.drawRange.start,rangeCount=geometry.drawRange.count,groupStart=null!==group?group.start:0,groupCount=null!==group?group.count:1/0,drawStart=Math.max(dataStart,rangeStart,groupStart),drawEnd=Math.min(dataStart+dataCount,rangeStart+rangeCount,groupStart+groupCount)-1,drawCount=Math.max(0,drawEnd-drawStart+1);if(object instanceof THREE.Mesh)if(material.wireframe===!0)state.setLineWidth(material.wireframeLinewidth*getTargetPixelRatio()),renderer.setMode(_gl.LINES);else switch(object.drawMode){case THREE.TrianglesDrawMode:renderer.setMode(_gl.TRIANGLES);break;case THREE.TriangleStripDrawMode:renderer.setMode(_gl.TRIANGLE_STRIP);break;case THREE.TriangleFanDrawMode:renderer.setMode(_gl.TRIANGLE_FAN)}else if(object instanceof THREE.Line){var lineWidth=material.linewidth;void 0===lineWidth&&(lineWidth=1),state.setLineWidth(lineWidth*getTargetPixelRatio()),object instanceof THREE.LineSegments?renderer.setMode(_gl.LINES):renderer.setMode(_gl.LINE_STRIP)}else object instanceof THREE.Points&&renderer.setMode(_gl.POINTS);geometry instanceof THREE.InstancedBufferGeometry?geometry.maxInstancedCount>0&&renderer.renderInstances(geometry,drawStart,drawCount):renderer.render(drawStart,drawCount)},this.render=function(scene,camera,renderTarget,forceClear){if(camera instanceof THREE.Camera==!1)return void console.error("THREE.WebGLRenderer.render: camera is not an instance of THREE.Camera.");var fog=scene.fog;if(_currentGeometryProgram="",_currentMaterialId=-1,_currentCamera=null,scene.autoUpdate===!0&&scene.updateMatrixWorld(),null===camera.parent&&camera.updateMatrixWorld(),camera.matrixWorldInverse.getInverse(camera.matrixWorld),_projScreenMatrix.multiplyMatrices(camera.projectionMatrix,camera.matrixWorldInverse),_frustum.setFromMatrix(_projScreenMatrix),lights.length=0,opaqueObjectsLastIndex=-1,transparentObjectsLastIndex=-1,sprites.length=0,lensFlares.length=0,setupGlobalClippingPlanes(this.clippingPlanes,camera),projectObject(scene,camera),opaqueObjects.length=opaqueObjectsLastIndex+1,transparentObjects.length=transparentObjectsLastIndex+1,_this.sortObjects===!0&&(opaqueObjects.sort(painterSortStable),transparentObjects.sort(reversePainterSortStable)),_clippingEnabled&&(_clipRenderingShadows=!0,setupClippingPlanes(null)),setupShadows(lights),shadowMap.render(scene,camera),setupLights(lights,camera),_clippingEnabled&&(_clipRenderingShadows=!1,resetGlobalClippingState()),_infoRender.calls=0,_infoRender.vertices=0,_infoRender.faces=0,_infoRender.points=0,void 0===renderTarget&&(renderTarget=null),this.setRenderTarget(renderTarget),(this.autoClear||forceClear)&&this.clear(this.autoClearColor,this.autoClearDepth,this.autoClearStencil),scene.overrideMaterial){var overrideMaterial=scene.overrideMaterial;renderObjects(opaqueObjects,camera,fog,overrideMaterial),renderObjects(transparentObjects,camera,fog,overrideMaterial)}else state.setBlending(THREE.NoBlending),renderObjects(opaqueObjects,camera,fog),renderObjects(transparentObjects,camera,fog);if(spritePlugin.render(scene,camera),lensFlarePlugin.render(scene,camera,_currentViewport),renderTarget){var texture=renderTarget.texture;texture.generateMipmaps&&isPowerOfTwo(renderTarget)&&texture.minFilter!==THREE.NearestFilter&&texture.minFilter!==THREE.LinearFilter&&updateRenderTargetMipmap(renderTarget)}state.setDepthTest(!0),state.setDepthWrite(!0),state.setColorWrite(!0)},this.setFaceCulling=function(cullFace,frontFaceDirection){cullFace===THREE.CullFaceNone?state.disable(_gl.CULL_FACE):(frontFaceDirection===THREE.FrontFaceDirectionCW?_gl.frontFace(_gl.CW):_gl.frontFace(_gl.CCW),cullFace===THREE.CullFaceBack?_gl.cullFace(_gl.BACK):cullFace===THREE.CullFaceFront?_gl.cullFace(_gl.FRONT):_gl.cullFace(_gl.FRONT_AND_BACK),state.enable(_gl.CULL_FACE))};var setTextureWarned=!1;this.setTexture=function(texture,slot){setTextureWarned||(console.warn("THREE.WebGLRenderer: .setTexture is deprecated, use setTexture2D instead."),setTextureWarned=!0),setTexture2D(texture,slot)},this.allocTextureUnit=allocTextureUnit,this.setTexture2D=setTexture2D,this.setTextureCube=function(texture,slot){texture instanceof THREE.CubeTexture||Array.isArray(texture.image)&&6===texture.image.length?setCubeTexture(texture,slot):setCubeTextureDynamic(texture.texture,slot)},this.getCurrentRenderTarget=function(){return _currentRenderTarget},this.setRenderTarget=function(renderTarget){_currentRenderTarget=renderTarget,renderTarget&&void 0===properties.get(renderTarget).__webglFramebuffer&&setupRenderTarget(renderTarget);var framebuffer,isCube=renderTarget instanceof THREE.WebGLRenderTargetCube;if(renderTarget){var renderTargetProperties=properties.get(renderTarget);framebuffer=isCube?renderTargetProperties.__webglFramebuffer[renderTarget.activeCubeFace]:renderTargetProperties.__webglFramebuffer,_currentScissor.copy(renderTarget.scissor),_currentScissorTest=renderTarget.scissorTest,_currentViewport.copy(renderTarget.viewport)}else framebuffer=null,_currentScissor.copy(_scissor).multiplyScalar(_pixelRatio),_currentScissorTest=_scissorTest,_currentViewport.copy(_viewport).multiplyScalar(_pixelRatio);if(_currentFramebuffer!==framebuffer&&(_gl.bindFramebuffer(_gl.FRAMEBUFFER,framebuffer),_currentFramebuffer=framebuffer),state.scissor(_currentScissor),state.setScissorTest(_currentScissorTest),state.viewport(_currentViewport),isCube){var textureProperties=properties.get(renderTarget.texture);_gl.framebufferTexture2D(_gl.FRAMEBUFFER,_gl.COLOR_ATTACHMENT0,_gl.TEXTURE_CUBE_MAP_POSITIVE_X+renderTarget.activeCubeFace,textureProperties.__webglTexture,renderTarget.activeMipMapLevel)}},this.readRenderTargetPixels=function(renderTarget,x,y,width,height,buffer){if(renderTarget instanceof THREE.WebGLRenderTarget==!1)return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not THREE.WebGLRenderTarget.");var framebuffer=properties.get(renderTarget).__webglFramebuffer;if(framebuffer){var restore=!1;framebuffer!==_currentFramebuffer&&(_gl.bindFramebuffer(_gl.FRAMEBUFFER,framebuffer),restore=!0);try{var texture=renderTarget.texture;if(texture.format!==THREE.RGBAFormat&&paramThreeToGL(texture.format)!==_gl.getParameter(_gl.IMPLEMENTATION_COLOR_READ_FORMAT))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in RGBA or implementation defined format.");if(!(texture.type===THREE.UnsignedByteType||paramThreeToGL(texture.type)===_gl.getParameter(_gl.IMPLEMENTATION_COLOR_READ_TYPE)||texture.type===THREE.FloatType&&extensions.get("WEBGL_color_buffer_float")||texture.type===THREE.HalfFloatType&&extensions.get("EXT_color_buffer_half_float")))return void console.error("THREE.WebGLRenderer.readRenderTargetPixels: renderTarget is not in UnsignedByteType or implementation defined type.");_gl.checkFramebufferStatus(_gl.FRAMEBUFFER)===_gl.FRAMEBUFFER_COMPLETE?x>0&&x<=renderTarget.width-width&&y>0&&y<=renderTarget.height-height&&_gl.readPixels(x,y,width,height,paramThreeToGL(texture.format),paramThreeToGL(texture.type),buffer):console.error("THREE.WebGLRenderer.readRenderTargetPixels: readPixels from renderTarget failed. Framebuffer not complete.")}finally{restore&&_gl.bindFramebuffer(_gl.FRAMEBUFFER,_currentFramebuffer)}}}},THREE.WebGLRenderTarget=function(width,height,options){this.uuid=THREE.Math.generateUUID(),this.width=width,
this.height=height,this.scissor=new THREE.Vector4(0,0,width,height),this.scissorTest=!1,this.viewport=new THREE.Vector4(0,0,width,height),options=options||{},void 0===options.minFilter&&(options.minFilter=THREE.LinearFilter),this.texture=new THREE.Texture(void 0,void 0,options.wrapS,options.wrapT,options.magFilter,options.minFilter,options.format,options.type,options.anisotropy,options.encoding),this.depthBuffer=void 0!==options.depthBuffer?options.depthBuffer:!0,this.stencilBuffer=void 0!==options.stencilBuffer?options.stencilBuffer:!0,this.depthTexture=null},THREE.WebGLRenderTarget.prototype={constructor:THREE.WebGLRenderTarget,setSize:function(width,height){this.width===width&&this.height===height||(this.width=width,this.height=height,this.dispose()),this.viewport.set(0,0,width,height),this.scissor.set(0,0,width,height)},clone:function(){return(new this.constructor).copy(this)},copy:function(source){return this.width=source.width,this.height=source.height,this.viewport.copy(source.viewport),this.texture=source.texture.clone(),this.depthBuffer=source.depthBuffer,this.stencilBuffer=source.stencilBuffer,this.depthTexture=source.depthTexture,this},dispose:function(){this.dispatchEvent({type:"dispose"})}},THREE.EventDispatcher.prototype.apply(THREE.WebGLRenderTarget.prototype),THREE.WebGLRenderTargetCube=function(width,height,options){THREE.WebGLRenderTarget.call(this,width,height,options),this.activeCubeFace=0,this.activeMipMapLevel=0},THREE.WebGLRenderTargetCube.prototype=Object.create(THREE.WebGLRenderTarget.prototype),THREE.WebGLRenderTargetCube.prototype.constructor=THREE.WebGLRenderTargetCube,THREE.WebGLBufferRenderer=function(_gl,extensions,_infoRender){function setMode(value){mode=value}function render(start,count){_gl.drawArrays(mode,start,count),_infoRender.calls++,_infoRender.vertices+=count,mode===_gl.TRIANGLES&&(_infoRender.faces+=count/3)}function renderInstances(geometry){var extension=extensions.get("ANGLE_instanced_arrays");if(null===extension)return void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays.");var position=geometry.attributes.position,count=0;position instanceof THREE.InterleavedBufferAttribute?(count=position.data.count,extension.drawArraysInstancedANGLE(mode,0,count,geometry.maxInstancedCount)):(count=position.count,extension.drawArraysInstancedANGLE(mode,0,count,geometry.maxInstancedCount)),_infoRender.calls++,_infoRender.vertices+=count*geometry.maxInstancedCount,mode===_gl.TRIANGLES&&(_infoRender.faces+=geometry.maxInstancedCount*count/3)}var mode;this.setMode=setMode,this.render=render,this.renderInstances=renderInstances},THREE.WebGLIndexedBufferRenderer=function(_gl,extensions,_infoRender){function setMode(value){mode=value}function setIndex(index){index.array instanceof Uint32Array&&extensions.get("OES_element_index_uint")?(type=_gl.UNSIGNED_INT,size=4):(type=_gl.UNSIGNED_SHORT,size=2)}function render(start,count){_gl.drawElements(mode,count,type,start*size),_infoRender.calls++,_infoRender.vertices+=count,mode===_gl.TRIANGLES&&(_infoRender.faces+=count/3)}function renderInstances(geometry,start,count){var extension=extensions.get("ANGLE_instanced_arrays");return null===extension?void console.error("THREE.WebGLBufferRenderer: using THREE.InstancedBufferGeometry but hardware does not support extension ANGLE_instanced_arrays."):(extension.drawElementsInstancedANGLE(mode,count,type,start*size,geometry.maxInstancedCount),_infoRender.calls++,_infoRender.vertices+=count*geometry.maxInstancedCount,void(mode===_gl.TRIANGLES&&(_infoRender.faces+=geometry.maxInstancedCount*count/3)))}var mode,type,size;this.setMode=setMode,this.setIndex=setIndex,this.render=render,this.renderInstances=renderInstances},THREE.WebGLExtensions=function(gl){var extensions={};this.get=function(name){if(void 0!==extensions[name])return extensions[name];var extension;switch(name){case"WEBGL_depth_texture":extension=gl.getExtension("WEBGL_depth_texture")||gl.getExtension("MOZ_WEBGL_depth_texture")||gl.getExtension("WEBKIT_WEBGL_depth_texture");case"EXT_texture_filter_anisotropic":extension=gl.getExtension("EXT_texture_filter_anisotropic")||gl.getExtension("MOZ_EXT_texture_filter_anisotropic")||gl.getExtension("WEBKIT_EXT_texture_filter_anisotropic");break;case"WEBGL_compressed_texture_s3tc":extension=gl.getExtension("WEBGL_compressed_texture_s3tc")||gl.getExtension("MOZ_WEBGL_compressed_texture_s3tc")||gl.getExtension("WEBKIT_WEBGL_compressed_texture_s3tc");break;case"WEBGL_compressed_texture_pvrtc":extension=gl.getExtension("WEBGL_compressed_texture_pvrtc")||gl.getExtension("WEBKIT_WEBGL_compressed_texture_pvrtc");break;case"WEBGL_compressed_texture_etc1":extension=gl.getExtension("WEBGL_compressed_texture_etc1");break;default:extension=gl.getExtension(name)}return null===extension&&console.warn("THREE.WebGLRenderer: "+name+" extension not supported."),extensions[name]=extension,extension}},THREE.WebGLCapabilities=function(gl,extensions,parameters){function getMaxPrecision(precision){if("highp"===precision){if(gl.getShaderPrecisionFormat(gl.VERTEX_SHADER,gl.HIGH_FLOAT).precision>0&&gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER,gl.HIGH_FLOAT).precision>0)return"highp";precision="mediump"}return"mediump"===precision&&gl.getShaderPrecisionFormat(gl.VERTEX_SHADER,gl.MEDIUM_FLOAT).precision>0&&gl.getShaderPrecisionFormat(gl.FRAGMENT_SHADER,gl.MEDIUM_FLOAT).precision>0?"mediump":"lowp"}this.getMaxPrecision=getMaxPrecision,this.precision=void 0!==parameters.precision?parameters.precision:"highp",this.logarithmicDepthBuffer=void 0!==parameters.logarithmicDepthBuffer?parameters.logarithmicDepthBuffer:!1,this.maxTextures=gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS),this.maxVertexTextures=gl.getParameter(gl.MAX_VERTEX_TEXTURE_IMAGE_UNITS),this.maxTextureSize=gl.getParameter(gl.MAX_TEXTURE_SIZE),this.maxCubemapSize=gl.getParameter(gl.MAX_CUBE_MAP_TEXTURE_SIZE),this.maxAttributes=gl.getParameter(gl.MAX_VERTEX_ATTRIBS),this.maxVertexUniforms=gl.getParameter(gl.MAX_VERTEX_UNIFORM_VECTORS),this.maxVaryings=gl.getParameter(gl.MAX_VARYING_VECTORS),this.maxFragmentUniforms=gl.getParameter(gl.MAX_FRAGMENT_UNIFORM_VECTORS),this.vertexTextures=this.maxVertexTextures>0,this.floatFragmentTextures=!!extensions.get("OES_texture_float"),this.floatVertexTextures=this.vertexTextures&&this.floatFragmentTextures;var _maxPrecision=getMaxPrecision(this.precision);_maxPrecision!==this.precision&&(console.warn("THREE.WebGLRenderer:",this.precision,"not supported, using",_maxPrecision,"instead."),this.precision=_maxPrecision),this.logarithmicDepthBuffer&&(this.logarithmicDepthBuffer=!!extensions.get("EXT_frag_depth"))},THREE.WebGLGeometries=function(gl,properties,info){function get(object){var geometry=object.geometry;if(void 0!==geometries[geometry.id])return geometries[geometry.id];geometry.addEventListener("dispose",onGeometryDispose);var buffergeometry;return geometry instanceof THREE.BufferGeometry?buffergeometry=geometry:geometry instanceof THREE.Geometry&&(void 0===geometry._bufferGeometry&&(geometry._bufferGeometry=(new THREE.BufferGeometry).setFromObject(object)),buffergeometry=geometry._bufferGeometry),geometries[geometry.id]=buffergeometry,info.memory.geometries++,buffergeometry}function onGeometryDispose(event){var geometry=event.target,buffergeometry=geometries[geometry.id];null!==buffergeometry.index&&deleteAttribute(buffergeometry.index),deleteAttributes(buffergeometry.attributes),geometry.removeEventListener("dispose",onGeometryDispose),delete geometries[geometry.id];var property=properties.get(geometry);property.wireframe&&deleteAttribute(property.wireframe),properties["delete"](geometry);var bufferproperty=properties.get(buffergeometry);bufferproperty.wireframe&&deleteAttribute(bufferproperty.wireframe),properties["delete"](buffergeometry),info.memory.geometries--}function getAttributeBuffer(attribute){return attribute instanceof THREE.InterleavedBufferAttribute?properties.get(attribute.data).__webglBuffer:properties.get(attribute).__webglBuffer}function deleteAttribute(attribute){var buffer=getAttributeBuffer(attribute);void 0!==buffer&&(gl.deleteBuffer(buffer),removeAttributeBuffer(attribute))}function deleteAttributes(attributes){for(var name in attributes)deleteAttribute(attributes[name])}function removeAttributeBuffer(attribute){attribute instanceof THREE.InterleavedBufferAttribute?properties["delete"](attribute.data):properties["delete"](attribute)}var geometries={};this.get=get},THREE.WebGLLights=function(){var lights={};this.get=function(light){if(void 0!==lights[light.id])return lights[light.id];var uniforms;switch(light.type){case"DirectionalLight":uniforms={direction:new THREE.Vector3,color:new THREE.Color,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case"SpotLight":uniforms={position:new THREE.Vector3,direction:new THREE.Vector3,color:new THREE.Color,distance:0,coneCos:0,penumbraCos:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case"PointLight":uniforms={position:new THREE.Vector3,color:new THREE.Color,distance:0,decay:0,shadow:!1,shadowBias:0,shadowRadius:1,shadowMapSize:new THREE.Vector2};break;case"HemisphereLight":uniforms={direction:new THREE.Vector3,skyColor:new THREE.Color,groundColor:new THREE.Color}}return lights[light.id]=uniforms,uniforms}},THREE.WebGLObjects=function(gl,properties,info){function update(object){var geometry=geometries.get(object);object.geometry instanceof THREE.Geometry&&geometry.updateFromObject(object);var index=geometry.index,attributes=geometry.attributes;null!==index&&updateAttribute(index,gl.ELEMENT_ARRAY_BUFFER);for(var name in attributes)updateAttribute(attributes[name],gl.ARRAY_BUFFER);var morphAttributes=geometry.morphAttributes;for(var name in morphAttributes)for(var array=morphAttributes[name],i=0,l=array.length;l>i;i++)updateAttribute(array[i],gl.ARRAY_BUFFER);return geometry}function updateAttribute(attribute,bufferType){var data=attribute instanceof THREE.InterleavedBufferAttribute?attribute.data:attribute,attributeProperties=properties.get(data);void 0===attributeProperties.__webglBuffer?createBuffer(attributeProperties,data,bufferType):attributeProperties.version!==data.version&&updateBuffer(attributeProperties,data,bufferType)}function createBuffer(attributeProperties,data,bufferType){attributeProperties.__webglBuffer=gl.createBuffer(),gl.bindBuffer(bufferType,attributeProperties.__webglBuffer);var usage=data.dynamic?gl.DYNAMIC_DRAW:gl.STATIC_DRAW;gl.bufferData(bufferType,data.array,usage),attributeProperties.version=data.version}function updateBuffer(attributeProperties,data,bufferType){gl.bindBuffer(bufferType,attributeProperties.__webglBuffer),data.dynamic===!1||-1===data.updateRange.count?gl.bufferSubData(bufferType,0,data.array):0===data.updateRange.count?console.error("THREE.WebGLObjects.updateBuffer: dynamic THREE.BufferAttribute marked as needsUpdate but updateRange.count is 0, ensure you are using set methods or updating manually."):(gl.bufferSubData(bufferType,data.updateRange.offset*data.array.BYTES_PER_ELEMENT,data.array.subarray(data.updateRange.offset,data.updateRange.offset+data.updateRange.count)),data.updateRange.count=0),attributeProperties.version=data.version}function getAttributeBuffer(attribute){return attribute instanceof THREE.InterleavedBufferAttribute?properties.get(attribute.data).__webglBuffer:properties.get(attribute).__webglBuffer}function getWireframeAttribute(geometry){var property=properties.get(geometry);if(void 0!==property.wireframe)return property.wireframe;var indices=[],index=geometry.index,attributes=geometry.attributes,position=attributes.position;if(null!==index)for(var edges={},array=index.array,i=0,l=array.length;l>i;i+=3){var a=array[i+0],b=array[i+1],c=array[i+2];checkEdge(edges,a,b)&&indices.push(a,b),checkEdge(edges,b,c)&&indices.push(b,c),checkEdge(edges,c,a)&&indices.push(c,a)}else for(var array=attributes.position.array,i=0,l=array.length/3-1;l>i;i+=3){var a=i+0,b=i+1,c=i+2;indices.push(a,b,b,c,c,a)}var TypeArray=position.count>65535?Uint32Array:Uint16Array,attribute=new THREE.BufferAttribute(new TypeArray(indices),1);return updateAttribute(attribute,gl.ELEMENT_ARRAY_BUFFER),property.wireframe=attribute,attribute}function checkEdge(edges,a,b){if(a>b){var tmp=a;a=b,b=tmp}var list=edges[a];return void 0===list?(edges[a]=[b],!0):-1===list.indexOf(b)?(list.push(b),!0):!1}var geometries=new THREE.WebGLGeometries(gl,properties,info);this.getAttributeBuffer=getAttributeBuffer,this.getWireframeAttribute=getWireframeAttribute,this.update=update},THREE.WebGLProgram=function(){function getEncodingComponents(encoding){switch(encoding){case THREE.LinearEncoding:return["Linear","( value )"];case THREE.sRGBEncoding:return["sRGB","( value )"];case THREE.RGBEEncoding:return["RGBE","( value )"];case THREE.RGBM7Encoding:return["RGBM","( value, 7.0 )"];case THREE.RGBM16Encoding:return["RGBM","( value, 16.0 )"];case THREE.RGBDEncoding:return["RGBD","( value, 256.0 )"];case THREE.GammaEncoding:return["Gamma","( value, float( GAMMA_FACTOR ) )"];default:throw new Error("unsupported encoding: "+encoding)}}function getTexelDecodingFunction(functionName,encoding){var components=getEncodingComponents(encoding);return"vec4 "+functionName+"( vec4 value ) { return "+components[0]+"ToLinear"+components[1]+"; }"}function getTexelEncodingFunction(functionName,encoding){var components=getEncodingComponents(encoding);return"vec4 "+functionName+"( vec4 value ) { return LinearTo"+components[0]+components[1]+"; }"}function getToneMappingFunction(functionName,toneMapping){var toneMappingName;switch(toneMapping){case THREE.LinearToneMapping:toneMappingName="Linear";break;case THREE.ReinhardToneMapping:toneMappingName="Reinhard";break;case THREE.Uncharted2ToneMapping:toneMappingName="Uncharted2";break;case THREE.CineonToneMapping:toneMappingName="OptimizedCineon";break;default:throw new Error("unsupported toneMapping: "+toneMapping)}return"vec3 "+functionName+"( vec3 color ) { return "+toneMappingName+"ToneMapping( color ); }"}function generateExtensions(extensions,parameters,rendererExtensions){extensions=extensions||{};var chunks=[extensions.derivatives||parameters.envMapCubeUV||parameters.bumpMap||parameters.normalMap||parameters.flatShading?"#extension GL_OES_standard_derivatives : enable":"",(extensions.fragDepth||parameters.logarithmicDepthBuffer)&&rendererExtensions.get("EXT_frag_depth")?"#extension GL_EXT_frag_depth : enable":"",extensions.drawBuffers&&rendererExtensions.get("WEBGL_draw_buffers")?"#extension GL_EXT_draw_buffers : require":"",(extensions.shaderTextureLOD||parameters.envMap)&&rendererExtensions.get("EXT_shader_texture_lod")?"#extension GL_EXT_shader_texture_lod : enable":""];return chunks.filter(filterEmptyLine).join("\n")}function generateDefines(defines){var chunks=[];for(var name in defines){var value=defines[name];value!==!1&&chunks.push("#define "+name+" "+value)}return chunks.join("\n")}function fetchAttributeLocations(gl,program,identifiers){for(var attributes={},n=gl.getProgramParameter(program,gl.ACTIVE_ATTRIBUTES),i=0;n>i;i++){var info=gl.getActiveAttrib(program,i),name=info.name;attributes[name]=gl.getAttribLocation(program,name)}return attributes}function filterEmptyLine(string){return""!==string}function replaceLightNums(string,parameters){return string.replace(/NUM_DIR_LIGHTS/g,parameters.numDirLights).replace(/NUM_SPOT_LIGHTS/g,parameters.numSpotLights).replace(/NUM_POINT_LIGHTS/g,parameters.numPointLights).replace(/NUM_HEMI_LIGHTS/g,parameters.numHemiLights)}function parseIncludes(string){function replace(match,include){var replace=THREE.ShaderChunk[include];if(void 0===replace)throw new Error("Can not resolve #include <"+include+">");return parseIncludes(replace)}var pattern=/#include +<([\w\d.]+)>/g;return string.replace(pattern,replace)}function unrollLoops(string){function replace(match,start,end,snippet){for(var unroll="",i=parseInt(start);i<parseInt(end);i++)unroll+=snippet.replace(/\[ i \]/g,"[ "+i+" ]");return unroll}var pattern=/for \( int i \= (\d+)\; i < (\d+)\; i \+\+ \) \{([\s\S]+?)(?=\})\}/g;return string.replace(pattern,replace)}var programIdCount=0;return function(renderer,code,material,parameters){var gl=renderer.context,extensions=material.extensions,defines=material.defines,vertexShader=material.__webglShader.vertexShader,fragmentShader=material.__webglShader.fragmentShader,shadowMapTypeDefine="SHADOWMAP_TYPE_BASIC";parameters.shadowMapType===THREE.PCFShadowMap?shadowMapTypeDefine="SHADOWMAP_TYPE_PCF":parameters.shadowMapType===THREE.PCFSoftShadowMap&&(shadowMapTypeDefine="SHADOWMAP_TYPE_PCF_SOFT");var envMapTypeDefine="ENVMAP_TYPE_CUBE",envMapModeDefine="ENVMAP_MODE_REFLECTION",envMapBlendingDefine="ENVMAP_BLENDING_MULTIPLY";if(parameters.envMap){switch(material.envMap.mapping){case THREE.CubeReflectionMapping:case THREE.CubeRefractionMapping:envMapTypeDefine="ENVMAP_TYPE_CUBE";break;case THREE.CubeUVReflectionMapping:case THREE.CubeUVRefractionMapping:envMapTypeDefine="ENVMAP_TYPE_CUBE_UV";break;case THREE.EquirectangularReflectionMapping:case THREE.EquirectangularRefractionMapping:envMapTypeDefine="ENVMAP_TYPE_EQUIREC";break;case THREE.SphericalReflectionMapping:envMapTypeDefine="ENVMAP_TYPE_SPHERE"}switch(material.envMap.mapping){case THREE.CubeRefractionMapping:case THREE.EquirectangularRefractionMapping:envMapModeDefine="ENVMAP_MODE_REFRACTION"}switch(material.combine){case THREE.MultiplyOperation:envMapBlendingDefine="ENVMAP_BLENDING_MULTIPLY";break;case THREE.MixOperation:envMapBlendingDefine="ENVMAP_BLENDING_MIX";break;case THREE.AddOperation:envMapBlendingDefine="ENVMAP_BLENDING_ADD"}}var prefixVertex,prefixFragment,gammaFactorDefine=renderer.gammaFactor>0?renderer.gammaFactor:1,customExtensions=generateExtensions(extensions,parameters,renderer.extensions),customDefines=generateDefines(defines),program=gl.createProgram();material instanceof THREE.RawShaderMaterial?(prefixVertex="",prefixFragment=""):(prefixVertex=["precision "+parameters.precision+" float;","precision "+parameters.precision+" int;","#define SHADER_NAME "+material.__webglShader.name,customDefines,parameters.supportsVertexTextures?"#define VERTEX_TEXTURES":"","#define GAMMA_FACTOR "+gammaFactorDefine,"#define MAX_BONES "+parameters.maxBones,parameters.map?"#define USE_MAP":"",parameters.envMap?"#define USE_ENVMAP":"",parameters.envMap?"#define "+envMapModeDefine:"",parameters.lightMap?"#define USE_LIGHTMAP":"",parameters.aoMap?"#define USE_AOMAP":"",parameters.emissiveMap?"#define USE_EMISSIVEMAP":"",parameters.bumpMap?"#define USE_BUMPMAP":"",parameters.normalMap?"#define USE_NORMALMAP":"",parameters.displacementMap&&parameters.supportsVertexTextures?"#define USE_DISPLACEMENTMAP":"",parameters.specularMap?"#define USE_SPECULARMAP":"",parameters.roughnessMap?"#define USE_ROUGHNESSMAP":"",parameters.metalnessMap?"#define USE_METALNESSMAP":"",parameters.alphaMap?"#define USE_ALPHAMAP":"",parameters.vertexColors?"#define USE_COLOR":"",parameters.flatShading?"#define FLAT_SHADED":"",parameters.skinning?"#define USE_SKINNING":"",parameters.useVertexTexture?"#define BONE_TEXTURE":"",parameters.morphTargets?"#define USE_MORPHTARGETS":"",parameters.morphNormals&&parameters.flatShading===!1?"#define USE_MORPHNORMALS":"",parameters.doubleSided?"#define DOUBLE_SIDED":"",parameters.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+parameters.numClippingPlanes,parameters.shadowMapEnabled?"#define USE_SHADOWMAP":"",parameters.shadowMapEnabled?"#define "+shadowMapTypeDefine:"",parameters.sizeAttenuation?"#define USE_SIZEATTENUATION":"",parameters.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",parameters.logarithmicDepthBuffer&&renderer.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"","uniform mat4 modelMatrix;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform mat4 viewMatrix;","uniform mat3 normalMatrix;","uniform vec3 cameraPosition;","attribute vec3 position;","attribute vec3 normal;","attribute vec2 uv;","#ifdef USE_COLOR","	attribute vec3 color;","#endif","#ifdef USE_MORPHTARGETS","	attribute vec3 morphTarget0;","	attribute vec3 morphTarget1;","	attribute vec3 morphTarget2;","	attribute vec3 morphTarget3;","	#ifdef USE_MORPHNORMALS","		attribute vec3 morphNormal0;","		attribute vec3 morphNormal1;","		attribute vec3 morphNormal2;","		attribute vec3 morphNormal3;","	#else","		attribute vec3 morphTarget4;","		attribute vec3 morphTarget5;","		attribute vec3 morphTarget6;","		attribute vec3 morphTarget7;","	#endif","#endif","#ifdef USE_SKINNING","	attribute vec4 skinIndex;","	attribute vec4 skinWeight;","#endif","\n"].filter(filterEmptyLine).join("\n"),prefixFragment=[customExtensions,"precision "+parameters.precision+" float;","precision "+parameters.precision+" int;","#define SHADER_NAME "+material.__webglShader.name,customDefines,parameters.alphaTest?"#define ALPHATEST "+parameters.alphaTest:"","#define GAMMA_FACTOR "+gammaFactorDefine,parameters.useFog&&parameters.fog?"#define USE_FOG":"",parameters.useFog&&parameters.fogExp?"#define FOG_EXP2":"",parameters.map?"#define USE_MAP":"",parameters.envMap?"#define USE_ENVMAP":"",parameters.envMap?"#define "+envMapTypeDefine:"",parameters.envMap?"#define "+envMapModeDefine:"",parameters.envMap?"#define "+envMapBlendingDefine:"",parameters.lightMap?"#define USE_LIGHTMAP":"",parameters.aoMap?"#define USE_AOMAP":"",parameters.emissiveMap?"#define USE_EMISSIVEMAP":"",parameters.bumpMap?"#define USE_BUMPMAP":"",parameters.normalMap?"#define USE_NORMALMAP":"",parameters.specularMap?"#define USE_SPECULARMAP":"",parameters.roughnessMap?"#define USE_ROUGHNESSMAP":"",parameters.metalnessMap?"#define USE_METALNESSMAP":"",parameters.alphaMap?"#define USE_ALPHAMAP":"",parameters.vertexColors?"#define USE_COLOR":"",parameters.flatShading?"#define FLAT_SHADED":"",parameters.doubleSided?"#define DOUBLE_SIDED":"",parameters.flipSided?"#define FLIP_SIDED":"","#define NUM_CLIPPING_PLANES "+parameters.numClippingPlanes,parameters.shadowMapEnabled?"#define USE_SHADOWMAP":"",parameters.shadowMapEnabled?"#define "+shadowMapTypeDefine:"",parameters.premultipliedAlpha?"#define PREMULTIPLIED_ALPHA":"",parameters.physicallyCorrectLights?"#define PHYSICALLY_CORRECT_LIGHTS":"",parameters.logarithmicDepthBuffer?"#define USE_LOGDEPTHBUF":"",parameters.logarithmicDepthBuffer&&renderer.extensions.get("EXT_frag_depth")?"#define USE_LOGDEPTHBUF_EXT":"",parameters.envMap&&renderer.extensions.get("EXT_shader_texture_lod")?"#define TEXTURE_LOD_EXT":"","uniform mat4 viewMatrix;","uniform vec3 cameraPosition;",parameters.toneMapping!==THREE.NoToneMapping?"#define TONE_MAPPING":"",parameters.toneMapping!==THREE.NoToneMapping?THREE.ShaderChunk.tonemapping_pars_fragment:"",parameters.toneMapping!==THREE.NoToneMapping?getToneMappingFunction("toneMapping",parameters.toneMapping):"",parameters.outputEncoding||parameters.mapEncoding||parameters.envMapEncoding||parameters.emissiveMapEncoding?THREE.ShaderChunk.encodings_pars_fragment:"",parameters.mapEncoding?getTexelDecodingFunction("mapTexelToLinear",parameters.mapEncoding):"",parameters.envMapEncoding?getTexelDecodingFunction("envMapTexelToLinear",parameters.envMapEncoding):"",parameters.emissiveMapEncoding?getTexelDecodingFunction("emissiveMapTexelToLinear",parameters.emissiveMapEncoding):"",parameters.outputEncoding?getTexelEncodingFunction("linearToOutputTexel",parameters.outputEncoding):"",parameters.depthPacking?"#define DEPTH_PACKING "+material.depthPacking:"","\n"].filter(filterEmptyLine).join("\n")),vertexShader=parseIncludes(vertexShader,parameters),vertexShader=replaceLightNums(vertexShader,parameters),fragmentShader=parseIncludes(fragmentShader,parameters),fragmentShader=replaceLightNums(fragmentShader,parameters),material instanceof THREE.ShaderMaterial==!1&&(vertexShader=unrollLoops(vertexShader),fragmentShader=unrollLoops(fragmentShader));var vertexGlsl=prefixVertex+vertexShader,fragmentGlsl=prefixFragment+fragmentShader,glVertexShader=THREE.WebGLShader(gl,gl.VERTEX_SHADER,vertexGlsl),glFragmentShader=THREE.WebGLShader(gl,gl.FRAGMENT_SHADER,fragmentGlsl);gl.attachShader(program,glVertexShader),gl.attachShader(program,glFragmentShader),void 0!==material.index0AttributeName?gl.bindAttribLocation(program,0,material.index0AttributeName):parameters.morphTargets===!0&&gl.bindAttribLocation(program,0,"position"),gl.linkProgram(program);var programLog=gl.getProgramInfoLog(program),vertexLog=gl.getShaderInfoLog(glVertexShader),fragmentLog=gl.getShaderInfoLog(glFragmentShader),runnable=!0,haveDiagnostics=!0;gl.getProgramParameter(program,gl.LINK_STATUS)===!1?(runnable=!1,console.error("THREE.WebGLProgram: shader error: ",gl.getError(),"gl.VALIDATE_STATUS",gl.getProgramParameter(program,gl.VALIDATE_STATUS),"gl.getProgramInfoLog",programLog,vertexLog,fragmentLog)):""!==programLog?console.warn("THREE.WebGLProgram: gl.getProgramInfoLog()",programLog):""!==vertexLog&&""!==fragmentLog||(haveDiagnostics=!1),haveDiagnostics&&(this.diagnostics={runnable:runnable,material:material,programLog:programLog,vertexShader:{log:vertexLog,prefix:prefixVertex},fragmentShader:{log:fragmentLog,prefix:prefixFragment}}),gl.deleteShader(glVertexShader),gl.deleteShader(glFragmentShader);var cachedUniforms;this.getUniforms=function(){return void 0===cachedUniforms&&(cachedUniforms=new THREE.WebGLUniforms(gl,program,renderer)),cachedUniforms};var cachedAttributes;return this.getAttributes=function(){return void 0===cachedAttributes&&(cachedAttributes=fetchAttributeLocations(gl,program)),cachedAttributes},this.destroy=function(){gl.deleteProgram(program),this.program=void 0},Object.defineProperties(this,{uniforms:{get:function(){return console.warn("THREE.WebGLProgram: .uniforms is now .getUniforms()."),this.getUniforms()}},attributes:{get:function(){return console.warn("THREE.WebGLProgram: .attributes is now .getAttributes()."),this.getAttributes()}}}),this.id=programIdCount++,this.code=code,this.usedTimes=1,this.program=program,this.vertexShader=glVertexShader,this.fragmentShader=glFragmentShader,this}}(),THREE.WebGLPrograms=function(renderer,capabilities){function allocateBones(object){if(capabilities.floatVertexTextures&&object&&object.skeleton&&object.skeleton.useVertexTexture)return 1024;var nVertexUniforms=capabilities.maxVertexUniforms,nVertexMatrices=Math.floor((nVertexUniforms-20)/4),maxBones=nVertexMatrices;return void 0!==object&&object instanceof THREE.SkinnedMesh&&(maxBones=Math.min(object.skeleton.bones.length,maxBones),maxBones<object.skeleton.bones.length&&console.warn("WebGLRenderer: too many bones - "+object.skeleton.bones.length+", this GPU supports just "+maxBones+" (try OpenGL instead of ANGLE)")),maxBones}function getTextureEncodingFromMap(map,gammaOverrideLinear){var encoding;return map?map instanceof THREE.Texture?encoding=map.encoding:map instanceof THREE.WebGLRenderTarget&&(encoding=map.texture.encoding):encoding=THREE.LinearEncoding,encoding===THREE.LinearEncoding&&gammaOverrideLinear&&(encoding=THREE.GammaEncoding),encoding}var programs=[],shaderIDs={MeshDepthMaterial:"depth",MeshNormalMaterial:"normal",MeshBasicMaterial:"basic",MeshLambertMaterial:"lambert",MeshPhongMaterial:"phong",MeshStandardMaterial:"physical",MeshPhysicalMaterial:"physical",LineBasicMaterial:"basic",LineDashedMaterial:"dashed",PointsMaterial:"points"},parameterNames=["precision","supportsVertexTextures","map","mapEncoding","envMap","envMapMode","envMapEncoding","lightMap","aoMap","emissiveMap","emissiveMapEncoding","bumpMap","normalMap","displacementMap","specularMap","roughnessMap","metalnessMap","alphaMap","combine","vertexColors","fog","useFog","fogExp","flatShading","sizeAttenuation","logarithmicDepthBuffer","skinning","maxBones","useVertexTexture","morphTargets","morphNormals","maxMorphTargets","maxMorphNormals","premultipliedAlpha","numDirLights","numPointLights","numSpotLights","numHemiLights","shadowMapEnabled","shadowMapType","toneMapping","physicallyCorrectLights","alphaTest","doubleSided","flipSided","numClippingPlanes","depthPacking"];this.getParameters=function(material,lights,fog,nClipPlanes,object){var shaderID=shaderIDs[material.type],maxBones=allocateBones(object),precision=renderer.getPrecision();null!==material.precision&&(precision=capabilities.getMaxPrecision(material.precision),precision!==material.precision&&console.warn("THREE.WebGLProgram.getParameters:",material.precision,"not supported, using",precision,"instead."));var parameters={shaderID:shaderID,precision:precision,supportsVertexTextures:capabilities.vertexTextures,outputEncoding:getTextureEncodingFromMap(renderer.getCurrentRenderTarget(),renderer.gammaOutput),map:!!material.map,mapEncoding:getTextureEncodingFromMap(material.map,renderer.gammaInput),envMap:!!material.envMap,envMapMode:material.envMap&&material.envMap.mapping,envMapEncoding:getTextureEncodingFromMap(material.envMap,renderer.gammaInput),envMapCubeUV:!!material.envMap&&(material.envMap.mapping===THREE.CubeUVReflectionMapping||material.envMap.mapping===THREE.CubeUVRefractionMapping),lightMap:!!material.lightMap,aoMap:!!material.aoMap,emissiveMap:!!material.emissiveMap,emissiveMapEncoding:getTextureEncodingFromMap(material.emissiveMap,renderer.gammaInput),bumpMap:!!material.bumpMap,normalMap:!!material.normalMap,displacementMap:!!material.displacementMap,roughnessMap:!!material.roughnessMap,metalnessMap:!!material.metalnessMap,specularMap:!!material.specularMap,alphaMap:!!material.alphaMap,combine:material.combine,vertexColors:material.vertexColors,fog:fog,useFog:material.fog,fogExp:fog instanceof THREE.FogExp2,flatShading:material.shading===THREE.FlatShading,sizeAttenuation:material.sizeAttenuation,logarithmicDepthBuffer:capabilities.logarithmicDepthBuffer,skinning:material.skinning,maxBones:maxBones,useVertexTexture:capabilities.floatVertexTextures&&object&&object.skeleton&&object.skeleton.useVertexTexture,morphTargets:material.morphTargets,morphNormals:material.morphNormals,maxMorphTargets:renderer.maxMorphTargets,maxMorphNormals:renderer.maxMorphNormals,numDirLights:lights.directional.length,numPointLights:lights.point.length,numSpotLights:lights.spot.length,numHemiLights:lights.hemi.length,numClippingPlanes:nClipPlanes,shadowMapEnabled:renderer.shadowMap.enabled&&object.receiveShadow&&lights.shadows.length>0,shadowMapType:renderer.shadowMap.type,toneMapping:renderer.toneMapping,physicallyCorrectLights:renderer.physicallyCorrectLights,premultipliedAlpha:material.premultipliedAlpha,alphaTest:material.alphaTest,doubleSided:material.side===THREE.DoubleSide,flipSided:material.side===THREE.BackSide,depthPacking:void 0!==material.depthPacking?material.depthPacking:!1};return parameters},this.getProgramCode=function(material,parameters){var array=[];if(parameters.shaderID?array.push(parameters.shaderID):(array.push(material.fragmentShader),array.push(material.vertexShader)),void 0!==material.defines)for(var name in material.defines)array.push(name),array.push(material.defines[name]);for(var i=0;i<parameterNames.length;i++)array.push(parameters[parameterNames[i]]);return array.join()},this.acquireProgram=function(material,parameters,code){for(var program,p=0,pl=programs.length;pl>p;p++){var programInfo=programs[p];if(programInfo.code===code){program=programInfo,++program.usedTimes;break}}return void 0===program&&(program=new THREE.WebGLProgram(renderer,code,material,parameters),programs.push(program)),program},this.releaseProgram=function(program){if(0===--program.usedTimes){var i=programs.indexOf(program);programs[i]=programs[programs.length-1],programs.pop(),program.destroy()}},this.programs=programs},THREE.WebGLProperties=function(){var properties={};this.get=function(object){var uuid=object.uuid,map=properties[uuid];return void 0===map&&(map={},properties[uuid]=map),map},this["delete"]=function(object){delete properties[object.uuid]},this.clear=function(){properties={}}},THREE.WebGLShader=function(){function addLineNumbers(string){
for(var lines=string.split("\n"),i=0;i<lines.length;i++)lines[i]=i+1+": "+lines[i];return lines.join("\n")}return function(gl,type,string){var shader=gl.createShader(type);return gl.shaderSource(shader,string),gl.compileShader(shader),gl.getShaderParameter(shader,gl.COMPILE_STATUS)===!1&&console.error("THREE.WebGLShader: Shader couldn't compile."),""!==gl.getShaderInfoLog(shader)&&console.warn("THREE.WebGLShader: gl.getShaderInfoLog()",type===gl.VERTEX_SHADER?"vertex":"fragment",gl.getShaderInfoLog(shader),addLineNumbers(string)),shader}}(),THREE.WebGLShadowMap=function(_renderer,_lights,_objects){function getDepthMaterial(object,material,isPointLight,lightPositionWorld){var geometry=object.geometry,result=null,materialVariants=_depthMaterials,customMaterial=object.customDepthMaterial;if(isPointLight&&(materialVariants=_distanceMaterials,customMaterial=object.customDistanceMaterial),customMaterial)result=customMaterial;else{var useMorphing=void 0!==geometry.morphTargets&&geometry.morphTargets.length>0&&material.morphTargets,useSkinning=object instanceof THREE.SkinnedMesh&&material.skinning,variantIndex=0;useMorphing&&(variantIndex|=_MorphingFlag),useSkinning&&(variantIndex|=_SkinningFlag),result=materialVariants[variantIndex]}if(_renderer.localClippingEnabled&&material.clipShadows===!0&&0!==material.clippingPlanes.length){var keyA=result.uuid,keyB=material.uuid,materialsForVariant=_materialCache[keyA];void 0===materialsForVariant&&(materialsForVariant={},_materialCache[keyA]=materialsForVariant);var cachedMaterial=materialsForVariant[keyB];void 0===cachedMaterial&&(cachedMaterial=result.clone(),materialsForVariant[keyB]=cachedMaterial),result=cachedMaterial}return result.visible=material.visible,result.wireframe=material.wireframe,result.side=material.side,result.clipShadows=material.clipShadows,result.clippingPlanes=material.clippingPlanes,result.wireframeLinewidth=material.wireframeLinewidth,result.linewidth=material.linewidth,isPointLight&&void 0!==result.uniforms.lightPos&&result.uniforms.lightPos.value.copy(lightPositionWorld),result}function projectObject(object,camera,shadowCamera){if(object.visible!==!1){if(object.layers.test(camera.layers)&&(object instanceof THREE.Mesh||object instanceof THREE.Line||object instanceof THREE.Points)&&object.castShadow&&(object.frustumCulled===!1||_frustum.intersectsObject(object)===!0)){var material=object.material;material.visible===!0&&(object.modelViewMatrix.multiplyMatrices(shadowCamera.matrixWorldInverse,object.matrixWorld),_renderList.push(object))}for(var children=object.children,i=0,l=children.length;l>i;i++)projectObject(children[i],camera,shadowCamera)}}var _gl=_renderer.context,_state=_renderer.state,_frustum=new THREE.Frustum,_projScreenMatrix=new THREE.Matrix4,_lightShadows=_lights.shadows,_shadowMapSize=new THREE.Vector2,_lookTarget=new THREE.Vector3,_lightPositionWorld=new THREE.Vector3,_renderList=[],_MorphingFlag=1,_SkinningFlag=2,_NumberOfMaterialVariants=(_MorphingFlag|_SkinningFlag)+1,_depthMaterials=new Array(_NumberOfMaterialVariants),_distanceMaterials=new Array(_NumberOfMaterialVariants),_materialCache={},cubeDirections=[new THREE.Vector3(1,0,0),new THREE.Vector3(-1,0,0),new THREE.Vector3(0,0,1),new THREE.Vector3(0,0,-1),new THREE.Vector3(0,1,0),new THREE.Vector3(0,-1,0)],cubeUps=[new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,1,0),new THREE.Vector3(0,0,1),new THREE.Vector3(0,0,-1)],cube2DViewPorts=[new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4,new THREE.Vector4],depthMaterialTemplate=new THREE.MeshDepthMaterial;depthMaterialTemplate.depthPacking=THREE.RGBADepthPacking,depthMaterialTemplate.clipping=!0;for(var distanceShader=THREE.ShaderLib.distanceRGBA,distanceUniforms=THREE.UniformsUtils.clone(distanceShader.uniforms),i=0;i!==_NumberOfMaterialVariants;++i){var useMorphing=0!==(i&_MorphingFlag),useSkinning=0!==(i&_SkinningFlag),depthMaterial=depthMaterialTemplate.clone();depthMaterial.morphTargets=useMorphing,depthMaterial.skinning=useSkinning,_depthMaterials[i]=depthMaterial;var distanceMaterial=new THREE.ShaderMaterial({defines:{USE_SHADOWMAP:""},uniforms:distanceUniforms,vertexShader:distanceShader.vertexShader,fragmentShader:distanceShader.fragmentShader,morphTargets:useMorphing,skinning:useSkinning,clipping:!0});_distanceMaterials[i]=distanceMaterial}var scope=this;this.enabled=!1,this.autoUpdate=!0,this.needsUpdate=!1,this.type=THREE.PCFShadowMap,this.cullFace=THREE.CullFaceFront,this.render=function(scene,camera){if(scope.enabled!==!1&&(scope.autoUpdate!==!1||scope.needsUpdate!==!1)&&0!==_lightShadows.length){_state.clearColor(1,1,1,1),_state.disable(_gl.BLEND),_state.enable(_gl.CULL_FACE),_gl.frontFace(_gl.CCW),_gl.cullFace(scope.cullFace===THREE.CullFaceFront?_gl.FRONT:_gl.BACK),_state.setDepthTest(!0),_state.setScissorTest(!1);for(var faceCount,isPointLight,i=0,il=_lightShadows.length;il>i;i++){var light=_lightShadows[i],shadow=light.shadow,shadowCamera=shadow.camera;if(_shadowMapSize.copy(shadow.mapSize),light instanceof THREE.PointLight){faceCount=6,isPointLight=!0;var vpWidth=_shadowMapSize.x,vpHeight=_shadowMapSize.y;cube2DViewPorts[0].set(2*vpWidth,vpHeight,vpWidth,vpHeight),cube2DViewPorts[1].set(0,vpHeight,vpWidth,vpHeight),cube2DViewPorts[2].set(3*vpWidth,vpHeight,vpWidth,vpHeight),cube2DViewPorts[3].set(vpWidth,vpHeight,vpWidth,vpHeight),cube2DViewPorts[4].set(3*vpWidth,0,vpWidth,vpHeight),cube2DViewPorts[5].set(vpWidth,0,vpWidth,vpHeight),_shadowMapSize.x*=4,_shadowMapSize.y*=2}else faceCount=1,isPointLight=!1;if(null===shadow.map){var pars={minFilter:THREE.NearestFilter,magFilter:THREE.NearestFilter,format:THREE.RGBAFormat};shadow.map=new THREE.WebGLRenderTarget(_shadowMapSize.x,_shadowMapSize.y,pars),shadowCamera.updateProjectionMatrix()}shadow instanceof THREE.SpotLightShadow&&shadow.update(light);var shadowMap=shadow.map,shadowMatrix=shadow.matrix;_lightPositionWorld.setFromMatrixPosition(light.matrixWorld),shadowCamera.position.copy(_lightPositionWorld),_renderer.setRenderTarget(shadowMap),_renderer.clear();for(var face=0;faceCount>face;face++){if(isPointLight){_lookTarget.copy(shadowCamera.position),_lookTarget.add(cubeDirections[face]),shadowCamera.up.copy(cubeUps[face]),shadowCamera.lookAt(_lookTarget);var vpDimensions=cube2DViewPorts[face];_state.viewport(vpDimensions)}else _lookTarget.setFromMatrixPosition(light.target.matrixWorld),shadowCamera.lookAt(_lookTarget);shadowCamera.updateMatrixWorld(),shadowCamera.matrixWorldInverse.getInverse(shadowCamera.matrixWorld),shadowMatrix.set(.5,0,0,.5,0,.5,0,.5,0,0,.5,.5,0,0,0,1),shadowMatrix.multiply(shadowCamera.projectionMatrix),shadowMatrix.multiply(shadowCamera.matrixWorldInverse),_projScreenMatrix.multiplyMatrices(shadowCamera.projectionMatrix,shadowCamera.matrixWorldInverse),_frustum.setFromMatrix(_projScreenMatrix),_renderList.length=0,projectObject(scene,camera,shadowCamera);for(var j=0,jl=_renderList.length;jl>j;j++){var object=_renderList[j],geometry=_objects.update(object),material=object.material;if(material instanceof THREE.MultiMaterial)for(var groups=geometry.groups,materials=material.materials,k=0,kl=groups.length;kl>k;k++){var group=groups[k],groupMaterial=materials[group.materialIndex];if(groupMaterial.visible===!0){var depthMaterial=getDepthMaterial(object,groupMaterial,isPointLight,_lightPositionWorld);_renderer.renderBufferDirect(shadowCamera,null,geometry,depthMaterial,object,group)}}else{var depthMaterial=getDepthMaterial(object,material,isPointLight,_lightPositionWorld);_renderer.renderBufferDirect(shadowCamera,null,geometry,depthMaterial,object,null)}}}}var clearColor=_renderer.getClearColor(),clearAlpha=_renderer.getClearAlpha();_renderer.setClearColor(clearColor,clearAlpha),_state.enable(_gl.BLEND),scope.cullFace===THREE.CullFaceFront&&_gl.cullFace(_gl.BACK),scope.needsUpdate=!1}}},THREE.WebGLState=function(gl,extensions,paramThreeToGL){var _this=this,color=new THREE.Vector4,maxVertexAttributes=gl.getParameter(gl.MAX_VERTEX_ATTRIBS),newAttributes=new Uint8Array(maxVertexAttributes),enabledAttributes=new Uint8Array(maxVertexAttributes),attributeDivisors=new Uint8Array(maxVertexAttributes),capabilities={},compressedTextureFormats=null,currentBlending=null,currentBlendEquation=null,currentBlendSrc=null,currentBlendDst=null,currentBlendEquationAlpha=null,currentBlendSrcAlpha=null,currentBlendDstAlpha=null,currentPremultipledAlpha=!1,currentDepthFunc=null,currentDepthWrite=null,currentColorWrite=null,currentStencilWrite=null,currentStencilFunc=null,currentStencilRef=null,currentStencilMask=null,currentStencilFail=null,currentStencilZFail=null,currentStencilZPass=null,currentFlipSided=null,currentLineWidth=null,currentPolygonOffsetFactor=null,currentPolygonOffsetUnits=null,currentScissorTest=null,maxTextures=gl.getParameter(gl.MAX_TEXTURE_IMAGE_UNITS),currentTextureSlot=void 0,currentBoundTextures={},currentClearColor=new THREE.Vector4,currentClearDepth=null,currentClearStencil=null,currentScissor=new THREE.Vector4,currentViewport=new THREE.Vector4;this.init=function(){this.clearColor(0,0,0,1),this.clearDepth(1),this.clearStencil(0),this.enable(gl.DEPTH_TEST),gl.depthFunc(gl.LEQUAL),gl.frontFace(gl.CCW),gl.cullFace(gl.BACK),this.enable(gl.CULL_FACE),this.enable(gl.BLEND),gl.blendEquation(gl.FUNC_ADD),gl.blendFunc(gl.SRC_ALPHA,gl.ONE_MINUS_SRC_ALPHA)},this.initAttributes=function(){for(var i=0,l=newAttributes.length;l>i;i++)newAttributes[i]=0},this.enableAttribute=function(attribute){if(newAttributes[attribute]=1,0===enabledAttributes[attribute]&&(gl.enableVertexAttribArray(attribute),enabledAttributes[attribute]=1),0!==attributeDivisors[attribute]){var extension=extensions.get("ANGLE_instanced_arrays");extension.vertexAttribDivisorANGLE(attribute,0),attributeDivisors[attribute]=0}},this.enableAttributeAndDivisor=function(attribute,meshPerAttribute,extension){newAttributes[attribute]=1,0===enabledAttributes[attribute]&&(gl.enableVertexAttribArray(attribute),enabledAttributes[attribute]=1),attributeDivisors[attribute]!==meshPerAttribute&&(extension.vertexAttribDivisorANGLE(attribute,meshPerAttribute),attributeDivisors[attribute]=meshPerAttribute)},this.disableUnusedAttributes=function(){for(var i=0,l=enabledAttributes.length;l>i;i++)enabledAttributes[i]!==newAttributes[i]&&(gl.disableVertexAttribArray(i),enabledAttributes[i]=0)},this.enable=function(id){capabilities[id]!==!0&&(gl.enable(id),capabilities[id]=!0)},this.disable=function(id){capabilities[id]!==!1&&(gl.disable(id),capabilities[id]=!1)},this.getCompressedTextureFormats=function(){if(null===compressedTextureFormats&&(compressedTextureFormats=[],extensions.get("WEBGL_compressed_texture_pvrtc")||extensions.get("WEBGL_compressed_texture_s3tc")||extensions.get("WEBGL_compressed_texture_etc1")))for(var formats=gl.getParameter(gl.COMPRESSED_TEXTURE_FORMATS),i=0;i<formats.length;i++)compressedTextureFormats.push(formats[i]);return compressedTextureFormats},this.setBlending=function(blending,blendEquation,blendSrc,blendDst,blendEquationAlpha,blendSrcAlpha,blendDstAlpha,premultipliedAlpha){blending===THREE.NoBlending?this.disable(gl.BLEND):this.enable(gl.BLEND),blending===currentBlending&&premultipliedAlpha===currentPremultipledAlpha||(blending===THREE.AdditiveBlending?premultipliedAlpha?(gl.blendEquationSeparate(gl.FUNC_ADD,gl.FUNC_ADD),gl.blendFuncSeparate(gl.ONE,gl.ONE,gl.ONE,gl.ONE)):(gl.blendEquation(gl.FUNC_ADD),gl.blendFunc(gl.SRC_ALPHA,gl.ONE)):blending===THREE.SubtractiveBlending?premultipliedAlpha?(gl.blendEquationSeparate(gl.FUNC_ADD,gl.FUNC_ADD),gl.blendFuncSeparate(gl.ZERO,gl.ZERO,gl.ONE_MINUS_SRC_COLOR,gl.ONE_MINUS_SRC_ALPHA)):(gl.blendEquation(gl.FUNC_ADD),gl.blendFunc(gl.ZERO,gl.ONE_MINUS_SRC_COLOR)):blending===THREE.MultiplyBlending?premultipliedAlpha?(gl.blendEquationSeparate(gl.FUNC_ADD,gl.FUNC_ADD),gl.blendFuncSeparate(gl.ZERO,gl.ZERO,gl.SRC_COLOR,gl.SRC_ALPHA)):(gl.blendEquation(gl.FUNC_ADD),gl.blendFunc(gl.ZERO,gl.SRC_COLOR)):premultipliedAlpha?(gl.blendEquationSeparate(gl.FUNC_ADD,gl.FUNC_ADD),gl.blendFuncSeparate(gl.ONE,gl.ONE_MINUS_SRC_ALPHA,gl.ONE,gl.ONE_MINUS_SRC_ALPHA)):(gl.blendEquationSeparate(gl.FUNC_ADD,gl.FUNC_ADD),gl.blendFuncSeparate(gl.SRC_ALPHA,gl.ONE_MINUS_SRC_ALPHA,gl.ONE,gl.ONE_MINUS_SRC_ALPHA)),currentBlending=blending,currentPremultipledAlpha=premultipliedAlpha),blending===THREE.CustomBlending?(blendEquationAlpha=blendEquationAlpha||blendEquation,blendSrcAlpha=blendSrcAlpha||blendSrc,blendDstAlpha=blendDstAlpha||blendDst,blendEquation===currentBlendEquation&&blendEquationAlpha===currentBlendEquationAlpha||(gl.blendEquationSeparate(paramThreeToGL(blendEquation),paramThreeToGL(blendEquationAlpha)),currentBlendEquation=blendEquation,currentBlendEquationAlpha=blendEquationAlpha),blendSrc===currentBlendSrc&&blendDst===currentBlendDst&&blendSrcAlpha===currentBlendSrcAlpha&&blendDstAlpha===currentBlendDstAlpha||(gl.blendFuncSeparate(paramThreeToGL(blendSrc),paramThreeToGL(blendDst),paramThreeToGL(blendSrcAlpha),paramThreeToGL(blendDstAlpha)),currentBlendSrc=blendSrc,currentBlendDst=blendDst,currentBlendSrcAlpha=blendSrcAlpha,currentBlendDstAlpha=blendDstAlpha)):(currentBlendEquation=null,currentBlendSrc=null,currentBlendDst=null,currentBlendEquationAlpha=null,currentBlendSrcAlpha=null,currentBlendDstAlpha=null)},this.setDepthFunc=function(depthFunc){if(currentDepthFunc!==depthFunc){if(depthFunc)switch(depthFunc){case THREE.NeverDepth:gl.depthFunc(gl.NEVER);break;case THREE.AlwaysDepth:gl.depthFunc(gl.ALWAYS);break;case THREE.LessDepth:gl.depthFunc(gl.LESS);break;case THREE.LessEqualDepth:gl.depthFunc(gl.LEQUAL);break;case THREE.EqualDepth:gl.depthFunc(gl.EQUAL);break;case THREE.GreaterEqualDepth:gl.depthFunc(gl.GEQUAL);break;case THREE.GreaterDepth:gl.depthFunc(gl.GREATER);break;case THREE.NotEqualDepth:gl.depthFunc(gl.NOTEQUAL);break;default:gl.depthFunc(gl.LEQUAL)}else gl.depthFunc(gl.LEQUAL);currentDepthFunc=depthFunc}},this.setDepthTest=function(depthTest){depthTest?this.enable(gl.DEPTH_TEST):this.disable(gl.DEPTH_TEST)},this.setDepthWrite=function(depthWrite){currentDepthWrite!==depthWrite&&(gl.depthMask(depthWrite),currentDepthWrite=depthWrite)},this.setColorWrite=function(colorWrite){currentColorWrite!==colorWrite&&(gl.colorMask(colorWrite,colorWrite,colorWrite,colorWrite),currentColorWrite=colorWrite)},this.setStencilFunc=function(stencilFunc,stencilRef,stencilMask){currentStencilFunc===stencilFunc&&currentStencilRef===stencilRef&&currentStencilMask===stencilMask||(gl.stencilFunc(stencilFunc,stencilRef,stencilMask),currentStencilFunc=stencilFunc,currentStencilRef=stencilRef,currentStencilMask=stencilMask)},this.setStencilOp=function(stencilFail,stencilZFail,stencilZPass){currentStencilFail===stencilFail&&currentStencilZFail===stencilZFail&&currentStencilZPass===stencilZPass||(gl.stencilOp(stencilFail,stencilZFail,stencilZPass),currentStencilFail=stencilFail,currentStencilZFail=stencilZFail,currentStencilZPass=stencilZPass)},this.setStencilTest=function(stencilTest){stencilTest?this.enable(gl.STENCIL_TEST):this.disable(gl.STENCIL_TEST)},this.setStencilWrite=function(stencilWrite){currentStencilWrite!==stencilWrite&&(gl.stencilMask(stencilWrite),currentStencilWrite=stencilWrite)},this.setFlipSided=function(flipSided){currentFlipSided!==flipSided&&(flipSided?gl.frontFace(gl.CW):gl.frontFace(gl.CCW),currentFlipSided=flipSided)},this.setLineWidth=function(width){width!==currentLineWidth&&(gl.lineWidth(width),currentLineWidth=width)},this.setPolygonOffset=function(polygonOffset,factor,units){polygonOffset?this.enable(gl.POLYGON_OFFSET_FILL):this.disable(gl.POLYGON_OFFSET_FILL),!polygonOffset||currentPolygonOffsetFactor===factor&&currentPolygonOffsetUnits===units||(gl.polygonOffset(factor,units),currentPolygonOffsetFactor=factor,currentPolygonOffsetUnits=units)},this.getScissorTest=function(){return currentScissorTest},this.setScissorTest=function(scissorTest){currentScissorTest=scissorTest,scissorTest?this.enable(gl.SCISSOR_TEST):this.disable(gl.SCISSOR_TEST)},this.activeTexture=function(webglSlot){void 0===webglSlot&&(webglSlot=gl.TEXTURE0+maxTextures-1),currentTextureSlot!==webglSlot&&(gl.activeTexture(webglSlot),currentTextureSlot=webglSlot)},this.bindTexture=function(webglType,webglTexture){void 0===currentTextureSlot&&_this.activeTexture();var boundTexture=currentBoundTextures[currentTextureSlot];void 0===boundTexture&&(boundTexture={type:void 0,texture:void 0},currentBoundTextures[currentTextureSlot]=boundTexture),boundTexture.type===webglType&&boundTexture.texture===webglTexture||(gl.bindTexture(webglType,webglTexture),boundTexture.type=webglType,boundTexture.texture=webglTexture)},this.compressedTexImage2D=function(){try{gl.compressedTexImage2D.apply(gl,arguments)}catch(error){console.error(error)}},this.texImage2D=function(){try{gl.texImage2D.apply(gl,arguments)}catch(error){console.error(error)}},this.clearColor=function(r,g,b,a){color.set(r,g,b,a),currentClearColor.equals(color)===!1&&(gl.clearColor(r,g,b,a),currentClearColor.copy(color))},this.clearDepth=function(depth){currentClearDepth!==depth&&(gl.clearDepth(depth),currentClearDepth=depth)},this.clearStencil=function(stencil){currentClearStencil!==stencil&&(gl.clearStencil(stencil),currentClearStencil=stencil)},this.scissor=function(scissor){currentScissor.equals(scissor)===!1&&(gl.scissor(scissor.x,scissor.y,scissor.z,scissor.w),currentScissor.copy(scissor))},this.viewport=function(viewport){currentViewport.equals(viewport)===!1&&(gl.viewport(viewport.x,viewport.y,viewport.z,viewport.w),currentViewport.copy(viewport))},this.reset=function(){for(var i=0;i<enabledAttributes.length;i++)1===enabledAttributes[i]&&(gl.disableVertexAttribArray(i),enabledAttributes[i]=0);capabilities={},compressedTextureFormats=null,currentTextureSlot=void 0,currentBoundTextures={},currentBlending=null,currentColorWrite=null,currentDepthWrite=null,currentStencilWrite=null,currentFlipSided=null}},THREE.WebGLUniforms=function(){var UniformContainer=function(){this.seq=[],this.map={}},arrayCacheF32=[],arrayCacheI32=[],flatten=function(array,nBlocks,blockSize){var firstElem=array[0];if(0>=firstElem||firstElem>0)return array;var n=nBlocks*blockSize,r=arrayCacheF32[n];if(void 0===r&&(r=new Float32Array(n),arrayCacheF32[n]=r),0!==nBlocks){firstElem.toArray(r,0);for(var i=1,offset=0;i!==nBlocks;++i)offset+=blockSize,array[i].toArray(r,offset)}return r},allocTexUnits=function(renderer,n){var r=arrayCacheI32[n];void 0===r&&(r=new Int32Array(n),arrayCacheI32[n]=r);for(var i=0;i!==n;++i)r[i]=renderer.allocTextureUnit();return r},setValue1f=function(gl,v){gl.uniform1f(this.addr,v)},setValue1i=function(gl,v){gl.uniform1i(this.addr,v)},setValue2fv=function(gl,v){void 0===v.x?gl.uniform2fv(this.addr,v):gl.uniform2f(this.addr,v.x,v.y)},setValue3fv=function(gl,v){void 0!==v.x?gl.uniform3f(this.addr,v.x,v.y,v.z):void 0!==v.r?gl.uniform3f(this.addr,v.r,v.g,v.b):gl.uniform3fv(this.addr,v)},setValue4fv=function(gl,v){void 0===v.x?gl.uniform4fv(this.addr,v):gl.uniform4f(this.addr,v.x,v.y,v.z,v.w)},setValue2fm=function(gl,v){gl.uniformMatrix2fv(this.addr,!1,v.elements||v)},setValue3fm=function(gl,v){gl.uniformMatrix3fv(this.addr,!1,v.elements||v)},setValue4fm=function(gl,v){gl.uniformMatrix4fv(this.addr,!1,v.elements||v)},setValueT1=function(gl,v,renderer){var unit=renderer.allocTextureUnit();gl.uniform1i(this.addr,unit),v&&renderer.setTexture2D(v,unit)},setValueT6=function(gl,v,renderer){var unit=renderer.allocTextureUnit();gl.uniform1i(this.addr,unit),v&&renderer.setTextureCube(v,unit)},setValue2iv=function(gl,v){gl.uniform2iv(this.addr,v)},setValue3iv=function(gl,v){gl.uniform3iv(this.addr,v)},setValue4iv=function(gl,v){gl.uniform4iv(this.addr,v)},getSingularSetter=function(type){switch(type){case 5126:return setValue1f;case 35664:return setValue2fv;case 35665:return setValue3fv;case 35666:return setValue4fv;case 35674:return setValue2fm;case 35675:return setValue3fm;case 35676:return setValue4fm;case 35678:return setValueT1;case 35680:return setValueT6;case 5124:case 35670:return setValue1i;case 35667:case 35671:return setValue2iv;case 35668:case 35672:return setValue3iv;case 35669:case 35673:return setValue4iv}},setValue1fv=function(gl,v){gl.uniform1fv(this.addr,v)},setValue1iv=function(gl,v){gl.uniform1iv(this.addr,v)},setValueV2a=function(gl,v){gl.uniform2fv(this.addr,flatten(v,this.size,2))},setValueV3a=function(gl,v){gl.uniform3fv(this.addr,flatten(v,this.size,3))},setValueV4a=function(gl,v){gl.uniform4fv(this.addr,flatten(v,this.size,4))},setValueM2a=function(gl,v){gl.uniformMatrix2fv(this.addr,!1,flatten(v,this.size,4))},setValueM3a=function(gl,v){gl.uniformMatrix3fv(this.addr,!1,flatten(v,this.size,9))},setValueM4a=function(gl,v){gl.uniformMatrix4fv(this.addr,!1,flatten(v,this.size,16))},setValueT1a=function(gl,v,renderer){var n=v.length,units=allocTexUnits(renderer,n);gl.uniform1iv(this.addr,units);for(var i=0;i!==n;++i){var tex=v[i];tex&&renderer.setTexture2D(tex,units[i])}},setValueT6a=function(gl,v,renderer){var n=v.length,units=allocTexUnits(renderer,n);gl.uniform1iv(this.addr,units);for(var i=0;i!==n;++i){var tex=v[i];tex&&renderer.setTextureCube(tex,units[i])}},getPureArraySetter=function(type){switch(type){case 5126:return setValue1fv;case 35664:return setValueV2a;case 35665:return setValueV3a;case 35666:return setValueV4a;case 35674:return setValueM2a;case 35675:return setValueM3a;case 35676:return setValueM4a;case 35678:return setValueT1a;case 35680:return setValueT6a;case 5124:case 35670:return setValue1iv;case 35667:case 35671:return setValue2iv;case 35668:case 35672:return setValue3iv;case 35669:case 35673:return setValue4iv}},SingleUniform=function(id,activeInfo,addr){this.id=id,this.addr=addr,this.setValue=getSingularSetter(activeInfo.type)},PureArrayUniform=function(id,activeInfo,addr){this.id=id,this.addr=addr,this.size=activeInfo.size,this.setValue=getPureArraySetter(activeInfo.type)},StructuredUniform=function(id){this.id=id,UniformContainer.call(this)};StructuredUniform.prototype.setValue=function(gl,value){for(var seq=this.seq,i=0,n=seq.length;i!==n;++i){var u=seq[i];u.setValue(gl,value[u.id])}};var RePathPart=/([\w\d_]+)(\])?(\[|\.)?/g,addUniform=function(container,uniformObject){container.seq.push(uniformObject),container.map[uniformObject.id]=uniformObject},parseUniform=function(activeInfo,addr,container){var path=activeInfo.name,pathLength=path.length;for(RePathPart.lastIndex=0;;){var match=RePathPart.exec(path),matchEnd=RePathPart.lastIndex,id=match[1],idIsIndex="]"===match[2],subscript=match[3];if(idIsIndex&&(id=0|id),void 0===subscript||"["===subscript&&matchEnd+2===pathLength){addUniform(container,void 0===subscript?new SingleUniform(id,activeInfo,addr):new PureArrayUniform(id,activeInfo,addr));break}var map=container.map,next=map[id];void 0===next&&(next=new StructuredUniform(id),addUniform(container,next)),container=next}},WebGLUniforms=function(gl,program,renderer){UniformContainer.call(this),this.renderer=renderer;for(var n=gl.getProgramParameter(program,gl.ACTIVE_UNIFORMS),i=0;i!==n;++i){var info=gl.getActiveUniform(program,i),path=info.name,addr=gl.getUniformLocation(program,path);parseUniform(info,addr,this)}};return WebGLUniforms.prototype.setValue=function(gl,name,value){var u=this.map[name];void 0!==u&&u.setValue(gl,value,this.renderer)},WebGLUniforms.prototype.set=function(gl,object,name){var u=this.map[name];void 0!==u&&u.setValue(gl,object[name],this.renderer)},WebGLUniforms.prototype.setOptional=function(gl,object,name){var v=object[name];void 0!==v&&this.setValue(gl,name,v)},WebGLUniforms.upload=function(gl,seq,values,renderer){for(var i=0,n=seq.length;i!==n;++i){var u=seq[i],v=values[u.id];v.needsUpdate!==!1&&u.setValue(gl,v.value,renderer)}},WebGLUniforms.seqWithValue=function(seq,values){for(var r=[],i=0,n=seq.length;i!==n;++i){var u=seq[i];u.id in values&&r.push(u)}return r},WebGLUniforms.splitDynamic=function(seq,values){for(var r=null,n=seq.length,w=0,i=0;i!==n;++i){var u=seq[i],v=values[u.id];v&&v.dynamic===!0?(null===r&&(r=[]),r.push(u)):(i>w&&(seq[w]=u),++w)}return n>w&&(seq.length=w),r},WebGLUniforms.evalDynamic=function(seq,values,object,camera){for(var i=0,n=seq.length;i!==n;++i){var v=values[seq[i].id],f=v.onUpdateCallback;void 0!==f&&f.call(v,object,camera)}},WebGLUniforms}(),THREE.LensFlarePlugin=function(renderer,flares){function init(){var vertices=new Float32Array([-1,-1,0,0,1,-1,1,0,1,1,1,1,-1,1,0,1]),faces=new Uint16Array([0,1,2,0,2,3]);vertexBuffer=gl.createBuffer(),elementBuffer=gl.createBuffer(),gl.bindBuffer(gl.ARRAY_BUFFER,vertexBuffer),gl.bufferData(gl.ARRAY_BUFFER,vertices,gl.STATIC_DRAW),gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,elementBuffer),gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,faces,gl.STATIC_DRAW),tempTexture=gl.createTexture(),occlusionTexture=gl.createTexture(),state.bindTexture(gl.TEXTURE_2D,tempTexture),gl.texImage2D(gl.TEXTURE_2D,0,gl.RGB,16,16,0,gl.RGB,gl.UNSIGNED_BYTE,null),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.NEAREST),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST),state.bindTexture(gl.TEXTURE_2D,occlusionTexture),gl.texImage2D(gl.TEXTURE_2D,0,gl.RGBA,16,16,0,gl.RGBA,gl.UNSIGNED_BYTE,null),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_S,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_WRAP_T,gl.CLAMP_TO_EDGE),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MAG_FILTER,gl.NEAREST),gl.texParameteri(gl.TEXTURE_2D,gl.TEXTURE_MIN_FILTER,gl.NEAREST),shader={vertexShader:["uniform lowp int renderType;","uniform vec3 screenPosition;","uniform vec2 scale;","uniform float rotation;","uniform sampler2D occlusionMap;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","varying float vVisibility;","void main() {","vUV = uv;","vec2 pos = position;","if ( renderType == 2 ) {","vec4 visibility = texture2D( occlusionMap, vec2( 0.1, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.1 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.9, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.9 ) );","visibility += texture2D( occlusionMap, vec2( 0.1, 0.5 ) );","visibility += texture2D( occlusionMap, vec2( 0.5, 0.5 ) );","vVisibility =        visibility.r / 9.0;","vVisibility *= 1.0 - visibility.g / 9.0;","vVisibility *=       visibility.b / 9.0;","vVisibility *= 1.0 - visibility.a / 9.0;","pos.x = cos( rotation ) * position.x - sin( rotation ) * position.y;","pos.y = sin( rotation ) * position.x + cos( rotation ) * position.y;","}","gl_Position = vec4( ( pos * scale + screenPosition.xy ).xy, screenPosition.z, 1.0 );","}"].join("\n"),fragmentShader:["uniform lowp int renderType;","uniform sampler2D map;","uniform float opacity;","uniform vec3 color;","varying vec2 vUV;","varying float vVisibility;","void main() {","if ( renderType == 0 ) {","gl_FragColor = vec4( 1.0, 0.0, 1.0, 0.0 );","} else if ( renderType == 1 ) {","gl_FragColor = texture2D( map, vUV );","} else {","vec4 texture = texture2D( map, vUV );","texture.a *= opacity * vVisibility;","gl_FragColor = texture;","gl_FragColor.rgb *= color;","}","}"].join("\n")},program=createProgram(shader),attributes={vertex:gl.getAttribLocation(program,"position"),uv:gl.getAttribLocation(program,"uv")},uniforms={renderType:gl.getUniformLocation(program,"renderType"),map:gl.getUniformLocation(program,"map"),occlusionMap:gl.getUniformLocation(program,"occlusionMap"),opacity:gl.getUniformLocation(program,"opacity"),color:gl.getUniformLocation(program,"color"),scale:gl.getUniformLocation(program,"scale"),rotation:gl.getUniformLocation(program,"rotation"),screenPosition:gl.getUniformLocation(program,"screenPosition")}}function createProgram(shader){var program=gl.createProgram(),fragmentShader=gl.createShader(gl.FRAGMENT_SHADER),vertexShader=gl.createShader(gl.VERTEX_SHADER),prefix="precision "+renderer.getPrecision()+" float;\n";return gl.shaderSource(fragmentShader,prefix+shader.fragmentShader),gl.shaderSource(vertexShader,prefix+shader.vertexShader),gl.compileShader(fragmentShader),gl.compileShader(vertexShader),gl.attachShader(program,fragmentShader),gl.attachShader(program,vertexShader),gl.linkProgram(program),program}var vertexBuffer,elementBuffer,shader,program,attributes,uniforms,tempTexture,occlusionTexture,gl=renderer.context,state=renderer.state;this.render=function(scene,camera,viewport){if(0!==flares.length){var tempPosition=new THREE.Vector3,invAspect=viewport.w/viewport.z,halfViewportWidth=.5*viewport.z,halfViewportHeight=.5*viewport.w,size=16/viewport.w,scale=new THREE.Vector2(size*invAspect,size),screenPosition=new THREE.Vector3(1,1,0),screenPositionPixels=new THREE.Vector2(1,1),validArea=new THREE.Box2;validArea.min.set(0,0),validArea.max.set(viewport.z-16,viewport.w-16),void 0===program&&init(),gl.useProgram(program),state.initAttributes(),state.enableAttribute(attributes.vertex),state.enableAttribute(attributes.uv),state.disableUnusedAttributes(),gl.uniform1i(uniforms.occlusionMap,0),gl.uniform1i(uniforms.map,1),gl.bindBuffer(gl.ARRAY_BUFFER,vertexBuffer),gl.vertexAttribPointer(attributes.vertex,2,gl.FLOAT,!1,16,0),gl.vertexAttribPointer(attributes.uv,2,gl.FLOAT,!1,16,8),gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,elementBuffer),state.disable(gl.CULL_FACE),state.setDepthWrite(!1);for(var i=0,l=flares.length;l>i;i++){size=16/viewport.w,scale.set(size*invAspect,size);var flare=flares[i];if(tempPosition.set(flare.matrixWorld.elements[12],flare.matrixWorld.elements[13],flare.matrixWorld.elements[14]),tempPosition.applyMatrix4(camera.matrixWorldInverse),tempPosition.applyProjection(camera.projectionMatrix),screenPosition.copy(tempPosition),screenPositionPixels.x=viewport.x+screenPosition.x*halfViewportWidth+halfViewportWidth-8,screenPositionPixels.y=viewport.y+screenPosition.y*halfViewportHeight+halfViewportHeight-8,validArea.containsPoint(screenPositionPixels)===!0){state.activeTexture(gl.TEXTURE0),state.bindTexture(gl.TEXTURE_2D,null),state.activeTexture(gl.TEXTURE1),state.bindTexture(gl.TEXTURE_2D,tempTexture),gl.copyTexImage2D(gl.TEXTURE_2D,0,gl.RGB,screenPositionPixels.x,screenPositionPixels.y,16,16,0),gl.uniform1i(uniforms.renderType,0),gl.uniform2f(uniforms.scale,scale.x,scale.y),gl.uniform3f(uniforms.screenPosition,screenPosition.x,screenPosition.y,screenPosition.z),state.disable(gl.BLEND),state.enable(gl.DEPTH_TEST),gl.drawElements(gl.TRIANGLES,6,gl.UNSIGNED_SHORT,0),state.activeTexture(gl.TEXTURE0),state.bindTexture(gl.TEXTURE_2D,occlusionTexture),gl.copyTexImage2D(gl.TEXTURE_2D,0,gl.RGBA,screenPositionPixels.x,screenPositionPixels.y,16,16,0),gl.uniform1i(uniforms.renderType,1),state.disable(gl.DEPTH_TEST),state.activeTexture(gl.TEXTURE1),state.bindTexture(gl.TEXTURE_2D,tempTexture),gl.drawElements(gl.TRIANGLES,6,gl.UNSIGNED_SHORT,0),flare.positionScreen.copy(screenPosition),flare.customUpdateCallback?flare.customUpdateCallback(flare):flare.updateLensFlares(),gl.uniform1i(uniforms.renderType,2),state.enable(gl.BLEND);for(var j=0,jl=flare.lensFlares.length;jl>j;j++){var sprite=flare.lensFlares[j];sprite.opacity>.001&&sprite.scale>.001&&(screenPosition.x=sprite.x,screenPosition.y=sprite.y,screenPosition.z=sprite.z,size=sprite.size*sprite.scale/viewport.w,scale.x=size*invAspect,scale.y=size,gl.uniform3f(uniforms.screenPosition,screenPosition.x,screenPosition.y,screenPosition.z),gl.uniform2f(uniforms.scale,scale.x,scale.y),gl.uniform1f(uniforms.rotation,sprite.rotation),gl.uniform1f(uniforms.opacity,sprite.opacity),gl.uniform3f(uniforms.color,sprite.color.r,sprite.color.g,sprite.color.b),state.setBlending(sprite.blending,sprite.blendEquation,sprite.blendSrc,sprite.blendDst),renderer.setTexture2D(sprite.texture,1),gl.drawElements(gl.TRIANGLES,6,gl.UNSIGNED_SHORT,0))}}}state.enable(gl.CULL_FACE),state.enable(gl.DEPTH_TEST),
state.setDepthWrite(!0),renderer.resetGLState()}}},THREE.SpritePlugin=function(renderer,sprites){function init(){var vertices=new Float32Array([-.5,-.5,0,0,.5,-.5,1,0,.5,.5,1,1,-.5,.5,0,1]),faces=new Uint16Array([0,1,2,0,2,3]);vertexBuffer=gl.createBuffer(),elementBuffer=gl.createBuffer(),gl.bindBuffer(gl.ARRAY_BUFFER,vertexBuffer),gl.bufferData(gl.ARRAY_BUFFER,vertices,gl.STATIC_DRAW),gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,elementBuffer),gl.bufferData(gl.ELEMENT_ARRAY_BUFFER,faces,gl.STATIC_DRAW),program=createProgram(),attributes={position:gl.getAttribLocation(program,"position"),uv:gl.getAttribLocation(program,"uv")},uniforms={uvOffset:gl.getUniformLocation(program,"uvOffset"),uvScale:gl.getUniformLocation(program,"uvScale"),rotation:gl.getUniformLocation(program,"rotation"),scale:gl.getUniformLocation(program,"scale"),color:gl.getUniformLocation(program,"color"),map:gl.getUniformLocation(program,"map"),opacity:gl.getUniformLocation(program,"opacity"),modelViewMatrix:gl.getUniformLocation(program,"modelViewMatrix"),projectionMatrix:gl.getUniformLocation(program,"projectionMatrix"),fogType:gl.getUniformLocation(program,"fogType"),fogDensity:gl.getUniformLocation(program,"fogDensity"),fogNear:gl.getUniformLocation(program,"fogNear"),fogFar:gl.getUniformLocation(program,"fogFar"),fogColor:gl.getUniformLocation(program,"fogColor"),alphaTest:gl.getUniformLocation(program,"alphaTest")};var canvas=document.createElement("canvas");canvas.width=8,canvas.height=8;var context=canvas.getContext("2d");context.fillStyle="white",context.fillRect(0,0,8,8),texture=new THREE.Texture(canvas),texture.needsUpdate=!0}function createProgram(){var program=gl.createProgram(),vertexShader=gl.createShader(gl.VERTEX_SHADER),fragmentShader=gl.createShader(gl.FRAGMENT_SHADER);return gl.shaderSource(vertexShader,["precision "+renderer.getPrecision()+" float;","uniform mat4 modelViewMatrix;","uniform mat4 projectionMatrix;","uniform float rotation;","uniform vec2 scale;","uniform vec2 uvOffset;","uniform vec2 uvScale;","attribute vec2 position;","attribute vec2 uv;","varying vec2 vUV;","void main() {","vUV = uvOffset + uv * uvScale;","vec2 alignedPosition = position * scale;","vec2 rotatedPosition;","rotatedPosition.x = cos( rotation ) * alignedPosition.x - sin( rotation ) * alignedPosition.y;","rotatedPosition.y = sin( rotation ) * alignedPosition.x + cos( rotation ) * alignedPosition.y;","vec4 finalPosition;","finalPosition = modelViewMatrix * vec4( 0.0, 0.0, 0.0, 1.0 );","finalPosition.xy += rotatedPosition;","finalPosition = projectionMatrix * finalPosition;","gl_Position = finalPosition;","}"].join("\n")),gl.shaderSource(fragmentShader,["precision "+renderer.getPrecision()+" float;","uniform vec3 color;","uniform sampler2D map;","uniform float opacity;","uniform int fogType;","uniform vec3 fogColor;","uniform float fogDensity;","uniform float fogNear;","uniform float fogFar;","uniform float alphaTest;","varying vec2 vUV;","void main() {","vec4 texture = texture2D( map, vUV );","if ( texture.a < alphaTest ) discard;","gl_FragColor = vec4( color * texture.xyz, texture.a * opacity );","if ( fogType > 0 ) {","float depth = gl_FragCoord.z / gl_FragCoord.w;","float fogFactor = 0.0;","if ( fogType == 1 ) {","fogFactor = smoothstep( fogNear, fogFar, depth );","} else {","const float LOG2 = 1.442695;","fogFactor = exp2( - fogDensity * fogDensity * depth * depth * LOG2 );","fogFactor = 1.0 - clamp( fogFactor, 0.0, 1.0 );","}","gl_FragColor = mix( gl_FragColor, vec4( fogColor, gl_FragColor.w ), fogFactor );","}","}"].join("\n")),gl.compileShader(vertexShader),gl.compileShader(fragmentShader),gl.attachShader(program,vertexShader),gl.attachShader(program,fragmentShader),gl.linkProgram(program),program}function painterSortStable(a,b){return a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.z!==b.z?b.z-a.z:b.id-a.id}var vertexBuffer,elementBuffer,program,attributes,uniforms,texture,gl=renderer.context,state=renderer.state,spritePosition=new THREE.Vector3,spriteRotation=new THREE.Quaternion,spriteScale=new THREE.Vector3;this.render=function(scene,camera){if(0!==sprites.length){void 0===program&&init(),gl.useProgram(program),state.initAttributes(),state.enableAttribute(attributes.position),state.enableAttribute(attributes.uv),state.disableUnusedAttributes(),state.disable(gl.CULL_FACE),state.enable(gl.BLEND),gl.bindBuffer(gl.ARRAY_BUFFER,vertexBuffer),gl.vertexAttribPointer(attributes.position,2,gl.FLOAT,!1,16,0),gl.vertexAttribPointer(attributes.uv,2,gl.FLOAT,!1,16,8),gl.bindBuffer(gl.ELEMENT_ARRAY_BUFFER,elementBuffer),gl.uniformMatrix4fv(uniforms.projectionMatrix,!1,camera.projectionMatrix.elements),state.activeTexture(gl.TEXTURE0),gl.uniform1i(uniforms.map,0);var oldFogType=0,sceneFogType=0,fog=scene.fog;fog?(gl.uniform3f(uniforms.fogColor,fog.color.r,fog.color.g,fog.color.b),fog instanceof THREE.Fog?(gl.uniform1f(uniforms.fogNear,fog.near),gl.uniform1f(uniforms.fogFar,fog.far),gl.uniform1i(uniforms.fogType,1),oldFogType=1,sceneFogType=1):fog instanceof THREE.FogExp2&&(gl.uniform1f(uniforms.fogDensity,fog.density),gl.uniform1i(uniforms.fogType,2),oldFogType=2,sceneFogType=2)):(gl.uniform1i(uniforms.fogType,0),oldFogType=0,sceneFogType=0);for(var i=0,l=sprites.length;l>i;i++){var sprite=sprites[i];sprite.modelViewMatrix.multiplyMatrices(camera.matrixWorldInverse,sprite.matrixWorld),sprite.z=-sprite.modelViewMatrix.elements[14]}sprites.sort(painterSortStable);for(var scale=[],i=0,l=sprites.length;l>i;i++){var sprite=sprites[i],material=sprite.material;gl.uniform1f(uniforms.alphaTest,material.alphaTest),gl.uniformMatrix4fv(uniforms.modelViewMatrix,!1,sprite.modelViewMatrix.elements),sprite.matrixWorld.decompose(spritePosition,spriteRotation,spriteScale),scale[0]=spriteScale.x,scale[1]=spriteScale.y;var fogType=0;scene.fog&&material.fog&&(fogType=sceneFogType),oldFogType!==fogType&&(gl.uniform1i(uniforms.fogType,fogType),oldFogType=fogType),null!==material.map?(gl.uniform2f(uniforms.uvOffset,material.map.offset.x,material.map.offset.y),gl.uniform2f(uniforms.uvScale,material.map.repeat.x,material.map.repeat.y)):(gl.uniform2f(uniforms.uvOffset,0,0),gl.uniform2f(uniforms.uvScale,1,1)),gl.uniform1f(uniforms.opacity,material.opacity),gl.uniform3f(uniforms.color,material.color.r,material.color.g,material.color.b),gl.uniform1f(uniforms.rotation,material.rotation),gl.uniform2fv(uniforms.scale,scale),state.setBlending(material.blending,material.blendEquation,material.blendSrc,material.blendDst),state.setDepthTest(material.depthTest),state.setDepthWrite(material.depthWrite),material.map?renderer.setTexture2D(material.map,0):renderer.setTexture2D(texture,0),gl.drawElements(gl.TRIANGLES,6,gl.UNSIGNED_SHORT,0)}state.enable(gl.CULL_FACE),renderer.resetGLState()}}},Object.defineProperties(THREE.Box2.prototype,{empty:{value:function(){return console.warn("THREE.Box2: .empty() has been renamed to .isEmpty()."),this.isEmpty()}},isIntersectionBox:{value:function(box){return console.warn("THREE.Box2: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(box)}}}),Object.defineProperties(THREE.Box3.prototype,{empty:{value:function(){return console.warn("THREE.Box3: .empty() has been renamed to .isEmpty()."),this.isEmpty()}},isIntersectionBox:{value:function(box){return console.warn("THREE.Box3: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(box)}},isIntersectionSphere:{value:function(sphere){return console.warn("THREE.Box3: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(sphere)}}}),Object.defineProperties(THREE.Matrix3.prototype,{multiplyVector3:{value:function(vector){return console.warn("THREE.Matrix3: .multiplyVector3() has been removed. Use vector.applyMatrix3( matrix ) instead."),vector.applyMatrix3(this)}},multiplyVector3Array:{value:function(a){return console.warn("THREE.Matrix3: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead."),this.applyToVector3Array(a)}}}),Object.defineProperties(THREE.Matrix4.prototype,{extractPosition:{value:function(m){return console.warn("THREE.Matrix4: .extractPosition() has been renamed to .copyPosition()."),this.copyPosition(m)}},setRotationFromQuaternion:{value:function(q){return console.warn("THREE.Matrix4: .setRotationFromQuaternion() has been renamed to .makeRotationFromQuaternion()."),this.makeRotationFromQuaternion(q)}},multiplyVector3:{value:function(vector){return console.warn("THREE.Matrix4: .multiplyVector3() has been removed. Use vector.applyMatrix4( matrix ) or vector.applyProjection( matrix ) instead."),vector.applyProjection(this)}},multiplyVector4:{value:function(vector){return console.warn("THREE.Matrix4: .multiplyVector4() has been removed. Use vector.applyMatrix4( matrix ) instead."),vector.applyMatrix4(this)}},multiplyVector3Array:{value:function(a){return console.warn("THREE.Matrix4: .multiplyVector3Array() has been renamed. Use matrix.applyToVector3Array( array ) instead."),this.applyToVector3Array(a)}},rotateAxis:{value:function(v){console.warn("THREE.Matrix4: .rotateAxis() has been removed. Use Vector3.transformDirection( matrix ) instead."),v.transformDirection(this)}},crossVector:{value:function(vector){return console.warn("THREE.Matrix4: .crossVector() has been removed. Use vector.applyMatrix4( matrix ) instead."),vector.applyMatrix4(this)}},translate:{value:function(v){console.error("THREE.Matrix4: .translate() has been removed.")}},rotateX:{value:function(angle){console.error("THREE.Matrix4: .rotateX() has been removed.")}},rotateY:{value:function(angle){console.error("THREE.Matrix4: .rotateY() has been removed.")}},rotateZ:{value:function(angle){console.error("THREE.Matrix4: .rotateZ() has been removed.")}},rotateByAxis:{value:function(axis,angle){console.error("THREE.Matrix4: .rotateByAxis() has been removed.")}}}),Object.defineProperties(THREE.Plane.prototype,{isIntersectionLine:{value:function(line){return console.warn("THREE.Plane: .isIntersectionLine() has been renamed to .intersectsLine()."),this.intersectsLine(line)}}}),Object.defineProperties(THREE.Quaternion.prototype,{multiplyVector3:{value:function(vector){return console.warn("THREE.Quaternion: .multiplyVector3() has been removed. Use is now vector.applyQuaternion( quaternion ) instead."),vector.applyQuaternion(this)}}}),Object.defineProperties(THREE.Ray.prototype,{isIntersectionBox:{value:function(box){return console.warn("THREE.Ray: .isIntersectionBox() has been renamed to .intersectsBox()."),this.intersectsBox(box)}},isIntersectionPlane:{value:function(plane){return console.warn("THREE.Ray: .isIntersectionPlane() has been renamed to .intersectsPlane()."),this.intersectsPlane(plane)}},isIntersectionSphere:{value:function(sphere){return console.warn("THREE.Ray: .isIntersectionSphere() has been renamed to .intersectsSphere()."),this.intersectsSphere(sphere)}}}),Object.defineProperties(THREE.Vector3.prototype,{setEulerFromRotationMatrix:{value:function(){console.error("THREE.Vector3: .setEulerFromRotationMatrix() has been removed. Use Euler.setFromRotationMatrix() instead.")}},setEulerFromQuaternion:{value:function(){console.error("THREE.Vector3: .setEulerFromQuaternion() has been removed. Use Euler.setFromQuaternion() instead.")}},getPositionFromMatrix:{value:function(m){return console.warn("THREE.Vector3: .getPositionFromMatrix() has been renamed to .setFromMatrixPosition()."),this.setFromMatrixPosition(m)}},getScaleFromMatrix:{value:function(m){return console.warn("THREE.Vector3: .getScaleFromMatrix() has been renamed to .setFromMatrixScale()."),this.setFromMatrixScale(m)}},getColumnFromMatrix:{value:function(index,matrix){return console.warn("THREE.Vector3: .getColumnFromMatrix() has been renamed to .setFromMatrixColumn()."),this.setFromMatrixColumn(index,matrix)}}}),THREE.Face4=function(a,b,c,d,normal,color,materialIndex){return console.warn("THREE.Face4 has been removed. A THREE.Face3 will be created instead."),new THREE.Face3(a,b,c,normal,color,materialIndex)},THREE.Vertex=function(x,y,z){return console.warn("THREE.Vertex has been removed. Use THREE.Vector3 instead."),new THREE.Vector3(x,y,z)},Object.defineProperties(THREE.Object3D.prototype,{eulerOrder:{get:function(){return console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order},set:function(value){console.warn("THREE.Object3D: .eulerOrder is now .rotation.order."),this.rotation.order=value}},getChildByName:{value:function(name){return console.warn("THREE.Object3D: .getChildByName() has been renamed to .getObjectByName()."),this.getObjectByName(name)}},renderDepth:{set:function(value){console.warn("THREE.Object3D: .renderDepth has been removed. Use .renderOrder, instead.")}},translate:{value:function(distance,axis){return console.warn("THREE.Object3D: .translate() has been removed. Use .translateOnAxis( axis, distance ) instead."),this.translateOnAxis(axis,distance)}},useQuaternion:{get:function(){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")},set:function(value){console.warn("THREE.Object3D: .useQuaternion has been removed. The library now uses quaternions by default.")}}}),Object.defineProperties(THREE,{PointCloud:{value:function(geometry,material){return console.warn("THREE.PointCloud has been renamed to THREE.Points."),new THREE.Points(geometry,material)}},ParticleSystem:{value:function(geometry,material){return console.warn("THREE.ParticleSystem has been renamed to THREE.Points."),new THREE.Points(geometry,material)}}}),Object.defineProperties(THREE.Light.prototype,{onlyShadow:{set:function(value){console.warn("THREE.Light: .onlyShadow has been removed.")}},shadowCameraFov:{set:function(value){console.warn("THREE.Light: .shadowCameraFov is now .shadow.camera.fov."),this.shadow.camera.fov=value}},shadowCameraLeft:{set:function(value){console.warn("THREE.Light: .shadowCameraLeft is now .shadow.camera.left."),this.shadow.camera.left=value}},shadowCameraRight:{set:function(value){console.warn("THREE.Light: .shadowCameraRight is now .shadow.camera.right."),this.shadow.camera.right=value}},shadowCameraTop:{set:function(value){console.warn("THREE.Light: .shadowCameraTop is now .shadow.camera.top."),this.shadow.camera.top=value}},shadowCameraBottom:{set:function(value){console.warn("THREE.Light: .shadowCameraBottom is now .shadow.camera.bottom."),this.shadow.camera.bottom=value}},shadowCameraNear:{set:function(value){console.warn("THREE.Light: .shadowCameraNear is now .shadow.camera.near."),this.shadow.camera.near=value}},shadowCameraFar:{set:function(value){console.warn("THREE.Light: .shadowCameraFar is now .shadow.camera.far."),this.shadow.camera.far=value}},shadowCameraVisible:{set:function(value){console.warn("THREE.Light: .shadowCameraVisible has been removed. Use new THREE.CameraHelper( light.shadow.camera ) instead.")}},shadowBias:{set:function(value){console.warn("THREE.Light: .shadowBias is now .shadow.bias."),this.shadow.bias=value}},shadowDarkness:{set:function(value){console.warn("THREE.Light: .shadowDarkness has been removed.")}},shadowMapWidth:{set:function(value){console.warn("THREE.Light: .shadowMapWidth is now .shadow.mapSize.width."),this.shadow.mapSize.width=value}},shadowMapHeight:{set:function(value){console.warn("THREE.Light: .shadowMapHeight is now .shadow.mapSize.height."),this.shadow.mapSize.height=value}}}),Object.defineProperties(THREE.BufferAttribute.prototype,{length:{get:function(){return console.warn("THREE.BufferAttribute: .length has been deprecated. Please use .count."),this.array.length}}}),Object.defineProperties(THREE.BufferGeometry.prototype,{drawcalls:{get:function(){return console.error("THREE.BufferGeometry: .drawcalls has been renamed to .groups."),this.groups}},offsets:{get:function(){return console.warn("THREE.BufferGeometry: .offsets has been renamed to .groups."),this.groups}},addIndex:{value:function(index){console.warn("THREE.BufferGeometry: .addIndex() has been renamed to .setIndex()."),this.setIndex(index)}},addDrawCall:{value:function(start,count,indexOffset){void 0!==indexOffset&&console.warn("THREE.BufferGeometry: .addDrawCall() no longer supports indexOffset."),console.warn("THREE.BufferGeometry: .addDrawCall() is now .addGroup()."),this.addGroup(start,count)}},clearDrawCalls:{value:function(){console.warn("THREE.BufferGeometry: .clearDrawCalls() is now .clearGroups()."),this.clearGroups()}},computeTangents:{value:function(){console.warn("THREE.BufferGeometry: .computeTangents() has been removed.")}},computeOffsets:{value:function(){console.warn("THREE.BufferGeometry: .computeOffsets() has been removed.")}}}),Object.defineProperties(THREE.Material.prototype,{wrapAround:{get:function(){console.warn("THREE."+this.type+": .wrapAround has been removed.")},set:function(value){console.warn("THREE."+this.type+": .wrapAround has been removed.")}},wrapRGB:{get:function(){return console.warn("THREE."+this.type+": .wrapRGB has been removed."),new THREE.Color}}}),Object.defineProperties(THREE,{PointCloudMaterial:{value:function(parameters){return console.warn("THREE.PointCloudMaterial has been renamed to THREE.PointsMaterial."),new THREE.PointsMaterial(parameters)}},ParticleBasicMaterial:{value:function(parameters){return console.warn("THREE.ParticleBasicMaterial has been renamed to THREE.PointsMaterial."),new THREE.PointsMaterial(parameters)}},ParticleSystemMaterial:{value:function(parameters){return console.warn("THREE.ParticleSystemMaterial has been renamed to THREE.PointsMaterial."),new THREE.PointsMaterial(parameters)}}}),Object.defineProperties(THREE.MeshPhongMaterial.prototype,{metal:{get:function(){return console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead."),!1},set:function(value){console.warn("THREE.MeshPhongMaterial: .metal has been removed. Use THREE.MeshStandardMaterial instead")}}}),Object.defineProperties(THREE.ShaderMaterial.prototype,{derivatives:{get:function(){return console.warn("THREE.ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives},set:function(value){console.warn("THREE. ShaderMaterial: .derivatives has been moved to .extensions.derivatives."),this.extensions.derivatives=value}}}),Object.defineProperties(THREE.WebGLRenderer.prototype,{supportsFloatTextures:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsFloatTextures() is now .extensions.get( 'OES_texture_float' )."),this.extensions.get("OES_texture_float")}},supportsHalfFloatTextures:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsHalfFloatTextures() is now .extensions.get( 'OES_texture_half_float' )."),this.extensions.get("OES_texture_half_float")}},supportsStandardDerivatives:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsStandardDerivatives() is now .extensions.get( 'OES_standard_derivatives' )."),this.extensions.get("OES_standard_derivatives")}},supportsCompressedTextureS3TC:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTextureS3TC() is now .extensions.get( 'WEBGL_compressed_texture_s3tc' )."),this.extensions.get("WEBGL_compressed_texture_s3tc")}},supportsCompressedTexturePVRTC:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsCompressedTexturePVRTC() is now .extensions.get( 'WEBGL_compressed_texture_pvrtc' )."),this.extensions.get("WEBGL_compressed_texture_pvrtc")}},supportsBlendMinMax:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsBlendMinMax() is now .extensions.get( 'EXT_blend_minmax' )."),this.extensions.get("EXT_blend_minmax")}},supportsVertexTextures:{value:function(){return this.capabilities.vertexTextures}},supportsInstancedArrays:{value:function(){return console.warn("THREE.WebGLRenderer: .supportsInstancedArrays() is now .extensions.get( 'ANGLE_instanced_arrays' )."),this.extensions.get("ANGLE_instanced_arrays")}},enableScissorTest:{value:function(boolean){console.warn("THREE.WebGLRenderer: .enableScissorTest() is now .setScissorTest()."),this.setScissorTest(boolean)}},initMaterial:{value:function(){console.warn("THREE.WebGLRenderer: .initMaterial() has been removed.")}},addPrePlugin:{value:function(){console.warn("THREE.WebGLRenderer: .addPrePlugin() has been removed.")}},addPostPlugin:{value:function(){console.warn("THREE.WebGLRenderer: .addPostPlugin() has been removed.")}},updateShadowMap:{value:function(){console.warn("THREE.WebGLRenderer: .updateShadowMap() has been removed.")}},shadowMapEnabled:{get:function(){return this.shadowMap.enabled},set:function(value){console.warn("THREE.WebGLRenderer: .shadowMapEnabled is now .shadowMap.enabled."),this.shadowMap.enabled=value}},shadowMapType:{get:function(){return this.shadowMap.type},set:function(value){console.warn("THREE.WebGLRenderer: .shadowMapType is now .shadowMap.type."),this.shadowMap.type=value}},shadowMapCullFace:{get:function(){return this.shadowMap.cullFace},set:function(value){console.warn("THREE.WebGLRenderer: .shadowMapCullFace is now .shadowMap.cullFace."),this.shadowMap.cullFace=value}}}),Object.defineProperties(THREE.WebGLRenderTarget.prototype,{wrapS:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS},set:function(value){console.warn("THREE.WebGLRenderTarget: .wrapS is now .texture.wrapS."),this.texture.wrapS=value}},wrapT:{get:function(){return console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT},set:function(value){console.warn("THREE.WebGLRenderTarget: .wrapT is now .texture.wrapT."),this.texture.wrapT=value}},magFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter},set:function(value){console.warn("THREE.WebGLRenderTarget: .magFilter is now .texture.magFilter."),this.texture.magFilter=value}},minFilter:{get:function(){return console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter},set:function(value){console.warn("THREE.WebGLRenderTarget: .minFilter is now .texture.minFilter."),this.texture.minFilter=value}},anisotropy:{get:function(){return console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy},set:function(value){console.warn("THREE.WebGLRenderTarget: .anisotropy is now .texture.anisotropy."),this.texture.anisotropy=value}},offset:{get:function(){return console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset},set:function(value){console.warn("THREE.WebGLRenderTarget: .offset is now .texture.offset."),this.texture.offset=value}},repeat:{get:function(){return console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat},set:function(value){console.warn("THREE.WebGLRenderTarget: .repeat is now .texture.repeat."),this.texture.repeat=value}},format:{get:function(){return console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format},set:function(value){console.warn("THREE.WebGLRenderTarget: .format is now .texture.format."),this.texture.format=value}},type:{get:function(){return console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type},set:function(value){console.warn("THREE.WebGLRenderTarget: .type is now .texture.type."),this.texture.type=value}},generateMipmaps:{get:function(){return console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps},set:function(value){console.warn("THREE.WebGLRenderTarget: .generateMipmaps is now .texture.generateMipmaps."),this.texture.generateMipmaps=value}}}),Object.defineProperties(THREE.Audio.prototype,{load:{value:function(file){console.warn("THREE.Audio: .load has been deprecated. Please use THREE.AudioLoader.");var scope=this,audioLoader=new THREE.AudioLoader;return audioLoader.load(file,function(buffer){scope.setBuffer(buffer)}),this}}}),THREE.GeometryUtils={merge:function(geometry1,geometry2,materialIndexOffset){console.warn("THREE.GeometryUtils: .merge() has been moved to Geometry. Use geometry.merge( geometry2, matrix, materialIndexOffset ) instead.");var matrix;geometry2 instanceof THREE.Mesh&&(geometry2.matrixAutoUpdate&&geometry2.updateMatrix(),matrix=geometry2.matrix,geometry2=geometry2.geometry),geometry1.merge(geometry2,matrix,materialIndexOffset)},center:function(geometry){return console.warn("THREE.GeometryUtils: .center() has been moved to Geometry. Use geometry.center() instead."),geometry.center()}},THREE.ImageUtils={crossOrigin:void 0,loadTexture:function(url,mapping,onLoad,onError){console.warn("THREE.ImageUtils.loadTexture has been deprecated. Use THREE.TextureLoader() instead.");var loader=new THREE.TextureLoader;loader.setCrossOrigin(this.crossOrigin);var texture=loader.load(url,onLoad,void 0,onError);return mapping&&(texture.mapping=mapping),texture},loadTextureCube:function(urls,mapping,onLoad,onError){console.warn("THREE.ImageUtils.loadTextureCube has been deprecated. Use THREE.CubeTextureLoader() instead.");var loader=new THREE.CubeTextureLoader;loader.setCrossOrigin(this.crossOrigin);var texture=loader.load(urls,onLoad,void 0,onError);return mapping&&(texture.mapping=mapping),texture},loadCompressedTexture:function(){console.error("THREE.ImageUtils.loadCompressedTexture has been removed. Use THREE.DDSLoader instead.")},loadCompressedTextureCube:function(){console.error("THREE.ImageUtils.loadCompressedTextureCube has been removed. Use THREE.DDSLoader instead.")}},THREE.Projector=function(){console.error("THREE.Projector has been moved to /examples/js/renderers/Projector.js."),this.projectVector=function(vector,camera){console.warn("THREE.Projector: .projectVector() is now vector.project()."),vector.project(camera)},this.unprojectVector=function(vector,camera){console.warn("THREE.Projector: .unprojectVector() is now vector.unproject()."),vector.unproject(camera)},this.pickingRay=function(vector,camera){console.error("THREE.Projector: .pickingRay() is now raycaster.setFromCamera().")}},THREE.CanvasRenderer=function(){console.error("THREE.CanvasRenderer has been moved to /examples/js/renderers/CanvasRenderer.js"),this.domElement=document.createElement("canvas"),this.clear=function(){},this.render=function(){},this.setClearColor=function(){},this.setSize=function(){}},THREE.MeshFaceMaterial=THREE.MultiMaterial,Object.defineProperties(THREE.LOD.prototype,{objects:{get:function(){return console.warn("THREE.LOD: .objects has been renamed to .levels."),this.levels}}}),THREE.CurveUtils={tangentQuadraticBezier:function(t,p0,p1,p2){return 2*(1-t)*(p1-p0)+2*t*(p2-p1)},tangentCubicBezier:function(t,p0,p1,p2,p3){return-3*p0*(1-t)*(1-t)+3*p1*(1-t)*(1-t)-6*t*p1*(1-t)+6*t*p2*(1-t)-3*t*t*p2+3*t*t*p3},tangentSpline:function(t,p0,p1,p2,p3){var h00=6*t*t-6*t,h10=3*t*t-4*t+1,h01=-6*t*t+6*t,h11=3*t*t-2*t;return h00+h10+h01+h11},interpolate:function(p0,p1,p2,p3,t){var v0=.5*(p2-p0),v1=.5*(p3-p1),t2=t*t,t3=t*t2;return(2*p1-2*p2+v0+v1)*t3+(-3*p1+3*p2-2*v0-v1)*t2+v0*t+p1}},THREE.SceneUtils={createMultiMaterialObject:function(geometry,materials){for(var group=new THREE.Group,i=0,l=materials.length;l>i;i++)group.add(new THREE.Mesh(geometry,materials[i]));return group},detach:function(child,parent,scene){child.applyMatrix(parent.matrixWorld),parent.remove(child),scene.add(child)},attach:function(child,scene,parent){var matrixWorldInverse=new THREE.Matrix4;matrixWorldInverse.getInverse(parent.matrixWorld),child.applyMatrix(matrixWorldInverse),scene.remove(child),parent.add(child)}},THREE.ShapeUtils={area:function(contour){for(var n=contour.length,a=0,p=n-1,q=0;n>q;p=q++)a+=contour[p].x*contour[q].y-contour[q].x*contour[p].y;return.5*a},triangulate:function(){function snip(contour,u,v,w,n,verts){var p,ax,ay,bx,by,cx,cy,px,py;if(ax=contour[verts[u]].x,ay=contour[verts[u]].y,bx=contour[verts[v]].x,by=contour[verts[v]].y,cx=contour[verts[w]].x,cy=contour[verts[w]].y,Number.EPSILON>(bx-ax)*(cy-ay)-(by-ay)*(cx-ax))return!1;var aX,aY,bX,bY,cX,cY,apx,apy,bpx,bpy,cpx,cpy,cCROSSap,bCROSScp,aCROSSbp;for(aX=cx-bx,aY=cy-by,bX=ax-cx,bY=ay-cy,cX=bx-ax,cY=by-ay,p=0;n>p;p++)if(px=contour[verts[p]].x,py=contour[verts[p]].y,!(px===ax&&py===ay||px===bx&&py===by||px===cx&&py===cy)&&(apx=px-ax,apy=py-ay,bpx=px-bx,bpy=py-by,cpx=px-cx,cpy=py-cy,aCROSSbp=aX*bpy-aY*bpx,cCROSSap=cX*apy-cY*apx,bCROSScp=bX*cpy-bY*cpx,aCROSSbp>=-Number.EPSILON&&bCROSScp>=-Number.EPSILON&&cCROSSap>=-Number.EPSILON))return!1;return!0}return function(contour,indices){var n=contour.length;if(3>n)return null;var u,v,w,result=[],verts=[],vertIndices=[];if(THREE.ShapeUtils.area(contour)>0)for(v=0;n>v;v++)verts[v]=v;else for(v=0;n>v;v++)verts[v]=n-1-v;var nv=n,count=2*nv;for(v=nv-1;nv>2;){if(count--<=0)return console.warn("THREE.ShapeUtils: Unable to triangulate polygon! in triangulate()"),indices?vertIndices:result;if(u=v,u>=nv&&(u=0),v=u+1,v>=nv&&(v=0),w=v+1,w>=nv&&(w=0),snip(contour,u,v,w,nv,verts)){var a,b,c,s,t;for(a=verts[u],b=verts[v],c=verts[w],result.push([contour[a],contour[b],contour[c]]),vertIndices.push([verts[u],verts[v],verts[w]]),s=v,t=v+1;nv>t;s++,t++)verts[s]=verts[t];nv--,count=2*nv}}return indices?vertIndices:result}}(),triangulateShape:function(contour,holes){function point_in_segment_2D_colin(inSegPt1,inSegPt2,inOtherPt){return inSegPt1.x!==inSegPt2.x?inSegPt1.x<inSegPt2.x?inSegPt1.x<=inOtherPt.x&&inOtherPt.x<=inSegPt2.x:inSegPt2.x<=inOtherPt.x&&inOtherPt.x<=inSegPt1.x:inSegPt1.y<inSegPt2.y?inSegPt1.y<=inOtherPt.y&&inOtherPt.y<=inSegPt2.y:inSegPt2.y<=inOtherPt.y&&inOtherPt.y<=inSegPt1.y}function intersect_segments_2D(inSeg1Pt1,inSeg1Pt2,inSeg2Pt1,inSeg2Pt2,inExcludeAdjacentSegs){var seg1dx=inSeg1Pt2.x-inSeg1Pt1.x,seg1dy=inSeg1Pt2.y-inSeg1Pt1.y,seg2dx=inSeg2Pt2.x-inSeg2Pt1.x,seg2dy=inSeg2Pt2.y-inSeg2Pt1.y,seg1seg2dx=inSeg1Pt1.x-inSeg2Pt1.x,seg1seg2dy=inSeg1Pt1.y-inSeg2Pt1.y,limit=seg1dy*seg2dx-seg1dx*seg2dy,perpSeg1=seg1dy*seg1seg2dx-seg1dx*seg1seg2dy;if(Math.abs(limit)>Number.EPSILON){var perpSeg2;if(limit>0){if(0>perpSeg1||perpSeg1>limit)return[];if(perpSeg2=seg2dy*seg1seg2dx-seg2dx*seg1seg2dy,0>perpSeg2||perpSeg2>limit)return[]}else{if(perpSeg1>0||limit>perpSeg1)return[];if(perpSeg2=seg2dy*seg1seg2dx-seg2dx*seg1seg2dy,perpSeg2>0||limit>perpSeg2)return[]}if(0===perpSeg2)return!inExcludeAdjacentSegs||0!==perpSeg1&&perpSeg1!==limit?[inSeg1Pt1]:[];if(perpSeg2===limit)return!inExcludeAdjacentSegs||0!==perpSeg1&&perpSeg1!==limit?[inSeg1Pt2]:[];if(0===perpSeg1)return[inSeg2Pt1];if(perpSeg1===limit)return[inSeg2Pt2];var factorSeg1=perpSeg2/limit;return[{x:inSeg1Pt1.x+factorSeg1*seg1dx,y:inSeg1Pt1.y+factorSeg1*seg1dy}]}if(0!==perpSeg1||seg2dy*seg1seg2dx!==seg2dx*seg1seg2dy)return[];var seg1Pt=0===seg1dx&&0===seg1dy,seg2Pt=0===seg2dx&&0===seg2dy;if(seg1Pt&&seg2Pt)return inSeg1Pt1.x!==inSeg2Pt1.x||inSeg1Pt1.y!==inSeg2Pt1.y?[]:[inSeg1Pt1];if(seg1Pt)return point_in_segment_2D_colin(inSeg2Pt1,inSeg2Pt2,inSeg1Pt1)?[inSeg1Pt1]:[];if(seg2Pt)return point_in_segment_2D_colin(inSeg1Pt1,inSeg1Pt2,inSeg2Pt1)?[inSeg2Pt1]:[];var seg1min,seg1max,seg1minVal,seg1maxVal,seg2min,seg2max,seg2minVal,seg2maxVal;return 0!==seg1dx?(inSeg1Pt1.x<inSeg1Pt2.x?(seg1min=inSeg1Pt1,seg1minVal=inSeg1Pt1.x,seg1max=inSeg1Pt2,seg1maxVal=inSeg1Pt2.x):(seg1min=inSeg1Pt2,seg1minVal=inSeg1Pt2.x,seg1max=inSeg1Pt1,seg1maxVal=inSeg1Pt1.x),inSeg2Pt1.x<inSeg2Pt2.x?(seg2min=inSeg2Pt1,seg2minVal=inSeg2Pt1.x,seg2max=inSeg2Pt2,seg2maxVal=inSeg2Pt2.x):(seg2min=inSeg2Pt2,seg2minVal=inSeg2Pt2.x,seg2max=inSeg2Pt1,seg2maxVal=inSeg2Pt1.x)):(inSeg1Pt1.y<inSeg1Pt2.y?(seg1min=inSeg1Pt1,seg1minVal=inSeg1Pt1.y,seg1max=inSeg1Pt2,seg1maxVal=inSeg1Pt2.y):(seg1min=inSeg1Pt2,seg1minVal=inSeg1Pt2.y,seg1max=inSeg1Pt1,seg1maxVal=inSeg1Pt1.y),inSeg2Pt1.y<inSeg2Pt2.y?(seg2min=inSeg2Pt1,seg2minVal=inSeg2Pt1.y,seg2max=inSeg2Pt2,seg2maxVal=inSeg2Pt2.y):(seg2min=inSeg2Pt2,seg2minVal=inSeg2Pt2.y,seg2max=inSeg2Pt1,seg2maxVal=inSeg2Pt1.y)),seg2minVal>=seg1minVal?seg2minVal>seg1maxVal?[]:seg1maxVal===seg2minVal?inExcludeAdjacentSegs?[]:[seg2min]:seg2maxVal>=seg1maxVal?[seg2min,seg1max]:[seg2min,seg2max]:seg1minVal>seg2maxVal?[]:seg1minVal===seg2maxVal?inExcludeAdjacentSegs?[]:[seg1min]:seg2maxVal>=seg1maxVal?[seg1min,seg1max]:[seg1min,seg2max];
}function isPointInsideAngle(inVertex,inLegFromPt,inLegToPt,inOtherPt){var legFromPtX=inLegFromPt.x-inVertex.x,legFromPtY=inLegFromPt.y-inVertex.y,legToPtX=inLegToPt.x-inVertex.x,legToPtY=inLegToPt.y-inVertex.y,otherPtX=inOtherPt.x-inVertex.x,otherPtY=inOtherPt.y-inVertex.y,from2toAngle=legFromPtX*legToPtY-legFromPtY*legToPtX,from2otherAngle=legFromPtX*otherPtY-legFromPtY*otherPtX;if(Math.abs(from2toAngle)>Number.EPSILON){var other2toAngle=otherPtX*legToPtY-otherPtY*legToPtX;return from2toAngle>0?from2otherAngle>=0&&other2toAngle>=0:from2otherAngle>=0||other2toAngle>=0}return from2otherAngle>0}function removeHoles(contour,holes){function isCutLineInsideAngles(inShapeIdx,inHoleIdx){var lastShapeIdx=shape.length-1,prevShapeIdx=inShapeIdx-1;0>prevShapeIdx&&(prevShapeIdx=lastShapeIdx);var nextShapeIdx=inShapeIdx+1;nextShapeIdx>lastShapeIdx&&(nextShapeIdx=0);var insideAngle=isPointInsideAngle(shape[inShapeIdx],shape[prevShapeIdx],shape[nextShapeIdx],hole[inHoleIdx]);if(!insideAngle)return!1;var lastHoleIdx=hole.length-1,prevHoleIdx=inHoleIdx-1;0>prevHoleIdx&&(prevHoleIdx=lastHoleIdx);var nextHoleIdx=inHoleIdx+1;return nextHoleIdx>lastHoleIdx&&(nextHoleIdx=0),insideAngle=isPointInsideAngle(hole[inHoleIdx],hole[prevHoleIdx],hole[nextHoleIdx],shape[inShapeIdx]),!!insideAngle}function intersectsShapeEdge(inShapePt,inHolePt){var sIdx,nextIdx,intersection;for(sIdx=0;sIdx<shape.length;sIdx++)if(nextIdx=sIdx+1,nextIdx%=shape.length,intersection=intersect_segments_2D(inShapePt,inHolePt,shape[sIdx],shape[nextIdx],!0),intersection.length>0)return!0;return!1}function intersectsHoleEdge(inShapePt,inHolePt){var ihIdx,chkHole,hIdx,nextIdx,intersection;for(ihIdx=0;ihIdx<indepHoles.length;ihIdx++)for(chkHole=holes[indepHoles[ihIdx]],hIdx=0;hIdx<chkHole.length;hIdx++)if(nextIdx=hIdx+1,nextIdx%=chkHole.length,intersection=intersect_segments_2D(inShapePt,inHolePt,chkHole[hIdx],chkHole[nextIdx],!0),intersection.length>0)return!0;return!1}for(var hole,holeIndex,shapeIndex,shapePt,holePt,holeIdx,cutKey,tmpShape1,tmpShape2,tmpHole1,tmpHole2,shape=contour.concat(),indepHoles=[],failedCuts=[],h=0,hl=holes.length;hl>h;h++)indepHoles.push(h);for(var minShapeIndex=0,counter=2*indepHoles.length;indepHoles.length>0;){if(counter--,0>counter){console.log("Infinite Loop! Holes left:"+indepHoles.length+", Probably Hole outside Shape!");break}for(shapeIndex=minShapeIndex;shapeIndex<shape.length;shapeIndex++){shapePt=shape[shapeIndex],holeIndex=-1;for(var h=0;h<indepHoles.length;h++)if(holeIdx=indepHoles[h],cutKey=shapePt.x+":"+shapePt.y+":"+holeIdx,void 0===failedCuts[cutKey]){hole=holes[holeIdx];for(var h2=0;h2<hole.length;h2++)if(holePt=hole[h2],isCutLineInsideAngles(shapeIndex,h2)&&!intersectsShapeEdge(shapePt,holePt)&&!intersectsHoleEdge(shapePt,holePt)){holeIndex=h2,indepHoles.splice(h,1),tmpShape1=shape.slice(0,shapeIndex+1),tmpShape2=shape.slice(shapeIndex),tmpHole1=hole.slice(holeIndex),tmpHole2=hole.slice(0,holeIndex+1),shape=tmpShape1.concat(tmpHole1).concat(tmpHole2).concat(tmpShape2),minShapeIndex=shapeIndex;break}if(holeIndex>=0)break;failedCuts[cutKey]=!0}if(holeIndex>=0)break}}return shape}for(var i,il,f,face,key,index,allPointsMap={},allpoints=contour.concat(),h=0,hl=holes.length;hl>h;h++)Array.prototype.push.apply(allpoints,holes[h]);for(i=0,il=allpoints.length;il>i;i++)key=allpoints[i].x+":"+allpoints[i].y,void 0!==allPointsMap[key]&&console.warn("THREE.Shape: Duplicate point",key),allPointsMap[key]=i;var shapeWithoutHoles=removeHoles(contour,holes),triangles=THREE.ShapeUtils.triangulate(shapeWithoutHoles,!1);for(i=0,il=triangles.length;il>i;i++)for(face=triangles[i],f=0;3>f;f++)key=face[f].x+":"+face[f].y,index=allPointsMap[key],void 0!==index&&(face[f]=index);return triangles.concat()},isClockWise:function(pts){return THREE.ShapeUtils.area(pts)<0},b2:function(){function b2p0(t,p){var k=1-t;return k*k*p}function b2p1(t,p){return 2*(1-t)*t*p}function b2p2(t,p){return t*t*p}return function(t,p0,p1,p2){return b2p0(t,p0)+b2p1(t,p1)+b2p2(t,p2)}}(),b3:function(){function b3p0(t,p){var k=1-t;return k*k*k*p}function b3p1(t,p){var k=1-t;return 3*k*k*t*p}function b3p2(t,p){var k=1-t;return 3*k*t*t*p}function b3p3(t,p){return t*t*t*p}return function(t,p0,p1,p2,p3){return b3p0(t,p0)+b3p1(t,p1)+b3p2(t,p2)+b3p3(t,p3)}}()},THREE.Curve=function(){},THREE.Curve.prototype={constructor:THREE.Curve,getPoint:function(t){return console.warn("THREE.Curve: Warning, getPoint() not implemented!"),null},getPointAt:function(u){var t=this.getUtoTmapping(u);return this.getPoint(t)},getPoints:function(divisions){divisions||(divisions=5);var d,pts=[];for(d=0;divisions>=d;d++)pts.push(this.getPoint(d/divisions));return pts},getSpacedPoints:function(divisions){divisions||(divisions=5);var d,pts=[];for(d=0;divisions>=d;d++)pts.push(this.getPointAt(d/divisions));return pts},getLength:function(){var lengths=this.getLengths();return lengths[lengths.length-1]},getLengths:function(divisions){if(divisions||(divisions=this.__arcLengthDivisions?this.__arcLengthDivisions:200),this.cacheArcLengths&&this.cacheArcLengths.length===divisions+1&&!this.needsUpdate)return this.cacheArcLengths;this.needsUpdate=!1;var current,p,cache=[],last=this.getPoint(0),sum=0;for(cache.push(0),p=1;divisions>=p;p++)current=this.getPoint(p/divisions),sum+=current.distanceTo(last),cache.push(sum),last=current;return this.cacheArcLengths=cache,cache},updateArcLengths:function(){this.needsUpdate=!0,this.getLengths()},getUtoTmapping:function(u,distance){var targetArcLength,arcLengths=this.getLengths(),i=0,il=arcLengths.length;targetArcLength=distance?distance:u*arcLengths[il-1];for(var comparison,low=0,high=il-1;high>=low;)if(i=Math.floor(low+(high-low)/2),comparison=arcLengths[i]-targetArcLength,0>comparison)low=i+1;else{if(!(comparison>0)){high=i;break}high=i-1}if(i=high,arcLengths[i]===targetArcLength){var t=i/(il-1);return t}var lengthBefore=arcLengths[i],lengthAfter=arcLengths[i+1],segmentLength=lengthAfter-lengthBefore,segmentFraction=(targetArcLength-lengthBefore)/segmentLength,t=(i+segmentFraction)/(il-1);return t},getTangent:function(t){var delta=1e-4,t1=t-delta,t2=t+delta;0>t1&&(t1=0),t2>1&&(t2=1);var pt1=this.getPoint(t1),pt2=this.getPoint(t2),vec=pt2.clone().sub(pt1);return vec.normalize()},getTangentAt:function(u){var t=this.getUtoTmapping(u);return this.getTangent(t)}},THREE.Curve.create=function(constructor,getPointFunc){return constructor.prototype=Object.create(THREE.Curve.prototype),constructor.prototype.constructor=constructor,constructor.prototype.getPoint=getPointFunc,constructor},THREE.CurvePath=function(){this.curves=[],this.autoClose=!1},THREE.CurvePath.prototype=Object.create(THREE.Curve.prototype),THREE.CurvePath.prototype.constructor=THREE.CurvePath,THREE.CurvePath.prototype.add=function(curve){this.curves.push(curve)},THREE.CurvePath.prototype.closePath=function(){var startPoint=this.curves[0].getPoint(0),endPoint=this.curves[this.curves.length-1].getPoint(1);startPoint.equals(endPoint)||this.curves.push(new THREE.LineCurve(endPoint,startPoint))},THREE.CurvePath.prototype.getPoint=function(t){for(var d=t*this.getLength(),curveLengths=this.getCurveLengths(),i=0;i<curveLengths.length;){if(curveLengths[i]>=d){var diff=curveLengths[i]-d,curve=this.curves[i],u=1-diff/curve.getLength();return curve.getPointAt(u)}i++}return null},THREE.CurvePath.prototype.getLength=function(){var lens=this.getCurveLengths();return lens[lens.length-1]},THREE.CurvePath.prototype.getCurveLengths=function(){if(this.cacheLengths&&this.cacheLengths.length===this.curves.length)return this.cacheLengths;for(var lengths=[],sums=0,i=0,l=this.curves.length;l>i;i++)sums+=this.curves[i].getLength(),lengths.push(sums);return this.cacheLengths=lengths,lengths},THREE.CurvePath.prototype.createPointsGeometry=function(divisions){var pts=this.getPoints(divisions);return this.createGeometry(pts)},THREE.CurvePath.prototype.createSpacedPointsGeometry=function(divisions){var pts=this.getSpacedPoints(divisions);return this.createGeometry(pts)},THREE.CurvePath.prototype.createGeometry=function(points){for(var geometry=new THREE.Geometry,i=0,l=points.length;l>i;i++){var point=points[i];geometry.vertices.push(new THREE.Vector3(point.x,point.y,point.z||0))}return geometry},THREE.Font=function(data){this.data=data},THREE.Font.prototype={constructor:THREE.Font,generateShapes:function(text,size,divisions){function createPaths(text){for(var chars=String(text).split(""),scale=size/data.resolution,offset=0,paths=[],i=0;i<chars.length;i++){var ret=createPath(chars[i],scale,offset);offset+=ret.offset,paths.push(ret.path)}return paths}function createPath(c,scale,offset){var glyph=data.glyphs[c]||data.glyphs["?"];if(glyph){var x,y,cpx,cpy,cpx0,cpy0,cpx1,cpy1,cpx2,cpy2,laste,path=new THREE.Path,pts=[],b2=THREE.ShapeUtils.b2,b3=THREE.ShapeUtils.b3;if(glyph.o)for(var outline=glyph._cachedOutline||(glyph._cachedOutline=glyph.o.split(" ")),i=0,l=outline.length;l>i;){var action=outline[i++];switch(action){case"m":x=outline[i++]*scale+offset,y=outline[i++]*scale,path.moveTo(x,y);break;case"l":x=outline[i++]*scale+offset,y=outline[i++]*scale,path.lineTo(x,y);break;case"q":if(cpx=outline[i++]*scale+offset,cpy=outline[i++]*scale,cpx1=outline[i++]*scale+offset,cpy1=outline[i++]*scale,path.quadraticCurveTo(cpx1,cpy1,cpx,cpy),laste=pts[pts.length-1]){cpx0=laste.x,cpy0=laste.y;for(var i2=1;divisions>=i2;i2++){var t=i2/divisions;b2(t,cpx0,cpx1,cpx),b2(t,cpy0,cpy1,cpy)}}break;case"b":if(cpx=outline[i++]*scale+offset,cpy=outline[i++]*scale,cpx1=outline[i++]*scale+offset,cpy1=outline[i++]*scale,cpx2=outline[i++]*scale+offset,cpy2=outline[i++]*scale,path.bezierCurveTo(cpx1,cpy1,cpx2,cpy2,cpx,cpy),laste=pts[pts.length-1]){cpx0=laste.x,cpy0=laste.y;for(var i2=1;divisions>=i2;i2++){var t=i2/divisions;b3(t,cpx0,cpx1,cpx2,cpx),b3(t,cpy0,cpy1,cpy2,cpy)}}}}return{offset:glyph.ha*scale,path:path}}}void 0===size&&(size=100),void 0===divisions&&(divisions=4);for(var data=this.data,paths=createPaths(text),shapes=[],p=0,pl=paths.length;pl>p;p++)Array.prototype.push.apply(shapes,paths[p].toShapes());return shapes}},THREE.Path=function(points){THREE.CurvePath.call(this),this.actions=[],points&&this.fromPoints(points)},THREE.Path.prototype=Object.create(THREE.CurvePath.prototype),THREE.Path.prototype.constructor=THREE.Path,THREE.Path.prototype.fromPoints=function(vectors){this.moveTo(vectors[0].x,vectors[0].y);for(var i=1,l=vectors.length;l>i;i++)this.lineTo(vectors[i].x,vectors[i].y)},THREE.Path.prototype.moveTo=function(x,y){this.actions.push({action:"moveTo",args:[x,y]})},THREE.Path.prototype.lineTo=function(x,y){var lastargs=this.actions[this.actions.length-1].args,x0=lastargs[lastargs.length-2],y0=lastargs[lastargs.length-1],curve=new THREE.LineCurve(new THREE.Vector2(x0,y0),new THREE.Vector2(x,y));this.curves.push(curve),this.actions.push({action:"lineTo",args:[x,y]})},THREE.Path.prototype.quadraticCurveTo=function(aCPx,aCPy,aX,aY){var lastargs=this.actions[this.actions.length-1].args,x0=lastargs[lastargs.length-2],y0=lastargs[lastargs.length-1],curve=new THREE.QuadraticBezierCurve(new THREE.Vector2(x0,y0),new THREE.Vector2(aCPx,aCPy),new THREE.Vector2(aX,aY));this.curves.push(curve),this.actions.push({action:"quadraticCurveTo",args:[aCPx,aCPy,aX,aY]})},THREE.Path.prototype.bezierCurveTo=function(aCP1x,aCP1y,aCP2x,aCP2y,aX,aY){var lastargs=this.actions[this.actions.length-1].args,x0=lastargs[lastargs.length-2],y0=lastargs[lastargs.length-1],curve=new THREE.CubicBezierCurve(new THREE.Vector2(x0,y0),new THREE.Vector2(aCP1x,aCP1y),new THREE.Vector2(aCP2x,aCP2y),new THREE.Vector2(aX,aY));this.curves.push(curve),this.actions.push({action:"bezierCurveTo",args:[aCP1x,aCP1y,aCP2x,aCP2y,aX,aY]})},THREE.Path.prototype.splineThru=function(pts){var args=Array.prototype.slice.call(arguments),lastargs=this.actions[this.actions.length-1].args,x0=lastargs[lastargs.length-2],y0=lastargs[lastargs.length-1],npts=[new THREE.Vector2(x0,y0)];Array.prototype.push.apply(npts,pts);var curve=new THREE.SplineCurve(npts);this.curves.push(curve),this.actions.push({action:"splineThru",args:args})},THREE.Path.prototype.arc=function(aX,aY,aRadius,aStartAngle,aEndAngle,aClockwise){var lastargs=this.actions[this.actions.length-1].args,x0=lastargs[lastargs.length-2],y0=lastargs[lastargs.length-1];this.absarc(aX+x0,aY+y0,aRadius,aStartAngle,aEndAngle,aClockwise)},THREE.Path.prototype.absarc=function(aX,aY,aRadius,aStartAngle,aEndAngle,aClockwise){this.absellipse(aX,aY,aRadius,aRadius,aStartAngle,aEndAngle,aClockwise)},THREE.Path.prototype.ellipse=function(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation){var lastargs=this.actions[this.actions.length-1].args,x0=lastargs[lastargs.length-2],y0=lastargs[lastargs.length-1];this.absellipse(aX+x0,aY+y0,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation)},THREE.Path.prototype.absellipse=function(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation){var args=[aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation||0],curve=new THREE.EllipseCurve(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation);this.curves.push(curve);var lastPoint=curve.getPoint(1);args.push(lastPoint.x),args.push(lastPoint.y),this.actions.push({action:"ellipse",args:args})},THREE.Path.prototype.getSpacedPoints=function(divisions){divisions||(divisions=40);for(var points=[],i=0;divisions>i;i++)points.push(this.getPoint(i/divisions));return this.autoClose&&points.push(points[0]),points},THREE.Path.prototype.getPoints=function(divisions){divisions=divisions||12;for(var cpx,cpy,cpx2,cpy2,cpx1,cpy1,cpx0,cpy0,laste,tx,ty,b2=THREE.ShapeUtils.b2,b3=THREE.ShapeUtils.b3,points=[],i=0,l=this.actions.length;l>i;i++){var item=this.actions[i],action=item.action,args=item.args;switch(action){case"moveTo":points.push(new THREE.Vector2(args[0],args[1]));break;case"lineTo":points.push(new THREE.Vector2(args[0],args[1]));break;case"quadraticCurveTo":cpx=args[2],cpy=args[3],cpx1=args[0],cpy1=args[1],points.length>0?(laste=points[points.length-1],cpx0=laste.x,cpy0=laste.y):(laste=this.actions[i-1].args,cpx0=laste[laste.length-2],cpy0=laste[laste.length-1]);for(var j=1;divisions>=j;j++){var t=j/divisions;tx=b2(t,cpx0,cpx1,cpx),ty=b2(t,cpy0,cpy1,cpy),points.push(new THREE.Vector2(tx,ty))}break;case"bezierCurveTo":cpx=args[4],cpy=args[5],cpx1=args[0],cpy1=args[1],cpx2=args[2],cpy2=args[3],points.length>0?(laste=points[points.length-1],cpx0=laste.x,cpy0=laste.y):(laste=this.actions[i-1].args,cpx0=laste[laste.length-2],cpy0=laste[laste.length-1]);for(var j=1;divisions>=j;j++){var t=j/divisions;tx=b3(t,cpx0,cpx1,cpx2,cpx),ty=b3(t,cpy0,cpy1,cpy2,cpy),points.push(new THREE.Vector2(tx,ty))}break;case"splineThru":laste=this.actions[i-1].args;var last=new THREE.Vector2(laste[laste.length-2],laste[laste.length-1]),spts=[last],n=divisions*args[0].length;spts=spts.concat(args[0]);for(var spline=new THREE.SplineCurve(spts),j=1;n>=j;j++)points.push(spline.getPointAt(j/n));break;case"arc":for(var angle,aX=args[0],aY=args[1],aRadius=args[2],aStartAngle=args[3],aEndAngle=args[4],aClockwise=!!args[5],deltaAngle=aEndAngle-aStartAngle,tdivisions=2*divisions,j=1;tdivisions>=j;j++){var t=j/tdivisions;aClockwise||(t=1-t),angle=aStartAngle+t*deltaAngle,tx=aX+aRadius*Math.cos(angle),ty=aY+aRadius*Math.sin(angle),points.push(new THREE.Vector2(tx,ty))}break;case"ellipse":var angle,cos,sin,aX=args[0],aY=args[1],xRadius=args[2],yRadius=args[3],aStartAngle=args[4],aEndAngle=args[5],aClockwise=!!args[6],aRotation=args[7],deltaAngle=aEndAngle-aStartAngle,tdivisions=2*divisions;0!==aRotation&&(cos=Math.cos(aRotation),sin=Math.sin(aRotation));for(var j=1;tdivisions>=j;j++){var t=j/tdivisions;if(aClockwise||(t=1-t),angle=aStartAngle+t*deltaAngle,tx=aX+xRadius*Math.cos(angle),ty=aY+yRadius*Math.sin(angle),0!==aRotation){var x=tx,y=ty;tx=(x-aX)*cos-(y-aY)*sin+aX,ty=(x-aX)*sin+(y-aY)*cos+aY}points.push(new THREE.Vector2(tx,ty))}}}var lastPoint=points[points.length-1];return Math.abs(lastPoint.x-points[0].x)<Number.EPSILON&&Math.abs(lastPoint.y-points[0].y)<Number.EPSILON&&points.splice(points.length-1,1),this.autoClose&&points.push(points[0]),points},THREE.Path.prototype.toShapes=function(isCCW,noHoles){function extractSubpaths(inActions){for(var subPaths=[],lastPath=new THREE.Path,i=0,l=inActions.length;l>i;i++){var item=inActions[i],args=item.args,action=item.action;"moveTo"===action&&0!==lastPath.actions.length&&(subPaths.push(lastPath),lastPath=new THREE.Path),lastPath[action].apply(lastPath,args)}return 0!==lastPath.actions.length&&subPaths.push(lastPath),subPaths}function toShapesNoHoles(inSubpaths){for(var shapes=[],i=0,l=inSubpaths.length;l>i;i++){var tmpPath=inSubpaths[i],tmpShape=new THREE.Shape;tmpShape.actions=tmpPath.actions,tmpShape.curves=tmpPath.curves,shapes.push(tmpShape)}return shapes}function isPointInsidePolygon(inPt,inPolygon){for(var polyLen=inPolygon.length,inside=!1,p=polyLen-1,q=0;polyLen>q;p=q++){var edgeLowPt=inPolygon[p],edgeHighPt=inPolygon[q],edgeDx=edgeHighPt.x-edgeLowPt.x,edgeDy=edgeHighPt.y-edgeLowPt.y;if(Math.abs(edgeDy)>Number.EPSILON){if(0>edgeDy&&(edgeLowPt=inPolygon[q],edgeDx=-edgeDx,edgeHighPt=inPolygon[p],edgeDy=-edgeDy),inPt.y<edgeLowPt.y||inPt.y>edgeHighPt.y)continue;if(inPt.y===edgeLowPt.y){if(inPt.x===edgeLowPt.x)return!0}else{var perpEdge=edgeDy*(inPt.x-edgeLowPt.x)-edgeDx*(inPt.y-edgeLowPt.y);if(0===perpEdge)return!0;if(0>perpEdge)continue;inside=!inside}}else{if(inPt.y!==edgeLowPt.y)continue;if(edgeHighPt.x<=inPt.x&&inPt.x<=edgeLowPt.x||edgeLowPt.x<=inPt.x&&inPt.x<=edgeHighPt.x)return!0}}return inside}var isClockWise=THREE.ShapeUtils.isClockWise,subPaths=extractSubpaths(this.actions);if(0===subPaths.length)return[];if(noHoles===!0)return toShapesNoHoles(subPaths);var solid,tmpPath,tmpShape,shapes=[];if(1===subPaths.length)return tmpPath=subPaths[0],tmpShape=new THREE.Shape,tmpShape.actions=tmpPath.actions,tmpShape.curves=tmpPath.curves,shapes.push(tmpShape),shapes;var holesFirst=!isClockWise(subPaths[0].getPoints());holesFirst=isCCW?!holesFirst:holesFirst;var tmpPoints,betterShapeHoles=[],newShapes=[],newShapeHoles=[],mainIdx=0;newShapes[mainIdx]=void 0,newShapeHoles[mainIdx]=[];for(var i=0,l=subPaths.length;l>i;i++)tmpPath=subPaths[i],tmpPoints=tmpPath.getPoints(),solid=isClockWise(tmpPoints),solid=isCCW?!solid:solid,solid?(!holesFirst&&newShapes[mainIdx]&&mainIdx++,newShapes[mainIdx]={s:new THREE.Shape,p:tmpPoints},newShapes[mainIdx].s.actions=tmpPath.actions,newShapes[mainIdx].s.curves=tmpPath.curves,holesFirst&&mainIdx++,newShapeHoles[mainIdx]=[]):newShapeHoles[mainIdx].push({h:tmpPath,p:tmpPoints[0]});if(!newShapes[0])return toShapesNoHoles(subPaths);if(newShapes.length>1){for(var ambiguous=!1,toChange=[],sIdx=0,sLen=newShapes.length;sLen>sIdx;sIdx++)betterShapeHoles[sIdx]=[];for(var sIdx=0,sLen=newShapes.length;sLen>sIdx;sIdx++)for(var sho=newShapeHoles[sIdx],hIdx=0;hIdx<sho.length;hIdx++){for(var ho=sho[hIdx],hole_unassigned=!0,s2Idx=0;s2Idx<newShapes.length;s2Idx++)isPointInsidePolygon(ho.p,newShapes[s2Idx].p)&&(sIdx!==s2Idx&&toChange.push({froms:sIdx,tos:s2Idx,hole:hIdx}),hole_unassigned?(hole_unassigned=!1,betterShapeHoles[s2Idx].push(ho)):ambiguous=!0);hole_unassigned&&betterShapeHoles[sIdx].push(ho)}toChange.length>0&&(ambiguous||(newShapeHoles=betterShapeHoles))}for(var tmpHoles,i=0,il=newShapes.length;il>i;i++){tmpShape=newShapes[i].s,shapes.push(tmpShape),tmpHoles=newShapeHoles[i];for(var j=0,jl=tmpHoles.length;jl>j;j++)tmpShape.holes.push(tmpHoles[j].h)}return shapes},THREE.Shape=function(){THREE.Path.apply(this,arguments),this.holes=[]},THREE.Shape.prototype=Object.create(THREE.Path.prototype),THREE.Shape.prototype.constructor=THREE.Shape,THREE.Shape.prototype.extrude=function(options){return new THREE.ExtrudeGeometry(this,options)},THREE.Shape.prototype.makeGeometry=function(options){return new THREE.ShapeGeometry(this,options)},THREE.Shape.prototype.getPointsHoles=function(divisions){for(var holesPts=[],i=0,l=this.holes.length;l>i;i++)holesPts[i]=this.holes[i].getPoints(divisions);return holesPts},THREE.Shape.prototype.extractAllPoints=function(divisions){return{shape:this.getPoints(divisions),holes:this.getPointsHoles(divisions)}},THREE.Shape.prototype.extractPoints=function(divisions){return this.extractAllPoints(divisions)},THREE.LineCurve=function(v1,v2){this.v1=v1,this.v2=v2},THREE.LineCurve.prototype=Object.create(THREE.Curve.prototype),THREE.LineCurve.prototype.constructor=THREE.LineCurve,THREE.LineCurve.prototype.getPoint=function(t){var point=this.v2.clone().sub(this.v1);return point.multiplyScalar(t).add(this.v1),point},THREE.LineCurve.prototype.getPointAt=function(u){return this.getPoint(u)},THREE.LineCurve.prototype.getTangent=function(t){var tangent=this.v2.clone().sub(this.v1);return tangent.normalize()},THREE.QuadraticBezierCurve=function(v0,v1,v2){this.v0=v0,this.v1=v1,this.v2=v2},THREE.QuadraticBezierCurve.prototype=Object.create(THREE.Curve.prototype),THREE.QuadraticBezierCurve.prototype.constructor=THREE.QuadraticBezierCurve,THREE.QuadraticBezierCurve.prototype.getPoint=function(t){var b2=THREE.ShapeUtils.b2;return new THREE.Vector2(b2(t,this.v0.x,this.v1.x,this.v2.x),b2(t,this.v0.y,this.v1.y,this.v2.y))},THREE.QuadraticBezierCurve.prototype.getTangent=function(t){var tangentQuadraticBezier=THREE.CurveUtils.tangentQuadraticBezier;return new THREE.Vector2(tangentQuadraticBezier(t,this.v0.x,this.v1.x,this.v2.x),tangentQuadraticBezier(t,this.v0.y,this.v1.y,this.v2.y)).normalize()},THREE.CubicBezierCurve=function(v0,v1,v2,v3){this.v0=v0,this.v1=v1,this.v2=v2,this.v3=v3},THREE.CubicBezierCurve.prototype=Object.create(THREE.Curve.prototype),THREE.CubicBezierCurve.prototype.constructor=THREE.CubicBezierCurve,THREE.CubicBezierCurve.prototype.getPoint=function(t){var b3=THREE.ShapeUtils.b3;return new THREE.Vector2(b3(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x),b3(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y))},THREE.CubicBezierCurve.prototype.getTangent=function(t){var tangentCubicBezier=THREE.CurveUtils.tangentCubicBezier;return new THREE.Vector2(tangentCubicBezier(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x),tangentCubicBezier(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y)).normalize()},THREE.SplineCurve=function(points){this.points=void 0==points?[]:points},THREE.SplineCurve.prototype=Object.create(THREE.Curve.prototype),THREE.SplineCurve.prototype.constructor=THREE.SplineCurve,THREE.SplineCurve.prototype.getPoint=function(t){var points=this.points,point=(points.length-1)*t,intPoint=Math.floor(point),weight=point-intPoint,point0=points[0===intPoint?intPoint:intPoint-1],point1=points[intPoint],point2=points[intPoint>points.length-2?points.length-1:intPoint+1],point3=points[intPoint>points.length-3?points.length-1:intPoint+2],interpolate=THREE.CurveUtils.interpolate;return new THREE.Vector2(interpolate(point0.x,point1.x,point2.x,point3.x,weight),interpolate(point0.y,point1.y,point2.y,point3.y,weight))},THREE.EllipseCurve=function(aX,aY,xRadius,yRadius,aStartAngle,aEndAngle,aClockwise,aRotation){this.aX=aX,this.aY=aY,this.xRadius=xRadius,this.yRadius=yRadius,this.aStartAngle=aStartAngle,this.aEndAngle=aEndAngle,this.aClockwise=aClockwise,this.aRotation=aRotation||0},THREE.EllipseCurve.prototype=Object.create(THREE.Curve.prototype),THREE.EllipseCurve.prototype.constructor=THREE.EllipseCurve,THREE.EllipseCurve.prototype.getPoint=function(t){var deltaAngle=this.aEndAngle-this.aStartAngle;0>deltaAngle&&(deltaAngle+=2*Math.PI),deltaAngle>2*Math.PI&&(deltaAngle-=2*Math.PI);var angle;angle=this.aClockwise===!0?this.aEndAngle+(1-t)*(2*Math.PI-deltaAngle):this.aStartAngle+t*deltaAngle;var x=this.aX+this.xRadius*Math.cos(angle),y=this.aY+this.yRadius*Math.sin(angle);if(0!==this.aRotation){var cos=Math.cos(this.aRotation),sin=Math.sin(this.aRotation),tx=x,ty=y;x=(tx-this.aX)*cos-(ty-this.aY)*sin+this.aX,y=(tx-this.aX)*sin+(ty-this.aY)*cos+this.aY}return new THREE.Vector2(x,y)},THREE.ArcCurve=function(aX,aY,aRadius,aStartAngle,aEndAngle,aClockwise){THREE.EllipseCurve.call(this,aX,aY,aRadius,aRadius,aStartAngle,aEndAngle,aClockwise)},THREE.ArcCurve.prototype=Object.create(THREE.EllipseCurve.prototype),THREE.ArcCurve.prototype.constructor=THREE.ArcCurve,THREE.LineCurve3=THREE.Curve.create(function(v1,v2){this.v1=v1,this.v2=v2},function(t){var vector=new THREE.Vector3;return vector.subVectors(this.v2,this.v1),vector.multiplyScalar(t),vector.add(this.v1),vector}),THREE.QuadraticBezierCurve3=THREE.Curve.create(function(v0,v1,v2){this.v0=v0,this.v1=v1,this.v2=v2},function(t){var b2=THREE.ShapeUtils.b2;return new THREE.Vector3(b2(t,this.v0.x,this.v1.x,this.v2.x),b2(t,this.v0.y,this.v1.y,this.v2.y),b2(t,this.v0.z,this.v1.z,this.v2.z))}),THREE.CubicBezierCurve3=THREE.Curve.create(function(v0,v1,v2,v3){this.v0=v0,this.v1=v1,this.v2=v2,this.v3=v3},function(t){var b3=THREE.ShapeUtils.b3;return new THREE.Vector3(b3(t,this.v0.x,this.v1.x,this.v2.x,this.v3.x),b3(t,this.v0.y,this.v1.y,this.v2.y,this.v3.y),b3(t,this.v0.z,this.v1.z,this.v2.z,this.v3.z))}),THREE.SplineCurve3=THREE.Curve.create(function(points){console.warn("THREE.SplineCurve3 will be deprecated. Please use THREE.CatmullRomCurve3"),this.points=void 0==points?[]:points},function(t){var points=this.points,point=(points.length-1)*t,intPoint=Math.floor(point),weight=point-intPoint,point0=points[0==intPoint?intPoint:intPoint-1],point1=points[intPoint],point2=points[intPoint>points.length-2?points.length-1:intPoint+1],point3=points[intPoint>points.length-3?points.length-1:intPoint+2],interpolate=THREE.CurveUtils.interpolate;return new THREE.Vector3(interpolate(point0.x,point1.x,point2.x,point3.x,weight),interpolate(point0.y,point1.y,point2.y,point3.y,weight),interpolate(point0.z,point1.z,point2.z,point3.z,weight))}),THREE.CatmullRomCurve3=function(){function CubicPoly(){}var tmp=new THREE.Vector3,px=new CubicPoly,py=new CubicPoly,pz=new CubicPoly;return CubicPoly.prototype.init=function(x0,x1,t0,t1){this.c0=x0,this.c1=t0,this.c2=-3*x0+3*x1-2*t0-t1,this.c3=2*x0-2*x1+t0+t1},CubicPoly.prototype.initNonuniformCatmullRom=function(x0,x1,x2,x3,dt0,dt1,dt2){var t1=(x1-x0)/dt0-(x2-x0)/(dt0+dt1)+(x2-x1)/dt1,t2=(x2-x1)/dt1-(x3-x1)/(dt1+dt2)+(x3-x2)/dt2;t1*=dt1,t2*=dt1,this.init(x1,x2,t1,t2)},CubicPoly.prototype.initCatmullRom=function(x0,x1,x2,x3,tension){this.init(x1,x2,tension*(x2-x0),tension*(x3-x1))},CubicPoly.prototype.calc=function(t){var t2=t*t,t3=t2*t;return this.c0+this.c1*t+this.c2*t2+this.c3*t3},THREE.Curve.create(function(p){this.points=p||[],this.closed=!1},function(t){var point,intPoint,weight,l,points=this.points;l=points.length,2>l&&console.log("duh, you need at least 2 points"),point=(l-(this.closed?0:1))*t,intPoint=Math.floor(point),weight=point-intPoint,this.closed?intPoint+=intPoint>0?0:(Math.floor(Math.abs(intPoint)/points.length)+1)*points.length:0===weight&&intPoint===l-1&&(intPoint=l-2,weight=1);var p0,p1,p2,p3;if(this.closed||intPoint>0?p0=points[(intPoint-1)%l]:(tmp.subVectors(points[0],points[1]).add(points[0]),p0=tmp),p1=points[intPoint%l],p2=points[(intPoint+1)%l],this.closed||l>intPoint+2?p3=points[(intPoint+2)%l]:(tmp.subVectors(points[l-1],points[l-2]).add(points[l-1]),p3=tmp),void 0===this.type||"centripetal"===this.type||"chordal"===this.type){var pow="chordal"===this.type?.5:.25,dt0=Math.pow(p0.distanceToSquared(p1),pow),dt1=Math.pow(p1.distanceToSquared(p2),pow),dt2=Math.pow(p2.distanceToSquared(p3),pow);1e-4>dt1&&(dt1=1),1e-4>dt0&&(dt0=dt1),1e-4>dt2&&(dt2=dt1),px.initNonuniformCatmullRom(p0.x,p1.x,p2.x,p3.x,dt0,dt1,dt2),py.initNonuniformCatmullRom(p0.y,p1.y,p2.y,p3.y,dt0,dt1,dt2),pz.initNonuniformCatmullRom(p0.z,p1.z,p2.z,p3.z,dt0,dt1,dt2)}else if("catmullrom"===this.type){var tension=void 0!==this.tension?this.tension:.5;px.initCatmullRom(p0.x,p1.x,p2.x,p3.x,tension),py.initCatmullRom(p0.y,p1.y,p2.y,p3.y,tension),pz.initCatmullRom(p0.z,p1.z,p2.z,p3.z,tension)}var v=new THREE.Vector3(px.calc(weight),py.calc(weight),pz.calc(weight));return v})}(),THREE.ClosedSplineCurve3=function(points){console.warn("THREE.ClosedSplineCurve3 has been deprecated. Please use THREE.CatmullRomCurve3."),THREE.CatmullRomCurve3.call(this,points),this.type="catmullrom",this.closed=!0},THREE.ClosedSplineCurve3.prototype=Object.create(THREE.CatmullRomCurve3.prototype),THREE.BoxGeometry=function(width,height,depth,widthSegments,heightSegments,depthSegments){THREE.Geometry.call(this),this.type="BoxGeometry",this.parameters={width:width,height:height,depth:depth,widthSegments:widthSegments,heightSegments:heightSegments,depthSegments:depthSegments},this.fromBufferGeometry(new THREE.BoxBufferGeometry(width,height,depth,widthSegments,heightSegments,depthSegments)),this.mergeVertices()},THREE.BoxGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.BoxGeometry.prototype.constructor=THREE.BoxGeometry,THREE.CubeGeometry=THREE.BoxGeometry,THREE.BoxBufferGeometry=function(width,height,depth,widthSegments,heightSegments,depthSegments){function calculateVertexCount(w,h,d){var segments=0;return segments+=w*h*2,segments+=w*d*2,segments+=d*h*2,4*segments}function buildPlane(u,v,w,udir,vdir,width,height,depth,gridX,gridY,materialIndex){for(var segmentWidth=width/gridX,segmentHeight=height/gridY,widthHalf=width/2,heightHalf=height/2,depthHalf=depth/2,gridX1=gridX+1,gridY1=gridY+1,vertexCounter=0,groupCount=0,vector=new THREE.Vector3,iy=0;gridY1>iy;iy++)for(var y=iy*segmentHeight-heightHalf,ix=0;gridX1>ix;ix++){var x=ix*segmentWidth-widthHalf;vector[u]=x*udir,vector[v]=y*vdir,vector[w]=depthHalf,vertices[vertexBufferOffset]=vector.x,vertices[vertexBufferOffset+1]=vector.y,vertices[vertexBufferOffset+2]=vector.z,vector[u]=0,vector[v]=0,vector[w]=depth>0?1:-1,normals[vertexBufferOffset]=vector.x,normals[vertexBufferOffset+1]=vector.y,normals[vertexBufferOffset+2]=vector.z,uvs[uvBufferOffset]=ix/gridX,uvs[uvBufferOffset+1]=1-iy/gridY,vertexBufferOffset+=3,uvBufferOffset+=2,vertexCounter+=1}for(iy=0;gridY>iy;iy++)for(ix=0;gridX>ix;ix++){var a=numberOfVertices+ix+gridX1*iy,b=numberOfVertices+ix+gridX1*(iy+1),c=numberOfVertices+(ix+1)+gridX1*(iy+1),d=numberOfVertices+(ix+1)+gridX1*iy;indices[indexBufferOffset]=a,indices[indexBufferOffset+1]=b,indices[indexBufferOffset+2]=d,indices[indexBufferOffset+3]=b,indices[indexBufferOffset+4]=c,indices[indexBufferOffset+5]=d,indexBufferOffset+=6,groupCount+=6}scope.addGroup(groupStart,groupCount,materialIndex),groupStart+=groupCount,numberOfVertices+=vertexCounter}THREE.BufferGeometry.call(this),this.type="BoxBufferGeometry",this.parameters={width:width,height:height,depth:depth,widthSegments:widthSegments,heightSegments:heightSegments,depthSegments:depthSegments};var scope=this;widthSegments=Math.floor(widthSegments)||1,heightSegments=Math.floor(heightSegments)||1,depthSegments=Math.floor(depthSegments)||1;var vertexCount=calculateVertexCount(widthSegments,heightSegments,depthSegments),indexCount=vertexCount/4*6,indices=new(indexCount>65535?Uint32Array:Uint16Array)(indexCount),vertices=new Float32Array(3*vertexCount),normals=new Float32Array(3*vertexCount),uvs=new Float32Array(2*vertexCount),vertexBufferOffset=0,uvBufferOffset=0,indexBufferOffset=0,numberOfVertices=0,groupStart=0;buildPlane("z","y","x",-1,-1,depth,height,width,depthSegments,heightSegments,0),buildPlane("z","y","x",1,-1,depth,height,-width,depthSegments,heightSegments,1),buildPlane("x","z","y",1,1,width,depth,height,widthSegments,depthSegments,2),buildPlane("x","z","y",1,-1,width,depth,-height,widthSegments,depthSegments,3),buildPlane("x","y","z",1,-1,width,height,depth,widthSegments,heightSegments,4),buildPlane("x","y","z",-1,-1,width,height,-depth,widthSegments,heightSegments,5),this.setIndex(new THREE.BufferAttribute(indices,1)),this.addAttribute("position",new THREE.BufferAttribute(vertices,3)),this.addAttribute("normal",new THREE.BufferAttribute(normals,3)),this.addAttribute("uv",new THREE.BufferAttribute(uvs,2))},THREE.BoxBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.BoxBufferGeometry.prototype.constructor=THREE.BoxBufferGeometry,THREE.CircleGeometry=function(radius,segments,thetaStart,thetaLength){THREE.Geometry.call(this),this.type="CircleGeometry",
this.parameters={radius:radius,segments:segments,thetaStart:thetaStart,thetaLength:thetaLength},this.fromBufferGeometry(new THREE.CircleBufferGeometry(radius,segments,thetaStart,thetaLength))},THREE.CircleGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.CircleGeometry.prototype.constructor=THREE.CircleGeometry,THREE.CircleBufferGeometry=function(radius,segments,thetaStart,thetaLength){THREE.BufferGeometry.call(this),this.type="CircleBufferGeometry",this.parameters={radius:radius,segments:segments,thetaStart:thetaStart,thetaLength:thetaLength},radius=radius||50,segments=void 0!==segments?Math.max(3,segments):8,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:2*Math.PI;var vertices=segments+2,positions=new Float32Array(3*vertices),normals=new Float32Array(3*vertices),uvs=new Float32Array(2*vertices);normals[2]=1,uvs[0]=.5,uvs[1]=.5;for(var s=0,i=3,ii=2;segments>=s;s++,i+=3,ii+=2){var segment=thetaStart+s/segments*thetaLength;positions[i]=radius*Math.cos(segment),positions[i+1]=radius*Math.sin(segment),normals[i+2]=1,uvs[ii]=(positions[i]/radius+1)/2,uvs[ii+1]=(positions[i+1]/radius+1)/2}for(var indices=[],i=1;segments>=i;i++)indices.push(i,i+1,0);this.setIndex(new THREE.BufferAttribute(new Uint16Array(indices),1)),this.addAttribute("position",new THREE.BufferAttribute(positions,3)),this.addAttribute("normal",new THREE.BufferAttribute(normals,3)),this.addAttribute("uv",new THREE.BufferAttribute(uvs,2)),this.boundingSphere=new THREE.Sphere(new THREE.Vector3,radius)},THREE.CircleBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.CircleBufferGeometry.prototype.constructor=THREE.CircleBufferGeometry,THREE.CylinderBufferGeometry=function(radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength){function calculateVertexCount(){var count=(radialSegments+1)*(heightSegments+1);return openEnded===!1&&(count+=2*(radialSegments+1)+2*radialSegments),count}function calculateIndexCount(){var count=radialSegments*heightSegments*2*3;return openEnded===!1&&(count+=2*radialSegments*3),count}function generateTorso(){var x,y,normal=new THREE.Vector3,vertex=new THREE.Vector3,groupCount=0,tanTheta=(radiusBottom-radiusTop)/height;for(y=0;heightSegments>=y;y++){var indexRow=[],v=y/heightSegments,radius=v*(radiusBottom-radiusTop)+radiusTop;for(x=0;radialSegments>=x;x++){var u=x/radialSegments;vertex.x=radius*Math.sin(u*thetaLength+thetaStart),vertex.y=-v*height+halfHeight,vertex.z=radius*Math.cos(u*thetaLength+thetaStart),vertices.setXYZ(index,vertex.x,vertex.y,vertex.z),normal.copy(vertex),(0===radiusTop&&0===y||0===radiusBottom&&y===heightSegments)&&(normal.x=Math.sin(u*thetaLength+thetaStart),normal.z=Math.cos(u*thetaLength+thetaStart)),normal.setY(Math.sqrt(normal.x*normal.x+normal.z*normal.z)*tanTheta).normalize(),normals.setXYZ(index,normal.x,normal.y,normal.z),uvs.setXY(index,u,1-v),indexRow.push(index),index++}indexArray.push(indexRow)}for(x=0;radialSegments>x;x++)for(y=0;heightSegments>y;y++){var i1=indexArray[y][x],i2=indexArray[y+1][x],i3=indexArray[y+1][x+1],i4=indexArray[y][x+1];indices.setX(indexOffset,i1),indexOffset++,indices.setX(indexOffset,i2),indexOffset++,indices.setX(indexOffset,i4),indexOffset++,indices.setX(indexOffset,i2),indexOffset++,indices.setX(indexOffset,i3),indexOffset++,indices.setX(indexOffset,i4),indexOffset++,groupCount+=6}scope.addGroup(groupStart,groupCount,0),groupStart+=groupCount}function generateCap(top){var x,centerIndexStart,centerIndexEnd,uv=new THREE.Vector2,vertex=new THREE.Vector3,groupCount=0,radius=top===!0?radiusTop:radiusBottom,sign=top===!0?1:-1;for(centerIndexStart=index,x=1;radialSegments>=x;x++)vertices.setXYZ(index,0,halfHeight*sign,0),normals.setXYZ(index,0,sign,0),top===!0?(uv.x=x/radialSegments,uv.y=0):(uv.x=(x-1)/radialSegments,uv.y=1),uvs.setXY(index,uv.x,uv.y),index++;for(centerIndexEnd=index,x=0;radialSegments>=x;x++){var u=x/radialSegments;vertex.x=radius*Math.sin(u*thetaLength+thetaStart),vertex.y=halfHeight*sign,vertex.z=radius*Math.cos(u*thetaLength+thetaStart),vertices.setXYZ(index,vertex.x,vertex.y,vertex.z),normals.setXYZ(index,0,sign,0),uvs.setXY(index,u,top===!0?1:0),index++}for(x=0;radialSegments>x;x++){var c=centerIndexStart+x,i=centerIndexEnd+x;top===!0?(indices.setX(indexOffset,i),indexOffset++,indices.setX(indexOffset,i+1),indexOffset++,indices.setX(indexOffset,c),indexOffset++):(indices.setX(indexOffset,i+1),indexOffset++,indices.setX(indexOffset,i),indexOffset++,indices.setX(indexOffset,c),indexOffset++),groupCount+=3}scope.addGroup(groupStart,groupCount,top===!0?1:2),groupStart+=groupCount}THREE.BufferGeometry.call(this),this.type="CylinderBufferGeometry",this.parameters={radiusTop:radiusTop,radiusBottom:radiusBottom,height:height,radialSegments:radialSegments,heightSegments:heightSegments,openEnded:openEnded,thetaStart:thetaStart,thetaLength:thetaLength};var scope=this;radiusTop=void 0!==radiusTop?radiusTop:20,radiusBottom=void 0!==radiusBottom?radiusBottom:20,height=void 0!==height?height:100,radialSegments=Math.floor(radialSegments)||8,heightSegments=Math.floor(heightSegments)||1,openEnded=void 0!==openEnded?openEnded:!1,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:2*Math.PI;var vertexCount=calculateVertexCount(),indexCount=calculateIndexCount(),indices=new THREE.BufferAttribute(new(indexCount>65535?Uint32Array:Uint16Array)(indexCount),1),vertices=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),normals=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),uvs=new THREE.BufferAttribute(new Float32Array(2*vertexCount),2),index=0,indexOffset=0,indexArray=[],halfHeight=height/2,groupStart=0;generateTorso(),openEnded===!1&&(radiusTop>0&&generateCap(!0),radiusBottom>0&&generateCap(!1)),this.setIndex(indices),this.addAttribute("position",vertices),this.addAttribute("normal",normals),this.addAttribute("uv",uvs)},THREE.CylinderBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.CylinderBufferGeometry.prototype.constructor=THREE.CylinderBufferGeometry,THREE.CylinderGeometry=function(radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength){THREE.Geometry.call(this),this.type="CylinderGeometry",this.parameters={radiusTop:radiusTop,radiusBottom:radiusBottom,height:height,radialSegments:radialSegments,heightSegments:heightSegments,openEnded:openEnded,thetaStart:thetaStart,thetaLength:thetaLength},this.fromBufferGeometry(new THREE.CylinderBufferGeometry(radiusTop,radiusBottom,height,radialSegments,heightSegments,openEnded,thetaStart,thetaLength)),this.mergeVertices()},THREE.CylinderGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.CylinderGeometry.prototype.constructor=THREE.CylinderGeometry,THREE.EdgesGeometry=function(geometry,thresholdAngle){function sortFunction(a,b){return a-b}THREE.BufferGeometry.call(this),thresholdAngle=void 0!==thresholdAngle?thresholdAngle:1;var geometry2,thresholdDot=Math.cos(THREE.Math.DEG2RAD*thresholdAngle),edge=[0,0],hash={},keys=["a","b","c"];geometry instanceof THREE.BufferGeometry?(geometry2=new THREE.Geometry,geometry2.fromBufferGeometry(geometry)):geometry2=geometry.clone(),geometry2.mergeVertices(),geometry2.computeFaceNormals();for(var vertices=geometry2.vertices,faces=geometry2.faces,i=0,l=faces.length;l>i;i++)for(var face=faces[i],j=0;3>j;j++){edge[0]=face[keys[j]],edge[1]=face[keys[(j+1)%3]],edge.sort(sortFunction);var key=edge.toString();void 0===hash[key]?hash[key]={vert1:edge[0],vert2:edge[1],face1:i,face2:void 0}:hash[key].face2=i}var coords=[];for(var key in hash){var h=hash[key];if(void 0===h.face2||faces[h.face1].normal.dot(faces[h.face2].normal)<=thresholdDot){var vertex=vertices[h.vert1];coords.push(vertex.x),coords.push(vertex.y),coords.push(vertex.z),vertex=vertices[h.vert2],coords.push(vertex.x),coords.push(vertex.y),coords.push(vertex.z)}}this.addAttribute("position",new THREE.BufferAttribute(new Float32Array(coords),3))},THREE.EdgesGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.EdgesGeometry.prototype.constructor=THREE.EdgesGeometry,THREE.ExtrudeGeometry=function(shapes,options){return"undefined"==typeof shapes?void(shapes=[]):(THREE.Geometry.call(this),this.type="ExtrudeGeometry",shapes=Array.isArray(shapes)?shapes:[shapes],this.addShapeList(shapes,options),void this.computeFaceNormals())},THREE.ExtrudeGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.ExtrudeGeometry.prototype.constructor=THREE.ExtrudeGeometry,THREE.ExtrudeGeometry.prototype.addShapeList=function(shapes,options){for(var sl=shapes.length,s=0;sl>s;s++){var shape=shapes[s];this.addShape(shape,options)}},THREE.ExtrudeGeometry.prototype.addShape=function(shape,options){function scalePt2(pt,vec,size){return vec||console.error("THREE.ExtrudeGeometry: vec does not exist"),vec.clone().multiplyScalar(size).add(pt)}function getBevelVec(inPt,inPrev,inNext){var v_trans_x,v_trans_y,shrink_by=1,v_prev_x=inPt.x-inPrev.x,v_prev_y=inPt.y-inPrev.y,v_next_x=inNext.x-inPt.x,v_next_y=inNext.y-inPt.y,v_prev_lensq=v_prev_x*v_prev_x+v_prev_y*v_prev_y,collinear0=v_prev_x*v_next_y-v_prev_y*v_next_x;if(Math.abs(collinear0)>Number.EPSILON){var v_prev_len=Math.sqrt(v_prev_lensq),v_next_len=Math.sqrt(v_next_x*v_next_x+v_next_y*v_next_y),ptPrevShift_x=inPrev.x-v_prev_y/v_prev_len,ptPrevShift_y=inPrev.y+v_prev_x/v_prev_len,ptNextShift_x=inNext.x-v_next_y/v_next_len,ptNextShift_y=inNext.y+v_next_x/v_next_len,sf=((ptNextShift_x-ptPrevShift_x)*v_next_y-(ptNextShift_y-ptPrevShift_y)*v_next_x)/(v_prev_x*v_next_y-v_prev_y*v_next_x);v_trans_x=ptPrevShift_x+v_prev_x*sf-inPt.x,v_trans_y=ptPrevShift_y+v_prev_y*sf-inPt.y;var v_trans_lensq=v_trans_x*v_trans_x+v_trans_y*v_trans_y;if(2>=v_trans_lensq)return new THREE.Vector2(v_trans_x,v_trans_y);shrink_by=Math.sqrt(v_trans_lensq/2)}else{var direction_eq=!1;v_prev_x>Number.EPSILON?v_next_x>Number.EPSILON&&(direction_eq=!0):v_prev_x<-Number.EPSILON?v_next_x<-Number.EPSILON&&(direction_eq=!0):Math.sign(v_prev_y)===Math.sign(v_next_y)&&(direction_eq=!0),direction_eq?(v_trans_x=-v_prev_y,v_trans_y=v_prev_x,shrink_by=Math.sqrt(v_prev_lensq)):(v_trans_x=v_prev_x,v_trans_y=v_prev_y,shrink_by=Math.sqrt(v_prev_lensq/2))}return new THREE.Vector2(v_trans_x/shrink_by,v_trans_y/shrink_by)}function buildLidFaces(){if(bevelEnabled){var layer=0,offset=vlen*layer;for(i=0;flen>i;i++)face=faces[i],f3(face[2]+offset,face[1]+offset,face[0]+offset);for(layer=steps+2*bevelSegments,offset=vlen*layer,i=0;flen>i;i++)face=faces[i],f3(face[0]+offset,face[1]+offset,face[2]+offset)}else{for(i=0;flen>i;i++)face=faces[i],f3(face[2],face[1],face[0]);for(i=0;flen>i;i++)face=faces[i],f3(face[0]+vlen*steps,face[1]+vlen*steps,face[2]+vlen*steps)}}function buildSideFaces(){var layeroffset=0;for(sidewalls(contour,layeroffset),layeroffset+=contour.length,h=0,hl=holes.length;hl>h;h++)ahole=holes[h],sidewalls(ahole,layeroffset),layeroffset+=ahole.length}function sidewalls(contour,layeroffset){var j,k;for(i=contour.length;--i>=0;){j=i,k=i-1,0>k&&(k=contour.length-1);var s=0,sl=steps+2*bevelSegments;for(s=0;sl>s;s++){var slen1=vlen*s,slen2=vlen*(s+1),a=layeroffset+j+slen1,b=layeroffset+k+slen1,c=layeroffset+k+slen2,d=layeroffset+j+slen2;f4(a,b,c,d,contour,s,sl,j,k)}}}function v(x,y,z){scope.vertices.push(new THREE.Vector3(x,y,z))}function f3(a,b,c){a+=shapesOffset,b+=shapesOffset,c+=shapesOffset,scope.faces.push(new THREE.Face3(a,b,c,null,null,0));var uvs=uvgen.generateTopUV(scope,a,b,c);scope.faceVertexUvs[0].push(uvs)}function f4(a,b,c,d,wallContour,stepIndex,stepsLength,contourIndex1,contourIndex2){a+=shapesOffset,b+=shapesOffset,c+=shapesOffset,d+=shapesOffset,scope.faces.push(new THREE.Face3(a,b,d,null,null,1)),scope.faces.push(new THREE.Face3(b,c,d,null,null,1));var uvs=uvgen.generateSideWallUV(scope,a,b,c,d);scope.faceVertexUvs[0].push([uvs[0],uvs[1],uvs[3]]),scope.faceVertexUvs[0].push([uvs[1],uvs[2],uvs[3]])}var extrudePts,splineTube,binormal,normal,position2,amount=void 0!==options.amount?options.amount:100,bevelThickness=void 0!==options.bevelThickness?options.bevelThickness:6,bevelSize=void 0!==options.bevelSize?options.bevelSize:bevelThickness-2,bevelSegments=void 0!==options.bevelSegments?options.bevelSegments:3,bevelEnabled=void 0!==options.bevelEnabled?options.bevelEnabled:!0,curveSegments=void 0!==options.curveSegments?options.curveSegments:12,steps=void 0!==options.steps?options.steps:1,extrudePath=options.extrudePath,extrudeByPath=!1,uvgen=void 0!==options.UVGenerator?options.UVGenerator:THREE.ExtrudeGeometry.WorldUVGenerator;extrudePath&&(extrudePts=extrudePath.getSpacedPoints(steps),extrudeByPath=!0,bevelEnabled=!1,splineTube=void 0!==options.frames?options.frames:new THREE.TubeGeometry.FrenetFrames(extrudePath,steps,!1),binormal=new THREE.Vector3,normal=new THREE.Vector3,position2=new THREE.Vector3),bevelEnabled||(bevelSegments=0,bevelThickness=0,bevelSize=0);var ahole,h,hl,scope=this,shapesOffset=this.vertices.length,shapePoints=shape.extractPoints(curveSegments),vertices=shapePoints.shape,holes=shapePoints.holes,reverse=!THREE.ShapeUtils.isClockWise(vertices);if(reverse){for(vertices=vertices.reverse(),h=0,hl=holes.length;hl>h;h++)ahole=holes[h],THREE.ShapeUtils.isClockWise(ahole)&&(holes[h]=ahole.reverse());reverse=!1}var faces=THREE.ShapeUtils.triangulateShape(vertices,holes),contour=vertices;for(h=0,hl=holes.length;hl>h;h++)ahole=holes[h],vertices=vertices.concat(ahole);for(var b,bs,t,z,vert,face,vlen=vertices.length,flen=faces.length,contourMovements=[],i=0,il=contour.length,j=il-1,k=i+1;il>i;i++,j++,k++)j===il&&(j=0),k===il&&(k=0),contourMovements[i]=getBevelVec(contour[i],contour[j],contour[k]);var oneHoleMovements,holesMovements=[],verticesMovements=contourMovements.concat();for(h=0,hl=holes.length;hl>h;h++){for(ahole=holes[h],oneHoleMovements=[],i=0,il=ahole.length,j=il-1,k=i+1;il>i;i++,j++,k++)j===il&&(j=0),k===il&&(k=0),oneHoleMovements[i]=getBevelVec(ahole[i],ahole[j],ahole[k]);holesMovements.push(oneHoleMovements),verticesMovements=verticesMovements.concat(oneHoleMovements)}for(b=0;bevelSegments>b;b++){for(t=b/bevelSegments,z=bevelThickness*(1-t),bs=bevelSize*Math.sin(t*Math.PI/2),i=0,il=contour.length;il>i;i++)vert=scalePt2(contour[i],contourMovements[i],bs),v(vert.x,vert.y,-z);for(h=0,hl=holes.length;hl>h;h++)for(ahole=holes[h],oneHoleMovements=holesMovements[h],i=0,il=ahole.length;il>i;i++)vert=scalePt2(ahole[i],oneHoleMovements[i],bs),v(vert.x,vert.y,-z)}for(bs=bevelSize,i=0;vlen>i;i++)vert=bevelEnabled?scalePt2(vertices[i],verticesMovements[i],bs):vertices[i],extrudeByPath?(normal.copy(splineTube.normals[0]).multiplyScalar(vert.x),binormal.copy(splineTube.binormals[0]).multiplyScalar(vert.y),position2.copy(extrudePts[0]).add(normal).add(binormal),v(position2.x,position2.y,position2.z)):v(vert.x,vert.y,0);var s;for(s=1;steps>=s;s++)for(i=0;vlen>i;i++)vert=bevelEnabled?scalePt2(vertices[i],verticesMovements[i],bs):vertices[i],extrudeByPath?(normal.copy(splineTube.normals[s]).multiplyScalar(vert.x),binormal.copy(splineTube.binormals[s]).multiplyScalar(vert.y),position2.copy(extrudePts[s]).add(normal).add(binormal),v(position2.x,position2.y,position2.z)):v(vert.x,vert.y,amount/steps*s);for(b=bevelSegments-1;b>=0;b--){for(t=b/bevelSegments,z=bevelThickness*(1-t),bs=bevelSize*Math.sin(t*Math.PI/2),i=0,il=contour.length;il>i;i++)vert=scalePt2(contour[i],contourMovements[i],bs),v(vert.x,vert.y,amount+z);for(h=0,hl=holes.length;hl>h;h++)for(ahole=holes[h],oneHoleMovements=holesMovements[h],i=0,il=ahole.length;il>i;i++)vert=scalePt2(ahole[i],oneHoleMovements[i],bs),extrudeByPath?v(vert.x,vert.y+extrudePts[steps-1].y,extrudePts[steps-1].x+z):v(vert.x,vert.y,amount+z)}buildLidFaces(),buildSideFaces()},THREE.ExtrudeGeometry.WorldUVGenerator={generateTopUV:function(geometry,indexA,indexB,indexC){var vertices=geometry.vertices,a=vertices[indexA],b=vertices[indexB],c=vertices[indexC];return[new THREE.Vector2(a.x,a.y),new THREE.Vector2(b.x,b.y),new THREE.Vector2(c.x,c.y)]},generateSideWallUV:function(geometry,indexA,indexB,indexC,indexD){var vertices=geometry.vertices,a=vertices[indexA],b=vertices[indexB],c=vertices[indexC],d=vertices[indexD];return Math.abs(a.y-b.y)<.01?[new THREE.Vector2(a.x,1-a.z),new THREE.Vector2(b.x,1-b.z),new THREE.Vector2(c.x,1-c.z),new THREE.Vector2(d.x,1-d.z)]:[new THREE.Vector2(a.y,1-a.z),new THREE.Vector2(b.y,1-b.z),new THREE.Vector2(c.y,1-c.z),new THREE.Vector2(d.y,1-d.z)]}},THREE.ShapeGeometry=function(shapes,options){THREE.Geometry.call(this),this.type="ShapeGeometry",Array.isArray(shapes)===!1&&(shapes=[shapes]),this.addShapeList(shapes,options),this.computeFaceNormals()},THREE.ShapeGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.ShapeGeometry.prototype.constructor=THREE.ShapeGeometry,THREE.ShapeGeometry.prototype.addShapeList=function(shapes,options){for(var i=0,l=shapes.length;l>i;i++)this.addShape(shapes[i],options);return this},THREE.ShapeGeometry.prototype.addShape=function(shape,options){void 0===options&&(options={});var i,l,hole,curveSegments=void 0!==options.curveSegments?options.curveSegments:12,material=options.material,uvgen=void 0===options.UVGenerator?THREE.ExtrudeGeometry.WorldUVGenerator:options.UVGenerator,shapesOffset=this.vertices.length,shapePoints=shape.extractPoints(curveSegments),vertices=shapePoints.shape,holes=shapePoints.holes,reverse=!THREE.ShapeUtils.isClockWise(vertices);if(reverse){for(vertices=vertices.reverse(),i=0,l=holes.length;l>i;i++)hole=holes[i],THREE.ShapeUtils.isClockWise(hole)&&(holes[i]=hole.reverse());reverse=!1}var faces=THREE.ShapeUtils.triangulateShape(vertices,holes);for(i=0,l=holes.length;l>i;i++)hole=holes[i],vertices=vertices.concat(hole);var vert,face,vlen=vertices.length,flen=faces.length;for(i=0;vlen>i;i++)vert=vertices[i],this.vertices.push(new THREE.Vector3(vert.x,vert.y,0));for(i=0;flen>i;i++){face=faces[i];var a=face[0]+shapesOffset,b=face[1]+shapesOffset,c=face[2]+shapesOffset;this.faces.push(new THREE.Face3(a,b,c,null,null,material)),this.faceVertexUvs[0].push(uvgen.generateTopUV(this,a,b,c))}},THREE.LatheBufferGeometry=function(points,segments,phiStart,phiLength){THREE.BufferGeometry.call(this),this.type="LatheBufferGeometry",this.parameters={points:points,segments:segments,phiStart:phiStart,phiLength:phiLength},segments=Math.floor(segments)||12,phiStart=phiStart||0,phiLength=phiLength||2*Math.PI,phiLength=THREE.Math.clamp(phiLength,0,2*Math.PI);var base,i,j,vertexCount=(segments+1)*points.length,indexCount=segments*points.length*2*3,indices=new THREE.BufferAttribute(new(indexCount>65535?Uint32Array:Uint16Array)(indexCount),1),vertices=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),uvs=new THREE.BufferAttribute(new Float32Array(2*vertexCount),2),index=0,indexOffset=0,inverseSegments=(1/(points.length-1),1/segments),vertex=new THREE.Vector3,uv=new THREE.Vector2;for(i=0;segments>=i;i++){var phi=phiStart+i*inverseSegments*phiLength,sin=Math.sin(phi),cos=Math.cos(phi);for(j=0;j<=points.length-1;j++)vertex.x=points[j].x*sin,vertex.y=points[j].y,vertex.z=points[j].x*cos,vertices.setXYZ(index,vertex.x,vertex.y,vertex.z),uv.x=i/segments,uv.y=j/(points.length-1),uvs.setXY(index,uv.x,uv.y),index++}for(i=0;segments>i;i++)for(j=0;j<points.length-1;j++){base=j+i*points.length;var a=base,b=base+points.length,c=base+points.length+1,d=base+1;indices.setX(indexOffset,a),indexOffset++,indices.setX(indexOffset,b),indexOffset++,indices.setX(indexOffset,d),indexOffset++,indices.setX(indexOffset,b),indexOffset++,indices.setX(indexOffset,c),indexOffset++,indices.setX(indexOffset,d),indexOffset++}if(this.setIndex(indices),this.addAttribute("position",vertices),this.addAttribute("uv",uvs),this.computeVertexNormals(),phiLength===2*Math.PI){var normals=this.attributes.normal.array,n1=new THREE.Vector3,n2=new THREE.Vector3,n=new THREE.Vector3;for(base=segments*points.length*3,i=0,j=0;i<points.length;i++,j+=3)n1.x=normals[j+0],n1.y=normals[j+1],n1.z=normals[j+2],n2.x=normals[base+j+0],n2.y=normals[base+j+1],n2.z=normals[base+j+2],n.addVectors(n1,n2).normalize(),normals[j+0]=normals[base+j+0]=n.x,normals[j+1]=normals[base+j+1]=n.y,normals[j+2]=normals[base+j+2]=n.z}},THREE.LatheBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.LatheBufferGeometry.prototype.constructor=THREE.LatheBufferGeometry,THREE.LatheGeometry=function(points,segments,phiStart,phiLength){THREE.Geometry.call(this),this.type="LatheGeometry",this.parameters={points:points,segments:segments,phiStart:phiStart,phiLength:phiLength},this.fromBufferGeometry(new THREE.LatheBufferGeometry(points,segments,phiStart,phiLength)),this.mergeVertices()},THREE.LatheGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.LatheGeometry.prototype.constructor=THREE.LatheGeometry,THREE.PlaneGeometry=function(width,height,widthSegments,heightSegments){THREE.Geometry.call(this),this.type="PlaneGeometry",this.parameters={width:width,height:height,widthSegments:widthSegments,heightSegments:heightSegments},this.fromBufferGeometry(new THREE.PlaneBufferGeometry(width,height,widthSegments,heightSegments))},THREE.PlaneGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.PlaneGeometry.prototype.constructor=THREE.PlaneGeometry,THREE.PlaneBufferGeometry=function(width,height,widthSegments,heightSegments){THREE.BufferGeometry.call(this),this.type="PlaneBufferGeometry",this.parameters={width:width,height:height,widthSegments:widthSegments,heightSegments:heightSegments};for(var width_half=width/2,height_half=height/2,gridX=Math.floor(widthSegments)||1,gridY=Math.floor(heightSegments)||1,gridX1=gridX+1,gridY1=gridY+1,segment_width=width/gridX,segment_height=height/gridY,vertices=new Float32Array(gridX1*gridY1*3),normals=new Float32Array(gridX1*gridY1*3),uvs=new Float32Array(gridX1*gridY1*2),offset=0,offset2=0,iy=0;gridY1>iy;iy++)for(var y=iy*segment_height-height_half,ix=0;gridX1>ix;ix++){var x=ix*segment_width-width_half;vertices[offset]=x,vertices[offset+1]=-y,normals[offset+2]=1,uvs[offset2]=ix/gridX,uvs[offset2+1]=1-iy/gridY,offset+=3,offset2+=2}offset=0;for(var indices=new(vertices.length/3>65535?Uint32Array:Uint16Array)(gridX*gridY*6),iy=0;gridY>iy;iy++)for(var ix=0;gridX>ix;ix++){var a=ix+gridX1*iy,b=ix+gridX1*(iy+1),c=ix+1+gridX1*(iy+1),d=ix+1+gridX1*iy;indices[offset]=a,indices[offset+1]=b,indices[offset+2]=d,indices[offset+3]=b,indices[offset+4]=c,indices[offset+5]=d,offset+=6}this.setIndex(new THREE.BufferAttribute(indices,1)),this.addAttribute("position",new THREE.BufferAttribute(vertices,3)),this.addAttribute("normal",new THREE.BufferAttribute(normals,3)),this.addAttribute("uv",new THREE.BufferAttribute(uvs,2))},THREE.PlaneBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.PlaneBufferGeometry.prototype.constructor=THREE.PlaneBufferGeometry,THREE.RingBufferGeometry=function(innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength){THREE.BufferGeometry.call(this),this.type="RingBufferGeometry",this.parameters={innerRadius:innerRadius,outerRadius:outerRadius,thetaSegments:thetaSegments,phiSegments:phiSegments,thetaStart:thetaStart,thetaLength:thetaLength},innerRadius=innerRadius||20,outerRadius=outerRadius||50,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:2*Math.PI,thetaSegments=void 0!==thetaSegments?Math.max(3,thetaSegments):8,phiSegments=void 0!==phiSegments?Math.max(1,phiSegments):1;var segment,j,i,vertexCount=(thetaSegments+1)*(phiSegments+1),indexCount=thetaSegments*phiSegments*2*3,indices=new THREE.BufferAttribute(new(indexCount>65535?Uint32Array:Uint16Array)(indexCount),1),vertices=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),normals=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),uvs=new THREE.BufferAttribute(new Float32Array(2*vertexCount),2),index=0,indexOffset=0,radius=innerRadius,radiusStep=(outerRadius-innerRadius)/phiSegments,vertex=new THREE.Vector3,uv=new THREE.Vector2;for(j=0;phiSegments>=j;j++){for(i=0;thetaSegments>=i;i++)segment=thetaStart+i/thetaSegments*thetaLength,vertex.x=radius*Math.cos(segment),vertex.y=radius*Math.sin(segment),vertices.setXYZ(index,vertex.x,vertex.y,vertex.z),normals.setXYZ(index,0,0,1),uv.x=(vertex.x/outerRadius+1)/2,uv.y=(vertex.y/outerRadius+1)/2,uvs.setXY(index,uv.x,uv.y),index++;radius+=radiusStep}for(j=0;phiSegments>j;j++){var thetaSegmentLevel=j*(thetaSegments+1);for(i=0;thetaSegments>i;i++){segment=i+thetaSegmentLevel;var a=segment,b=segment+thetaSegments+1,c=segment+thetaSegments+2,d=segment+1;indices.setX(indexOffset,a),indexOffset++,indices.setX(indexOffset,b),indexOffset++,indices.setX(indexOffset,c),indexOffset++,indices.setX(indexOffset,a),indexOffset++,indices.setX(indexOffset,c),indexOffset++,indices.setX(indexOffset,d),indexOffset++}}this.setIndex(indices),this.addAttribute("position",vertices),this.addAttribute("normal",normals),this.addAttribute("uv",uvs)},THREE.RingBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.RingBufferGeometry.prototype.constructor=THREE.RingBufferGeometry,THREE.RingGeometry=function(innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength){THREE.Geometry.call(this),this.type="RingGeometry",this.parameters={innerRadius:innerRadius,outerRadius:outerRadius,thetaSegments:thetaSegments,phiSegments:phiSegments,thetaStart:thetaStart,thetaLength:thetaLength},this.fromBufferGeometry(new THREE.RingBufferGeometry(innerRadius,outerRadius,thetaSegments,phiSegments,thetaStart,thetaLength))},THREE.RingGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.RingGeometry.prototype.constructor=THREE.RingGeometry,THREE.SphereGeometry=function(radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength){THREE.Geometry.call(this),this.type="SphereGeometry",this.parameters={radius:radius,widthSegments:widthSegments,heightSegments:heightSegments,phiStart:phiStart,phiLength:phiLength,thetaStart:thetaStart,thetaLength:thetaLength},this.fromBufferGeometry(new THREE.SphereBufferGeometry(radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength))},THREE.SphereGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.SphereGeometry.prototype.constructor=THREE.SphereGeometry,THREE.SphereBufferGeometry=function(radius,widthSegments,heightSegments,phiStart,phiLength,thetaStart,thetaLength){THREE.BufferGeometry.call(this),this.type="SphereBufferGeometry",this.parameters={radius:radius,widthSegments:widthSegments,heightSegments:heightSegments,phiStart:phiStart,phiLength:phiLength,thetaStart:thetaStart,thetaLength:thetaLength},radius=radius||50,widthSegments=Math.max(3,Math.floor(widthSegments)||8),heightSegments=Math.max(2,Math.floor(heightSegments)||6),phiStart=void 0!==phiStart?phiStart:0,phiLength=void 0!==phiLength?phiLength:2*Math.PI,thetaStart=void 0!==thetaStart?thetaStart:0,thetaLength=void 0!==thetaLength?thetaLength:Math.PI;for(var thetaEnd=thetaStart+thetaLength,vertexCount=(widthSegments+1)*(heightSegments+1),positions=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),normals=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),uvs=new THREE.BufferAttribute(new Float32Array(2*vertexCount),2),index=0,vertices=[],normal=new THREE.Vector3,y=0;heightSegments>=y;y++){for(var verticesRow=[],v=y/heightSegments,x=0;widthSegments>=x;x++){var u=x/widthSegments,px=-radius*Math.cos(phiStart+u*phiLength)*Math.sin(thetaStart+v*thetaLength),py=radius*Math.cos(thetaStart+v*thetaLength),pz=radius*Math.sin(phiStart+u*phiLength)*Math.sin(thetaStart+v*thetaLength);normal.set(px,py,pz).normalize(),positions.setXYZ(index,px,py,pz),normals.setXYZ(index,normal.x,normal.y,normal.z),uvs.setXY(index,u,1-v),verticesRow.push(index),index++}vertices.push(verticesRow)}for(var indices=[],y=0;heightSegments>y;y++)for(var x=0;widthSegments>x;x++){var v1=vertices[y][x+1],v2=vertices[y][x],v3=vertices[y+1][x],v4=vertices[y+1][x+1];(0!==y||thetaStart>0)&&indices.push(v1,v2,v4),(y!==heightSegments-1||thetaEnd<Math.PI)&&indices.push(v2,v3,v4)}this.setIndex(new(positions.count>65535?THREE.Uint32Attribute:THREE.Uint16Attribute)(indices,1)),this.addAttribute("position",positions),this.addAttribute("normal",normals),this.addAttribute("uv",uvs),this.boundingSphere=new THREE.Sphere(new THREE.Vector3,radius)},THREE.SphereBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.SphereBufferGeometry.prototype.constructor=THREE.SphereBufferGeometry,THREE.TextGeometry=function(text,parameters){parameters=parameters||{};var font=parameters.font;if(font instanceof THREE.Font==!1)return console.error("THREE.TextGeometry: font parameter is not an instance of THREE.Font."),new THREE.Geometry;var shapes=font.generateShapes(text,parameters.size,parameters.curveSegments);parameters.amount=void 0!==parameters.height?parameters.height:50,void 0===parameters.bevelThickness&&(parameters.bevelThickness=10),void 0===parameters.bevelSize&&(parameters.bevelSize=8),void 0===parameters.bevelEnabled&&(parameters.bevelEnabled=!1),THREE.ExtrudeGeometry.call(this,shapes,parameters),this.type="TextGeometry"},THREE.TextGeometry.prototype=Object.create(THREE.ExtrudeGeometry.prototype),THREE.TextGeometry.prototype.constructor=THREE.TextGeometry,THREE.TorusBufferGeometry=function(radius,tube,radialSegments,tubularSegments,arc){THREE.BufferGeometry.call(this),this.type="TorusBufferGeometry",this.parameters={radius:radius,tube:tube,radialSegments:radialSegments,tubularSegments:tubularSegments,arc:arc},radius=radius||100,tube=tube||40,radialSegments=Math.floor(radialSegments)||8,tubularSegments=Math.floor(tubularSegments)||6,arc=arc||2*Math.PI;var j,i,vertexCount=(radialSegments+1)*(tubularSegments+1),indexCount=radialSegments*tubularSegments*2*3,indices=new(indexCount>65535?Uint32Array:Uint16Array)(indexCount),vertices=new Float32Array(3*vertexCount),normals=new Float32Array(3*vertexCount),uvs=new Float32Array(2*vertexCount),vertexBufferOffset=0,uvBufferOffset=0,indexBufferOffset=0,center=new THREE.Vector3,vertex=new THREE.Vector3,normal=new THREE.Vector3;for(j=0;radialSegments>=j;j++)for(i=0;tubularSegments>=i;i++){var u=i/tubularSegments*arc,v=j/radialSegments*Math.PI*2;vertex.x=(radius+tube*Math.cos(v))*Math.cos(u),vertex.y=(radius+tube*Math.cos(v))*Math.sin(u),vertex.z=tube*Math.sin(v),vertices[vertexBufferOffset]=vertex.x,vertices[vertexBufferOffset+1]=vertex.y,vertices[vertexBufferOffset+2]=vertex.z,center.x=radius*Math.cos(u),center.y=radius*Math.sin(u),normal.subVectors(vertex,center).normalize(),normals[vertexBufferOffset]=normal.x,normals[vertexBufferOffset+1]=normal.y,normals[vertexBufferOffset+2]=normal.z,uvs[uvBufferOffset]=i/tubularSegments,uvs[uvBufferOffset+1]=j/radialSegments,vertexBufferOffset+=3,uvBufferOffset+=2}for(j=1;radialSegments>=j;j++)for(i=1;tubularSegments>=i;i++){var a=(tubularSegments+1)*j+i-1,b=(tubularSegments+1)*(j-1)+i-1,c=(tubularSegments+1)*(j-1)+i,d=(tubularSegments+1)*j+i;indices[indexBufferOffset]=a,indices[indexBufferOffset+1]=b,indices[indexBufferOffset+2]=d,indices[indexBufferOffset+3]=b,indices[indexBufferOffset+4]=c,indices[indexBufferOffset+5]=d,indexBufferOffset+=6}this.setIndex(new THREE.BufferAttribute(indices,1)),this.addAttribute("position",new THREE.BufferAttribute(vertices,3)),this.addAttribute("normal",new THREE.BufferAttribute(normals,3)),this.addAttribute("uv",new THREE.BufferAttribute(uvs,2))},THREE.TorusBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.TorusBufferGeometry.prototype.constructor=THREE.TorusBufferGeometry,THREE.TorusGeometry=function(radius,tube,radialSegments,tubularSegments,arc){THREE.Geometry.call(this),this.type="TorusGeometry",this.parameters={radius:radius,tube:tube,radialSegments:radialSegments,tubularSegments:tubularSegments,arc:arc},this.fromBufferGeometry(new THREE.TorusBufferGeometry(radius,tube,radialSegments,tubularSegments,arc))},THREE.TorusGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.TorusGeometry.prototype.constructor=THREE.TorusGeometry,
THREE.TorusKnotBufferGeometry=function(radius,tube,tubularSegments,radialSegments,p,q){function calculatePositionOnCurve(u,p,q,radius,position){var cu=Math.cos(u),su=Math.sin(u),quOverP=q/p*u,cs=Math.cos(quOverP);position.x=radius*(2+cs)*.5*cu,position.y=radius*(2+cs)*su*.5,position.z=radius*Math.sin(quOverP)*.5}THREE.BufferGeometry.call(this),this.type="TorusKnotBufferGeometry",this.parameters={radius:radius,tube:tube,tubularSegments:tubularSegments,radialSegments:radialSegments,p:p,q:q},radius=radius||100,tube=tube||40,tubularSegments=Math.floor(tubularSegments)||64,radialSegments=Math.floor(radialSegments)||8,p=p||2,q=q||3;var i,j,vertexCount=(radialSegments+1)*(tubularSegments+1),indexCount=radialSegments*tubularSegments*2*3,indices=new THREE.BufferAttribute(new(indexCount>65535?Uint32Array:Uint16Array)(indexCount),1),vertices=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),normals=new THREE.BufferAttribute(new Float32Array(3*vertexCount),3),uvs=new THREE.BufferAttribute(new Float32Array(2*vertexCount),2),index=0,indexOffset=0,vertex=new THREE.Vector3,normal=new THREE.Vector3,uv=new THREE.Vector2,P1=new THREE.Vector3,P2=new THREE.Vector3,B=new THREE.Vector3,T=new THREE.Vector3,N=new THREE.Vector3;for(i=0;tubularSegments>=i;++i){var u=i/tubularSegments*p*Math.PI*2;for(calculatePositionOnCurve(u,p,q,radius,P1),calculatePositionOnCurve(u+.01,p,q,radius,P2),T.subVectors(P2,P1),N.addVectors(P2,P1),B.crossVectors(T,N),N.crossVectors(B,T),B.normalize(),N.normalize(),j=0;radialSegments>=j;++j){var v=j/radialSegments*Math.PI*2,cx=-tube*Math.cos(v),cy=tube*Math.sin(v);vertex.x=P1.x+(cx*N.x+cy*B.x),vertex.y=P1.y+(cx*N.y+cy*B.y),vertex.z=P1.z+(cx*N.z+cy*B.z),vertices.setXYZ(index,vertex.x,vertex.y,vertex.z),normal.subVectors(vertex,P1).normalize(),normals.setXYZ(index,normal.x,normal.y,normal.z),uv.x=i/tubularSegments,uv.y=j/radialSegments,uvs.setXY(index,uv.x,uv.y),index++}}for(j=1;tubularSegments>=j;j++)for(i=1;radialSegments>=i;i++){var a=(radialSegments+1)*(j-1)+(i-1),b=(radialSegments+1)*j+(i-1),c=(radialSegments+1)*j+i,d=(radialSegments+1)*(j-1)+i;indices.setX(indexOffset,a),indexOffset++,indices.setX(indexOffset,b),indexOffset++,indices.setX(indexOffset,d),indexOffset++,indices.setX(indexOffset,b),indexOffset++,indices.setX(indexOffset,c),indexOffset++,indices.setX(indexOffset,d),indexOffset++}this.setIndex(indices),this.addAttribute("position",vertices),this.addAttribute("normal",normals),this.addAttribute("uv",uvs)},THREE.TorusKnotBufferGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.TorusKnotBufferGeometry.prototype.constructor=THREE.TorusKnotBufferGeometry,THREE.TorusKnotGeometry=function(radius,tube,tubularSegments,radialSegments,p,q,heightScale){THREE.Geometry.call(this),this.type="TorusKnotGeometry",this.parameters={radius:radius,tube:tube,tubularSegments:tubularSegments,radialSegments:radialSegments,p:p,q:q},void 0!==heightScale&&console.warn("THREE.TorusKnotGeometry: heightScale has been deprecated. Use .scale( x, y, z ) instead."),this.fromBufferGeometry(new THREE.TorusKnotBufferGeometry(radius,tube,tubularSegments,radialSegments,p,q)),this.mergeVertices()},THREE.TorusKnotGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.TorusKnotGeometry.prototype.constructor=THREE.TorusKnotGeometry,THREE.TubeGeometry=function(path,segments,radius,radialSegments,closed,taper){function vert(x,y,z){return scope.vertices.push(new THREE.Vector3(x,y,z))-1}THREE.Geometry.call(this),this.type="TubeGeometry",this.parameters={path:path,segments:segments,radius:radius,radialSegments:radialSegments,closed:closed,taper:taper},segments=segments||64,radius=radius||1,radialSegments=radialSegments||8,closed=closed||!1,taper=taper||THREE.TubeGeometry.NoTaper;var tangent,normal,binormal,u,v,r,cx,cy,pos,i,j,ip,jp,a,b,c,d,uva,uvb,uvc,uvd,grid=[],scope=this,numpoints=segments+1,pos2=new THREE.Vector3,frames=new THREE.TubeGeometry.FrenetFrames(path,segments,closed),tangents=frames.tangents,normals=frames.normals,binormals=frames.binormals;for(this.tangents=tangents,this.normals=normals,this.binormals=binormals,i=0;numpoints>i;i++)for(grid[i]=[],u=i/(numpoints-1),pos=path.getPointAt(u),tangent=tangents[i],normal=normals[i],binormal=binormals[i],r=radius*taper(u),j=0;radialSegments>j;j++)v=j/radialSegments*2*Math.PI,cx=-r*Math.cos(v),cy=r*Math.sin(v),pos2.copy(pos),pos2.x+=cx*normal.x+cy*binormal.x,pos2.y+=cx*normal.y+cy*binormal.y,pos2.z+=cx*normal.z+cy*binormal.z,grid[i][j]=vert(pos2.x,pos2.y,pos2.z);for(i=0;segments>i;i++)for(j=0;radialSegments>j;j++)ip=closed?(i+1)%segments:i+1,jp=(j+1)%radialSegments,a=grid[i][j],b=grid[ip][j],c=grid[ip][jp],d=grid[i][jp],uva=new THREE.Vector2(i/segments,j/radialSegments),uvb=new THREE.Vector2((i+1)/segments,j/radialSegments),uvc=new THREE.Vector2((i+1)/segments,(j+1)/radialSegments),uvd=new THREE.Vector2(i/segments,(j+1)/radialSegments),this.faces.push(new THREE.Face3(a,b,d)),this.faceVertexUvs[0].push([uva,uvb,uvd]),this.faces.push(new THREE.Face3(b,c,d)),this.faceVertexUvs[0].push([uvb.clone(),uvc,uvd.clone()]);this.computeFaceNormals(),this.computeVertexNormals()},THREE.TubeGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.TubeGeometry.prototype.constructor=THREE.TubeGeometry,THREE.TubeGeometry.NoTaper=function(u){return 1},THREE.TubeGeometry.SinusoidalTaper=function(u){return Math.sin(Math.PI*u)},THREE.TubeGeometry.FrenetFrames=function(path,segments,closed){function initialNormal3(){normals[0]=new THREE.Vector3,binormals[0]=new THREE.Vector3,smallest=Number.MAX_VALUE,tx=Math.abs(tangents[0].x),ty=Math.abs(tangents[0].y),tz=Math.abs(tangents[0].z),smallest>=tx&&(smallest=tx,normal.set(1,0,0)),smallest>=ty&&(smallest=ty,normal.set(0,1,0)),smallest>=tz&&normal.set(0,0,1),vec.crossVectors(tangents[0],normal).normalize(),normals[0].crossVectors(tangents[0],vec),binormals[0].crossVectors(tangents[0],normals[0])}var theta,smallest,tx,ty,tz,i,u,normal=new THREE.Vector3,tangents=[],normals=[],binormals=[],vec=new THREE.Vector3,mat=new THREE.Matrix4,numpoints=segments+1;for(this.tangents=tangents,this.normals=normals,this.binormals=binormals,i=0;numpoints>i;i++)u=i/(numpoints-1),tangents[i]=path.getTangentAt(u),tangents[i].normalize();for(initialNormal3(),i=1;numpoints>i;i++)normals[i]=normals[i-1].clone(),binormals[i]=binormals[i-1].clone(),vec.crossVectors(tangents[i-1],tangents[i]),vec.length()>Number.EPSILON&&(vec.normalize(),theta=Math.acos(THREE.Math.clamp(tangents[i-1].dot(tangents[i]),-1,1)),normals[i].applyMatrix4(mat.makeRotationAxis(vec,theta))),binormals[i].crossVectors(tangents[i],normals[i]);if(closed)for(theta=Math.acos(THREE.Math.clamp(normals[0].dot(normals[numpoints-1]),-1,1)),theta/=numpoints-1,tangents[0].dot(vec.crossVectors(normals[0],normals[numpoints-1]))>0&&(theta=-theta),i=1;numpoints>i;i++)normals[i].applyMatrix4(mat.makeRotationAxis(tangents[i],theta*i)),binormals[i].crossVectors(tangents[i],normals[i])},THREE.PolyhedronGeometry=function(vertices,indices,radius,detail){function prepare(vector){var vertex=vector.normalize().clone();vertex.index=that.vertices.push(vertex)-1;var u=azimuth(vector)/2/Math.PI+.5,v=inclination(vector)/Math.PI+.5;return vertex.uv=new THREE.Vector2(u,1-v),vertex}function make(v1,v2,v3,materialIndex){var face=new THREE.Face3(v1.index,v2.index,v3.index,[v1.clone(),v2.clone(),v3.clone()],void 0,materialIndex);that.faces.push(face),centroid.copy(v1).add(v2).add(v3).divideScalar(3);var azi=azimuth(centroid);that.faceVertexUvs[0].push([correctUV(v1.uv,v1,azi),correctUV(v2.uv,v2,azi),correctUV(v3.uv,v3,azi)])}function subdivide(face,detail){for(var cols=Math.pow(2,detail),a=prepare(that.vertices[face.a]),b=prepare(that.vertices[face.b]),c=prepare(that.vertices[face.c]),v=[],materialIndex=face.materialIndex,i=0;cols>=i;i++){v[i]=[];for(var aj=prepare(a.clone().lerp(c,i/cols)),bj=prepare(b.clone().lerp(c,i/cols)),rows=cols-i,j=0;rows>=j;j++)0===j&&i===cols?v[i][j]=aj:v[i][j]=prepare(aj.clone().lerp(bj,j/rows))}for(var i=0;cols>i;i++)for(var j=0;2*(cols-i)-1>j;j++){var k=Math.floor(j/2);j%2===0?make(v[i][k+1],v[i+1][k],v[i][k],materialIndex):make(v[i][k+1],v[i+1][k+1],v[i+1][k],materialIndex)}}function azimuth(vector){return Math.atan2(vector.z,-vector.x)}function inclination(vector){return Math.atan2(-vector.y,Math.sqrt(vector.x*vector.x+vector.z*vector.z))}function correctUV(uv,vector,azimuth){return 0>azimuth&&1===uv.x&&(uv=new THREE.Vector2(uv.x-1,uv.y)),0===vector.x&&0===vector.z&&(uv=new THREE.Vector2(azimuth/2/Math.PI+.5,uv.y)),uv.clone()}THREE.Geometry.call(this),this.type="PolyhedronGeometry",this.parameters={vertices:vertices,indices:indices,radius:radius,detail:detail},radius=radius||1,detail=detail||0;for(var that=this,i=0,l=vertices.length;l>i;i+=3)prepare(new THREE.Vector3(vertices[i],vertices[i+1],vertices[i+2]));for(var p=this.vertices,faces=[],i=0,j=0,l=indices.length;l>i;i+=3,j++){var v1=p[indices[i]],v2=p[indices[i+1]],v3=p[indices[i+2]];faces[j]=new THREE.Face3(v1.index,v2.index,v3.index,[v1.clone(),v2.clone(),v3.clone()],void 0,j)}for(var centroid=new THREE.Vector3,i=0,l=faces.length;l>i;i++)subdivide(faces[i],detail);for(var i=0,l=this.faceVertexUvs[0].length;l>i;i++){var uvs=this.faceVertexUvs[0][i],x0=uvs[0].x,x1=uvs[1].x,x2=uvs[2].x,max=Math.max(x0,x1,x2),min=Math.min(x0,x1,x2);max>.9&&.1>min&&(.2>x0&&(uvs[0].x+=1),.2>x1&&(uvs[1].x+=1),.2>x2&&(uvs[2].x+=1))}for(var i=0,l=this.vertices.length;l>i;i++)this.vertices[i].multiplyScalar(radius);this.mergeVertices(),this.computeFaceNormals(),this.boundingSphere=new THREE.Sphere(new THREE.Vector3,radius)},THREE.PolyhedronGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.PolyhedronGeometry.prototype.constructor=THREE.PolyhedronGeometry,THREE.DodecahedronGeometry=function(radius,detail){var t=(1+Math.sqrt(5))/2,r=1/t,vertices=[-1,-1,-1,-1,-1,1,-1,1,-1,-1,1,1,1,-1,-1,1,-1,1,1,1,-1,1,1,1,0,-r,-t,0,-r,t,0,r,-t,0,r,t,-r,-t,0,-r,t,0,r,-t,0,r,t,0,-t,0,-r,t,0,-r,-t,0,r,t,0,r],indices=[3,11,7,3,7,15,3,15,13,7,19,17,7,17,6,7,6,15,17,4,8,17,8,10,17,10,6,8,0,16,8,16,2,8,2,10,0,12,1,0,1,18,0,18,16,6,10,2,6,2,13,6,13,15,2,16,18,2,18,3,2,3,13,18,1,9,18,9,11,18,11,3,4,14,12,4,12,0,4,0,8,11,9,5,11,5,19,11,19,7,19,5,14,19,14,4,19,4,17,1,12,14,1,14,5,1,5,9];THREE.PolyhedronGeometry.call(this,vertices,indices,radius,detail),this.type="DodecahedronGeometry",this.parameters={radius:radius,detail:detail}},THREE.DodecahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.DodecahedronGeometry.prototype.constructor=THREE.DodecahedronGeometry,THREE.IcosahedronGeometry=function(radius,detail){var t=(1+Math.sqrt(5))/2,vertices=[-1,t,0,1,t,0,-1,-t,0,1,-t,0,0,-1,t,0,1,t,0,-1,-t,0,1,-t,t,0,-1,t,0,1,-t,0,-1,-t,0,1],indices=[0,11,5,0,5,1,0,1,7,0,7,10,0,10,11,1,5,9,5,11,4,11,10,2,10,7,6,7,1,8,3,9,4,3,4,2,3,2,6,3,6,8,3,8,9,4,9,5,2,4,11,6,2,10,8,6,7,9,8,1];THREE.PolyhedronGeometry.call(this,vertices,indices,radius,detail),this.type="IcosahedronGeometry",this.parameters={radius:radius,detail:detail}},THREE.IcosahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.IcosahedronGeometry.prototype.constructor=THREE.IcosahedronGeometry,THREE.OctahedronGeometry=function(radius,detail){var vertices=[1,0,0,-1,0,0,0,1,0,0,-1,0,0,0,1,0,0,-1],indices=[0,2,4,0,4,3,0,3,5,0,5,2,1,2,5,1,5,3,1,3,4,1,4,2];THREE.PolyhedronGeometry.call(this,vertices,indices,radius,detail),this.type="OctahedronGeometry",this.parameters={radius:radius,detail:detail}},THREE.OctahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.OctahedronGeometry.prototype.constructor=THREE.OctahedronGeometry,THREE.TetrahedronGeometry=function(radius,detail){var vertices=[1,1,1,-1,-1,1,-1,1,-1,1,-1,-1],indices=[2,1,0,0,3,2,1,3,0,2,3,1];THREE.PolyhedronGeometry.call(this,vertices,indices,radius,detail),this.type="TetrahedronGeometry",this.parameters={radius:radius,detail:detail}},THREE.TetrahedronGeometry.prototype=Object.create(THREE.PolyhedronGeometry.prototype),THREE.TetrahedronGeometry.prototype.constructor=THREE.TetrahedronGeometry,THREE.ParametricGeometry=function(func,slices,stacks){THREE.Geometry.call(this),this.type="ParametricGeometry",this.parameters={func:func,slices:slices,stacks:stacks};var i,j,p,u,v,verts=this.vertices,faces=this.faces,uvs=this.faceVertexUvs[0],sliceCount=slices+1;for(i=0;stacks>=i;i++)for(v=i/stacks,j=0;slices>=j;j++)u=j/slices,p=func(u,v),verts.push(p);var a,b,c,d,uva,uvb,uvc,uvd;for(i=0;stacks>i;i++)for(j=0;slices>j;j++)a=i*sliceCount+j,b=i*sliceCount+j+1,c=(i+1)*sliceCount+j+1,d=(i+1)*sliceCount+j,uva=new THREE.Vector2(j/slices,i/stacks),uvb=new THREE.Vector2((j+1)/slices,i/stacks),uvc=new THREE.Vector2((j+1)/slices,(i+1)/stacks),uvd=new THREE.Vector2(j/slices,(i+1)/stacks),faces.push(new THREE.Face3(a,b,d)),uvs.push([uva,uvb,uvd]),faces.push(new THREE.Face3(b,c,d)),uvs.push([uvb.clone(),uvc,uvd.clone()]);this.computeFaceNormals(),this.computeVertexNormals()},THREE.ParametricGeometry.prototype=Object.create(THREE.Geometry.prototype),THREE.ParametricGeometry.prototype.constructor=THREE.ParametricGeometry,THREE.WireframeGeometry=function(geometry){function sortFunction(a,b){return a-b}THREE.BufferGeometry.call(this);var edge=[0,0],hash={},keys=["a","b","c"];if(geometry instanceof THREE.Geometry){for(var vertices=geometry.vertices,faces=geometry.faces,numEdges=0,edges=new Uint32Array(6*faces.length),i=0,l=faces.length;l>i;i++)for(var face=faces[i],j=0;3>j;j++){edge[0]=face[keys[j]],edge[1]=face[keys[(j+1)%3]],edge.sort(sortFunction);var key=edge.toString();void 0===hash[key]&&(edges[2*numEdges]=edge[0],edges[2*numEdges+1]=edge[1],hash[key]=!0,numEdges++)}for(var coords=new Float32Array(2*numEdges*3),i=0,l=numEdges;l>i;i++)for(var j=0;2>j;j++){var vertex=vertices[edges[2*i+j]],index=6*i+3*j;coords[index+0]=vertex.x,coords[index+1]=vertex.y,coords[index+2]=vertex.z}this.addAttribute("position",new THREE.BufferAttribute(coords,3))}else if(geometry instanceof THREE.BufferGeometry)if(null!==geometry.index){var indices=geometry.index.array,vertices=geometry.attributes.position,groups=geometry.groups,numEdges=0;0===groups.length&&geometry.addGroup(0,indices.length);for(var edges=new Uint32Array(2*indices.length),o=0,ol=groups.length;ol>o;++o)for(var group=groups[o],start=group.start,count=group.count,i=start,il=start+count;il>i;i+=3)for(var j=0;3>j;j++){edge[0]=indices[i+j],edge[1]=indices[i+(j+1)%3],edge.sort(sortFunction);var key=edge.toString();void 0===hash[key]&&(edges[2*numEdges]=edge[0],edges[2*numEdges+1]=edge[1],hash[key]=!0,numEdges++)}for(var coords=new Float32Array(2*numEdges*3),i=0,l=numEdges;l>i;i++)for(var j=0;2>j;j++){var index=6*i+3*j,index2=edges[2*i+j];coords[index+0]=vertices.getX(index2),coords[index+1]=vertices.getY(index2),coords[index+2]=vertices.getZ(index2)}this.addAttribute("position",new THREE.BufferAttribute(coords,3))}else{for(var vertices=geometry.attributes.position.array,numEdges=vertices.length/3,numTris=numEdges/3,coords=new Float32Array(2*numEdges*3),i=0,l=numTris;l>i;i++)for(var j=0;3>j;j++){var index=18*i+6*j,index1=9*i+3*j;coords[index+0]=vertices[index1],coords[index+1]=vertices[index1+1],coords[index+2]=vertices[index1+2];var index2=9*i+3*((j+1)%3);coords[index+3]=vertices[index2],coords[index+4]=vertices[index2+1],coords[index+5]=vertices[index2+2]}this.addAttribute("position",new THREE.BufferAttribute(coords,3))}},THREE.WireframeGeometry.prototype=Object.create(THREE.BufferGeometry.prototype),THREE.WireframeGeometry.prototype.constructor=THREE.WireframeGeometry,THREE.AxisHelper=function(size){size=size||1;var vertices=new Float32Array([0,0,0,size,0,0,0,0,0,0,size,0,0,0,0,0,0,size]),colors=new Float32Array([1,0,0,1,.6,0,0,1,0,.6,1,0,0,0,1,0,.6,1]),geometry=new THREE.BufferGeometry;geometry.addAttribute("position",new THREE.BufferAttribute(vertices,3)),geometry.addAttribute("color",new THREE.BufferAttribute(colors,3));var material=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors});THREE.LineSegments.call(this,geometry,material)},THREE.AxisHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.AxisHelper.prototype.constructor=THREE.AxisHelper,THREE.ArrowHelper=function(){var lineGeometry=new THREE.Geometry;lineGeometry.vertices.push(new THREE.Vector3(0,0,0),new THREE.Vector3(0,1,0));var coneGeometry=new THREE.CylinderGeometry(0,.5,1,5,1);return coneGeometry.translate(0,-.5,0),function(dir,origin,length,color,headLength,headWidth){THREE.Object3D.call(this),void 0===color&&(color=16776960),void 0===length&&(length=1),void 0===headLength&&(headLength=.2*length),void 0===headWidth&&(headWidth=.2*headLength),this.position.copy(origin),this.line=new THREE.Line(lineGeometry,new THREE.LineBasicMaterial({color:color})),this.line.matrixAutoUpdate=!1,this.add(this.line),this.cone=new THREE.Mesh(coneGeometry,new THREE.MeshBasicMaterial({color:color})),this.cone.matrixAutoUpdate=!1,this.add(this.cone),this.setDirection(dir),this.setLength(length,headLength,headWidth)}}(),THREE.ArrowHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.ArrowHelper.prototype.constructor=THREE.ArrowHelper,THREE.ArrowHelper.prototype.setDirection=function(){var radians,axis=new THREE.Vector3;return function(dir){dir.y>.99999?this.quaternion.set(0,0,0,1):dir.y<-.99999?this.quaternion.set(1,0,0,0):(axis.set(dir.z,0,-dir.x).normalize(),radians=Math.acos(dir.y),this.quaternion.setFromAxisAngle(axis,radians))}}(),THREE.ArrowHelper.prototype.setLength=function(length,headLength,headWidth){void 0===headLength&&(headLength=.2*length),void 0===headWidth&&(headWidth=.2*headLength),this.line.scale.set(1,Math.max(0,length-headLength),1),this.line.updateMatrix(),this.cone.scale.set(headWidth,headLength,headWidth),this.cone.position.y=length,this.cone.updateMatrix()},THREE.ArrowHelper.prototype.setColor=function(color){this.line.material.color.set(color),this.cone.material.color.set(color)},THREE.BoxHelper=function(object){var indices=new Uint16Array([0,1,1,2,2,3,3,0,4,5,5,6,6,7,7,4,0,4,1,5,2,6,3,7]),positions=new Float32Array(24),geometry=new THREE.BufferGeometry;geometry.setIndex(new THREE.BufferAttribute(indices,1)),geometry.addAttribute("position",new THREE.BufferAttribute(positions,3)),THREE.LineSegments.call(this,geometry,new THREE.LineBasicMaterial({color:16776960})),void 0!==object&&this.update(object)},THREE.BoxHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.BoxHelper.prototype.constructor=THREE.BoxHelper,THREE.BoxHelper.prototype.update=function(){var box=new THREE.Box3;return function(object){if(object instanceof THREE.Box3?box.copy(object):box.setFromObject(object),!box.isEmpty()){var min=box.min,max=box.max,position=this.geometry.attributes.position,array=position.array;array[0]=max.x,array[1]=max.y,array[2]=max.z,array[3]=min.x,array[4]=max.y,array[5]=max.z,array[6]=min.x,array[7]=min.y,array[8]=max.z,array[9]=max.x,array[10]=min.y,array[11]=max.z,array[12]=max.x,array[13]=max.y,array[14]=min.z,array[15]=min.x,array[16]=max.y,array[17]=min.z,array[18]=min.x,array[19]=min.y,array[20]=min.z,array[21]=max.x,array[22]=min.y,array[23]=min.z,position.needsUpdate=!0,this.geometry.computeBoundingSphere()}}}(),THREE.BoundingBoxHelper=function(object,hex){var color=void 0!==hex?hex:8947848;this.object=object,this.box=new THREE.Box3,THREE.Mesh.call(this,new THREE.BoxGeometry(1,1,1),new THREE.MeshBasicMaterial({color:color,wireframe:!0}))},THREE.BoundingBoxHelper.prototype=Object.create(THREE.Mesh.prototype),THREE.BoundingBoxHelper.prototype.constructor=THREE.BoundingBoxHelper,THREE.BoundingBoxHelper.prototype.update=function(){this.box.setFromObject(this.object),this.box.size(this.scale),this.box.center(this.position)},THREE.CameraHelper=function(camera){function addLine(a,b,hex){addPoint(a,hex),addPoint(b,hex)}function addPoint(id,hex){geometry.vertices.push(new THREE.Vector3),geometry.colors.push(new THREE.Color(hex)),void 0===pointMap[id]&&(pointMap[id]=[]),pointMap[id].push(geometry.vertices.length-1)}var geometry=new THREE.Geometry,material=new THREE.LineBasicMaterial({color:16777215,vertexColors:THREE.FaceColors}),pointMap={},hexFrustum=16755200,hexCone=16711680,hexUp=43775,hexTarget=16777215,hexCross=3355443;addLine("n1","n2",hexFrustum),addLine("n2","n4",hexFrustum),addLine("n4","n3",hexFrustum),addLine("n3","n1",hexFrustum),addLine("f1","f2",hexFrustum),addLine("f2","f4",hexFrustum),addLine("f4","f3",hexFrustum),addLine("f3","f1",hexFrustum),addLine("n1","f1",hexFrustum),addLine("n2","f2",hexFrustum),addLine("n3","f3",hexFrustum),addLine("n4","f4",hexFrustum),addLine("p","n1",hexCone),addLine("p","n2",hexCone),addLine("p","n3",hexCone),addLine("p","n4",hexCone),addLine("u1","u2",hexUp),addLine("u2","u3",hexUp),addLine("u3","u1",hexUp),addLine("c","t",hexTarget),addLine("p","c",hexCross),addLine("cn1","cn2",hexCross),addLine("cn3","cn4",hexCross),addLine("cf1","cf2",hexCross),addLine("cf3","cf4",hexCross),THREE.LineSegments.call(this,geometry,material),this.camera=camera,this.camera.updateProjectionMatrix(),this.matrix=camera.matrixWorld,this.matrixAutoUpdate=!1,this.pointMap=pointMap,this.update()},THREE.CameraHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.CameraHelper.prototype.constructor=THREE.CameraHelper,THREE.CameraHelper.prototype.update=function(){function setPoint(point,x,y,z){vector.set(x,y,z).unproject(camera);var points=pointMap[point];if(void 0!==points)for(var i=0,il=points.length;il>i;i++)geometry.vertices[points[i]].copy(vector)}var geometry,pointMap,vector=new THREE.Vector3,camera=new THREE.Camera;return function(){geometry=this.geometry,pointMap=this.pointMap;var w=1,h=1;camera.projectionMatrix.copy(this.camera.projectionMatrix),setPoint("c",0,0,-1),setPoint("t",0,0,1),setPoint("n1",-w,-h,-1),setPoint("n2",w,-h,-1),setPoint("n3",-w,h,-1),setPoint("n4",w,h,-1),setPoint("f1",-w,-h,1),setPoint("f2",w,-h,1),setPoint("f3",-w,h,1),setPoint("f4",w,h,1),setPoint("u1",.7*w,1.1*h,-1),setPoint("u2",.7*-w,1.1*h,-1),setPoint("u3",0,2*h,-1),setPoint("cf1",-w,0,1),setPoint("cf2",w,0,1),setPoint("cf3",0,-h,1),setPoint("cf4",0,h,1),setPoint("cn1",-w,0,-1),setPoint("cn2",w,0,-1),setPoint("cn3",0,-h,-1),setPoint("cn4",0,h,-1),geometry.verticesNeedUpdate=!0}}(),THREE.DirectionalLightHelper=function(light,size){THREE.Object3D.call(this),this.light=light,this.light.updateMatrixWorld(),this.matrix=light.matrixWorld,this.matrixAutoUpdate=!1,size=size||1;var geometry=new THREE.Geometry;geometry.vertices.push(new THREE.Vector3(-size,size,0),new THREE.Vector3(size,size,0),new THREE.Vector3(size,-size,0),new THREE.Vector3(-size,-size,0),new THREE.Vector3(-size,size,0));var material=new THREE.LineBasicMaterial({fog:!1});material.color.copy(this.light.color).multiplyScalar(this.light.intensity),this.lightPlane=new THREE.Line(geometry,material),this.add(this.lightPlane),geometry=new THREE.Geometry,geometry.vertices.push(new THREE.Vector3,new THREE.Vector3),material=new THREE.LineBasicMaterial({fog:!1}),material.color.copy(this.light.color).multiplyScalar(this.light.intensity),this.targetLine=new THREE.Line(geometry,material),this.add(this.targetLine),this.update()},THREE.DirectionalLightHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.DirectionalLightHelper.prototype.constructor=THREE.DirectionalLightHelper,THREE.DirectionalLightHelper.prototype.dispose=function(){this.lightPlane.geometry.dispose(),this.lightPlane.material.dispose(),this.targetLine.geometry.dispose(),this.targetLine.material.dispose()},THREE.DirectionalLightHelper.prototype.update=function(){var v1=new THREE.Vector3,v2=new THREE.Vector3,v3=new THREE.Vector3;return function(){v1.setFromMatrixPosition(this.light.matrixWorld),v2.setFromMatrixPosition(this.light.target.matrixWorld),v3.subVectors(v2,v1),this.lightPlane.lookAt(v3),this.lightPlane.material.color.copy(this.light.color).multiplyScalar(this.light.intensity),this.targetLine.geometry.vertices[1].copy(v3),this.targetLine.geometry.verticesNeedUpdate=!0,this.targetLine.material.color.copy(this.lightPlane.material.color)}}(),THREE.EdgesHelper=function(object,hex,thresholdAngle){var color=void 0!==hex?hex:16777215;THREE.LineSegments.call(this,new THREE.EdgesGeometry(object.geometry,thresholdAngle),new THREE.LineBasicMaterial({color:color})),this.matrix=object.matrixWorld,this.matrixAutoUpdate=!1},THREE.EdgesHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.EdgesHelper.prototype.constructor=THREE.EdgesHelper,THREE.FaceNormalsHelper=function(object,size,hex,linewidth){this.object=object,this.size=void 0!==size?size:1;var color=void 0!==hex?hex:16776960,width=void 0!==linewidth?linewidth:1,nNormals=0,objGeometry=this.object.geometry;objGeometry instanceof THREE.Geometry?nNormals=objGeometry.faces.length:console.warn("THREE.FaceNormalsHelper: only THREE.Geometry is supported. Use THREE.VertexNormalsHelper, instead.");var geometry=new THREE.BufferGeometry,positions=new THREE.Float32Attribute(2*nNormals*3,3);geometry.addAttribute("position",positions),THREE.LineSegments.call(this,geometry,new THREE.LineBasicMaterial({color:color,linewidth:width})),this.matrixAutoUpdate=!1,this.update()},THREE.FaceNormalsHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.FaceNormalsHelper.prototype.constructor=THREE.FaceNormalsHelper,THREE.FaceNormalsHelper.prototype.update=function(){var v1=new THREE.Vector3,v2=new THREE.Vector3,normalMatrix=new THREE.Matrix3;return function(){this.object.updateMatrixWorld(!0),normalMatrix.getNormalMatrix(this.object.matrixWorld);for(var matrixWorld=this.object.matrixWorld,position=this.geometry.attributes.position,objGeometry=this.object.geometry,vertices=objGeometry.vertices,faces=objGeometry.faces,idx=0,i=0,l=faces.length;l>i;i++){var face=faces[i],normal=face.normal;v1.copy(vertices[face.a]).add(vertices[face.b]).add(vertices[face.c]).divideScalar(3).applyMatrix4(matrixWorld),v2.copy(normal).applyMatrix3(normalMatrix).normalize().multiplyScalar(this.size).add(v1),position.setXYZ(idx,v1.x,v1.y,v1.z),idx+=1,position.setXYZ(idx,v2.x,v2.y,v2.z),idx+=1}return position.needsUpdate=!0,this}}(),THREE.GridHelper=function(size,step){var geometry=new THREE.Geometry,material=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors});this.color1=new THREE.Color(4473924),this.color2=new THREE.Color(8947848);for(var i=-size;size>=i;i+=step){geometry.vertices.push(new THREE.Vector3(-size,0,i),new THREE.Vector3(size,0,i),new THREE.Vector3(i,0,-size),new THREE.Vector3(i,0,size));var color=0===i?this.color1:this.color2;geometry.colors.push(color,color,color,color)}THREE.LineSegments.call(this,geometry,material)},THREE.GridHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.GridHelper.prototype.constructor=THREE.GridHelper,THREE.GridHelper.prototype.setColors=function(colorCenterLine,colorGrid){this.color1.set(colorCenterLine),this.color2.set(colorGrid),this.geometry.colorsNeedUpdate=!0},THREE.HemisphereLightHelper=function(light,sphereSize){THREE.Object3D.call(this),this.light=light,this.light.updateMatrixWorld(),this.matrix=light.matrixWorld,this.matrixAutoUpdate=!1,this.colors=[new THREE.Color,new THREE.Color];var geometry=new THREE.SphereGeometry(sphereSize,4,2);geometry.rotateX(-Math.PI/2);for(var i=0,il=8;il>i;i++)geometry.faces[i].color=this.colors[4>i?0:1];var material=new THREE.MeshBasicMaterial({vertexColors:THREE.FaceColors,wireframe:!0});this.lightSphere=new THREE.Mesh(geometry,material),this.add(this.lightSphere),this.update()},THREE.HemisphereLightHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.HemisphereLightHelper.prototype.constructor=THREE.HemisphereLightHelper,THREE.HemisphereLightHelper.prototype.dispose=function(){this.lightSphere.geometry.dispose(),this.lightSphere.material.dispose()},THREE.HemisphereLightHelper.prototype.update=function(){var vector=new THREE.Vector3;return function(){this.colors[0].copy(this.light.color).multiplyScalar(this.light.intensity),this.colors[1].copy(this.light.groundColor).multiplyScalar(this.light.intensity),this.lightSphere.lookAt(vector.setFromMatrixPosition(this.light.matrixWorld).negate()),this.lightSphere.geometry.colorsNeedUpdate=!0}}(),THREE.PointLightHelper=function(light,sphereSize){this.light=light,this.light.updateMatrixWorld();var geometry=new THREE.SphereGeometry(sphereSize,4,2),material=new THREE.MeshBasicMaterial({wireframe:!0,fog:!1});material.color.copy(this.light.color).multiplyScalar(this.light.intensity),THREE.Mesh.call(this,geometry,material),this.matrix=this.light.matrixWorld,this.matrixAutoUpdate=!1},THREE.PointLightHelper.prototype=Object.create(THREE.Mesh.prototype),THREE.PointLightHelper.prototype.constructor=THREE.PointLightHelper,THREE.PointLightHelper.prototype.dispose=function(){this.geometry.dispose(),this.material.dispose()},THREE.PointLightHelper.prototype.update=function(){this.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)},THREE.SkeletonHelper=function(object){this.bones=this.getBoneList(object);for(var geometry=new THREE.Geometry,i=0;i<this.bones.length;i++){var bone=this.bones[i];bone.parent instanceof THREE.Bone&&(geometry.vertices.push(new THREE.Vector3),geometry.vertices.push(new THREE.Vector3),geometry.colors.push(new THREE.Color(0,0,1)),geometry.colors.push(new THREE.Color(0,1,0)))}geometry.dynamic=!0;var material=new THREE.LineBasicMaterial({vertexColors:THREE.VertexColors,depthTest:!1,depthWrite:!1,transparent:!0});THREE.LineSegments.call(this,geometry,material),this.root=object,this.matrix=object.matrixWorld,this.matrixAutoUpdate=!1,this.update()},THREE.SkeletonHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.SkeletonHelper.prototype.constructor=THREE.SkeletonHelper,THREE.SkeletonHelper.prototype.getBoneList=function(object){var boneList=[];object instanceof THREE.Bone&&boneList.push(object);for(var i=0;i<object.children.length;i++)boneList.push.apply(boneList,this.getBoneList(object.children[i]));return boneList},THREE.SkeletonHelper.prototype.update=function(){for(var geometry=this.geometry,matrixWorldInv=(new THREE.Matrix4).getInverse(this.root.matrixWorld),boneMatrix=new THREE.Matrix4,j=0,i=0;i<this.bones.length;i++){var bone=this.bones[i];bone.parent instanceof THREE.Bone&&(boneMatrix.multiplyMatrices(matrixWorldInv,bone.matrixWorld),geometry.vertices[j].setFromMatrixPosition(boneMatrix),boneMatrix.multiplyMatrices(matrixWorldInv,bone.parent.matrixWorld),geometry.vertices[j+1].setFromMatrixPosition(boneMatrix),j+=2)}geometry.verticesNeedUpdate=!0,geometry.computeBoundingSphere()},THREE.SpotLightHelper=function(light){THREE.Object3D.call(this),this.light=light,this.light.updateMatrixWorld(),this.matrix=light.matrixWorld,this.matrixAutoUpdate=!1;for(var geometry=new THREE.BufferGeometry,positions=[0,0,0,0,0,1,0,0,0,1,0,1,0,0,0,-1,0,1,0,0,0,0,1,1,0,0,0,0,-1,1],i=0,j=1,l=32;l>i;i++,j++){var p1=i/l*Math.PI*2,p2=j/l*Math.PI*2;positions.push(Math.cos(p1),Math.sin(p1),1,Math.cos(p2),Math.sin(p2),1)}geometry.addAttribute("position",new THREE.Float32Attribute(positions,3));var material=new THREE.LineBasicMaterial({fog:!1});this.cone=new THREE.LineSegments(geometry,material),this.add(this.cone),this.update()},THREE.SpotLightHelper.prototype=Object.create(THREE.Object3D.prototype),THREE.SpotLightHelper.prototype.constructor=THREE.SpotLightHelper,THREE.SpotLightHelper.prototype.dispose=function(){this.cone.geometry.dispose(),this.cone.material.dispose()},THREE.SpotLightHelper.prototype.update=function(){var vector=new THREE.Vector3,vector2=new THREE.Vector3;return function(){var coneLength=this.light.distance?this.light.distance:1e3,coneWidth=coneLength*Math.tan(this.light.angle);this.cone.scale.set(coneWidth,coneWidth,coneLength),vector.setFromMatrixPosition(this.light.matrixWorld),vector2.setFromMatrixPosition(this.light.target.matrixWorld),this.cone.lookAt(vector2.sub(vector)),this.cone.material.color.copy(this.light.color).multiplyScalar(this.light.intensity)}}(),THREE.VertexNormalsHelper=function(object,size,hex,linewidth){this.object=object,this.size=void 0!==size?size:1;var color=void 0!==hex?hex:16711680,width=void 0!==linewidth?linewidth:1,nNormals=0,objGeometry=this.object.geometry;
objGeometry instanceof THREE.Geometry?nNormals=3*objGeometry.faces.length:objGeometry instanceof THREE.BufferGeometry&&(nNormals=objGeometry.attributes.normal.count);var geometry=new THREE.BufferGeometry,positions=new THREE.Float32Attribute(2*nNormals*3,3);geometry.addAttribute("position",positions),THREE.LineSegments.call(this,geometry,new THREE.LineBasicMaterial({color:color,linewidth:width})),this.matrixAutoUpdate=!1,this.update()},THREE.VertexNormalsHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.VertexNormalsHelper.prototype.constructor=THREE.VertexNormalsHelper,THREE.VertexNormalsHelper.prototype.update=function(){var v1=new THREE.Vector3,v2=new THREE.Vector3,normalMatrix=new THREE.Matrix3;return function(){var keys=["a","b","c"];this.object.updateMatrixWorld(!0),normalMatrix.getNormalMatrix(this.object.matrixWorld);var matrixWorld=this.object.matrixWorld,position=this.geometry.attributes.position,objGeometry=this.object.geometry;if(objGeometry instanceof THREE.Geometry)for(var vertices=objGeometry.vertices,faces=objGeometry.faces,idx=0,i=0,l=faces.length;l>i;i++)for(var face=faces[i],j=0,jl=face.vertexNormals.length;jl>j;j++){var vertex=vertices[face[keys[j]]],normal=face.vertexNormals[j];v1.copy(vertex).applyMatrix4(matrixWorld),v2.copy(normal).applyMatrix3(normalMatrix).normalize().multiplyScalar(this.size).add(v1),position.setXYZ(idx,v1.x,v1.y,v1.z),idx+=1,position.setXYZ(idx,v2.x,v2.y,v2.z),idx+=1}else if(objGeometry instanceof THREE.BufferGeometry)for(var objPos=objGeometry.attributes.position,objNorm=objGeometry.attributes.normal,idx=0,j=0,jl=objPos.count;jl>j;j++)v1.set(objPos.getX(j),objPos.getY(j),objPos.getZ(j)).applyMatrix4(matrixWorld),v2.set(objNorm.getX(j),objNorm.getY(j),objNorm.getZ(j)),v2.applyMatrix3(normalMatrix).normalize().multiplyScalar(this.size).add(v1),position.setXYZ(idx,v1.x,v1.y,v1.z),idx+=1,position.setXYZ(idx,v2.x,v2.y,v2.z),idx+=1;return position.needsUpdate=!0,this}}(),THREE.WireframeHelper=function(object,hex){var color=void 0!==hex?hex:16777215;THREE.LineSegments.call(this,new THREE.WireframeGeometry(object.geometry),new THREE.LineBasicMaterial({color:color})),this.matrix=object.matrixWorld,this.matrixAutoUpdate=!1},THREE.WireframeHelper.prototype=Object.create(THREE.LineSegments.prototype),THREE.WireframeHelper.prototype.constructor=THREE.WireframeHelper,THREE.ImmediateRenderObject=function(material){THREE.Object3D.call(this),this.material=material,this.render=function(renderCallback){}},THREE.ImmediateRenderObject.prototype=Object.create(THREE.Object3D.prototype),THREE.ImmediateRenderObject.prototype.constructor=THREE.ImmediateRenderObject,THREE.MorphBlendMesh=function(geometry,material){THREE.Mesh.call(this,geometry,material),this.animationsMap={},this.animationsList=[];var numFrames=this.geometry.morphTargets.length,name="__default",startFrame=0,endFrame=numFrames-1,fps=numFrames/1;this.createAnimation(name,startFrame,endFrame,fps),this.setAnimationWeight(name,1)},THREE.MorphBlendMesh.prototype=Object.create(THREE.Mesh.prototype),THREE.MorphBlendMesh.prototype.constructor=THREE.MorphBlendMesh,THREE.MorphBlendMesh.prototype.createAnimation=function(name,start,end,fps){var animation={start:start,end:end,length:end-start+1,fps:fps,duration:(end-start)/fps,lastFrame:0,currentFrame:0,active:!1,time:0,direction:1,weight:1,directionBackwards:!1,mirroredLoop:!1};this.animationsMap[name]=animation,this.animationsList.push(animation)},THREE.MorphBlendMesh.prototype.autoCreateAnimations=function(fps){for(var firstAnimation,pattern=/([a-z]+)_?(\d+)/i,frameRanges={},geometry=this.geometry,i=0,il=geometry.morphTargets.length;il>i;i++){var morph=geometry.morphTargets[i],chunks=morph.name.match(pattern);if(chunks&&chunks.length>1){var name=chunks[1];frameRanges[name]||(frameRanges[name]={start:1/0,end:-(1/0)});var range=frameRanges[name];i<range.start&&(range.start=i),i>range.end&&(range.end=i),firstAnimation||(firstAnimation=name)}}for(var name in frameRanges){var range=frameRanges[name];this.createAnimation(name,range.start,range.end,fps)}this.firstAnimation=firstAnimation},THREE.MorphBlendMesh.prototype.setAnimationDirectionForward=function(name){var animation=this.animationsMap[name];animation&&(animation.direction=1,animation.directionBackwards=!1)},THREE.MorphBlendMesh.prototype.setAnimationDirectionBackward=function(name){var animation=this.animationsMap[name];animation&&(animation.direction=-1,animation.directionBackwards=!0)},THREE.MorphBlendMesh.prototype.setAnimationFPS=function(name,fps){var animation=this.animationsMap[name];animation&&(animation.fps=fps,animation.duration=(animation.end-animation.start)/animation.fps)},THREE.MorphBlendMesh.prototype.setAnimationDuration=function(name,duration){var animation=this.animationsMap[name];animation&&(animation.duration=duration,animation.fps=(animation.end-animation.start)/animation.duration)},THREE.MorphBlendMesh.prototype.setAnimationWeight=function(name,weight){var animation=this.animationsMap[name];animation&&(animation.weight=weight)},THREE.MorphBlendMesh.prototype.setAnimationTime=function(name,time){var animation=this.animationsMap[name];animation&&(animation.time=time)},THREE.MorphBlendMesh.prototype.getAnimationTime=function(name){var time=0,animation=this.animationsMap[name];return animation&&(time=animation.time),time},THREE.MorphBlendMesh.prototype.getAnimationDuration=function(name){var duration=-1,animation=this.animationsMap[name];return animation&&(duration=animation.duration),duration},THREE.MorphBlendMesh.prototype.playAnimation=function(name){var animation=this.animationsMap[name];animation?(animation.time=0,animation.active=!0):console.warn("THREE.MorphBlendMesh: animation["+name+"] undefined in .playAnimation()")},THREE.MorphBlendMesh.prototype.stopAnimation=function(name){var animation=this.animationsMap[name];animation&&(animation.active=!1)},THREE.MorphBlendMesh.prototype.update=function(delta){for(var i=0,il=this.animationsList.length;il>i;i++){var animation=this.animationsList[i];if(animation.active){var frameTime=animation.duration/animation.length;animation.time+=animation.direction*delta,animation.mirroredLoop?(animation.time>animation.duration||animation.time<0)&&(animation.direction*=-1,animation.time>animation.duration&&(animation.time=animation.duration,animation.directionBackwards=!0),animation.time<0&&(animation.time=0,animation.directionBackwards=!1)):(animation.time=animation.time%animation.duration,animation.time<0&&(animation.time+=animation.duration));var keyframe=animation.start+THREE.Math.clamp(Math.floor(animation.time/frameTime),0,animation.length-1),weight=animation.weight;keyframe!==animation.currentFrame&&(this.morphTargetInfluences[animation.lastFrame]=0,this.morphTargetInfluences[animation.currentFrame]=1*weight,this.morphTargetInfluences[keyframe]=0,animation.lastFrame=animation.currentFrame,animation.currentFrame=keyframe);var mix=animation.time%frameTime/frameTime;animation.directionBackwards&&(mix=1-mix),animation.currentFrame!==animation.lastFrame?(this.morphTargetInfluences[animation.currentFrame]=mix*weight,this.morphTargetInfluences[animation.lastFrame]=(1-mix)*weight):this.morphTargetInfluences[animation.currentFrame]=weight}}},"undefined"!=typeof exports?("undefined"!=typeof module&&module.exports&&(exports=module.exports=THREE),exports.THREE=THREE):this.THREE=THREE,THREE.SpriteCanvasMaterial=function(parameters){THREE.Material.call(this),this.type="SpriteCanvasMaterial",this.color=new THREE.Color(16777215),this.program=function(context,color){},this.setValues(parameters)},THREE.SpriteCanvasMaterial.prototype=Object.create(THREE.Material.prototype),THREE.SpriteCanvasMaterial.prototype.constructor=THREE.SpriteCanvasMaterial,THREE.SpriteCanvasMaterial.prototype.clone=function(){var material=new THREE.SpriteCanvasMaterial;return material.copy(this),material.color.copy(this.color),material.program=this.program,material},THREE.CanvasRenderer=function(parameters){function calculateLights(){_ambientLight.setRGB(0,0,0),_directionalLights.setRGB(0,0,0),_pointLights.setRGB(0,0,0);for(var l=0,ll=_lights.length;ll>l;l++){var light=_lights[l],lightColor=light.color;light instanceof THREE.AmbientLight?_ambientLight.add(lightColor):light instanceof THREE.DirectionalLight?_directionalLights.add(lightColor):light instanceof THREE.PointLight&&_pointLights.add(lightColor)}}function calculateLight(position,normal,color){for(var l=0,ll=_lights.length;ll>l;l++){var light=_lights[l];if(_lightColor.copy(light.color),light instanceof THREE.DirectionalLight){var lightPosition=_vector3.setFromMatrixPosition(light.matrixWorld).normalize(),amount=normal.dot(lightPosition);if(0>=amount)continue;amount*=light.intensity,color.add(_lightColor.multiplyScalar(amount))}else if(light instanceof THREE.PointLight){var lightPosition=_vector3.setFromMatrixPosition(light.matrixWorld),amount=normal.dot(_vector3.subVectors(lightPosition,position).normalize());if(0>=amount)continue;if(amount*=0==light.distance?1:1-Math.min(position.distanceTo(lightPosition)/light.distance,1),0==amount)continue;amount*=light.intensity,color.add(_lightColor.multiplyScalar(amount))}}}function renderSprite(v1,element,material){setOpacity(material.opacity),setBlending(material.blending);var scaleX=element.scale.x*_canvasWidthHalf,scaleY=element.scale.y*_canvasHeightHalf,dist=.5*Math.sqrt(scaleX*scaleX+scaleY*scaleY);if(_elemBox.min.set(v1.x-dist,v1.y-dist),_elemBox.max.set(v1.x+dist,v1.y+dist),material instanceof THREE.SpriteMaterial){var texture=material.map;if(null!==texture){var pattern=_patterns[texture.id];if(void 0!==pattern&&pattern.version===texture.version||(pattern=textureToPattern(texture),_patterns[texture.id]=pattern),void 0!==pattern.canvas){setFillStyle(pattern.canvas);var bitmap=texture.image,ox=bitmap.width*texture.offset.x,oy=bitmap.height*texture.offset.y,sx=bitmap.width*texture.repeat.x,sy=bitmap.height*texture.repeat.y,cx=scaleX/sx,cy=scaleY/sy;_context.save(),_context.translate(v1.x,v1.y),0!==material.rotation&&_context.rotate(material.rotation),_context.translate(-scaleX/2,-scaleY/2),_context.scale(cx,cy),_context.translate(-ox,-oy),_context.fillRect(ox,oy,sx,sy),_context.restore()}}else setFillStyle(material.color.getStyle()),_context.save(),_context.translate(v1.x,v1.y),0!==material.rotation&&_context.rotate(material.rotation),_context.scale(scaleX,-scaleY),_context.fillRect(-.5,-.5,1,1),_context.restore()}else material instanceof THREE.SpriteCanvasMaterial&&(setStrokeStyle(material.color.getStyle()),setFillStyle(material.color.getStyle()),_context.save(),_context.translate(v1.x,v1.y),0!==material.rotation&&_context.rotate(material.rotation),_context.scale(scaleX,scaleY),material.program(_context),_context.restore())}function renderLine(v1,v2,element,material){if(setOpacity(material.opacity),setBlending(material.blending),_context.beginPath(),_context.moveTo(v1.positionScreen.x,v1.positionScreen.y),_context.lineTo(v2.positionScreen.x,v2.positionScreen.y),material instanceof THREE.LineBasicMaterial){if(setLineWidth(material.linewidth),setLineCap(material.linecap),setLineJoin(material.linejoin),material.vertexColors!==THREE.VertexColors)setStrokeStyle(material.color.getStyle());else{var colorStyle1=element.vertexColors[0].getStyle(),colorStyle2=element.vertexColors[1].getStyle();if(colorStyle1===colorStyle2)setStrokeStyle(colorStyle1);else{try{var grad=_context.createLinearGradient(v1.positionScreen.x,v1.positionScreen.y,v2.positionScreen.x,v2.positionScreen.y);grad.addColorStop(0,colorStyle1),grad.addColorStop(1,colorStyle2)}catch(exception){grad=colorStyle1}setStrokeStyle(grad)}}_context.stroke(),_elemBox.expandByScalar(2*material.linewidth)}else material instanceof THREE.LineDashedMaterial&&(setLineWidth(material.linewidth),setLineCap(material.linecap),setLineJoin(material.linejoin),setStrokeStyle(material.color.getStyle()),setLineDash([material.dashSize,material.gapSize]),_context.stroke(),_elemBox.expandByScalar(2*material.linewidth),setLineDash([]))}function renderFace3(v1,v2,v3,uv1,uv2,uv3,element,material){if(_this.info.render.vertices+=3,_this.info.render.faces++,setOpacity(material.opacity),setBlending(material.blending),_v1x=v1.positionScreen.x,_v1y=v1.positionScreen.y,_v2x=v2.positionScreen.x,_v2y=v2.positionScreen.y,_v3x=v3.positionScreen.x,_v3y=v3.positionScreen.y,drawTriangle(_v1x,_v1y,_v2x,_v2y,_v3x,_v3y),(material instanceof THREE.MeshLambertMaterial||material instanceof THREE.MeshPhongMaterial)&&null===material.map)_diffuseColor.copy(material.color),_emissiveColor.copy(material.emissive),material.vertexColors===THREE.FaceColors&&_diffuseColor.multiply(element.color),_color.copy(_ambientLight),_centroid.copy(v1.positionWorld).add(v2.positionWorld).add(v3.positionWorld).divideScalar(3),calculateLight(_centroid,element.normalModel,_color),_color.multiply(_diffuseColor).add(_emissiveColor),material.wireframe===!0?strokePath(_color,material.wireframeLinewidth,material.wireframeLinecap,material.wireframeLinejoin):fillPath(_color);else if(material instanceof THREE.MeshBasicMaterial||material instanceof THREE.MeshLambertMaterial||material instanceof THREE.MeshPhongMaterial)if(null!==material.map){var mapping=material.map.mapping;mapping===THREE.UVMapping&&(_uvs=element.uvs,patternPath(_v1x,_v1y,_v2x,_v2y,_v3x,_v3y,_uvs[uv1].x,_uvs[uv1].y,_uvs[uv2].x,_uvs[uv2].y,_uvs[uv3].x,_uvs[uv3].y,material.map))}else null!==material.envMap?material.envMap.mapping===THREE.SphericalReflectionMapping&&(_normal.copy(element.vertexNormalsModel[uv1]).applyMatrix3(_normalViewMatrix),_uv1x=.5*_normal.x+.5,_uv1y=.5*_normal.y+.5,_normal.copy(element.vertexNormalsModel[uv2]).applyMatrix3(_normalViewMatrix),_uv2x=.5*_normal.x+.5,_uv2y=.5*_normal.y+.5,_normal.copy(element.vertexNormalsModel[uv3]).applyMatrix3(_normalViewMatrix),_uv3x=.5*_normal.x+.5,_uv3y=.5*_normal.y+.5,patternPath(_v1x,_v1y,_v2x,_v2y,_v3x,_v3y,_uv1x,_uv1y,_uv2x,_uv2y,_uv3x,_uv3y,material.envMap)):(_color.copy(material.color),material.vertexColors===THREE.FaceColors&&_color.multiply(element.color),material.wireframe===!0?strokePath(_color,material.wireframeLinewidth,material.wireframeLinecap,material.wireframeLinejoin):fillPath(_color));else material instanceof THREE.MeshNormalMaterial?(_normal.copy(element.normalModel).applyMatrix3(_normalViewMatrix),_color.setRGB(_normal.x,_normal.y,_normal.z).multiplyScalar(.5).addScalar(.5),material.wireframe===!0?strokePath(_color,material.wireframeLinewidth,material.wireframeLinecap,material.wireframeLinejoin):fillPath(_color)):(_color.setRGB(1,1,1),material.wireframe===!0?strokePath(_color,material.wireframeLinewidth,material.wireframeLinecap,material.wireframeLinejoin):fillPath(_color))}function drawTriangle(x0,y0,x1,y1,x2,y2){_context.beginPath(),_context.moveTo(x0,y0),_context.lineTo(x1,y1),_context.lineTo(x2,y2),_context.closePath()}function strokePath(color,linewidth,linecap,linejoin){setLineWidth(linewidth),setLineCap(linecap),setLineJoin(linejoin),setStrokeStyle(color.getStyle()),_context.stroke(),_elemBox.expandByScalar(2*linewidth)}function fillPath(color){setFillStyle(color.getStyle()),_context.fill()}function textureToPattern(texture){if(0===texture.version||texture instanceof THREE.CompressedTexture||texture instanceof THREE.DataTexture)return{canvas:void 0,version:texture.version};var image=texture.image;if(image.complete===!1)return{canvas:void 0,version:0};var canvas=document.createElement("canvas");canvas.width=image.width,canvas.height=image.height;var context=canvas.getContext("2d");context.setTransform(1,0,0,-1,0,image.height),context.drawImage(image,0,0);var repeatX=texture.wrapS===THREE.RepeatWrapping,repeatY=texture.wrapT===THREE.RepeatWrapping,repeat="no-repeat";repeatX===!0&&repeatY===!0?repeat="repeat":repeatX===!0?repeat="repeat-x":repeatY===!0&&(repeat="repeat-y");var pattern=_context.createPattern(canvas,repeat);return texture.onUpdate&&texture.onUpdate(texture),{canvas:pattern,version:texture.version}}function patternPath(x0,y0,x1,y1,x2,y2,u0,v0,u1,v1,u2,v2,texture){var pattern=_patterns[texture.id];if(void 0!==pattern&&pattern.version===texture.version||(pattern=textureToPattern(texture),_patterns[texture.id]=pattern),void 0===pattern.canvas)return setFillStyle("rgba( 0, 0, 0, 1)"),void _context.fill();setFillStyle(pattern.canvas);var a,b,c,d,e,f,det,idet,offsetX=texture.offset.x/texture.repeat.x,offsetY=texture.offset.y/texture.repeat.y,width=texture.image.width*texture.repeat.x,height=texture.image.height*texture.repeat.y;u0=(u0+offsetX)*width,v0=(v0+offsetY)*height,u1=(u1+offsetX)*width,v1=(v1+offsetY)*height,u2=(u2+offsetX)*width,v2=(v2+offsetY)*height,x1-=x0,y1-=y0,x2-=x0,y2-=y0,u1-=u0,v1-=v0,u2-=u0,v2-=v0,det=u1*v2-u2*v1,0!==det&&(idet=1/det,a=(v2*x1-v1*x2)*idet,b=(v2*y1-v1*y2)*idet,c=(u1*x2-u2*x1)*idet,d=(u1*y2-u2*y1)*idet,e=x0-a*u0-c*v0,f=y0-b*u0-d*v0,_context.save(),_context.transform(a,b,c,d,e,f),_context.fill(),_context.restore())}function expand(v1,v2,pixels){var idet,x=v2.x-v1.x,y=v2.y-v1.y,det=x*x+y*y;0!==det&&(idet=pixels/Math.sqrt(det),x*=idet,y*=idet,v2.x+=x,v2.y+=y,v1.x-=x,v1.y-=y)}function setOpacity(value){_contextGlobalAlpha!==value&&(_context.globalAlpha=value,_contextGlobalAlpha=value)}function setBlending(value){_contextGlobalCompositeOperation!==value&&(value===THREE.NormalBlending?_context.globalCompositeOperation="source-over":value===THREE.AdditiveBlending?_context.globalCompositeOperation="lighter":value===THREE.SubtractiveBlending&&(_context.globalCompositeOperation="darker"),_contextGlobalCompositeOperation=value)}function setLineWidth(value){_contextLineWidth!==value&&(_context.lineWidth=value,_contextLineWidth=value)}function setLineCap(value){_contextLineCap!==value&&(_context.lineCap=value,_contextLineCap=value)}function setLineJoin(value){_contextLineJoin!==value&&(_context.lineJoin=value,_contextLineJoin=value)}function setStrokeStyle(value){_contextStrokeStyle!==value&&(_context.strokeStyle=value,_contextStrokeStyle=value)}function setFillStyle(value){_contextFillStyle!==value&&(_context.fillStyle=value,_contextFillStyle=value)}function setLineDash(value){_contextLineDash.length!==value.length&&(_context.setLineDash(value),_contextLineDash=value)}console.log("THREE.CanvasRenderer",THREE.REVISION),parameters=parameters||{};var _renderData,_elements,_lights,_camera,_v1,_v2,_v3,_v1x,_v1y,_v2x,_v2y,_v3x,_v3y,_uvs,_uv1x,_uv1y,_uv2x,_uv2y,_uv3x,_uv3y,_this=this,_projector=new THREE.Projector,_canvas=void 0!==parameters.canvas?parameters.canvas:document.createElement("canvas"),_canvasWidth=_canvas.width,_canvasHeight=_canvas.height,_canvasWidthHalf=Math.floor(_canvasWidth/2),_canvasHeightHalf=Math.floor(_canvasHeight/2),_viewportX=0,_viewportY=0,_viewportWidth=_canvasWidth,_viewportHeight=_canvasHeight,_pixelRatio=1,_context=_canvas.getContext("2d",{alpha:parameters.alpha===!0}),_clearColor=new THREE.Color(0),_clearAlpha=parameters.alpha===!0?0:1,_contextGlobalAlpha=1,_contextGlobalCompositeOperation=0,_contextStrokeStyle=null,_contextFillStyle=null,_contextLineWidth=null,_contextLineCap=null,_contextLineJoin=null,_contextLineDash=[],_color=(new THREE.RenderableVertex,new THREE.RenderableVertex,new THREE.Color),_diffuseColor=(new THREE.Color,new THREE.Color,new THREE.Color,new THREE.Color,new THREE.Color),_emissiveColor=new THREE.Color,_lightColor=new THREE.Color,_patterns={},_clipBox=new THREE.Box2,_clearBox=new THREE.Box2,_elemBox=new THREE.Box2,_ambientLight=new THREE.Color,_directionalLights=new THREE.Color,_pointLights=new THREE.Color,_vector3=new THREE.Vector3,_centroid=new THREE.Vector3,_normal=new THREE.Vector3,_normalViewMatrix=new THREE.Matrix3;void 0===_context.setLineDash&&(_context.setLineDash=function(){}),this.domElement=_canvas,this.autoClear=!0,this.sortObjects=!0,this.sortElements=!0,this.info={render:{vertices:0,faces:0}},this.supportsVertexTextures=function(){},this.setFaceCulling=function(){},this.getContext=function(){return _context},this.getContextAttributes=function(){return _context.getContextAttributes()},this.getPixelRatio=function(){return _pixelRatio},this.setPixelRatio=function(value){void 0!==value&&(_pixelRatio=value)},this.setSize=function(width,height,updateStyle){_canvasWidth=width*_pixelRatio,_canvasHeight=height*_pixelRatio,_canvas.width=_canvasWidth,_canvas.height=_canvasHeight,_canvasWidthHalf=Math.floor(_canvasWidth/2),_canvasHeightHalf=Math.floor(_canvasHeight/2),updateStyle!==!1&&(_canvas.style.width=width+"px",_canvas.style.height=height+"px"),_clipBox.min.set(-_canvasWidthHalf,-_canvasHeightHalf),_clipBox.max.set(_canvasWidthHalf,_canvasHeightHalf),_clearBox.min.set(-_canvasWidthHalf,-_canvasHeightHalf),_clearBox.max.set(_canvasWidthHalf,_canvasHeightHalf),_contextGlobalAlpha=1,_contextGlobalCompositeOperation=0,_contextStrokeStyle=null,_contextFillStyle=null,_contextLineWidth=null,_contextLineCap=null,_contextLineJoin=null,this.setViewport(0,0,width,height)},this.setViewport=function(x,y,width,height){_viewportX=x*_pixelRatio,_viewportY=y*_pixelRatio,_viewportWidth=width*_pixelRatio,_viewportHeight=height*_pixelRatio},this.setScissor=function(){},this.setScissorTest=function(){},this.setClearColor=function(color,alpha){_clearColor.set(color),_clearAlpha=void 0!==alpha?alpha:1,_clearBox.min.set(-_canvasWidthHalf,-_canvasHeightHalf),_clearBox.max.set(_canvasWidthHalf,_canvasHeightHalf)},this.setClearColorHex=function(hex,alpha){console.warn("THREE.CanvasRenderer: .setClearColorHex() is being removed. Use .setClearColor() instead."),this.setClearColor(hex,alpha)},this.getClearColor=function(){return _clearColor},this.getClearAlpha=function(){return _clearAlpha},this.getMaxAnisotropy=function(){return 0},this.clear=function(){_clearBox.isEmpty()===!1&&(_clearBox.intersect(_clipBox),_clearBox.expandByScalar(2),_clearBox.min.x=_clearBox.min.x+_canvasWidthHalf,_clearBox.min.y=-_clearBox.min.y+_canvasHeightHalf,_clearBox.max.x=_clearBox.max.x+_canvasWidthHalf,_clearBox.max.y=-_clearBox.max.y+_canvasHeightHalf,1>_clearAlpha&&_context.clearRect(0|_clearBox.min.x,0|_clearBox.max.y,_clearBox.max.x-_clearBox.min.x|0,_clearBox.min.y-_clearBox.max.y|0),_clearAlpha>0&&(setBlending(THREE.NormalBlending),setOpacity(1),setFillStyle("rgba("+Math.floor(255*_clearColor.r)+","+Math.floor(255*_clearColor.g)+","+Math.floor(255*_clearColor.b)+","+_clearAlpha+")"),_context.fillRect(0|_clearBox.min.x,0|_clearBox.max.y,_clearBox.max.x-_clearBox.min.x|0,_clearBox.min.y-_clearBox.max.y|0)),_clearBox.makeEmpty())},this.clearColor=function(){},this.clearDepth=function(){},this.clearStencil=function(){},this.render=function(scene,camera){if(camera instanceof THREE.Camera==!1)return void console.error("THREE.CanvasRenderer.render: camera is not an instance of THREE.Camera.");this.autoClear===!0&&this.clear(),_this.info.render.vertices=0,_this.info.render.faces=0,_context.setTransform(_viewportWidth/_canvasWidth,0,0,-_viewportHeight/_canvasHeight,_viewportX,_canvasHeight-_viewportY),_context.translate(_canvasWidthHalf,_canvasHeightHalf),_renderData=_projector.projectScene(scene,camera,this.sortObjects,this.sortElements),_elements=_renderData.elements,_lights=_renderData.lights,_camera=camera,_normalViewMatrix.getNormalMatrix(camera.matrixWorldInverse),calculateLights();for(var e=0,el=_elements.length;el>e;e++){var element=_elements[e],material=element.material;if(void 0!==material&&0!==material.opacity){if(_elemBox.makeEmpty(),element instanceof THREE.RenderableSprite)_v1=element,_v1.x*=_canvasWidthHalf,_v1.y*=_canvasHeightHalf,renderSprite(_v1,element,material);else if(element instanceof THREE.RenderableLine)_v1=element.v1,_v2=element.v2,_v1.positionScreen.x*=_canvasWidthHalf,_v1.positionScreen.y*=_canvasHeightHalf,_v2.positionScreen.x*=_canvasWidthHalf,_v2.positionScreen.y*=_canvasHeightHalf,_elemBox.setFromPoints([_v1.positionScreen,_v2.positionScreen]),_clipBox.intersectsBox(_elemBox)===!0&&renderLine(_v1,_v2,element,material);else if(element instanceof THREE.RenderableFace){if(_v1=element.v1,_v2=element.v2,_v3=element.v3,_v1.positionScreen.z<-1||_v1.positionScreen.z>1)continue;if(_v2.positionScreen.z<-1||_v2.positionScreen.z>1)continue;if(_v3.positionScreen.z<-1||_v3.positionScreen.z>1)continue;_v1.positionScreen.x*=_canvasWidthHalf,_v1.positionScreen.y*=_canvasHeightHalf,_v2.positionScreen.x*=_canvasWidthHalf,_v2.positionScreen.y*=_canvasHeightHalf,_v3.positionScreen.x*=_canvasWidthHalf,_v3.positionScreen.y*=_canvasHeightHalf,material.overdraw>0&&(expand(_v1.positionScreen,_v2.positionScreen,material.overdraw),expand(_v2.positionScreen,_v3.positionScreen,material.overdraw),expand(_v3.positionScreen,_v1.positionScreen,material.overdraw)),_elemBox.setFromPoints([_v1.positionScreen,_v2.positionScreen,_v3.positionScreen]),_clipBox.intersectsBox(_elemBox)===!0&&renderFace3(_v1,_v2,_v3,0,1,2,element,material)}_clearBox.union(_elemBox)}}_context.setTransform(1,0,0,1,0,0)}},THREE.RenderableObject=function(){this.id=0,this.object=null,this.z=0,this.renderOrder=0},THREE.RenderableFace=function(){this.id=0,this.v1=new THREE.RenderableVertex,this.v2=new THREE.RenderableVertex,this.v3=new THREE.RenderableVertex,this.normalModel=new THREE.Vector3,this.vertexNormalsModel=[new THREE.Vector3,new THREE.Vector3,new THREE.Vector3],this.vertexNormalsLength=0,this.color=new THREE.Color,this.material=null,this.uvs=[new THREE.Vector2,new THREE.Vector2,new THREE.Vector2],this.z=0,this.renderOrder=0},THREE.RenderableVertex=function(){this.position=new THREE.Vector3,this.positionWorld=new THREE.Vector3,this.positionScreen=new THREE.Vector4,this.visible=!0},THREE.RenderableVertex.prototype.copy=function(vertex){this.positionWorld.copy(vertex.positionWorld),this.positionScreen.copy(vertex.positionScreen)},THREE.RenderableLine=function(){this.id=0,this.v1=new THREE.RenderableVertex,this.v2=new THREE.RenderableVertex,this.vertexColors=[new THREE.Color,new THREE.Color],this.material=null,this.z=0,this.renderOrder=0},THREE.RenderableSprite=function(){this.id=0,this.object=null,this.x=0,this.y=0,this.z=0,this.rotation=0,this.scale=new THREE.Vector2,this.material=null,this.renderOrder=0},THREE.Projector=function(){function getNextObjectInPool(){if(_objectCount===_objectPoolLength){var object=new THREE.RenderableObject;return _objectPool.push(object),_objectPoolLength++,_objectCount++,object}return _objectPool[_objectCount++]}function getNextVertexInPool(){if(_vertexCount===_vertexPoolLength){var vertex=new THREE.RenderableVertex;return _vertexPool.push(vertex),_vertexPoolLength++,_vertexCount++,vertex}return _vertexPool[_vertexCount++]}function getNextFaceInPool(){if(_faceCount===_facePoolLength){var face=new THREE.RenderableFace;return _facePool.push(face),_facePoolLength++,_faceCount++,face}return _facePool[_faceCount++]}function getNextLineInPool(){if(_lineCount===_linePoolLength){var line=new THREE.RenderableLine;return _linePool.push(line),_linePoolLength++,_lineCount++,line}return _linePool[_lineCount++]}function getNextSpriteInPool(){if(_spriteCount===_spritePoolLength){var sprite=new THREE.RenderableSprite;return _spritePool.push(sprite),_spritePoolLength++,_spriteCount++,sprite}return _spritePool[_spriteCount++]}function painterSort(a,b){return a.renderOrder!==b.renderOrder?a.renderOrder-b.renderOrder:a.z!==b.z?b.z-a.z:a.id!==b.id?a.id-b.id:0}function clipLine(s1,s2){var alpha1=0,alpha2=1,bc1near=s1.z+s1.w,bc2near=s2.z+s2.w,bc1far=-s1.z+s1.w,bc2far=-s2.z+s2.w;return bc1near>=0&&bc2near>=0&&bc1far>=0&&bc2far>=0?!0:0>bc1near&&0>bc2near||0>bc1far&&0>bc2far?!1:(0>bc1near?alpha1=Math.max(alpha1,bc1near/(bc1near-bc2near)):0>bc2near&&(alpha2=Math.min(alpha2,bc1near/(bc1near-bc2near))),0>bc1far?alpha1=Math.max(alpha1,bc1far/(bc1far-bc2far)):0>bc2far&&(alpha2=Math.min(alpha2,bc1far/(bc1far-bc2far))),alpha1>alpha2?!1:(s1.lerp(s2,alpha1),s2.lerp(s1,1-alpha2),!0))}var _object,_objectCount,_vertex,_vertexCount,_face,_faceCount,_line,_lineCount,_sprite,_spriteCount,_modelMatrix,_objectPool=[],_objectPoolLength=0,_vertexPool=[],_vertexPoolLength=0,_facePool=[],_facePoolLength=0,_linePool=[],_linePoolLength=0,_spritePool=[],_spritePoolLength=0,_renderData={objects:[],lights:[],elements:[]},_vector3=new THREE.Vector3,_vector4=new THREE.Vector4,_clipBox=new THREE.Box3(new THREE.Vector3(-1,-1,-1),new THREE.Vector3(1,1,1)),_boundingBox=new THREE.Box3,_points3=new Array(3),_viewMatrix=(new Array(4),new THREE.Matrix4),_viewProjectionMatrix=new THREE.Matrix4,_modelViewProjectionMatrix=new THREE.Matrix4,_normalMatrix=new THREE.Matrix3,_frustum=new THREE.Frustum,_clippedVertex1PositionScreen=new THREE.Vector4,_clippedVertex2PositionScreen=new THREE.Vector4;this.projectVector=function(vector,camera){console.warn("THREE.Projector: .projectVector() is now vector.project()."),vector.project(camera)},this.unprojectVector=function(vector,camera){console.warn("THREE.Projector: .unprojectVector() is now vector.unproject()."),vector.unproject(camera)},this.pickingRay=function(vector,camera){console.error("THREE.Projector: .pickingRay() is now raycaster.setFromCamera().")};var RenderList=function(){function setObject(value){object=value,material=object.material,normalMatrix.getNormalMatrix(object.matrixWorld),normals.length=0,uvs.length=0}function projectVertex(vertex){var position=vertex.position,positionWorld=vertex.positionWorld,positionScreen=vertex.positionScreen;positionWorld.copy(position).applyMatrix4(_modelMatrix),positionScreen.copy(positionWorld).applyMatrix4(_viewProjectionMatrix);var invW=1/positionScreen.w;positionScreen.x*=invW,positionScreen.y*=invW,positionScreen.z*=invW,vertex.visible=positionScreen.x>=-1&&positionScreen.x<=1&&positionScreen.y>=-1&&positionScreen.y<=1&&positionScreen.z>=-1&&positionScreen.z<=1}function pushVertex(x,y,z){_vertex=getNextVertexInPool(),_vertex.position.set(x,y,z),projectVertex(_vertex)}function pushNormal(x,y,z){normals.push(x,y,z)}function pushUv(x,y){uvs.push(x,y)}function checkTriangleVisibility(v1,v2,v3){return v1.visible===!0||v2.visible===!0||v3.visible===!0?!0:(_points3[0]=v1.positionScreen,_points3[1]=v2.positionScreen,_points3[2]=v3.positionScreen,_clipBox.intersectsBox(_boundingBox.setFromPoints(_points3)))}function checkBackfaceCulling(v1,v2,v3){return(v3.positionScreen.x-v1.positionScreen.x)*(v2.positionScreen.y-v1.positionScreen.y)-(v3.positionScreen.y-v1.positionScreen.y)*(v2.positionScreen.x-v1.positionScreen.x)<0}function pushLine(a,b){var v1=_vertexPool[a],v2=_vertexPool[b];_line=getNextLineInPool(),_line.id=object.id,_line.v1.copy(v1),_line.v2.copy(v2),_line.z=(v1.positionScreen.z+v2.positionScreen.z)/2,_line.renderOrder=object.renderOrder,_line.material=object.material,_renderData.elements.push(_line)}function pushTriangle(a,b,c){var v1=_vertexPool[a],v2=_vertexPool[b],v3=_vertexPool[c];if(checkTriangleVisibility(v1,v2,v3)!==!1&&(material.side===THREE.DoubleSide||checkBackfaceCulling(v1,v2,v3)===!0)){_face=getNextFaceInPool(),_face.id=object.id,_face.v1.copy(v1),_face.v2.copy(v2),_face.v3.copy(v3),_face.z=(v1.positionScreen.z+v2.positionScreen.z+v3.positionScreen.z)/3,_face.renderOrder=object.renderOrder,_face.normalModel.fromArray(normals,3*a),_face.normalModel.applyMatrix3(normalMatrix).normalize();for(var i=0;3>i;i++){var normal=_face.vertexNormalsModel[i];normal.fromArray(normals,3*arguments[i]),normal.applyMatrix3(normalMatrix).normalize();var uv=_face.uvs[i];uv.fromArray(uvs,2*arguments[i])}_face.vertexNormalsLength=3,_face.material=object.material,_renderData.elements.push(_face)}}var normals=[],uvs=[],object=null,material=null,normalMatrix=new THREE.Matrix3;return{setObject:setObject,projectVertex:projectVertex,checkTriangleVisibility:checkTriangleVisibility,checkBackfaceCulling:checkBackfaceCulling,pushVertex:pushVertex,pushNormal:pushNormal,pushUv:pushUv,pushLine:pushLine,pushTriangle:pushTriangle}},renderList=new RenderList;this.projectScene=function(scene,camera,sortObjects,sortElements){_faceCount=0,_lineCount=0,_spriteCount=0,_renderData.elements.length=0,scene.autoUpdate===!0&&scene.updateMatrixWorld(),null===camera.parent&&camera.updateMatrixWorld(),_viewMatrix.copy(camera.matrixWorldInverse.getInverse(camera.matrixWorld)),
_viewProjectionMatrix.multiplyMatrices(camera.projectionMatrix,_viewMatrix),_frustum.setFromMatrix(_viewProjectionMatrix),_objectCount=0,_renderData.objects.length=0,_renderData.lights.length=0,scene.traverseVisible(function(object){if(object instanceof THREE.Light)_renderData.lights.push(object);else if(object instanceof THREE.Mesh||object instanceof THREE.Line||object instanceof THREE.Sprite){var material=object.material;if(material.visible===!1)return;object.frustumCulled!==!1&&_frustum.intersectsObject(object)!==!0||(_object=getNextObjectInPool(),_object.id=object.id,_object.object=object,_vector3.setFromMatrixPosition(object.matrixWorld),_vector3.applyProjection(_viewProjectionMatrix),_object.z=_vector3.z,_object.renderOrder=object.renderOrder,_renderData.objects.push(_object))}}),sortObjects===!0&&_renderData.objects.sort(painterSort);for(var o=0,ol=_renderData.objects.length;ol>o;o++){var object=_renderData.objects[o].object,geometry=object.geometry;if(renderList.setObject(object),_modelMatrix=object.matrixWorld,_vertexCount=0,object instanceof THREE.Mesh){if(geometry instanceof THREE.BufferGeometry){var attributes=geometry.attributes,groups=geometry.groups;if(void 0===attributes.position)continue;for(var positions=attributes.position.array,i=0,l=positions.length;l>i;i+=3)renderList.pushVertex(positions[i],positions[i+1],positions[i+2]);if(void 0!==attributes.normal)for(var normals=attributes.normal.array,i=0,l=normals.length;l>i;i+=3)renderList.pushNormal(normals[i],normals[i+1],normals[i+2]);if(void 0!==attributes.uv)for(var uvs=attributes.uv.array,i=0,l=uvs.length;l>i;i+=2)renderList.pushUv(uvs[i],uvs[i+1]);if(null!==geometry.index){var indices=geometry.index.array;if(groups.length>0)for(var o=0;o<groups.length;o++)for(var group=groups[o],i=group.start,l=group.start+group.count;l>i;i+=3)renderList.pushTriangle(indices[i],indices[i+1],indices[i+2]);else for(var i=0,l=indices.length;l>i;i+=3)renderList.pushTriangle(indices[i],indices[i+1],indices[i+2])}else for(var i=0,l=positions.length/3;l>i;i+=3)renderList.pushTriangle(i,i+1,i+2)}else if(geometry instanceof THREE.Geometry){var vertices=geometry.vertices,faces=geometry.faces,faceVertexUvs=geometry.faceVertexUvs[0];_normalMatrix.getNormalMatrix(_modelMatrix);for(var material=object.material,isFaceMaterial=material instanceof THREE.MultiMaterial,objectMaterials=isFaceMaterial===!0?object.material:null,v=0,vl=vertices.length;vl>v;v++){var vertex=vertices[v];if(_vector3.copy(vertex),material.morphTargets===!0)for(var morphTargets=geometry.morphTargets,morphInfluences=object.morphTargetInfluences,t=0,tl=morphTargets.length;tl>t;t++){var influence=morphInfluences[t];if(0!==influence){var target=morphTargets[t],targetVertex=target.vertices[v];_vector3.x+=(targetVertex.x-vertex.x)*influence,_vector3.y+=(targetVertex.y-vertex.y)*influence,_vector3.z+=(targetVertex.z-vertex.z)*influence}}renderList.pushVertex(_vector3.x,_vector3.y,_vector3.z)}for(var f=0,fl=faces.length;fl>f;f++){var face=faces[f];if(material=isFaceMaterial===!0?objectMaterials.materials[face.materialIndex]:object.material,void 0!==material){var side=material.side,v1=_vertexPool[face.a],v2=_vertexPool[face.b],v3=_vertexPool[face.c];if(renderList.checkTriangleVisibility(v1,v2,v3)!==!1){var visible=renderList.checkBackfaceCulling(v1,v2,v3);if(side!==THREE.DoubleSide){if(side===THREE.FrontSide&&visible===!1)continue;if(side===THREE.BackSide&&visible===!0)continue}_face=getNextFaceInPool(),_face.id=object.id,_face.v1.copy(v1),_face.v2.copy(v2),_face.v3.copy(v3),_face.normalModel.copy(face.normal),visible!==!1||side!==THREE.BackSide&&side!==THREE.DoubleSide||_face.normalModel.negate(),_face.normalModel.applyMatrix3(_normalMatrix).normalize();for(var faceVertexNormals=face.vertexNormals,n=0,nl=Math.min(faceVertexNormals.length,3);nl>n;n++){var normalModel=_face.vertexNormalsModel[n];normalModel.copy(faceVertexNormals[n]),visible!==!1||side!==THREE.BackSide&&side!==THREE.DoubleSide||normalModel.negate(),normalModel.applyMatrix3(_normalMatrix).normalize()}_face.vertexNormalsLength=faceVertexNormals.length;var vertexUvs=faceVertexUvs[f];if(void 0!==vertexUvs)for(var u=0;3>u;u++)_face.uvs[u].copy(vertexUvs[u]);_face.color=face.color,_face.material=material,_face.z=(v1.positionScreen.z+v2.positionScreen.z+v3.positionScreen.z)/3,_face.renderOrder=object.renderOrder,_renderData.elements.push(_face)}}}}}else if(object instanceof THREE.Line){if(geometry instanceof THREE.BufferGeometry){var attributes=geometry.attributes;if(void 0!==attributes.position){for(var positions=attributes.position.array,i=0,l=positions.length;l>i;i+=3)renderList.pushVertex(positions[i],positions[i+1],positions[i+2]);if(null!==geometry.index)for(var indices=geometry.index.array,i=0,l=indices.length;l>i;i+=2)renderList.pushLine(indices[i],indices[i+1]);else for(var step=object instanceof THREE.LineSegments?2:1,i=0,l=positions.length/3-1;l>i;i+=step)renderList.pushLine(i,i+1)}}else if(geometry instanceof THREE.Geometry){_modelViewProjectionMatrix.multiplyMatrices(_viewProjectionMatrix,_modelMatrix);var vertices=object.geometry.vertices;if(0===vertices.length)continue;v1=getNextVertexInPool(),v1.positionScreen.copy(vertices[0]).applyMatrix4(_modelViewProjectionMatrix);for(var step=object instanceof THREE.LineSegments?2:1,v=1,vl=vertices.length;vl>v;v++)v1=getNextVertexInPool(),v1.positionScreen.copy(vertices[v]).applyMatrix4(_modelViewProjectionMatrix),(v+1)%step>0||(v2=_vertexPool[_vertexCount-2],_clippedVertex1PositionScreen.copy(v1.positionScreen),_clippedVertex2PositionScreen.copy(v2.positionScreen),clipLine(_clippedVertex1PositionScreen,_clippedVertex2PositionScreen)===!0&&(_clippedVertex1PositionScreen.multiplyScalar(1/_clippedVertex1PositionScreen.w),_clippedVertex2PositionScreen.multiplyScalar(1/_clippedVertex2PositionScreen.w),_line=getNextLineInPool(),_line.id=object.id,_line.v1.positionScreen.copy(_clippedVertex1PositionScreen),_line.v2.positionScreen.copy(_clippedVertex2PositionScreen),_line.z=Math.max(_clippedVertex1PositionScreen.z,_clippedVertex2PositionScreen.z),_line.renderOrder=object.renderOrder,_line.material=object.material,object.material.vertexColors===THREE.VertexColors&&(_line.vertexColors[0].copy(object.geometry.colors[v]),_line.vertexColors[1].copy(object.geometry.colors[v-1])),_renderData.elements.push(_line)))}}else if(object instanceof THREE.Sprite){_vector4.set(_modelMatrix.elements[12],_modelMatrix.elements[13],_modelMatrix.elements[14],1),_vector4.applyMatrix4(_viewProjectionMatrix);var invW=1/_vector4.w;_vector4.z*=invW,_vector4.z>=-1&&_vector4.z<=1&&(_sprite=getNextSpriteInPool(),_sprite.id=object.id,_sprite.x=_vector4.x*invW,_sprite.y=_vector4.y*invW,_sprite.z=_vector4.z,_sprite.renderOrder=object.renderOrder,_sprite.object=object,_sprite.rotation=object.rotation,_sprite.scale.x=object.scale.x*Math.abs(_sprite.x-(_vector4.x+camera.projectionMatrix.elements[0])/(_vector4.w+camera.projectionMatrix.elements[12])),_sprite.scale.y=object.scale.y*Math.abs(_sprite.y-(_vector4.y+camera.projectionMatrix.elements[5])/(_vector4.w+camera.projectionMatrix.elements[13])),_sprite.material=object.material,_renderData.elements.push(_sprite))}}return sortElements===!0&&_renderData.elements.sort(painterSort),_renderData}},THREE.Animation=function(root,data){this.root=root,this.data=THREE.AnimationHandler.init(data),this.hierarchy=THREE.AnimationHandler.parse(root),this.currentTime=0,this.timeScale=1,this.isPlaying=!1,this.loop=!0,this.weight=0,this.interpolationType=THREE.AnimationHandler.LINEAR},THREE.Animation.prototype={constructor:THREE.Animation,keyTypes:["pos","rot","scl"],play:function(startTime,weight){this.currentTime=void 0!==startTime?startTime:0,this.weight=void 0!==weight?weight:1,this.isPlaying=!0,this.reset(),THREE.AnimationHandler.play(this)},stop:function(){this.isPlaying=!1,THREE.AnimationHandler.stop(this)},reset:function(){for(var h=0,hl=this.hierarchy.length;hl>h;h++){var object=this.hierarchy[h];void 0===object.animationCache&&(object.animationCache={animations:{},blending:{positionWeight:0,quaternionWeight:0,scaleWeight:0}});var name=this.data.name,animations=object.animationCache.animations,animationCache=animations[name];void 0===animationCache&&(animationCache={prevKey:{pos:0,rot:0,scl:0},nextKey:{pos:0,rot:0,scl:0},originalMatrix:object.matrix},animations[name]=animationCache);for(var t=0;3>t;t++){for(var type=this.keyTypes[t],prevKey=this.data.hierarchy[h].keys[0],nextKey=this.getNextKeyWith(type,h,1);nextKey.time<this.currentTime&&nextKey.index>prevKey.index;)prevKey=nextKey,nextKey=this.getNextKeyWith(type,h,nextKey.index+1);animationCache.prevKey[type]=prevKey,animationCache.nextKey[type]=nextKey}}},resetBlendWeights:function(){for(var h=0,hl=this.hierarchy.length;hl>h;h++){var object=this.hierarchy[h],animationCache=object.animationCache;if(void 0!==animationCache){var blending=animationCache.blending;blending.positionWeight=0,blending.quaternionWeight=0,blending.scaleWeight=0}}},update:function(){var points=[],target=new THREE.Vector3,newVector=new THREE.Vector3,newQuat=new THREE.Quaternion,interpolateCatmullRom=function(points,scale){var point,intPoint,weight,w2,w3,pa,pb,pc,pd,c=[],v3=[];return point=(points.length-1)*scale,intPoint=Math.floor(point),weight=point-intPoint,c[0]=0===intPoint?intPoint:intPoint-1,c[1]=intPoint,c[2]=intPoint>points.length-2?intPoint:intPoint+1,c[3]=intPoint>points.length-3?intPoint:intPoint+2,pa=points[c[0]],pb=points[c[1]],pc=points[c[2]],pd=points[c[3]],w2=weight*weight,w3=weight*w2,v3[0]=interpolate(pa[0],pb[0],pc[0],pd[0],weight,w2,w3),v3[1]=interpolate(pa[1],pb[1],pc[1],pd[1],weight,w2,w3),v3[2]=interpolate(pa[2],pb[2],pc[2],pd[2],weight,w2,w3),v3},interpolate=function(p0,p1,p2,p3,t,t2,t3){var v0=.5*(p2-p0),v1=.5*(p3-p1);return(2*(p1-p2)+v0+v1)*t3+(-3*(p1-p2)-2*v0-v1)*t2+v0*t+p1};return function(delta){if(this.isPlaying!==!1&&(this.currentTime+=delta*this.timeScale,0!==this.weight)){var duration=this.data.length;(this.currentTime>duration||this.currentTime<0)&&(this.loop?(this.currentTime%=duration,this.currentTime<0&&(this.currentTime+=duration),this.reset()):this.stop());for(var h=0,hl=this.hierarchy.length;hl>h;h++)for(var object=this.hierarchy[h],animationCache=object.animationCache.animations[this.data.name],blending=object.animationCache.blending,t=0;3>t;t++){var type=this.keyTypes[t],prevKey=animationCache.prevKey[type],nextKey=animationCache.nextKey[type];if(this.timeScale>0&&nextKey.time<=this.currentTime||this.timeScale<0&&prevKey.time>=this.currentTime){for(prevKey=this.data.hierarchy[h].keys[0],nextKey=this.getNextKeyWith(type,h,1);nextKey.time<this.currentTime&&nextKey.index>prevKey.index;)prevKey=nextKey,nextKey=this.getNextKeyWith(type,h,nextKey.index+1);animationCache.prevKey[type]=prevKey,animationCache.nextKey[type]=nextKey}var scale=(this.currentTime-prevKey.time)/(nextKey.time-prevKey.time),prevXYZ=prevKey[type],nextXYZ=nextKey[type];if(0>scale&&(scale=0),scale>1&&(scale=1),"pos"===type){if(this.interpolationType===THREE.AnimationHandler.LINEAR){newVector.x=prevXYZ[0]+(nextXYZ[0]-prevXYZ[0])*scale,newVector.y=prevXYZ[1]+(nextXYZ[1]-prevXYZ[1])*scale,newVector.z=prevXYZ[2]+(nextXYZ[2]-prevXYZ[2])*scale;var proportionalWeight=this.weight/(this.weight+blending.positionWeight);object.position.lerp(newVector,proportionalWeight),blending.positionWeight+=this.weight}else if(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){points[0]=this.getPrevKeyWith("pos",h,prevKey.index-1).pos,points[1]=prevXYZ,points[2]=nextXYZ,points[3]=this.getNextKeyWith("pos",h,nextKey.index+1).pos,scale=.33*scale+.33;var currentPoint=interpolateCatmullRom(points,scale),proportionalWeight=this.weight/(this.weight+blending.positionWeight);blending.positionWeight+=this.weight;var vector=object.position;if(vector.x=vector.x+(currentPoint[0]-vector.x)*proportionalWeight,vector.y=vector.y+(currentPoint[1]-vector.y)*proportionalWeight,vector.z=vector.z+(currentPoint[2]-vector.z)*proportionalWeight,this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD){var forwardPoint=interpolateCatmullRom(points,1.01*scale);target.set(forwardPoint[0],forwardPoint[1],forwardPoint[2]),target.sub(vector),target.y=0,target.normalize();var angle=Math.atan2(target.x,target.z);object.rotation.set(0,angle,0)}}}else if("rot"===type)if(THREE.Quaternion.slerp(prevXYZ,nextXYZ,newQuat,scale),0===blending.quaternionWeight)object.quaternion.copy(newQuat),blending.quaternionWeight=this.weight;else{var proportionalWeight=this.weight/(this.weight+blending.quaternionWeight);THREE.Quaternion.slerp(object.quaternion,newQuat,object.quaternion,proportionalWeight),blending.quaternionWeight+=this.weight}else if("scl"===type){newVector.x=prevXYZ[0]+(nextXYZ[0]-prevXYZ[0])*scale,newVector.y=prevXYZ[1]+(nextXYZ[1]-prevXYZ[1])*scale,newVector.z=prevXYZ[2]+(nextXYZ[2]-prevXYZ[2])*scale;var proportionalWeight=this.weight/(this.weight+blending.scaleWeight);object.scale.lerp(newVector,proportionalWeight),blending.scaleWeight+=this.weight}}return!0}}}(),getNextKeyWith:function(type,h,key){var keys=this.data.hierarchy[h].keys;for(this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?key=key<keys.length-1?key:keys.length-1:key%=keys.length;key<keys.length;key++)if(void 0!==keys[key][type])return keys[key];return this.data.hierarchy[h].keys[0]},getPrevKeyWith:function(type,h,key){var keys=this.data.hierarchy[h].keys;for(key=this.interpolationType===THREE.AnimationHandler.CATMULLROM||this.interpolationType===THREE.AnimationHandler.CATMULLROM_FORWARD?key>0?key:0:key>=0?key:key+keys.length;key>=0;key--)if(void 0!==keys[key][type])return keys[key];return this.data.hierarchy[h].keys[keys.length-1]}},THREE.AnimationHandler={LINEAR:0,CATMULLROM:1,CATMULLROM_FORWARD:2,add:function(){console.warn("THREE.AnimationHandler.add() has been deprecated.")},get:function(){console.warn("THREE.AnimationHandler.get() has been deprecated.")},remove:function(){console.warn("THREE.AnimationHandler.remove() has been deprecated.")},animations:[],init:function(data){if(data.initialized===!0)return data;for(var h=0;h<data.hierarchy.length;h++){for(var k=0;k<data.hierarchy[h].keys.length;k++)if(data.hierarchy[h].keys[k].time<0&&(data.hierarchy[h].keys[k].time=0),void 0!==data.hierarchy[h].keys[k].rot&&!(data.hierarchy[h].keys[k].rot instanceof THREE.Quaternion)){var quat=data.hierarchy[h].keys[k].rot;data.hierarchy[h].keys[k].rot=(new THREE.Quaternion).fromArray(quat)}if(data.hierarchy[h].keys.length&&void 0!==data.hierarchy[h].keys[0].morphTargets){for(var usedMorphTargets={},k=0;k<data.hierarchy[h].keys.length;k++)for(var m=0;m<data.hierarchy[h].keys[k].morphTargets.length;m++){var morphTargetName=data.hierarchy[h].keys[k].morphTargets[m];usedMorphTargets[morphTargetName]=-1}data.hierarchy[h].usedMorphTargets=usedMorphTargets;for(var k=0;k<data.hierarchy[h].keys.length;k++){var influences={};for(var morphTargetName in usedMorphTargets){for(var m=0;m<data.hierarchy[h].keys[k].morphTargets.length;m++)if(data.hierarchy[h].keys[k].morphTargets[m]===morphTargetName){influences[morphTargetName]=data.hierarchy[h].keys[k].morphTargetsInfluences[m];break}m===data.hierarchy[h].keys[k].morphTargets.length&&(influences[morphTargetName]=0)}data.hierarchy[h].keys[k].morphTargetsInfluences=influences}}for(var k=1;k<data.hierarchy[h].keys.length;k++)data.hierarchy[h].keys[k].time===data.hierarchy[h].keys[k-1].time&&(data.hierarchy[h].keys.splice(k,1),k--);for(var k=0;k<data.hierarchy[h].keys.length;k++)data.hierarchy[h].keys[k].index=k}return data.initialized=!0,data},parse:function(root){var parseRecurseHierarchy=function(root,hierarchy){hierarchy.push(root);for(var c=0;c<root.children.length;c++)parseRecurseHierarchy(root.children[c],hierarchy)},hierarchy=[];if(root instanceof THREE.SkinnedMesh)for(var b=0;b<root.skeleton.bones.length;b++)hierarchy.push(root.skeleton.bones[b]);else parseRecurseHierarchy(root,hierarchy);return hierarchy},play:function(animation){-1===this.animations.indexOf(animation)&&this.animations.push(animation)},stop:function(animation){var index=this.animations.indexOf(animation);-1!==index&&this.animations.splice(index,1)},update:function(deltaTimeMS){for(var i=0;i<this.animations.length;i++)this.animations[i].resetBlendWeights();for(var i=0;i<this.animations.length;i++)this.animations[i].update(deltaTimeMS)}},THREE.KeyFrameAnimation=function(data){this.root=data.node,this.data=THREE.AnimationHandler.init(data),this.hierarchy=THREE.AnimationHandler.parse(this.root),this.currentTime=0,this.timeScale=.001,this.isPlaying=!1,this.isPaused=!0,this.loop=!0;for(var h=0,hl=this.hierarchy.length;hl>h;h++){var keys=this.data.hierarchy[h].keys,sids=this.data.hierarchy[h].sids,obj=this.hierarchy[h];if(keys.length&&sids){for(var s=0;s<sids.length;s++){var sid=sids[s],next=this.getNextKeyWith(sid,h,0);next&&next.apply(sid)}obj.matrixAutoUpdate=!1,this.data.hierarchy[h].node.updateMatrix(),obj.matrixWorldNeedsUpdate=!0}}},THREE.KeyFrameAnimation.prototype={constructor:THREE.KeyFrameAnimation,play:function(startTime){if(this.currentTime=void 0!==startTime?startTime:0,this.isPlaying===!1){this.isPlaying=!0;var h,object,node,hl=this.hierarchy.length;for(h=0;hl>h;h++){object=this.hierarchy[h],node=this.data.hierarchy[h],void 0===node.animationCache&&(node.animationCache={},node.animationCache.prevKey=null,node.animationCache.nextKey=null,node.animationCache.originalMatrix=object.matrix);var keys=this.data.hierarchy[h].keys;keys.length>1&&(node.animationCache.prevKey=keys[0],node.animationCache.nextKey=keys[1],this.startTime=Math.min(keys[0].time,this.startTime),this.endTime=Math.max(keys[keys.length-1].time,this.endTime))}this.update(0)}this.isPaused=!1},stop:function(){this.isPlaying=!1,this.isPaused=!1;for(var h=0;h<this.data.hierarchy.length;h++){var obj=this.hierarchy[h],node=this.data.hierarchy[h];if(void 0!==node.animationCache){var original=node.animationCache.originalMatrix;original.copy(obj.matrix),obj.matrix=original,delete node.animationCache}}},update:function(delta){if(this.isPlaying!==!1){this.currentTime+=delta*this.timeScale;var duration=this.data.length;this.loop===!0&&this.currentTime>duration&&(this.currentTime%=duration),this.currentTime=Math.min(this.currentTime,duration);for(var h=0,hl=this.hierarchy.length;hl>h;h++){var object=this.hierarchy[h],node=this.data.hierarchy[h],keys=node.keys,animationCache=node.animationCache;if(keys.length){var prevKey=animationCache.prevKey,nextKey=animationCache.nextKey;if(nextKey.time<=this.currentTime){for(;nextKey.time<this.currentTime&&nextKey.index>prevKey.index;)prevKey=nextKey,nextKey=keys[prevKey.index+1];animationCache.prevKey=prevKey,animationCache.nextKey=nextKey}nextKey.time>=this.currentTime?prevKey.interpolate(nextKey,this.currentTime):prevKey.interpolate(nextKey,nextKey.time),this.data.hierarchy[h].node.updateMatrix(),object.matrixWorldNeedsUpdate=!0}}}},getNextKeyWith:function(sid,h,key){var keys=this.data.hierarchy[h].keys;for(key%=keys.length;key<keys.length;key++)if(keys[key].hasTarget(sid))return keys[key];return keys[0]},getPrevKeyWith:function(sid,h,key){var keys=this.data.hierarchy[h].keys;for(key=key>=0?key:key+keys.length;key>=0;key--)if(keys[key].hasTarget(sid))return keys[key];return keys[keys.length-1]}},THREE.MorphAnimMesh=function(geometry,material){THREE.Mesh.call(this,geometry,material),this.type="MorphAnimMesh",this.mixer=new THREE.AnimationMixer(this),this.activeAction=null},THREE.MorphAnimMesh.prototype=Object.create(THREE.Mesh.prototype),THREE.MorphAnimMesh.prototype.constructor=THREE.MorphAnimMesh,THREE.MorphAnimMesh.prototype.setDirectionForward=function(){this.mixer.timeScale=1},THREE.MorphAnimMesh.prototype.setDirectionBackward=function(){this.mixer.timeScale=-1},THREE.MorphAnimMesh.prototype.playAnimation=function(label,fps){this.activeAction&&(this.activeAction.stop(),this.activeAction=null);var clip=THREE.AnimationClip.findByName(this.geometry.animations,label);if(!clip)throw new Error("THREE.MorphAnimMesh: animations["+label+"] undefined in .playAnimation()");var action=this.mixer.clipAction(clip);action.timeScale=clip.tracks.length*fps/clip.duration,this.activeAction=action.play()},THREE.MorphAnimMesh.prototype.updateAnimation=function(delta){this.mixer.update(delta)},THREE.MorphAnimMesh.prototype.copy=function(source){return THREE.Mesh.prototype.copy.call(this,source),this.mixer=new THREE.AnimationMixer(this),this};var SEA3D={VERSION:17e3};SEA3D.getVersion=function(){var v=SEA3D.VERSION.toString(),l=v.length;return v.substring(0,l-4)+"."+v.substring(l-4,l-3)+"."+v.substring(l-3,l-2)+"."+parseFloat(v.substring(l-2,l)).toString()},console.log("SEA3D "+SEA3D.getVersion()),SEA3D.Stream=function(buffer){this.position=0,this.buffer=buffer||new ArrayBuffer},SEA3D.Stream.NONE=0,SEA3D.Stream.BOOLEAN=1,SEA3D.Stream.BYTE=2,SEA3D.Stream.UBYTE=3,SEA3D.Stream.SHORT=4,SEA3D.Stream.USHORT=5,SEA3D.Stream.INT24=6,SEA3D.Stream.UINT24=7,SEA3D.Stream.INT=8,SEA3D.Stream.UINT=9,SEA3D.Stream.FLOAT=10,SEA3D.Stream.DOUBLE=11,SEA3D.Stream.DECIMAL=12,SEA3D.Stream.VECTOR3D=74,SEA3D.Stream.VECTOR4D=106,SEA3D.Stream.STRING_TINY=128,SEA3D.Stream.STRING_SHORT=129,SEA3D.Stream.STRING_LONG=130,SEA3D.Stream.ASSET=200,SEA3D.Stream.GROUP=255,SEA3D.Stream.BLEND_MODE=["normal","add","subtract","multiply","dividing","alpha","screen","darken","overlay","colorburn","linearburn","lighten","colordodge","lineardodge","softlight","hardlight","pinlight","spotlight","spotlightblend","hardmix","average","difference","exclusion","hue","saturation","color","value"],SEA3D.Stream.INTERPOLATION_TABLE=["normal","linear","sine.in","sine.out","sine.inout","cubic.in","cubic.out","cubic.inout","quint.in","quint.out","quint.inout","circ.in","circ.out","circ.inout","back.in","back.out","back.inout","quad.in","quad.out","quad.inout","quart.in","quart.out","quart.inout","expo.in","expo.out","expo.inout","elastic.in","elastic.out","elastic.inout","bounce.in","bounce.out","bounce.inout"],SEA3D.Stream.sizeOf=function(kind){return 0==kind?0:kind>=1&&31>=kind?1:kind>=32&&63>=kind?2:kind>=64&&95>=kind?3:kind>=96&&125>=kind?4:-1},SEA3D.Stream.prototype={constructor:SEA3D.Stream,set buffer(val){this.buf=val,this.length=val.byteLength,this.data=new DataView(val)},get buffer(){return this.buf},get bytesAvailable(){return this.length-this.position}},SEA3D.Stream.prototype.getByte=function(pos){return this.data.getInt8(pos)},SEA3D.Stream.prototype.readBytes=function(len){var buf=this.buf.slice(this.position,this.position+len);return this.position+=len,buf},SEA3D.Stream.prototype.readByte=function(){return this.data.getInt8(this.position++)},SEA3D.Stream.prototype.readUByte=function(){return this.data.getUint8(this.position++)},SEA3D.Stream.prototype.readBool=function(){return 0!=this.data.getInt8(this.position++)},SEA3D.Stream.prototype.readShort=function(){var v=this.data.getInt16(this.position,!0);return this.position+=2,v},SEA3D.Stream.prototype.readUShort=function(){var v=this.data.getUint16(this.position,!0);return this.position+=2,v},SEA3D.Stream.prototype.readUInt24=function(){var v=16777215&this.data.getUint32(this.position,!0);return this.position+=3,v},SEA3D.Stream.prototype.readUInt24F=function(){return this.readUShort()|this.readUByte()<<16},SEA3D.Stream.prototype.readInt=function(){var v=this.data.getInt32(this.position,!0);return this.position+=4,v},SEA3D.Stream.prototype.readUInt=function(){var v=this.data.getUint32(this.position,!0);return this.position+=4,v},SEA3D.Stream.prototype.readFloat=function(){var v=this.data.getFloat32(this.position,!0);return this.position+=4,v},SEA3D.Stream.prototype.readUInteger=function(){var v=this.readUByte(),r=127&v;return 0!=(128&v)&&(v=this.readUByte(),r|=(127&v)<<7,0!=(128&v)&&(v=this.readUByte(),r|=(127&v)<<13)),r},SEA3D.Stream.prototype.readVector2=function(){return{x:this.readFloat(),y:this.readFloat()}},SEA3D.Stream.prototype.readVector3=function(){return{x:this.readFloat(),y:this.readFloat(),z:this.readFloat()}},SEA3D.Stream.prototype.readVector4=function(){return{x:this.readFloat(),y:this.readFloat(),z:this.readFloat(),w:this.readFloat()}},SEA3D.Stream.prototype.readMatrix=function(){var mtx=new Float32Array(16);return mtx[0]=this.readFloat(),mtx[1]=this.readFloat(),mtx[2]=this.readFloat(),mtx[3]=0,mtx[4]=this.readFloat(),mtx[5]=this.readFloat(),mtx[6]=this.readFloat(),mtx[7]=0,mtx[8]=this.readFloat(),mtx[9]=this.readFloat(),mtx[10]=this.readFloat(),mtx[11]=0,mtx[12]=this.readFloat(),mtx[13]=this.readFloat(),mtx[14]=this.readFloat(),mtx[15]=1,mtx},SEA3D.Stream.prototype.readUTF=function(len){return String.fromCharCode.apply(void 0,new Uint16Array(new Uint8Array(this.readBytes(len))))},SEA3D.Stream.prototype.readExt=function(){return this.readUTF(4).replace(/\0/g,"")},SEA3D.Stream.prototype.readUTF8=function(){return this.readUTF(this.readUByte())},SEA3D.Stream.prototype.readUTF8Short=function(){return this.readUTF(this.readUShort())},SEA3D.Stream.prototype.readUTF8Long=function(){return this.readUTF(this.readUInt())},SEA3D.Stream.prototype.readUByteArray=function(length){var v=new Uint8Array(length);return SEA3D.Stream.memcpy(v.buffer,0,this.buffer,this.position,length),this.position+=length,v},SEA3D.Stream.prototype.readUShortArray=function(length){var v=new Uint16Array(length),len=2*length;return SEA3D.Stream.memcpy(v.buffer,0,this.buffer,this.position,len),this.position+=len,v},SEA3D.Stream.prototype.readUIntArray=function(length){var v=new Uint32Array(length),len=2*length;return SEA3D.Stream.memcpy(v.buffer,0,this.buffer,this.position,len),this.position+=len,v},SEA3D.Stream.prototype.readFloatArray=function(length){var v=new Float32Array(length),len=4*length;return SEA3D.Stream.memcpy(v.buffer,0,this.buffer,this.position,len),this.position+=len,v},SEA3D.Stream.prototype.readBlendMode=function(){return SEA3D.Stream.BLEND_MODE[this.readUByte()]},SEA3D.Stream.prototype.readInterpolation=function(){return SEA3D.Stream.INTERPOLATION_TABLE[this.readUByte()]},SEA3D.Stream.prototype.readTags=function(callback){for(var numTag=this.readUByte(),i=0;numTag>i;++i){var kind=this.readUShort(),size=this.readUInt(),pos=this.position;callback(kind,data,size),this.position=pos+=size}},SEA3D.Stream.prototype.readProperties=function(sea3d){var count=this.readUByte(),props={},types={};props.__type=types;for(var i=0;count>i;i++){var name=this.readUTF8(),type=this.readUByte();props[name]=this.readToken(type,sea3d),types[name]=type}return props},SEA3D.Stream.prototype.readAnimationList=function(sea3d){for(var list=[],count=this.readUByte(),i=0;count>i;){var attrib=this.readUByte(),anm={};anm.relative=0!=(1&attrib),2&attrib&&(anm.timeScale=this.readFloat()),anm.tag=sea3d.getObject(this.readUInt()),list[i++]=anm}return list},SEA3D.Stream.prototype.readScriptList=function(sea3d){for(var list=[],count=this.readUByte(),i=0;count>i;){var attrib=this.readUByte(),script={};if(script.priority=1&attrib|2&attrib,4&attrib){var numParams=this.readUByte();script.params={};for(var j=0;numParams>j;j++){var name=this.readUTF8();script.params[name]=this.readObject(sea3d)}}8&attrib&&(script.method=this.readUTF8()),script.tag=sea3d.getObject(this.readUInt()),list[i++]=script}return list},SEA3D.Stream.prototype.readObject=function(sea3d){return this.readToken(this.readUByte(),sea3d)},SEA3D.Stream.prototype.readToken=function(type,sea3d){switch(type){case SEA3D.Stream.BOOLEAN:return this.readBool();case SEA3D.Stream.UBYTE:return this.readUByte();case SEA3D.Stream.USHORT:return this.readUShort();case SEA3D.Stream.UINT24:return this.readUInt24();case SEA3D.Stream.INT:return this.readInt();case SEA3D.Stream.UINT:return this.readUInt();case SEA3D.Stream.FLOAT:return this.readFloat();case SEA3D.Stream.VECTOR3D:return this.readVector3();case SEA3D.Stream.VECTOR4D:return this.readVector4();case SEA3D.Stream.STRING_TINY:return this.readUTF8();case SEA3D.Stream.STRING_SHORT:return this.readUTF8Short();case SEA3D.Stream.STRING_LONG:return this.readUTF8Long();case SEA3D.Stream.ASSET:var asset=this.readUInt();return asset>0?sea3d.getObject(asset-1).tag:null;default:console.error("DataType not found!")}return null},SEA3D.Stream.prototype.readVector=function(type,length,offset){var size=SEA3D.Stream.sizeOf(type),i=offset*size,count=i+length*size;switch(type){case SEA3D.Stream.BOOLEAN:return this.readUByteArray(count);case SEA3D.Stream.UBYTE:return this.readUByteArray(count);case SEA3D.Stream.USHORT:return this.readUShortArray(count);case SEA3D.Stream.UINT24:return this.readUInt24Array(count);case SEA3D.Stream.UINT:return this.readUIntArray(count);case SEA3D.Stream.FLOAT:return this.readFloatArray(count);case SEA3D.Stream.VECTOR3D:return this.readFloatArray(count);case SEA3D.Stream.VECTOR4D:return this.readFloatArray(count)}},SEA3D.Stream.prototype.append=function(data){var tmp=new ArrayBuffer(this.data.byteLength+data.byteLength);tmp.set(new ArrayBuffer(this.data),0),tmp.set(new ArrayBuffer(data),this.data.byteLength),this.data=tmp},SEA3D.Stream.prototype.concat=function(position,length){return new SEA3D.Stream(this.buffer.slice(position,position+length))},SEA3D.Stream.memcpy=function(dst,dstOffset,src,srcOffset,byteLength){var dstU8=new Uint8Array(dst,dstOffset,byteLength),srcU8=new Uint8Array(src,srcOffset,byteLength);dstU8.set(srcU8)},SEA3D.UByteArray=function(){this.ubytes=[],this.length=0},SEA3D.UByteArray.prototype={constructor:SEA3D.UByteArray,add:function(ubytes){this.ubytes.push(ubytes),this.length+=ubytes.byteLength},toBuffer:function(){for(var memcpy=new Uint8Array(this.length),i=0,offset=0;i<this.ubytes.length;i++)memcpy.set(this.ubytes[i],offset),offset+=this.ubytes[i].byteLength;return memcpy.buffer}},SEA3D.Math={DEGREES:180/Math.PI,RADIANS:Math.PI/180},SEA3D.Math.angle=function(val){var ang=180,inv=0>val;return val=(inv?-val:val)%360,val>ang&&(val=-ang+(val-ang)),inv?-val:val},SEA3D.Math.lerpAngle=function(val,tar,t){return Math.abs(val-tar)>180&&(val>tar?tar+=360:tar-=360),val+=(tar-val)*t,SEA3D.Math.angle(val)},SEA3D.Math.lerpColor=function(val,tar,t){var a0=val>>24&255,r0=val>>16&255,g0=val>>8&255,b0=255&val,a1=tar>>24&255,r1=tar>>16&255,g1=tar>>8&255,b1=255&tar;return a0+=(a1-a0)*t,r0+=(r1-r0)*t,g0+=(g1-g0)*t,b0+=(b1-b0)*t,a0<<24|r0<<16|g0<<8|b0},SEA3D.Math.lerp=function(val,tar,t){return val+(tar-val)*t},SEA3D.Math.lerp1x=function(val,tar,t){val[0]+=(tar[0]-val[0])*t},SEA3D.Math.lerp3x=function(val,tar,t){val[0]+=(tar[0]-val[0])*t,val[1]+=(tar[1]-val[1])*t,val[2]+=(tar[2]-val[2])*t},SEA3D.Math.lerpAng1x=function(val,tar,t){val[0]=SEA3D.Math.lerpAngle(val[0],tar[0],t)},SEA3D.Math.lerpColor1x=function(val,tar,t){val[0]=SEA3D.Math.lerpColor(val[0],tar[0],t)},SEA3D.Math.lerpQuat4x=function(val,tar,t){var x,y,z,w,l,x1=val[0],y1=val[1],z1=val[2],w1=val[3],x2=tar[0],y2=tar[1],z2=tar[2],w2=tar[3];0>x1*x2+y1*y2+z1*z2+w1*w2&&(x2=-x2,y2=-y2,z2=-z2,w2=-w2),x=x1+t*(x2-x1),y=y1+t*(y2-y1),z=z1+t*(z2-z1),w=w1+t*(w2-w1),l=1/Math.sqrt(w*w+x*x+y*y+z*z),val[0]=x*l,val[1]=y*l,val[2]=z*l,val[3]=w*l},SEA3D.Timer=function(){this.time=this.start=Date.now()},SEA3D.Timer.prototype={constructor:SEA3D.Timer,get now(){return Date.now()},get deltaTime(){return Date.now()-this.time},get elapsedTime(){return Date.now()-this.start},update:function(){this.time=Date.now()}},SEA3D.AnimationBlendMethod={LINEAR:"linear",EASING:"easing"},SEA3D.Domain=function(id){this.id=id,this.scripts=[],this.global={},this.events=new SEA3D.EventDispatcher},SEA3D.Domain.prototype={constructor:SEA3D.Domain,add:function(src){this.scripts.push(src)},remove:function(src){this.scripts.splice(this.scripts.indexOf(src),1)},contains:function(src){return-1!=this.scripts.indexOf(src)},addEvent:function(type,listener){this.events.addEventListener(type,listener)},hasEvent:function(type,listener){return this.events.hasEventListener(type,listener)},removeEvent:function(type,listener){this.events.removeEventListener(type,listener)},print:function(){console.log.apply(console,arguments)},watch:function(){
console.log.apply(console,"watch:",arguments)},getReference:function(ns){return eval(ns)},dispatchEvent:function(event){event.domain=this;for(var scripts=this.scripts.concat(),i=scripts.length;i--;)scripts[i].dispatchEvent(event);this.events.dispatchEvent(event)},dispose:function(){for(var scripts=this.scripts.concat(),i=scripts.length;i--;)scripts[i].dispose();this.dispatchEvent({type:"dispose"})}},SEA3D.DomainManager=function(autoDisposeRootDomain){this.domains=[],this.autoDisposeRootDomain=void 0==autoDisposeRootDomain},SEA3D.DomainManager.prototype={constructor:SEA3D.DomainManager,onDisposeDomain:function(e){this.remove(e.domain),this.autoDisposeRootDomain&&1==this.domains.length&&this.dispose()},add:function(domain){this._onDisposeDomain=this._onDisposeDomain||this.onDisposeDomain.bind(this),domain.addEvent("dispose",this._onDisposeDomain),this.domains.push(domain)},remove:function(domain){domain.removeEvent("dispose",this._onDisposeDomain),this.domains.splice(this.domains.indexOf(domain),1)},contains:function(domain){return-1!=this.domains.indexOf(domain)},dispose:function(){for(var domains=this.domains.concat(),i=domains.length;i--;)domains[i].dispose()}},SEA3D.Script=function(domain,root){domain=domain||new SEA3D.Domain,domain.add(this);var events=new SEA3D.EventDispatcher;this.getId=function(){return domain.id},this.isRoot=function(){return root},this.addEvent=function(type,listener){events.addEventListener(type,listener)},this.hasEvent=function(type,listener){return events.hasEventListener(type,listener)},this.removeEvent=function(type,listener){events.removeEventListener(type,listener)},this.dispatchEvent=function(event){event.script=this,events.dispatchEvent(event)},this.dispose=function(){domain.remove(this),root&&domain.dispose(),this.dispatchEvent({type:"dispose"})}},SEA3D.ScriptManager=function(){this.scripts=[];var onDisposeScript=function(e){this.remove(e.script)}.bind(this);this.add=function(src){src.addEvent("dispose",onDisposeScript),this.scripts.push(src)},this.remove=function(src){src.removeEvent("dispose",onDisposeScript),this.scripts.splice(this.scripts.indexOf(src),1)},this.contains=function(src){return this.scripts.indexOf(src)>-1},this.dispatchEvent=function(event){for(var scripts=this.scripts.concat(),i=scripts.length;i--;)scripts[i].dispatchEvent(event)}},SEA3D.AnimationFrame=function(){this.data=[0,0,0,0]},SEA3D.AnimationFrame.prototype.toVector=function(){return{x:this.data[0],y:this.data[1],z:this.data[2],w:this.data[3]}},SEA3D.AnimationFrame.prototype.toAngles=function(d){var x=this.data[0],y=this.data[1],z=this.data[2],w=this.data[3],a=2*(w*y-z*x);return-1>a?a=-1:a>1&&(a=1),{x:Math.atan2(2*(w*x+y*z),1-2*(x*x+y*y))*d,y:Math.asin(a)*d,z:Math.atan2(2*(w*z+x*y),1-2*(y*y+z*z))*d}},SEA3D.AnimationFrame.prototype.toEuler=function(){return this.toAngles(SEA3D.Math.DEGREES)},SEA3D.AnimationFrame.prototype.toRadians=function(){return this.toAngles(1)},SEA3D.AnimationFrame.prototype.setX=function(val){this.data[0]=val},SEA3D.AnimationFrame.prototype.getX=function(){return this.data[0]},SEA3D.AnimationFrame.prototype.setY=function(val){this.data[1]=val},SEA3D.AnimationFrame.prototype.getY=function(){return this.data[1]},SEA3D.AnimationFrame.prototype.setZ=function(val){this.data[2]=val},SEA3D.AnimationFrame.prototype.getZ=function(){return this.data[2]},SEA3D.AnimationFrame.prototype.setW=function(val){this.data[3]=val},SEA3D.AnimationFrame.prototype.getW=function(){return this.data[3]},SEA3D.AnimationData=function(kind,dataType,data,offset){switch(this.kind=kind,this.type=dataType,this.blockLength=SEA3D.Stream.sizeOf(dataType),this.data=data,this.offset=void 0==offset?0:offset,this.blockLength){case 1:this.getData=this.getData1x;break;case 2:this.getData=this.getData2x;break;case 3:this.getData=this.getData3x;break;case 4:this.getData=this.getData4x}},SEA3D.AnimationData.prototype.getData1x=function(frame,data){frame=this.offset+frame*this.blockLength,data[0]=this.data[frame]},SEA3D.AnimationData.prototype.getData2x=function(frame,data){frame=this.offset+frame*this.blockLength,data[0]=this.data[frame],data[1]=this.data[frame+1]},SEA3D.AnimationData.prototype.getData3x=function(frame,data){frame=this.offset+frame*this.blockLength,data[0]=this.data[frame],data[1]=this.data[frame+1],data[2]=this.data[frame+2]},SEA3D.AnimationData.prototype.getData4x=function(frame,data){frame=this.offset+frame*this.blockLength,data[0]=this.data[frame],data[1]=this.data[frame+1],data[2]=this.data[frame+2],data[3]=this.data[frame+3]},SEA3D.AnimationNode=function(name,frameRate,numFrames,repeat,intrpl){this.name=name,this.frameRate=frameRate,this.frameMill=1e3/frameRate,this.numFrames=numFrames,this.length=numFrames-1,this.time=0,this.duration=this.length*this.frameMill,this.repeat=repeat,this.intrpl=intrpl,this.invalidState=!0,this.dataList=[],this.dataListId={},this.buffer=new SEA3D.AnimationFrame,this.percent=0,this.prevFrame=0,this.nextFrame=0,this.frame=0},SEA3D.AnimationNode.prototype.setTime=function(value){this.frame=this.validFrame(value/this.frameMill),this.time=this.frame*this.frameRate,this.invalidState=!0},SEA3D.AnimationNode.prototype.getTime=function(){return this.time},SEA3D.AnimationNode.prototype.setFrame=function(value){this.setTime(value*this.frameMill)},SEA3D.AnimationNode.prototype.getRealFrame=function(){return Math.floor(this.frame)},SEA3D.AnimationNode.prototype.getFrame=function(){return this.frame},SEA3D.AnimationNode.prototype.setPosition=function(value){this.setFrame(value*(this.numFrames-1))},SEA3D.AnimationNode.prototype.getPosition=function(){return this.frame/(this.numFrames-1)},SEA3D.AnimationNode.prototype.validFrame=function(value){var inverse=0>value;return inverse&&(value=-value),value>this.length&&(value=this.repeat?value%this.length:this.length),inverse&&(value=this.length-value),value},SEA3D.AnimationNode.prototype.addData=function(animationData){this.dataListId[animationData.kind]=animationData,this.dataList[this.dataList.length]=animationData},SEA3D.AnimationNode.prototype.removeData=function(animationData){delete this.dataListId[animationData.kind],this.dataList.splice(this.dataList.indexOf(animationData),1)},SEA3D.AnimationNode.prototype.getDataByKind=function(kind){return this.dataListId[kind]},SEA3D.AnimationNode.prototype.getFrameAt=function(frame,id){return this.dataListId[id].getFrameData(frame,this.buffer.data),this.buffer},SEA3D.AnimationNode.prototype.getFrame=function(id){return this.dataListId[id].getFrameData(this.getRealFrame(),this.buffer.data),this.buffer},SEA3D.AnimationNode.prototype.getInterpolationFrame=function(animationData,iFunc){return 0==this.numFrames?this.buffer:(this.invalidState&&(this.prevFrame=this.getRealFrame(),this.nextFrame=this.validFrame(this.prevFrame+1),this.percent=this.frame-this.prevFrame,this.invalidState=!1),animationData.getData(this.prevFrame,this.buffer.data),this.percent>0&&(animationData.getData(this.nextFrame,SEA3D.AnimationNode.FRAME_BUFFER),iFunc(this.buffer.data,SEA3D.AnimationNode.FRAME_BUFFER,this.percent)),this.buffer)},SEA3D.AnimationNode.FRAME_BUFFER=[0,0,0,0],SEA3D.AnimationSet=function(){this.animations=[],this.dataCount=-1},SEA3D.AnimationSet.prototype.addAnimation=function(node){-1==this.dataCount&&(this.dataCount=node.dataList.length),this.animations[node.name]=node,this.animations.push(node)},SEA3D.AnimationSet.prototype.getAnimationByName=function(name){return this.animations[name]},SEA3D.AnimationState=function(node){this.node=node,this.offset=0,this.weight=0,this.time=0},SEA3D.AnimationState.prototype.setTime=function(val){this.node.time=this.time=val},SEA3D.AnimationState.prototype.getTime=function(){return this.time},SEA3D.AnimationState.prototype.setFrame=function(val){this.node.setFrame(val),this.time=this.node.time},SEA3D.AnimationState.prototype.getFrame=function(){return this.update(),this.node.getFrame()},SEA3D.AnimationState.prototype.setPosition=function(val){this.node.setPosition(val),this.time=this.node.time},SEA3D.AnimationState.prototype.getPosition=function(){return this.update(),this.node.getPosition()},SEA3D.AnimationState.prototype.update=function(){this.node.time!=this.time&&this.node.setTime(this.time)},SEA3D.AnimationHandler=function(animationSet){this.animationSet=animationSet,this.states=SEA3D.AnimationHandler.stateFromAnimations(animationSet.animations),this.timeScale=1,this.time=0,this.numAnimation=animationSet.animations.length,this.relative=!1,this.playing=!1,this.delta=0,this.easeSpeed=2,this.crossfade=0,this.updateAllStates=!1,this.blendMethod=SEA3D.AnimationBlendMethod.LINEAR},SEA3D.AnimationHandler.prototype.update=function(delta){this.delta=delta,this.time+=delta*this.timeScale,this.updateState(),this.updateAnimation()},SEA3D.AnimationHandler.prototype.updateState=function(){var i,l,state;if(this.currentState.node.setTime(this.time-this.currentState.offset),this.currentState.weight<1&&this.crossfade>0){var delta=Math.abs(this.delta)/(1e3*this.crossfade),weight=1;for(this.blendMethod===SEA3D.AnimationBlendMethod.EASING&&(delta*=this.easeSpeed),i=0,l=this.states.length;l>i;++i)state=this.states[i],state.weight>0&&state!==this.currentState&&(this.blendMethod===SEA3D.AnimationBlendMethod.LINEAR?state.weight-=delta:this.blendMethod===SEA3D.AnimationBlendMethod.EASING&&(state.weight-=state.weight*delta),state.weight<0&&(state.weight=0),weight-=state.weight,this.updateAllStates&&state.node.setTime(this.time-state.offset));0>weight&&(weight=0),this.currentState.weight=weight}else for(i=0;i<this.states.length;++i)state=this.states[i],state===this.currentState?state.weight=1:(state.weight=0,this.updateAllStates&&state.node.setTime(this.time))},SEA3D.AnimationHandler.prototype.updateAnimation=function(){for(var dataCount=this.animationSet.dataCount,nodes=this.animationSet.animations,currentNode=this.currentState.node,i=0;dataCount>i;i++)for(var n=0;n<nodes.length;n++){var frame,node=nodes[n],state=this.states[n],data=node.dataList[i],iFunc=SEA3D.Animation.DefaultLerpFuncs[data.kind];0==n&&(frame=currentNode.getInterpolationFrame(currentNode.dataList[i],iFunc),currentNode.repeat||currentNode.frame!=currentNode.numFrames-1||this.onComplete&&this.onComplete(this)),node!=currentNode&&state.weight>0&&iFunc(frame.data,node.getInterpolationFrame(data,iFunc).data,state.weight),this.updateAnimationFrame&&this.updateAnimationFrame(frame,data.kind)}},SEA3D.AnimationHandler.prototype.getStateByName=function(name){return this.states[name]},SEA3D.AnimationHandler.prototype.getStateNameByIndex=function(index){return this.animationSet.animations[index].name},SEA3D.AnimationHandler.prototype.play=function(name,crossfade,offset){if(this.currentState=this.getStateByName(name),!this.currentState)throw new Error('Animation "'+name+'" not found.');this.crossfade=crossfade,this.currentState.offset=this.time,void 0!==offset&&(this.currentState.time=offset),this.playing||(SEA3D.AnimationHandler.add(this),this.playing=!0)},SEA3D.AnimationHandler.prototype.resume=function(){this.playing||(SEA3D.AnimationHandler.add(this),this.playing=!0)},SEA3D.AnimationHandler.prototype.pause=function(){this.playing&&(SEA3D.AnimationHandler.remove(this),this.playing=!1)},SEA3D.AnimationHandler.prototype.stop=function(){this.time=0,this.pause()},SEA3D.AnimationHandler.prototype.setRelative=function(val){this.relative=val},SEA3D.AnimationHandler.prototype.getRelative=function(){return this.relative},SEA3D.AnimationHandler.add=function(animation){SEA3D.AnimationHandler.animations.push(animation)},SEA3D.AnimationHandler.remove=function(animation){SEA3D.AnimationHandler.animations.splice(SEA3D.AnimationHandler.animations.indexOf(animation),1)},SEA3D.AnimationHandler.stateFromAnimations=function(anms){for(var states=[],i=0;i<anms.length;i++)states[anms[i].name]=states[i]=new SEA3D.AnimationState(anms[i]);return states},SEA3D.AnimationHandler.update=function(delta){for(var i=0,len=SEA3D.AnimationHandler.animations.length;len>i;i++)SEA3D.AnimationHandler.animations[i].update(1e3*delta)},SEA3D.AnimationHandler.setTime=function(time){for(var i=0,len=SEA3D.AnimationHandler.animations.length;len>i;i++)SEA3D.AnimationHandler.animations[i].time=time},SEA3D.AnimationHandler.stop=function(){for(;SEA3D.AnimationHandler.animations.length;)SEA3D.AnimationHandler.animations[0].stop()},SEA3D.AnimationHandler.animations=[],SEA3D.Object=function(name,data,type,sea3d){this.name=name,this.data=data,this.type=type,this.sea3d=sea3d},SEA3D.GeometryBase=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.attrib=data.readUShort(),this.isBig=0!=(1&this.attrib),data.readVInt=this.isBig?data.readUInt:data.readUShort,this.numVertex=data.readVInt(),this.length=3*this.numVertex},SEA3D.Geometry=function(name,data,sea3d){SEA3D.GeometryBase.call(this,name,data,sea3d);var i,j,len;if(4&this.attrib&&(this.normal=data.readFloatArray(this.length)),8&this.attrib&&(this.tangent=data.readFloatArray(this.length)),32&this.attrib)for(this.uv=[],this.uv.length=data.readUByte(),len=2*this.numVertex,i=0;i<this.uv.length;)this.uv[i++]=data.readFloatArray(len);if(64&this.attrib){this.jointPerVertex=data.readUByte();var jntLen=this.numVertex*this.jointPerVertex;this.joint=data.readUShortArray(jntLen),this.weight=data.readFloatArray(jntLen)}if(128&this.attrib){var colorAttrib=data.readUByte();for(this.numColor=((64&colorAttrib)>>6|(128&colorAttrib)>>6)+1,this.color=[],i=0,len=15&colorAttrib;len>i;i++)this.color.push(data.readFloatArray(this.numVertex*this.numColor))}this.vertex=data.readFloatArray(this.length);var count=data.readUByte();if(this.groups=[],1024&this.attrib){for(i=0,len=0;count>i;i++)j=3*data.readVInt(),this.groups.push({start:len,count:j}),len+=j;this.indexes=this.isBig?data.readUIntArray(len):data.readUShortArray(len)}else{var stride=this.isBig?4:2,bytearray=new SEA3D.UByteArray;for(i=0,j=0;count>i;i++)len=3*data.readVInt(),this.groups.push({start:j,count:len}),j+=len,bytearray.add(data.readUByteArray(len*stride));this.indexes=this.isBig?new Uint32Array(bytearray.toBuffer()):new Uint16Array(bytearray.toBuffer())}},SEA3D.Geometry.prototype=Object.create(SEA3D.GeometryBase.prototype),SEA3D.Geometry.prototype.constructor=SEA3D.Geometry,SEA3D.Geometry.prototype.type="geo",SEA3D.GeometryDeltaBase=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.attrib=data.readUShort(),this.numVertex=data.readUInteger(),this.length=3*this.numVertex,1&this.attrib?(data.readNumber=data.readByte,this.numDiv=127.5):(data.readNumber=data.readShort,numDiv=32767.5)},SEA3D.GeometryDelta=function(name,data,sea3d){SEA3D.GeometryDeltaBase.call(this,name,data,sea3d);var i,j,start,delta,len,vec;if(4&this.attrib)for(delta=data.readFloat(),this.normal=new Float32Array(this.length),i=0;i<this.length;)this.normal[i++]=data.readNumber()/this.numDiv*delta;if(8&this.attrib)for(delta=data.readFloat(),this.tangent=new Float32Array(this.length),i=0;i<this.length;)this.tangent[i++]=data.readNumber()/this.numDiv*delta;if(32&this.attrib){this.uv=[],this.uv.length=data.readUByte();var uvLen=2*this.numVertex;for(i=0;i<this.uv.length;)for(delta=data.readFloat(),this.uv[i++]=vec=new Float32Array(uvLen),j=0;uvLen>j;)vec[j++]=data.readNumber()/this.numDiv*delta}if(64&this.attrib){this.jointPerVertex=data.readUByte();var jntLen=this.numVertex*this.jointPerVertex;for(this.joint=new Uint16Array(jntLen),this.weight=new Float32Array(jntLen),i=0;jntLen>i;)this.joint[i++]=data.readUInteger();for(i=0;jntLen>i;)this.weight[i++]=data.readNumber()/this.numDiv*1}if(128&this.attrib){var colorAttrib=data.readUByte(),numColorData=((64&colorAttrib)>>6|(128&colorAttrib)>>6)+1,colorCount=4*this.numVertex;for(this.color=[],this.color.length=15&colorAttrib,this.numColor=4,i=0;i<this.color.length;i++){var vColor=new Float32Array(colorCount);switch(numColorData){case 1:for(j=0;colorCount>j;)vColor[j++]=data.readUByte()/255,vColor[j++]=0,vColor[j++]=0,vColor[j++]=1;break;case 2:for(j=0;colorCount>j;)vColor[j++]=data.readUByte()/255,vColor[j++]=data.readUByte()/255,vColor[j++]=0,vColor[j++]=1;break;case 3:for(j=0;colorCount>j;)vColor[j++]=data.readUByte()/255,vColor[j++]=data.readUByte()/255,vColor[j++]=data.readUByte()/255,vColor[j++]=1;break;case 4:for(j=0;colorCount>j;)vColor[j++]=data.readUByte()/255,vColor[j++]=data.readUByte()/255,vColor[j++]=data.readUByte()/255,vColor[j++]=data.readUByte()/255}this.color[i]=vColor}}for(delta=data.readFloat(),this.vertex=new Float32Array(this.length),i=0;i<this.length;)this.vertex[i++]=data.readNumber()/this.numDiv*delta;var count=data.readUByte();for(this.indexes=vec=[],this.groups=[],j=0,i=0;count>i;i++)for(len=3*data.readVInt(),this.groups.push({start:j,count:len}),len+=j;len>j;)vec[j++]=data.readVInt();var count=data.readUByte();if(this.indexes=vec=[],this.groups=[],2&this.attrib)for(i=0;count>i;i++){for(len=data.readUInteger(),start=vec.length,j=0;len>j;j++){var a=data.readUInteger(),b=data.readUInteger(),c=data.readUInteger(),d=data.readUInteger();vec.push(a),vec.push(b),vec.push(c),d>0&&(vec.push(c),vec.push(d+1),vec.push(a))}this.groups.push({start:start,count:vec.length-start})}else for(j=0,i=0;count>i;i++)for(len=3*data.readUInteger(),this.groups.push({start:j,count:len}),len+=j;len>j;)vec[j++]=data.readUInteger()},SEA3D.GeometryDeltaBase.prototype=Object.create(SEA3D.GeometryDeltaBase.prototype),SEA3D.GeometryDeltaBase.prototype.constructor=SEA3D.GeometryDelta,SEA3D.GeometryDelta.prototype.type="geDL",SEA3D.Object3D=function(name,data,sea3d){if(this.name=name,this.data=data,this.sea3d=sea3d,this.isStatic=!1,this.visible=!0,this.attrib=data.readUShort(),1&this.attrib&&(this.parent=sea3d.getObject(data.readUInt())),2&this.attrib&&(this.animations=data.readAnimationList(sea3d)),4&this.attrib&&(this.scripts=data.readScriptList(sea3d)),16&this.attrib&&(this.properties=sea3d.getObject(data.readUInt())),32&this.attrib){var objectType=data.readUByte();this.isStatic=0!=(1&objectType),this.visible=0!=(2&objectType)}},SEA3D.Object3D.prototype.readTag=function(kind,data,size){},SEA3D.Entity3D=function(name,data,sea3d){if(SEA3D.Object3D.call(this,name,data,sea3d),this.castShadows=!0,64&this.attrib){var lightType=data.readUByte();this.castShadows=0==(1&lightType)}},SEA3D.Entity3D.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Entity3D.prototype.constructor=SEA3D.Entity3D,SEA3D.Sound3D=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),this.autoPlay=0!=(64&this.attrib),128&this.attrib&&(this.mixer=sea3d.getObject(data.readUInt())),this.sound=sea3d.getObject(data.readUInt()),this.volume=data.readFloat()},SEA3D.Sound3D.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Sound3D.prototype.constructor=SEA3D.Sound3D,SEA3D.SoundPoint=function(name,data,sea3d){SEA3D.Sound3D.call(this,name,data,sea3d),this.position=data.readVector3(),this.distance=data.readFloat(),data.readTags(this.readTag.bind(this))},SEA3D.SoundPoint.prototype=Object.create(SEA3D.Sound3D.prototype),SEA3D.SoundPoint.prototype.constructor=SEA3D.SoundPoint,SEA3D.SoundPoint.prototype.type="sp",SEA3D.Container3D=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),this.transform=data.readMatrix(),data.readTags(this.readTag.bind(this))},SEA3D.Container3D.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Container3D.prototype.constructor=SEA3D.Container3D,SEA3D.Container3D.prototype.type="c3d",SEA3D.TextureURL=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.url=data.readUTF(data.length)},SEA3D.TextureURL.prototype.type="urlT",SEA3D.Actions=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.count=data.readUInt(),this.actions=[];for(var i=0;i<this.count;i++){var flag=data.readUByte(),kind=data.readUShort(),size=data.readUShort(),position=data.position,act=this.actions[i]={kind:kind};switch(1&flag&&(act.range=[data.readUInt(),data.readUInt()]),2&flag&&(act.time=data.readUInt()),4&flag&&(act.intrpl=data.readInterpolation(),0==act.intrpl.indexOf("back.")?act.intrplParam0=data.readFloat():0==act.intrpl.indexOf("elastic.")&&(act.intrplParam0=data.readFloat(),act.intrplParam1=data.readFloat())),kind){case SEA3D.Actions.RTT_TARGET:act.source=sea3d.getObject(data.readUInt()),act.target=sea3d.getObject(data.readUInt());break;case SEA3D.Actions.LOOK_AT:act.source=sea3d.getObject(data.readUInt()),act.target=sea3d.getObject(data.readUInt());break;case SEA3D.Actions.PLAY_SOUND:act.sound=sea3d.getObject(data.readUInt()),act.offset=data.readUInt();break;case SEA3D.Actions.PLAY_ANIMATION:act.object=sea3d.getObject(data.readUInt()),act.name=data.readUTF8();break;case SEA3D.Actions.FOG:act.color=data.readUInt24(),act.min=data.readFloat(),act.max=data.readFloat();break;case SEA3D.Actions.ENVIRONMENT:act.texture=sea3d.getObject(data.readUInt());break;case SEA3D.Actions.ENVIRONMENT_COLOR:act.color=data.readUInt24F();break;case SEA3D.Actions.CAMERA:act.camera=sea3d.getObject(data.readUInt());break;case SEA3D.Actions.SCRIPTS:act.scripts=data.readScriptList(sea3d);break;case SEA3D.Actions.CLASS_OF:act.classof=sea3d.getObject(data.readUInt());break;default:console.log('Action "'+kind+'" not found.')}data.position=position+size}},SEA3D.Actions.SCENE=0,SEA3D.Actions.ENVIRONMENT_COLOR=1,SEA3D.Actions.ENVIRONMENT=2,SEA3D.Actions.FOG=3,SEA3D.Actions.PLAY_ANIMATION=4,SEA3D.Actions.PLAY_SOUND=5,SEA3D.Actions.ANIMATION_AUDIO_SYNC=6,SEA3D.Actions.LOOK_AT=7,SEA3D.Actions.RTT_TARGET=8,SEA3D.Actions.CAMERA=9,SEA3D.Actions.SCRIPTS=10,SEA3D.Actions.CLASS_OF=11,SEA3D.Actions.prototype.type="act",SEA3D.Properties=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.tag=data.readProperties(sea3d),this.tag.__name=name},SEA3D.Properties.prototype.type="prop",SEA3D.FileInfo=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.tag=data.readProperties(sea3d),this.tag.__name=name,sea3d.info=this.tag},SEA3D.FileInfo.prototype.type="info",SEA3D.JavaScript=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.src=data.readUTF(data.length)},SEA3D.JavaScript.prototype.type="js",SEA3D.JavaScriptMethod=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d;var count=data.readUShort();this.methods={};for(var i=0;count>i;i++){var method=(data.readUByte(),data.readUTF8());this.methods[method]={src:data.readUTF8Long()}}},SEA3D.JavaScriptMethod.prototype.type="jsm",SEA3D.GLSL=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.src=data.readUTF(data.length)},SEA3D.GLSL.prototype.type="glsl",SEA3D.Dummy=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),this.transform=data.readMatrix(),this.width=data.readFloat(),this.height=data.readFloat(),this.depth=data.readFloat(),data.readTags(this.readTag.bind(this))},SEA3D.Dummy.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Dummy.prototype.constructor=SEA3D.Dummy,SEA3D.Dummy.prototype.type="dmy",SEA3D.Line=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),this.count=3*(64&this.attrib?data.readUInt():data.readUShort()),this.closed=0!=(128&this.attrib),this.transform=data.readMatrix(),this.vertex=[];for(var i=0;i<this.count;)this.vertex[i++]=data.readFloat();data.readTags(this.readTag.bind(this))},SEA3D.Line.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Line.prototype.constructor=SEA3D.Line,SEA3D.Line.prototype.type="line",SEA3D.Mesh2D=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),256&this.attrib&&(this.material=sea3d.getObject(data.readUInt())),this.position=data.readVector3(),this.width=data.readFloat(),this.height=data.readFloat(),data.readTags(this.readTag.bind(this))},SEA3D.Mesh2D.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Mesh2D.prototype.constructor=SEA3D.Mesh2D,SEA3D.Mesh2D.prototype.type="m2d",SEA3D.Mesh=function(name,data,sea3d){if(SEA3D.Entity3D.call(this,name,data,sea3d),256&this.attrib){this.material=[];var len=data.readUByte();if(1==len)this.material[0]=sea3d.getObject(data.readUInt());else for(var i=0;len>i;){var matIndex=data.readUInt();matIndex>0?this.material[i++]=sea3d.getObject(matIndex-1):this.material[i++]=void 0}}if(512&this.attrib){this.modifiers=[];for(var len=data.readUByte(),i=0;len>i;i++)this.modifiers[i]=sea3d.getObject(data.readUInt())}1024&this.attrib&&(this.reference={type:data.readUByte(),ref:sea3d.getObject(data.readUInt())}),this.transform=data.readMatrix(),this.geometry=sea3d.getObject(data.readUInt()),data.readTags(this.readTag.bind(this))},SEA3D.Mesh.prototype=Object.create(SEA3D.Entity3D.prototype),SEA3D.Mesh.prototype.constructor=SEA3D.Mesh,SEA3D.Mesh.prototype.type="m3d",SEA3D.Skeleton=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d;var length=data.readUShort();this.joint=[];for(var i=0;length>i;i++)this.joint[i]={name:data.readUTF8(),parentIndex:data.readUShort()-1,inverseBindMatrix:data.readMatrix()}},SEA3D.Skeleton.prototype.type="skl",SEA3D.SkeletonLocal=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d;var length=data.readUShort();this.joint=[];for(var i=0;length>i;i++)this.joint[i]={name:data.readUTF8(),parentIndex:data.readUShort()-1,x:data.readFloat(),y:data.readFloat(),z:data.readFloat(),qx:data.readFloat(),qy:data.readFloat(),qz:data.readFloat(),qw:data.readFloat()}},SEA3D.SkeletonLocal.prototype.type="sklq",SEA3D.AnimationBase=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d;var flag=data.readUByte();if(this.sequence=[],1&flag)for(var count=data.readUShort(),i=0;count>i;i++)flag=data.readUByte(),this.sequence[i]={name:data.readUTF8(),start:data.readUInt(),count:data.readUInt(),repeat:0!=(1&flag),intrpl:0!=(2&flag)};this.frameRate=data.readUByte(),this.numFrames=data.readUInt(),0==this.sequence.length&&(this.sequence[0]={name:"root",start:0,count:this.numFrames,repeat:!0,intrpl:!0})},SEA3D.Animation=function(name,data,sea3d){SEA3D.AnimationBase.call(this,name,data,sea3d),this.dataList=[];for(var i=0,l=data.readUByte();l>i;i++){var kind=data.readUShort(),type=data.readUByte(),anmRaw=data.readVector(type,this.numFrames,0);this.dataList.push({kind:kind,type:type,blockSize:SEA3D.Stream.sizeOf(type),data:anmRaw})}},SEA3D.Animation.POSITION=0,SEA3D.Animation.ROTATION=1,SEA3D.Animation.SCALE=2,SEA3D.Animation.COLOR=3,SEA3D.Animation.MULTIPLIER=4,SEA3D.Animation.ATTENUATION_START=5,SEA3D.Animation.ATTENUATION_END=6,SEA3D.Animation.FOV=7,SEA3D.Animation.OFFSET_U=8,SEA3D.Animation.OFFSET_V=9,SEA3D.Animation.SCALE_U=10,SEA3D.Animation.SCALE_V=11,SEA3D.Animation.ANGLE=12,SEA3D.Animation.ALPHA=13,SEA3D.Animation.VOLUME=14,SEA3D.Animation.DefaultLerpFuncs=[SEA3D.Math.lerp3x,SEA3D.Math.lerpQuat4x,SEA3D.Math.lerp3x,SEA3D.Math.lerpColor1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x,SEA3D.Math.lerpAng1x,SEA3D.Math.lerp1x,SEA3D.Math.lerp1x],SEA3D.Animation.prototype=Object.create(SEA3D.AnimationBase.prototype),SEA3D.Animation.prototype.constructor=SEA3D.Animation,SEA3D.Animation.prototype.type="anm",SEA3D.SkeletonAnimation=function(name,data,sea3d){SEA3D.AnimationBase.call(this,name,data,sea3d),this.name=name,this.data=data,this.sea3d=sea3d,this.numJoints=data.readUShort(),this.raw=data.readFloatArray(this.numFrames*this.numJoints*7)},SEA3D.SkeletonAnimation.prototype.type="skla",SEA3D.Morph=function(name,data,sea3d){SEA3D.GeometryBase.call(this,name,data,sea3d);var useVertex=0!=(2&this.attrib),useNormal=0!=(4&this.attrib),nodeCount=data.readUShort();this.node=[];for(var i=0;nodeCount>i;i++){var verts,norms,nodeName=data.readUTF8();useVertex&&(verts=data.readFloatArray(this.length)),useNormal&&(norms=data.readFloatArray(this.length)),this.node[i]={vertex:verts,normal:norms,name:nodeName}}},SEA3D.Morph.prototype=Object.create(SEA3D.GeometryBase.prototype),SEA3D.Morph.prototype.constructor=SEA3D.Morph,SEA3D.Morph.prototype.type="mph",SEA3D.VertexAnimation=function(name,data,sea3d){SEA3D.AnimationBase.call(this,name,data,sea3d);var flags=data.readUByte();this.isBig=0!=(1&flags),data.readVInt=this.isBig?data.readUInt:data.readUShort,this.numVertex=data.readVInt(),this.length=3*this.numVertex;var useVertex=0!=(2&flags),useNormal=0!=(4&flags);this.frame=[];var i,verts,norms;for(i=0;i<this.numFrames;i++)useVertex&&(verts=data.readFloatArray(this.length)),useNormal&&(norms=data.readFloatArray(this.length)),this.frame[i]={vertex:verts,normal:norms}},SEA3D.VertexAnimation.prototype=Object.create(SEA3D.AnimationBase.prototype),SEA3D.VertexAnimation.prototype.constructor=SEA3D.VertexAnimation,SEA3D.VertexAnimation.prototype.type="vtxa",SEA3D.Camera=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),64&this.attrib&&(this.dof={distance:data.readFloat(),range:data.readFloat()}),this.transform=data.readMatrix(),this.fov=data.readFloat(),data.readTags(this.readTag.bind(this))},SEA3D.Camera.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Camera.prototype.constructor=SEA3D.Camera,SEA3D.Camera.prototype.type="cam",SEA3D.JointObject=function(name,data,sea3d){SEA3D.Object3D.call(this,name,data,sea3d),this.target=sea3d.getObject(data.readUInt()),this.joint=data.readUShort(),data.readTags(this.readTag.bind(this))},SEA3D.JointObject.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.JointObject.prototype.constructor=SEA3D.JointObject,SEA3D.JointObject.prototype.type="jnt",SEA3D.Light=function(name,data,sea3d){if(SEA3D.Object3D.call(this,name,data,sea3d),this.attenStart=Number.MAX_VALUE,this.attenEnd=Number.MAX_VALUE,64&this.attrib){var shadowHeader=data.readUByte();this.shadow={},this.shadow.opacity=1&shadowHeader?data.readFloat():1,this.shadow.color=2&shadowHeader?data.readUInt24():0}512&this.attrib&&(this.attenStart=data.readFloat(),this.attenEnd=data.readFloat()),this.color=data.readUInt24(),this.multiplier=data.readFloat()},SEA3D.Light.prototype=Object.create(SEA3D.Object3D.prototype),SEA3D.Light.prototype.constructor=SEA3D.Light,SEA3D.PointLight=function(name,data,sea3d){SEA3D.Light.call(this,name,data,sea3d),128&this.attrib&&(this.attenuation={start:data.readFloat(),end:data.readFloat()}),this.position=data.readVector3(),data.readTags(this.readTag.bind(this))},SEA3D.PointLight.prototype=Object.create(SEA3D.Light.prototype),SEA3D.PointLight.prototype.constructor=SEA3D.PointLight,SEA3D.PointLight.prototype.type="plht",SEA3D.HemisphereLight=function(name,data,sea3d){SEA3D.Light.call(this,name,data,sea3d),128&this.attrib&&(this.attenuation={start:data.readFloat(),end:data.readFloat()}),this.secondColor=data.readUInt24(),data.readTags(this.readTag.bind(this))},SEA3D.HemisphereLight.prototype=Object.create(SEA3D.Light.prototype),SEA3D.HemisphereLight.prototype.constructor=SEA3D.HemisphereLight,SEA3D.HemisphereLight.prototype.type="hlht",SEA3D.DirectionalLight=function(name,data,sea3d){SEA3D.Light.call(this,name,data,sea3d),this.transform=data.readMatrix(),data.readTags(this.readTag.bind(this))},SEA3D.DirectionalLight.prototype=Object.create(SEA3D.Light.prototype),SEA3D.DirectionalLight.prototype.constructor=SEA3D.DirectionalLight,SEA3D.DirectionalLight.prototype.type="dlht",SEA3D.Material=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.technique=[],this.attrib=data.readUShort(),this.alpha=1,this.blendMode="normal",this.alphaThreshold=.5,this.bothSides=0!=(1&this.attrib),this.receiveLights=0==(2&this.attrib),this.receiveShadows=0==(4&this.attrib),this.receiveFog=0==(8&this.attrib),this.smooth=0==(16&this.attrib),32&this.attrib&&(this.alpha=data.readFloat()),64&this.attrib&&(this.blendMode=data.readBlendMode()),128&this.attrib&&(this.animations=data.readAnimationList(sea3d)),this.depthMask=0==(256&this.attrib);for(var count=data.readUByte(),i=0;count>i;++i){var tech,methodAttrib,kind=data.readUShort(),size=data.readUShort(),pos=data.position;switch(kind){case SEA3D.Material.DEFAULT:tech={ambientColor:data.readUInt24(),diffuseColor:data.readUInt24(),specularColor:data.readUInt24(),specular:data.readFloat(),gloss:data.readFloat()};break;case SEA3D.Material.COMPOSITE_TEXTURE:
tech={composite:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.DIFFUSE_MAP:tech={texture:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.SPECULAR_MAP:tech={texture:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.NORMAL_MAP:tech={texture:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.REFLECTION:case SEA3D.Material.FRESNEL_REFLECTION:tech={texture:sea3d.getObject(data.readUInt()),alpha:data.readFloat()},kind==SEA3D.Material.FRESNEL_REFLECTION&&(tech.power=data.readFloat(),tech.normal=data.readFloat());break;case SEA3D.Material.REFRACTION:tech={texture:sea3d.getObject(data.readUInt()),alpha:data.readFloat(),ior:data.readFloat()};break;case SEA3D.Material.RIM:tech={color:data.readUInt24(),strength:data.readFloat(),power:data.readFloat(),blendMode:data.readBlendMode()};break;case SEA3D.Material.LIGHT_MAP:tech={texture:sea3d.getObject(data.readUInt()),channel:data.readUByte(),blendMode:data.readBlendMode()};break;case SEA3D.Material.DETAIL_MAP:tech={texture:sea3d.getObject(data.readUInt()),scale:data.readFloat(),blendMode:data.readBlendMode()};break;case SEA3D.Material.CEL:tech={color:data.readUInt24(),levels:data.readUByte(),size:data.readFloat(),specularCutOff:data.readFloat(),smoothness:data.readFloat()};break;case SEA3D.Material.TRANSLUCENT:tech={color:data.readUInt24(),translucency:data.readFloat(),scattering:data.readFloat()};break;case SEA3D.Material.BLEND_NORMAL_MAP:methodAttrib=data.readUByte(),tech={texture:sea3d.getObject(data.readUInt()),secondaryTexture:sea3d.getObject(data.readUInt())},1&methodAttrib?(tech.offsetX0=data.readFloat(),tech.offsetY0=data.readFloat(),tech.offsetX1=data.readFloat(),tech.offsetY1=data.readFloat()):tech.offsetX0=tech.offsetY0=tech.offsetX1=tech.offsetY1=0,tech.animate=2&methodAttrib;break;case SEA3D.Material.MIRROR_REFLECTION:tech={texture:sea3d.getObject(data.readUInt()),alpha:data.readFloat()};break;case SEA3D.Material.AMBIENT_MAP:tech={texture:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.ALPHA_MAP:tech={texture:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.EMISSIVE_MAP:tech={texture:sea3d.getObject(data.readUInt())};break;case SEA3D.Material.VERTEX_COLOR:tech={blendMode:data.readBlendMode()};break;case SEA3D.Material.WRAP_LIGHTING:tech={color:data.readUInt24(),strength:data.readFloat()};break;case SEA3D.Material.COLOR_REPLACE:methodAttrib=data.readUByte(),tech={red:data.readUInt24(),green:data.readUInt24(),blue:data.readUInt24()},1&methodAttrib&&(tech.mask=sea3d.getObject(data.readUInt())),2&methodAttrib&&(tech.alpha=data.readFloat());break;case SEA3D.Material.REFLECTION_SPHERICAL:tech={texture:sea3d.getObject(data.readUInt()),alpha:data.readFloat()};break;default:console.warn("SEA3D: MaterialTechnique not found:",kind.toString(16)),data.position=pos+=size;continue}tech.kind=kind,this.technique.push(tech),data.position=pos+=size}},SEA3D.Material.DEFAULT=0,SEA3D.Material.COMPOSITE_TEXTURE=1,SEA3D.Material.DIFFUSE_MAP=2,SEA3D.Material.SPECULAR_MAP=3,SEA3D.Material.REFLECTION=4,SEA3D.Material.REFRACTION=5,SEA3D.Material.NORMAL_MAP=6,SEA3D.Material.FRESNEL_REFLECTION=7,SEA3D.Material.RIM=8,SEA3D.Material.LIGHT_MAP=9,SEA3D.Material.DETAIL_MAP=10,SEA3D.Material.CEL=11,SEA3D.Material.TRANSLUCENT=12,SEA3D.Material.BLEND_NORMAL_MAP=13,SEA3D.Material.MIRROR_REFLECTION=14,SEA3D.Material.AMBIENT_MAP=15,SEA3D.Material.ALPHA_MAP=16,SEA3D.Material.EMISSIVE_MAP=17,SEA3D.Material.VERTEX_COLOR=18,SEA3D.Material.WRAP_LIGHTING=19,SEA3D.Material.COLOR_REPLACE=20,SEA3D.Material.REFLECTION_SPHERICAL=21,SEA3D.Material.prototype.type="mat",SEA3D.Composite=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d;var layerCount=data.readUByte();this.layer=[];for(var i=0;layerCount>i;i++)this.layer[i]=new SEA3D.Composite.prototype.Layer(data,sea3d)},SEA3D.Composite.prototype.getLayerByName=function(name){for(var i=0;i<this.layer.length;i++)if(this.layer[i].name==name)return this.layer[i]},SEA3D.Composite.prototype.Layer=function(data,sea3d){var attrib=data.readUShort();1&attrib?this.texture=new SEA3D.Composite.LayerBitmap(data,sea3d):this.color=data.readUInt24(),2&attrib&&(this.mask=new SEA3D.Composite.LayerBitmap(data,sea3d)),4&attrib&&(this.name=data.readUTF8()),this.blendMode=8&attrib?data.readBlendMode():"normal",this.opacity=16&attrib?data.readFloat():1},SEA3D.Composite.LayerBitmap=function(data,sea3d){this.map=sea3d.getObject(data.readUInt());var attrib=data.readUShort();this.channel=1&attrib?data.readUByte():0,this.repeat=attrib&!1,this.offsetU=4&attrib?data.readFloat():0,this.offsetV=8&attrib?data.readFloat():0,this.scaleU=16&attrib?data.readFloat():1,this.scaleV=32&attrib?data.readFloat():1,this.rotation=64&attrib?data.readFloat():0,128&attrib&&(this.animation=data.readAnimationList(sea3d))},SEA3D.Composite.prototype.type="ctex",SEA3D.Sphere=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.radius=data.readFloat()},SEA3D.Sphere.prototype.type="sph",SEA3D.Box=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.width=data.readFloat(),this.height=data.readFloat(),this.depth=data.readFloat()},SEA3D.Box.prototype.type="box",SEA3D.Cone=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.radius=data.readFloat(),this.height=data.readFloat()},SEA3D.Cone.prototype.type="cone",SEA3D.Capsule=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.radius=data.readFloat(),this.height=data.readFloat()},SEA3D.Capsule.prototype.type="cap",SEA3D.Cylinder=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.radius=data.readFloat(),this.height=data.readFloat()},SEA3D.Cylinder.prototype.type="cyl",SEA3D.ConvexGeometry=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.geometry=sea3d.getObject(data.readUInt()),this.subGeometryIndex=data.readUByte()},SEA3D.ConvexGeometry.prototype.type="gs",SEA3D.TriangleGeometry=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.geometry=sea3d.getObject(data.readUInt()),this.subGeometryIndex=data.readUByte()},SEA3D.TriangleGeometry.prototype.type="sgs",SEA3D.Compound=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.compounds=[];for(var count=data.readUByte(),i=0;count>i;i++)this.compounds.push({shape:sea3d.getObject(data.readUInt()),transform:data.readMatrix()})},SEA3D.Compound.prototype.type="cmps",SEA3D.Physics=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.attrib=data.readUShort(),this.shape=sea3d.getObject(data.readUInt()),1&this.attrib?this.target=sea3d.getObject(data.readUInt()):this.transform=data.readMatrix()},SEA3D.Physics.prototype.readTag=function(kind,data,size){},SEA3D.RigidBodyBase=function(name,data,sea3d){SEA3D.Physics.call(this,name,data,sea3d),32&this.attrib?(this.linearDamping=data.readFloat(),this.angularDamping=data.readFloat()):(this.linearDamping=0,this.angularDamping=0),this.mass=data.readFloat(),this.friction=data.readFloat(),this.restitution=data.readFloat()},SEA3D.RigidBodyBase.prototype=Object.create(SEA3D.Physics.prototype),SEA3D.RigidBodyBase.prototype.constructor=SEA3D.RigidBodyBase,SEA3D.RigidBody=function(name,data,sea3d){SEA3D.RigidBodyBase.call(this,name,data,sea3d),data.readTags(this.readTag.bind(this))},SEA3D.RigidBody.prototype=Object.create(SEA3D.RigidBodyBase.prototype),SEA3D.RigidBody.prototype.constructor=SEA3D.RigidBody,SEA3D.RigidBody.prototype.type="rb",SEA3D.CarController=function(name,data,sea3d){SEA3D.RigidBodyBase.call(this,name,data,sea3d),this.suspensionStiffness=data.readFloat(),this.suspensionCompression=data.readFloat(),this.suspensionDamping=data.readFloat(),this.maxSuspensionTravelCm=data.readFloat(),this.frictionSlip=data.readFloat(),this.maxSuspensionForce=data.readFloat(),this.dampingCompression=data.readFloat(),this.dampingRelaxation=data.readFloat();var count=data.readUByte();this.wheel=[];for(var i=0;count>i;i++)this.wheel[i]=new SEA3D.CarController.Wheel(data,sea3d);data.readTags(this.readTag.bind(this))},SEA3D.CarController.Wheel=function(data,sea3d){this.data=data,this.sea3d=sea3d;var attrib=data.readUShort();this.isFront=0!=(1&attrib),this.target=sea3d.getObject(data.readUInt()),this.pos=data.readVector3(),this.dir=data.readVector3(),this.axle=data.readVector3(),this.radius=data.readFloat(),this.suspensionRestLength=data.readFloat()},SEA3D.CarController.prototype=Object.create(SEA3D.RigidBodyBase.prototype),SEA3D.CarController.prototype.constructor=SEA3D.CarController,SEA3D.CarController.prototype.type="carc",SEA3D.Constraints=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.attrib=data.readUShort(),this.disableCollisionsBetweenBodies=this.attrib&!0,this.targetA=sea3d.getObject(data.readUInt()),this.pointA=data.readVector3(),2&this.attrib&&(this.targetB=sea3d.getObject(data.readUInt()),this.pointB=data.readVector3())},SEA3D.P2PConstraint=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,SEA3D.Constraints.call(this,name,data,sea3d)},SEA3D.P2PConstraint.prototype=Object.create(SEA3D.Constraints.prototype),SEA3D.P2PConstraint.prototype.constructor=SEA3D.P2PConstraint,SEA3D.P2PConstraint.prototype.type="p2pc",SEA3D.HingeConstraint=function(name,data,sea3d){SEA3D.Constraints.call(this,name,data,sea3d),this.axisA=data.readVector3(),1&this.attrib&&(this.axisB=data.readVector3()),4&this.attrib&&(this.limit={low:data.readFloat(),high:data.readFloat(),softness:data.readFloat(),biasFactor:data.readFloat(),relaxationFactor:data.readFloat()}),8&this.attrib&&(this.angularMotor={velocity:data.readFloat(),impulse:data.readFloat()})},SEA3D.HingeConstraint.prototype=Object.create(SEA3D.Constraints.prototype),SEA3D.HingeConstraint.prototype.constructor=SEA3D.HingeConstraint,SEA3D.HingeConstraint.prototype.type="hnec",SEA3D.ConeTwistConstraint=function(name,data,sea3d){SEA3D.Constraints.call(this,name,data,sea3d),this.axisA=data.readVector3(),1&this.attrib&&(this.axisB=data.readVector3()),4&this.attrib&&(this.limit={swingSpan1:data.readFloat(),swingSpan2:data.readFloat(),twistSpan:data.readFloat(),softness:data.readFloat(),biasFactor:data.readFloat(),relaxationFactor:data.readFloat()})},SEA3D.ConeTwistConstraint.prototype=Object.create(SEA3D.Constraints.prototype),SEA3D.ConeTwistConstraint.prototype.constructor=SEA3D.ConeTwistConstraint,SEA3D.ConeTwistConstraint.prototype.type="ctwc",SEA3D.PlanarRender=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.attrib=data.readUByte(),this.quality=1&this.attrib|2&this.attrib,this.transform=data.readMatrix()},SEA3D.PlanarRender.prototype.type="rttp",SEA3D.CubeRender=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.attrib=data.readUByte(),this.quality=1&this.attrib|2&this.attrib,this.position=data.readVector3()},SEA3D.CubeRender.prototype.type="rttc",SEA3D.CubeMap=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.transparent=!1;data.readExt();this.faces=[];for(var i=0;6>i;i++){var size=data.readUInt();this.faces[i]=data.concat(data.position,size),data.position+=size}},SEA3D.CubeMap.prototype.type="cmap",SEA3D.JPEG=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.transparent=!1},SEA3D.JPEG.prototype.type="jpg",SEA3D.JPEG_XR=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.transparent=!0},SEA3D.JPEG_XR.prototype.type="wdp",SEA3D.PNG=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.transparent=6==data.getByte(25)},SEA3D.PNG.prototype.type="png",SEA3D.GIF=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d,this.transparent=data.getByte(11)>0},SEA3D.GIF.prototype.type="gif",SEA3D.OGG=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d},SEA3D.OGG.prototype.type="ogg",SEA3D.MP3=function(name,data,sea3d){this.name=name,this.data=data,this.sea3d=sea3d},SEA3D.MP3.prototype.type="mp3",SEA3D.File=function(data){this.version=SEA3D.VERSION,this.objects=[],this.typeClass={},this.typeRead={},this.typeUnique={},this.position=this.dataPosition=0,this.scope=this,this.streaming=!0,this.timeLimit=60,this.addClass(SEA3D.FileInfo,!0),this.addClass(SEA3D.Geometry,!0),this.addClass(SEA3D.GeometryDelta,!0),this.addClass(SEA3D.Mesh),this.addClass(SEA3D.Mesh2D),this.addClass(SEA3D.Material),this.addClass(SEA3D.Composite),this.addClass(SEA3D.PointLight),this.addClass(SEA3D.DirectionalLight),this.addClass(SEA3D.HemisphereLight),this.addClass(SEA3D.Skeleton,!0),this.addClass(SEA3D.SkeletonLocal,!0),this.addClass(SEA3D.SkeletonAnimation,!0),this.addClass(SEA3D.JointObject),this.addClass(SEA3D.Camera),this.addClass(SEA3D.Morph,!0),this.addClass(SEA3D.VertexAnimation,!0),this.addClass(SEA3D.CubeMap,!0),this.addClass(SEA3D.Animation),this.addClass(SEA3D.Dummy),this.addClass(SEA3D.Line),this.addClass(SEA3D.SoundPoint),this.addClass(SEA3D.PlanarRender),this.addClass(SEA3D.CubeRender),this.addClass(SEA3D.Actions),this.addClass(SEA3D.Container3D),this.addClass(SEA3D.Properties),this.addClass(SEA3D.TextureURL,!0),this.addClass(SEA3D.Sphere),this.addClass(SEA3D.Box),this.addClass(SEA3D.Cone),this.addClass(SEA3D.Capsule),this.addClass(SEA3D.Cylinder),this.addClass(SEA3D.ConvexGeometry),this.addClass(SEA3D.TriangleGeometry),this.addClass(SEA3D.Compound),this.addClass(SEA3D.RigidBody),this.addClass(SEA3D.P2PConstraint),this.addClass(SEA3D.HingeConstraint),this.addClass(SEA3D.ConeTwistConstraint),this.addClass(SEA3D.CarController),this.addClass(SEA3D.JPEG,!0),this.addClass(SEA3D.JPEG_XR,!0),this.addClass(SEA3D.PNG,!0),this.addClass(SEA3D.GIF,!0),this.addClass(SEA3D.OGG,!0),this.addClass(SEA3D.MP3,!0),this.addClass(SEA3D.JavaScript,!0),this.addClass(SEA3D.JavaScriptMethod,!0),this.addClass(SEA3D.GLSL,!0)},SEA3D.File.CompressionLibs={},SEA3D.File.DecompressionMethod={},SEA3D.File.setDecompressionEngine=function(id,name,method){SEA3D.File.CompressionLibs[id]=name,SEA3D.File.DecompressionMethod[id]=method},SEA3D.File.prototype.addClass=function(clazz,unique){this.typeClass[clazz.prototype.type]=clazz,this.typeUnique[clazz.prototype.type]=unique===!0},SEA3D.File.prototype.readHead=function(){if(this.stream.bytesAvailable<16)return!1;if("SEA"!=this.stream.readUTF(3))throw new Error("Invalid SEA3D format.");if(this.sign=this.stream.readUTF(3),this.version=this.stream.readUInt24(),0!=this.stream.readUByte())throw new Error("Protection algorithm not compatible.");if(this.compressionID=this.stream.readUByte(),this.compressionAlgorithm=SEA3D.File.CompressionLibs[this.compressionID],this.decompressionMethod=SEA3D.File.DecompressionMethod[this.compressionID],this.compressionID>0&&!this.decompressionMethod)throw new Error("Compression algorithm not compatible.");return this.length=this.stream.readUInt(),this.dataPosition=this.stream.position,this.objects.length=0,this.state=this.readBody,this.onHead&&this.onHead({file:this,sign:this.sign}),!0},SEA3D.File.prototype.getObject=function(index){return this.objects[index]},SEA3D.File.prototype.readSEAObject=function(){if(this.stream.bytesAvailable<4)return null;var size=this.stream.readUInt(),position=this.stream.position;if(this.stream.bytesAvailable<size)return null;var flag=this.stream.readUByte(),type=this.stream.readExt(),meta=null,name=1&flag?this.stream.readUTF8():"",compressed=0!=(2&flag),streaming=0!=(4&flag);if(8&flag){var metalen=this.stream.readUShort(),metabytes=this.stream.concat(this.stream.position,metalen);this.stream.position+=metalen,compressed&&this.decompressionMethod&&metabytes.set(this.decompressionMethod(metabytes.buffer)),meta=metabytes.readProperties(this)}size-=this.stream.position-position,position=this.stream.position;var obj,data=this.stream.concat(position,size);return this.typeClass[type]?(compressed&&this.decompressionMethod&&(data.buffer=this.decompressionMethod(data.buffer)),obj=new this.typeClass[type](name,data,this),this.streaming&&streaming&&this.typeRead[type]&&this.typeRead[type].call(this.scope,obj)):(obj=new SEA3D.Object(name,data,type,this),console.warn('SEA3D: Unknown format "'+type+'" of file "'+name+'". Add a module referring for this format.')),obj.streaming=streaming,obj.metadata=meta,this.objects.push(this.objects[obj.type+"/"+obj.name]=obj),this.dataPosition=position+size,++this.position,obj},SEA3D.File.prototype.readBody=function(){for(this.timer.update();this.position<this.length;){if(!(this.timer.deltaTime<this.timeLimit))return!1;this.stream.position=this.dataPosition;var sea=this.readSEAObject();if(!sea)return!1;this.dispatchCompleteObject(sea)}return this.state=this.readComplete,!0},SEA3D.File.prototype.parse=function(){this.timer=new SEA3D.Timer,this.position=0,setTimeout(this.parseObject.bind(this),10)},SEA3D.File.prototype.parseObject=function(){for(this.timer.update();this.position<this.length&&this.timer.deltaTime<this.timeLimit;){var obj=this.objects[this.position++],type=obj.type;this.typeUnique[type]||delete obj.tag,obj.streaming&&this.typeRead[type]&&void 0==obj.tag&&this.typeRead[type].call(this.scope,obj)}if(this.position==this.length){var elapsedTime=this.timer.elapsedTime,message=elapsedTime+"ms, "+this.objects.length+" objects";this.onParseComplete?this.onParseComplete({file:this,timeTotal:elapsedTime,message:message}):console.log("SEA3D Parse Complete:",message)}else this.onParseProgress&&this.onParseProgress({file:this,loaded:this.position,total:this.length,progress:this.position/this.length}),setTimeout(this.parseObject.bind(this),10)},SEA3D.File.prototype.readComplete=function(){this.stream.position=this.dataPosition,6202321!=this.stream.readUInt24F()&&console.warn("SEA3D file is corrupted."),delete this.state,this.dispatchComplete()},SEA3D.File.prototype.readState=function(){for(;this.state&&this.state(););this.state&&(setTimeout(this.readState.bind(this),10),this.dispatchProgress())},SEA3D.File.prototype.read=function(data){this.stream=new SEA3D.Stream(data),this.timer=new SEA3D.Timer,this.state=this.readHead,this.readState()},SEA3D.File.prototype.dispatchCompleteObject=function(obj){this.onCompleteObject&&this.onCompleteObject({file:this,object:obj})},SEA3D.File.prototype.dispatchProgress=function(){this.onProgress&&this.onProgress({file:this,loaded:this.position,total:this.length,progress:this.position/this.length})},SEA3D.File.prototype.dispatchDownloadProgress=function(position,length){this.onDownloadProgress&&this.onDownloadProgress({file:this,loaded:position,total:length,progress:position/length})},SEA3D.File.prototype.dispatchComplete=function(){var elapsedTime=this.timer.elapsedTime,message=elapsedTime+"ms, "+this.objects.length+" objects";this.onComplete?this.onComplete({file:this,timeTotal:elapsedTime,message:message}):console.log("SEA3D:",message)},SEA3D.File.prototype.dispatchError=function(id,message){this.onError?this.onError({file:this,id:id,message:message}):console.error("SEA3D: #"+id,message)},SEA3D.File.prototype.load=function(url){var file=this,xhr=new XMLHttpRequest;xhr.open("GET",url,!0),xhr.responseType="arraybuffer",xhr.onprogress=function(e){e.lengthComputable&&file.dispatchDownloadProgress(e.loaded,e.total)},xhr.onreadystatechange=function(){2===xhr.readyState||3===xhr.readyState||4===xhr.readyState&&(200===xhr.status||0===xhr.status?file.read(this.response):this.dispatchError(1001,"Couldn't load ["+url+"] ["+xhr.status+"]"))},xhr.send()},SEA3D.EventDispatcher=function(){},SEA3D.EventDispatcher.prototype={constructor:SEA3D.EventDispatcher,addEventListener:function(type,listener){void 0===this._listeners&&(this._listeners={});var listeners=this._listeners;void 0===listeners[type]&&(listeners[type]=[]),-1===listeners[type].indexOf(listener)&&listeners[type].push(listener)},hasEventListener:function(type,listener){if(void 0===this._listeners)return!1;var listeners=this._listeners;return void 0!==listeners[type]&&-1!==listeners[type].indexOf(listener)},removeEventListener:function(type,listener){if(void 0!==this._listeners){var listeners=this._listeners,listenerArray=listeners[type];if(void 0!==listenerArray){var index=listenerArray.indexOf(listener);-1!==index&&listenerArray.splice(index,1)}}},dispatchEvent:function(event){if(void 0!==this._listeners){var listeners=this._listeners,listenerArray=listeners[event.type];if(void 0!==listenerArray){event.target=this;for(var array=[],length=listenerArray.length,i=0;length>i;i++)array[i]=listenerArray[i];for(var i=0;length>i;i++)array[i].call(this,event)}}}},SEA3D.EventDispatcher.apply=function(object){object.addEventListener=SEA3D.EventDispatcher.prototype.addEvenListener,object.hasEventListener=SEA3D.EventDispatcher.prototype.hasEventListener,object.removeEventListener=SEA3D.EventDispatcher.prototype.removeEventListener,object.dispatchEvent=SEA3D.EventDispatcher.prototype.dispatchEvent},THREE.SEA3D=function(config){this.config=config||{},void 0==this.config.script&&(this.config.script=!0),void 0==this.config.autoPlay&&(this.config.autoPlay=!1),void 0==this.config.multiplier&&(this.config.multiplier=1),void 0==this.config.bounding&&(this.config.bounding=!0),void 0==this.config.standardMaterial&&(this.config.standardMaterial=!0),void 0==this.config.audioRolloffFactor&&(this.config.audioRolloffFactor=10),void 0==this.config.timeLimit&&(this.config.timeLimit=10),void 0==this.config.streaming&&(this.config.streaming=!0),void 0==this.config.lights&&(this.config.lights=!0),void 0==this.config.useVertexTexture&&(this.config.useVertexTexture=!0)},THREE.SEA3D.prototype={constructor:THREE.SEA3D,addEventListener:THREE.EventDispatcher.prototype.addEventListener,hasEventListener:THREE.EventDispatcher.prototype.hasEventListener,removeEventListener:THREE.EventDispatcher.prototype.removeEventListener,dispatchEvent:THREE.EventDispatcher.prototype.dispatchEvent,set container(val){this.config.container=val},get container(){return this.config.container}},THREE.SEA3D.BACKGROUND_COLOR=3355443,THREE.SEA3D.HELPER_COLOR=10140133,THREE.SEA3D.RTT_SIZE=512,THREE.SEA3D.ShaderLib={},THREE.SEA3D.ShaderLib.replaceCode=function(src,target,replace){for(var i=0;i<target.length;i++){var tar=target[i],rep=replace[i],index=src.indexOf(tar);index>-1&&(src=src.substring(0,index)+rep+src.substring(index+tar.length))}return src},THREE.SEA3D.ShaderLib.fragStdMtl=THREE.SEA3D.ShaderLib.replaceCode(THREE.ShaderLib.phong.fragmentShader,["vec3 outgoingLight = ( reflectedLight.directDiffuse + reflectedLight.indirectDiffuse ) * specular + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;","vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight;"],["vec3 outgoingLight = ( reflectedLight.directDiffuse + reflectedLight.indirectDiffuse ) * specular + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight * specular;","vec3 outgoingLight = reflectedLight.directDiffuse + reflectedLight.indirectDiffuse + reflectedLight.directSpecular + reflectedLight.indirectSpecular + totalEmissiveLight * diffuse;"]),THREE.SEA3D.StandardMaterial=function(){THREE.MeshPhongMaterial.call(this)},THREE.SEA3D.StandardMaterial.prototype=Object.create(THREE.MeshPhongMaterial.prototype),THREE.SEA3D.StandardMaterial.prototype.constructor=THREE.SEA3D.StandardMaterial,THREE.SEA3D.StandardMaterial.prototype.lightMapUV=1,THREE.SEA3D.StandardMaterial.prototype.__defineSetter__("__webglShader",function(val){val.fragmentShader=THREE.SEA3D.ShaderLib.fragStdMtl,0==this.lightMapUV&&(val.fragmentShader=THREE.SEA3D.ShaderLib.replaceCode(val.fragmentShader,"texture2D( aoMap, vUv2 )","texture2D( aoMap, vUv )")),this.__webglShader__=val}),THREE.SEA3D.StandardMaterial.prototype.__defineGetter__("__webglShader",function(){return this.__webglShader__}),THREE.SEA3D.StandardMaterial.prototype.copy=function(source){return THREE.MeshPhongMaterial.prototype.copy.call(this,source),this},THREE.SEA3D.StandardMaterial.prototype.clone=function(){return(new this.constructor).copy(this)},THREE.SEA3D.Object3D=function(){THREE.Object3D.call(this)},THREE.SEA3D.Object3D.prototype=Object.create(THREE.Object3D.prototype),THREE.SEA3D.Object3D.prototype.constructor=THREE.SEA3D.Object3D,THREE.SEA3D.Object3D.prototype.updateAnimateMatrix=function(force){this.matrixAutoUpdate===!0&&this.updateMatrix(),this.matrixWorldNeedsUpdate!==!0&&force!==!0||(null===this.parent?this.matrixWorld.copy(this.matrix):this.matrixWorld.multiplyMatrices(this.parent.matrixWorld,this.matrix),this.animateMatrix.compose(this.animatePosition,this.animateQuaternion,this.animateScale),this.matrixWorld.multiplyMatrices(this.matrixWorld,this.animateMatrix),this.matrixWorldNeedsUpdate=!1,force=!0);for(var i=0,l=this.children.length;l>i;i++)this.children[i].updateMatrixWorld(force)},THREE.SEA3D.Object3D.prototype.setAnimateMatrix=function(val){this.getAnimateMatrix()!=val&&(val?(this.animateMatrix=new THREE.Matrix4,this.animatePosition=new THREE.Vector3,this.animateQuaternion=new THREE.Quaternion,this.animateScale=new THREE.Vector3(1,1,1),this.updateMatrixWorld=THREE.SEA3D.Object3D.prototype.updateAnimateMatrix):(delete this.animateMatrix,delete this.animatePosition,delete this.animateQuaternion,delete this.animateScale,this.updateMatrixWorld=THREE.Object3D.prototype.updateMatrixWorld),this.matrixWorldNeedsUpdate=!0)},THREE.SEA3D.Object3D.prototype.getAnimateMatrix=function(){return void 0!=this.animateMatrix},THREE.SEA3D.Dummy=function(width,height,depth){this.width=void 0!=width?width:100,this.height=void 0!=height?height:100,this.depth=void 0!=depth?depth:100;var geo=new THREE.BoxGeometry(this.width,this.height,this.depth,1,1,1);THREE.Mesh.call(this,geo,THREE.SEA3D.Dummy.MATERIAL)},THREE.SEA3D.Dummy.prototype=Object.create(THREE.Mesh.prototype),THREE.SEA3D.Dummy.prototype.constructor=THREE.Dummy,THREE.SEA3D.Dummy.prototype.setAnimateMatrix=THREE.SEA3D.Object3D.prototype.setAnimateMatrix,THREE.SEA3D.Dummy.prototype.getAnimateMatrix=THREE.SEA3D.Object3D.prototype.getAnimateMatrix,THREE.SEA3D.Dummy.MATERIAL=new THREE.MeshBasicMaterial({wireframe:!0,color:THREE.SEA3D.HELPER_COLOR}),THREE.SEA3D.Dummy.prototype.clone=function(object){return new this.constructor(this.width,this.height,this.depth).copy(this)},THREE.SEA3D.Dummy.prototype.dispose=function(){this.geometry.dispose()},THREE.SEA3D.Mesh=function(geometry,material){THREE.Mesh.call(this,geometry,material)},THREE.SEA3D.Mesh.prototype=Object.create(THREE.Mesh.prototype),THREE.SEA3D.Mesh.prototype.constructor=THREE.Mesh,THREE.SEA3D.Mesh.prototype.setAnimateMatrix=THREE.SEA3D.Object3D.prototype.setAnimateMatrix,THREE.SEA3D.Mesh.prototype.getAnimateMatrix=THREE.SEA3D.Object3D.prototype.getAnimateMatrix,THREE.SEA3D.Mesh.prototype.setWeight=function(name,val){this.morphTargetInfluences[this.morphTargetDictionary[name]]=val},THREE.SEA3D.Mesh.prototype.getWeight=function(name){return this.morphTargetInfluences[this.morphTargetDictionary[name]]},THREE.SEA3D.Mesh.prototype.copy=function(source){return THREE.Mesh.prototype.copy.call(this,source),this.animation&&(this.animation=source.animation.clone(this)),this},THREE.SEA3D.Mesh.prototype.clone=function(object){return new this.constructor(this.geometry,this.material).copy(this)},THREE.SEA3D.SkinnedMesh=function(geometry,material,useVertexTexture){THREE.SkinnedMesh.call(this,geometry,material,useVertexTexture)},THREE.SEA3D.SkinnedMesh.prototype=Object.create(THREE.SkinnedMesh.prototype),THREE.SEA3D.SkinnedMesh.prototype.constructor=THREE.SEA3D.SkinnedMesh,THREE.SEA3D.SkinnedMesh.prototype.setAnimateMatrix=THREE.SEA3D.Object3D.prototype.setAnimateMatrix,THREE.SEA3D.SkinnedMesh.prototype.getAnimateMatrix=THREE.SEA3D.Object3D.prototype.getAnimateMatrix,THREE.SEA3D.SkinnedMesh.prototype.setWeight=THREE.SEA3D.Mesh.prototype.setWeight,THREE.SEA3D.SkinnedMesh.prototype.getWeight=THREE.SEA3D.Mesh.prototype.getWeight,THREE.SEA3D.SkinnedMesh.prototype.isPlaying=!1,THREE.SEA3D.SkinnedMesh.prototype.stop=function(){this.currentAnimation&&(this.currentAnimation.stop(),delete this.currentAnimation,this.isPlaying=!1)},THREE.SEA3D.SkinnedMesh.prototype.pause=function(){this.isPlaying&&(this.currentAnimation.pause(),this.isPlaying=!1)},THREE.SEA3D.SkinnedMesh.prototype.resume=function(){!this.isPlaying&&this.currentAnimation&&(this.currentAnimation.pause(),this.isPlaying=!0)},THREE.SEA3D.SkinnedMesh.prototype.play=function(name,crossfade,offset){var animation=this.animations[name];if(!animation)throw new Error('Animation "'+name+'" not found.');animation.play(void 0!==offset?offset:animation.currentTime,animation.weight),this.currentAnimation=animation,this.isPlaying=!0,THREE.SEA3D.AnimationHandler.addCrossfade(this,void 0!==crossfade?crossfade:0)},THREE.SEA3D.SkinnedMesh.prototype.setAnimations=function(animations){var nsIndex=animations[0].name.indexOf("/")+1;this.animations=[],this.easeSpeed=2,this.blendMethod=SEA3D.AnimationBlendMethod.LINEAR,this.animationNamespace=animations[0].name.substring(0,nsIndex);for(var i=0;i<animations.length;i++){var ns=animations[i].name,name=ns.substring(nsIndex);this.animations[i]=new THREE.SEA3D.Animation(this,animations[i]),this.animations[i].loop=animations[i].repeat,this.animations[i].name=name,this.animations[name]=this.animations[i]}},THREE.SEA3D.SkinnedMesh.prototype.boneByName=function(name){for(var bones=this.skeleton.bones,i=0,bl=bones.length;bl>i;i++)if(name==bones[i].name)return bones[i]},THREE.SEA3D.SkinnedMesh.prototype.copy=function(source){return THREE.SkinnedMesh.prototype.copy.call(this,source),this.animation&&(this.animation=source.animation.clone(this)),this.geometry.animations&&this.setAnimations(this.geometry.animations),this},THREE.SEA3D.SkinnedMesh.prototype.clone=function(object){return new this.constructor(this.geometry,this.material,this.useVertexTexture).copy(this)},THREE.SEA3D.VertexAnimationMesh=function(geometry,material,fps){THREE.MorphAnimMesh.call(this,geometry,material),this.fps=void 0!==fps?fps:30,this.animations=geometry.animations,this.isPlaying=!1,this.totalTime=0,this.playingCallback=this.updateAnimation.bind(this)},THREE.SEA3D.VertexAnimationMesh.prototype=Object.create(THREE.MorphAnimMesh.prototype),THREE.SEA3D.VertexAnimationMesh.prototype.constructor=THREE.SEA3D.VertexAnimationMesh,THREE.SEA3D.VertexAnimationMesh.prototype.setAnimateMatrix=THREE.SEA3D.Object3D.prototype.setAnimateMatrix,THREE.SEA3D.VertexAnimationMesh.prototype.getAnimateMatrix=THREE.SEA3D.Object3D.prototype.getAnimateMatrix,THREE.SEA3D.VertexAnimationMesh.prototype.play=function(name,offset){var animation=this.animations[name];this.setFrameRange(animation.start?animation.start:1,animation.end-1),this.duration=(animation.end-animation.start)/this.fps,this.time=void 0!==offset?offset:this.time,this.resume()},THREE.SEA3D.VertexAnimationMesh.prototype.pause=function(){this.isPlaying&&(this.isPlaying=!1,THREE.SEA3D.AnimationHandler.removeUpdate(this.playingCallback))},THREE.SEA3D.VertexAnimationMesh.prototype.resume=function(){this.isPlaying||(this.isPlaying=!0,THREE.SEA3D.AnimationHandler.addUpdate(this.playingCallback))},THREE.SEA3D.VertexAnimationMesh.prototype.stop=function(){this.pause(),this.time=0},THREE.SEA3D.VertexAnimationMesh.prototype.clone=function(object){return new this.constructor(this.geometry,this.material,this.fps).copy(this)},THREE.SEA3D.Camera=function(fov,aspect,near,far){THREE.PerspectiveCamera.call(this,fov,aspect,near,far)},THREE.SEA3D.Camera.prototype=Object.create(THREE.PerspectiveCamera.prototype),THREE.SEA3D.Camera.prototype.constructor=THREE.SEA3D.Camera,THREE.SEA3D.Camera.prototype.setAnimateMatrix=THREE.SEA3D.Object3D.prototype.setAnimateMatrix,THREE.SEA3D.Camera.prototype.getAnimateMatrix=THREE.SEA3D.Object3D.prototype.getAnimateMatrix,THREE.SEA3D.Camera.prototype.copy=function(source){return THREE.PerspectiveCamera.prototype.copy.call(this,source),this},THREE.SEA3D.AnimationHandler={crossfade:[],updates:[],update:function(dt){var i,cf=THREE.SEA3D.AnimationHandler.crossfade,ups=THREE.SEA3D.AnimationHandler.updates;
for(i=0;i<cf.length;){var mesh=cf[i],len=mesh.animations.length,weight=1,delta=Math.abs(dt)/mesh.crossfade;for(mesh.blendMethod===SEA3D.AnimationBlendMethod.EASING&&(delta*=mesh.easeSpeed);len;){var state=mesh.animations[--len];state.weight>0&&state!=mesh.currentAnimation&&(mesh.blendMethod===SEA3D.AnimationBlendMethod.LINEAR?state.weight-=delta:mesh.blendMethod===SEA3D.AnimationBlendMethod.EASING&&(state.weight-=state.weight*delta),state.weight<0&&(state.weight=0),weight-=state.weight)}0>weight&&(weight=0),mesh.currentAnimation.weight=weight,1==weight?(cf.splice(i,1),delete mesh.crossfade,mesh.onCrossfadeComplete&&mesh.onCrossfadeComplete(mesh)):++i}for(i=0;i<ups.length;)ups[i++](dt);SEA3D.AnimationHandler.update(dt)},addCrossfade:function(mesh,crossfade){var fadelist=THREE.SEA3D.AnimationHandler.crossfade;if(crossfade>0)mesh.crossfade||fadelist.push(mesh),mesh.crossfade=crossfade;else{for(var len=mesh.animations.length;len;)mesh.animations[--len].weight=0;mesh.crossfade&&(fadelist.splice(fadelist.indexOf(mesh),1),delete mesh.crossfade,mesh.onCrossfadeComplete&&mesh.onCrossfadeComplete(mesh)),mesh.currentAnimation.weight=1}},addUpdate:function(func){THREE.SEA3D.AnimationHandler.updates.push(func)},removeUpdate:function(func){var index=THREE.SEA3D.AnimationHandler.updates.indexOf(func);-1!==index&&THREE.SEA3D.AnimationHandler.updates.splice(THREE.SEA3D.AnimationHandler.updates.indexOf(func),1)}},THREE.SEA3D.Animation=function(root,data){THREE.Animation.call(this,root,data)},THREE.SEA3D.Animation.prototype=Object.create(THREE.Animation.prototype),THREE.SEA3D.Animation.prototype.constructor=THREE.SEA3D.Animation,THREE.SEA3D.Animation.prototype.stop=function(){this.onComplete&&this.onComplete(this),THREE.Animation.prototype.stop.call(this)},THREE.SEA3D.Animation.prototype.reset=function(){this.onReset&&this.onReset(this),THREE.Animation.prototype.reset.call(this)},THREE.SEA3D.MTXBUF=new THREE.Matrix4,THREE.SEA3D.VECBUF=new THREE.Vector3,THREE.SEA3D.QUABUF=new THREE.Quaternion,THREE.SEA3D.prototype.setShadowMap=function(light,opacity){light.shadowMapWidth=light.shadowMapHeight=2048,light.castShadow=!0,light.shadowDarkness=void 0==opacity?1:opacity},THREE.SEA3D.prototype.getMesh=function(name){return this.objects["m3d/"+name]},THREE.SEA3D.prototype.getDummy=function(name){return this.objects["dmy/"+name]},THREE.SEA3D.prototype.getLine=function(name){return this.objects["line/"+name]},THREE.SEA3D.prototype.getSound3D=function(name){return this.objects["sn3d/"+name]},THREE.SEA3D.prototype.getMaterial=function(name){return this.objects["mat/"+name]},THREE.SEA3D.prototype.getLight=function(name){return this.objects["lht/"+name]},THREE.SEA3D.prototype.getGLSL=function(name){return this.objects["glsl/"+name]},THREE.SEA3D.prototype.getCamera=function(name){return this.objects["cam/"+name]},THREE.SEA3D.prototype.getTexture=function(name){return this.objects["tex/"+name]},THREE.SEA3D.prototype.getCubeMap=function(name){return this.objects["cmap/"+name]},THREE.SEA3D.prototype.getJointObject=function(name){return this.objects["jnt/"+name]},THREE.SEA3D.prototype.getContainer3D=function(name){return this.objects["c3d/"+name]},THREE.SEA3D.prototype.getSprite=function(name){return this.objects["m2d/"+name]},THREE.SEA3D.prototype.getProperty=function(name){return this.objects["prop/"+name]},THREE.SEA3D.prototype.isPowerOfTwo=function(num){return num?(num&-num)==num:!1},THREE.SEA3D.prototype.nearestPowerOfTwo=function(num){return Math.pow(2,Math.round(Math.log(num)/Math.LN2))},THREE.SEA3D.prototype.updateTransform=function(obj3d,sea){var mtx=THREE.SEA3D.MTXBUF,vec=THREE.SEA3D.VECBUF;sea.transform?mtx.elements.set(sea.transform):mtx.makeTranslation(sea.position.x,sea.position.y,sea.position.z),obj3d.position.setFromMatrixPosition(mtx),obj3d.scale.setFromMatrixScale(mtx),mtx.scale(vec.set(1/obj3d.scale.x,1/obj3d.scale.y,1/obj3d.scale.z)),obj3d.rotation.setFromRotationMatrix(mtx),sea.isStatic&&(obj3d.updateMatrixWorld(),obj3d.matrixAutoUpdate=!1)},THREE.SEA3D.prototype.toVector3=function(data){return new THREE.Vector3(data.x,data.y,data.z)},THREE.SEA3D.prototype.scaleColor=function(color,scale){var r=(color>>16)*scale,g=(color>>8&255)*scale,b=(255&color)*scale;return r<<16|g<<8|b},THREE.SEA3D.prototype.updateScene=function(){if(void 0!=this.materials)for(var i=0,l=this.materials.length;l>i;++i)this.materials[i].needsUpdate=!0},THREE.SEA3D.prototype.addSceneObject=function(sea){var obj3d=sea.tag;obj3d.userData=sea.properties,this.config.script&&sea.scripts&&this.runJSMList(obj3d,sea.scripts),sea.parent?sea.parent.tag.add(obj3d):this.config.container&&this.config.container.add(obj3d),obj3d.visible=sea.visible},THREE.SEA3D.prototype.createObjectURL=function(raw,mime){return(window.URL||window.webkitURL).createObjectURL(new Blob([raw],{type:mime}))},THREE.SEA3D.prototype.bufferToTexture=function(raw){return this.createObjectURL(raw,"image")},THREE.SEA3D.prototype.bufferToSound=function(raw){return this.createObjectURL(raw,"audio")},THREE.SEA3D.prototype.applyDefaultAnimation=function(sea,animatorClass){for(var obj=sea.tag,i=0,count=sea.animations?sea.animations.length:0;count>i;i++){var anm=sea.animations[i];switch(anm.tag.type){case SEA3D.Animation.prototype.type:return obj.animation=new animatorClass(obj,anm.tag.tag),obj.animation.setRelative(anm.relative),this.config.autoPlay&&obj.animation.play(obj.animation.getStateNameByIndex(0)),obj.animation}}},THREE.SEA3D.prototype.readAnimation=function(sea){for(var anmSet=new SEA3D.AnimationSet,i=0;i<sea.sequence.length;i++){for(var seq=sea.sequence[i],node=new SEA3D.AnimationNode(seq.name,sea.frameRate,seq.count,seq.repeat,seq.intrpl),j=0;j<sea.dataList.length;j++){var anmData=sea.dataList[j];node.addData(new SEA3D.AnimationData(anmData.kind,anmData.type,anmData.data,seq.start*anmData.blockSize))}anmSet.addAnimation(node)}this.domain.animationSets=this.animationSets=this.animationSets||[],this.animationSets.push(this.objects[sea.name+".#anm"]=sea.tag=anmSet)},THREE.SEA3D.Object3DAnimator=function(object3d,animationSet){SEA3D.AnimationHandler.call(this,animationSet),this.object3d=object3d},THREE.SEA3D.Object3DAnimator.prototype=Object.create(SEA3D.AnimationHandler.prototype),THREE.SEA3D.Object3DAnimator.prototype.constructor=THREE.SEA3D.Object3DAnimator,THREE.SEA3D.Object3DAnimator.prototype.stop=function(){this.relative&&(this.object3d.animatePosition=new THREE.Vector3,this.object3d.animateQuaternion=new THREE.Quaternion,this.object3d.animateScale=new THREE.Vector3(1,1,1)),SEA3D.AnimationHandler.prototype.stop.call(this)},THREE.SEA3D.Object3DAnimator.prototype.setRelative=function(val){this.object3d.setAnimateMatrix(this.relative=val)},THREE.SEA3D.Object3DAnimator.prototype.updateAnimationFrame=function(frame,kind){if(this.relative){switch(kind){case SEA3D.Animation.POSITION:var v=frame.toVector();this.object3d.animatePosition.set(v.x,v.y,v.z);break;case SEA3D.Animation.ROTATION:var v=frame.toVector();this.object3d.animateQuaternion.set(v.x,v.y,v.z,v.w);break;case SEA3D.Animation.SCALE:var v=frame.toVector();this.object3d.animateScale.set(v.x,v.y,v.z)}this.object3d.matrixWorldNeedsUpdate=!0}else switch(kind){case SEA3D.Animation.POSITION:var v=frame.toVector();this.object3d.position.set(v.x,v.y,v.z);break;case SEA3D.Animation.ROTATION:var v=frame.toVector();this.object3d.quaternion.set(v.x,v.y,v.z,v.w);break;case SEA3D.Animation.SCALE:var v=frame.toVector();this.object3d.scale.set(v.x,v.y,v.z)}},THREE.SEA3D.CameraAnimator=function(object3d,animationSet){THREE.SEA3D.Object3DAnimator.call(this,object3d,animationSet)},THREE.SEA3D.CameraAnimator.prototype=Object.create(THREE.SEA3D.Object3DAnimator.prototype),THREE.SEA3D.CameraAnimator.prototype.constructor=THREE.SEA3D.Object3DAnimator,THREE.SEA3D.CameraAnimator.prototype.updateAnimationFrame=function(frame,kind){switch(kind){case SEA3D.Animation.FOV:this.object3d.fov=frame.getX();break;default:THREE.SEA3D.Object3DAnimator.prototype.updateAnimationFrame.call(this,frame,kind)}},THREE.SEA3D.LightAnimator=function(object3d,animationSet){THREE.SEA3D.Object3DAnimator.call(this,object3d,animationSet)},THREE.SEA3D.LightAnimator.prototype=Object.create(THREE.SEA3D.Object3DAnimator.prototype),THREE.SEA3D.LightAnimator.prototype.constructor=THREE.SEA3D.Object3DAnimator,THREE.SEA3D.LightAnimator.prototype.updateAnimationFrame=function(frame,kind){switch(kind){case SEA3D.Animation.COLOR:this.object3d.color.setHex(frame.getX());break;case SEA3D.Animation.MULTIPLIER:this.object3d.intensity=frame.getX();break;default:THREE.SEA3D.Object3DAnimator.prototype.updateAnimationFrame.call(this,frame,kind)}},THREE.SEA3D.prototype.readGeometryBuffer=function(sea){for(var geo=new THREE.BufferGeometry,i=0;i<sea.groups.length;i++){var g=sea.groups[i];geo.addGroup(g.start,g.count,i)}geo.setIndex(new THREE.BufferAttribute(sea.indexes,1)),geo.addAttribute("position",new THREE.BufferAttribute(sea.vertex,3)),sea.uv&&(geo.addAttribute("uv",new THREE.BufferAttribute(sea.uv[0],2)),sea.uv.length>1&&geo.addAttribute("uv2",new THREE.BufferAttribute(sea.uv[1],2))),sea.normal?geo.addAttribute("normal",new THREE.BufferAttribute(sea.normal,3)):geo.computeVertexNormals(),sea.tangent4&&geo.addAttribute("tangent",new THREE.BufferAttribute(sea.tangent4,4)),sea.color&&geo.addAttribute("color",new THREE.BufferAttribute(sea.color[0],sea.numColor)),sea.joint&&(geo.addAttribute("skinIndex",new THREE.Float32Attribute(sea.joint,sea.jointPerVertex)),geo.addAttribute("skinWeight",new THREE.Float32Attribute(sea.weight,sea.jointPerVertex))),this.config.bounding&&(geo.computeBoundingBox(),geo.computeBoundingSphere()),geo.name=sea.name,this.domain.geometries=this.geometries=this.geometries||[],this.geometries.push(this.objects["geo/"+sea.name]=sea.tag=geo)},THREE.SEA3D.prototype.readDummy=function(sea){var dummy=new THREE.SEA3D.Dummy(sea.width,sea.height,sea.depth);dummy.name=sea.name,this.domain.dummys=this.dummys=this.dummys||[],this.dummys.push(this.objects["dmy/"+sea.name]=sea.tag=dummy),this.addSceneObject(sea),this.updateTransform(dummy,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.Object3DAnimator)},THREE.SEA3D.prototype.readLine=function(sea){var geo=new THREE.BufferGeometry;sea.closed&&sea.vertex.push(sea.vertex[0],sea.vertex[1],sea.vertex[2]),geo.addAttribute("position",new THREE.BufferAttribute(new Float32Array(sea.vertex),3));var line=new THREE.Line(geo,new THREE.LineBasicMaterial({color:THREE.SEA3D.HELPER_COLOR,linewidth:3}));line.name=sea.name,this.lines=this.lines||[],this.lines.push(this.objects["line/"+sea.name]=sea.tag=line),this.addSceneObject(sea),this.updateTransform(line,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.Object3DAnimator)},THREE.SEA3D.prototype.readContainer3D=function(sea){var container=new THREE.SEA3D.Object3D;this.domain.containers=this.containers=this.containers||[],this.containers.push(this.objects["c3d/"+sea.name]=sea.tag=container),this.addSceneObject(sea),this.updateTransform(container,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.Object3DAnimator)},THREE.SEA3D.prototype.readMesh2D=function(sea){var material;sea.material&&(sea.material.tag.sprite?material=sea.material.tag.sprite:(material=sea.material.tag.sprite=new THREE.SpriteMaterial,material.map=sea.material.tag.map,material.map.flipY=!0,material.color=sea.material.tag.emissive,material.opacity=sea.material.tag.opacity,material.blending=sea.material.tag.blending));var sprite=new THREE.Sprite(material);sprite.name=sea.name,this.domain.sprites=this.sprites=this.sprites||[],this.sprites.push(this.objects["m2d/"+sea.name]=sea.tag=sprite),this.addSceneObject(sea),this.updateTransform(sprite,sea),sprite.scale.set(sea.width,sea.height,1)},THREE.SEA3D.prototype.readMesh=function(sea){var i,count,mesh,mat,skeleton,skeletonAnimation,vertexAnimation,morpher,geo=sea.geometry.tag;for(i=0,count=sea.modifiers?sea.modifiers.length:0;count>i;i++){var mod=sea.modifiers[i];switch(mod.type){case SEA3D.Skeleton.prototype.type:case SEA3D.SkeletonLocal.prototype.type:skeleton=mod,geo.bones=skeleton.tag;break;case SEA3D.Morph.prototype.type:morpher=mod,geo.morphAttributes=morpher.tag.attribs,geo.morphTargets=morpher.tag.targets}}for(i=0,count=sea.animations?sea.animations.length:0;count>i;i++){var anm=sea.animations[i];switch(anm.tag.type){case SEA3D.SkeletonAnimation.prototype.type:skeletonAnimation=anm.tag,geo.animations=this.getSkeletonAnimation(skeletonAnimation,skeleton);break;case SEA3D.VertexAnimation.prototype.type:vertexAnimation=anm.tag,geo.morphAttributes=vertexAnimation.tag.attribs,geo.morphTargets=vertexAnimation.tag.targets,geo.animations=vertexAnimation.tag.animations}}var uMorph=void 0!=morpher||void 0!=vertexAnimation,uMorphNormal=morpher&&void 0!=morpher.tag.attribs.normal||vertexAnimation&&void 0!=vertexAnimation.tag.attribs.normal;if(sea.material)if(sea.material.length>1){var mats=[];for(i=0;i<sea.material.length;i++)mats[i]=sea.material[i].tag,mats[i].skinning=void 0!=skeleton,mats[i].morphTargets=uMorph,mats[i].morphNormals=uMorphNormal,mats[i].vertexColors=sea.geometry.color?THREE.VertexColors:THREE.NoColors;mat=new THREE.MultiMaterial(mats)}else mat=sea.material[0].tag,mat.skinning=void 0!=skeleton,mat.morphTargets=uMorph,mat.morphNormals=uMorphNormal,mat.vertexColors=sea.geometry.color?THREE.VertexColors:THREE.NoColors;skeleton?(mesh=new THREE.SEA3D.SkinnedMesh(geo,mat,this.config.useVertexTexture),skeletonAnimation&&(mesh.setAnimations(geo.animations),this.config.autoPlay&&mesh.play(mesh.animations[0].name))):vertexAnimation?(mesh=new THREE.SEA3D.VertexAnimationMesh(geo,mat,vertexAnimation.frameRate),this.config.autoPlay&&mesh.play(mesh.animations[0].name)):mesh=new THREE.SEA3D.Mesh(geo,mat),mesh.name=sea.name,mesh.castShadow=sea.castShadows,mesh.receiveShadow=sea.material?sea.material[0].receiveShadows:!0,this.domain.meshes=this.meshes=this.meshes||[],this.meshes.push(this.objects["m3d/"+sea.name]=sea.tag=mesh),this.addSceneObject(sea),this.updateTransform(mesh,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.Object3DAnimator)},THREE.SEA3D.prototype.readSoundPoint=function(sea){this.audioListener||(this.audioListener=new THREE.AudioListener,this.config.container&&this.config.container.add(this.audioListener));var sound3d=new THREE.PositionalAudio(this.audioListener);sound3d.load(sea.sound.tag),sound3d.autoplay=sea.autoPlay,sound3d.setLoop(sea.autoPlay),sound3d.setVolume(sea.volume),sound3d.setRefDistance(sea.distance),sound3d.setRolloffFactor(this.config.audioRolloffFactor),sound3d.name=sea.name,this.domain.sounds3d=this.sounds3d=this.sounds3d||[],this.sounds3d.push(this.objects["sn3d/"+sea.name]=sea.tag=sound3d),this.addSceneObject(sea),this.updateTransform(sound3d,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.Object3DAnimator)},THREE.SEA3D.prototype.readCubeRender=function(sea){var cube=new THREE.CubeCamera(.1,5e3,THREE.SEA3D.RTT_SIZE);cube.renderTarget.cubeCamera=cube,this.domain.cubeRenderers=this.cubeRenderers=this.cubeRenderers||[],this.cubeRenderers.push(this.objects["rttc/"+sea.name]=sea.tag=cube.renderTarget),this.addSceneObject(sea),this.updateTransform(cube,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.Object3DAnimator)},THREE.SEA3D.prototype.readImage=function(sea){var image=new Image,texture=new THREE.Texture;image.src=this.bufferToTexture(sea.data.buffer),texture.name=sea.name,texture.wrapS=texture.wrapT=THREE.RepeatWrapping,texture.flipY=!1,texture.image=image,texture.needsUpdate=!0,this.domain.textures=this.textures=this.textures||[],this.textures.push(this.objects["tex/"+sea.name]=sea.tag=texture)},THREE.SEA3D.prototype.readCubeMap=function(sea){var images=[],texture=new THREE.Texture,faces=[];faces[0]=sea.faces[1],faces[1]=sea.faces[0],faces[2]=sea.faces[3],faces[3]=sea.faces[2],faces[4]=sea.faces[5],faces[5]=sea.faces[4],images.loadedCount=0,texture.name=sea.name,texture.image=images,texture.flipY=!1;for(var i=0,il=faces.length;il>i;++i){var cubeImage=new Image;images[i]=cubeImage,cubeImage.onload=function(){6==++images.loadedCount&&(texture.needsUpdate=!0)},cubeImage.src=this.bufferToTexture(faces[i].buffer)}this.domain.cubemaps=this.cubemaps=this.cubemaps||[],this.cubemaps.push(this.objects["cmap/"+sea.name]=sea.tag=texture)},THREE.SEA3D.prototype.readSound=function(sea){var sound=this.bufferToSound(sea.data.buffer);this.domain.sounds=this.sounds=this.sounds||[],this.sounds.push(this.objects["snd/"+sea.name]=sea.tag=sound)},THREE.SEA3D.prototype.readTextureURL=function(sea){var texture=(new THREE.TextureLoader).load(sea.url);texture.name=sea.name,texture.wrapS=texture.wrapT=THREE.RepeatWrapping,texture.flipY=!1,this.domain.textures=this.textures=this.textures||[],this.textures.push(this.objects["tex/"+sea.name]=sea.tag=texture)},THREE.SEA3D.SCRIPT=new SEA3D.ScriptManager,THREE.SEA3D.SCRIPT.dispatchUpdate=function(delta){this.dispatchEvent({type:"update",delta:delta})},THREE.SEA3D.Domain=function(id,objects,container,extensions){SEA3D.Domain.call(this,id),this.objects=objects,this.container=container,this.extensions=extensions||[]},THREE.SEA3D.Domain.prototype=Object.create(SEA3D.Domain.prototype),THREE.SEA3D.Domain.prototype.constructor=THREE.SEA3D.Domain,THREE.SEA3D.Domain.prototype.disposeExtensions=function(){extensions=extensions.concat();for(var i=list.length;i--;)list[i].dispose()},THREE.SEA3D.Domain.prototype.disposeList=function(list){if(list&&list.length){list=list.concat();for(var i=list.length;i--;)list[i].dispose()}},THREE.SEA3D.Domain.prototype.dispose=function(){for(SEA3D.Domain.prototype.dispose.call(this);this.container.children.length;)this.container.remove(this.container.children[0]);for(var i=this.extensions.length;i--;)this.extensions[i].dispose.call(this);this.disposeList(this.materials),this.disposeList(this.dummys)},SEA3D.Domain.prototype.getMesh=THREE.SEA3D.prototype.getMesh,SEA3D.Domain.prototype.getDummy=THREE.SEA3D.prototype.getDummy,SEA3D.Domain.prototype.getLine=THREE.SEA3D.prototype.getLine,SEA3D.Domain.prototype.getSound3D=THREE.SEA3D.prototype.getSound3D,SEA3D.Domain.prototype.getMaterial=THREE.SEA3D.prototype.getMaterial,SEA3D.Domain.prototype.getLight=THREE.SEA3D.prototype.getLight,SEA3D.Domain.prototype.getGLSL=THREE.SEA3D.prototype.getGLSL,SEA3D.Domain.prototype.getCamera=THREE.SEA3D.prototype.getCamera,SEA3D.Domain.prototype.getTexture=THREE.SEA3D.prototype.getTexture,SEA3D.Domain.prototype.getCubeMap=THREE.SEA3D.prototype.getCubeMap,SEA3D.Domain.prototype.getJointObject=THREE.SEA3D.prototype.getJointObject,SEA3D.Domain.prototype.getContainer3D=THREE.SEA3D.prototype.getContainer3D,SEA3D.Domain.prototype.getSprite=THREE.SEA3D.prototype.getSprite,SEA3D.Domain.prototype.getProperty=THREE.SEA3D.prototype.getProperty,THREE.SEA3D.DomainManager=function(autoDisposeRootDomain){SEA3D.DomainManager.call(this,autoDisposeRootDomain)},THREE.SEA3D.DomainManager.prototype=Object.create(SEA3D.DomainManager.prototype),THREE.SEA3D.DomainManager.prototype.constructor=THREE.SEA3D.DomainManager,THREE.SEA3D.DomainManager.prototype.add=function(domain){SEA3D.DomainManager.prototype.add.call(this,domain),this.textures=this.textures||domain.textures,this.cubemaps=this.cubemaps||domain.cubemaps,this.geometries=this.geometries||domain.geometries},THREE.SEA3D.DomainManager.prototype.disposeList=THREE.SEA3D.Domain.prototype.disposeList,THREE.SEA3D.DomainManager.prototype.dispose=function(){SEA3D.DomainManager.prototype.dispose.call(this),this.disposeList(this.textures),this.disposeList(this.cubemaps),this.disposeList(this.geometries)},THREE.SEA3D.prototype.runJSMList=function(target,scripts,root){for(var i=0;i<scripts.length;i++){var script=scripts[i];script.tag.type==SEA3D.JavaScriptMethod.prototype.type&&this.runJSM(target,script,root)}},THREE.SEA3D.prototype.runJSM=function(target,script,root){void 0==target.local&&(target.local={});var include={print:this.domain.print,watch:this.domain.watch,sea3d:this.domain,scene:this.config.container,source:new SEA3D.Script(this.domain,1==root)};Object.freeze(include.source),THREE.SEA3D.SCRIPT.add(include.source);try{this.script[script.method](include,this.domain.getReference,this.domain.global,target.local,target,script.params)}catch(e){console.error('SEA3D JavaScript: Error running method "'+script.method+'".'),console.error(e)}},THREE.SEA3D.prototype.readJavaScriptMethod=function(sea){try{var src="(function() {\nvar $METHOD = {}\n",declare='function($INC, $REF, global, local, $his, $PARAM) {\nvar watch = $INC["watch"],\nscene = $INC["scene"],\nsea3d = $INC["sea3d"],\nprint = $INC["print"];\n';declare+='var $SRC = $INC["source"],\naddEvent = $SRC.addEvent.bind( $SRC ),\nhasEvent = $SRC.hasEvent.bind( $SRC ),\ndispatchEvent = $SRC.dispatchEvent.bind( $SRC ),\nremoveEvent = $SRC.removeEvent.bind( $SRC ),\ndispose = $SRC.dispose.bind( $SRC );\n';for(var name in sea.methods)src+='$METHOD["'+name+'"] = '+declare+sea.methods[name].src+"}\n";src+="return $METHOD; })",this.script=eval(src)()}catch(e){console.error('SEA3D JavaScriptMethod: Error running "'+sea.name+'".'),console.error(e)}},THREE.SEA3D.prototype.readGLSL=function(sea){this.domain.glsl=this.glsl=this.glsl||[],this.glsl.push(this.objects["glsl/"+sea.name]=sea.tag=sea.src)},THREE.SEA3D.prototype.blendMode={normal:THREE.NormalBlending,add:THREE.AdditiveBlending,subtract:THREE.SubtractiveBlending,multiply:THREE.MultiplyBlending,screen:THREE.AdditiveBlending},THREE.SEA3D.prototype.materialTechnique=function(){var techniques={};return techniques[SEA3D.Material.DEFAULT]=function(tech,mat){mat.emissive.setHex(tech.ambientColor),mat.color.setHex(tech.diffuseColor),mat.specular.setHex(this.scaleColor(tech.specularColor,tech.specular)),mat.shininess=tech.gloss},techniques[SEA3D.Material.DIFFUSE_MAP]=function(tech,mat){mat.map=tech.texture.tag,mat.transparent=tech.texture.transparent,mat.color.setHex(16777215)},techniques[SEA3D.Material.SPECULAR_MAP]=function(tech,mat){mat.specularMap=tech.texture.tag},techniques[SEA3D.Material.NORMAL_MAP]=function(tech,mat){mat.normalMap=tech.texture.tag},techniques[SEA3D.Material.REFLECTION]=techniques[SEA3D.Material.FRESNEL_REFLECTION]=function(tech,mat){mat.envMap=tech.texture.tag,mat.envMap.mapping=THREE.CubeReflectionMapping,mat.combine=THREE.MixOperation,mat.reflectivity=tech.alpha},techniques[SEA3D.Material.REFLECTION_SPHERICAL]=function(tech,mat){mat.envMap=tech.texture.tag,mat.envMap.mapping=THREE.SphericalReflectionMapping,mat.combine=THREE.MixOperation,mat.reflectivity=tech.alpha},techniques[SEA3D.Material.REFRACTION_MAP]=function(tech,mat){mat.envMap=tech.texture.tag,mat.envMap.mapping=THREE.CubeRefractionMapping(),mat.refractionRatio=tech.ior,mat.reflectivity=tech.alpha},techniques[SEA3D.Material.LIGHT_MAP]=function(tech,mat){"multiply"==tech.blendMode?mat.aoMap=tech.texture.tag:mat.lightMap=tech.texture.tag,mat.lightMapUV=tech.channel},techniques}(),THREE.SEA3D.prototype.readMaterial=function(sea){var mat=this.config.standardMaterial?new THREE.SEA3D.StandardMaterial:new THREE.MeshPhongMaterial;mat.emissiveToAmbientColor=this.config.ambientColor,mat.name=sea.name,mat.side=sea.bothSides?THREE.DoubleSide:THREE.FrontSide,mat.shading=sea.smooth?THREE.SmoothShading:THREE.FlatShading,"normal"!=sea.blendMode&&this.blendMode[sea.blendMode]&&(mat.blending=this.blendMode[sea.blendMode]),(sea.alpha<1||mat.blending>THREE.NormalBlending)&&(mat.opacity=sea.alpha,mat.transparent=!0);for(var i=0;i<sea.technique.length;i++){var tech=sea.technique[i];this.materialTechnique[tech.kind]&&this.materialTechnique[tech.kind].call(this,tech,mat)}mat.transparent&&(mat.alphaTest=sea.alphaThreshold),this.domain.materials=this.materials=this.materials||[],this.materials.push(this.objects["mat/"+sea.name]=sea.tag=mat)},THREE.SEA3D.prototype.readPointLight=function(sea){var light=new THREE.PointLight(sea.color,sea.multiplier*this.config.multiplier);light.name=sea.name,sea.attenuation&&(light.distance=sea.attenuation.end),sea.shadow&&this.setShadowMap(light,sea.shadow.opacity),this.domain.lights=this.lights=this.lights||[],this.lights.push(this.objects["lht/"+sea.name]=sea.tag=light),this.config.lights&&this.addSceneObject(sea),this.updateTransform(light,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.LightAnimator),this.updateScene()},THREE.SEA3D.prototype.readHemisphereLight=function(sea){var light=new THREE.HemisphereLight(sea.color,sea.secondColor,sea.multiplier*this.config.multiplier);light.name=sea.name,this.domain.lights=this.lights=this.lights||[],this.lights.push(this.objects["lht/"+sea.name]=sea.tag=light),this.config.lights&&this.addSceneObject(sea),this.applyDefaultAnimation(sea,THREE.SEA3D.LightAnimator),this.updateScene()},THREE.SEA3D.prototype.readDirectionalLight=function(sea){var light=new THREE.DirectionalLight(sea.color,sea.multiplier*this.config.multiplier);light.name=sea.name,sea.shadow&&this.setShadowMap(light,sea.shadow.opacity),this.domain.lights=this.lights=this.lights||[],this.lights.push(this.objects["lht/"+sea.name]=sea.tag=light),this.config.lights&&this.addSceneObject(sea),this.updateTransform(light,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.LightAnimator),this.updateScene()},THREE.SEA3D.prototype.readCamera=function(sea){var camera=new THREE.SEA3D.Camera(sea.fov);camera.name=sea.name,this.domain.cameras=this.cameras=this.cameras||[],this.cameras.push(this.objects["cam/"+sea.name]=sea.tag=camera),this.addSceneObject(sea),this.updateTransform(camera,sea),this.applyDefaultAnimation(sea,THREE.SEA3D.CameraAnimator)},THREE.SEA3D.prototype.readSkeletonLocal=function(sea){for(var bones=[],i=0;i<sea.joint.length;i++){var bone=sea.joint[i];bones[i]={name:bone.name,pos:[bone.x,bone.y,bone.z],rotq:[bone.qx,bone.qy,bone.qz,bone.qw],parent:bone.parentIndex}}sea.tag=bones},THREE.SEA3D.prototype.readJointObject=function(sea){var mesh=sea.target.tag,bone=mesh.skeleton.bones[sea.joint];this.domain.joints=this.joints=this.joints||[],this.joints.push(this.objects["jnt/"+sea.name]=sea.tag=bone)},THREE.SEA3D.prototype.getSkeletonAnimation=function(sea,skl){if(sea.tag)return sea.tag;for(var animations=[],delta=1e3/sea.frameRate/1e3,i=0;i<sea.sequence.length;i++){for(var seq=sea.sequence[i],start=seq.start,end=start+seq.count,ns=sea.name+"/"+seq.name,animation={name:ns,repeat:seq.repeat,fps:sea.frameRate,JIT:0,length:delta*(seq.count-1),hierarchy:[]},numJoints=sea.numJoints,raw=sea.raw,j=0;numJoints>j;j++){for(var bone=skl.joint[j],node={parent:bone.parentIndex,keys:[]},keys=node.keys,time=0,frame=start;end>frame;frame++){var idx=frame*numJoints*7+7*j;keys.push({time:time,pos:[raw[idx],raw[idx+1],raw[idx+2]],rot:[raw[idx+3],raw[idx+4],raw[idx+5],raw[idx+6]],scl:[1,1,1]}),time+=delta}animation.hierarchy[j]=node}animations.push(animation)}return sea.tag=animations},THREE.SEA3D.prototype.readMorpher=function(sea){for(var attribs={position:[]},targets=[],i=0;i<sea.node.length;i++){var node=sea.node[i];attribs.position[i]=new THREE.Float32Attribute(new Float32Array(node.vertex),3),node.normal&&(attribs.normal=attribs.normal||[],attribs.normal[i]=new THREE.Float32Attribute(new Float32Array(node.normal),3)),targets[i]={name:node.name}}sea.tag={attribs:attribs,targets:targets}},THREE.SEA3D.prototype.readVertexAnimation=function(sea){for(var attribs={position:[]},targets=[],animations=[],i=0,l=sea.frame.length;l>i;i++){var frame=sea.frame[i];attribs.position[i]=new THREE.Float32Attribute(new Float32Array(frame.vertex),3),frame.normal&&(attribs.normal=attribs.normal||[],attribs.normal[i]=new THREE.Float32Attribute(new Float32Array(frame.normal),3)),targets[i]={name:i}}for(var i=0;i<sea.sequence.length;i++){var seq=sea.sequence[i];animations[i]=animations[seq.name]={name:seq.name,start:seq.start,end:seq.start+seq.count,repeat:seq.repeat}}sea.tag={attribs:attribs,targets:targets,animations:animations,frameRate:sea.frameRate}},THREE.SEA3D.prototype.readActions=function(sea){for(var i=0;i<sea.actions.length;i++){var act=sea.actions[i];switch(act.kind){case SEA3D.Actions.SCRIPTS:this.runJSMList(this.domain,act.scripts,!0)}}},THREE.SEA3D.Event={LOAD_PROGRESS:"sea3d_progress",DOWNLOAD_PROGRESS:"sea3d_download",COMPLETE:"sea3d_complete",OBJECT_COMPLETE:"sea3d_object",PARSE_PROGRESS:"parse_progress",PARSE_COMPLETE:"parse_complete",ERROR:"sea3d_error"},THREE.SEA3D.prototype.onProgress=void 0,THREE.SEA3D.prototype.onComplete=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.COMPLETE,args.file.dispatchEvent(args)},THREE.SEA3D.prototype.onLoadProgress=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.LOAD_PROGRESS,args.file.dispatchEvent(args),args.file.onProgress&&args.file.onProgress(args)},THREE.SEA3D.prototype.onDownloadProgress=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.DOWNLOAD_PROGRESS,args.file.dispatchEvent(args),args.file.onProgress&&args.file.onProgress(args)},THREE.SEA3D.prototype.onCompleteObject=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.OBJECT_COMPLETE,args.file.dispatchEvent(args)},THREE.SEA3D.prototype.onParseProgress=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.PARSE_PROGRESS,args.file.dispatchEvent(args)},THREE.SEA3D.prototype.onParseComplete=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.PARSE_COMPLETE,args.file.dispatchEvent(args)},THREE.SEA3D.prototype.onError=function(args){args.file=this.scope,args.type=THREE.SEA3D.Event.ERROR,args.file.dispatchEvent(args)},THREE.SEA3D.prototype.newDomain=function(){this.domain=new THREE.SEA3D.Domain(this.config.id,this.objects={},this.config.container,THREE.SEA3D.EXTENSIONS_DOMAIN)},THREE.SEA3D.prototype.parse=function(onParseComplete,onParseProgress){delete this.cameras,delete this.containers,delete this.lights,delete this.joints,delete this.meshes,delete this.materials,delete this.animationSets,delete this.sprites,delete this.sounds3d,delete this.cubeRenderers,delete this.sounds,delete this.glsl,delete this.dummy,delete this.domain,this.newDomain(),this.file.onParseComplete=function(e){this.config.manager&&this.config.manager.add(this.domain),(onParseComplete||this.onParseComplete).call(this.file,e)}.bind(this),this.file.onParseProgress=onParseProgress||this.onParseProgress;for(var i=0;i<THREE.SEA3D.EXTENSIONS_PARSE.length;i++)THREE.SEA3D.EXTENSIONS_PARSE[i].call(this);return this.file.parse(),this},THREE.SEA3D.prototype.load=function(url){this.loadBytes(),this.file.load(url)},THREE.SEA3D.prototype.onHead=function(args){if("TJS"!=args.sign)throw new Error("Sign '"+args.sign+"' not supported! Use SEA3D Studio to publish or SEA3DLegacy.js")},THREE.SEA3D.EXTENSIONS=[],THREE.SEA3D.EXTENSIONS_PARSE=[],THREE.SEA3D.EXTENSIONS_DOMAIN=[],THREE.SEA3D.prototype.loadBytes=function(data){this.file=new SEA3D.File,this.file.scope=this,this.file.config=this.config,this.file.streaming=this.config.streaming,this.file.timeLimit=this.config.timeLimit,this.file.onProgress=this.onLoadProgress,this.file.onCompleteObject=this.onCompleteObject,this.file.onDownloadProgress=this.onDownloadProgress,this.file.onParseProgress=this.onParseProgress,this.file.onParseComplete=this.onParseComplete,this.file.onError=this.onError,this.file.onHead=this.onHead,this.file.onComplete=function(e){this.config.manager&&this.config.manager.add(this.domain),this.onComplete.call(this.file,e)}.bind(this),this.newDomain(),this.file.typeRead[SEA3D.Geometry.prototype.type]=this.file.typeRead[SEA3D.GeometryDelta.prototype.type]=this.readGeometryBuffer,this.file.typeRead[SEA3D.Mesh.prototype.type]=this.readMesh,this.file.typeRead[SEA3D.Mesh2D.prototype.type]=this.readMesh2D,this.file.typeRead[SEA3D.Container3D.prototype.type]=this.readContainer3D,this.file.typeRead[SEA3D.Dummy.prototype.type]=this.readDummy,this.file.typeRead[SEA3D.Line.prototype.type]=this.readLine,this.file.typeRead[SEA3D.Material.prototype.type]=this.readMaterial,this.file.typeRead[SEA3D.Camera.prototype.type]=this.readCamera,this.file.typeRead[SEA3D.SkeletonLocal.prototype.type]=this.readSkeletonLocal,this.file.typeRead[SEA3D.JointObject.prototype.type]=this.readJointObject,this.file.typeRead[SEA3D.CubeMap.prototype.type]=this.readCubeMap,this.file.typeRead[SEA3D.CubeRender.prototype.type]=this.readCubeRender,
this.file.typeRead[SEA3D.Animation.prototype.type]=this.readAnimation,this.file.typeRead[SEA3D.SoundPoint.prototype.type]=this.readSoundPoint,this.file.typeRead[SEA3D.TextureURL.prototype.type]=this.readTextureURL,this.file.typeRead[SEA3D.Morph.prototype.type]=this.readMorpher,this.file.typeRead[SEA3D.VertexAnimation.prototype.type]=this.readVertexAnimation,this.file.typeRead[SEA3D.PointLight.prototype.type]=this.readPointLight,this.file.typeRead[SEA3D.DirectionalLight.prototype.type]=this.readDirectionalLight,this.file.typeRead[SEA3D.HemisphereLight.prototype.type]=this.readHemisphereLight,this.file.typeRead[SEA3D.Actions.prototype.type]=this.readActions,this.file.typeRead[SEA3D.JPEG.prototype.type]=this.file.typeRead[SEA3D.JPEG_XR.prototype.type]=this.file.typeRead[SEA3D.PNG.prototype.type]=this.file.typeRead[SEA3D.GIF.prototype.type]=this.readImage,this.file.typeRead[SEA3D.MP3.prototype.type]=this.readSound,this.file.typeRead[SEA3D.GLSL.prototype.type]=this.readGLSL,this.file.typeRead[SEA3D.JavaScriptMethod.prototype.type]=this.readJavaScriptMethod;for(var i=0;i<THREE.SEA3D.EXTENSIONS.length;i++)THREE.SEA3D.EXTENSIONS[i].call(this);this.file.read(data)};var LZMA=LZMA||{};LZMA.OutWindow=function(){this._windowSize=0},LZMA.OutWindow.prototype.create=function(windowSize){this._buffer&&this._windowSize===windowSize||(this._buffer=[]),this._windowSize=windowSize,this._pos=0,this._streamPos=0},LZMA.OutWindow.prototype.flush=function(){var size=this._pos-this._streamPos;if(0!==size){for(;size--;)this._stream.writeByte(this._buffer[this._streamPos++]);this._pos>=this._windowSize&&(this._pos=0),this._streamPos=this._pos}},LZMA.OutWindow.prototype.releaseStream=function(){this.flush(),this._stream=null},LZMA.OutWindow.prototype.setStream=function(stream){this.releaseStream(),this._stream=stream},LZMA.OutWindow.prototype.init=function(solid){solid||(this._streamPos=0,this._pos=0)},LZMA.OutWindow.prototype.copyBlock=function(distance,len){var pos=this._pos-distance-1;for(0>pos&&(pos+=this._windowSize);len--;)pos>=this._windowSize&&(pos=0),this._buffer[this._pos++]=this._buffer[pos++],this._pos>=this._windowSize&&this.flush()},LZMA.OutWindow.prototype.putByte=function(b){this._buffer[this._pos++]=b,this._pos>=this._windowSize&&this.flush()},LZMA.OutWindow.prototype.getByte=function(distance){var pos=this._pos-distance-1;return 0>pos&&(pos+=this._windowSize),this._buffer[pos]},LZMA.RangeDecoder=function(){},LZMA.RangeDecoder.prototype.setStream=function(stream){this._stream=stream},LZMA.RangeDecoder.prototype.releaseStream=function(){this._stream=null},LZMA.RangeDecoder.prototype.init=function(){var i=5;for(this._code=0,this._range=-1;i--;)this._code=this._code<<8|this._stream.readByte()},LZMA.RangeDecoder.prototype.decodeDirectBits=function(numTotalBits){for(var t,result=0,i=numTotalBits;i--;)this._range>>>=1,t=this._code-this._range>>>31,this._code-=this._range&t-1,result=result<<1|1-t,0===(4278190080&this._range)&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8);return result},LZMA.RangeDecoder.prototype.decodeBit=function(probs,index){var prob=probs[index],newBound=(this._range>>>11)*prob;return(2147483648^this._code)<(2147483648^newBound)?(this._range=newBound,probs[index]+=2048-prob>>>5,0===(4278190080&this._range)&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8),0):(this._range-=newBound,this._code-=newBound,probs[index]-=prob>>>5,0===(4278190080&this._range)&&(this._code=this._code<<8|this._stream.readByte(),this._range<<=8),1)},LZMA.initBitModels=function(probs,len){for(;len--;)probs[len]=1024},LZMA.BitTreeDecoder=function(numBitLevels){this._models=[],this._numBitLevels=numBitLevels},LZMA.BitTreeDecoder.prototype.init=function(){LZMA.initBitModels(this._models,1<<this._numBitLevels)},LZMA.BitTreeDecoder.prototype.decode=function(rangeDecoder){for(var m=1,i=this._numBitLevels;i--;)m=m<<1|rangeDecoder.decodeBit(this._models,m);return m-(1<<this._numBitLevels)},LZMA.BitTreeDecoder.prototype.reverseDecode=function(rangeDecoder){for(var bit,m=1,symbol=0,i=0;i<this._numBitLevels;++i)bit=rangeDecoder.decodeBit(this._models,m),m=m<<1|bit,symbol|=bit<<i;return symbol},LZMA.reverseDecode2=function(models,startIndex,rangeDecoder,numBitLevels){for(var bit,m=1,symbol=0,i=0;numBitLevels>i;++i)bit=rangeDecoder.decodeBit(models,startIndex+m),m=m<<1|bit,symbol|=bit<<i;return symbol},LZMA.LenDecoder=function(){this._choice=[],this._lowCoder=[],this._midCoder=[],this._highCoder=new LZMA.BitTreeDecoder(8),this._numPosStates=0},LZMA.LenDecoder.prototype.create=function(numPosStates){for(;this._numPosStates<numPosStates;++this._numPosStates)this._lowCoder[this._numPosStates]=new LZMA.BitTreeDecoder(3),this._midCoder[this._numPosStates]=new LZMA.BitTreeDecoder(3)},LZMA.LenDecoder.prototype.init=function(){var i=this._numPosStates;for(LZMA.initBitModels(this._choice,2);i--;)this._lowCoder[i].init(),this._midCoder[i].init();this._highCoder.init()},LZMA.LenDecoder.prototype.decode=function(rangeDecoder,posState){return 0===rangeDecoder.decodeBit(this._choice,0)?this._lowCoder[posState].decode(rangeDecoder):0===rangeDecoder.decodeBit(this._choice,1)?8+this._midCoder[posState].decode(rangeDecoder):16+this._highCoder.decode(rangeDecoder)},LZMA.Decoder2=function(){this._decoders=[]},LZMA.Decoder2.prototype.init=function(){LZMA.initBitModels(this._decoders,768)},LZMA.Decoder2.prototype.decodeNormal=function(rangeDecoder){var symbol=1;do symbol=symbol<<1|rangeDecoder.decodeBit(this._decoders,symbol);while(256>symbol);return 255&symbol},LZMA.Decoder2.prototype.decodeWithMatchByte=function(rangeDecoder,matchByte){var matchBit,bit,symbol=1;do if(matchBit=matchByte>>7&1,matchByte<<=1,bit=rangeDecoder.decodeBit(this._decoders,(1+matchBit<<8)+symbol),symbol=symbol<<1|bit,matchBit!==bit){for(;256>symbol;)symbol=symbol<<1|rangeDecoder.decodeBit(this._decoders,symbol);break}while(256>symbol);return 255&symbol},LZMA.LiteralDecoder=function(){},LZMA.LiteralDecoder.prototype.create=function(numPosBits,numPrevBits){var i;if(!this._coders||this._numPrevBits!==numPrevBits||this._numPosBits!==numPosBits)for(this._numPosBits=numPosBits,this._posMask=(1<<numPosBits)-1,this._numPrevBits=numPrevBits,this._coders=[],i=1<<this._numPrevBits+this._numPosBits;i--;)this._coders[i]=new LZMA.Decoder2},LZMA.LiteralDecoder.prototype.init=function(){for(var i=1<<this._numPrevBits+this._numPosBits;i--;)this._coders[i].init()},LZMA.LiteralDecoder.prototype.getDecoder=function(pos,prevByte){return this._coders[((pos&this._posMask)<<this._numPrevBits)+((255&prevByte)>>>8-this._numPrevBits)]},LZMA.Decoder=function(){this._outWindow=new LZMA.OutWindow,this._rangeDecoder=new LZMA.RangeDecoder,this._isMatchDecoders=[],this._isRepDecoders=[],this._isRepG0Decoders=[],this._isRepG1Decoders=[],this._isRepG2Decoders=[],this._isRep0LongDecoders=[],this._posSlotDecoder=[],this._posDecoders=[],this._posAlignDecoder=new LZMA.BitTreeDecoder(4),this._lenDecoder=new LZMA.LenDecoder,this._repLenDecoder=new LZMA.LenDecoder,this._literalDecoder=new LZMA.LiteralDecoder,this._dictionarySize=-1,this._dictionarySizeCheck=-1,this._posSlotDecoder[0]=new LZMA.BitTreeDecoder(6),this._posSlotDecoder[1]=new LZMA.BitTreeDecoder(6),this._posSlotDecoder[2]=new LZMA.BitTreeDecoder(6),this._posSlotDecoder[3]=new LZMA.BitTreeDecoder(6)},LZMA.Decoder.prototype.setDictionarySize=function(dictionarySize){return 0>dictionarySize?!1:(this._dictionarySize!==dictionarySize&&(this._dictionarySize=dictionarySize,this._dictionarySizeCheck=Math.max(this._dictionarySize,1),this._outWindow.create(Math.max(this._dictionarySizeCheck,4096))),!0)},LZMA.Decoder.prototype.setLcLpPb=function(lc,lp,pb){var numPosStates=1<<pb;return lc>8||lp>4||pb>4?!1:(this._literalDecoder.create(lp,lc),this._lenDecoder.create(numPosStates),this._repLenDecoder.create(numPosStates),this._posStateMask=numPosStates-1,!0)},LZMA.Decoder.prototype.init=function(){var i=4;for(this._outWindow.init(!1),LZMA.initBitModels(this._isMatchDecoders,192),LZMA.initBitModels(this._isRep0LongDecoders,192),LZMA.initBitModels(this._isRepDecoders,12),LZMA.initBitModels(this._isRepG0Decoders,12),LZMA.initBitModels(this._isRepG1Decoders,12),LZMA.initBitModels(this._isRepG2Decoders,12),LZMA.initBitModels(this._posDecoders,114),this._literalDecoder.init();i--;)this._posSlotDecoder[i].init();this._lenDecoder.init(),this._repLenDecoder.init(),this._posAlignDecoder.init(),this._rangeDecoder.init()},LZMA.Decoder.prototype.decode=function(inStream,outStream,outSize){var posState,decoder2,len,distance,posSlot,numDirectBits,state=0,rep0=0,rep1=0,rep2=0,rep3=0,nowPos64=0,prevByte=0;for(this._rangeDecoder.setStream(inStream),this._outWindow.setStream(outStream),this.init();0>outSize||outSize>nowPos64;)if(posState=nowPos64&this._posStateMask,0===this._rangeDecoder.decodeBit(this._isMatchDecoders,(state<<4)+posState))decoder2=this._literalDecoder.getDecoder(nowPos64++,prevByte),prevByte=state>=7?decoder2.decodeWithMatchByte(this._rangeDecoder,this._outWindow.getByte(rep0)):decoder2.decodeNormal(this._rangeDecoder),this._outWindow.putByte(prevByte),state=4>state?0:state-(10>state?3:6);else{if(1===this._rangeDecoder.decodeBit(this._isRepDecoders,state))len=0,0===this._rangeDecoder.decodeBit(this._isRepG0Decoders,state)?0===this._rangeDecoder.decodeBit(this._isRep0LongDecoders,(state<<4)+posState)&&(state=7>state?9:11,len=1):(0===this._rangeDecoder.decodeBit(this._isRepG1Decoders,state)?distance=rep1:(0===this._rangeDecoder.decodeBit(this._isRepG2Decoders,state)?distance=rep2:(distance=rep3,rep3=rep2),rep2=rep1),rep1=rep0,rep0=distance),0===len&&(len=2+this._repLenDecoder.decode(this._rangeDecoder,posState),state=7>state?8:11);else if(rep3=rep2,rep2=rep1,rep1=rep0,len=2+this._lenDecoder.decode(this._rangeDecoder,posState),state=7>state?7:10,posSlot=this._posSlotDecoder[5>=len?len-2:3].decode(this._rangeDecoder),posSlot>=4){if(numDirectBits=(posSlot>>1)-1,rep0=(2|1&posSlot)<<numDirectBits,14>posSlot)rep0+=LZMA.reverseDecode2(this._posDecoders,rep0-posSlot-1,this._rangeDecoder,numDirectBits);else if(rep0+=this._rangeDecoder.decodeDirectBits(numDirectBits-4)<<4,rep0+=this._posAlignDecoder.reverseDecode(this._rangeDecoder),0>rep0){if(-1===rep0)break;return!1}}else rep0=posSlot;if(rep0>=nowPos64||rep0>=this._dictionarySizeCheck)return!1;this._outWindow.copyBlock(rep0,len),nowPos64+=len,prevByte=this._outWindow.getByte(0)}return this._outWindow.flush(),this._outWindow.releaseStream(),this._rangeDecoder.releaseStream(),!0},LZMA.Decoder.prototype.setDecoderProperties=function(properties){var value,lc,lp,pb,dictionarySize;return properties.size<5?!1:(value=properties.readByte(),lc=value%9,value=~~(value/9),lp=value%5,pb=~~(value/5),this.setLcLpPb(lc,lp,pb)?(dictionarySize=properties.readByte(),dictionarySize|=properties.readByte()<<8,dictionarySize|=properties.readByte()<<16,dictionarySize+=16777216*properties.readByte(),this.setDictionarySize(dictionarySize)):!1)},LZMA.decompress=function(properties,inStream,outStream,outSize){var decoder=new LZMA.Decoder;if(!decoder.setDecoderProperties(properties))throw"Incorrect stream properties";if(!decoder.decode(inStream,outStream,outSize))throw"Error in data stream";return!0},LZMA.decompressFile=function(inStream,outStream){var outSize,decoder=new LZMA.Decoder;if(!decoder.setDecoderProperties(inStream))throw"Incorrect stream properties";if(outSize=inStream.readByte(),outSize|=inStream.readByte()<<8,outSize|=inStream.readByte()<<16,outSize+=16777216*inStream.readByte(),inStream.readByte(),inStream.readByte(),inStream.readByte(),inStream.readByte(),!decoder.decode(inStream,outStream,outSize))throw"Error in data stream";return!0},SEA3D.File.LZMAUncompress=function(data){data=new Uint8Array(data);var inStream={data:data,position:0,readByte:function(){return this.data[this.position++]}},outStream={data:[],position:0,writeByte:function(value){this.data[this.position++]=value}};return LZMA.decompressFile(inStream,outStream),new Uint8Array(outStream.data).buffer},SEA3D.File.setDecompressionEngine(2,"lzma",SEA3D.File.LZMAUncompress),THREE.OrbitControls=function(object,domElement){function getAutoRotationAngle(){return 2*Math.PI/60/60*scope.autoRotateSpeed}function getZoomScale(){return Math.pow(.95,scope.zoomSpeed)}function rotateLeft(angle){sphericalDelta.theta-=angle}function rotateUp(angle){sphericalDelta.phi-=angle}function dollyIn(dollyScale){scope.object instanceof THREE.PerspectiveCamera?scale/=dollyScale:scope.object instanceof THREE.OrthographicCamera?(scope.object.zoom=Math.max(scope.minZoom,Math.min(scope.maxZoom,scope.object.zoom*dollyScale)),scope.object.updateProjectionMatrix(),zoomChanged=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),scope.enableZoom=!1)}function dollyOut(dollyScale){scope.object instanceof THREE.PerspectiveCamera?scale*=dollyScale:scope.object instanceof THREE.OrthographicCamera?(scope.object.zoom=Math.max(scope.minZoom,Math.min(scope.maxZoom,scope.object.zoom/dollyScale)),scope.object.updateProjectionMatrix(),zoomChanged=!0):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - dolly/zoom disabled."),scope.enableZoom=!1)}function handleMouseDownRotate(event){rotateStart.set(event.clientX,event.clientY)}function handleMouseDownDolly(event){dollyStart.set(event.clientX,event.clientY)}function handleMouseDownPan(event){panStart.set(event.clientX,event.clientY)}function handleMouseMoveRotate(event){rotateEnd.set(event.clientX,event.clientY),rotateDelta.subVectors(rotateEnd,rotateStart);var element=scope.domElement===document?scope.domElement.body:scope.domElement;rotateLeft(2*Math.PI*rotateDelta.x/element.clientWidth*scope.rotateSpeed),rotateUp(2*Math.PI*rotateDelta.y/element.clientHeight*scope.rotateSpeed),rotateStart.copy(rotateEnd),scope.update()}function handleMouseMoveDolly(event){dollyEnd.set(event.clientX,event.clientY),dollyDelta.subVectors(dollyEnd,dollyStart),dollyDelta.y>0?dollyIn(getZoomScale()):dollyDelta.y<0&&dollyOut(getZoomScale()),dollyStart.copy(dollyEnd),scope.update()}function handleMouseMovePan(event){panEnd.set(event.clientX,event.clientY),panDelta.subVectors(panEnd,panStart),pan(panDelta.x,panDelta.y),panStart.copy(panEnd),scope.update()}function handleMouseUp(event){}function handleMouseWheel(event){var delta=0;void 0!==event.wheelDelta?delta=event.wheelDelta:void 0!==event.detail&&(delta=-event.detail),delta>0?dollyOut(getZoomScale()):0>delta&&dollyIn(getZoomScale()),scope.update()}function handleKeyDown(event){switch(event.keyCode){case scope.keys.UP:pan(0,scope.keyPanSpeed),scope.update();break;case scope.keys.BOTTOM:pan(0,-scope.keyPanSpeed),scope.update();break;case scope.keys.LEFT:pan(scope.keyPanSpeed,0),scope.update();break;case scope.keys.RIGHT:pan(-scope.keyPanSpeed,0),scope.update()}}function handleTouchStartRotate(event){rotateStart.set(event.touches[0].pageX,event.touches[0].pageY)}function handleTouchStartDolly(event){var dx=event.touches[0].pageX-event.touches[1].pageX,dy=event.touches[0].pageY-event.touches[1].pageY,distance=Math.sqrt(dx*dx+dy*dy);dollyStart.set(0,distance)}function handleTouchStartPan(event){panStart.set(event.touches[0].pageX,event.touches[0].pageY)}function handleTouchMoveRotate(event){rotateEnd.set(event.touches[0].pageX,event.touches[0].pageY),rotateDelta.subVectors(rotateEnd,rotateStart);var element=scope.domElement===document?scope.domElement.body:scope.domElement;rotateLeft(2*Math.PI*rotateDelta.x/element.clientWidth*scope.rotateSpeed),rotateUp(2*Math.PI*rotateDelta.y/element.clientHeight*scope.rotateSpeed),rotateStart.copy(rotateEnd),scope.update()}function handleTouchMoveDolly(event){var dx=event.touches[0].pageX-event.touches[1].pageX,dy=event.touches[0].pageY-event.touches[1].pageY,distance=Math.sqrt(dx*dx+dy*dy);dollyEnd.set(0,distance),dollyDelta.subVectors(dollyEnd,dollyStart),dollyDelta.y>0?dollyOut(getZoomScale()):dollyDelta.y<0&&dollyIn(getZoomScale()),dollyStart.copy(dollyEnd),scope.update()}function handleTouchMovePan(event){panEnd.set(event.touches[0].pageX,event.touches[0].pageY),panDelta.subVectors(panEnd,panStart),pan(panDelta.x,panDelta.y),panStart.copy(panEnd),scope.update()}function handleTouchEnd(event){}function onMouseDown(event){if(scope.enabled!==!1){if(event.preventDefault(),event.button===scope.mouseButtons.ORBIT){if(scope.enableRotate===!1)return;handleMouseDownRotate(event),state=STATE.ROTATE}else if(event.button===scope.mouseButtons.ZOOM){if(scope.enableZoom===!1)return;handleMouseDownDolly(event),state=STATE.DOLLY}else if(event.button===scope.mouseButtons.PAN){if(scope.enablePan===!1)return;handleMouseDownPan(event),state=STATE.PAN}state!==STATE.NONE&&(document.addEventListener("mousemove",onMouseMove,!1),document.addEventListener("mouseup",onMouseUp,!1),document.addEventListener("mouseout",onMouseUp,!1),scope.dispatchEvent(startEvent))}}function onMouseMove(event){if(scope.enabled!==!1)if(event.preventDefault(),state===STATE.ROTATE){if(scope.enableRotate===!1)return;handleMouseMoveRotate(event)}else if(state===STATE.DOLLY){if(scope.enableZoom===!1)return;handleMouseMoveDolly(event)}else if(state===STATE.PAN){if(scope.enablePan===!1)return;handleMouseMovePan(event)}}function onMouseUp(event){scope.enabled!==!1&&(handleMouseUp(event),document.removeEventListener("mousemove",onMouseMove,!1),document.removeEventListener("mouseup",onMouseUp,!1),document.removeEventListener("mouseout",onMouseUp,!1),scope.dispatchEvent(endEvent),state=STATE.NONE)}function onMouseWheel(event){scope.enabled===!1||scope.enableZoom===!1||state!==STATE.NONE&&state!==STATE.ROTATE||(event.preventDefault(),event.stopPropagation(),handleMouseWheel(event),scope.dispatchEvent(startEvent),scope.dispatchEvent(endEvent))}function onKeyDown(event){scope.enabled!==!1&&scope.enableKeys!==!1&&scope.enablePan!==!1&&handleKeyDown(event)}function onTouchStart(event){if(scope.enabled!==!1){switch(event.touches.length){case 1:if(scope.enableRotate===!1)return;handleTouchStartRotate(event),state=STATE.TOUCH_ROTATE;break;case 2:if(scope.enableZoom===!1)return;handleTouchStartDolly(event),state=STATE.TOUCH_DOLLY;break;case 3:if(scope.enablePan===!1)return;handleTouchStartPan(event),state=STATE.TOUCH_PAN;break;default:state=STATE.NONE}state!==STATE.NONE&&scope.dispatchEvent(startEvent)}}function onTouchMove(event){if(scope.enabled!==!1)switch(event.preventDefault(),event.stopPropagation(),event.touches.length){case 1:if(scope.enableRotate===!1)return;if(state!==STATE.TOUCH_ROTATE)return;handleTouchMoveRotate(event);break;case 2:if(scope.enableZoom===!1)return;if(state!==STATE.TOUCH_DOLLY)return;handleTouchMoveDolly(event);break;case 3:if(scope.enablePan===!1)return;if(state!==STATE.TOUCH_PAN)return;handleTouchMovePan(event);break;default:state=STATE.NONE}}function onTouchEnd(event){scope.enabled!==!1&&(handleTouchEnd(event),scope.dispatchEvent(endEvent),state=STATE.NONE)}function onContextMenu(event){event.preventDefault()}this.object=object,this.domElement=void 0!==domElement?domElement:document,this.enabled=!0,this.target=new THREE.Vector3,this.minDistance=0,this.maxDistance=1/0,this.minZoom=0,this.maxZoom=1/0,this.minPolarAngle=0,this.maxPolarAngle=Math.PI,this.minAzimuthAngle=-(1/0),this.maxAzimuthAngle=1/0,this.enableDamping=!1,this.dampingFactor=.25,this.enableZoom=!0,this.zoomSpeed=1,this.enableRotate=!0,this.rotateSpeed=1,this.enablePan=!0,this.keyPanSpeed=7,this.autoRotate=!1,this.autoRotateSpeed=2,this.enableKeys=!0,this.keys={LEFT:37,UP:38,RIGHT:39,BOTTOM:40},this.mouseButtons={ORBIT:THREE.MOUSE.LEFT,ZOOM:THREE.MOUSE.MIDDLE,PAN:THREE.MOUSE.RIGHT},this.target0=this.target.clone(),this.position0=this.object.position.clone(),this.zoom0=this.object.zoom,this.getPolarAngle=function(){return phi},this.getAzimuthalAngle=function(){return theta},this.reset=function(){scope.target.copy(scope.target0),scope.object.position.copy(scope.position0),scope.object.zoom=scope.zoom0,scope.object.updateProjectionMatrix(),scope.dispatchEvent(changeEvent),scope.update(),state=STATE.NONE},this.update=function(){var offset=new THREE.Vector3,quat=(new THREE.Quaternion).setFromUnitVectors(object.up,new THREE.Vector3(0,1,0)),quatInverse=quat.clone().inverse(),lastPosition=new THREE.Vector3,lastQuaternion=new THREE.Quaternion;return function(){var position=scope.object.position;return offset.copy(position).sub(scope.target),offset.applyQuaternion(quat),spherical.setFromVector3(offset),scope.autoRotate&&state===STATE.NONE&&rotateLeft(getAutoRotationAngle()),spherical.theta+=sphericalDelta.theta,spherical.phi+=sphericalDelta.phi,spherical.theta=Math.max(scope.minAzimuthAngle,Math.min(scope.maxAzimuthAngle,spherical.theta)),spherical.phi=Math.max(scope.minPolarAngle,Math.min(scope.maxPolarAngle,spherical.phi)),spherical.makeSafe(),spherical.radius*=scale,spherical.radius=Math.max(scope.minDistance,Math.min(scope.maxDistance,spherical.radius)),scope.target.add(panOffset),offset.setFromSpherical(spherical),offset.applyQuaternion(quatInverse),position.copy(scope.target).add(offset),scope.object.lookAt(scope.target),scope.enableDamping===!0?(sphericalDelta.theta*=1-scope.dampingFactor,sphericalDelta.phi*=1-scope.dampingFactor):sphericalDelta.set(0,0,0),scale=1,panOffset.set(0,0,0),zoomChanged||lastPosition.distanceToSquared(scope.object.position)>EPS||8*(1-lastQuaternion.dot(scope.object.quaternion))>EPS?(scope.dispatchEvent(changeEvent),lastPosition.copy(scope.object.position),lastQuaternion.copy(scope.object.quaternion),zoomChanged=!1,!0):!1}}(),this.dispose=function(){scope.domElement.removeEventListener("contextmenu",onContextMenu,!1),scope.domElement.removeEventListener("mousedown",onMouseDown,!1),scope.domElement.removeEventListener("mousewheel",onMouseWheel,!1),scope.domElement.removeEventListener("MozMousePixelScroll",onMouseWheel,!1),scope.domElement.removeEventListener("touchstart",onTouchStart,!1),scope.domElement.removeEventListener("touchend",onTouchEnd,!1),scope.domElement.removeEventListener("touchmove",onTouchMove,!1),document.removeEventListener("mousemove",onMouseMove,!1),document.removeEventListener("mouseup",onMouseUp,!1),document.removeEventListener("mouseout",onMouseUp,!1),window.removeEventListener("keydown",onKeyDown,!1)};var scope=this,changeEvent={type:"change"},startEvent={type:"start"},endEvent={type:"end"},STATE={NONE:-1,ROTATE:0,DOLLY:1,PAN:2,TOUCH_ROTATE:3,TOUCH_DOLLY:4,TOUCH_PAN:5},state=STATE.NONE,EPS=1e-6,spherical=new THREE.Spherical,sphericalDelta=new THREE.Spherical,scale=1,panOffset=new THREE.Vector3,zoomChanged=!1,rotateStart=new THREE.Vector2,rotateEnd=new THREE.Vector2,rotateDelta=new THREE.Vector2,panStart=new THREE.Vector2,panEnd=new THREE.Vector2,panDelta=new THREE.Vector2,dollyStart=new THREE.Vector2,dollyEnd=new THREE.Vector2,dollyDelta=new THREE.Vector2,panLeft=function(){var v=new THREE.Vector3;return function(distance,objectMatrix){v.setFromMatrixColumn(objectMatrix,0),v.multiplyScalar(-distance),panOffset.add(v)}}(),panUp=function(){var v=new THREE.Vector3;return function(distance,objectMatrix){v.setFromMatrixColumn(objectMatrix,1),v.multiplyScalar(distance),panOffset.add(v)}}(),pan=function(){var offset=new THREE.Vector3;return function(deltaX,deltaY){var element=scope.domElement===document?scope.domElement.body:scope.domElement;if(scope.object instanceof THREE.PerspectiveCamera){var position=scope.object.position;offset.copy(position).sub(scope.target);var targetDistance=offset.length();targetDistance*=Math.tan(scope.object.fov/2*Math.PI/180),panLeft(2*deltaX*targetDistance/element.clientHeight,scope.object.matrix),panUp(2*deltaY*targetDistance/element.clientHeight,scope.object.matrix)}else scope.object instanceof THREE.OrthographicCamera?(panLeft(deltaX*(scope.object.right-scope.object.left)/scope.object.zoom/element.clientWidth,scope.object.matrix),panUp(deltaY*(scope.object.top-scope.object.bottom)/scope.object.zoom/element.clientHeight,scope.object.matrix)):(console.warn("WARNING: OrbitControls.js encountered an unknown camera type - pan disabled."),scope.enablePan=!1)}}();scope.domElement.addEventListener("contextmenu",onContextMenu,!1),scope.domElement.addEventListener("mousedown",onMouseDown,!1),scope.domElement.addEventListener("mousewheel",onMouseWheel,!1),scope.domElement.addEventListener("MozMousePixelScroll",onMouseWheel,!1),scope.domElement.addEventListener("touchstart",onTouchStart,!1),scope.domElement.addEventListener("touchend",onTouchEnd,!1),scope.domElement.addEventListener("touchmove",onTouchMove,!1),window.addEventListener("keydown",onKeyDown,!1),this.update()},THREE.OrbitControls.prototype=Object.create(THREE.EventDispatcher.prototype),THREE.OrbitControls.prototype.constructor=THREE.OrbitControls,Object.defineProperties(THREE.OrbitControls.prototype,{center:{get:function(){return console.warn("THREE.OrbitControls: .center has been renamed to .target"),this.target}},noZoom:{get:function(){return console.warn("THREE.OrbitControls: .noZoom has been deprecated. Use .enableZoom instead."),!this.enableZoom},set:function(value){console.warn("THREE.OrbitControls: .noZoom has been deprecated. Use .enableZoom instead."),this.enableZoom=!value}},noRotate:{get:function(){return console.warn("THREE.OrbitControls: .noRotate has been deprecated. Use .enableRotate instead."),!this.enableRotate},set:function(value){console.warn("THREE.OrbitControls: .noRotate has been deprecated. Use .enableRotate instead."),this.enableRotate=!value}},noPan:{get:function(){return console.warn("THREE.OrbitControls: .noPan has been deprecated. Use .enablePan instead."),!this.enablePan},set:function(value){console.warn("THREE.OrbitControls: .noPan has been deprecated. Use .enablePan instead."),this.enablePan=!value}},noKeys:{get:function(){return console.warn("THREE.OrbitControls: .noKeys has been deprecated. Use .enableKeys instead."),!this.enableKeys},set:function(value){console.warn("THREE.OrbitControls: .noKeys has been deprecated. Use .enableKeys instead."),this.enableKeys=!value}},staticMoving:{get:function(){return console.warn("THREE.OrbitControls: .staticMoving has been deprecated. Use .enableDamping instead."),!this.constraint.enableDamping},set:function(value){console.warn("THREE.OrbitControls: .staticMoving has been deprecated. Use .enableDamping instead."),this.constraint.enableDamping=!value}},dynamicDampingFactor:{get:function(){return console.warn("THREE.OrbitControls: .dynamicDampingFactor has been renamed. Use .dampingFactor instead."),this.constraint.dampingFactor},set:function(value){console.warn("THREE.OrbitControls: .dynamicDampingFactor has been renamed. Use .dampingFactor instead."),this.constraint.dampingFactor=value}}}),define("3d-view",["3d-viewer/three-viewer","ajs","BaseViewer","template-store-singleton","jquery"],function(ThreeViewer,AJS,BaseViewer,templateStore,$){var ThreeDView=BaseViewer.extend({id:"cp-3d-view-wrapper",tagName:"div",initialize:function(){BaseViewer.prototype.initialize.apply(this,arguments),this.viewer=new ThreeViewer},teardown:function(){this.viewer.dispose(),this.viewer=null,this.off(),this.remove()},render:function(){this.$el.html(templateStore.get("threeDViewer")({})),this.viewer.init(this.$el[0],this.model.get("src"));var oldOnComplete=this.viewer.loader.file.onComplete.bind(this.viewer.loader);this.viewer.loader.file.onComplete=function(e){$(".cp-3d-spinner",this.$el).hide(),oldOnComplete(e)}.bind(this),this.viewer.render();var fileView=this._fileViewer.getView();return fileView.fileSidebarView.isAnyPanelInitialized()&&fileView.fileSidebarView.teardownPanel(),this.trigger("viewerReady"),this},setupMode:function(mode,isModeChanged){var view=this._fileViewer.getView(),toolbar=view.fileContentView.getLayerForName("toolbar"),oldActions=toolbar.getActions();toolbar.setActions(oldActions.concat(ThreeDView._CUSTOM_ACTIONS))},zoomIn:function(){this.viewer.zoom(1+ThreeDView._ZOOM_FACTOR)},zoomOut:function(){this.viewer.zoom(1-ThreeDView._ZOOM_FACTOR)},zoomActual:function(){this.viewer.zoom(1)}});return ThreeDView._CUSTOM_ACTIONS=[{title:AJS.I18n.getText("cp.3d.file.type.toggle.grid"),className:"cp-toolbar-3d-toggle-grid",predicate:function(){return!0},handler:function(){this._fileViewer.analytics.send("files.fileviewer-web.file.3d.disable-grid",{actionType:"button"}),this._viewer.viewer.toggleGrid()}},{title:AJS.I18n.getText("cp.3d.file.type.toggle.camera.type"),className:"cp-toolbar-3d-toggle-camera-type",predicate:function(){return!0},handler:function(){this._fileViewer.analytics.send("files.fileviewer-web.file.3d.toggle-camera-type",{actionType:"button"}),this._viewer.viewer.toggleCameraType()}},{title:AJS.I18n.getText("cp.3d.file.type.toggle.axis"),className:"cp-toolbar-3d-toggle-axis",predicate:function(){return!0},handler:function(){this._fileViewer.analytics.send("files.fileviewer-web.file.3d.toggle-axis",{actionType:"button"}),this._viewer.viewer.toggleAxes()}}],ThreeDView._ZOOM_FACTOR=.2,ThreeDView});var THREE=THREE||window.THREE;define("3d-viewer/three-viewer",[],function(){function ThreeViewer(){this._reset()}function onWindowResize(){var w=this.domNode.offsetWidth,h=this.domNode.offsetHeight;this.camera instanceof THREE.PerspectiveCamera?this.camera.aspect=w/h:this.camera instanceof THREE.OrthographicCamera&&(this.camera.left=w/-2,this.camera.right=w/2,this.camera.top=h/2,this.camera.bottom=h/-2),this.camera.updateProjectionMatrix(),this.renderer.setSize(w,h)}return ThreeViewer.prototype.init=function(domNode,modelPath){this.domNode=domNode;var w=this.domNode.offsetWidth,h=this.domNode.offsetHeight;this.clock=new THREE.Clock,this.scene=new THREE.Scene,this.sceneOverlay=new THREE.Scene,this.currentZoom=50,this.toggleCameraType(),this.axes=ThreeViewer.createAxes(30),this.sceneOverlay.add(this.axes),this.grid=ThreeViewer.createGrid(),this.scene.add(this.grid),this.loader=ThreeViewer.loadModel(modelPath,this.scene),this.boundingBox=new THREE.BoundingBoxHelper,this.lights=ThreeViewer.createLights(),this.scene.add(this.lights),this.renderer=ThreeViewer.getRenderer(),this.renderer.setSize(w,h),this.renderer.setClearColor(ThreeViewer.CONST.COLOR.ECLIPSE,ThreeViewer.CONST.OPACITY.OPAQUE),this.domNode.appendChild(this.renderer.domElement),this.onWindowResizeDelegate=onWindowResize.bind(this),window.addEventListener("resize",this.onWindowResizeDelegate,!1)},ThreeViewer.prototype.dispose=function(){window.removeEventListener("resize",this.onWindowResizeDelegate,!1),this.domNode.removeChild(this.renderer.domElement),this._reset()},ThreeViewer.prototype.render=function(){this.renderer&&(requestAnimationFrame(this.render.bind(this)),this.animate(),this.renderer.clear(),this.renderer.render(this.scene,this.camera),this.renderer.clearDepth(),this.renderer.render(this.sceneOverlay,this.camera))},ThreeViewer.prototype.animate=function(){var delta=this.clock.getDelta();THREE.SEA3D.AnimationHandler.update(delta),THREE.AnimationHandler.update(delta)},ThreeViewer.prototype.toggleCameraType=function(){var w=this.domNode.offsetWidth,h=this.domNode.offsetHeight,oldPos=this.camera&&this.camera.position,isPerspectiveCamera=!this.camera||this.camera instanceof THREE.PerspectiveCamera;this.camera=isPerspectiveCamera?new THREE.OrthographicCamera(w/-2,w/2,h/2,h/-2,-ThreeViewer.CONST.DISTANCE.FAR,ThreeViewer.CONST.DISTANCE.FAR):new THREE.PerspectiveCamera(ThreeViewer.CONST.CAMERA.PERSPECTIVE.FOV,w/h,ThreeViewer.CONST.DISTANCE.NEAR,ThreeViewer.CONST.DISTANCE.FAR),oldPos?this.camera.position.set(oldPos.x,oldPos.y,oldPos.z):this.camera.position.z=this.currentZoom,this.controls=new THREE.OrbitControls(this.camera)},ThreeViewer.prototype.toggleAxes=function(){this.axes.visible=!this.axes.visible},ThreeViewer.prototype.toggleGrid=function(){this.grid.visible=!this.grid.visible},ThreeViewer.prototype.toggleBoundingBox=function(){this.boundingBox.visible=!this.boundingBox.visible},ThreeViewer.prototype.toggleAnimation=function(){this.currentAnimation&&(this.currentAnimation.isPlaying?this.currentAnimation.stop():this.currentAnimation.play())},ThreeViewer.prototype._reset=function(){this.scene=null,this.sceneOverlay=null,
this.camera=null,this.controls=null,this.renderer=null,this.model=null,this.animations=[],this.currentAnimation=null,this.boundingBox=null,this.lights=null,this.axes=null,this.grid=null,this.domNode=null,this.onWindowResizeDelegate=null,this.currentZoom=0,this.clock=null},ThreeViewer.prototype.zoom=function(zoomFactor){this.camera.zoom*=zoomFactor,this.camera.updateProjectionMatrix()},ThreeViewer.prototype.getZoomFactor=function(){return this.camera.zoom},ThreeViewer.getRenderer=function(){var is3DSupported=!1,renderer=null;try{var canvas=window.document.createElement("canvas");is3DSupported=!!canvas.getContext("webgl")}catch(x){}return is3DSupported?(renderer=new THREE.WebGLRenderer,renderer.setPixelRatio(window.devicePixelRatio)):renderer=new THREE.CanvasRenderer,renderer.autoClear=!1,renderer},ThreeViewer.createLights=function(){var lights=[];lights[0]=new THREE.PointLight(ThreeViewer.CONST.COLOR.WHITE,ThreeViewer.CONST.INTENSITY.MAX,ThreeViewer.CONST.DISTANCE.NONE),lights[1]=new THREE.PointLight(ThreeViewer.CONST.COLOR.WHITE,ThreeViewer.CONST.INTENSITY.MAX,ThreeViewer.CONST.DISTANCE.NONE),lights[2]=new THREE.PointLight(ThreeViewer.CONST.COLOR.WHITE,ThreeViewer.CONST.INTENSITY.MAX,ThreeViewer.CONST.DISTANCE.NONE),lights[0].position.set(0,200,0),lights[1].position.set(100,200,100),lights[2].position.set(-100,-200,-100);var result=new THREE.Object3D,ambientLight=new THREE.AmbientLight(ThreeViewer.CONST.COLOR.BLACK);return result.add.apply(result,[ambientLight].concat(lights)),result},ThreeViewer.loadModel=function(path,container){var loader=new THREE.SEA3D({autoPlay:!0,container:container});return loader.load(path),loader},ThreeViewer.createAxes=function(size){return new THREE.AxisHelper(size)},ThreeViewer.createGrid=function(){var result=new THREE.GridHelper(ThreeViewer.CONST.GRID.SIZE,ThreeViewer.CONST.GRID.STEP);return result.setColors(ThreeViewer.CONST.COLOR.NERO,ThreeViewer.CONST.COLOR.CHARCOAL),result},ThreeViewer.CONST={DISTANCE:{NONE:0,NEAR:1,FAR:5e3},COLOR:{WHITE:16777215,BLACK:0,CHARCOAL:4868682,NERO:2105376,ECLIPSE:3750201},OPACITY:{OPAQUE:1,TRANSPARENT:0},INTENSITY:{MAX:1},GRID:{SIZE:5e3,STEP:200},CAMERA:{PERSPECTIVE:{FOV:75}}},ThreeViewer})}).bind(window)(function(){var FileViewer;return FileViewer="undefined"!=typeof module&&"exports"in module?require("./fileviewer.js"):window.require?window.FileViewer:window.FileViewer}());