(function (FileViewer) {
    'use strict';

    // use FileViewer's internal module system
    var define  = FileViewer.define;
    var require = FileViewer.require;

define('watermark/watermarkPlugin', [
  'backbone',
  'template-store-singleton'
], function (
  Backbone,
  templateStore
) {
  'use strict';

  /**
   * Displays a watermark image if enabled in config, to use it,
   * set the following properties
   *
   * watermark: {
   *     imgSrc: 'url_to_image',
   *     linkUrl: 'url_to_open_when_clicked_on_image'
   * }
   */
  var watermarkPlugin = function (fileViewer) {
    if (!fileViewer.getConfig().watermark) { return; }

    var watermarkView = Backbone.View.extend({
      render: function () {
        this.$el.append(templateStore.get('watermarkImage')({
          img: fileViewer.getConfig().watermark.imgSrc,
          url: fileViewer.getConfig().watermark.linkUrl
        }));
        return this;
      }
    });

    fileViewer.getView().fileContentView.addLayerView(
      'watermarkImage',
      watermarkView
    );
  };

  return watermarkPlugin;
});

(function () {
  'use strict';
  var FileViewer = require('file-viewer');
  var watermarkPlugin = require('watermark/watermarkPlugin');
  FileViewer.registerPlugin('watermark', watermarkPlugin);
}());

}(function () {
  var FileViewer;

    if (typeof module !== "undefined" && ('exports' in module)) {
      FileViewer = require('./fileviewer.js');
    } else if (window.require) {
      FileViewer = window.FileViewer;
    } else {
      FileViewer = window.FileViewer;
    }

    return FileViewer;
}()));
