(function (FileViewer) {
    'use strict';

    // use FileViewer's internal module system
    var define  = FileViewer.define;
    var require = FileViewer.require;

define('metabar/metabarPlugin', [
  'metabar/metabarView'
], function (
  MetabarView
) {
  'use strict';

  var metabarPlugin = function (fileViewer) {

    if (!fileViewer.getConfig().metaBar) {
      return;
    }

    var fileView = fileViewer.getView();
    var metaView = fileView.fileMetaView;

    metaView.addLayerView('metabar', MetabarView, {
      predicate: MetabarView.predicate
    });
  };

  return metabarPlugin;
});

define('metabar/metabarView', [
  'underscore',
  'backbone',
  'template-store-singleton'
], function (
  _,
  Backbone,
  templateStore
) {
  'use strict';

  return Backbone.View.extend({

    initialize: function (options) {
      var fileViewer  = options.fileViewer;
      this._meta    = fileViewer.getCurrent().meta || {};
      this._config  = fileViewer.getConfig().metaBar || {};
    },

    render: function () {
      this.$el.append(templateStore.get('metabar')({
        avatarSrc: this._meta.avatarSrc || this._config.defaultAvatar,
        author: this._meta.author,
        authorPrefix: this._meta.authorPrefix,
        date: this._meta.date,
        time: this._meta.time,
        fileType: this._meta.fileType,
        fileSize: this._meta.fileSize
      }));

      this.$el.find('.cp-meta-avatar-image').one(
        'error',
        _.partial(this._handleAvatarImageError, this)
      );
    },

    _handleAvatarImageError: function (view) {
      if (!view._config.defaultAvatar) {
        this.parentElement.remove();
      } else {
        this.src = view._config.defaultAvatar;
      }
    }

  }, {

    predicate: function (fileViewer) {
      var config = fileViewer.getConfig().metaBar;
      var meta   = fileViewer.getCurrent().meta || {};

      return !!(config && meta.author && meta.date);
    }

  });
});

(function () {
  'use strict';
  var FileViewer = require('file-viewer');
  var metabarPlugin = require('metabar/metabarPlugin');
  FileViewer.registerPlugin('metabar', metabarPlugin);
}());

}(function () {
  var FileViewer;

    if (typeof module !== "undefined" && ('exports' in module)) {
      FileViewer = require('./fileviewer.js');
    } else if (window.require) {
      FileViewer = window.FileViewer;
    } else {
      FileViewer = window.FileViewer;
    }

    return FileViewer;
}()));
