define('jira/fileviewer/module-backend/asynchronous', ['wrm/require', 'jira/jquery/deferred', 'jquery', 'wrm/context-path'], function(wrmRequire, Deferred, $, wrmContextPath) {
    'use strict';

    // Given the path with file at the end it will capture
    // only the path. E.g. /path/to/file.txt -> /path/to/
    var PATH_REGEXP = /(.+[\/])[^\/]+/;

    /**
     * Proxies requests for modules to WRM.
     * @param {string} templateUrl
     * @return {function}
     */
    return function (modulePath) {
        var WRM_MAPPING = {
            'pdf-viewer': 'wr!com.atlassian.jira.jira-fileviewer-plugin:fileviewer-pdf'
        };

        var WORKER_JS_RESOURCE_NAME = 'com.atlassian.jira.jira-fileviewer-plugin:fileviewer-pdf-worker';

        function getPdfConfig() {
            var dfd = new Deferred();
            $.ajax({
                url: wrmContextPath() + "/rest/webResources/1.0/resources",
                type: "POST",
                contentType: "application/json",
                dataType: "json",
                data: JSON.stringify({
                    r: [WORKER_JS_RESOURCE_NAME],
                    c: [], xc: [], xr: []
                })
            }).done(function (data) {
                var workerSrc = data.resources[0].url; // take the fir
                var cMapUrl = workerSrc.match(PATH_REGEXP)[1] + 'bcmaps/';
                dfd.resolve({
                    workerSrc: workerSrc,
                    cMapUrl: cMapUrl
                });
            }).fail(dfd.reject.bind(dfd));
            return dfd.promise();
        }

        if (WRM_MAPPING[modulePath]) {
            return wrmRequire(WRM_MAPPING[modulePath]);
        } else if (modulePath === "pdf-config") {
            return getPdfConfig();
        }
    };
});
