AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");
(function () {

    module("JIRA.Triggers.SelectTriggerDialogPageView", {
        setup: function () {
            var self = this;

            this.sandbox = sinon.sandbox.create();
            this.model = {
                fetchTriggerTypeList: sinon.stub(),
                on: sinon.stub(),
                off: sinon.stub(),
                changeSelectedTriggerType: sinon.stub()
            };
            this.feedbackDialog = {
                show: sinon.stub()
            };
            this.submitButton = {
                text: sinon.stub()
            };
            this.dialog = {
                disableSubmitButton: sinon.stub(),
                addSubmitButton: function () {
                    return self.submitButton;
                },
                addCancelLink: sinon.stub(),
                closeDialog: sinon.stub(),
                enableSubmitButton: sinon.stub()
            };

            this.fetchDeferred = jQuery.Deferred();
            this.model.fetchTriggerTypeList.returns(this.fetchDeferred);
        },
        teardown: function () {
            this.sandbox.restore();
        },
        createView: function () {
            this.view = new JIRA.Triggers.SelectTriggerDialogPageView({
                model: this.model,
                feedbackDialog: this.feedbackDialog,
                dialog: this.dialog
            });
        },
        createTriggerType: function () {
            return {
                key: "some-key",
                name: "some-name",
                description: "some-description",
                icon: {}
            };
        }
    });

    test("View initialises with no data", function () {
        this.fetchDeferred.resolve([]);
        this.createView();

        this.view._renderTriggerList([]);
        equal(this.view.$el.find(".no-trigger-types").length, 1, "There are no trigger types");
        ok(this.dialog.disableSubmitButton.calledOnce, "Submit button should be disabled");
    });

    test("View initialises with data", function () {
        this.createView();
        var triggerType = this.createTriggerType();

        this.view.show();
        this.view._renderTriggerList([triggerType]);
        this.view._handleSelectionChanged(triggerType.key);
        equal(this.view.$el.find(".no-trigger-types").length, 0, "There are trigger types");
        equal(this.view.$el.find("li.trigger-type").length, 1, "The trigger type is there");
        equal(this.view.$el.find("li.trigger-type").first().data("module-key"), "some-key", "The trigger type key is there");
        equal(this.view.$el.find("li.trigger-type .trigger-type-name").first().text().trim(), "some-name", "The trigger type is name there");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        equal(this.view.$el.find("li.trigger-type .trigger-type-description").first().text(), "some-description", "The trigger type description is there");
        ok(this.model.changeSelectedTriggerType.calledOnce, "Selected trigger changed");
    });

    test("View initialises with failure from fetching", function () {
        this.createView();

        this.view._handleFetchFailed();
        var auiErrors = this.view.$el.find(".aui-message-error");
        ok(auiErrors.length > 0, "Errors are shown");
        equal(auiErrors.first().text(), "admin.trigger.config.add-dialog.fetching.error.title", "Error is shown");
    });

    test("Adding trigger type is successful", function () {
        this.createView();

        this.view._handleTriggerAdded();
        ok(this.dialog.closeDialog.calledOnce, "Dialog close has been called.")
    });

    test("Adding trigger type failed because of generic error", function () {
        this.createView();
        this.view._renderTriggerList([this.createTriggerType()]);

        var failureXhr = {status: 500};

        this.view._handleAddingTriggerFailed(failureXhr);
        equal(this.view.$el.find("#trigger-error-container").length, 1, "There is an error message");
        equal(this.view.$el.find("#trigger-error-container").first().text(), "admin.trigger.config.add-dialog.adding.error.title", "The error message text is correct.");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        ok(this.dialog.enableSubmitButton.calledOnce, "Submit button enabled");
    });

    test("Adding trigger type failed because of specific error", function () {
        this.createView();
        this.view._renderTriggerList([this.createTriggerType()]);

        var failureXhr = {
            status: 400,
            responseText: '{"errorMessages": ["test"]}'
        };

        this.view._handleAddingTriggerFailed(failureXhr);
        equal(this.view.$el.find("#trigger-error-container").length, 1, "There is an error message");
        equal(this.view.$el.find("#trigger-error-container").first().text(), "test", "The error message text is correct.");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        ok(this.dialog.enableSubmitButton.calledOnce, "Submit button enabled");
    });

    test("Adding trigger type failed and error format is invalid", function () {
        this.createView();
        this.view._renderTriggerList([this.createTriggerType()]);

        var failureXhr = {
            status: 400,
            responseText: '{}'
        };

        this.view._handleAddingTriggerFailed(failureXhr);
        equal(this.view.$el.find("#trigger-error-container").length, 1, "There is an error message");
        equal(this.view.$el.find("#trigger-error-container").first().text(), "admin.trigger.config.add-dialog.adding.error.title", "The error message text is correct.");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        ok(this.dialog.enableSubmitButton.calledOnce, "Submit button enabled");
    });

    test("Clicking on the feedback link calls feedbackDialog", function () {
        this.createView();
        this.view._renderTriggerList([this.createTriggerType()]);

        var feedbackBox = this.view.$el.find(".trigger-type-info-box");
        equal(feedbackBox.length, 1, "There is one feedback box");
        feedbackBox.trigger("click");

        ok(this.feedbackDialog.show.calledOnce, "FeedbackDialog.show should be called on feedback click");
    });

})();
