AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.SelectTriggerDialogPageModel", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.backupEverything();
            this.stubEverything();
        },
        teardown: function () {
            this.sandbox.restore();
            AJS.$.ajax = this.ajax;
            JIRA.SmartAjax.makeWebSudoRequest = this.smartAjax;
        },
        backupEverything: function () {
            this.smartAjax = JIRA.SmartAjax.makeWebSudoRequest;
            this.ajax = AJS.$.ajax;
        },
        stubEverything: function () {
            JIRA.SmartAjax.makeWebSudoRequest = this.sandbox.stub();
            AJS.$.ajax = this.sandbox.stub();
        },
        createModel: function (workflowName, actionId) {
            this.listModel = {
                updateData: sinon.stub()
            };
            var mdl = new JIRA.Triggers.SelectTriggerDialogPageModel({
                workflowName: workflowName,
                actionId: actionId,
                listModel: this.listModel
            });
            this.triggerSpy = this.sandbox.spy(mdl, "trigger");

            var selectedTrigger = {moduleKey: "some-key"};
            mdl.set("selectedTrigger", selectedTrigger);
            return mdl;
        },
        mockAjax: function () {
            var deferred = AJS.$.Deferred();
            JIRA.SmartAjax.makeWebSudoRequest.returns(deferred);
            AJS.$.ajax.returns(deferred);
            return deferred;
        }
    });

    test("Trigger type list initialises with no data", function () {
        var model = this.createModel("workflow", 1);
        var deferred = this.mockAjax();
        var result = model.fetchTriggerTypeList();
        deferred.resolve([]);
        ok(result.isResolved(), "Successfully retrieved result.");
        result.done(function (result) {
            equal(result.length, 0, "No items returned.");
        });
    });

    test("Trigger type list initialises with data", function () {
        var model = this.createModel("workflow", 1);
        var deferred = this.mockAjax();
        var result = model.fetchTriggerTypeList();
        deferred.resolve([{things: "stuff"}]);
        ok(result.isResolved(), "Successfully retrieved result.");
        result.done(function (result) {
            equal(result.length, 1, "1 item returned.");
            equal(result[0].things, "stuff", "Correct item returned.");
        });
    });

    test("Trigger type list can not be retrieved", function () {
        var model = this.createModel("workflow", 1);
        var deferred = this.mockAjax();
        var result = model.fetchTriggerTypeList();
        deferred.reject({status: 404});
        ok(result.isRejected(), "Retrieval of result failed.");
    });

    test("Adding Trigger Type is successful", function () {
        var model = this.createModel("workflow", 1);
        var deferred = this.mockAjax("some-key");
        var result = model.addTriggerType();
        deferred.resolve();
        ok(result.isResolved(), "Successfully retrieved result.");
        ok(this.listModel.updateData.calledOnce, "updateData should have been called on the list model");
    });

    test("Adding Trigger Type failed", function () {
        var model = this.createModel("workflow", 1);
        var deferred = this.mockAjax("some-key");
        var result = model.addTriggerType();
        deferred.reject({status: 404});
        ok(result.isRejected(), "Retrieval of result failed.");
        ok(!this.listModel.updateData.called, "updateData should not have been called on the list model");

    });

    test("Changing selected trigger type uses model", function () {
        var model = this.createModel("workflow", 1);
        var deferred = this.mockAjax("some-key");
        var result = model.fetchTriggerTypeList();
        deferred.resolve([{key: "thekey", modelVal: "randomVal"}]);
        ok(result.isResolved(), "Successfully retrieved result.");

        model.changeSelectedTriggerType("thekey");

        equal(model.get('selectedTrigger').key, "thekey");
        equal(model.get('selectedTrigger').modelVal, "randomVal");
    });

})();
