/**
 * @class JIRA.Triggers.DiagnosticsDialogPageView
 * View to represent the diagnostics page in the dialog wizard used to add a trigger.
 */
Backbone.define("JIRA.Triggers.DiagnosticsDialogPageView", Backbone.View.extend({
    header: JIRA.Templates.Triggers.Common.header,

    /**
     * Initialise the view.
     *
     * @classdesc
     * The representation of the Diagnostics page in the Add Trigger Dialog.
     *
     * @constructs
     * @extends Backbone.view
     * @param {object} options
     * @param {object} options.dialog an instance of JIRA.Triggers.AddTriggerDialogView.
     */
    initialize: function (options) {
        this.dialog = options.dialog;
    },

    show: function () {
        this.submitButton = this.dialog.addSubmitButton(
            AJS.I18n.getText('admin.triggers.config.add-dialog.add'),
            _.bind(this._handleAddTriggerButtonClicked, this));
        this.dialog.addCancelLink();

        this.$el.html(JIRA.Templates.Triggers.Add.renderDiagnosticsPage());

        var selectedTrigger = this.model.get("selectedTrigger");

        // We checked before whether a diagnostics page is defined for the trigger
        var diagnosticModel = new JIRA.Triggers.DiagnosticsPanelModel({
            name: selectedTrigger.name,
            key: selectedTrigger.key,
            description: selectedTrigger.description,
            icon: selectedTrigger.icon,
            actionId: this.model.get("actionId"),
            workflowName: this.model.get("workflowName"),
            workflowMode: this.model.get("workflowMode")
        });
        this.$el.find("#trigger-header").html(this.header({
            icon: diagnosticModel.get('icon'),
            description: diagnosticModel.get('description')
        }));

        new JIRA.Triggers.DiagnosticsPanelView({
            el: this.$el.find("#diagnostics-content").get(),
            model: diagnosticModel
        });
    },

    getHeader: function () {
        return AJS.I18n.getText('admin.trigger.config.viewdiagnostics.diagnosticsfor',
            this.model.get("selectedTrigger").name);
    },

    _handleAddTriggerButtonClicked: function () {
        return this.model.addTriggerType()
            .done(_.bind(this._handleTriggerAdded, this))
            .fail(_.bind(this._handleAddingTriggerFailed, this));
    },

    _handleTriggerAdded: function () {
        this.dialog.closeDialog();
        this.remove();
    },

    _handleAddingTriggerFailed: function (xhr) {
        JIRA.Triggers.AddTriggerCommon.handleAddingTriggerFailed(xhr, this.$el);

        this.dialog.enableSubmitButton();
    }
}));
