AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.DiagnosticDialogPageView", {
        setup: function () {
            var self = this;

            this.sandbox = sinon.sandbox.create();
            var getStub = sinon.stub();
            getStub.withArgs('selectedTrigger').returns({
                name: "name",
                key: "key",
                description: "description",
                icon: {
                    url: "http://www.example.com/test.jpg"
                }
            });
            this.model = {
                on: sinon.stub(),
                off: sinon.stub(),
                changeSelectedTriggerType: sinon.stub(),
                get: getStub
            };
            this.submitButton = {
                text: sinon.stub()
            };
            this.dialog = {
                disableSubmitButton: sinon.stub(),
                addCancelLink: sinon.stub(),
                closeDialog: sinon.stub(),
                enableSubmitButton: sinon.stub(),
                addSubmitButton: sinon.stub()
            };
        },
        teardown: function () {
            this.sandbox.restore();
        },
        createView: function () {
            this.view = new JIRA.Triggers.DiagnosticsDialogPageView({
                model: this.model,
                dialog: this.dialog
            });
        },
        createTriggerType: function () {
            return {
                key: "some-key",
                name: "some-name",
                description: "some-description",
                icon: {}
            };
        }
    });

    test("Diagnostics page shows up", function () {
        this.createView();

        this.view.show();
        // Check that the header exists.
        header = this.view.$el.find("#trigger-header");
        ok(header.length > 0);
        equal(header.find('.trigger-type-description').text(), "description");
        ok(this.dialog.addSubmitButton.calledOnce, "Submit button added");
        ok(this.dialog.addCancelLink.calledOnce, "Cancel button added");
    });

    test("Adding trigger type is successful", function () {
        this.createView();

        this.view._handleTriggerAdded();
        ok(this.dialog.closeDialog.calledOnce, "Dialog close has been called.")
    });

    test("Adding trigger type failed because of generic error", function () {
        this.createView();

        var failureXhr = {status: 500};

        this.view.show();
        this.view._handleAddingTriggerFailed(failureXhr);
        equal(this.view.$el.find("#trigger-error-container").length, 1, "There is an error message");
        equal(this.view.$el.find("#trigger-error-container").first().text(), "admin.trigger.config.add-dialog.adding.error.title", "The error message text is correct.");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        ok(this.dialog.enableSubmitButton.calledOnce, "Submit button enabled");
    });

    test("Adding trigger type failed because of specific error", function () {
        this.createView();

        var failureXhr = {
            status: 400,
            responseText: '{"errorMessages": ["test"]}'
        };

        this.view.show();
        this.view._handleAddingTriggerFailed(failureXhr);
        equal(this.view.$el.find("#trigger-error-container").length, 1, "There is an error message");
        equal(this.view.$el.find("#trigger-error-container").first().text(), "test", "The error message text is correct.");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        ok(this.dialog.enableSubmitButton.calledOnce, "Submit button enabled");
    });

    test("Adding trigger type failed and error format is invalid", function () {
        this.createView();

        var failureXhr = {
            status: 400,
            responseText: '{}'
        };

        this.view.show();
        this.view._handleAddingTriggerFailed(failureXhr);
        equal(this.view.$el.find("#trigger-error-container").length, 1, "There is an error message");
        equal(this.view.$el.find("#trigger-error-container").first().text(), "admin.trigger.config.add-dialog.adding.error.title", "The error message text is correct.");
        equal(this.view.$el.find(".select-trigger-button:disabled").length, 0, "Add trigger button is enabled");
        ok(this.dialog.enableSubmitButton.calledOnce, "Submit button enabled");
    });
})();
