AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.AddTriggerDialogView", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.model = {};
            this.listModel = {
                get: sinon.stub(),
                updateData: sinon.stub()
            };
            this.firstPage = {
                view: {
                    getHeader: sinon.stub(),
                    show: sinon.stub(),
                    destroy: sinon.stub()
                }
            }
        },
        teardown: function () {
            if (this.view.$dialog.is(":visible")) {
                this.view.closeDialog();
            }
            this.sandbox.restore();
        },
        createView: function () {
            this.view = new JIRA.Triggers.AddTriggerDialogView({
                model: this.model,
                listModel: this.listModel,
                firstPage: this.firstPage
            });
        }
    });

    test("Dialog shows up", function () {
        this.createView();

        ok(this.view.$dialog.is(":visible"), "Dialog is visible");
        equal(this.view.$dialog.find(".dialog-title").text(), "admin.triggers.config.add-dialog.header", "Default header is shown.");
        equal(this.view.$dialog.find(".status-loading").length, 1, "Loading spinner is visible.");
        equal(this.view.$dialog.find(".wizard-back-button").length, 0, "Back button is not present on first page.");
    });

    test("Go to next page", function () {
        this.createView();

        this.nextView = {
            getHeader: sinon.stub(),
            show: sinon.stub()
        };
        this.nextModel = {};

        this.view.goToNextPage(this.nextView, this.nextModel);

        equal(this.view.$dialog.find(".status-loading").length, 1, "Loading spinner is visible.");
        ok(this.nextView.getHeader.calledOnce, "Next view has been asked to provide header.");
        equal(this.view.$dialog.find(".dialog-title").text(), "admin.triggers.config.add-dialog.header", "Default header is shown.");
        equal(this.view.$dialog.find(".wizard-back-button").length, 1, "Back button is present.");
    });

    test("Set header", function () {
        this.createView();

        this.view.setHeader("test");
        equal(this.view.$dialog.find(".dialog-title").text(), "test", "Configured custom header is shown.");
    });

    test("Add submit button", function () {
        this.createView();
        var addSubmitCallback = sinon.stub();

        this.view.addSubmitButton("test", addSubmitCallback);

        var submitButton = this.view.$dialog.find(".select-trigger-button");
        equal(submitButton.length, 1, "Submit button is visible");
        equal(submitButton.text(), "test", "Button has the right title.");
    });

    test("Hide dialog", function () {
        this.createView();

        this.view.hide();
        equal(this.view.$dialog.is(":visible"), false, "Dialog is not visible");
    });

    test("Disable submit button", function () {
        this.createView();
        var addSubmitCallback = sinon.stub();
        this.view.addSubmitButton("test", addSubmitCallback);

        this.view.disableSubmitButton();

        ok(this.view.$dialog.find(".select-trigger-button").is(':disabled'), "Submit button is disabled.")
    });

    test("Enable submit button", function () {
        this.createView();
        var addSubmitCallback = sinon.stub();
        this.view.addSubmitButton("test", addSubmitCallback);
        this.view.disableSubmitButton();

        this.view.enableSubmitButton();

        equal(this.view.$dialog.find(".select-trigger-button").is(':disabled'), false, "Submit button is not disabled.")
    });

    test("Close dialog", function () {
        this.createView();

        this.view.closeDialog();

        ok(this.listModel.updateData.calledOnce, "Update data has been called on list model.");
        equal(this.view.$dialog.is(":visible"), false, "Dialog is not visible");
    });
})();