/**
 * @class JIRA.Triggers.AddTriggerDialogModel
 * Model for the dialog to add a trigger.
 */
Backbone.define('JIRA.Triggers.AddTriggerDialogModel', Backbone.Model.extend({

    namedEvents: [
        "webSudoWillShow",
        "webSudoCancel",
        "selectionChanged",
        "headerChangeRequest"
    ],

    /**
     * Initialise the model.
     *
     * @classdesc
     * The Add Trigger Dialog model.
     *
     * @constructs
     * @extends Backbone.view
     * @param {object} options
     * @param {string} options.workflowName the name of the current workflow.
     * @param {number} options.actionId the id of the current workflow transition.
     * @param {string} options.workflowMode the current workflow mode.
     */
    initialize: function (options) {
        this.workflowName = options.workflowName;
        this.actionId = options.actionId;
        this.workflowMode = options.workflowMode;
    }
}));
