JIRA.Triggers.AddTriggerCommon = {};

JIRA.Triggers.AddTriggerCommon.handleAddingTriggerFailed = function (xhr, context) {
    var errorText = AJS.I18n.getText('admin.trigger.config.add-dialog.adding.error.title'),
        errorContainer = context.find("#trigger-error-container"),
        hadError = false;

    // Remove any previous errors
    if (errorContainer.text().length) {
        hadError = true;
        errorContainer.empty();
    }

    if (xhr.status === 401) {
        errorText = AJS.I18n.getText('admin.trigger.config.add-dialog.adding.error.authentication.title');
    } else if (xhr.status !== 500 && xhr.status !== 404) {
        var errors = JSON.parse(xhr.responseText);
        var errorMsg = errors.errorMessages || {};
        if (errorMsg.length) {
            errorText = errorMsg[0];
        }
    }

    context.find("#trigger-error-container").html(
        AJS.messages.error({
            body: AJS.escapeHtml(errorText),
            closeable: false
        }));

    return hadError;
};