/**
 * Define Backbone objects with this function to show their name in the console/debugger.
 * See: https://extranet.atlassian.com/pages/viewpage.action?pageId=2007138904
 *
 * Only define Backbone.define ourselves if it isn't already defined.
 * View issue page already does this, but unfortunately not Greenhopper/Dashboard
 */
if (Backbone && !Backbone.define) {
    Backbone.define = function (name, ctor) {
        eval("Backbone['Class: " + name + "'] = function() { Backbone['Class: " + name + "'].__ctor.apply(this, arguments); }");
        var cls = Backbone['Class: ' + name];
        cls.__ctor = ctor;
        ctor.prototype.name = name;
        cls.prototype = ctor.prototype;
        _.extend(cls, ctor);
        _.each(ctor.prototype, function (fn, fnName) {
            if (typeof fn === 'function') {
                fn.displayName = name + '.' + fnName;
            }
        });
        var context = window;
        var parts = name.split('.');
        _.each(parts, function (part, i) {
            if (i === parts.length - 1) {
                context[part] = cls;
            } else {
                context = context[part] == null ? (context[part] = {}) : context[part];
            }
        });
        return cls;
    };
}
