AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");(function(){module("JIRA.Triggers.TriggersListView",{setup:function(){this.sandbox=sinon.sandbox.create();this.model={removeTrigger:this.sandbox.spy(),on:this.sandbox.stub(),get:this.sandbox.stub()};this.feedbackDialog={show:this.sandbox.stub()};this.fixture=jQuery("#qunit-fixture");this.tmpDiagView=JIRA.Triggers.DiagnosticsDialogView;this.tmpDiagModel=JIRA.Triggers.DiagnosticsPanelModel;this.model.get.withArgs("editable").returns(true)},teardown:function(){this.sandbox.restore();JIRA.Triggers.DiagnosticsDialogView=this.tmpDiagView;JIRA.Triggers.DiagnosticsPanelModel=this.tmpDiagModel},createView:function(){return new JIRA.Triggers.TriggersListView({model:this.model,el:this.fixture,listElement:this.fixture})},createTrigger:function(b,a){return{id:b,triggerName:a}}});test("tests that the details dialog works properly",function(){var b={preventDefault:this.sandbox.spy()};this.model.getTriggerInfo=this.sandbox.stub();this.model.getTriggerInfo.returns({triggerKey:"key",name:"name",icon:"icon",description:"description"});JIRA.Triggers.DiagnosticsPanelModel=this.sandbox.stub();JIRA.Triggers.DiagnosticsDialogView=this.sandbox.stub();JIRA.Triggers.DiagnosticsDialogView.returns({render:this.sandbox.stub()});var a=this.createView();a._handleViewDiagnostics(b);ok(b.preventDefault.calledOnce);ok(JIRA.Triggers.DiagnosticsPanelModel.calledWith({triggerId:undefined,name:"name",key:"key",icon:"icon",description:"description",actionId:undefined,workflowName:undefined,workflowMode:undefined}))});test("tests that the details dialog with row data works properly",function(){var b={preventDefault:this.sandbox.spy()};this.model.getTriggerInfo=this.sandbox.stub();this.model.getTriggerInfo.returns({triggerKey:"key",name:"name",icon:"icon",description:"description"});this.model.get=this.sandbox.stub();this.model.get.withArgs("actionId").returns("actionId");this.model.get.withArgs("workflowName").returns("workflowName");this.model.get.withArgs("workflowMode").returns("draft");JIRA.Triggers.DiagnosticsPanelModel=this.sandbox.stub();JIRA.Triggers.DiagnosticsDialogView=this.sandbox.stub();JIRA.Triggers.DiagnosticsDialogView.returns({render:this.sandbox.stub()});this.fixture.append("<div class='trigger-row' data-trigger-id='3'><a id='testTarget'></a></div>");b.target=this.fixture.find("#testTarget");var a=this.createView();a._handleViewDiagnostics(b);ok(b.preventDefault.calledOnce);ok(JIRA.Triggers.DiagnosticsPanelModel.calledWith({triggerId:"3",name:"name",key:"key",icon:"icon",description:"description",actionId:"actionId",workflowName:"workflowName",workflowMode:"draft"}))});test("View initialises with no data",function(){var a=this.createView();a._handleFetchSucceeded({triggers:[]});equal(this.fixture.find("table.aui").length,1,"There is a list");equal(this.fixture.find("tbody td.empty-list").length,1,"Empty list element only")});test("View initialises with a single item in the list",function(){var a=this.createView();a._handleFetchSucceeded({triggers:[{name:"test"}]});equal(this.fixture.find("table.aui").length,1,"There is a list");equal(this.fixture.find("tbody td.name").length,1,"There is one element");equal(this.fixture.find("tbody td.name").text(),"test","There is one element")});test("View contains warnings correctly",function(){var a=this.createView();a._handleFetchSucceeded({triggers:[{name:"test",warning:"Needs more salt"}]});equal(this.fixture.find("table.aui").length,1,"There is a list");var b=this.fixture.find("tbody td.name");equal(b.length,1,"There is one element");var c=b.find("span.aui-icon-warning");equal(c.length,1,"There is one element");equal(c.attr("original-title"),"Needs more salt","Warning has correct tooltip")});test("View initialises with two items in the list",function(){var a=this.createView();a._handleFetchSucceeded({triggers:[{name:"test"},{name:"rest"}]});equal(this.fixture.find("table.aui").length,1,"There is a list");equal(this.fixture.find("tbody td.name").length,2,"There are two elements");equal(this.fixture.find("tbody td.name").text(),"testrest","There are two elements")});test("View has 404 error",function(){var a=this.createView();a._handleFetchFailed({error:{status:404}});equal(this.fixture.find("table.aui").length,0,"There is no list");equal(this.fixture.find(".aui-message").length,1,"There is a message");equal(this.fixture.find(".aui-message .icon-generic").length,1,"There is a message")});test("View has 401 error",function(){var a=this.createView();a._handleFetchFailed({error:{status:401}});equal(this.fixture.find("table.aui").length,0,"There is no list");equal(this.fixture.find(".aui-message").length,1,"There is a message");equal(this.fixture.find(".aui-message .icon-warning").length,1,"There is a message")});test("Remove click triggers a remove operation",function(){var a=this.createView();a._handleFetchSucceeded({triggers:[this.createTrigger(1,"One"),this.createTrigger(2,"Two")]});equal(this.fixture.find("table.aui").length,1,"There is a list");var b=this.fixture.find("table.aui .trigger-row:first").find(".remove-trigger");equal(b.length,1,"Remove link found");b.trigger("click");ok(this.model.removeTrigger.withArgs("1").calledOnce,"Remove should be called on model")});test("Read-only mode",function(){this.model.get.withArgs("editable").returns(false);var a=this.createView();a._handleFetchSucceeded({triggers:[this.createTrigger(1,"One"),this.createTrigger(2,"Two")]});equal(this.fixture.find("table.aui").length,1,"There is a list");var c=this.fixture.find("table.aui .trigger-row .remove-trigger");equal(c.length,0,"No remove links in read only mode");var b=this.fixture.find(".open-trigger-selection-dialog");equal(b.length,0,"No add trigger button in read only mode")})})();