Backbone.define("JIRA.Triggers.TriggersListView",Backbone.View.extend({template:JIRA.Templates.Triggers.List.triggersList,loading:JIRA.Templates.Triggers.Common.renderBigSpinner,connError:JIRA.Templates.Triggers.List.connError,authError:JIRA.Templates.Triggers.List.authError,events:{"click button.open-trigger-selection-dialog":"_createAddTriggerView","click .remove-trigger":"_handleRemove","click .view-diagnostics":"_handleViewDiagnostics","click #triggers-list-feedback-trigger":"_handleFeedback"},initialize:function(a){this.options=_.defaults({},a);this.model=this.options.model;this.listElement=this.options.listElement;this._initFeedbackDialog(a);this._initFetchHandlers()},renderLoadingState:function(){var a=this.listElement;a.html(this.loading());var b=this.listElement.find(".status-loading");b.spin("large");b.show();return this},renderSuccess:function(a){var b=this.listElement;b.html(this.template({triggers:a.triggers,editable:this.model.get("editable")}));AJS.$(b).find(".aui-icon-warning").tooltip({aria:true});AJS.$(b).parents("#workflow-transition-info").find("#triggers").find(".aui-badge").text(a.triggers.length);return this},renderAuth:function(a){var b=this.listElement;b.html(this.authError(a));return this},renderNoConnection:function(){var a=this.listElement;a.html(this.connError());return this},isPresent:function(){return !_.isUndefined(this.$el)},_initFeedbackDialog:function(a){this.feedbackDialog=a.feedbackDialog||new JIRA.DevStatus.FeedbackDialog({summary:AJS.I18n.getText("admin.triggers.config.feedback.summary")})},_handleFeedback:function(a){a.preventDefault();this.feedbackDialog.show()},_handleFetchSucceeded:function(a){return this.renderSuccess(a)},_handleFetchFailed:function(a){if(a.error.status===401){this.renderAuth(a)}else{this.renderNoConnection()}},_handleRemove:function(b){b.preventDefault();var a=AJS.$(b.target).closest(".trigger-row");this.model.removeTrigger(a.attr("data-trigger-id"))},_handleViewDiagnostics:function(f){f.preventDefault();var d=AJS.$(f.target).closest(".trigger-row");var g=d.attr("data-trigger-id");var c=this.model.getTriggerInfo(parseInt(g))||{};var a=new JIRA.Triggers.DiagnosticsPanelModel({triggerId:g,name:c.name,key:c.triggerKey,icon:c.icon,description:c.description,actionId:this.model.get("actionId"),workflowName:this.model.get("workflowName"),workflowMode:this.model.get("workflowMode")});var b=new JIRA.Triggers.DiagnosticsDialogView({model:a});b.render()},_initFetchHandlers:function(){this.listenTo(this.model,"fetchRequested",this.renderLoadingState);this.listenTo(this.model,"fetchSucceeded",this._handleFetchSucceeded);this.listenTo(this.model,"fetchFailed",this._handleFetchFailed);this.listenTo(this.model,"removeFailed",this._handleFetchFailed);this.listenTo(this.model,"triggerTypeAvailabilityUpdatedSucceeded",this._handleTriggerTypeAvailabilityUpdateSucceeded);this.listenTo(this.model,"triggerTypeAvailabilityUpdatedFailed",this._handleTriggerTypeAvailabilityUpdateFailed)},_handleTriggerTypeAvailabilityUpdateSucceeded:function(a){this._getAddTriggerButton().attr("aria-disabled",a!=true)},_handleTriggerTypeAvailabilityUpdateFailed:function(){this._getAddTriggerButton().removeAttr("aria-disabled")},_createAddTriggerView:function(){if(this._getAddTriggerButton().attr("aria-disabled")!=="true"){new JIRA.Triggers.AddTriggerDialogView({listModel:this.model})}},_getAddTriggerButton:function(){return this.$el.find("button.open-trigger-selection-dialog")}}));