Backbone.define("JIRA.Triggers.TriggersListModule", Backbone.Model.extend({

    initialize: function (options) {
        var element = AJS.$('#triggers-config-list');
        var listElement = element.find('#workflow-triggers-list');
        this.workflowName = listElement.attr('data-workflow-name');
        this.actionId = listElement.attr('data-actionid');

        this.model = new JIRA.Triggers.TriggersListModel({
            actionId: this.actionId,
            workflowName: this.workflowName,
            editable: listElement.data('editable'), // using jQuery data on purpose, as we want the property value to be boolean
            workflowMode: listElement.attr('data-workflow-mode')
        });

        this.view = new JIRA.Triggers.TriggersListView({
            model: this.model,
            el: element,
            listElement: listElement
        });
    },

    update: function () {
        if (this.view.isPresent()) {
            this.model.updateData();
        }
    }
}));

AJS.toInit(function ($) {
    // Only load the content if we're actually on the triggers tab
    if (AJS.$('.active-tab #triggers').length) {
        var module = new JIRA.Triggers.TriggersListModule({});
        module.update();
        var triggersTabShownEventName = 'administration.workflow.view.transition.triggers-transitions-tab.shown';
        AJS.trigger('analyticsEvent', {name: triggersTabShownEventName, data: {}});
    }

    new JIRA.Triggers.Analytics({el: document.body});
});
