AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.TriggersListModule", {
        setup: function () {
            var $ = jQuery;
            this.fixture = $("#qunit-fixture");
            this.fixture.append($("<div id='triggers-config-list'><div id='workflow-triggers-list'/></div>"));
            this.triggersList = this.fixture.find('#workflow-triggers-list');
        },
        addDataParams: function (workflowName, actionId, workflowMode, editable) {
            this.triggersList.attr('data-workflow-name', workflowName)
                .attr('data-actionid', actionId)
                .attr('data-workflow-mode', workflowMode)
                .attr('data-editable', editable);
        }
    });

    test("Initializes with correct workflowName and actionId", function () {
        this.addDataParams('Test workflow', '11', 'draft', 'true');
        var module = new JIRA.Triggers.TriggersListModule({});
        equal(module.workflowName, 'Test workflow');
        equal(module.actionId, '11');
    });

    test("Initializes model with correct properties", function () {
        this.addDataParams('Test workflow', '11', 'draft', 'true');
        var module = new JIRA.Triggers.TriggersListModule({});
        equal(module.model.get('workflowName'), 'Test workflow');
        equal(module.model.get('actionId'), '11');
        equal(module.model.get('workflowMode'), 'draft');
        equal(module.model.get('editable'), true);
    });

    test("Initializes model with editable false", function () {
        this.addDataParams('Test workflow', '11', 'live', 'false');
        var module = new JIRA.Triggers.TriggersListModule({});
        equal(module.model.get('workflowMode'), 'live');
        equal(module.model.get('editable'), false);
    });
})();