AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");(function(){module("JIRA.Triggers.TriggersListModel",{setup:function(){this.sandbox=sinon.sandbox.create();this.fixture=jQuery("#qunit-fixture");this.stubEverything()},teardown:function(){this.sandbox.restore()},stubEverything:function(){this.sandbox.stub(AJS.$,"ajax")},createModel:function(a,d,c){var b=new JIRA.Triggers.TriggersListModel({workflowName:a,actionId:d,workflowMode:c});this.triggerSpy=this.sandbox.spy(b,"trigger");this.updateDataSpy=this.sandbox.spy(b,"updateData");return b},mockAjax:function(){var a=AJS.$.Deferred();AJS.$.ajax.returns(a);return a}});test("Model initialises with no data",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.updateData();a.resolve([]);equal(b.get("data").triggers.length,0,"Empty triggers");ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce,"fetchSucceeded was called")});test("Model initialises with no data",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.updateData();a.resolve([{things:"stuff"}]);equal(b.get("data").triggers.length,1,"One trigger");equal(b.get("data").triggers[0].things,"stuff","Trigger data matches response");ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce,"fetchSucceeded was called")});test("Model asks for live workflow",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.updateData();a.resolve([]);var c=AJS.$.ajax.firstCall;equal(c.args[0].data.workflowName,"workflow","workflow name was correct");equal(c.args[0].data.actionId,1,"action ID was correct");equal(c.args[0].data.workflowMode,"live","workflow mode was correct");ok(this.triggerSpy.withArgs("triggerTypeAvailabilityUpdatedSucceeded").calledOnce,"triggerTypeAvailabilityUpdatedSucceeded was called")});test("Model asks for draft workflow",function(){var b=this.createModel("workflow",1,"draft");var a=this.mockAjax();b.updateData();a.resolve([]);var c=AJS.$.ajax.firstCall;equal(c.args[0].data.workflowName,"workflow","workflow name was correct");equal(c.args[0].data.actionId,1,"action ID was correct");equal(c.args[0].data.workflowMode,"draft","workflow mode was correct");ok(this.triggerSpy.withArgs("triggerTypeAvailabilityUpdatedSucceeded").calledOnce,"triggerTypeAvailabilityUpdatedSucceeded was called")});test("Model cannot contact the server",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.updateData();a.reject({status:404});equal(b.get("data").error.status,404,"Empty triggers");ok(this.triggerSpy.withArgs("fetchFailed").calledOnce,"fetchFailed was called")});test("Auth exception when contacting server",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.updateData();a.reject({status:401});equal(b.get("data").error.status,401,"Empty triggers");ok(this.triggerSpy.withArgs("fetchFailed").calledOnce,"fetchFailed was called")});test("Removing triggers successful triggers data update",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.removeTrigger(1);var c=this.mockAjax();a.resolve("OK");c.resolve([{name:"Some trigger"}]);equal(b.get("data").triggers.length,1,"One trigger in data");equal(b.get("data").triggers[0].name,"Some trigger","Trigger data matches response");ok(this.updateDataSpy.calledOnce,"updateData was called");ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce,"fetchSucceeded was called")});test("Removing triggers successful triggers data update, which fails",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.removeTrigger(1);var c=this.mockAjax();a.resolve("OK");c.reject({status:400});equal(b.get("data").error.status,400,"No triggers because of error response");ok(this.updateDataSpy.calledOnce,"updateData was called");ok(this.triggerSpy.withArgs("fetchFailed").calledOnce,"fetchFailed was called")});test("Removing triggers fails",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.removeTrigger(1);a.reject({status:400});equal(b.get("data").error.status,400,"No triggers because of error response");equal(this.updateDataSpy.callCount,0,"updateData was never called");ok(this.triggerSpy.withArgs("removeFailed").calledOnce,"removeFailed was called")});test("Removing non existing trigger is successful",function(){var b=this.createModel("workflow",1,"live");var a=this.mockAjax();b.removeTrigger(1);a.reject({status:404});equal(b.get("data").error.status,404,"No triggers because of error response");ok(this.updateDataSpy.calledOnce,"updateData was called");ok(this.triggerSpy.withArgs("removeSucceeded").calledOnce,"removeSucceeded was called")});test("Trigger type list initialises with data",function(){var b=this.createModel("workflow",1);var a=this.mockAjax();b._fetchTriggerTypes();a.resolve(["1","2"]);ok(this.triggerSpy.withArgs("triggerTypeAvailabilityUpdatedSucceeded",true).calledOnce,"triggerTypeAvailabilityUpdatedSucceeded was called")});test("Trigger type list initialises without data",function(){var b=this.createModel("workflow",1);var a=this.mockAjax();b._fetchTriggerTypes();a.resolve([]);ok(this.triggerSpy.withArgs("triggerTypeAvailabilityUpdatedSucceeded",false).calledOnce,"triggerTypeAvailabilityUpdatedSucceeded was called")});test("Trigger type list can not be retrieved",function(){var b=this.createModel("workflow",1);var a=this.mockAjax();b._fetchTriggerTypes();a.reject({status:404});ok(this.triggerSpy.withArgs("triggerTypeAvailabilityUpdatedFailed").calledOnce,"triggerTypeAvailabilityUpdatedFailed was called")});test("Trigger Info gets appropriate information about a trigger",function(){var a=this.createModel("workflow",1);a.set("data",{triggers:[{id:"key-1",val:"val-1"},{id:"key-2",val:"val-2"}]});equal(a.getTriggerInfo("key-2").val,"val-2");equal(a.getTriggerInfo("key-3"),undefined)})})();