/**
 * @class JIRA.Triggers.Diagnostics
 * Triggers diagnostics module allows for registering a plugin so that it has
 * diagnostics available.
 */
JIRA.Triggers.Diagnostics = {
    registeredHooks: {},

    /**
     * Registers a given diagnostics panel module with the diagnostics
     * subsystem.
     * @param {string} triggerKey the full plugin key for this trigger.
     * @param {Object} item the object used to construct a diagnostics module.
     */
    register: function (triggerKey, item) {
        this.registeredHooks[triggerKey] = item;
    },

    /**
     * Gets the diagnostics panel module for the given full plugin key.
     * @param {string} triggerKey the full plugin key for the trigger.
     */
    getDiagnosticsFor: function (triggerKey) {
        return this.registeredHooks[triggerKey];
    }
};

