/**
 * @class JIRA.Triggers.Configuration
 * Triggers configuration module allows for registering a plugin so that it has
 * configuration options available.
 */
JIRA.Triggers.Configuration = {
    registeredHooks: {},

    /**
     * Registers a given configuration panel module with the configuration
     * subsystem.
     * @param {string} triggerKey the full plugin key for this trigger.
     * @param {Object} item the object used to construct a configuration module.
     */
    register: function (triggerKey, item) {
        this.registeredHooks[triggerKey] = item;
    },

    /**
     * Gets the configuration panel module for the given full plugin key.
     * @param {string} triggerKey the full plugin key for the trigger.
     */
    getConfigurationFor: function (triggerKey) {
        return this.registeredHooks[triggerKey];
    }
};

