/**
 * @class JIRA.Triggers.FailedTransitionsListView
 * Dialog for diagnostics of each already added trigger.
 */
Backbone.define("JIRA.Triggers.Diagnostics.FailedTransitionsListView", Backbone.View.extend({
    template: JIRA.Templates.Triggers.Diagnostics.FailedTransitions.list,
    failed: JIRA.Templates.Triggers.Diagnostics.FailedTransitions.failedUpdate,
    loading: JIRA.Templates.Triggers.Common.renderBigSpinner,

    initialize: function () {
        this.listenTo(this.model, 'fetchSucceeded', this._renderSucceeded);
        this.listenTo(this.model, 'fetchFailed', this._renderFailed);
    },

    render: function () {
        var data = this.model.get('data');
        var state = data.get('fetchState');
        if (state === 'fetchSucceeded') {
            this._renderSucceeded();
        } else if (state === 'fetchFailed') {
            this._renderFailed();
        }
        // else don't display anything.
    },

    _renderSucceeded: function () {
        var data = this.model.get('data');
        if (data.transitionsList.length > 0) {
            this.$el.html(this.template(data));
            this._renderLiveStamp();
        }
    },

    _renderFailed: function () {
        this.$el.html(this.failed());
    },

    _renderLiveStamp: function () {
        var timestamp = this.$el.find("time.livestamp");
        timestamp.livestamp();
        timestamp.each(function () {
            var time_el = AJS.$(this);
            var time_val = time_el.attr("datetime");
            var fixed_time = isNaN(time_val) ? time_val : +time_val;
            var fixedMoment = moment(fixed_time).zone(fixed_time);
            if (!fixedMoment.isValid()) {
                fixedMoment = moment(fixed_time);
            }
            time_el.attr("title", fixedMoment.format('LLL'));
        });
    }
}));
