AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.Diagnostics.FailedTransitionsListView", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.model = {
                on: this.sandbox.stub(),
                get: this.sandbox.stub()
            };

            this.fixture = jQuery("#qunit-fixture");

            this.model.get.withArgs("editable").returns(true);
            AJS.$.fn.livestamp = this.sandbox.stub();
            moment = this.sandbox.stub();
            var momentObj = {
                zone: this.sandbox.stub(),
                isValid: this.sandbox.stub(),
                format: this.sandbox.stub()
            };
            moment.returns(momentObj);
            momentObj.zone.returns(momentObj);
            momentObj.isValid.returns(true);
            momentObj.format.returns("MOMENTED");
        },
        teardown: function () {
            this.sandbox.restore();
            delete AJS.$.fn.livestamp;
            delete moment;
        },
        createView: function () {
            return new JIRA.Triggers.Diagnostics.FailedTransitionsListView({
                model: this.model,
                el: this.fixture
            });
        }
    });

    test("View initialising starts listening", function () {
        var view = this.createView();
        ok(this.model.on.withArgs("fetchSucceeded").calledOnce);
        ok(this.model.on.withArgs("fetchFailed").calledOnce);
    });

    test("View initialises with no data", function () {
        var view = this.createView();
        this.model.get.withArgs("data").returns({
            transitionsList: []
        });

        view._renderSucceeded();
        equal(this.fixture.find(".failed-transitions").length, 0, "No failed transitions");
    });

    test("View initialises with empty data", function () {
        var view = this.createView();
        this.model.get.withArgs("data").returns({
            transitionsList: []
        });

        view._renderSucceeded();
        equal(this.fixture.find(".failed-transitions").length, 0, "No failed transitions");
    });

    test("View initialises with a single item in the list", function () {
        var view = this.createView();
        this.model.get.withArgs("data").returns({
            transitionsList: [{
                date: "2013-01-01",
                issueKey: "theKey",
                errorMessages: "Things went wrong"
            }]
        });

        view._renderSucceeded();
        var row = this.fixture.find("table tbody tr");
        equal(row.length, 1, "table row exists");
        equal(row.find(".date").text(), "2013-01-01");
        equal(row.find(".date time").attr('title'), "MOMENTED");
        equal(row.find(".issue-key").text(), "theKey");
        equal(row.find(".error-messages").text(), "Things went wrong");
    });

    test("View initialises with two items in the list", function () {
        var view = this.createView();
        this.model.get.withArgs("data").returns({
            transitionsList: [{
                date: "2013-01-01",
                issueKey: "theKey",
                errorMessages: "Things went wrong"
            }, {
                date: "eieio",
                issueKey: "altKey",
                errorMessages: "altError"
            }]
        });

        view._renderSucceeded();
        var rows = this.fixture.find("table tbody tr");
        row1 = AJS.$(rows.get(0));
        row2 = AJS.$(rows.get(1));
        equal(rows.length, 2, "table row exists");
        equal(row1.find(".date").text(), "2013-01-01");
        equal(row1.find(".date time").attr('title'), "MOMENTED");
        equal(row1.find(".issue-key").text(), "theKey");
        equal(row1.find(".error-messages").text(), "Things went wrong");
        equal(row2.find(".date").text(), "eieio");
        equal(row2.find(".date time").attr('title'), "MOMENTED");
        equal(row2.find(".issue-key").text(), "altKey");
        equal(row2.find(".error-messages").text(), "altError");
    });

    test("View has error", function () {
        var view = this.createView();

        view._renderFailed({});
        equal(this.fixture.find(".aui-message").length, 1, "There is a message");
    });

})();
