/**
 * @class JIRA.Triggers.Diagnostics.FailedTransitionsListModel
 * Model for the list of failed transitions.
 */
Backbone.define('JIRA.Triggers.Diagnostics.FailedTransitionsListModel', Backbone.Model.extend({
    namedEvents: [
        // events related to detailed data rest call
        "fetchRequested",
        "fetchFailed",
        "fetchSucceeded"
    ],

    /**
     * Updates the data from the back-end.
     */
    fetchData: function () {
        this._fireRequested();

        this._handleFetch(AJS.$.ajax({
            url: this._getFetchUrl(),
            data: {
                workflowName: this.get('workflowName'),
                actionId: this.get('actionId'),
                triggerId: this.get('triggerId')
            }
        }).promise());
    },

    _handleFetch: function (promise) {
        var self = this;
        promise.done(function (result) {
            var transitionsList = _.map(result, function (item) {
                return {
                    date: item.date,
                    errorMessages: item.errorMessages,
                    issueKey: item.issueKey,
                    issueUrl: AJS.contextPath() + '/browse/' + item.issueKey
                };
            });
            self.set('data', {
                transitionsList: transitionsList
            });
            self._fireSuccessResult();
        }).fail(function (xhr, status) {
            self.set('data', {
                error: xhr
            });
            self._fireFailResult();
        });
    },

    _getFetchUrl: function () {
        return AJS.contextPath() + '/rest/triggers/1.0/diagnostics/transitions/failed';
    },

    _fireSuccessResult: function () {
        this.trigger('fetchSucceeded');
        this.set('fetchState', 'fetchSucceeded');
    },

    _fireFailResult: function () {
        this.trigger('fetchFailed');
        this.set('fetchState', 'fetchFailed');
    },

    _fireRequested: function () {
        this.trigger("fetchRequested", this.get('workflowName'), this.get('actionId'));
        this.set('fetchState', 'fetchRequested');
    }

}));
