AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.Diagnostics.FailedTransitionsListModel", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.fixture = jQuery("#qunit-fixture");
            this.stubEverything();
        },
        teardown: function () {
            this.sandbox.restore();
        },
        stubEverything: function () {
            this.sandbox.stub(AJS.$, "ajax");
        },
        createModel: function (workflowName, actionId, triggerId) {
            var model = new JIRA.Triggers.Diagnostics.FailedTransitionsListModel({
                workflowName: workflowName,
                actionId: actionId,
                triggerId: triggerId
            });
            this.triggerSpy = this.sandbox.spy(model, "trigger");
            this.fetchDataSpy = this.sandbox.spy(model, "fetchData");
            return model;
        },
        mockAjax: function () {
            var deferred = AJS.$.Deferred();
            AJS.$.ajax.returns(deferred);
            return deferred;
        }
    });

    test("Model initialises with no data", function () {
        var model = this.createModel("workflow", 1, 3);
        var deferred = this.mockAjax();
        model.fetchData();
        ok(this.triggerSpy.withArgs("fetchRequested").calledOnce, "fetchRequested was called");
        deferred.resolve([]);
        equal(model.get("data").transitionsList.length, 0, "Empty triggers");
        ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce, "fetchSucceeded was called");
    });

    test("Model initialises with minimal data", function () {
        var model = this.createModel("workflow", 1, 3);
        var deferred = this.mockAjax();
        model.fetchData();
        deferred.resolve([{things: "stuff"}]);
        equal(model.get("data").transitionsList.length, 1, "One trigger");
        equal(model.get("data").transitionsList[0].things, undefined, "Trigger data is empty");
        ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce, "fetchSucceeded was called");
    });

    test("Model initialises with correct data", function () {
        var model = this.createModel("workflow", 1, 3);
        var deferred = this.mockAjax();
        model.fetchData();
        deferred.resolve([{date: "date", errorMessages: "error", issueKey: 'abc-123'}]);
        equal(model.get("data").transitionsList.length, 1, "One trigger");
        equal(model.get("data").transitionsList[0].date, "date", "Trigger data matches date");
        equal(model.get("data").transitionsList[0].errorMessages, "error", "Trigger data matches error");
        equal(model.get("data").transitionsList[0].issueKey, "abc-123", "Trigger data matches issueKey");
        ok(model.get("data").transitionsList[0].issueUrl.indexOf("/browse/abc-123") != -1,
            "Trigger data generates issueUrl correctly");
        ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce, "fetchSucceeded was called");
    });

    test("Model asks for live workflow", function () {
        var model = this.createModel("workflow", 1, 3);
        var deferred = this.mockAjax();
        model.fetchData();
        deferred.resolve([]);
        var ajaxCall = AJS.$.ajax.firstCall;
        equal(ajaxCall.args[0].data.workflowName, "workflow", "workflow name was correct");
        equal(ajaxCall.args[0].data.actionId, 1, "action ID was correct");
        equal(ajaxCall.args[0].data.triggerId, 3, "trigger ID was correct");
    });

    test("Model cannot contact the server", function () {
        var model = this.createModel("workflow", 1, 3);
        var deferred = this.mockAjax();
        model.fetchData();
        deferred.reject({status: 404});
        equal(model.get("data").error.status, 404, "Empty triggers");
        ok(this.triggerSpy.withArgs("fetchFailed").calledOnce, "fetchFailed was called");
    });

    test("Auth exception when contacting server", function () {
        var model = this.createModel("workflow", 1, 3);
        var deferred = this.mockAjax();
        model.fetchData();
        deferred.reject({status: 401});
        equal(model.get("data").error.status, 401, "Empty triggers");
        ok(this.triggerSpy.withArgs("fetchFailed").calledOnce, "fetchFailed was called");
    });

})();
