AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");(function(){module("JIRA.Triggers.Diagnostics.FailedTransitionsListModel",{setup:function(){this.sandbox=sinon.sandbox.create();this.fixture=jQuery("#qunit-fixture");this.stubEverything()},teardown:function(){this.sandbox.restore()},stubEverything:function(){this.sandbox.stub(AJS.$,"ajax")},createModel:function(a,d,c){var b=new JIRA.Triggers.Diagnostics.FailedTransitionsListModel({workflowName:a,actionId:d,triggerId:c});this.triggerSpy=this.sandbox.spy(b,"trigger");this.fetchDataSpy=this.sandbox.spy(b,"fetchData");return b},mockAjax:function(){var a=AJS.$.Deferred();AJS.$.ajax.returns(a);return a}});test("Model initialises with no data",function(){var b=this.createModel("workflow",1,3);var a=this.mockAjax();b.fetchData();ok(this.triggerSpy.withArgs("fetchRequested").calledOnce,"fetchRequested was called");a.resolve([]);equal(b.get("data").transitionsList.length,0,"Empty triggers");ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce,"fetchSucceeded was called")});test("Model initialises with minimal data",function(){var b=this.createModel("workflow",1,3);var a=this.mockAjax();b.fetchData();a.resolve([{things:"stuff"}]);equal(b.get("data").transitionsList.length,1,"One trigger");equal(b.get("data").transitionsList[0].things,undefined,"Trigger data is empty");ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce,"fetchSucceeded was called")});test("Model initialises with correct data",function(){var b=this.createModel("workflow",1,3);var a=this.mockAjax();b.fetchData();a.resolve([{date:"date",errorMessages:"error",issueKey:"abc-123"}]);equal(b.get("data").transitionsList.length,1,"One trigger");equal(b.get("data").transitionsList[0].date,"date","Trigger data matches date");equal(b.get("data").transitionsList[0].errorMessages,"error","Trigger data matches error");equal(b.get("data").transitionsList[0].issueKey,"abc-123","Trigger data matches issueKey");ok(b.get("data").transitionsList[0].issueUrl.indexOf("/browse/abc-123")!=-1,"Trigger data generates issueUrl correctly");ok(this.triggerSpy.withArgs("fetchSucceeded").calledOnce,"fetchSucceeded was called")});test("Model asks for live workflow",function(){var b=this.createModel("workflow",1,3);var a=this.mockAjax();b.fetchData();a.resolve([]);var c=AJS.$.ajax.firstCall;equal(c.args[0].data.workflowName,"workflow","workflow name was correct");equal(c.args[0].data.actionId,1,"action ID was correct");equal(c.args[0].data.triggerId,3,"trigger ID was correct")});test("Model cannot contact the server",function(){var b=this.createModel("workflow",1,3);var a=this.mockAjax();b.fetchData();a.reject({status:404});equal(b.get("data").error.status,404,"Empty triggers");ok(this.triggerSpy.withArgs("fetchFailed").calledOnce,"fetchFailed was called")});test("Auth exception when contacting server",function(){var b=this.createModel("workflow",1,3);var a=this.mockAjax();b.fetchData();a.reject({status:401});equal(b.get("data").error.status,401,"Empty triggers");ok(this.triggerSpy.withArgs("fetchFailed").calledOnce,"fetchFailed was called")})})();