/**
 * @class JIRA.Triggers.DiagnosticsPanelView
 */
Backbone.define("JIRA.Triggers.DiagnosticsPanelView", Backbone.View.extend({

    /**
     * @constructs
     * @extends Backbone.View
     */
    initialize: function () {
        this.render();
    },

    /**
     * Renders the diagnostics panel for the appropriate trigger type.
     */
    render: function () {
        var diagType = this.model.getTrigger();
        if (diagType == null) // Not registered.
        {
            return;
        }
        var diagnostics = new diagType({
            container: this.el,
            triggerId: this.model.get('triggerId'),
            workflowName: this.model.get('workflowName'),
            workflowMode: this.model.get('workflowMode'),
            actionId: this.model.get('actionId')
        });

        diagnostics.showDiagnostics();
    }

}));
