AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.DiagnosticsPanelView", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.fixture = jQuery("#qunit-fixture");
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("tests does not render when no trigger", function () {
        var model = {
            get: this.sandbox.stub(),
            getTrigger: this.sandbox.stub()
        };
        new JIRA.Triggers.DiagnosticsPanelView({model: model});
        ok(model.getTrigger.called);
        equal(model.get.callCount, 0);
    });

    test("tests does render when trigger available", function () {
        var model = {
            get: this.sandbox.stub(),
            getTrigger: this.sandbox.stub()
        };
        var diagType = this.sandbox.stub();
        var diagnostics = {
            showDiagnostics: this.sandbox.stub()
        };
        diagType.returns(diagnostics);
        model.getTrigger.returns(diagType);
        model.get.withArgs("triggerId").returns("0");
        model.get.withArgs("workflowName").returns("randomname");
        model.get.withArgs("workflowMode").returns("mode");
        model.get.withArgs("actionId").returns("doathing");
        new JIRA.Triggers.DiagnosticsPanelView({model: model});
        ok(model.getTrigger.called);
        ok(model.get.called);
        ok(diagnostics.showDiagnostics.called);
    });

})();
