/**
 * @class JIRA.Triggers.DiagnosticsPanelModel
 */
Backbone.define('JIRA.Triggers.DiagnosticsPanelModel', Backbone.Model.extend({

    properties: ['triggerId', 'name', 'key', 'icon', 'description'],

    namedEvents: [],

    /**
     * @return {Object} the appropriate trigger diagnostics component for this
     * trigger.
     */
    getTrigger: function () {
        return JIRA.Triggers.Diagnostics.getDiagnosticsFor(this.get('key'));
    }
}));
