/**
 * @class JIRA.Triggers.DiagnosticsDialogView
 * Dialog for diagnostics of each already added trigger.
 */
Backbone.define("JIRA.Triggers.DiagnosticsDialogView", Backbone.View.extend({
    template: JIRA.Templates.Triggers.Add.renderDiagnosticsPage,
    header: JIRA.Templates.Triggers.Common.header,

    /**
     * @constructs
     * @extends Backbone.View
     */
    initialize: function () {
    },

    _createDialog: function () {
        return new AJS.Dialog({
            id: 'diagnostics-dialog',
            closeOnOutsideClick: true,
            width: 800
        });
    },

    _closeDialog: function () {
        this.dialog && this.dialog.remove();
    },

    _renderHeader: function ($panelBody) {
        var self = this;
        $panelBody.find("#trigger-header").html(this.header({
            icon: this.model.get('icon'),
            description: this.model.get('description')
        }));
    },

    _renderFailedTransitions: function ($panelBody) {
        var failedTransitionsModel = new JIRA.Triggers.Diagnostics.FailedTransitionsListModel({
            workflowName: this.model.get('workflowName'),
            actionId: this.model.get('actionId'),
            triggerId: this.model.get('triggerId')
        });
        new JIRA.Triggers.Diagnostics.FailedTransitionsListView({
            el: $panelBody.find("#failed-transitions-container").get(),
            model: failedTransitionsModel
        });
        failedTransitionsModel.fetchData();
    },

    /**
     * renders the dialog.
     */
    render: function () {
        this.dialog = this._createDialog();

        this.dialog.addHeader(AJS.I18n.getText('admin.trigger.config.viewdiagnostics.diagnosticsfor',
            this.model.get("name")));
        this.dialog.addPanel("diagnosticsPanel", "", "diagnostics-panel-body");
        var panel = this.dialog.getCurrentPanel();
        var $panelBody = AJS.$(panel.body);
        $panelBody.html(this.template());
        var self = this;
        this.dialog.addButton(AJS.I18n.getText('admin.trigger.config.viewdiagnostics.done'), function (dialog) {
            dialog.hide();
            self._closeDialog();
        }, "done-button aui-button aui-button-primary");

        this._colourButton();
        this.dialog.show();

        this._renderHeader($panelBody);

        if (this.model.getTrigger() != null) {
            new JIRA.Triggers.DiagnosticsPanelView({
                el: $panelBody.find("#diagnostics-content").get(),
                model: self.model
            });
        }

        this._renderFailedTransitions($panelBody);
    },

    _colourButton: function () {
        this.$dialog = this.dialog.popup.element;
        this.$addTriggerButton = this.$dialog.find(".done-button");
        this.$addTriggerButton.removeClass("button-panel-button");
    }

}));
