AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

(function () {

    module("JIRA.Triggers.DiagnosticsDialogView", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.fixture = jQuery("#qunit-fixture");

            var self = this;
            this.stubDialog = {
                addHeader: self.sandbox.stub(),
                addPanel: self.sandbox.stub(),
                addButton: self.sandbox.stub(),
                getCurrentPanel: self.sandbox.stub(),
                closed: self.sandbox.stub(),
                remove: self.sandbox.stub(),
                show: self.sandbox.stub(),
                popup: {
                    element: {
                        find: self.sandbox.stub()
                    }
                }
            };
            this.stubDialog.getCurrentPanel.returns(this.fixture);
            this.stubDialog.popup.element.find.returns(this.fixture);
            this.model = {
                getTrigger: self.sandbox.stub(),
                get: self.sandbox.stub()
            };

            this.toTest = new JIRA.Triggers.DiagnosticsDialogView({model: self.model});
            this.toTest._createDialog = function () {
                return self.stubDialog;
            };
            this.toTest._closeDialog = function () {
                self.stubDialog.closed();
            };

            this.toTest._renderHeader = self.sandbox.stub();
            this.toTest._renderFailedTransitions = self.sandbox.stub();
        },
        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("tests dialog shows correctly", function () {
        this.model.get.withArgs("name").returns("Bob Trigger");
        var dialog = this.toTest.render();

        ok(this.stubDialog.show.called);
        ok(this.stubDialog.addHeader.withArgs("admin.trigger.config.viewdiagnostics.diagnosticsfor").called);
        ok(this.stubDialog.addPanel.called);
        ok(this.stubDialog.addButton.called);
        ok(this.toTest._renderHeader.called);
        ok(this.toTest._renderFailedTransitions.called);
    });

    test("tests dialog closes when button is clicked", function () {
        this.model.get.withArgs("name").returns("Bob Trigger");
        var dialog = this.toTest.render();

        var nDialog = {
            hide: this.sandbox.stub()
        };

        this.stubDialog.addButton.getCall(0).args[1](nDialog);
        ok(nDialog.hide.called);
    });

})();
