/**
 * Utility to show the JIRA Issue Collector from within any of the Dev Status plugins.
 *
 * @type JIRA.DevStatus.FeedbackDialog
 */
Backbone.define("JIRA.DevStatus.FeedbackDialog", Backbone.Model.extend({

    properties: ["collectorId", "summary"],

    defaults: {
        summary: AJS.I18n.getText("devstatus.feedback.summary.fallback"),
        collectorId: "effe8b72" // ID of the default Issue Collector configured on JAC for Fusion
    },

    /**
     * Show the feedback dialog, as provided by JAC for given `collectorId`.
     */
    show: function () {
        var collectorId = this.get('collectorId');

        // override the page properties for our issue collector only
        window.ATL_JQ_PAGE_PROPS = window.ATL_JQ_PAGE_PROPS || {};
        window.ATL_JQ_PAGE_PROPS[collectorId] = {
            fieldValues: {
                summary: this.get('summary')
            },

            triggerFunction: function (showCollectorDialog) {
                // this should only run after the script has been loaded
                _.defer(function () {
                    showCollectorDialog();
                });
            }
        };

        // load the issue collector JS
        AJS.$.getScript(this._collectorUrlFor(collectorId));
    },

    /**
     * Returns the URL for the issue collector JS file.
     *
     * @returns {string} the URL for the issue collector JS file
     * @private
     */
    _collectorUrlFor: function (collectorId) {
        // JIC should really consider providing short URLs...
        return "https://jira.atlassian.com/s/d41d8cd98f00b204e9800998ecf8427e/en_UK-7m3tmj-1988229788/6307/131/1.4.8/_/download/batch/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector/com.atlassian.jira.collector.plugin.jira-issue-collector-plugin:issuecollector.js?collectorId=" + collectorId;
    }

}));