Backbone.define("JIRA.Triggers.Analytics", Backbone.View.extend({
    events: {
        "click #triggers-learn-more-link": "fireTriggersLearnMoreLinkClicked"
    },

    /**
     * Fires an Atlassian Analytics event which is "privacy policy safe".
     * For further details please refer to <a href="https://extranet.atlassian.com/x/vkOJgw">Tagging & Whitelisting Analytics Events</a>.
     *
     * @param name  a unique name for the event
     * @param opts  an object containing any particular properties of relevance for this navigation type.
     */
    fireEvent: function (name, opts) {
        var eventName = "workflow.automatic.issue.transition." + name;
        var eventProps = (typeof opts !== "object") ? {} : opts;

        AJS.trigger('analyticsEvent', {name: eventName, data: eventProps});
    },

    fireTriggersLearnMoreLinkClicked: function () {
        this.fireEvent("triggers.learnmore.clicked", {}, true);
    }
}));

