AJS.test.require("com.atlassian.jira.plugins.jira-transition-triggers-plugin:triggers-list-common-resources");

module("JIRA.Triggers.Analytics", {
    setup: function () {
        this.sandbox = sinon.sandbox.create();
        this.sandbox.spy(AJS, "trigger");

        this.fixture = jQuery("#qunit-fixture");
        jQuery("<a id='triggers-learn-more-link' />").appendTo("#qunit-fixture");

        new JIRA.Triggers.Analytics({el: this.fixture});
    },

    teardown: function () {
        this.sandbox.restore();
    }
});

test("Learn More link in Triggers tab should raise an analytic event when clicked", function () {
    this.fixture.find("#triggers-learn-more-link").click();
    ok(AJS.trigger.calledWith('analyticsEvent', {
        name: "workflow.automatic.issue.transition.triggers.learnmore.clicked",
        data: {}
    }), "expected event was triggered");
});

