/**
 * This should only ever run on the user profile page.
 * It checks if the URL hash starts with "zone-" and takes various actions based on the result.
 * This is mainly for people who ctrl+click or middle click the links in the banner.
 */
define('jira-tzdetect/userprofile-checker', ['jira/analytics', 'jquery'], function (analytics, $) {
    var checker = {
        hash: location.hash.replace(/^#/, ''),
        zoneId: '',
        zoneParts: [],
        // Special keyword values, for analytical purposes.
        // Boolean value indicates whether to open zone prefs dialog.
        zoneKeywords: {
            set: true,
            other: true,
            ignore: false
        },

        track: function (value, attrs) {
            var data = {
                name: 'tzdetect.userprofile.' + value
            };
            if (attrs) {
                data.data = attrs;
            }
            analytics.send(data);
        },

        checkZoneId: function () {
            if (checker.hash.indexOf('zone-') !== 0) {
                return;
            }
            checker.zoneId = checker.hash.replace(/^zone-/, '');
            if (checker.zoneId in checker.zoneKeywords) {
                checker.track(checker.zoneId);
            } else {
                checker.track('prefillzone', {zoneId: checker.zoneId});
            }

            var parts = checker.zoneId.split('/');
            checker.zoneParts = parts.slice(0, 1).concat(parts.slice(1).join('/'));

            var keyword = checker.zoneKeywords[checker.zoneId];
            if (keyword === undefined || keyword === true) {
                checker.openPrefsDialog();
            }
        },

        openPrefsDialog: function () {
            var $link = $('#edit_prefs_lnk');
            if ($link.length) {
                if (!(checker.zoneId in checker.zoneKeywords)) {
                    checker.addDialogCallback();
                }
                $link.click();
            }
        },

        addDialogCallback: function () {
            $(document).on('dialogContentReady', function handleDialogReady(e, dialog) {
                if (dialog.options.trigger === '#edit_prefs_lnk') {
                    $(document).off('dialogContentReady', handleDialogReady);
                    checker.setCascadingSelectValues();
                }
            });
        },

        setCascadingSelectValues: function () {
            var $parent = $('#timeZoneRegion');
            var $child = $('#defaultUserTimeZone');
            $parent.val(checker.zoneParts[0]).trigger('change');
            $child.val(checker.zoneParts.join('/')).trigger('change');
            // Focus on the child select after all dialogContentReady callbacks have run
            // Yes, we should avoid setTimeout hacks, but it's for the Greater Good (of UX)
            setTimeout(function () {
                $child.focus();
            }, 0);
        }
    };
    return checker;
});
