AJS.test.require(["com.atlassian.jira.jira-tzdetect-plugin:tzdetect-banner-component"],function(){var C=require("jquery");var B=require("jira/ajs/ajax/smart-ajax");var A={defaultPrefs:{tzid:"Australia/Eucla",tzname:"(GMT+8:45) Eucla",janOffset:525,julyOffset:525},curPrefs:{},setPref:function(D,E){A.curPrefs[D]=E},resetPrefs:function(){A.curPrefs=C.extend({},A.defaultPrefs)},i18n:function(D){return"~~!"+D+"!~~"},generateZoneData:function(F){if(typeof F==="string"){F=[F]}var M={};var G=[];var E=[];var J,D,K,I;for(var H=0,L=F.length;H<L;H++){J=F[H];I=J.split("/");D=I[0];K=I[1];if(!M[D]){M[D]=true;G.push({key:D,displayName:A.i18n(D)})}E.push({regionKey:D,city:K,timeZoneId:J,displayName:A.i18n(D)+"/"+A.i18n(K),gmtOffset:"(GMT+00:00)"})}return{regions:G,zones:E}}};module("tzdetect-banner",{setup:function(){A.resetPrefs();this.fakeClaimData=sinon.stub();this.context=AJS.test.mockableModuleContext();this.context.mock("wrm/data",{claim:this.fakeClaimData});this.banner=this.context.require("jira-tzdetect/banner");this.prefsStub=sinon.stub(this.banner,"getPreferences").returns(A.curPrefs)},teardown:function(){C(this.banner.$tzFlag).remove();this.prefsStub.restore()}});test("banner is not re-shown if it already exists",function(){var D=this.stub(this.banner,"detectTimezoneOffsets");this.banner.init();equal(D.callCount,1,"detectTimezoneOffsets() is called in blank state");this.banner.$tzFlag=C("<div/>");this.banner.init();equal(D.callCount,1,"detectTimezoneOffsets() is not called when the banner exists")});test("banner is not shown when no tzid is found",function(){var D=this.stub(this.banner,"create");A.setPref("tzid","");this.banner.init();equal(D.callCount,0,"create() is not called")});test("banner is not shown when zone offsets match",function(){var D=this.stub(this.banner,"create");this.stub(this.banner,"getTzOffset").returns(525);this.banner.init();equal(D.callCount,0,"create() is not called")});test("banner is shown when zone offsets do not match",function(){var D=this.stub(this.banner,"create");this.stub(this.banner,"getTzOffset").returns(600);this.banner.init();equal(D.callCount,1,"create() is called")});test("banner silently does nothing if no data is provided",function(){var E={tzid:undefined,tzname:undefined,janOffset:0,julyOffset:0};var D;this.prefsStub.restore();_.each(E,function(G,F){this.fakeClaimData.withArgs("tzdetect.pref."+F).returns(G)}.bind(this));D=this.banner.getPreferences();deepEqual(D,E,"getPreferences() returns undefined for all keys");equal(this.fakeClaimData.callCount,4,"should have requested data from wrm/data")});test("update for a single matching zone",function(){var E=this.stub(this.banner,"setUserTimeZone");var D=A.generateZoneData("Australia/Darwin");this.banner.handleZoneData(D);ok(E.calledWith("Australia/Darwin"),"A single zone sets the user pref")});test("update for multiple matching zones",function(){var E=this.stub(this.banner,"setUserTimeZone");var D=A.generateZoneData(["Australia/Sydney","Australia/Melbourne","Australia/Hobart"]);this.banner.$link=C();this.banner.$dropdown=null;this.banner.handleZoneData(D);equal(E.callCount,0,"User pref is not set");ok(this.banner.$dropdown instanceof C,"Menu is created")});test("GMT offset zones are filtered out in menu",function(){var D=A.generateZoneData(["Australia/Perth","Asia/Singapore","Etc/GMT-8"]);this.banner.$link=C();this.banner.$dropdown=null;this.banner.handleZoneData(D);equal(this.banner.$dropdown.find("a[data-tzid]").length,2,"GMT offset zone is ignored")});test("GMT offset and Antarctica zones are filtered out before getting to the menu",function(){var E=this.stub(this.banner,"setUserTimeZone");var D=A.generateZoneData(["Australia/Perth","Antarctica/Casey","Etc/GMT-8"]);this.banner.$link=C();this.banner.$dropdown=null;this.banner.handleZoneData(D);ok(E.calledWith("Australia/Perth"),"Single zone after ignoring GMT offset sets user pref");equal(this.banner.$dropdown,null,"Banner is not shown")});test("banner tracks analytics when shown",function(){var D=this.stub(this.banner,"track");this.stub(this.banner,"getTzOffset").returns(600);this.banner.init();ok(D.calledWith("shown"),"Banner showing is tracked")});test("banner tracks analytics when update link is clicked",function(){var E=this.stub(this.banner,"track");this.stub(this.banner,"redirect");this.banner.$link=C();var D=A.generateZoneData([]);this.banner.handleZoneData(D);ok(E.calledWith("clicked.update",{matchingZoneCount:0}),"Update with no matching zones is tracked")});test("banner tracks analytics when zone is set",function(){var D=this.stub(this.banner,"track");this.stub(B,"makeRequest");this.banner.setUserTimeZone("Australia/Eucla","qunit");ok(D.calledWith("setzone",{zoneId:"Australia/Eucla",source:"qunit"}),"Setting a zone is tracked with the zone ID")})});