define('atlassian-nps-plugin/js/nps/survey-flags', [
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/amd-shims/templates',
    'jquery',
    'aui/flag',
    'atlassian-nps-plugin/js/nps/product'
],
/**
 * Handles the two types of survey-related flags used by NPS:
 * 1. Notification flag - asking user if they want to give feedback
 * 2. Confirmation flag - thanking user for providing feedback
 * @param AJS
 * @param Templates flag templates
 * @param $ jQuery
 * @param flag AUI flag
 * @param Product adapter for a specific product such as JIRA or Confluence
 */
function (
    AJS,
    Templates,
    $,
    flag,
    Product
) {
    "use strict";

    var SurveyFlags = {};

    SurveyFlags.showConfirmationFlag = function () {
        if (!$("#nps-header-confirmation").length) {
            var confirmationTitle = Templates.surveyConfirmationFlagTitle();
            var confirmationContent = Templates.surveyConfirmationFlagBody({
                productName: Product.getProductName()
            });

            var $confirmationFlag = $(flag({
                type: 'success',
                close: "auto",
                title: confirmationTitle,
                body: confirmationContent
            }));

            $confirmationFlag.attr('id', 'nps-header-confirmation');
        }
    };

    SurveyFlags.showNotificationFlag = function (showOptOutOption) {
        if (!$("#nps-header-notification").length) {
            var notificationTitle = Templates.surveyNotificationFlagTitle({
                productName: Product.getProductName()
            });
            var notificationContent = Templates.surveyNotificationFlagBody({
                showOptOutOption: showOptOutOption
            });

            var $surveyFlag = $(flag({
                type: 'info',
                close: "manual",
                title: notificationTitle,
                body: notificationContent
            }));

            $surveyFlag.attr('id', 'nps-header-notification');

            $("#nps-header-notification-open-survey").click(function () {
                SurveyFlags.removeSurveyFlag();
                AJS.trigger("/nps/openSurvey");
            });

            $("#nps-header-notification .icon-close").click(function() {
                AJS.trigger("/nps/cancelSurvey", "notification");
            });

            $("#nps-header-notification-dismiss-survey").click(function () {
                SurveyFlags.removeSurveyFlag();
                AJS.trigger("/nps/dismissSurvey", "dismiss");
            });
        }
    };

    SurveyFlags.removeSurveyFlag = function () {
        $("#nps-header-notification").remove();
    };

    return SurveyFlags;
});
