define('atlassian-nps-plugin/js/nps/server/acknowledgement-flag', [
    'jquery',
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/amd-shims/templates',
    'aui/flag',
    'atlassian-nps-plugin/js/nps/server/nps-status-manager',
    'atlassian-nps-plugin/js/nps/submission',
    'atlassian-nps-plugin/js/nps/product'
],
/**
 * An 'acknowledgement' flag is shown when NPS is installed on a Server instance (and after the analytics
 * privacy policy is accepted). This flag allows the system administrator to navigate to an admin page
 * to update its state (enabled/disabled) on their instance.
 * @param $ jQuery
 * @param AJS
 * @param Templates flag templates
 * @param flag AUI flag
 * @param NpsStatusManager manager for handling turning NPS on/off
 * @param Submission handles the firing of analytics events
 * @param Product adapter for a specific product such as JIRA or Confluence
 */
function(
    $,
    AJS,
    Templates,
    flag,
    NpsStatusManager,
    Submission,
    Product
) {
    'use strict';

    function setNpsAcknowledged() {
        return $.ajax({
            url: AJS.contextPath() + "/rest/nps/1.0/status/acknowledge",
            type: "PUT",
            contentType: "application/json",
            data: JSON.stringify({npsAcknowledged: "true"}),
            error: function() {
                AJS.error(AJS.I18n.getText('nps.acknowledgement.error'));
            }
        });
    }

    return {
        displayNpsAcknowledgementFlag: function() {
            Submission.showAcknowledgementFlag();

            var title = AJS.I18n.getText('nps.acknowledgement.title');
            var acknowledgementFlagContent = Templates.acknowledgementFlagBody({
                productName: Product.getProductName()
            });

            var acknowledgementFlag = flag({
                title: title,
                type: 'information',
                close: 'never',
                body: acknowledgementFlagContent
            });

            var $acknowledgementFlag = $(acknowledgementFlag).attr('id', 'acknowledge-nps-flag');
            var $enableButton = $acknowledgementFlag.find('[data-nps-enable="true"]');
            var $disableButton = $acknowledgementFlag.find('[data-nps-enable="false"]');

            $enableButton.on('click', function() {
                NpsStatusManager.updateNpsStatus(true);
                setNpsAcknowledged();
                Submission.acceptAcknowledgementFlag({enabled: true});
                acknowledgementFlag.close();
            });

            $disableButton.on('click', function() {
                NpsStatusManager.updateNpsStatus(false);
                setNpsAcknowledged();
                Submission.acceptAcknowledgementFlag({enabled: false});
                acknowledgementFlag.close();
            });

        }
    };
});
