define('atlassian-nps-plugin/js/nps/product', [
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/amd-shims/wrm'
], function(
    AJS,
    WRM
) {
    'use strict';

    var isServerMode;
    var isJsdAgent;

    function isCurrentUserJsdAgent() {
        if (isJsdAgent === undefined) {
            var jsdAgentDataProvider = WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources.is-current-user-jsd-agent-data-provider");
            isJsdAgent = (jsdAgentDataProvider === true);
        }

        return isJsdAgent;
    }

    return {
        getProductName: function () {
            if (isCurrentUserJsdAgent() === true) {
                return 'JIRA Service Desk';
            }
            else {
                return 'JIRA';
            }
        },

        setBindings: function () {
            return false;
        },

        getUserKey: function () {
            return AJS.Meta.get('remote-user');
        },

        isServerMode: function () {
            if (isServerMode === undefined) {
                var dataProvider = WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources.is-server-instance-data-provider");
                isServerMode = (dataProvider === true);
            }
            return isServerMode;
        },

        allowDisplayNotification: function () {
            var isLegacyJsdProjectPage = (window.location.pathname.toLowerCase().indexOf("/servicedesk/agent/") >= 0);
            var isJsdProjectPage = AJS.Meta.getBoolean("is-servicedesk-rendered");
            var isJsd = isLegacyJsdProjectPage || isJsdProjectPage;

            if (isCurrentUserJsdAgent() === true) {
                return isJsd;
            }
            else {
                // Don't show the JIRA survey notification on a JSD page
                return !isJsd;
            }
        },

        getSurveyTrigger: function() {
            return '#header-details-user-fullname';
        },

        allowDisplayAcknowledgementFlag: function() {
            return true;
        },

        enableABTesting: function() {
            return this.isServerMode();
        }
    };
});
