define('atlassian-nps-plugin/js/nps/product', [
    'atlassian-nps-plugin/js/amd-shims/ajs',
    'atlassian-nps-plugin/js/amd-shims/wrm'
], function(
    AJS,
    WRM
) {
    'use strict';

    var isServerMode;
    var npsOptedOut = WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources.nps-opted-out");

    return {
        getProductName: function() {
            return 'Confluence';
        },

        setBindings: function() {
            // inline require due to circular dependency problem between product/storage modules
            require(['atlassian-nps-plugin/js/nps/client-storage'], function(Storage) {
                // If user creates a comment or enters the page editor, remove the startIdle value
                AJS.bind('rte-ready', function() { Storage.remove("idleStart"); });
                // If user finishes commenting/editing, set the startIdle value to now
                AJS.bind('rte-destroyed', function() { Storage.set("idleStart", Date.now()); });
            });
        },

        getUserKey: function() {
            return AJS.Meta.get('remote-user');
        },

        isServerMode: function() {
            if (isServerMode === undefined) {
                var dataProvider = WRM.data.claim("com.atlassian.plugins.atlassian-nps-plugin:atlassian-nps-plugin-resources.is-server-instance-data-provider");
                isServerMode = (dataProvider === true);
            }
            return isServerMode;
        },

        enableABTesting: function() {
            return true;
        },

        allowDisplayNotification: function() {
            if (npsOptedOut) {
                return false;
            }

            var currentLocation = this.getLocation();

            // CONFDEV-37223: NPS shouldn't show in Administrator Access Page
            var isAuthenticatePage = /authenticate.action/.test(currentLocation.href);
            if (isAuthenticatePage) {
                return false;
            }

            if (AJS.DarkFeatures && AJS.DarkFeatures.isEnabled("nps.survey.inline.dialog")) {
                var search = currentLocation.search;
                var isComment = /(focusedCommentId|replyToComment)=(\d+)/.test(search);
                var isFilePreview = /preview=/.test(search);

                // Prevent to show survey when viewing a comment or previewing a file
                return !isComment && !isFilePreview;
            } else {
                return true;
            }
        },

        getSurveyTrigger: function() {
            return '#help-menu-link';
        },

        /**
         * This function implemented for unit testing purpose
         */
        getLocation: function() {
            return window.location;
        },

        /**
         * Indicate that Acknowledgement Flag can be displayed
         * @returns {boolean}
         */
        allowDisplayAcknowledgementFlag: function() {
            if (npsOptedOut) {
                return false;
            }

            var currentLocation = this.getLocation();
            // Don't allow to show if user is in onboarding flow
            var isInOnboardingFlow = function() {
                var isWelcomePage = /\/welcome.action/.test(currentLocation.href);

                var tutorialFlow = sessionStorage.getItem('onboarding-state:tutorialFlow');
                var inTutorialFlow = tutorialFlow && tutorialFlow !== '__complete__';

                return isWelcomePage || inTutorialFlow;
            };

            return !isInOnboardingFlow();
        }
    };
});
