/*! URI.js v1.14.1 http://medialize.github.io/URI.js/ */
(function(b,a){"object"===typeof exports?module.exports=a(require("./punycode"),require("./IPv6"),require("./SecondLevelDomains")):"function"===typeof define&&define.amd?define(["./punycode","./IPv6","./SecondLevelDomains"],a):b.URI=a(b.punycode,b.IPv6,b.SecondLevelDomains,b)})(this,function(R,o,K,S){function U(e,d){if(!(this instanceof U)){return new U(e,d)}void 0===e&&(e="undefined"!==typeof location?location.href+"":"");this.href(e);return void 0!==d?this.absoluteTo(d):this}function N(d){return d.replace(/([.*+?^=!:${}()|[\]\/\\])/g,"\\$1")}function g(d){return void 0===d?"Undefined":String(Object.prototype.toString.call(d)).slice(8,-1)}function T(d){return"Array"===g(d)}function i(l,d){var q,p;if(T(d)){q=0;for(p=d.length;q<p;q++){if(!i(l,d[q])){return !1}}return !0}var m=g(d);q=0;for(p=l.length;q<p;q++){if("RegExp"===m){if("string"===typeof l[q]&&l[q].match(d)){return !0}}else{if(l[q]===d){return !0}}}return !1}function Q(l,d){if(!T(l)||!T(d)||l.length!==d.length){return !1}l.sort();d.sort();for(var p=0,m=l.length;p<m;p++){if(l[p]!==d[p]){return !1}}return !0}function s(d){return escape(d)}function c(d){return encodeURIComponent(d).replace(/[!'()*]/g,s).replace(/\*/g,"%2A")}function k(d){return function(e,l){if(void 0===e){return this._parts[d]||""}this._parts[d]=e||null;this.build(!l);return this}}function O(e,d){return function(m,l){if(void 0===m){return this._parts[e]||""}null!==m&&(m+="",m.charAt(0)===d&&(m=m.substring(1)));this._parts[e]=m;this.build(!l);return this}}var n=S&&S.URI;U.version="1.14.1";var V=U.prototype,P=Object.prototype.hasOwnProperty;U._parts=function(){return{protocol:null,username:null,password:null,hostname:null,urn:null,port:null,path:null,query:null,fragment:null,duplicateQueryParameters:U.duplicateQueryParameters,escapeQuerySpace:U.escapeQuerySpace}};U.duplicateQueryParameters=!1;U.escapeQuerySpace=!0;U.protocol_expression=/^[a-z][a-z0-9.+-]*$/i;U.idn_expression=/[^a-z0-9\.-]/i;U.punycode_expression=/(xn--)/i;U.ip4_expression=/^\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}$/;U.ip6_expression=/^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(\.(25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(%.+)?\s*$/;U.find_uri_expression=/\b((?:[a-z][\w-]+:(?:\/{1,3}|[a-z0-9%])|www\d{0,3}[.]|[a-z0-9.\-]+[.][a-z]{2,4}\/)(?:[^\s()<>]+|\(([^\s()<>]+|(\([^\s()<>]+\)))*\))+(?:\(([^\s()<>]+|(\([^\s()<>]+\)))*\)|[^\s`!()\[\]{};:'".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))/ig;U.findUri={start:/\b(?:([a-z][a-z0-9.+-]*:\/\/)|www\.)/gi,end:/[\s\r\n]|$/,trim:/[`!()\[\]{};:'".,<>?\u00ab\u00bb\u201c\u201d\u201e\u2018\u2019]+$/};U.defaultPorts={http:"80",https:"443",ftp:"21",gopher:"70",ws:"80",wss:"443"};U.invalid_hostname_characters=/[^a-zA-Z0-9\.-]/;U.domAttributes={a:"href",blockquote:"cite",link:"href",base:"href",script:"src",form:"action",img:"src",area:"href",iframe:"src",embed:"src",source:"src",track:"src",input:"src",audio:"src",video:"src"};U.getDomAttribute=function(e){if(e&&e.nodeName){var d=e.nodeName.toLowerCase();return"input"===d&&"image"!==e.type?void 0:U.domAttributes[d]}};U.encode=c;U.decode=decodeURIComponent;U.iso8859=function(){U.encode=escape;U.decode=unescape};U.unicode=function(){U.encode=c;U.decode=decodeURIComponent};U.characters={pathname:{encode:{expression:/%(24|26|2B|2C|3B|3D|3A|40)/ig,map:{"%24":"$","%26":"&","%2B":"+","%2C":",","%3B":";","%3D":"=","%3A":":","%40":"@"}},decode:{expression:/[\/\?#]/g,map:{"/":"%2F","?":"%3F","#":"%23"}}},reserved:{encode:{expression:/%(21|23|24|26|27|28|29|2A|2B|2C|2F|3A|3B|3D|3F|40|5B|5D)/ig,map:{"%3A":":","%2F":"/","%3F":"?","%23":"#","%5B":"[","%5D":"]","%40":"@","%21":"!","%24":"$","%26":"&","%27":"'","%28":"(","%29":")","%2A":"*","%2B":"+","%2C":",","%3B":";","%3D":"="}}}};U.encodeQuery=function(e,d){var l=U.encode(e+"");void 0===d&&(d=U.escapeQuerySpace);return d?l.replace(/%20/g,"+"):l};U.decodeQuery=function(e,d){e+="";void 0===d&&(d=U.escapeQuerySpace);try{return U.decode(d?e.replace(/\+/g,"%20"):e)}catch(l){return e}};U.recodePath=function(e){e=(e+"").split("/");for(var d=0,l=e.length;d<l;d++){e[d]=U.encodePathSegment(U.decode(e[d]))}return e.join("/")};U.decodePath=function(e){e=(e+"").split("/");for(var d=0,l=e.length;d<l;d++){e[d]=U.decodePathSegment(e[d])}return e.join("/")};var M={encode:"encode",decode:"decode"},a,L=function(e,d){return function(m){try{return U[d](m+"").replace(U.characters[e][d].expression,function(p){return U.characters[e][d].map[p]})}catch(l){return m}}};for(a in M){U[a+"PathSegment"]=L("pathname",M[a])}U.encodeReserved=L("reserved","encode");U.parse=function(e,d){var l;d||(d={});l=e.indexOf("#");-1<l&&(d.fragment=e.substring(l+1)||null,e=e.substring(0,l));l=e.indexOf("?");-1<l&&(d.query=e.substring(l+1)||null,e=e.substring(0,l));"//"===e.substring(0,2)?(d.protocol=null,e=e.substring(2),e=U.parseAuthority(e,d)):(l=e.indexOf(":"),-1<l&&(d.protocol=e.substring(0,l)||null,d.protocol&&!d.protocol.match(U.protocol_expression)?d.protocol=void 0:"//"===e.substring(l+1,l+3)?(e=e.substring(l+3),e=U.parseAuthority(e,d)):(e=e.substring(l+1),d.urn=!0)));d.path=e;return d};U.parseHost=function(l,d){var p=l.indexOf("/"),m;-1===p&&(p=l.length);"["===l.charAt(0)?(m=l.indexOf("]"),d.hostname=l.substring(1,m)||null,d.port=l.substring(m+2,p)||null,"/"===d.port&&(d.port=null)):l.indexOf(":")!==l.lastIndexOf(":")?(d.hostname=l.substring(0,p)||null,d.port=null):(m=l.substring(0,p).split(":"),d.hostname=m[0]||null,d.port=m[1]||null);d.hostname&&"/"!==l.substring(p).charAt(0)&&(p++,l="/"+l);return l.substring(p)||"/"};U.parseAuthority=function(e,d){e=U.parseUserinfo(e,d);return U.parseHost(e,d)};U.parseUserinfo=function(e,d){var m=e.indexOf("/"),l=e.lastIndexOf("@",-1<m?m:e.length-1);-1<l&&(-1===m||l<m)?(m=e.substring(0,l).split(":"),d.username=m[0]?U.decode(m[0]):null,m.shift(),d.password=m[0]?U.decode(m.join(":")):null,e=e.substring(l+1)):(d.username=null,d.password=null);return e};U.parseQuery=function(l,e){if(!l){return{}}l=l.replace(/&+/g,"&").replace(/^\?*&*|&+$/g,"");if(!l){return{}}for(var u={},q=l.split("&"),p=q.length,r,m,t=0;t<p;t++){r=q[t].split("="),m=U.decodeQuery(r.shift(),e),r=r.length?U.decodeQuery(r.join("="),e):null,P.call(u,m)?("string"===typeof u[m]&&(u[m]=[u[m]]),u[m].push(r)):u[m]=r}return u};U.build=function(e){var d="";e.protocol&&(d+=e.protocol+":");e.urn||!d&&!e.hostname||(d+="//");d+=U.buildAuthority(e)||"";"string"===typeof e.path&&("/"!==e.path.charAt(0)&&"string"===typeof e.hostname&&(d+="/"),d+=e.path);"string"===typeof e.query&&e.query&&(d+="?"+e.query);"string"===typeof e.fragment&&e.fragment&&(d+="#"+e.fragment);return d};U.buildHost=function(e){var d="";if(e.hostname){d=U.ip6_expression.test(e.hostname)?d+("["+e.hostname+"]"):d+e.hostname}else{return""}e.port&&(d+=":"+e.port);return d};U.buildAuthority=function(d){return U.buildUserinfo(d)+U.buildHost(d)};U.buildUserinfo=function(e){var d="";e.username&&(d+=U.encode(e.username),e.password&&(d+=":"+U.encode(e.password)),d+="@");return d};U.buildQuery=function(l,e,u){var q="",p,r,m,t;for(r in l){if(P.call(l,r)&&r){if(T(l[r])){for(p={},m=0,t=l[r].length;m<t;m++){void 0!==l[r][m]&&void 0===p[l[r][m]+""]&&(q+="&"+U.buildQueryParameter(r,l[r][m],u),!0!==e&&(p[l[r][m]+""]=!0))}}else{void 0!==l[r]&&(q+="&"+U.buildQueryParameter(r,l[r],u))}}}return q.substring(1)};U.buildQueryParameter=function(e,d,l){return U.encodeQuery(e,l)+(null!==d?"="+U.encodeQuery(d,l):"")};U.addQuery=function(e,d,m){if("object"===typeof d){for(var l in d){P.call(d,l)&&U.addQuery(e,l,d[l])}}else{if("string"===typeof d){void 0===e[d]?e[d]=m:("string"===typeof e[d]&&(e[d]=[e[d]]),T(m)||(m=[m]),e[d]=(e[d]||[]).concat(m))}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}}};U.removeQuery=function(l,e,t){var q;if(T(e)){for(t=0,q=e.length;t<q;t++){l[e[t]]=void 0}}else{if("object"===typeof e){for(q in e){P.call(e,q)&&U.removeQuery(l,q,e[q])}}else{if("string"===typeof e){if(void 0!==t){if(l[e]===t){l[e]=void 0}else{if(T(l[e])){q=l[e];var r={},p,m;if(T(t)){for(p=0,m=t.length;p<m;p++){r[t[p]]=!0}}else{r[t]=!0}p=0;for(m=q.length;p<m;p++){void 0!==r[q[p]]&&(q.splice(p,1),m--,p--)}l[e]=q}}}else{l[e]=void 0}}else{throw new TypeError("URI.removeQuery() accepts an object, string as the first parameter")}}}};U.hasQuery=function(l,e,q,m){if("object"===typeof e){for(var p in e){if(P.call(e,p)&&!U.hasQuery(l,p,e[p])){return !1}}return !0}if("string"!==typeof e){throw new TypeError("URI.hasQuery() accepts an object, string as the name parameter")}switch(g(q)){case"Undefined":return e in l;case"Boolean":return l=Boolean(T(l[e])?l[e].length:l[e]),q===l;case"Function":return !!q(l[e],e,l);case"Array":return T(l[e])?(m?i:Q)(l[e],q):!1;case"RegExp":return T(l[e])?m?i(l[e],q):!1:Boolean(l[e]&&l[e].match(q));case"Number":q=String(q);case"String":return T(l[e])?m?i(l[e],q):!1:l[e]===q;default:throw new TypeError("URI.hasQuery() accepts undefined, boolean, string, number, RegExp, Function as the value parameter")}};U.commonPath=function(l,d){var p=Math.min(l.length,d.length),m;for(m=0;m<p;m++){if(l.charAt(m)!==d.charAt(m)){m--;break}}if(1>m){return l.charAt(0)===d.charAt(0)&&"/"===l.charAt(0)?"/":""}if("/"!==l.charAt(m)||"/"!==d.charAt(m)){m=l.substring(0,m).lastIndexOf("/")}return l.substring(0,m+1)};U.withinString=function(y,x,w){w||(w={});var u=w.start||U.findUri.start,v=w.end||U.findUri.end,t=w.trim||U.findUri.trim,r=/[a-z0-9-]=["']?$/i;for(u.lastIndex=0;;){var e=u.exec(y);if(!e){break}e=e.index;if(w.ignoreHtml){var q=y.slice(Math.max(e-3,0),e);if(q&&r.test(q)){continue}}var q=e+y.slice(e).search(v),p=y.slice(e,q).replace(t,"");w.ignore&&w.ignore.test(p)||(q=e+p.length,p=x(p,e,q,y),y=y.slice(0,e)+p+y.slice(q),u.lastIndex=e+p.length)}u.lastIndex=0;return y};U.ensureValidHostname=function(d){if(d.match(U.invalid_hostname_characters)){if(!R){throw new TypeError('Hostname "'+d+'" contains characters other than [A-Z0-9.-] and Punycode.js is not available')}if(R.toASCII(d).match(U.invalid_hostname_characters)){throw new TypeError('Hostname "'+d+'" contains characters other than [A-Z0-9.-]')}}};U.noConflict=function(d){if(d){return d={URI:this.noConflict()},S.URITemplate&&"function"===typeof S.URITemplate.noConflict&&(d.URITemplate=S.URITemplate.noConflict()),S.IPv6&&"function"===typeof S.IPv6.noConflict&&(d.IPv6=S.IPv6.noConflict()),S.SecondLevelDomains&&"function"===typeof S.SecondLevelDomains.noConflict&&(d.SecondLevelDomains=S.SecondLevelDomains.noConflict()),d}S.URI===this&&(S.URI=n);return this};V.build=function(d){if(!0===d){this._deferred_build=!0}else{if(void 0===d||this._deferred_build){this._string=U.build(this._parts),this._deferred_build=!1}}return this};V.clone=function(){return new U(this)};V.valueOf=V.toString=function(){return this.build(!1)._string};V.protocol=k("protocol");V.username=k("username");V.password=k("password");V.hostname=k("hostname");V.port=k("port");V.query=O("query","?");V.fragment=O("fragment","#");V.search=function(e,d){var l=this.query(e,d);return"string"===typeof l&&l.length?"?"+l:l};V.hash=function(e,d){var l=this.fragment(e,d);return"string"===typeof l&&l.length?"#"+l:l};V.pathname=function(e,d){if(void 0===e||!0===e){var l=this._parts.path||(this._parts.hostname?"/":"");return e?U.decodePath(l):l}this._parts.path=e?U.recodePath(e):"/";this.build(!d);return this};V.path=V.pathname;V.href=function(l,e){var q;if(void 0===l){return this.toString()}this._string="";this._parts=U._parts();var m=l instanceof U,p="object"===typeof l&&(l.hostname||l.path||l.pathname);l.nodeName&&(p=U.getDomAttribute(l),l=l[p]||"",p=!1);!m&&p&&void 0!==l.pathname&&(l=l.toString());if("string"===typeof l||l instanceof String){this._parts=U.parse(String(l),this._parts)}else{if(m||p){for(q in m=m?l._parts:l,m){P.call(this._parts,q)&&(this._parts[q]=m[q])}}else{throw new TypeError("invalid input")}}this.build(!e);return this};V.is=function(x){var w=!1,v=!1,t=!1,u=!1,r=!1,q=!1,p=!1,e=!this._parts.urn;this._parts.hostname&&(e=!1,v=U.ip4_expression.test(this._parts.hostname),t=U.ip6_expression.test(this._parts.hostname),w=v||t,r=(u=!w)&&K&&K.has(this._parts.hostname),q=u&&U.idn_expression.test(this._parts.hostname),p=u&&U.punycode_expression.test(this._parts.hostname));switch(x.toLowerCase()){case"relative":return e;case"absolute":return !e;case"domain":case"name":return u;case"sld":return r;case"ip":return w;case"ip4":case"ipv4":case"inet4":return v;case"ip6":case"ipv6":case"inet6":return t;case"idn":return q;case"url":return !this._parts.urn;case"urn":return !!this._parts.urn;case"punycode":return p}return null};var j=V.protocol,h=V.port,f=V.hostname;V.protocol=function(e,d){if(void 0!==e&&e&&(e=e.replace(/:(\/\/)?$/,""),!e.match(U.protocol_expression))){throw new TypeError('Protocol "'+e+"\" contains characters other than [A-Z0-9.+-] or doesn't start with [A-Z]")}return j.call(this,e,d)};V.scheme=V.protocol;V.port=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0!==e&&(0===e&&(e=null),e&&(e+="",":"===e.charAt(0)&&(e=e.substring(1)),e.match(/[^0-9]/)))){throw new TypeError('Port "'+e+'" contains characters other than [0-9]')}return h.call(this,e,d)};V.hostname=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0!==e){var l={};U.parseHost(e,l);e=l.hostname}return f.call(this,e,d)};V.host=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e){return this._parts.hostname?U.buildHost(this._parts):""}U.parseHost(e,this._parts);this.build(!d);return this};V.authority=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e){return this._parts.hostname?U.buildAuthority(this._parts):""}U.parseAuthority(e,this._parts);this.build(!d);return this};V.userinfo=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e){if(!this._parts.username){return""}var l=U.buildUserinfo(this._parts);return l.substring(0,l.length-1)}"@"!==e[e.length-1]&&(e+="@");U.parseUserinfo(e,this._parts);this.build(!d);return this};V.resource=function(e,d){var l;if(void 0===e){return this.path()+this.search()+this.hash()}l=U.parse(e);this._parts.path=l.path;this._parts.query=l.query;this._parts.fragment=l.fragment;this.build(!d);return this};V.subdomain=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e){if(!this._parts.hostname||this.is("IP")){return""}var l=this._parts.hostname.length-this.domain().length-1;return this._parts.hostname.substring(0,l)||""}l=this._parts.hostname.length-this.domain().length;l=this._parts.hostname.substring(0,l);l=new RegExp("^"+N(l));e&&"."!==e.charAt(e.length-1)&&(e+=".");e&&U.ensureValidHostname(e);this._parts.hostname=this._parts.hostname.replace(l,e);this.build(!d);return this};V.domain=function(e,d){if(this._parts.urn){return void 0===e?"":this}"boolean"===typeof e&&(d=e,e=void 0);if(void 0===e){if(!this._parts.hostname||this.is("IP")){return""}var l=this._parts.hostname.match(/\./g);if(l&&2>l.length){return this._parts.hostname}l=this._parts.hostname.length-this.tld(d).length-1;l=this._parts.hostname.lastIndexOf(".",l-1)+1;return this._parts.hostname.substring(l)||""}if(!e){throw new TypeError("cannot set domain empty")}U.ensureValidHostname(e);!this._parts.hostname||this.is("IP")?this._parts.hostname=e:(l=new RegExp(N(this.domain())+"$"),this._parts.hostname=this._parts.hostname.replace(l,e));this.build(!d);return this};V.tld=function(e,d){if(this._parts.urn){return void 0===e?"":this}"boolean"===typeof e&&(d=e,e=void 0);if(void 0===e){if(!this._parts.hostname||this.is("IP")){return""}var l=this._parts.hostname.lastIndexOf("."),l=this._parts.hostname.substring(l+1);return !0!==d&&K&&K.list[l.toLowerCase()]?K.get(this._parts.hostname)||l:l}if(e){if(e.match(/[^a-zA-Z0-9-]/)){if(K&&K.is(e)){l=new RegExp(N(this.tld())+"$"),this._parts.hostname=this._parts.hostname.replace(l,e)}else{throw new TypeError('TLD "'+e+'" contains characters other than [A-Z0-9]')}}else{if(!this._parts.hostname||this.is("IP")){throw new ReferenceError("cannot set TLD on non-domain host")}l=new RegExp(N(this.tld())+"$");this._parts.hostname=this._parts.hostname.replace(l,e)}}else{throw new TypeError("cannot set TLD empty")}this.build(!d);return this};V.directory=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e||!0===e){if(!this._parts.path&&!this._parts.hostname){return""}if("/"===this._parts.path){return"/"}var l=this._parts.path.length-this.filename().length-1,l=this._parts.path.substring(0,l)||(this._parts.hostname?"/":"");return e?U.decodePath(l):l}l=this._parts.path.length-this.filename().length;l=this._parts.path.substring(0,l);l=new RegExp("^"+N(l));this.is("relative")||(e||(e="/"),"/"!==e.charAt(0)&&(e="/"+e));e&&"/"!==e.charAt(e.length-1)&&(e+="/");e=U.recodePath(e);this._parts.path=this._parts.path.replace(l,e);this.build(!d);return this};V.filename=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e||!0===e){if(!this._parts.path||"/"===this._parts.path){return""}var m=this._parts.path.lastIndexOf("/"),m=this._parts.path.substring(m+1);return e?U.decodePathSegment(m):m}m=!1;"/"===e.charAt(0)&&(e=e.substring(1));e.match(/\.?\//)&&(m=!0);var l=new RegExp(N(this.filename())+"$");e=U.recodePath(e);this._parts.path=this._parts.path.replace(l,e);m?this.normalizePath(d):this.build(!d);return this};V.suffix=function(e,d){if(this._parts.urn){return void 0===e?"":this}if(void 0===e||!0===e){if(!this._parts.path||"/"===this._parts.path){return""}var m=this.filename(),l=m.lastIndexOf(".");if(-1===l){return""}m=m.substring(l+1);m=/^[a-z0-9%]+$/i.test(m)?m:"";return e?U.decodePathSegment(m):m}"."===e.charAt(0)&&(e=e.substring(1));if(m=this.suffix()){l=e?new RegExp(N(m)+"$"):new RegExp(N("."+m)+"$")}else{if(!e){return this}this._parts.path+="."+U.recodePath(e)}l&&(e=U.recodePath(e),this._parts.path=this._parts.path.replace(l,e));this.build(!d);return this};V.segment=function(m,l,u){var r=this._parts.urn?":":"/",t=this.path(),q="/"===t.substring(0,1),t=t.split(r);void 0!==m&&"number"!==typeof m&&(u=l,l=m,m=void 0);if(void 0!==m&&"number"!==typeof m){throw Error('Bad segment "'+m+'", must be 0-based integer')}q&&t.shift();0>m&&(m=Math.max(t.length+m,0));if(void 0===l){return void 0===m?t:t[m]}if(null===m||void 0===t[m]){if(T(l)){t=[];m=0;for(var p=l.length;m<p;m++){if(l[m].length||t.length&&t[t.length-1].length){t.length&&!t[t.length-1].length&&t.pop(),t.push(l[m])}}}else{if(l||"string"===typeof l){""===t[t.length-1]?t[t.length-1]=l:t.push(l)}}}else{l?t[m]=l:t.splice(m,1)}q&&t.unshift("");return this.path(t.join(r),u)};V.segmentCoded=function(l,e,q){var p,m;"number"!==typeof l&&(q=e,e=l,l=void 0);if(void 0===e){l=this.segment(l,e,q);if(T(l)){for(p=0,m=l.length;p<m;p++){l[p]=U.decode(l[p])}}else{l=void 0!==l?U.decode(l):void 0}return l}if(T(e)){for(p=0,m=e.length;p<m;p++){e[p]=U.decode(e[p])}}else{e="string"===typeof e||e instanceof String?U.encode(e):e}return this.segment(l,e,q)};var b=V.query;V.query=function(l,e){if(!0===l){return U.parseQuery(this._parts.query,this._parts.escapeQuerySpace)}if("function"===typeof l){var p=U.parseQuery(this._parts.query,this._parts.escapeQuerySpace),m=l.call(this,p);this._parts.query=U.buildQuery(m||p,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);this.build(!e);return this}return void 0!==l&&"string"!==typeof l?(this._parts.query=U.buildQuery(l,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace),this.build(!e),this):b.call(this,l,e)};V.setQuery=function(l,e,q){var p=U.parseQuery(this._parts.query,this._parts.escapeQuerySpace);if("string"===typeof l||l instanceof String){p[l]=void 0!==e?e:null}else{if("object"===typeof l){for(var m in l){P.call(l,m)&&(p[m]=l[m])}}else{throw new TypeError("URI.addQuery() accepts an object, string as the name parameter")}}this._parts.query=U.buildQuery(p,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);"string"!==typeof l&&(q=e);this.build(!q);return this};V.addQuery=function(l,e,p){var m=U.parseQuery(this._parts.query,this._parts.escapeQuerySpace);U.addQuery(m,l,void 0===e?null:e);this._parts.query=U.buildQuery(m,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);"string"!==typeof l&&(p=e);this.build(!p);return this};V.removeQuery=function(l,e,p){var m=U.parseQuery(this._parts.query,this._parts.escapeQuerySpace);U.removeQuery(m,l,e);this._parts.query=U.buildQuery(m,this._parts.duplicateQueryParameters,this._parts.escapeQuerySpace);"string"!==typeof l&&(p=e);this.build(!p);return this};V.hasQuery=function(l,e,p){var m=U.parseQuery(this._parts.query,this._parts.escapeQuerySpace);return U.hasQuery(m,l,e,p)};V.setSearch=V.setQuery;V.addSearch=V.addQuery;V.removeSearch=V.removeQuery;V.hasSearch=V.hasQuery;V.normalize=function(){return this._parts.urn?this.normalizeProtocol(!1).normalizeQuery(!1).normalizeFragment(!1).build():this.normalizeProtocol(!1).normalizeHostname(!1).normalizePort(!1).normalizePath(!1).normalizeQuery(!1).normalizeFragment(!1).build()};V.normalizeProtocol=function(d){"string"===typeof this._parts.protocol&&(this._parts.protocol=this._parts.protocol.toLowerCase(),this.build(!d));return this};V.normalizeHostname=function(d){this._parts.hostname&&(this.is("IDN")&&R?this._parts.hostname=R.toASCII(this._parts.hostname):this.is("IPv6")&&o&&(this._parts.hostname=o.best(this._parts.hostname)),this._parts.hostname=this._parts.hostname.toLowerCase(),this.build(!d));return this};V.normalizePort=function(d){"string"===typeof this._parts.protocol&&this._parts.port===U.defaultPorts[this._parts.protocol]&&(this._parts.port=null,this.build(!d));return this};V.normalizePath=function(l){if(this._parts.urn||!this._parts.path||"/"===this._parts.path){return this}var e,r=this._parts.path,q="",m,p;"/"!==r.charAt(0)&&(e=!0,r="/"+r);r=r.replace(/(\/(\.\/)+)|(\/\.$)/g,"/").replace(/\/{2,}/g,"/");e&&(q=r.substring(1).match(/^(\.\.\/)+/)||"")&&(q=q[0]);for(;;){m=r.indexOf("/..");if(-1===m){break}else{if(0===m){r=r.substring(3);continue}}p=r.substring(0,m).lastIndexOf("/");-1===p&&(p=m);r=r.substring(0,p)+r.substring(m+3)}e&&this.is("relative")&&(r=q+r.substring(1));r=U.recodePath(r);this._parts.path=r;this.build(!l);return this};V.normalizePathname=V.normalizePath;V.normalizeQuery=function(d){"string"===typeof this._parts.query&&(this._parts.query.length?this.query(U.parseQuery(this._parts.query,this._parts.escapeQuerySpace)):this._parts.query=null,this.build(!d));return this};V.normalizeFragment=function(d){this._parts.fragment||(this._parts.fragment=null,this.build(!d));return this};V.normalizeSearch=V.normalizeQuery;V.normalizeHash=V.normalizeFragment;V.iso8859=function(){var e=U.encode,d=U.decode;U.encode=escape;U.decode=decodeURIComponent;this.normalize();U.encode=e;U.decode=d;return this};V.unicode=function(){var e=U.encode,d=U.decode;U.encode=c;U.decode=unescape;this.normalize();U.encode=e;U.decode=d;return this};V.readable=function(){var l=this.clone();l.username("").password("").normalize();var e="";l._parts.protocol&&(e+=l._parts.protocol+"://");l._parts.hostname&&(l.is("punycode")&&R?(e+=R.toUnicode(l._parts.hostname),l._parts.port&&(e+=":"+l._parts.port)):e+=l.host());l._parts.hostname&&l._parts.path&&"/"!==l._parts.path.charAt(0)&&(e+="/");e+=l.path(!0);if(l._parts.query){for(var t="",r=0,p=l._parts.query.split("&"),q=p.length;r<q;r++){var m=(p[r]||"").split("="),t=t+("&"+U.decodeQuery(m[0],this._parts.escapeQuerySpace).replace(/&/g,"%26"));void 0!==m[1]&&(t+="="+U.decodeQuery(m[1],this._parts.escapeQuerySpace).replace(/&/g,"%26"))}e+="?"+t.substring(1)}return e+=U.decodeQuery(l.hash(),!0)};V.absoluteTo=function(l){var e=this.clone(),q=["protocol","username","password","hostname","port"],p,m;if(this._parts.urn){throw Error("URNs do not have any generally defined hierarchical components")}l instanceof U||(l=new U(l));e._parts.protocol||(e._parts.protocol=l._parts.protocol);if(this._parts.hostname){return e}for(p=0;m=q[p];p++){e._parts[m]=l._parts[m]}e._parts.path?".."===e._parts.path.substring(-2)&&(e._parts.path+="/"):(e._parts.path=l._parts.path,e._parts.query||(e._parts.query=l._parts.query));"/"!==e.path().charAt(0)&&(l=l.directory(),e._parts.path=(l?l+"/":"")+e._parts.path,e.normalizePath());e.build();return e};V.relativeTo=function(l){var e=this.clone().normalize(),r,q,m,p;if(e._parts.urn){throw Error("URNs do not have any generally defined hierarchical components")}l=(new U(l)).normalize();r=e._parts;q=l._parts;m=e.path();p=l.path();if("/"!==m.charAt(0)){throw Error("URI is already relative")}if("/"!==p.charAt(0)){throw Error("Cannot calculate a URI relative to another relative URI")}r.protocol===q.protocol&&(r.protocol=null);if(r.username===q.username&&r.password===q.password&&null===r.protocol&&null===r.username&&null===r.password&&r.hostname===q.hostname&&r.port===q.port){r.hostname=null,r.port=null}else{return e.build()}if(m===p){return r.path="",e.build()}l=U.commonPath(e.path(),l.path());if(!l){return e.build()}q=q.path.substring(l.length).replace(/[^\/]*$/,"").replace(/.*?\//g,"../");r.path=q+r.path.substring(l.length);return e.build()};V.equals=function(l){var e=this.clone();l=new U(l);var r={},q={},m={},p;e.normalize();l.normalize();if(e.toString()===l.toString()){return !0}r=e.query();q=l.query();e.query("");l.query("");if(e.toString()!==l.toString()||r.length!==q.length){return !1}r=U.parseQuery(r,this._parts.escapeQuerySpace);q=U.parseQuery(q,this._parts.escapeQuerySpace);for(p in r){if(P.call(r,p)){if(!T(r[p])){if(r[p]!==q[p]){return !1}}else{if(!Q(r[p],q[p])){return !1}}m[p]=!0}}for(p in q){if(P.call(q,p)&&!m[p]){return !1}}return !0};V.duplicateQueryParameters=function(d){this._parts.duplicateQueryParameters=!!d;return this};V.escapeQuerySpace=function(d){this._parts.escapeQuerySpace=!!d;return this};return U});