AJS.namespace("JIRA.Dashboard.Views");

JIRA.Dashboard.Views.DirectoryLoadingView = Backbone.View.extend({
    template: JIRA.Dashboard.Templates.gadgetDirectoryLoadingPage,

    initialize: function() {
        this.$content = AJS.$(this.template({
            loadingText: AJS.I18n.getText("gadgets.directory.loading.text")
        }));
    },

    render: function() {
        this.$el.html(this.$content);
        var spinnerOpts = AJS.$.fn.spin && AJS.$.fn.spin.presets ? AJS.$.fn.spin.presets.medium : {};
        var spinner = new Spinner(spinnerOpts).spin();
        this.$el.find(".loading-spinner").html(spinner.el);
    },

    detach: function() {
        this.$content.detach();
    }
});