AJS.test.require(["jira.webresources:legacy-namespacing","com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries","com.atlassian.gadgets.dashboard:dashboard-test"],function(){module("Directory items view test",{setup:function(){this.modelGetItemsForCategoryStub=sinon.stub(JIRA.Dashboard.Entities.DirectoryViewModel.prototype,"getItemsForCategory");this.modelGetItemsForCategoryStub.returns([{attributes:{thumbnailUri:"thumb1",specUri:"spec1",titleLabel:"title1",authorLabel:"author1",description:"some description",id:"spec1",specUriDisplay:"spec1"}},{attributes:{thumbnailUri:"thumb2",specUri:"spec2",titleLabel:"title2",authorLabel:"author2",description:"some description",id:"spec2",specUriDisplay:"spec2"}},{attributes:{thumbnailUri:"thumb3",specUri:"spec3",titleLabel:"title3",authorLabel:"author3",description:"some description",id:"spec3",specUriDisplay:"spec3"}},{attributes:{thumbnailUri:"thumb4",completeModuleKey:"com.atlassian.gadgets:modulekey1",titleLabel:"title4",authorLabel:"author4",description:"some description",id:"com.atlassian.gadgets:modulekey1"}},{attributes:{thumbnailUri:"thumb5",completeModuleKey:"com.atlassian.gadgets:modulekey2",titleLabel:"title5",authorLabel:"author5",description:"some description",id:"com.atlassian.gadgets:modulekey2"}}]);this.modelGetVisibleItemsForCategoryStub=sinon.stub(JIRA.Dashboard.Entities.DirectoryViewModel.prototype,"getVisibleItemsForCategory");this.modelGetVisibleItemsForCategoryStub.returns([new JIRA.Dashboard.Entities.DirectoryItem({id:"spec2",type:"gadget"}),new JIRA.Dashboard.Entities.DirectoryItem({id:"spec3"}),new JIRA.Dashboard.Entities.DirectoryItem({id:"com.atlassian.gadgets:modulekey1"})]);this.$rootDiv=AJS.$("#qunit-fixture");this.view=new JIRA.Dashboard.Views.DirectoryItems({model:new JIRA.Dashboard.Entities.DirectoryViewModel({},{directoryItems:_.extend({},Backbone.Events)}),el:this.$rootDiv})},teardown:function(){this.modelGetItemsForCategoryStub.restore();this.modelGetVisibleItemsForCategoryStub.restore()}});test("Should render items for selected category",function(){this.view.render();var items=this.$rootDiv.find("button[data-purpose='add-dashboard-item']");equal(items.length,5);equal(AJS.$(items[0]).attr("data-item-id"),"spec1");equal(AJS.$(items[1]).attr("data-item-id"),"spec2");equal(AJS.$(items[2]).attr("data-item-id"),"spec3");equal(AJS.$(items[3]).attr("data-item-id"),"com.atlassian.gadgets:modulekey1");equal(AJS.$(items[4]).attr("data-item-id"),"com.atlassian.gadgets:modulekey2")});test("Should throw dashboardItemAdd event when one of the add buttons is clicked",function(){var spy=sinon.spy();this.view.on("dashboardItemAdd",spy);this.view.render();AJS.$(this.$rootDiv.find("button[data-item-id='spec2']")).trigger(AJS.$.Event("click"));ok(spy.calledOnce);ok(spy.calledWith({id:"spec2",type:"gadget"}))});test("Should enable all add buttons when method is invoked",function(){this.view.render();this.view.disableAddButtons();this.view.enableAddButtons();var addButtons=this.$rootDiv.find("button[data-purpose='add-dashboard-item']");equal(addButtons.length,5);equal(AJS.$(addButtons[0]).attr("aria-disabled"),undefined);equal(AJS.$(addButtons[1]).attr("aria-disabled"),undefined);equal(AJS.$(addButtons[2]).attr("aria-disabled"),undefined);equal(AJS.$(addButtons[3]).attr("aria-disabled"),undefined);equal(AJS.$(addButtons[4]).attr("aria-disabled"),undefined)});test("Should disable all add buttons when method is invoked",function(){this.view.render();this.view.disableAddButtons();var addButtons=this.$rootDiv.find("button[data-purpose='add-dashboard-item']");equal(addButtons.length,5);equal(AJS.$(addButtons[0]).attr("aria-disabled"),"true");equal(AJS.$(addButtons[1]).attr("aria-disabled"),"true");equal(AJS.$(addButtons[2]).attr("aria-disabled"),"true");equal(AJS.$(addButtons[3]).attr("aria-disabled"),"true");equal(AJS.$(addButtons[4]).attr("aria-disabled"),"true")});test("Should hide items that are not visible",function(){this.view.render();var items=this.$rootDiv.children();equal(items.length,6);var $item0=AJS.$(items[0]);equal($item0.attr("data-item-id"),"spec1");ok(!$item0.is(":visible"));var $item1=AJS.$(items[1]);equal($item1.attr("data-item-id"),"spec2");ok($item1.is(":visible"));var $item2=AJS.$(items[2]);equal($item2.attr("data-item-id"),"spec3");ok($item2.is(":visible"));var $item3=AJS.$(items[3]);equal($item3.attr("data-item-id"),"com.atlassian.gadgets:modulekey1");ok($item3.is(":visible"));var $item4=AJS.$(items[4]);equal($item4.attr("data-item-id"),"com.atlassian.gadgets:modulekey2");ok(!$item4.is(":visible"));var $item5=AJS.$(items[5]);equal($item5.attr("data-item-id"),"no-result");ok(!$item5.is(":visible"))});test("Should show no result page when no items are visible due to search filtering",function(){this.modelGetVisibleItemsForCategoryStub.returns([]);this.view.render();var items=this.$rootDiv.children();equal(items.length,6);var $item0=AJS.$(items[0]);equal($item0.attr("data-item-id"),"spec1");ok(!$item0.is(":visible"));var $item1=AJS.$(items[1]);equal($item1.attr("data-item-id"),"spec2");ok(!$item1.is(":visible"));var $item2=AJS.$(items[2]);equal($item2.attr("data-item-id"),"spec3");ok(!$item2.is(":visible"));var $item3=AJS.$(items[3]);equal($item3.attr("data-item-id"),"com.atlassian.gadgets:modulekey1");ok(!$item3.is(":visible"));var $item4=AJS.$(items[4]);equal($item4.attr("data-item-id"),"com.atlassian.gadgets:modulekey2");ok(!$item4.is(":visible"));var $item5=AJS.$(items[5]);equal($item5.attr("data-item-id"),"no-result");ok($item5.is(":visible"))});test("Should render specUri only for dashboard items based on open social specification",function(){this.view.render();var items=this.$rootDiv.find(".aui-group textarea");equal(items.length,3);var $item0=AJS.$(items[0]);equal("spec1",$item0.val());var $item1=AJS.$(items[1]);equal("spec2",$item1.val());var $item2=AJS.$(items[2]);equal("spec3",$item2.val())})});