AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("Directory controller test", {
        setup: function() {
            this.directoryNavRenderStub = sinon.stub(JIRA.Dashboard.Views.DirectoryNav.prototype, "render");
            this.directoryItemsRenderStub = sinon.stub(JIRA.Dashboard.Views.DirectoryItems.prototype, "render");
            this.directoryItemsFilterStub = sinon.stub(JIRA.Dashboard.Views.DirectoryItems.prototype, "applySearchTextFiltering");
            this.directoryMessageRenderStub = sinon.stub(JIRA.Dashboard.Views.DirectoryMessageView.prototype, "render");
            this.directoryResetStub = sinon.stub(JIRA.Dashboard.Views.Directory.prototype, "resetUserInput");
            this.constantsStub = sinon.stub(JIRA.Dashboard.Directory.Constants, "getDefaultCategoryName").returns("All");

            this.model = _.extend({
                retryFailedEndpoints: function() {}
            }, Backbone.Events);
            this.controller = new JIRA.Dashboard.Controllers.DirectoryController(this.model);
        },

        teardown: function() {
            this.directoryNavRenderStub.restore();
            this.directoryItemsRenderStub.restore();
            this.directoryItemsFilterStub.restore();
            this.directoryMessageRenderStub.restore();
            this.directoryResetStub.restore();
            this.constantsStub.restore();
        }
    });

    test("Should render left and right panels when view state throws dataUpdate event", function(){
        this.controller.viewState.trigger("dataUpdate");

        ok(this.directoryNavRenderStub.calledOnce);
        ok(this.directoryNavRenderStub.calledOn(this.controller.directoryNav));
        ok(this.directoryItemsRenderStub.calledOnce);
        ok(this.directoryItemsRenderStub.calledOn(this.controller.directoryItemsView));

    });

    test("Should render message view when view state throws messageUpdate event", function(){
        this.controller.viewState.trigger("messageUpdate");

        ok(this.directoryMessageRenderStub.calledOnce);
        ok(this.directoryMessageRenderStub.calledOn(this.controller.messageView));
    });

    test("Should propagate dashboard item add event with the correct url", function(){
        var callback = sinon.spy();
        this.controller.on("dashboardItemAdd", callback);

        this.controller.directoryItemsView.trigger("dashboardItemAdd", "some-url");

        ok(callback.calledOnce);
        equal(callback.firstCall.args.length, 1);
        equal(callback.firstCall.args[0], "some-url");
    });

    test("Should render left and right panel and update model when triggered with category select event", function(){
        var modelSetCategoryStub = sinon.stub(this.controller.viewState, "setSelectedCategory");

        this.controller.directoryNav.trigger("categorySelect", "some-category");

        ok(this.directoryNavRenderStub.calledOnce);
        ok(this.directoryItemsRenderStub.calledOnce);
        ok(modelSetCategoryStub.calledOnce);
        deepEqual(modelSetCategoryStub.firstCall.args, ["some-category"]);

        modelSetCategoryStub.restore();
    });

    test("Should render left and right panel and update model when triggered with search text update event", function(){
        var modelSetTextStub = sinon.stub(this.controller.viewState, "setSearchText");

        this.controller.directory.trigger("searchTextUpdate", "some-text");

        ok(this.directoryNavRenderStub.calledOnce);
        ok(this.directoryItemsFilterStub.calledOnce);
        ok(modelSetTextStub.calledOnce);
        deepEqual(modelSetTextStub.firstCall.args, ["some-text"]);

        modelSetTextStub.restore();
    });

    test("Should ignore event when triggered with search text update event and search text has not changed", function(){
        this.controller.viewState.set("searchText", "some-text");
        var modelSetTextStub = sinon.stub(this.controller.viewState, "setSearchText");

        this.controller.directory.trigger("searchTextUpdate", "some-text");

        ok(!this.directoryNavRenderStub.called);
        ok(!this.directoryItemsRenderStub.called);
        ok(!modelSetTextStub.called);

        modelSetTextStub.restore();
    });

    test("Should disable directory add buttons", function(){
        var directoryItemsDisableButtonsStub = sinon.stub(this.controller.directoryItemsView, "disableAddButtons");

        this.controller.disableDirectoryAddButtons();

        ok(directoryItemsDisableButtonsStub.calledOnce);
        deepEqual(directoryItemsDisableButtonsStub.firstCall.args, []);

        directoryItemsDisableButtonsStub.restore();
    });

    test("Should enable directory add buttons", function(){
        var directoryItemsEnableButtonsStub = sinon.stub(this.controller.directoryItemsView, "enableAddButtons");

        this.controller.enableDirectoryAddButtons();

        ok(directoryItemsEnableButtonsStub.calledOnce);
        deepEqual(directoryItemsEnableButtonsStub.firstCall.args, []);

        directoryItemsEnableButtonsStub.restore();
    });

    test("Should delegate render to directory view", function(){
        var spy = sinon.spy(this.controller.directory, "render");

        this.controller.render();

        ok(spy.calledOnce);
        spy.restore();
    });

    test("Should delegate detach to directory view", function(){
        var spy = sinon.spy(this.controller.directory, "detach");

        this.controller.detach();

        ok(spy.calledOnce);
        spy.restore();
    });

    test("Should invoke set directory visible on view state model when directory is rendered", function(){
        var spy = sinon.spy(this.controller.viewState, "setDirectoryVisible");

        this.controller.render();

        ok(spy.calledOnce);
        spy.restore();
    });

    test("Should invoke set directory not visible on view state model when directory is detached", function(){
        var spy = sinon.spy(this.controller.viewState, "setDirectoryNotVisible");

        this.controller.detach();

        ok(spy.calledOnce);
        spy.restore();
    });

    test("Should invoke loadUnrenderedData on view state model when message view throws additionalItemsLoadRequest", function(){
        var stub = sinon.stub(this.controller.viewState, "loadUnrenderedData");

        this.controller.messageView.trigger("additionalItemsLoadRequest");

        ok(stub.calledOnce);
        stub.restore();
    });

    test("Should invoke retryFailedEnpoints on directory items when message view throws retrieveRetryRequest", function(){
        var stub = sinon.stub(this.model, "retryFailedEndpoints");

        this.controller.messageView.trigger("retrieveRetryRequest");

        ok(stub.calledOnce);

        stub.restore();
    });

    test("Should reset category and serch text and re-render both left and right panels when reset user input is invoked", function(){
        this.controller.viewState.setSelectedCategory("JIRA");
        this.controller.viewState.setSearchText("duck");

        this.controller.resetUserInput();

        equal(this.controller.viewState.getSelectedCategory(), "All");
        equal(this.controller.viewState.getSearchText(), "");
        ok(this.directoryNavRenderStub.calledOnce);
        ok(this.directoryItemsRenderStub.calledOnce);
        ok(this.directoryResetStub.calledOnce);
    });
});