AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module('AG.InlineGadgetAPI', {
        setup: function () {
            this.$form = AJS.$(
                '<form>' +
                    '<input type="checkbox" name="my-refresh" value="15">' +
                '</form>'
            );
            var gadget = {
                '$' : this.$form
            };

            this.api = new AG.InlineGadgetAPI(gadget);
        }
    });

    test('should rename properties before sending to server', function () {
        var preferences = {one: 'one', two: 'two'};
        var expectedPreferences = {up_one: 'one', up_two: 'two', up_isConfigured: true};

        deepEqual( expectedPreferences, this.api._preparePreferencesToBeSaved(preferences) );
    });
    test('should work on an empty properties map', function () {
        var preferences = {};
        var expectedPreferences = {up_isConfigured: true};

        deepEqual( expectedPreferences, this.api._preparePreferencesToBeSaved(preferences) );
    });
    test('should handle null object', function () {
        var preferences = null;
        var expectedPreferences = {up_isConfigured: true};

        deepEqual( expectedPreferences, this.api._preparePreferencesToBeSaved(preferences) );
    });
    test('should convert Number to String', function () {
        var preferences = {a: 42, b: 3.14};
        var expectedPreferences = {up_a: '42', up_b: '3.14', up_isConfigured: true};

        deepEqual( expectedPreferences, this.api._preparePreferencesToBeSaved(preferences) );
    });
    test('should convert Boolean to String', function () {
        var preferences = {a: false, b: true};
        var expectedPreferences = {up_a: 'false', up_b: 'true', up_isConfigured: true};

        deepEqual( expectedPreferences, this.api._preparePreferencesToBeSaved(preferences) );
    });

    test('should return default value when checkbox is not checked', function() {
        strictEqual( 'false', this.api.getRefreshFieldValue('my-refresh') );
    });
    test('should find checkbox state using default name - unchecked', function() {
        this.$form.find('input').attr('name', 'refresh');
        strictEqual( 'false', this.api.getRefreshFieldValue() );
    });
    test('should return specified value when checkbox is checked', function() {
        this.$form.find('input').attr('checked', true);
        strictEqual( '15', this.api.getRefreshFieldValue('my-refresh') );
    });
    test('should find checkbox state using default name - checked', function() {
        this.$form.find('input').attr('name', 'refresh');
        this.$form.find('input').attr('checked', true);
        strictEqual( '15', this.api.getRefreshFieldValue() );
    });
    test('should return correct value after multiple state changes', function() {
        strictEqual( 'false', this.api.getRefreshFieldValue('my-refresh') );

        this.$form.find('input').attr('checked', true);
        strictEqual( '15', this.api.getRefreshFieldValue('my-refresh') );

        this.$form.find('input').attr('checked', false);
        strictEqual( 'false', this.api.getRefreshFieldValue('my-refresh') );
    });
});