AJS.test.require([
    'jira.webresources:legacy-namespacing',
    'com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries',
    'com.atlassian.gadgets.dashboard:dashboard-prod'
], function(){
    var skate = require('dashboard/shims/skate');

    module('Dashboard analytics events tests', {
        setup: function() {
            this.setupStub = sinon.stub(AG.DashboardManager, 'setup');
            this.triggerStub = sinon.stub(AJS, 'trigger');

            this.fixture = document.getElementById('qunit-fixture');
        },

        initializeDashboardComponent: function() {
            this.fixture.innerHTML =
                '<dashboard params="{}" layouts="{}" id="dashboard-element">' +
                '   <a class="dashboard-tab-link" id="tab-link-1">Tab 1</a>' +
                '   <a class="dashboard-tab-link" id="tab-link-2">Tab 2</a>' +
                '   <dashboard-done />' +
                '</dashboard>';

            skate.init(document.getElementById('dashboard-element'));

            this.tabLink1 = document.getElementById('tab-link-1');
            this.tabLink2 = document.getElementById('tab-link-2');
        },

        teardown: function() {
            this.setupStub.restore();
            this.triggerStub.restore();
        }
    });

    test('Should trigger an event when a tab link is clicked', function() {
        this.initializeDashboardComponent();

        this.tabLink1.click();
        this.tabLink2.click();

        equal(this.setupStub.callCount, 1, 'AG.DashboardManager.setup() called once');
        equal(this.triggerStub.callCount, 2, 'AJS.trigger() called twice');

        var executionTest = this.triggerStub.alwaysCalledWithExactly('analyticsEvent', {
            name: 'gadgets.dashboard.tab.link.click'
        });

        ok(executionTest, 'Always triggered the expected event');
    });
});