AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("AG.DashboardManager", {
        setup: function () {
            this.sandbox = sinon.sandbox.create()
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    function makejQueryReadySynchronous(sandbox) {
        var original = AJS.$;
        sandbox.stub(AJS, "$", function (readyCallback) {
            if (typeof readyCallback !== "function") {
                return original.apply(AJS, arguments);
            }
            readyCallback();
        });
    }

    function disablejQueryAjax(sandbox) {
        sandbox.stub(AJS.$, "ajax");
    }

    function mockGadgets() {
        return {
            IfrGadgetService: {
                prototype: {}
            }
        };
    }

    asyncTest("AG.Dashboard.setup triggers an 'initialized' event on the dashboard DOM element.", function () {
        AJS.$("#qunit-fixture").append("<div id='dashboard'></div>");
        makejQueryReadySynchronous(this.sandbox);
        disablejQueryAjax(this.sandbox);
        this.sandbox.stub(AG, "window", {
            document: window.document,
            Event: window.Event,
            gadgets: mockGadgets()
        });

        document.querySelector("#dashboard").addEventListener("initialized", function () {
            expect(0);
            start();
        });

        AG.DashboardManager.setup({layouts: [], menu: {}});
    });

});