AJS.test.require([
    "jira.webresources:legacy-namespacing",
    "com.atlassian.gadgets.dashboard.refimpl.ui:required-libraries",
    "com.atlassian.gadgets.dashboard:dashboard-test"
], function(){
    module("AG.DOMEvent");

    var chance = new Chance(0);

    function mockDocument() {
        return {
            createEvent: function () {}
        };
    }

    function mockWindow() {
        return {
            Event: function () {},
            document: mockDocument()
        };
    }

    test("AG.DOMEvent uses document.createEvent when window.Event is not a function.", sinon.test(function () {
        var eventName = chance.word();
        var event = {
            initEvent: function (name, bubbles, cancelable) {
                equal(name, eventName);
                equal(bubbles, true);
                equal(cancelable, false);
            }
        };
        this.stub(AG, "window", mockWindow());
        AG.window.Event = {}; // Event just looks like a plain object in Internet Explorer 9
        this.stub(AG.window.document, "createEvent").withArgs("HTMLEvents").returns(event);

        strictEqual(event, AG.DOMEvent(eventName));

        ok(AG.window.document.createEvent.calledOnce);
        expect(5);
    }));

    test("AG.DOMEvent uses window.Event when it's a function", sinon.test(function () {
        var eventName = chance.word();

        this.stub(AG, "window", mockWindow());
        this.spy(AG.window.document, "createEvent");
        AG.window.Event = this.spy();

        AG.DOMEvent(eventName);

        ok(!AG.window.document.createEvent.called);
        ok(AG.window.Event.calledOnce);
        deepEqual(AG.window.Event.firstCall.args, [eventName]);
    }));
});