AJS.namespace("JIRA.Dashboard.Modules");

JIRA.Dashboard.Modules.Directory = function(triggersSelector) {
    this.controller = new JIRA.Dashboard.Controllers.DirectoryLoader(triggersSelector);
    this.controller.on("dashboardItemAdd", this.onDashboardItemAdd, this);
};

JIRA.Dashboard.Modules.Directory.prototype = {
    onDashboardItemAdd: function(directoryItem){
        this.controller.disableDirectoryAddButtons();

        var self = this;
        JIRA.Dashboard.DashboardService.addItem(directoryItem,{
            onSuccess: function() {
                self.controller.enableDirectoryAddButtons();
            },
            onError: function(errorMsg) {
                if(errorMsg) {
                    alert(errorMsg);
                }
                self.controller.enableDirectoryAddButtons();
            }
        })
    }
};
