AJS.test.require("com.atlassian.jira.jira-onboarding-assets-plugin:create-project-component",function(){"use strict";function e(e,t){return{name:e,key:t}}function t(e){var t={};return o.each(e.requestBody.split("&"),function(e){var r=e.split("=");t[r[0]]=r[1]}),t}function r(e,t){var r=this.$el.find("input[name="+e+"]");r.focus(),r.val(t),this.clock.tick(100)}function s(e,t){this.setInputFieldValue("key",t),this.setInputFieldValue("name",e)}var i=require("jquery"),n=require("jira/onboarding/create-project-sequence-view"),o=require("underscore"),a=[e("Test Project","TEST"),e("Another","ANO")];module("CreateProjectSequenceView construction",{setup:function(){this.$el=i("<div/>").appendTo("#qunit-fixture"),this.server=sinon.fakeServer.create()},teardown:function(){this.server.restore()}}),test("focuses the first input field upon creating the view",function(){var e=document.activeElement,t=new n({el:this.$el,leadName:"admin"});ok(document.activeElement===e),t.render(),ok(document.activeElement!==e,"active element should have changed upon rendering the view"),ok(document.activeElement===t.$("input:first")[0],"should be the first input element in the view")}),module("CreateProjectSequenceView tests",{setup:function(){this.server=sinon.fakeServer.create(),this.clock=sinon.useFakeTimers(),this.$el=i("<div/>").appendTo("#qunit-fixture"),this.server.respondWith([200,{"Content-Type":"application/json"},JSON.stringify(a)]),this.createProjectSequenceView=new n({el:this.$el,leadName:"admin",projectTemplateKey:"com.atlassian.jira-core-project-templates:jira-issuetracking"}),this.createProjectSequenceView.render(),this.clock.tick(100),this.createProject=o.bind(s,this),this.setInputFieldValue=o.bind(r,this)},teardown:function(){this.createProjectSequenceView.remove(),this.clock.restore(),this.server.restore()}}),test("Test getPostParams works as expected",function(){var e=t({requestBody:"arg1=val1&arg2=val2"});deepEqual(e,{arg1:"val1",arg2:"val2"})}),test("Test submit button is disabled at the beginning",function(){ok(i("input[type=submit]",this.$el).attr("disabled"),"Should be disabled"),equal(i("input[type=submit]",this.$el).attr("aria-disabled"),"true","Should be aria disabled")}),test("Test requested project names for fields",function(){equal(this.server.requests.length,1,"Should have one current request")}),test("Test setting project name as current project has error",function(){this.server.respond(),ok(!this.$el.find(".error").is(":visible"),"Should be no error messages"),this.setInputFieldValue("name",a[0].name);var e=this.$el.find(".error");ok(e.is(":visible"),"Should have an error message"),equal(i(e.get(0)).text(),"admin.errors.project.with.that.name.already.exists","Should be an error message for project name already existing")}),test("Test a key has been assigned when changing name",function(){this.server.respond(),this.setInputFieldValue("name","Stash");var e=this.$el.find("[name=key]").val();ok(e.length>0,"Key should have been assigned")}),test("Already used key should show an error",function(){this.server.respond(),this.setInputFieldValue("key","Stash");var e={errors:{projectKey:"errorMessage"}};this.server.requests.pop().respond(200,{"Content-Type":"application/json"},JSON.stringify(e));var t=this.$el.find(".error");ok(t.is(":visible"),"Should have an error message")}),test("Valid key does not show error",function(){this.server.respond(),this.setInputFieldValue("key","Stash"),this.server.requests.pop().respond(200,{"Content-Type":"application/json"},JSON.stringify("{}"));var e=this.$el.find(".error");ok(!e.is(":visible"),"Should have no error message")}),test("Valid name and key should enable the submit button",function(){this.server.respond(),this.createProject("Stash","STA"),ok(!i("input[type=submit]",this.$el).attr("disabled"),"Should not be disabled"),equal(i("input[type=submit]",this.$el).attr("aria-disabled"),"false","Should not be aria disabled")}),test("Project creation fields should be assigned correctly",function(){this.server.respond(),this.createProject("Stash","STA");this.server.requests.length;i("input[type=submit]",this.$el).click();var e={name:"Stash",key:"STA",lead:"admin",projectTemplateWebItemKey:encodeURIComponent("com.atlassian.jira-core-project-templates:jira-issuetracking")},r=t(this.server.requests.pop());deepEqual(r,e)}),test("Failed project creation 400 shows error messages",function(){this.server.respond(),this.createProject("Stash","STA"),i("input[type=submit]",this.$el).click();var e={errors:{projectKey:"Some error"}};this.server.requests.pop().respond(400,{"Content-Type":"application/json"},JSON.stringify(e)),equal(this.$el.find(".form-errors .title").length,1,"Error should be visible")}),test("Failed project creation other shows server error message",function(){this.server.respond(),this.createProject("Stash","STA"),i("input[type=submit]",this.$el).click();var e={errors:{projectKey:"Some error"}};this.server.requests.pop().respond(500,{"Content-Type":"application/json"},JSON.stringify(e)),equal(this.$el.find(".form-errors .title").length,1,"Error should be visible")}),test("Unauthorised shows a link to login with the correct redirect url",function(){this.server.respond(),this.createProject("Stash","STA"),i("input[type=submit]",this.$el).click(),this.server.requests.pop().respond(401,{"Content-Type":"application/json"},JSON.stringify("{}")),equal(this.$el.find(".form-errors .title").length,1,"Error should be visible")}),test("Project successful creation triggers event with redirect url",function(){var e={redirectUrl:"/test"};this.doneHandler=sinon.spy(),this.createProjectSequenceView.bind("done",this.doneHandler),this.server.respond(),this.createProject("Stash","STA"),this.clock.tick(100),i("input[type=submit]",this.$el).click(),this.server.requests.pop().respond(200,{"Content-Type":"application/json"},JSON.stringify(e)),ok(this.doneHandler.calledOnce,"Should have returned redirect url on finish"),ok(this.doneHandler.withArgs(e).calledOnce,"Called with redirect args")}),test("Skipping project creation creates event",function(){this.skipHandler=sinon.spy(),this.createProjectSequenceView.bind("skip",this.skipHandler),this.$el.find("#skip").click(),this.clock.tick(100),ok(this.skipHandler.calledOnce,"Should have called skip event handler")})});