AJS.test.require("com.atlassian.jira.jira-onboarding-assets-plugin:create-project-component",function(){"use strict";var e=require("jquery");module("CreateProjectSequence tests",{setup:function(){var t={render:sinon.spy(),once:function(e,t){this._events[e]=t},trigger:function(e,t){this._events[e](t)},_events:{}};this.createProjectSequenceView=t,this.CreateProjectSequenceView=function(){return t},this.context=AJS.test.mockableModuleContext(),this.context.mock("jira/onboarding/create-project-sequence-view",this.CreateProjectSequenceView),this.analyticsSpy=sinon.spy(),this.analytics={pushEvent:this.analyticsSpy},this.server=sinon.fakeServer.create(),this.$el=e("<div/>"),e("#qunit-fixture").append(this.$el),this.clock=sinon.useFakeTimers()},teardown:function(){this.clock.restore(),this.server.restore()}}),test("Rendered if has permission to create a project",sinon.test(function(){new(this.context.require("jira/onboarding/create-project-sequence"))({username:"admin",canCompleteCreateProjectSequence:!0,projectTemplateKey:"template-key"}).init(this.$el,this.analytics),ok(this.createProjectSequenceView.render.calledOnce)})),test("Test redirects to intro to agile if cannot create project",sinon.test(function(){var e=this.context.require("jira/onboarding/create-project-sequence"),t=new e({username:"admin",canCompleteCreateProjectSequence:!1,projectTemplateKey:"template-key"}),n=t.init(this.$el,this.analytics);this.clock.tick(100),ok(n.isRejected()),equal(n.reason(),e.EVENTS.NO_PERMISSION,"Reason for rejection should be the user does not have permission"),ok(this.analyticsSpy.calledOnce,"Analytics push event should have been called"),ok(this.analyticsSpy.withArgs(e.EVENTS.NO_PERMISSION).calledOnce,"Analytics push event with NO_PERMISSION arg")})),test("Test redirects to intro to agile if cannot find project template",sinon.test(function(){var e=this.context.require("jira/onboarding/create-project-sequence"),t=new e({username:"admin",canCompleteCreateProjectSequence:!0,projectTemplateKey:""}),n=t.init(this.$el,this.analytics);this.clock.tick(100),ok(n.isRejected()),equal(n.reason(),e.EVENTS.NO_TEMPLATE,"Reason for rejection should be that no suitable JIRA Project Template could be found"),ok(this.analyticsSpy.calledOnce,"Analytics push event should have been called"),ok(this.analyticsSpy.withArgs(e.EVENTS.NO_TEMPLATE).calledOnce,"Analytics push event with NO_TEMPLATE arg")})),test("Test redirects to intro to agile if no username on page",sinon.test(function(){var e=this.context.require("jira/onboarding/create-project-sequence"),t=new e({username:"admin",canCompleteCreateProjectSequence:!1,projectTemplateKey:"template-key"}),n=t.init(this.$el,this.analytics);this.clock.tick(100),ok(n.isRejected()),equal(n.reason(),e.EVENTS.NO_PERMISSION,"Reason for rejection should be the user does not have permission"),ok(this.analyticsSpy.calledOnce,"Analytics push event should have been called"),ok(this.analyticsSpy.withArgs(e.EVENTS.NO_PERMISSION).calledOnce,"Analytics push event with NO_PERMISSION arg")})),test("Test finishing the view redirects to the specified url",sinon.test(function(){var e=this.context.require("jira/onboarding/create-project-sequence"),t=new e({username:"admin",canCompleteCreateProjectSequence:!0,projectTemplateKey:"template-key"}),n=t.init(this.$el,this.analytics),i={returnUrl:"/test"};this.createProjectSequenceView.trigger("done",{returnUrl:"/test"}),this.clock.tick(100),ok(n.isFulfilled()),deepEqual(n.value(),i,"Value being fulfilled should be the return url"),ok(this.analyticsSpy.calledOnce,"Analytics push event should have been called"),ok(this.analyticsSpy.withArgs(e.EVENTS.CREATED).calledOnce,"Analytics push event with CREATED arg")})),test("Test skipping the project creation redirects to intro to agile",sinon.test(function(){var e=this.context.require("jira/onboarding/create-project-sequence"),t=new e({username:"admin",canCompleteCreateProjectSequence:!0,projectTemplateKey:"template-key"}),n=t.init(this.$el,this.analytics);this.createProjectSequenceView.trigger("skip"),ok(n.isRejected()),equal(n.reason(),e.EVENTS.SKIPPED,"Reason for rejection should be the user skipped"),ok(this.analyticsSpy.calledOnce,"Analytics push event should have been called"),ok(this.analyticsSpy.withArgs(e.EVENTS.SKIPPED).calledOnce,"Analytics push event with SKIPPED arg")}))});