var _typeof="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e};AJS.test.require("com.atlassian.jira.jira-onboarding-assets-plugin:choose-language-component",function(){"use strict";function e(e){var t={},a={};return i.times(e,function(e){var s=e+1,n="en_"+s;t[n]="English #"+s,a[n]={title:"Welcome to JIRA "+s+"!",paragraph:"Something something "+s+" something..."}}),{languages:t,translations:a}}function t(e){return n={setItem:e.stub(),getItem:e.stub(),removeItem:e.stub(),clear:e.stub()}}function a(e){return s={reloadViaWindowLocation:e.spy()}}var s,n,o=require("jquery"),i=require("underscore"),l=require("backbone"),r=require("jira/onboarding/choose-language-sequence-model");module("ChooseLanguageSequence",{setup:function(){this.sandbox=sinon.sandbox.create(),this.clock=this.sandbox.useFakeTimers(),this.server=this.sandbox.useFakeServer(),this.sandbox.stub(r.prototype,"url").returns("/rest/api/fake/mypreferences"),this.sandbox.stub(r.prototype,"toJSON");var e=this.fakeModel=new r,s=this.FakeModelClass=sinon.stub().returns(e),n=l.View.extend({render:this.sandbox.stub()}),i=this.fakeView=new n,h=this.FakeViewClass=sinon.stub().returns(i);this.context=AJS.test.mockableModuleContext(),this.context.mock("jira/onboarding/choose-language-sequence-model",s),this.context.mock("jira/onboarding/choose-language-sequence-view",h),this.context.mock("jira/data/local-storage",t(this.sandbox)),this.context.mock("jira/util/browser",a(this.sandbox)),this.analytics={pushEvent:this.sandbox.spy()},this.$el=o("<div></div>")},teardown:function(){this.sandbox.restore()}}),test("Can be constructed",1,function(){var e=this.context.require("jira/onboarding/choose-language-sequence");try{new e,ok(!0,"Expected no errors to be thrown when no options provided")}catch(e){equal(e.message,!1,"Expected no errors raised, but got one.")}}),test("#init rejects immediately if there are no languages",function(){var e=this.context.require("jira/onboarding/choose-language-sequence"),t=new e({languages:{}}),a=t.init(this.$el,this.analytics);this.clock.tick(100),equal(a.isRejected(),!0,"No languages"),equal(a.reason(),e.EVENTS.NO_LANGUAGES,"Reason should be that there were no languages to choose from."),ok(this.analytics.pushEvent.calledWith(e.EVENTS.NO_LANGUAGES),"should have fired NO_LANGUAGES event")}),test("#init initialises the view with the provided element",function(){new(this.context.require("jira/onboarding/choose-language-sequence"))(e(3)).init(this.$el,this.analytics),this.clock.tick(100),ok(this.FakeViewClass.calledOnce,"should construct the view");var t=this.FakeViewClass.getCall(0).args[0];ok("object"===(void 0===t?"undefined":_typeof(t)),"should be an object"),ok(t.el===this.$el,"our element was passed in to the view"),ok(this.fakeView.render.calledOnce,"should render the view immediately")}),test("#init initialises the model with the provided languages",function(){var t=e(3);new(this.context.require("jira/onboarding/choose-language-sequence"))(t).init(this.$el,this.analytics),this.clock.tick(100),ok(this.FakeModelClass.calledOnce,"should construct the model");var a=this.FakeModelClass.getCall(0).args;equal(_typeof(a[0]),"object","should have an attributes object"),equal(a[0].selected,"-1","should be -1 by default"),equal(_typeof(a[1]),"object","should have an options objects"),equal(a[1].languages.en_1.name,t.languages.en_1,"should have been passed our language name"),equal(a[1].languages.en_1.i18n,t.translations.en_1,"should have been passed translations for the langauge")}),test("starts with a chosen langauge of -1 (for system default",function(){var t=e(3);new(this.context.require("jira/onboarding/choose-language-sequence"))(t).init(this.$el,this.analytics),ok(this.FakeModelClass.calledWith({selected:"-1"}),"starts with system default language")}),test("rejects if view fires a 'skip' event",function(){var t=this.context.require("jira/onboarding/choose-language-sequence"),a=new t(e(3)),s=a.init(this.$el,this.analytics);this.clock.tick(100),equal(s.isPending(),!0,"nothing has happened yet"),this.fakeView.trigger("skip"),this.clock.tick(100),equal(s.isPending(),!1,"should be finished"),equal(s.isFulfilled(),!1,"should have finished with a skip"),equal(s.isRejected(),!0,"should have finished with a skip"),ok(this.analytics.pushEvent.calledWith(t.EVENTS.SKIPPED),"should have fired skip event")}),test("causes model to save when view fires a 'done' event",function(){var t=this.context.require("jira/onboarding/choose-language-sequence"),a=new t(e(3)),s=a.init(this.$el,this.analytics);this.clock.tick(100),equal(s.isPending(),!0,"nothing has happened yet"),this.sandbox.spy(this.fakeModel,"save"),this.fakeView.trigger("done"),this.clock.tick(100),equal(s.isPending(),!0,"should not be finished yet"),equal(this.fakeModel.save.callCount,1,"should have triggered a save on our model"),equal(this.server.requests.length,1,"should have made a REST call")}),test("sets localstorage value and reloads browser when language preference is changed successfully",function(){var t=this.context.require("jira/onboarding/choose-language-sequence"),a=new t(e(3)),o=a.init(this.$el,this.analytics);this.fakeModel.set("selected","en_3"),this.fakeView.trigger("done"),this.server.respondWith("PUT",this.fakeModel.url(),[204,{"Content-Type":"application/json"},""]),this.server.respond(),ok(o.isPending(),"should not finish the promise"),ok(s.reloadViaWindowLocation.calledOnce,"should call for a reload of the window"),ok(s.reloadViaWindowLocation.calledWith(window.location.href),"reloads current window location"),ok(n.setItem.calledWith("jira.onboarding.choose.language.success","en_3"),"should set the chosen language for pickup later")}),test("sets localstorage value and redirects to login if user session times out before saving language preference",function(){var t=this.context.require("jira/onboarding/choose-language-sequence"),a=new t(e(3)),o=a.init(this.$el,this.analytics);this.fakeModel.set("selected","en_2"),this.fakeView.trigger("done"),this.server.respondWith("PUT",this.fakeModel.url(),[401,{"Content-Type":"application/json"},'{ "message": "You need to be logged in", "status-code": 401 }']),this.server.respond();var i=s.reloadViaWindowLocation.getCall(0);ok(o.isPending(),"should not finish the promise"),ok(i,"should call for a reload of the window"),ok(i.args[0].indexOf("login.jsp")>-1,"redirects to login"),ok(i.args[0].indexOf(encodeURIComponent(window.location.href))>-1,"should return here once login is done"),ok(n.setItem.calledWith("jira.onboarding.choose.language.data","en_2"),"should set the chosen language for pickup later"),ok(this.analytics.pushEvent.calledWith(t.EVENTS.NOT_AUTHORIZED),"should fire an auth fail analytics event")}),test("remembers user's language choice (but doesn't automatically choose it) in the event their session timed out",function(){var t=e(3);t.currentLocale="en_2",n.getItem.withArgs("jira.onboarding.choose.language.data").returns("en_3"),new(this.context.require("jira/onboarding/choose-language-sequence"))(t).init(this.$el,this.analytics),ok(this.FakeModelClass.calledWith({selected:"en_3"}),"should prefer the localStorage value over currentLocale value"),ok(n.removeItem.calledWith("jira.onboarding.choose.language.data"),"should clean up after itself")}),test("rejects flow if setting the user preference yields server error",function(){var t=this.context.require("jira/onboarding/choose-language-sequence"),a=new t(e(3)),s=a.init(this.$el,this.analytics);this.fakeModel.set("selected","en_2"),this.fakeView.trigger("done"),this.server.respondWith("PUT",this.fakeModel.url(),[500,{"Content-Type":"application/json"},'{ "message": "Something weird happened", "status-code": 505 }']),this.server.respond(),equal(s.isPending(),!1,"should finish the promise"),equal(s.isRejected(),!0,"should rejeect the promise"),equal(s.reason(),t.EVENTS.ERROR_ON_SAVE,"should have a reason for rejection"),equal(this.analytics.pushEvent.calledWith(t.EVENTS.ERROR_ON_SAVE,sinon.match.object),!0,"should fire an analytics event with the error"),deepEqual(this.analytics.pushEvent.args[0][1],{error:{message:"Something weird happened",statusCode:500},language:"en_2"},"should fire an analytics event with the error")}),test("resolves flow immediately when (successful) language choice found in localStorage",function(){var t=e(3);n.getItem.withArgs("jira.onboarding.choose.language.success").returns("en_3");var a=this.context.require("jira/onboarding/choose-language-sequence"),s=new a(t),o=s.init(this.$el,this.analytics);this.clock.tick(100),equal(o.isPending(),!1,"we should be finished"),equal(o.isFulfilled(),!0,"should have succeeded"),equal(n.removeItem.calledWith("jira.onboarding.choose.language.success"),!0,"should clean up after itself"),equal(this.analytics.pushEvent.calledWith(a.EVENTS.DONE,sinon.match.has("language","en_3")),!0,"should have fired analytics to denote the language chosen by the user")}),test("resolves flow without page reload when language choice is the same as currently selected language",function(){var t=e(3);t.currentLocale="en_42";var a=this.context.require("jira/onboarding/choose-language-sequence"),o=new a(t),i=o.init(this.$el,this.analytics);this.fakeModel.set("selected","en_42"),this.fakeView.trigger("done"),this.clock.tick(100),equal(i.isPending(),!1,"promise should not be pending"),equal(i.isFulfilled(),!0,"promise should be done"),equal(this.analytics.pushEvent.calledWith(a.EVENTS.DONE,sinon.match.has("language","en_42")),!0,"should have fired analytics to denote the language chosen by the user"),equal(this.server.requests.length,0,"server should not have been involved"),equal(s.reloadViaWindowLocation.notCalled,!0,"should not call for a reload of the window"),equal(n.setItem.notCalled,!0,"should not persist the language to localStorage"),equal(n.removeItem.notCalled,!0,"should not need to clear the language from localStorage")}),test("analytics for system default language",function(){var t=e(3);t.languages[-1]="System default language",t.currentLocale="-1",t.defaultLocale="en_FOO",this.fakeModel.set("selected","-1");var a=this.context.require("jira/onboarding/choose-language-sequence");new a(t).init(this.$el,this.analytics),this.fakeView.trigger("done");var s=this.analytics.pushEvent.getCall(0);equal(this.analytics.pushEvent.calledWith(a.EVENTS.DONE,sinon.match.object),!0,"should have expanded system default language locale in analytics"),equal(s.args[1].language,"en_FOO","should have expanded system default language locale in analytics"),equal(s.args[1].choseDefault,!0,"should note the language chosen was the default choice"),equal(s.args[1].oldLanguage,"-1","should note the previous language value")}),test("destroys the model if language selection is changed to -1 ",function(){var t=e(3);this.sandbox.spy(this.fakeModel,"destroy"),t.languages[-1]="System default language",t.currentLocale="en_UK",t.defaultLocale="en_FOO",this.fakeModel.set("selected","-1"),new(this.context.require("jira/onboarding/choose-language-sequence"))(t).init(this.$el,this.analytics),this.fakeView.trigger("done"),equal(this.fakeModel.destroy.called,!0,"should call destroy method when locale is changed to system default"),equal(this.server.requests.length,1,"should have made a REST call"),equal(this.server.requests[0].method,"DELETE","method should be DELETE")})});